{*<!--
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
-->*}

{strip}
<div class="modal-dialog modal-lg">
    <div class="modal-content">
            <div class="modal-header">
                <div class="clearfix">
                    <div class="pull-right " >
                        <button type="button" class="close" aria-label="Close" data-dismiss="modal">
                            <span aria-hidden="true" class='fa fa-close'></span>
                        </button>
                    </div>
                    <h4 class="pull-left">
                        {vtranslate('CRMTiger Mobile Apps - Module Icons','CTMobileSettings')}
                    </h4>
                </div>
            </div>
        <div class="modal-body">
            <div id="popupPageContainer" class="contentsDiv col-sm-12">
            
                <div id="popupContents" class="">
                    <input type="hidden" id="supportedImageFormats" value='["png"]'/>
                    <form class="form-horizontal" id="SaveModuleIcons" method="post" action="index.php" enctype="multipart/form-data">
                    <input type="hidden" name="module" value="CTMobileSettings" />
                    <input type="hidden" name="parent" value="Settings" />
                    <input type="hidden" name="action" value="SaveModuleIcons" />
                      <table class="table table-borderless">
                            <tr>
                               <td class="fieldLabel alignMiddle">
                                  {vtranslate('Module','CTMobileSettings')}
                               </td>    
                               <td class="fieldValue">
                                  <select class="selec2 inputElement" name="IconModule">
                                  <option value="">{vtranslate('LBL_SELECT_MODULE','CTMobileSettings')}</option>
                                  {foreach item=modulemodel from=$ALL_MODULES}
                                  <option value="{$modulemodel->get('name')}" {if $MODULE_NAME eq $modulemodel->get('name')} selected {/if}>{vtranslate($modulemodel->get('name'),$modulemodel->get('name'))}</option>
                                  {/foreach}
                                  </select>
                               </td>
                            </tr>
                            <tr>
                                <td class="fieldLabel alignMiddle">
                                    {vtranslate('Module Icon','CTMobileSettings')}
                                </td>
                                <td class="fieldValue">
                                  <input type="file" name="moduleIcon" id="moduleIcon">
                                  <br/>
                                  <div class="alert alert-info">{vtranslate('Allowed size 79X79 pixels (.png format ).','CTMobileSettings')}</div>
                                </td>
                            </tr>
                            <tr>
                                <td class="fieldLabel alignMiddle">
                                </td>
                                <td class="fieldValue">
                                  <button type="submit" class="btn btn-success saveButton">Save</button>
                                  <a class="cancelLink" type="reset" onclick="javascript:window.close();">{vtranslate('Cancel','CTMobileSettings')}</a>
                                </td>
                            </tr>
                      </table>
                    </form> 
                </div>
               
            </div>
        </div>
    </div>
</div>
{/strip}

{literal}
<script type="text/javascript">
    var allowedDimensions = {
        'width' : 79,
        'height' : 79
    };
    var popupPageContainer = jQuery('#popupPageContainer');
    //var updateCompanyDetailsForm = jQuery('#SaveModuleIcons');
    var moduleIcon = popupPageContainer.find('#moduleIcon');
    popupPageContainer.on('change','#moduleIcon',function(e) {
        //http://stackoverflow.com/a/13572209
        var _URL = window.URL || window.webkitURL;
        var image, file = this.files[0];
        var validImageTypes = ['image/png'];
        if(!validImageTypes.includes(file['type'])){
            var eparams = {
                  title : app.vtranslate('Error'),
                  text: app.vtranslate('LBL_WRONG_IMAGE_TYPE'),
                  animation: 'show',
                  type: 'error'
              };
            Vtiger_Helper_Js.showPnotify(eparams);
            moduleIcon.val(null);
        }else if(file && typeof Image === 'function') {
            image = new Image();
            image.onload = function() {
                var width = this.width;
                var height = this.height;
                if(width > allowedDimensions.width || height > allowedDimensions.height ) {
                    var eparams = {
                          title : app.vtranslate('Error'),
                          text: app.vtranslate('JS_LOGO_IMAGE_DIMENSIONS_WRONG'),
                          animation: 'show',
                          type: 'error'
                      };
                    Vtiger_Helper_Js.showPnotify(eparams);
                    moduleIcon.val(null); //this will empty file input
                }
            };
            image.src = _URL.createObjectURL(file);
        }
    });

    var form = popupPageContainer.find('#SaveModuleIcons');
    form.submit(function( event ) {
        var IconModule = jQuery('[name="IconModule"]').val();
        var imageObj = jQuery('#moduleIcon');
        var imageName = imageObj.val();
        if(IconModule == ''){
          var eparams = {
                title : app.vtranslate('Error'),
                text: app.vtranslate('Please select module'),
                animation: 'show',
                type: 'error'
            };
          Vtiger_Helper_Js.showPnotify(eparams);
          event.preventDefault();
        }

        if(imageName == '') {
          var eparams = {
                title : app.vtranslate('Error'),
                text: app.vtranslate('Please select module icon'),
                animation: 'show',
                type: 'error'
            };
          Vtiger_Helper_Js.showPnotify(eparams);
          event.preventDefault();
        }
        
    });
</script>
{/literal}