 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_AttendanceSummary_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_AttendanceSummary_Js.editInstance == false){
            var instance = new CTMobileSettings_AttendanceSummary_Js();
            CTMobileSettings_AttendanceSummary_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_AttendanceSummary_Js.editInstance;
    }
},{ 
    registerUsersFilterChangeEvent:function() {

       var date = new Date();
       var month = date.getMonth()+1;
       var day = date.getDate();
       var year = date.getFullYear();
       var newdate = year + '/' + month + '/' + day;
        if(day > 7){
           day = day -7;
           if(day < 10 ){
               day = '0' + day;
           }
           if(month < 10 ){
               month = '0' + month;
           }
           var lastDate = year + '/' + month + '/' + day;
       }else{
           var month31 = [1,3,5,7,8,10,12];
           if(month > 1){
                day = 7 - day;
                month = month - 1;
                if(jQuery.inArray(month, month31) !== -1){
                    day = 31 - day;
                }else{
                    day = 30 - day;
                }
                year = year - 1;
                if(day < 10 ){
                   day = '0' + day;
                }
                if(month < 10 ){
                   month = '0' + month;
                }
                var lastDate = year + '/' + month + '/' + day;
           }else{
                day = day -7;
                month = month - 1;
                if(jQuery.inArray(month, month31) !== -1){
                    day = 31 - day;
                }else{
                    day = 30 - day;
                }
                if(day < 10 ){
                   day = '0' + day;
                }
                if(month < 10 ){
                   month = '0' + month;
                }
                var lastDate = year + '/' + month + '/' + day;
           }
       }
       var Today = newdate;
       var tempdate = date;
       tempdate.setDate(tempdate.getDate() - 1);
       var Yesterday = tempdate.getFullYear()+'/'+(tempdate.getMonth()+1)+'/'+tempdate.getDate();

       var tempdate1 = date;
       tempdate1.setDate(tempdate1.getDate() - 6);
       var last7days = tempdate1.getFullYear()+'/'+(tempdate1.getMonth()+1)+'/'+tempdate1.getDate();

       var tempdate2 = date;
       tempdate2.setDate(tempdate2.getDate() - 29);
       var last30days = tempdate2.getFullYear()+'/'+(tempdate2.getMonth()+1)+'/'+tempdate2.getDate();

       var date = new Date();
       var firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
       var lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
       var firstday = firstDay.getFullYear()+'/'+(firstDay.getMonth()+1)+'/'+firstDay.getDate();
       var lastday = lastDay.getFullYear()+'/'+(lastDay.getMonth()+1)+'/'+lastDay.getDate();

       var date = new Date();
       var firstDay = new Date(date.getFullYear(), date.getMonth()-1, 1);
       var lastDay = new Date(date.getFullYear(), date.getMonth(), 0);
       var monthStartDay = firstDay.getFullYear()+'/'+(firstDay.getMonth()+1)+'/'+firstDay.getDate();
       var monthEndDay = lastDay.getFullYear()+'/'+(lastDay.getMonth()+1)+'/'+lastDay.getDate();

       var date = new Date();
       var firstDay = new Date(date.getFullYear(), 0, 1);
       var lastDay = new Date(date.getFullYear(), 12, 0);
       var yearStartDay = firstDay.getFullYear()+'/'+(firstDay.getMonth()+1)+'/'+firstDay.getDate();
       var yearEndDay = lastDay.getFullYear()+'/'+(lastDay.getMonth()+1)+'/'+lastDay.getDate();

       var date = new Date();
       var firstDay = new Date(date.getFullYear()-1, 0, 1);
       var lastDay = new Date(date.getFullYear()-1, 12, 0);
       var lastyearStartDay = firstDay.getFullYear()+'/'+(firstDay.getMonth()+1)+'/'+firstDay.getDate();
       var lastyearEndDay = lastDay.getFullYear()+'/'+(lastDay.getMonth()+1)+'/'+lastDay.getDate();

       var dateValue = firstday + ' - ' + lastday;
       jQuery('input[name="daterange"]').val(dateValue);

       var today_label = app.vtranslate('Today');
       var yesterday_label = app.vtranslate('Yesterday');
       var last_7_days_label = app.vtranslate('Last 7 Days');
       var last_30_days_label = app.vtranslate('Last 30 Days');
       var this_month_label = app.vtranslate('This Month');
       var this_year_label = app.vtranslate('This Year');
       var last_year_label = app.vtranslate('Last Year');

       var myranges = {};
       myranges[today_label] = [Today,Today];
       myranges[yesterday_label] = [Yesterday, Yesterday];
       myranges[last_7_days_label] = [last7days, Today];
       myranges[last_30_days_label] = [last30days, Today];
       myranges[this_month_label] = [firstday, lastday];
       myranges[this_year_label] = [yearStartDay, yearEndDay];
       myranges[last_year_label] = [lastyearStartDay, lastyearEndDay];

       jQuery('input[name="daterange"]').daterangepicker({    locale: {
          format: 'YYYY/MM/DD',
          separator: " - ",
          applyLabel: app.vtranslate("Apply"),
          cancelLabel: app.vtranslate("Cancel"),
          fromLabel: app.vtranslate("From"),
          toLabel: app.vtranslate("To"),
          customRangeLabel: app.vtranslate("Custom Range"),
          daysOfWeek: [
              app.vtranslate("Su"),
              app.vtranslate("Mo"),
              app.vtranslate("Tu"),
              app.vtranslate("We"),
              app.vtranslate("Th"),
              app.vtranslate("Fr"),
              app.vtranslate("Sa")
          ],
          monthNames: [
              app.vtranslate("January"),
              app.vtranslate("February"),
              app.vtranslate("March"),
              app.vtranslate("April"),
              app.vtranslate("May"),
              app.vtranslate("June"),
              app.vtranslate("July"),
              app.vtranslate("August"),
              app.vtranslate("September"),
              app.vtranslate("October"),
              app.vtranslate("November"),
              app.vtranslate("December")
          ],
        },
        ranges: myranges
        });

        jQuery("#searchbtn").on("click", function(e) {
            var user_id = jQuery('#user_id').val();
            var daterange = jQuery('#daterange').val();
            var attendance_type = jQuery('#attendance_type').val();
            var mainmodule = app.getModuleName();
            var parentmodule = app.getParentModuleName();
            var action = 'getAttendance';
            var url = "index.php?module="+mainmodule+"&parent="+parentmodule+"&action="+action+"&search_key=user_name&search_value="+user_id+"&daterange="+daterange+"&attendance_type="+attendance_type;
            table = jQuery('#example1').DataTable({
              'paging'      : true,
              'lengthChange': false,
              'searching'   : false,
              'ordering'    : false,
              'info'        : true,
              'autoWidth'   : false,
              'pageLength' : 20,
              'processing': true,
              'serverSide': true,
              'serverMethod': 'post',
              'destroy': true,
              'ajax': {
                  'url':url
              },
              "language": {
                  "sProcessing": app.vtranslate('Processing'),
                  "sEmptyTable": app.vtranslate('No data available in table'),
                  "sInfo": app.vtranslate('Showing')+" _START_ "+app.vtranslate('to')+" _END_ "+app.vtranslate('of')+" _TOTAL_ "+app.vtranslate('entries'),
                  "sInfoEmpty": app.vtranslate('Showing')+" 0 "+app.vtranslate('to')+" 0 "+app.vtranslate('of')+" 0 "+app.vtranslate('entries'),
                  "oPaginate": {
                      "sFirst": app.vtranslate('First'),   
                      "sLast": app.vtranslate('Last'),  
                      "sNext":   app.vtranslate('Next'), 
                      "sPrevious": app.vtranslate('Previous'),
                  },
              },
              "columns": [
                { "data": "user_name" },
                { "data": "date" },
                { "data": "total_hours" },
                { "data": "total_minutes" }
              ]
              }); 
        });

        var mainmodule = app.getModuleName();
        var parentmodule = app.getParentModuleName();
        var action = 'getAttendance';
        var url = "index.php?module="+mainmodule+"&parent="+parentmodule+"&action="+action;
        table = jQuery('#example1').DataTable({
          'paging'      : true,
          'lengthChange': false,
          'searching'   : false,
          'ordering'    : false,
          'info'        : true,
          'autoWidth'   : false,
          'pageLength' : 20,
          'processing': true,
          'serverSide': true,
          'serverMethod': 'post',
          'ajax': {
              'url':url
          },
          "language": {
              "sProcessing": app.vtranslate('Processing'),
              "sEmptyTable": app.vtranslate('No data available in table'),
              "sInfo": app.vtranslate('Showing')+" _START_ "+app.vtranslate('to')+" _END_ "+app.vtranslate('of')+" _TOTAL_ "+app.vtranslate('entries'),
              "sInfoEmpty": app.vtranslate('Showing')+" 0 "+app.vtranslate('to')+" 0 "+app.vtranslate('of')+" 0 "+app.vtranslate('entries'),
              "oPaginate": {
                  "sFirst": app.vtranslate('First'),   
                  "sLast": app.vtranslate('Last'),  
                  "sNext":   app.vtranslate('Next'), 
                  "sPrevious": app.vtranslate('Previous'),
              },
          },
          "columns": [
            { "data": "user_name" },
            { "data": "date" },
            { "data": "total_hours" },
            { "data": "total_minutes" }
          ]
          });
        
    },

    registerEventsForDownload : function(){
        jQuery('#exportascsv').on('click',function(){
            var usersFilter = jQuery('#user_id').val();
            var daterange = jQuery('#daterange').val();
            var attendance_type = jQuery('#attendance_type').val();
            var params = {
                module: 'CTMobileSettings',
                action: 'getAttendance',
                mode: 'ExportDataCount',
                search_key:'username',
                search_value:usersFilter,
                daterange:daterange,
                attendance_type:attendance_type
            };
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
            });
            AppConnector.request(params).then(function (res) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                if(res.result['success'] > 0){
                    jQuery('#type').val('csv');
                    jQuery('#downloadForm').submit();
                }else{
                    var pparams = {
                        title : app.vtranslate('Error'),
                        text: app.vtranslate('No Data Available.'),
                        animation: 'show',
                        type: 'error'
                    };
                    Vtiger_Helper_Js.showPnotify(pparams);
                       
                }
            
            });  
            
        });

        jQuery('#exportasexcel').on('click',function(){
            var usersFilter = jQuery('#user_id').val();
            var daterange = jQuery('#daterange').val();
            var attendance_type = jQuery('#attendance_type').val();
            var params = {
                module: 'CTMobileSettings',
                action: 'getAttendance',
                mode: 'ExportDataCount',
                search_key:'username',
                search_value:usersFilter,
                daterange:daterange,
                attendance_type:attendance_type
            };
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
            });
            AppConnector.request(params).then(function (res) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                if(res.result['success'] > 0){
                    jQuery('#type').val('excel');
                    jQuery('#downloadForm').submit();
                }else{
                    var pparams = {
                        title : app.vtranslate('Error'),
                        text: app.vtranslate('No Data Available.'),
                        animation: 'show',
                        type: 'error'
                    };
                    Vtiger_Helper_Js.showPnotify(pparams);
                       
                }
            
            });  
            
        });
    },
    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerUsersFilterChangeEvent(); 
        this.registerEventsForDownload();  
    }
});




