 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_ManualSync_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_Settings_Js.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTMobileSettings_Settings_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_Settings_Js.editInstance;
    }
},{
    
    registerImportFile:function() {
       
        jQuery("#filename").on("change", function(e) {
          var fp = $("#filename");
          var lg = fp[0].files.length;
          var items = fp[0].files;
          var name = items[0].name;
          $(".uploadedFileDetails #uploadedFileName").text(name);
        });
        jQuery("#fieldfilename").on("change", function(e) {
          var fp = $("#fieldfilename");
          var lg = fp[0].files.length;
          var items = fp[0].files;
          var name = items[0].name;
          $(".uploadedFieldFileDetails #uploadedFieldFileName").text(name);
        });
        jQuery("#uploadForm").on("submit", function(e) {
            var fp = $("#filename");
            var lg = fp[0].files.length;
            if(lg > 0){
              e.preventDefault();
              var formData = new FormData(this);
              
              var params = {
                url: "index.php",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false
              };
              var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                 'enabled' : true
                }
              });
              AppConnector.request(params).then(function(e,res) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                if(res['success']){

                  var params = {
                      title : app.vtranslate('success'),
                      text: app.vtranslate('JS_UPLOAD_SUCCESSFUL'),
                      animation: 'show',
                      type: 'success'
                  };
                 Vtiger_Helper_Js.showPnotify(params);
                //app.helper.showSuccessNotification({'message' : app.vtranslate('JS_UPLOAD_SUCCESSFUL')});

                }else{
                    var params = {
                        title : app.vtranslate('Error'),
                        text: res['msg'],
                        animation: 'show',
                        type: 'error'
                    };
                    Vtiger_Helper_Js.showPnotify(params);
                    //app.helper.showErrorNotification({'message' : res['msg'] });
                }
              });
            }else{
              var params = {
                  title : app.vtranslate('Error'),
                  text: app.vtranslate('JS_PLEASE_SELECT_A_FILE'),
                  animation: 'show',
                  type: 'error'
              };
              Vtiger_Helper_Js.showPnotify(params);
              return false;
            }
        });
        jQuery("#uploadEntityForm").on("submit", function(e) {
            var fp = $("#fieldfilename");
            var lg = fp[0].files.length;
            if(lg > 0){
              e.preventDefault();
              var formData = new FormData(this);
              
              var params = {
                url: "index.php",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false
              };
              var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                 'enabled' : true
                }
              });
              AppConnector.request(params).then(function(e,res) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                if(res['success']){
                   var params = {
                        title : app.vtranslate('success'),
                        text: app.vtranslate('JS_UPLOAD_SUCCESSFUL'),
                        animation: 'show',
                        type: 'success'
                    };
                   Vtiger_Helper_Js.showPnotify(params);
                   //app.helper.showSuccessNotification({'message' : app.vtranslate('JS_UPLOAD_SUCCESSFUL')});
                   location.reload();
                }else{
                    var params = {
                        title : app.vtranslate('Error'),
                        text: res['msg'],
                        animation: 'show',
                        type: 'error'
                    };
                    Vtiger_Helper_Js.showPnotify(params);
                    //app.helper.showErrorNotification({'message' : res['msg'] });
                }
              });
            }else{
              var params = {
                  title : app.vtranslate('Error'),
                  text: app.vtranslate('JS_PLEASE_SELECT_A_FILE'),
                  animation: 'show',
                  type: 'error'
              };
              Vtiger_Helper_Js.showPnotify(params);
              /*app.helper.showErrorNotification({
                'message' : app.vtranslate('JS_PLEASE_SELECT_A_FILE')
              });*/
              return false;
            }
        });
    },

    //hide and show file and field selection
    registerSelectChangeEvent : function(){
        jQuery("#search_module").on("change", function(e) {
          var modulename = $('#search_module').val();
          
          if(modulename != "")
            $('.contentBlock').show();
          else
            $('.contentBlock').hide();
        });
        jQuery("#entity_search_module").on("change", function(e) {

          var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
             'enabled' : true
            }
          });
          var modulename = $('#entity_search_module').val();
          var selectedFields=jQuery("#uploadEntityForm").find("#fieldMappingData");
          if(modulename != ""){
            $('#fieldMappingData').show();
            var params= {
                  "type": "POST",
                  "url": "index.php?module=CTMobileSettings&parent=Settings&view=ManualSync&search_module="+modulename+"&mode=fieldMapping",
                  "dataType":"html",
                  "data" : {}
              };
            
            AppConnector.request(params).then(
                function(data) {
                    
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    selectedFields.html(data);
                    app.changeSelectElementView(selectedFields);
                    app.showSelect2ElementView(selectedFields.find('select.select2'));
                }
            )
          }else{
            $('#fieldMappingData').hide();
            progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                selectedFields.html('');
            $('.entityContentBlock').hide();
          }
        });

        //change event of field selection
        jQuery("#search_field_module").live("change", function(e) {
          var modulefields = $('#search_field_module').val();

          if(modulefields == null){
            $('.entityContentBlock').hide();
          }else{
            $('.entityContentBlock').show();
            var params = {
                "module" : "CTMobileSettings",
                "view" :"ManualSync",
                "mode" : "genarateCSVFile",
                "columns" : modulefields
               
            };
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
            });
            AppConnector.request(params).then(function(e,res) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                
            });
          }
        });


    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        $('.contentBlock').hide();
        $('.entityContentBlock').hide();
        this.registerImportFile();
        this.registerSelectChangeEvent(); 
    }
});
