 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_ModuleIcons_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_ModuleIcons_Js.editInstance == false){
            var instance = new CTMobileSettings_ModuleIcons_Js();
            CTMobileSettings_ModuleIcons_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_ModuleIcons_Js.editInstance;
    }
},{
    
    registerModuleIconDimensionsValidation : function() {

        jQuery('.editModuleIcons').on('click',function(){
            var popupInstance = Vtiger_Popup_Js.getInstance();
            var iconModule = jQuery(this).parent().find('[name="modulename"]').val();
            var params = {};
            params['module'] = "CTMobileSettings";
            params['view'] = "ModuleIconsAjax";
            params['iconModule'] = iconModule;
            popupInstance.show(params,function(data){

            });
        });

        //150*40 logo with padding would be nice
        var allowedDimensions = {
            'width' : 79,
            'height' : 79
        };
        var updateCompanyDetailsForm = jQuery('form#SaveModuleIcons');
        var moduleIcon = updateCompanyDetailsForm.find('#moduleIcon');
        moduleIcon.on('change', function() {
            //http://stackoverflow.com/a/13572209
            var _URL = window.URL || window.webkitURL;
            var image, file = this.files[0];
            if(file && typeof Image === 'function') {
                image = new Image();
                image.onload = function() {
                    var width = this.width;
                    var height = this.height;
                    if(width > allowedDimensions.width || height > allowedDimensions.height ) {
                        var params = {
                            title : app.vtranslate('Error'),
                            text: app.vtranslate('JS_LOGO_IMAGE_DIMENSIONS_WRONG'),
                            animation: 'show',
                            type: 'error'
                            };
                        Vtiger_Helper_Js.showPnotify(params);
                        
                        moduleIcon.val(null); //this will empty file input
                    }
                };
                image.src = _URL.createObjectURL(file);
            }
        });
    },

    registerSaveModuleIconEvent : function() {
      var thisInstance = this;
      var form = jQuery('#SaveModuleIcons');
      var params = {
        submitHandler : function(form) {
          var form = jQuery(form);
          var result = thisInstance.checkValidation();
          if(result === false){
            return result;
          }else {
            return true;
          }
        }
      };
    },

    checkValidation : function() {
      var IconModule = jQuery('[name="IconModule"]').val();
      if(IconModule == ''){
        var params = {
                title : app.vtranslate('Error'),
                text: app.vtranslate('Please select module'),
                animation: 'show',
                type: 'error'
            };
          Vtiger_Helper_Js.showPnotify(params);
        return false;
      }
      var imageObj = jQuery('#moduleIcon');
      var imageName = imageObj.val();
      if(imageName != '') {
        var image_arr = new Array();
        image_arr = imageName.split(".");
        var image_arr_last_index = image_arr.length - 1;
        if(image_arr_last_index < 0) {
          var params = {
                title : app.vtranslate('Error'),
                text: app.vtranslate('LBL_WRONG_IMAGE_TYPE'),
                animation: 'show',
                type: 'error'
            };
          Vtiger_Helper_Js.showPnotify(params);
          imageObj.val('');
          return false;
        }
        var image_extensions = JSON.parse(jQuery('#supportedImageFormats').val());
        var image_ext = image_arr[image_arr_last_index].toLowerCase();
        if(image_extensions.indexOf(image_ext) != '-1') {
          var size = imageObj[0].files[0].size;
          if (size < 1024000) {
            return true;
          } else {
            var params = {
                title : app.vtranslate('Error'),
                text: app.vtranslate('LBL_MAXIMUM_SIZE_EXCEEDS'),
                animation: 'show',
                type: 'error'
            };
            Vtiger_Helper_Js.showPnotify(params);
            return false;
          }
        } else {
            var params = {
                title : app.vtranslate('Error'),
                text: app.vtranslate('LBL_WRONG_IMAGE_TYPE'),
                animation: 'show',
                type: 'error'
            };
            Vtiger_Helper_Js.showPnotify(params);
            imageObj.val('');
            return false;
        }
    
      }
    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerSaveModuleIconEvent();
        this.registerModuleIconDimensionsValidation();
    }
});

