 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

jQuery(document).ready(function () {
	
	jQuery('#deactivateLicense').live('click',function(){
		var params = {};
		params['module'] = app.getModuleName();
		params['parent'] = app.getParentModuleName();
		params['action'] = 'Deactivate';
		var message1 = app.vtranslate('MSG_CTMOBILE_DEACTIVATE_POPUP');
		Vtiger_Helper_Js.showConfirmationBox({'message' : message1}).then(function(data) {
			AppConnector.request(params).then(function(data) {
				if(data.result){
					var params = {
						title : data.result.message,
						text: data.result.message,
						animation: 'show',
						type: 'success'
					};
					Vtiger_Helper_Js.showPnotify(params);
					location.reload();
				}	
			});
		});
	});
	
   jQuery('#unInstallCTMobile').live('click',function(){
		var params = {};
		params['module'] = 'CTMobileSettings';
		params['parent'] = 'Settings';
		params['action'] = 'Uninstall';
		var message1 = app.vtranslate("JS_CTMOBILE_POPUP1")+'<br/>'+app.vtranslate("JS_CTMOBILE_POPUP1_2");;
		var message2 = app.vtranslate("JS_CTMOBILE_POPUP2");
		Vtiger_Helper_Js.showConfirmationBox({'message' : message1}).then(function(data) {
			Vtiger_Helper_Js.showConfirmationBox({'message' : message2}).then(function(data) {
				AppConnector.request(params).then(function(data) {
					if(data.result !=''){
						var params = {
							title : app.vtranslate('CTMOBILE_UNISTALL_SUCCESS'),
							text: app.vtranslate('MSG_CTMOBILE_UNISTALL_SUCCESS'),
							animation: 'show',
							type: 'success'
						};
						Vtiger_Helper_Js.showPnotify(params);
						window.location.href = data.result;
					}
					else{
						var params = {
							title : app.vtranslate('CTMOBILE_UNISTALL_FAILED'),
							text: app.vtranslate('MSG_CTMOBILE_UNISTALL_FAILED'),
							animation: 'show',
							type: 'error'
						};
						Vtiger_Helper_Js.showPnotify(params);
					}	
				});
			});
		});
	});
	
   jQuery('#save_api_Key').on('click',function(){
 	var api_Key = jQuery('input[name="api_Key"]').val();
 	if(api_Key == ''){
		var params = {
			title : app.vtranslate('JS_MESSAGE'),
			text: 'Please Enter Google Api Key',
			animation: 'show',
			type: 'error'
		};
		Vtiger_Helper_Js.showPnotify(params);
 	}else{
 		var progressIndicatorElement = jQuery.progressIndicator({
			'position' : 'html',
			'blockInfo' : {
				'enabled' : true
			}
		});

		var params = {};
		params['module'] = app.getModuleName();
		params['action'] = 'SaveApi';
		params['mode'] = 'Google';
		params['api_Key'] = api_Key;
		
		AppConnector.request(params).then(
			function(data) {
					progressIndicatorElement.progressIndicator({'mode' : 'hide'});
					
				        var msg=data.result['msg'];
				        var code =data.result['code'];
				        if(code == 100){
				        	var params = {
								title : app.vtranslate('JS_MESSAGE'),
								text: msg,
								animation: 'show',
								type: 'error'
							};
							Vtiger_Helper_Js.showPnotify(params);	
				        }else if(code == 101){
				        	var params = {
								title : app.vtranslate('JS_MESSAGE'),
								text: msg,
								animation: 'show',
								type: 'error'
							};
							Vtiger_Helper_Js.showPnotify(params);	
				        }else{

							var params = {
									title : app.vtranslate('JS_MESSAGE'),
									text: msg,
									animation: 'show',
									type: 'info'
								};
								Vtiger_Helper_Js.showMessage(params);
							
							location.href = "index.php?module=CTMobileSettings&parent=Settings&view=Settings";
				        }
				   });
 	}
 
    
});

var url = window.location.href;
var url = new URL(url);
var view = url.searchParams.get("view");

if(view == 'GEOSettings'){
	jQuery("input[type='checkbox']").bootstrapSwitch();

	jQuery('#locationiq_status').on('switchChange.bootstrapSwitch',function(e){
        var currentElement = jQuery(e.currentTarget);
        if (currentElement.bootstrapSwitch('state')) {
          jQuery('#openstreet_status').bootstrapSwitch('state', false);
          jQuery('#google_status').bootstrapSwitch('state', false);
          updateMapStatus('LOCATIONIQ');
        }else{
          jQuery('#openstreet_status').bootstrapSwitch('state', true);
        }
    });

    jQuery('#google_status').on('switchChange.bootstrapSwitch',function(e){
        var currentElement = jQuery(e.currentTarget);
        if (currentElement.bootstrapSwitch('state')) {
          updateMapStatus('GOOGLE');
        }else{
          jQuery('#openstreet_status').bootstrapSwitch('state', true);
        }
    });

    jQuery('#openstreet_status').on('switchChange.bootstrapSwitch',function(e){
        var currentElement = jQuery(e.currentTarget);
        if (currentElement.bootstrapSwitch('state')) {
          jQuery('#google_status').bootstrapSwitch('state', false);
          jQuery('#locationiq_status').bootstrapSwitch('state', false);
          updateMapStatus('OPENSTREET');
        }else{
          //jQuery('#openstreet_status').bootstrapSwitch('state', true);
        }
    });
}

if(view == 'TeamTracking'){
	var date = new Date();
	var month = date.getMonth()+1;
	var day = date.getDate();
	var year = date.getFullYear();
	var newdate = year + '/' + month + '/' + day;
        if(day > 7){
	   day = day -7;
	   if(day < 10 ){
		   day = '0' + day;
	   }
	   if(month < 10 ){
		   month = '0' + month;
	   }
	   var lastDate = year + '/' + month + '/' + day;
        }else{
	     var month31 = [1,3,5,7,8,10,12];
	     if(month > 1){
			day = 7 - day;
			month = month - 1;
			if(jQuery.inArray(month, month31) !== -1){
				day = 31 - day;
			}else{
				day = 30 - day;
			}
			year = year - 1;
			if(day < 10 ){
			   day = '0' + day;
			}
			if(month < 10 ){
			   month = '0' + month;
			}
			var lastDate = year + '/' + month + '/' + day;
	     }else{
			day = day -7;
			month = month - 1;
			if(jQuery.inArray(month, month31) !== -1){
				day = 31 - day;
			}else{
				day = 30 - day;
			}
			if(day < 10 ){
			   day = '0' + day;
			}
			if(month < 10 ){
			   month = '0' + month;
			}
			var lastDate = year + '/' + month + '/' + day;
	     }
        }

        	   var Today = newdate;
	   var tempdate = date;
	   tempdate.setDate(tempdate.getDate() - 1);
	   var Yesterday = tempdate.getFullYear()+'/'+(tempdate.getMonth()+1)+'/'+tempdate.getDate();

	   var tempdate1 = date;
	   tempdate1.setDate(tempdate1.getDate() - 6);
	   var last7days = tempdate1.getFullYear()+'/'+(tempdate1.getMonth()+1)+'/'+tempdate1.getDate();

	   var tempdate2 = date;
	   tempdate2.setDate(tempdate2.getDate() - 29);
	   var last30days = tempdate2.getFullYear()+'/'+(tempdate2.getMonth()+1)+'/'+tempdate2.getDate();

	   var date = new Date();
	   var firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
	   var lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
	   var firstday = firstDay.getFullYear()+'/'+(firstDay.getMonth()+1)+'/'+firstDay.getDate();
	   var lastday = lastDay.getFullYear()+'/'+(lastDay.getMonth()+1)+'/'+lastDay.getDate();

	   var date = new Date();
	   var firstDay = new Date(date.getFullYear(), date.getMonth()-1, 1);
       var lastDay = new Date(date.getFullYear(), date.getMonth(), 0);
       var monthStartDay = firstDay.getFullYear()+'/'+(firstDay.getMonth()+1)+'/'+firstDay.getDate();
       var monthEndDay = lastDay.getFullYear()+'/'+(lastDay.getMonth()+1)+'/'+lastDay.getDate();

       var date = new Date();
	   var firstDay = new Date(date.getFullYear(), 0, 1);
       var lastDay = new Date(date.getFullYear(), 12, 0);
       var yearStartDay = firstDay.getFullYear()+'/'+(firstDay.getMonth()+1)+'/'+firstDay.getDate();
       var yearEndDay = lastDay.getFullYear()+'/'+(lastDay.getMonth()+1)+'/'+lastDay.getDate();

       var date = new Date();
	   var firstDay = new Date(date.getFullYear()-1, 0, 1);
       var lastDay = new Date(date.getFullYear()-1, 12, 0);
       var lastyearStartDay = firstDay.getFullYear()+'/'+(firstDay.getMonth()+1)+'/'+firstDay.getDate();
       var lastyearEndDay = lastDay.getFullYear()+'/'+(lastDay.getMonth()+1)+'/'+lastDay.getDate();


	var dateValue = lastDate + ' - ' + newdate;
	jQuery('input[name="daterange"]').val(dateValue);
	
	   var today_label = app.vtranslate('Today');
       var yesterday_label = app.vtranslate('Yesterday');
       var last_7_days_label = app.vtranslate('Last 7 Days');
       var last_30_days_label = app.vtranslate('Last 30 Days');
       var this_month_label = app.vtranslate('This Month');
       var this_year_label = app.vtranslate('This Year');
       var last_year_label = app.vtranslate('Last Year');

       var myranges = {};
       myranges[today_label] = [Today,Today];
       myranges[yesterday_label] = [Yesterday, Yesterday];
       myranges[last_7_days_label] = [last7days, Today];
       myranges[last_30_days_label] = [last30days, Today];
       myranges[this_month_label] = [firstday, lastday];
       myranges[this_year_label] = [yearStartDay, yearEndDay];
       myranges[last_year_label] = [lastyearStartDay, lastyearEndDay];

       jQuery('input[name="daterange"]').daterangepicker({    locale: {
          format: 'YYYY/MM/DD',
          separator: " - ",
          applyLabel: app.vtranslate("Apply"),
          cancelLabel: app.vtranslate("Cancel"),
          fromLabel: app.vtranslate("From"),
          toLabel: app.vtranslate("To"),
          customRangeLabel: app.vtranslate("Custom Range"),
          daysOfWeek: [
              app.vtranslate("Su"),
              app.vtranslate("Mo"),
              app.vtranslate("Tu"),
              app.vtranslate("We"),
              app.vtranslate("Th"),
              app.vtranslate("Fr"),
              app.vtranslate("Sa")
          ],
          monthNames: [
              app.vtranslate("January"),
              app.vtranslate("February"),
              app.vtranslate("March"),
              app.vtranslate("April"),
              app.vtranslate("May"),
              app.vtranslate("June"),
              app.vtranslate("July"),
              app.vtranslate("August"),
              app.vtranslate("September"),
              app.vtranslate("October"),
              app.vtranslate("November"),
              app.vtranslate("December")
          ],
        },
        ranges: myranges
        });
}
if(view = 'LicenseDetail'){
	var params = {};
		params['module'] = 'CTMobileSettings';
		params['action'] = 'chkPermission';
		params['mode'] = 'GetLicense';
		AppConnector.request(params).then(function(data){
			if(data.result != 0){
				var android_store_url = 'https://play.google.com/store/apps/details?id=com.crmtiger.vtigercrm&hl=en';
				var ios_store_url = 'https://apps.apple.com/in/app/crmtiger-vtiger-mobile/id1274011679';
				var detailView_url = 'index.php?module=CTMobileSettings&parent=Settings&view=Details';
				var darkcolor =  '#00008b';
				var success_msg = app.vtranslate('You have successfully enter your license information - Enjoy CRMTiger Mobile Apps by Downloading Mobile Apps from Store');
				var click_here = app.vtranslate('Click Here');
				var message_html = success_msg+"<br/><a style='color:#15c !important;'  onMouseOver="+'this.style.color="#00008b"'+" onMouseOut="+'this.style.color="#15c"'+" href='"+android_store_url+"' target='_blank'>"+click_here+"</a> "+app.vtranslate('Download apps for android users')+"<br/><a style='color:#15c !important;' onMouseOver="+'this.style.color="#00008b"'+" onMouseOut="+'this.style.color="#15c"'+" href='"+ios_store_url+"' target='_blank'>"+click_here+"</a> "+app.vtranslate('to download Apps for iOS users')+"<br/><a style='color:#15c !important;' onMouseOver="+'this.style.color="#00008b"'+" onMouseOut="+'this.style.color="#15c"'+" href='"+detailView_url+"' >"+click_here+"</a> "+app.vtranslate('view CRMTiger Mobile Apps management Dashboard - an Intuitive Dashboard for CRM Admin to manage various activities of CRMTiger Mobile Apps');
				jQuery('#successMessage').html(message_html);
			}
		});
}

 jQuery('.editButton').on('click',function(){
 	var url = jQuery(this).attr('data-url');
 	location.href = url;
 });

 jQuery('#ctopenstreetmap').on('click',function(){
	var url = jQuery(this).attr('data-url');
	location.href = url;
 });
 
 jQuery('#ctgooglemap').on('click',function(){
	var url = jQuery(this).attr('data-url');
	location.href = url;
 });
 
 
 jQuery('#updatectmobile').live('click',function(){
		var url = jQuery(this).attr('data-url');
		location.href = url;
 });
 jQuery('#help_btn').on('click',function(){
		var url = jQuery(this).attr('data-url');
		window.open(url, '_blank');
 });
 jQuery('#ios_btn').on('click',function(){
		var url = jQuery(this).attr('data-url');
		window.open(url, '_blank');
 });
 jQuery('#android_btn').on('click',function(){
		var url = jQuery(this).attr('data-url');
		window.open(url, '_blank');
 });


 jQuery('.blur_box_btn').on('click',function(){
	var url = jQuery(this).attr('data-url');
	window.open(url, '_blank');
 });

 jQuery('#WhatsNew').on('click',function(){
 	var popupInstance = Vtiger_Popup_Js.getInstance();
 	    var params = {};
 		params['module'] = "CTMobileSettings";
        params['view'] = "WhatsNew";
        popupInstance.show(params,function(data){

        });
 });

 //jQuery('#myModal').modal('show'); 
 jQuery('#updateModal').modal('show');

 jQuery('#forcelogout').on('click',function(){
	var message = app.vtranslate('Are you sure to Logout all Mobile Apps users');
	Vtiger_Helper_Js.showConfirmationBox({'message' : message}).then(function(data) {
	 	var params = {};
		params['module'] = app.getModuleName();
		params['parent'] = app.getParentModuleName();
		params['action'] = 'ForceLogout';

		var progressIndicatorElement = jQuery.progressIndicator({
			'position' : 'html',
			'blockInfo' : {
				'enabled' : true
			}
	    });

		AppConnector.request(params).then(function(data) {
			progressIndicatorElement.progressIndicator({'mode' : 'hide'});

			var pparams = {
				title : app.vtranslate('All mobile app users logout successfully'),
				text: app.vtranslate('All mobile app users logout successfully'),
				animation: 'show',
				type: 'info'
			};
			Vtiger_Helper_Js.showPnotify(pparams);
		});
	});
});

 $(function () {
    $("a[class='showErrorModal']").click(function () {
        $("#myModal").modal("show");
        return false;
    });
 });
 
jQuery('#save_license_settings').on('click',function(){
		License_Key = jQuery('input[name="License_Key"]').val();
		if(License_Key == ''){

			var params = {
				title : app.vtranslate('Please Enter License Key'),
				text: app.vtranslate('Please Enter License Key'),
				animation: 'show',
				type: 'error'
			};
			Vtiger_Helper_Js.showPnotify(params);
		}else{
			var progressIndicatorElement = jQuery.progressIndicator({
				'position' : 'html',
				'blockInfo' : {
					'enabled' : true
				}
			});

			var params = {};
			params['module'] = app.getModuleName();
			params['parent'] = app.getParentModuleName();
			params['action'] = 'SaveLicense';
			params['license_key'] = License_Key;
			
			AppConnector.request(params).then(function(data) {
					progressIndicatorElement.progressIndicator({'mode' : 'hide'});
					var msg=data.result['msg'];
					var code =data.result['code'];
					if(code === 100 || code === 101){
						var params = {
							title : app.vtranslate(msg),
							text: msg,
							animation: 'show',
							type: 'error'
						};
						Vtiger_Helper_Js.showPnotify(params);	
					}else if(code === 103){
						another_domain = data.result['domain'];
						license_key = data.result['license_key'];

						var params = {};
						params['module'] = app.getModuleName();
						params['parent'] = app.getParentModuleName();
						params['action'] = 'Deactivate';
						params['domain'] = another_domain;
						params['license_key'] = license_key;
						var message1 = app.vtranslate('Your License key is already registered with "'+another_domain+'", Are you Sure Want to Deactivate from there and Activate to current Instance ?');
						Vtiger_Helper_Js.showConfirmationBox({'message' : message1}).then(function(data) {
							var progressIndicatorElement2 = jQuery.progressIndicator({
								'position' : 'html',
								'blockInfo' : {
									'enabled' : true
								}
							});
							AppConnector.request(params).then(function(response) {
								if(response){
									var params2 = {};
									params2['module'] = app.getModuleName();
									params2['parent'] = app.getParentModuleName();
									params2['action'] = 'SaveLicense';
									params2['license_key'] = license_key;
									AppConnector.request(params2).then(function(data2) {
										progressIndicatorElement2.progressIndicator({'mode' : 'hide'});
										var msg2=data2.result['msg'];
										var code2 =data2.result['code'];
										if(code2 === 100 || code2 === 101 || code2 === 103){
											var pparams = {
												title : app.vtranslate('Something went wrong'),
												text: app.vtranslate('Something went wrong'),
												animation: 'show',
												type: 'error'
											};
											Vtiger_Helper_Js.showPnotify(pparams);
										}else{
											var params = {
												title : app.vtranslate(msg2),
												text: msg2,
												animation: 'show',
												type: 'info'
											};
											Vtiger_Helper_Js.showMessage(params);
											jQuery('#updateCRMTigerModal').modal({backdrop: 'static',keyboard: false});
										}
									});
								}	
							});
						});	

						setTimeout(function() {
							if(progressIndicatorElement2){
								var data = progressIndicatorElement2.data('progressIndicator');
								if(data.options.mode != 'hide'){
									progressIndicatorElement2.progressIndicator({'position' : 'html','blockInfo' : { 'enabled' : true },'message' : 'We are updating CRMTiger Mobile Apps extension - Please Wait...'});
								}
							}
					    }, 1000);

					    setTimeout(function() {
							if(progressIndicatorElement2){
								var data = progressIndicatorElement2.data('progressIndicator');
								if(data.options.mode != 'hide'){
									progressIndicatorElement2.progressIndicator({'position' : 'html','blockInfo' : { 'enabled' : true },'message' : '<p>We are still working on updating CRMTiger Mobile Apps extension - Please Wait for little more time... </p> <p>if it tooks more time than expected please contact us on <a class="btn btn-primary" href="mailto:support@crmtiger.com">support@crmtiger.com</a> or </p> <p><a class="btn btn-success" href="https://kb.crmtiger.com/knowledge-base/crmtiger-mobileapps-extensions/" target="_blank">Click here</a> to install CRMTiger Mobile Apps Extensions manually for respected vTiger version from <a href="index.php?module=ModuleManager&parent=Settings&view=List" class="btn btn-primary" target="_blank">Settings</a></p>'});
								}
							}
					    }, 1000*30);
					    
					}else{
						var params = {
							title : app.vtranslate(msg),
							text: msg,
							animation: 'show',
							type: 'info'
						};
						Vtiger_Helper_Js.showMessage(params);
						
						jQuery('#updateCRMTigerModal').modal({backdrop: 'static',keyboard: false});
					}
			});

		    setTimeout(function() {
				if(progressIndicatorElement){
					var data = progressIndicatorElement.data('progressIndicator');
					if(data.options.mode != 'hide'){
						progressIndicatorElement.progressIndicator({'position' : 'html','blockInfo' : { 'enabled' : true },'message' : 'We are updating CRMTiger Mobile Apps extension - Please Wait...'});
					}
				}
		    }, 1000);

		    setTimeout(function() {
				if(progressIndicatorElement){
					var data = progressIndicatorElement.data('progressIndicator');
					if(data.options.mode != 'hide'){
						progressIndicatorElement.progressIndicator({'position' : 'html','blockInfo' : { 'enabled' : true },'message' : '<p>We are still working on updating CRMTiger Mobile Apps extension - Please Wait for little more time... </p> <p>if it tooks more time than expected please contact us on <a class="btn btn-primary" href="mailto:support@crmtiger.com">support@crmtiger.com</a> or </p> <p><a class="btn btn-success" href="https://kb.crmtiger.com/knowledge-base/crmtiger-mobileapps-extensions/" target="_blank">Click here</a> to install CRMTiger Mobile Apps Extensions manually for respected vTiger version from <a href="index.php?module=ModuleManager&parent=Settings&view=List" class="btn btn-primary" target="_blank">Settings</a></p>'});
					}
				}
		    }, 1000*30);
		}
	 
		
	});

  jQuery('#ctapivalidate').on('click',function(){
    var api_Key = jQuery('input[name="api_Key"]').val();
    if(api_Key == ''){
        var params = {
            title : app.vtranslate('Please Enter Google Api Key'),
            text: app.vtranslate('Please Enter Google Api Key'),
            animation: 'show',
            type: 'error'
        };
        Vtiger_Helper_Js.showPnotify(params);
    }else{
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });

        var params = {};
        params['module'] = app.getModuleName();
        params['action'] = 'ValidateApi';
        params['mode'] = 'Google';
        params['api_Key'] = api_Key;
        
        AppConnector.request(params).then(
            function(data) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                var msg=data.result['msg'];
                var code =data.result['code'];
                if(code == 100){
                    var params = {
                        title : app.vtranslate(msg),
                        text: msg,
                        animation: 'show',
                        type: 'error'
                    };
                    Vtiger_Helper_Js.showPnotify(params);   
                }else if(code == 101){
                    var params = {
                        title : app.vtranslate(msg),
                        text: msg,
                        animation: 'show',
                        type: 'error'
                    };
                    Vtiger_Helper_Js.showPnotify(params);   
                }else{
                    var params = {
                            title : app.vtranslate(msg),
                            text: msg,
                            animation: 'show',
                            type: 'info'
                        };
                    Vtiger_Helper_Js.showMessage(params);
                }
            });
    }
});

jQuery('#remove_api_Key').on('click',function(){
    var params = {};
    params['module'] = app.getModuleName();
    params['action'] = 'RemoveApi';
    params['mode'] = 'Google';
    var progressIndicatorElement = jQuery.progressIndicator({
        'position' : 'html',
        'blockInfo' : {
            'enabled' : true
        }
    });
    AppConnector.request(params).then(
    function(data) {
        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
        var msg=data.result['msg'];
        var nparams = {
                title : msg,
                text: msg,
                animation: 'show',
                type: 'info'
            };
        Vtiger_Helper_Js.showMessage(nparams);
        location.reload();
    });
});

});

function updateModule(moduleName){
	var postData = {
	"module": 'CTMobileSettings',
	"action": 'updateModuleAjax',
	"updateModName": moduleName
	};
	var htmlmessage = jQuery('#waitmsg').html();
	var progressIndicatorElement = jQuery.progressIndicator({
        'position' : 'html',
        'blockInfo' : {
            'enabled' : true
        },
        'message':htmlmessage
    });
	AppConnector.request(postData).then(function(data) {
		progressIndicatorElement.progressIndicator({'mode' : 'hide'});
		location.reload(true);	
		
	},
	function(error,err){
		progressIndicatorElement.progressIndicator({'mode' : 'hide'});
		var errorhtml = '<p>'+app.vtranslate('Oooops.. Its taking longer time than expected..')+'<p>';
		errorhtml+='<p><a href="https://kb.crmtiger.com/knowledge-base/error-code-solutions/" target="_blank">'+app.vtranslate('Click Here')+'</a> , '+app.vtranslate('if you still wants to manually update extension')+'</p>';
		var progressIndicatorElement = jQuery.progressIndicator({
	        'position' : 'html',
	        'blockInfo' : {
	            'enabled' : true
	        },
	        'message':errorhtml
	    });
	});

	setTimeout(function() {
		var errorhtml = '<p>'+app.vtranslate('Oooops.. Its taking longer time than expected..')+'<p>';
		errorhtml+='<p><a href="https://kb.crmtiger.com/knowledge-base/error-code-solutions/" target="_blank">'+app.vtranslate('Click Here')+'</a> , '+app.vtranslate('if you still wants to manually update extension')+'</p>';
		var progressIndicatorElement = jQuery.progressIndicator({
	        'position' : 'html',
	        'blockInfo' : {
	            'enabled' : true
	        },
	        'message':errorhtml
	    });
    }, 1000*120);
}


function updateMapStatus(maptype){
    var params = {};
    params['module'] = app.getModuleName();
    params['action'] = 'SaveApi';
    params['mode'] = 'updatemapstatus';
    params['map_type'] = maptype;
    var progressIndicatorElement = jQuery.progressIndicator({
        'position' : 'html',
        'blockInfo' : {
            'enabled' : true
        }
    });
    AppConnector.request(params).then(
    function(data) {
        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
        var code = data.result['code'];
        var msg=data.result['msg'];
        if(code == 100){
        	 var activemap =  data.result['activemap'];
        	 jQuery('#google_status').bootstrapSwitch('state', false);
        	 if(activemap == 'LOCATIONIQ'){
        	 	jQuery('#openstreet_status').bootstrapSwitch('state', false);
        	 }else{
        	 	jQuery('#locationiq_status').bootstrapSwitch('state', false);
        	 }
        	 var nparams = {
                title : msg,
                text: msg,
                animation: 'show',
                type: 'error'
            };
        	Vtiger_Helper_Js.showMessage(nparams);
        }else{
        	if(maptype == 'GOOGLE'){
        	  jQuery('#openstreet_status').bootstrapSwitch('state', false);
              jQuery('#locationiq_status').bootstrapSwitch('state', false);
        	}
	        var nparams = {
	                title : msg,
	                text: msg,
	                animation: 'show',
	                type: 'info'
	            };
	        Vtiger_Helper_Js.showMessage(nparams);
        }
    });
}
