<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
include_once 'include/Webservices/Retrieve.php';
include_once dirname(__FILE__) . '/FetchRecord.php';
include_once 'include/Webservices/DescribeObject.php';
include_once 'modules/MailManager/MailManager.php';

class CTMobile_WS_EmailAction extends CTMobile_WS_FetchRecord {
	function process(CTMobile_API_Request $request) {
		$mailaction = trim($request->get('mailaction'));
  		if($mailaction == ''){
			$message = vtranslate('Required fields not found','CTMobile');
			throw new WebServiceException(404,$message);
		}
		global $current_user,$adb, $site_URL;
		$current_user = $this->getActiveUser();
		$currentUserModel = Users_Record_Model::getCurrentUserModel();

		$response = new CTMobile_API_Response();
		$actionlist = array();
		$userPrivModel = Users_Privileges_Model::getInstanceById($current_user->id);
		$presence = array('0', '2');
		if ($mailaction == 1) {
			$linkToAvailableActions = $this->linkToAvailableActions();
		}else{
			$linkToAvailableActions = $this->getCurrentUserMailManagerAllowedModules();
		}
		
		foreach($linkToAvailableActions as $moduleName) {
			$moduleModel = Vtiger_Module_Model::getInstance($moduleName);
			if (($userPrivModel->isAdminUser() ||
						$userPrivModel->hasGlobalReadPermission() ||
						$userPrivModel->hasModulePermission($moduleModel->getId())) && in_array($moduleModel->get('presence'), $presence)) {
			 	$createAction = $userPrivModel->hasModuleActionPermission($moduleModel->getId(), 'EditView');
			 	if($createAction){
					 if ($moduleName == 'Calendar'){
						 $label = vtranslate("LBL_ADD_CALENDAR", 'CTMobile',$current_user->language);
						 $actionlist[] = array('moduleName' => $moduleName, 'label'=>trim($label)); 
						 
						 $label1 = vtranslate("LBL_ADD_EVENTS", 'CTMobile',$current_user->language);
						 $actionlist[] = array('moduleName' => 'Events', 'label'=>trim($label1)); 
					 }else{
						  $label = vtranslate("LBL_MAILMANAGER_ADD_$moduleName", 'MailManager',$current_user->language);
						  $actionlist[] = array('moduleName' => $moduleName, 'label'=>trim($label)); 
					 }
				}
			}
		}
				
		$response->setResult(array('actionlist'=>$actionlist, 'module'=>'MailManager', 'message'=>''));	
		return $response;
	}
	
	/**
	 * Returns the available List of accessible modules for Mail Manager
	 * @return Array
	 */
	public function getCurrentUserMailManagerAllowedModules() {
		$moduleListForCreateRecordFromMail = array('Contacts', 'Accounts', 'Leads', 'HelpDesk', 'Calendar');
		
		foreach($moduleListForCreateRecordFromMail as $module) {
			
			if(MailManager::checkModuleWriteAccessForCurrentUser($module)) {
				$mailManagerAllowedModules[] = $module;
			}
		}
		return $mailManagerAllowedModules;
	}

	/**
	 * Returns the list of accessible modules on which Actions(Relationship) can be taken.
	 * @return string
	 */
	public function linkToAvailableActions() {
		$moduleListForLinkTo = array('Calendar','HelpDesk','ModComments','Emails');

		foreach($moduleListForLinkTo as $module) {
			if(MailManager::checkModuleWriteAccessForCurrentUser($module)) {
				$mailManagerAllowedModules[] = $module;
			}
		}
		return $mailManagerAllowedModules;
	}
}
