<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

vimport ('~~/include/Webservices/Query.php');

class CTMobile_WS_GetDateBaseEventList extends CTMobile_WS_Controller {
	
	function process(CTMobile_API_Request $request) {
		global $current_user,$adb, $site_URL;
		$current_user = $this->getActiveUser();
		$roleid = $current_user->roleid;
		$moduleModel = Vtiger_Module_Model::getInstance('Calendar');
		if(!in_array($moduleModel->get('presence'), array('0','2'))){
			$message = vtranslate('Calendar','Calendar')." ".$this->CTTranslate('Module is disabled');
			throw new WebServiceException(404,$message);
		}
		$userid = trim($request->get('userid'));
		$startdate = trim($request->get('startdate'));
		$enddate = trim($request->get('enddate'));
		$recentEvent_data = array();
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');

		$query = "SELECT * FROM vtiger_calendar_user_activitytypes 
			INNER JOIN vtiger_calendar_default_activitytypes on vtiger_calendar_default_activitytypes.id=vtiger_calendar_user_activitytypes.defaultid 
			WHERE vtiger_calendar_user_activitytypes.userid=?";
		$results = $adb->pquery($query, array($current_user->id));
		$rows = $adb->num_rows($results);

		$calendarViewTypes = Array();
		for($i=0; $i<$rows; $i++){
			$activityTypes = $adb->query_result_rowdata($results, $i);
			$moduleInstance = Vtiger_Module_Model::getInstance($activityTypes['module']);
			//If there is no module view permission, should not show in calendar view
			if($moduleInstance === false || !$moduleInstance->isPermitted('Detail')) {
				continue;
			}
			$fieldInstance = Vtiger_Field::getInstance($activityTypes['fieldname'], $moduleInstance);
			if($fieldInstance) {
				$fieldLabel = $fieldInstance->label;
			} else {
				$fieldLabel = $activityTypes['fieldname'];
			}
			if($activityTypes['visible'] == '1') {
				$calendarViewTypes['visible'][] = array('module'=>$activityTypes['module'], 'fieldname'=>$activityTypes['fieldname'], 'fieldlabel'=>$fieldLabel, 'visible' => $activityTypes['visible'] , 'color' => $activityTypes['color']);
			} else {
				$calendarViewTypes['invisible'][] = array('module'=>$activityTypes['module'], 'fieldname'=>$activityTypes['fieldname'], 'fieldlabel'=>$fieldLabel, 'visible' => $activityTypes['visible'] , 'color' => $activityTypes['color']);
			}
		}
		$count = 0;
		foreach($calendarViewTypes['visible'] as $key=>$value) {  
			$type = $value['module'];
			if($value['module'] == 'Events' && $count == 0){
				$count++;
			}else if($value['module'] == 'Events' && $count == 1){
				continue;
			}
			$start = $startdate;
			$end = $enddate;
			$userid = $current_user->id;
			$color = $value['color'];
			$targetModule = '';
			$fieldName = $value['fieldname'];
			$isGroupId = false;
			$mapping = '';
			$conditions = '';
			$result = array(); 
			switch ($type) {
				case 'Events': $this->pullEvents($start, $end, $result,$userid,$color,$isGroupId,$conditions); break;
				case 'Calendar': $this->pullTasks($start, $end, $result,$color); break;
				case 'Potentials': $this->pullPotentials($start, $end, $result, $color); break;
				case 'Contacts':
							if($fieldName == 'support_end_date') {
								$this->pullContactsBySupportEndDate($start, $end, $result, $color);
							}else{
								$this->pullContactsByBirthday($start, $end, $result, $color);
							}
							break;

				case 'Invoice': $this->pullInvoice($start, $end, $result, $color); break;
				case 'MultipleEvents' : $this->pullMultipleEvents($start,$end, $result,$mapping);break;
				case 'Project': $this->pullProjects($start, $end, $result, $color); break;
				case 'ProjectTask': $this->pullProjectTasks($start, $end, $result, $color); break;
			}
			if(!empty($result)){
				$recentEvent_data = array_merge($recentEvent_data,$result);
			}
		}
		$picklistValues1 = array();
		$eventPicklistValues = Vtiger_Util_Helper::getRoleBasedPicklistValues('eventstatus',$roleid);
		foreach($eventPicklistValues as $epvalue){
			$picklistValues1[] = array('value'=>$epvalue, 'label'=>vtranslate($epvalue,'Events'));
		}
		$picklistValues2 = array();
		$taskPicklistValues = Vtiger_Util_Helper::getRoleBasedPicklistValues('taskstatus',$roleid);
		foreach($taskPicklistValues as $tpvalue){
			$picklistValues2[] = array('value'=>$tpvalue, 'label'=>vtranslate($tpvalue,'Calendar'));
		}
		
		$response = new CTMobile_API_Response();					  

		if(count($recentEvent_data) == 0){
			$message =  $this->CTTranslate('No event or task for this date');
			$response->setResult(array('GetEventList'=>[],'code'=>404,'message'=>$message,'eventstatus'=>$picklistValues1,'taskstatus'=>$picklistValues2));
		} else {
			$response->setResult(array('GetEventList'=>$recentEvent_data,'message'=>'','eventstatus'=>$picklistValues1,'taskstatus'=>$picklistValues2));
		}
		return $response;
	}

	protected function generateCalendarViewConditionQuery($conditions) {
		$conditionQuery = $operator = '';
		switch ($conditions['operator']) {
			case 'e' : $operator = '=';
		}

		if(!empty($operator) && !empty($conditions['fieldname']) && !empty($conditions['value'])) {
			$conditionQuery = ' '.$conditions['fieldname'].$operator.'\'' .$conditions['value'].'\' ';
		}
		return $conditionQuery;
	}

	protected function getGroupsIdsForUsers($userId) {
		vimport('~~/include/utils/GetUserGroups.php');

		$userGroupInstance = new GetUserGroups();
		$userGroupInstance->getAllUserGroups($userId);
		return $userGroupInstance->user_groups;
	}

	protected function queryForRecords($query, $onlymine=true) {
		$user = Users_Record_Model::getCurrentUserModel();
		if ($onlymine) {
			$groupIds = $this->getGroupsIdsForUsers($user->getId());
			$groupWsIds = array();
			foreach($groupIds as $groupId) {
				$groupWsIds[] = vtws_getWebserviceEntityId('Groups', $groupId);
			}
			$userwsid = vtws_getWebserviceEntityId('Users', $user->getId());
			$userAndGroupIds = array_merge(array($userwsid),$groupWsIds);
			$query .= " AND assigned_user_id IN ('".implode("','",$userAndGroupIds)."')";
		}
		// TODO take care of pulling 100+ records
		return vtws_query($query.';', $user);
	}

	protected function pullEvents($start, $end, &$result, $userid = false, $color = null,$isGroupId = false, $conditions = '') {
		global $current_user;
		$current_user = $this->getActiveUser();
		$startDateTime = Vtiger_Datetime_UIType::getDBDateTimeValue($start . ' 00:00:00');
		$endDateTime = Vtiger_Datetime_UIType::getDBDateTimeValue($end . ' 23:59:00');

		$currentDateTime = date("Y-m-d H:i:s");

		$currentUser = Users_Record_Model::getCurrentUserModel();
		$db = PearDatabase::getInstance();
		$groupsIds = Vtiger_Util_Helper::getGroupsIdsForUsers($currentUser->getId());

		$moduleModel = Vtiger_Module_Model::getInstance('Events');
		if($userid && !$isGroupId){
			$focus = new Users();
			$focus->id = $userid;
			$focus->retrieve_entity_info($userid, 'Users');
			$user = Users_Record_Model::getInstanceFromUserObject($focus);
			$userName = $user->getName();
			$queryGenerator = new QueryGenerator($moduleModel->get('name'), $user);
		}else{
			$queryGenerator = new QueryGenerator($moduleModel->get('name'), $currentUser);
		}

		$queryGenerator->setFields(array('subject', 'eventstatus', 'visibility','date_start','time_start','due_date','time_end','assigned_user_id','id','activitytype','recurringtype'));
		$query = $queryGenerator->getQuery();

		$query.= " AND vtiger_activity.activitytype NOT IN ('Emails','Task') AND ";
		$hideCompleted = $currentUser->get('hidecompletedevents');
		if($hideCompleted)
			$query.= "vtiger_activity.eventstatus != 'Held' AND ";

		$query.= " CONCAT(date_start,' ',time_start) <= '".$endDateTime."' AND CONCAT(due_date,' ',time_end) >= '".$startDateTime."' ";

		$params = array();
		if(empty($userid)){
			$eventUserId  = $currentUser->getId();
			$params = array_merge(array($eventUserId), $this->getGroupsIdsForUsers($eventUserId));
		}else{
			$eventUserId = $userid;
			$params = array($eventUserId);
		}

		$query.= " AND vtiger_crmentity.smownerid IN (".  generateQuestionMarks($params).")";
		$queryResult = $db->pquery($query, $params);

		while($record = $db->fetchByAssoc($queryResult)){
			$item = array();
			$crmid = $record['activityid'];
			$visibility = $record['visibility'];
			$activitytype = $record['activitytype'];
			$status = vtranslate($record['eventstatus'],'Events');
			$ownerId = $record['smownerid'];
			//$item['id'] = $crmid;
			$item['id'] = vtws_getWebserviceEntityId('Events',$crmid);
			$item['visibility'] = $visibility;
			$item['activitytype'] = $activitytype;
			$item['status'] = $status;
			$recordBusy = true;
			if(in_array($ownerId, $groupsIds)) {
				$recordBusy = false;
			} else if($ownerId == $currentUser->getId()){
				$recordBusy = false;
			}
			// if the user is having view all permission then it should show the record
			// as we are showing in detail view
			if($profileGlobalPermission[1] ==0 || $profileGlobalPermission[2] ==0) {
				$recordBusy = false;
			}

			if(!$currentUser->isAdminUser() && $visibility == 'Private' && $userid && $userid != $currentUser->getId() && $recordBusy) {
				$item['title'] = decode_html($userName).' - '.decode_html(vtranslate('Busy','Events')).'*';
				//$item['url']   = '';
			} else {
				$item['title'] = decode_html($record['subject']);
				//$item['url']   = sprintf('index.php?module=Calendar&view=Detail&record=%s', $crmid);
			}

			$isFutureEvents = false;
           	$startDateTimes = $record['date_start'].' '.$record['time_start'];
            if(strtotime($startDateTimes) > strtotime($currentDateTime)){
            	$isFutureEvents = true;
            }
			$item['start'] = Vtiger_Util_Helper::convertDateTimeIntoUsersDisplayFormat($record['date_start'].' '.$record['time_start']);
			$item['end'] = Vtiger_Util_Helper::convertDateTimeIntoUsersDisplayFormat($record['due_date'].' '.$record['time_end']);

			$item['color'] = $color;
			$item['module'] = $moduleModel->getName();
			$item['modulelabel'] = vtranslate($moduleModel->getName(),$moduleModel->getName());
			$item['moduleicon'] = CTMobile_WS_Utils::getModuleURL($moduleModel->getName());
			$item['isShowStatus'] = true;
			$item['isShowCheckin'] = true;
			if($record['eventstatus'] == 'Held'){
				$item['isShowCheckin'] = false;
			}
			$attendance_data = $this->attendance_status($crmid);
			$item['ctattendance_status'] = $attendance_data['ctattendance_status'];
			$item['attendance_status'] = $attendance_data['attendance_status'];
			if($attendance_data['ctattendanceid'] != ''){
				$item['ctattendanceid'] = CTMobile_WS_Utils::getEntityModuleWSId('CTAttendance').'x'.$attendance_data['ctattendanceid'];
			}else{
				$item['ctattendanceid'] = $attendance_data['ctattendanceid'];
			}
			$item['isFutureEvents'] = $isFutureEvents;
			$item['hour_format'] = $currentUser->get('hour_format');
			if(Users_Privileges_Model::isPermitted('Calendar', 'DetailView', $crmid)){
				$result[] = $item;
			}
		}
	}

	protected function pullMultipleEvents($start, $end, &$result, $data) {

		foreach ($data as $id=>$backgroundColorAndTextColor) {
			$userEvents = array();
			$colorComponents = explode(',',$backgroundColorAndTextColor);
			$this->pullEvents($start, $end, $userEvents ,$id, $colorComponents[0], $colorComponents[2]);
			$result[$id] = $userEvents;
		}
	}

	protected function pullTasks($start, $end, &$result, $color = null) {
		global $current_user;
		$current_user = $this->getActiveUser();
		$startDateTime = Vtiger_Datetime_UIType::getDBDateTimeValue($start . ' 00:00:00');
		$endDateTime = Vtiger_Datetime_UIType::getDBDateTimeValue($end . ' 23:59:00');

		$dbStartDateTimeComponents = explode(' ', $startDateTime);
		$dbStartDate = $dbStartDateTimeComponents[0];

		$dbEndDateTimeComponents = explode(' ', $endDateTime);
		$dbEndDate = $dbEndDateTimeComponents[0];

		$db = PearDatabase::getInstance();
		$currentUser = Users_Record_Model::getCurrentUserModel();
		$moduleModel = Vtiger_Module_Model::getInstance('Calendar');
		$userAndGroupIds = array_merge(array($currentUser->getId()),$this->getGroupsIdsForUsers($currentUser->getId()));
		$queryGenerator = new QueryGenerator($moduleModel->get('name'), $currentUser);

		$queryGenerator->setFields(array('activityid','subject', 'taskstatus','activitytype', 'date_start','time_start','due_date','time_end','id'));
		$query = $queryGenerator->getQuery();

		$query.= " AND vtiger_activity.activitytype = 'Task' AND ";
		$hideCompleted = $currentUser->get('hidecompletedevents');
		if($hideCompleted)
			$query.= "vtiger_activity.status != 'Completed' AND ";

		$query.= " CONCAT(date_start,' ',time_start) <= '".$endDateTime."' AND date_start >= '".$dbStartDate."' AND due_date <= '".$dbEndDate."' ";
		//$query.= " ((date_start >= '$start' AND due_date < '$end') OR ( due_date >= '$start'))";
		$params = array($currentUser->getId());
		$query.= " AND vtiger_crmentity.smownerid IN (".generateQuestionMarks($params).")";
		$queryResult = $db->pquery($query,$params);

		while($record = $db->fetchByAssoc($queryResult)){
			$item = array();
			$crmid = $record['activityid'];
			$item['title'] = decode_html($record['subject']);
			$item['status'] = vtranslate($record['status'],'Calendar');
			$item['activitytype'] = $record['activitytype'];
			//$item['id'] = $crmid;
			$item['id'] = vtws_getWebserviceEntityId('Calendar',$crmid);

			$item['start'] = Vtiger_Util_Helper::convertDateTimeIntoUsersDisplayFormat($record['date_start'].' '.$record['time_start']);
			$item['end'] =  Vtiger_Date_UIType::getDisplayDateValue($record['due_date']);

			$test_start = explode(' ',$item['start']);
			if(!(strtotime($start) >= strtotime($test_start[0])  && strtotime($start) <= strtotime($item['end']))){
				continue;
			}
			$item['color'] = $color;
			$item['module'] = $moduleModel->getName();
			$item['modulelabel'] = vtranslate($moduleModel->getName(),$moduleModel->getName());
			$item['moduleicon'] = CTMobile_WS_Utils::getModuleURL($moduleModel->getName());
			$item['isShowStatus'] = true;
			$item['isShowCheckin'] = false;
			$item['hour_format'] = $currentUser->get('hour_format');
			if(Users_Privileges_Model::isPermitted('Calendar', 'DetailView', $crmid)){
				$result[] = $item;
			}
		}
	}

	protected function pullPotentials($start, $end, &$result, $color = null,$textColor = 'white') {
		global $current_user;
		$current_user = $this->getActiveUser();
		$currentUser = Users_Record_Model::getCurrentUserModel();
		$start = Vtiger_Date_UIType::getDBInsertedValue($start);
		$end = Vtiger_Date_UIType::getDBInsertedValue($end);
		$query = "SELECT potentialname,closingdate FROM Potentials";
		$query.= " WHERE closingdate >= '$start' AND closingdate <= '$end'";
		$records = $this->queryForRecords($query);
		foreach ($records as $record) {
			$item = array();
			list ($modid, $crmid) = vtws_getIdComponents($record['id']);
			$item['id'] = $record['id'];
			$item['title'] = decode_html($record['potentialname']);
			$item['start'] = Vtiger_Date_UIType::getDisplayDateValue($record['closingdate']);
			$item['end'] = '';
			$item['status'] = "";
			$item['isShowStatus'] = false;
			$item['module'] = 'Potentials';
			$item['modulelabel'] = vtranslate('Potentials','Potentials');
			$item['moduleicon']   = CTMobile_WS_Utils::getModuleURL('Potentials');
			$item['color'] = $color;
			$item['isShowCheckin'] = false;
			$item['hour_format'] = $currentUser->get('hour_format');
			$result[] = $item;
		}
	}

	protected function pullContacts($start, $end, &$result, $color = null,$textColor = 'white') {
		$this->pullContactsBySupportEndDate($start, $end, $result, $color, $textColor);
		$this->pullContactsByBirthday($start, $end, $result, $color, $textColor);
	}

	protected function pullContactsBySupportEndDate($start, $end, &$result, $color = null,$textColor = 'white') {
		global $current_user;
		$current_user = $this->getActiveUser();
		$currentUser = Users_Record_Model::getCurrentUserModel();
		$start = Vtiger_Date_UIType::getDBInsertedValue($start);
		$end = Vtiger_Date_UIType::getDBInsertedValue($end);
		$query = "SELECT firstname,lastname,support_end_date FROM Contacts";
		$query.= " WHERE support_end_date >= '$start' AND support_end_date <= '$end'";
		$records = $this->queryForRecords($query);
		foreach ($records as $record) {
			$item = array();
			list ($modid, $crmid) = vtws_getIdComponents($record['id']);
			$item['id'] =  $record['id'];
			$item['title'] = decode_html(trim($record['firstname'] . ' ' . $record['lastname']));
			$item['start'] = Vtiger_Date_UIType::getDisplayDateValue($record['support_end_date']);
			$item['end'] = '';
			$item['status'] = "";
			$item['isShowStatus'] = false;
			$item['module'] = 'Contacts';
			$item['modulelabel'] = vtranslate('Contacts','Contacts');
			$item['moduleicon']   = CTMobile_WS_Utils::getModuleURL('Contacts');
			$item['color'] = $color;
			$item['isShowCheckin'] = false;
			$item['hour_format'] = $currentUser->get('hour_format');
			$result[] = $item;
		}
	}

	protected  function pullContactsByBirthday($start, $end, &$result, $color = null,$textColor = 'white') {
		global $current_user;
		$current_user = $this->getActiveUser();
		$currentUser = Users_Record_Model::getCurrentUserModel();
		$db = PearDatabase::getInstance();
		$user = Users_Record_Model::getCurrentUserModel();
		$start = Vtiger_Date_UIType::getDBInsertedValue($start);
		$end = Vtiger_Date_UIType::getDBInsertedValue($end);
		$startDateComponents = split('-', $start);
		$endDateComponents = split('-', $end);
        
        $userAndGroupIds = array_merge(array($user->getId()),$this->getGroupsIdsForUsers($user->getId()));
        $params = array($start,$end,$start,$end);
        $params = array_merge($userAndGroupIds, $params);
        
		$year = $startDateComponents[0];

		$query = "SELECT firstname,lastname,birthday,crmid FROM vtiger_contactdetails";
		$query.= " INNER JOIN vtiger_contactsubdetails ON vtiger_contactdetails.contactid = vtiger_contactsubdetails.contactsubscriptionid";
		$query.= " INNER JOIN vtiger_crmentity ON vtiger_contactdetails.contactid = vtiger_crmentity.crmid";
		$query.= " WHERE vtiger_crmentity.deleted=0 AND smownerid IN (".  generateQuestionMarks($userAndGroupIds) .") AND";
		$query.= " ((CONCAT('$year-', date_format(birthday,'%m-%d')) >= ?
						AND CONCAT('$year-', date_format(birthday,'%m-%d')) <= ?)";

        
		$endDateYear = $endDateComponents[0];
		if ($year !== $endDateYear) {
			$query .= " OR
						(CONCAT('$endDateYear-', date_format(birthday,'%m-%d')) >= ?
							AND CONCAT('$endDateYear-', date_format(birthday,'%m-%d')) <= ?)";
		}
		$query .= ")";

		$queryResult = $db->pquery($query, $params);

		while($record = $db->fetchByAssoc($queryResult)){
			$item = array();
			$crmid = $record['crmid'];
			$recordDateTime = new DateTime($record['birthday']);

			$calendarYear = $year;
			if($recordDateTime->format('m') < $startDateComponents[1]) {
				$calendarYear = $endDateYear;
			}
			$recordDateTime->setDate($calendarYear, $recordDateTime->format('m'), $recordDateTime->format('d'));
			$item['id'] = vtws_getWebserviceEntityId('Contacts',$crmid);
			$item['title'] = decode_html(trim($record['firstname'] . ' ' . $record['lastname']));
			$item['start'] = Vtiger_Date_UIType::getDisplayDateValue($recordDateTime->format('Y-m-d'));
			$item['end'] = '';
			$item['status'] = "";
			$item['isShowStatus'] = false;
			$item['module'] = 'Contacts';
			$item['modulelabel'] = vtranslate('Contacts','Contacts');
			$item['moduleicon']   = CTMobile_WS_Utils::getModuleURL('Contacts');
			$item['color'] = $color;
			$item['isShowCheckin'] = false;
			$item['hour_format'] = $currentUser->get('hour_format');
			$result[] = $item;
		}
	}

	protected function pullInvoice($start, $end, &$result, $color = null,$textColor = 'white') {
		global $current_user;
		$current_user = $this->getActiveUser();
		$currentUser = Users_Record_Model::getCurrentUserModel();
		$start = Vtiger_Date_UIType::getDBInsertedValue($start);
		$end = Vtiger_Date_UIType::getDBInsertedValue($end);
		$query = "SELECT subject,duedate FROM Invoice";
		$query.= " WHERE duedate >= '$start' AND duedate <= '$end'";
		$records = $this->queryForRecords($query);
		foreach ($records as $record) {
			$item = array();
			list ($modid, $crmid) = vtws_getIdComponents($record['id']);
			$item['id'] = $record['id'];
			$item['title'] = decode_html($record['subject']);
			$item['start'] = Vtiger_Date_UIType::getDisplayDateValue($record['duedate']);
			$item['end'] = '';
			$item['status'] = "";
			$item['isShowStatus'] = false;
			$item['module'] = 'Invoice';
			$item['modulelabel'] = vtranslate('Invoice','Invoice');
			$item['moduleicon']   = CTMobile_WS_Utils::getModuleURL('Invoice');
			$item['color'] = $color;
			$item['isShowCheckin'] = false;
			$item['hour_format'] = $currentUser->get('hour_format');
			$result[] = $item;
		}
	}

	/**
	 * Function to pull all the current user projects
	 * @param type $startdate
	 * @param type $actualenddate
	 * @param type $result
	 * @param type $color
	 * @param type $textColor
	 */
	protected function pullProjects($start, $end, &$result, $color = null,$textColor = 'white') {
		global $current_user;
		$current_user = $this->getActiveUser();
		$currentUser = Users_Record_Model::getCurrentUserModel();
		$db = PearDatabase::getInstance();
		$user = Users_Record_Model::getCurrentUserModel();
		$start = Vtiger_Date_UIType::getDBInsertedValue($start);
		$end = Vtiger_Date_UIType::getDBInsertedValue($end);
		$userAndGroupIds = array_merge(array($user->getId()),$this->getGroupsIdsForUsers($user->getId()));
        $params = array($start,$end);
        $params = array_merge($userAndGroupIds, $params);
        
		$query = "SELECT projectname, startdate, targetenddate, crmid FROM vtiger_project";
		$query.= " INNER JOIN vtiger_crmentity ON vtiger_project.projectid = vtiger_crmentity.crmid";
		$query.= " WHERE vtiger_crmentity.deleted=0 AND smownerid IN (". generateQuestionMarks($userAndGroupIds) .") AND ";
		$query.= " ((startdate <= ? AND targetenddate >= ?))";
		$queryResult = $db->pquery($query, $params);

		while($record = $db->fetchByAssoc($queryResult)){
			$item = array();
			$crmid = $record['crmid'];
			$item['id'] = vtws_getWebserviceEntityId('Project',$crmid);
			$item['title'] = decode_html($record['projectname']);
			$item['start'] = Vtiger_Date_UIType::getDisplayDateValue($record['startdate']);
			$item['end'] = Vtiger_Date_UIType::getDisplayDateValue($record['targetenddate']);
			$item['status'] = "";
			$item['isShowStatus'] = false;
			$item['module'] = 'Project';
			$item['modulelabel'] = vtranslate('Project','Project');
			$item['moduleicon']   = CTMobile_WS_Utils::getModuleURL('Project');
			$item['color'] = $color;
			$item['isShowCheckin'] = false;
			$item['hour_format'] = $currentUser->get('hour_format');
			$result[] = $item;
		}
	}

	/**
	 * Function to pull all the current user porjecttasks
	 * @param type $startdate
	 * @param type $enddate
	 * @param type $result
	 * @param type $color
	 * @param type $textColor
	 */
	protected function pullProjectTasks($start, $end, &$result, $color = null,$textColor = 'white') {
		global $current_user;
		$current_user = $this->getActiveUser();
		$currentUser = Users_Record_Model::getCurrentUserModel();
		$db = PearDatabase::getInstance();
		$user = Users_Record_Model::getCurrentUserModel();
		$start = Vtiger_Date_UIType::getDBInsertedValue($start);
		$end = Vtiger_Date_UIType::getDBInsertedValue($end);
        $userAndGroupIds = array_merge(array($user->getId()),$this->getGroupsIdsForUsers($user->getId()));
         $params = array($start,$end,$start);
        $params = array_merge($params, $userAndGroupIds);
		
		$query = "SELECT projecttaskname, startdate, enddate, crmid FROM vtiger_projecttask";
		$query.= " INNER JOIN vtiger_crmentity ON vtiger_projecttask.projecttaskid = vtiger_crmentity.crmid";
		$query.= " WHERE vtiger_crmentity.deleted=0 AND ";
		$query.= " ((startdate >= ? AND enddate < ?) OR ( enddate >= ?))";
                $query.= " AND smownerid IN (". generateQuestionMarks($userAndGroupIds) .")";
		$queryResult = $db->pquery($query, $params);

		while($record = $db->fetchByAssoc($queryResult)){
			$item = array();
			$crmid = $record['crmid'];
			$item['id'] = vtws_getWebserviceEntityId('ProjectTask',$crmid);
			$item['title'] = decode_html($record['projecttaskname']);
			$item['start'] = Vtiger_Date_UIType::getDisplayDateValue($record['startdate']);
			$item['end'] = Vtiger_Date_UIType::getDisplayDateValue($record['targetenddate']);
			$item['status'] = "";
			$item['isShowStatus'] = false;
			$item['module'] = 'ProjectTask';
			$item['modulelabel'] = vtranslate('ProjectTask','ProjectTask');
			$item['moduleicon']   = CTMobile_WS_Utils::getModuleURL('ProjectTask');
			$item['color'] = $color;
			$item['isShowCheckin'] = false;
			$item['hour_format'] = $currentUser->get('hour_format');
			$result[] = $item;
		}
	}

	function attendance_status($recordid){
		global $current_user,$adb, $site_URL;
		$current_user = $this->getActiveUser();
		$employee_name = $current_user->id;

		$user =  Users::getActiveAdminUser();
		$recentEvent_data = array();
		$generator = new QueryGenerator('CTAttendance', $user);
		$generator->setFields(array('employee_name','attendance_status','createdtime','modifiedtime','id'));
		//$generator->addCondition('attendance_status', 'check_in', 'e');
		$eventQuery = $generator->getQuery();
		$eventQuery .= " AND vtiger_ctattendance.employee_name = '$employee_name' AND vtiger_ctattendance.eventid = '$recordid'";
		
		$query = $adb->pquery($eventQuery);
		$num_rows = $adb->num_rows($query);
		if( $num_rows > 0){
			$ctattendanceid = $adb->query_result($query,$num_rows-1,'ctattendanceid');
			$ctattendance_status = $adb->query_result($query,$num_rows-1,'attendance_status');
			$attendance_status = true;
		} else {
			$ctattendance_status = "";
			$attendance_status = false;
			$ctattendanceid = '';
		}
		$data = array();
		$data['attendance_status'] = vtranslate($ctattendance_status,'CTAttendance');
		$data['ctattendance_status'] = $attendance_status;
		$data['ctattendanceid'] = $ctattendanceid;
		if($ctattendance_status == 'check_out'){
			$data['ctattendance_status'] = false;
			$data['ctattendanceid'] = "";
		}
		return $data;
	}
}
