<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobile_WS_MarkChatImportant extends CTMobile_WS_Controller {
	
	function process(CTMobile_API_Request $request) {
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		global $current_user, $adb; // Few core API assumes this variable availability
		$current_user = $this->getActiveUser();
		$recordId = $request->get('recordId');
		$setype = VtigerCRMObject::getSEType($recordId);
		$ChatId = $request->get('ChatId');
		$important = $request->get('important');
		$customQuery = 	" UPDATE vtiger_whatsapplog SET whatsapplog_important = '".$important."'";
		if($setype){
            $customQuery.= ' WHERE whatsapplog_contactid = ?';
            $updateQuery = $adb->pquery($customQuery, array($recordId));
        }else{
            $customQuery.= ' WHERE whatsapplog_withccode = ?';
            $updateQuery = $adb->pquery($customQuery, array($ChatId));
        }
		if($important){
			$message = "Marked chat as Important";
			$message = $this->CTTranslate($message);
			$isImportant = true;
		}else{
			$message = "Unmarked chat as Important";
			$message = $this->CTTranslate($message);
			$isImportant = false;
		}
		$response = new CTMobile_API_Response();
		$response->setResult(array("message"=>$message,'isImportant'=>$isImportant));
		return $response;
	}

}
