<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

include_once dirname(__FILE__) . '/models/SearchFilter.php';

class CTMobile_WS_WhatsAppMessageList extends CTMobile_WS_Controller {
	
	function process(CTMobile_API_Request $request) {
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		global $current_user, $adb, $site_URL; // Few core API assumes this variable availability
		$current_user = $this->getActiveUser();
		$ausers = Users::getActiveAdminUser();
		$currenUserID = $current_user->id;
		$licenseData = CTWhatsApp_Record_Model::getWhatsAppLicenseDetail();
        $configurationData = Settings_CTWhatsApp_Record_Model::getUserConfigurationAllDataWithId($currenUserID);
        $expirydate = Settings_CTWhatsApp_ConfigurationDetail_View::encrypt_decrypt($licenseData['expiryDate'], $action='d');
        $connectedNumberDetails = array();
        $connectedNumberDetails['authtoken'] = $configurationData['authtoken'];
        $connectedNumberDetails['whatsappstatus'] = $configurationData['whatsappstatus'];
        $connectedNumberDetails['whatsappno'] = $configurationData['whatsappno'];
        $connectedNumberDetails['api_url'] = $configurationData['api_url'];
        $connectedNumberDetails['expirydate'] = $expirydate;
        if(strtotime($expirydate) < strtotime(date('Y-m-d'))){
        	$connectedNumberDetails['license_expired'] = 1;
        }else{
        	$connectedNumberDetails['license_expired'] = 0;
        }
		$activeNumbers = $this->getActiveNumber($current_user);

		$roleid = $current_user->roleid;
		$time_zone = $current_user->time_zone;
		$module = trim($request->get('module'));
		$ChatId = trim($request->get('ChatId'));
		$recordid = trim($request->get('recordid'));
		$index = trim($request->get('index'));
		$size = trim($request->get('size'));

		$customView = new CustomView();
		$filterid = $customView->getViewId($module);
		$filterOrAlertInstance = CTMobile_WS_FilterModel::modelWithId($module, $filterid);

		$whatsAppAllNumber = CTWhatsApp_Record_Model::getAllConnectedWhatsappNumber($currenUserID);
        $inNumber = '';
        foreach ($whatsAppAllNumber as $key => $value) {
            $inNumber .= "'".$value['whatsappno']."',";
        }
        $allnumber = rtrim($inNumber, ',');
        $inNumberQuery = ' AND vc.whatsapplog_your_number IN ('.$allnumber.') ';
		$generator = new QueryGenerator($module, $ausers);
		$generator->setFields($morefields);
		$query = $generator->getQuery();
		$explodeQuery = explode('FROM', $query);
		if (strpos($ChatId, '@g.us') !== false) {
		    $customQuery = 	" AND vtiger_ctwhatsapp.msgid = '".$ChatId."' AND vtiger_ctwhatsapp.your_number IN (".$allnumber.") ";
		}else{
			$ChatId = str_replace('(','',$ChatId);
			$ChatId = str_replace(' ','',$ChatId);
			$ChatId = str_replace(')','',$ChatId);
			$ChatId = str_replace('-','',$ChatId);
			$ChatId = str_replace('+','',$ChatId);
			$customQuery = 	" AND vtiger_ctwhatsapp.whatsapp_withccode = '".$ChatId."' AND vtiger_ctwhatsapp.your_number IN (".$allnumber.")";
		}

		if($recordid != ""){
			$customQuery.=" AND vtiger_ctwhatsapp.whatsapp_contactid = '$recordid' ";
		}
		
		$queryResult = $adb->pquery("SELECT * FROM ".$explodeQuery[1]." ".$customQuery. " AND  GROUP BY DATE(vtiger_ctwhatsapp.whatsapp_datetime) ORDER BY vtiger_ctwhatsapp.whatsapp_datetime DESC", array());

		if($index != '' && $size != ''){
			if($index == 0){
				$index = 1;
			}
			$limit = ($index*$size) - $size;

			$limitQuery = "SELECT * FROM ".$explodeQuery[1]." ".$customQuery. " GROUP BY DATE(vtiger_ctwhatsapp.whatsapp_datetime) ORDER BY vtiger_ctwhatsapp.whatsapp_datetime DESC LIMIT ".$limit.", ".$size;

			$totalQuery = "SELECT * FROM ".$explodeQuery[1]." ".$customQuery. " GROUP BY DATE(vtiger_ctwhatsapp.whatsapp_datetime) ORDER BY vtiger_ctwhatsapp.whatsapp_datetime DESC";
		}else{
			$limitQuery = "SELECT * FROM ".$explodeQuery[1]." ".$customQuery. " GROUP BY DATE(vtiger_ctwhatsapp.whatsapp_datetime) ORDER BY vtiger_ctwhatsapp.whatsapp_datetime DESC";
			$totalQuery = '';
		}

		$queryResult = $adb->pquery($limitQuery, array());
		$rows = $adb->num_rows($queryResult);
		$isLast = true;
		$totalLabel = "";
		if($totalQuery != ""){
			$totalResults = $adb->pquery($totalQuery);
			$totalRecords = $adb->num_rows($totalResults);
			if($index && $size){
				if($totalRecords > $index*$size){
					$isLast = false;	
					$pagesize = $index-1;
					$startRange = $pagesize*$size+1;
					$lastRange = $index*$size;	
				}else{
					$isLast = true;
					$pagesize = $index-1;
					$startRange = $pagesize*$size+1;
					$lastRange = $totalRecords;
				}
			}else{
				$isLast = true;
				$startRange = 1;
				$lastRange = $totalRecords;
			}

			$totalLabel = $startRange.' '.vtranslate('LBL_to', $module).' '.$lastRange.' '.vtranslate('LBL_OF', $module).' '.$totalRecords;
		}

		$whatsAppMessageList = array();
		for ($i=0; $i < $rows; $i++) {  
			$messageDateTime = explode(' ', $adb->query_result($queryResult, $i, 'whatsapp_datetime'));
			$whatsapp_withccode = $adb->query_result($queryResult, $i, 'whatsapp_withccode');
			$whatsapplog_important = 0;
			if($whatsapp_withccode == 'Groups'){
				$msgid = $adb->query_result($queryResult, $i, 'msgid');
				$getGroupname = $adb->pquery("SELECT * FROM vtiger_whatsapplog 
					INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_whatsapplog.whatsapplogid 
					WHERE vtiger_whatsapplog.whatsapplog_msgid = '".$msgid."' AND vtiger_crmentity.deleted = 0", array());
				$groupRow = $adb->num_rows($getGroupname);
				if($groupRow){
					$label = $adb->query_result($getGroupname, 0, 'whatsapplog_chatid');
					$imagePath = $adb->query_result($getGroupname, 0, 'whatsapplog_quotemessage');
					$whatsapplog_important = $adb->query_result($getGroupname, 0, 'whatsapplog_important');
				}
				$isGroup = 1;
				$ChatId = $ChatId;
				$message_body = $adb->query_result($queryResult, $i, 'message_body');
				$whatsapp_datetime = $adb->query_result($queryResult, $i, 'whatsapp_datetime');
				
			}else{
				if($recordid != ""){
					$getRecord = $adb->pquery("SELECT * FROM vtiger_whatsapplog 
						INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_whatsapplog.whatsapplogid 
						WHERE vtiger_whatsapplog.whatsapplog_withccode = '".$ChatId."' AND vtiger_crmentity.deleted = 0 AND whatsapplog_contactid = '".$recordid."' AND vtiger_whatsapplog.whatsapplog_your_number IN (".$allnumber.") ORDER BY whatsapplogid DESC", array());
					$RecordRow = $adb->num_rows($getRecord);
				}else{
					$getRecord = $adb->pquery("SELECT * FROM vtiger_whatsapplog 
						INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_whatsapplog.whatsapplogid 
						WHERE vtiger_whatsapplog.whatsapplog_withccode = '".$ChatId."' AND vtiger_crmentity.deleted = 0 AND whatsapplog_contactid != '' AND vtiger_whatsapplog.whatsapplog_your_number IN (".$allnumber.") ORDER BY whatsapplogid DESC", array());
					$RecordRow = $adb->num_rows($getRecord);
				}
				if($RecordRow){
					$whatsapp_contactid = $adb->query_result($getRecord, 0, 'whatsapplog_contactid');
					$whatsapplog_important = $adb->query_result($getRecord, 0, 'whatsapplog_important');
					$setype = VtigerCRMObject::getSEType($whatsapp_contactid);
					if($setype){
						if(!Users_Privileges_Model::isPermitted($setype, 'DetailView', $whatsapp_contactid)){
							$whatsapp_contactid = "";
						}
					}
				}
				
				//$whatsapp_contactid = $adb->query_result($queryResult, $i, 'whatsapp_contactid');
				if ($whatsapp_contactid) {
		            $sql = "SELECT vtiger_attachments.*, vtiger_crmentity.setype FROM vtiger_attachments
		                INNER JOIN vtiger_seattachmentsrel ON vtiger_seattachmentsrel.attachmentsid = vtiger_attachments.attachmentsid
		                INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_attachments.attachmentsid
		                WHERE vtiger_seattachmentsrel.crmid = ?";

		            $result = $adb->pquery($sql, array($whatsapp_contactid));

		            $imageId = $adb->query_result($result, 0, 'attachmentsid');
		            $imagePath = $adb->query_result($result, 0, 'path');
		            $imageName = $adb->query_result($result, 0, 'name');

		            //decode_html - added to handle UTF-8 characters in file names
		            $imageOriginalName = urlencode(decode_html($imageName));

		            if(!empty($imageName)){
		                $imageDetails[] = array(
		                    'id' => $imageId,
		                    'orgname' => $imageOriginalName,
		                    'path' => $imagePath.$imageId,
		                    'name' => $imageName
		                );
		                $imagePath = $site_URL.'/'.$imagePath.$imageId.'_'.$imageName;
		            }
		            $checkDeleted = $adb->pquery("SELECT crmid FROM vtiger_crmentity WHERE crmid = ? and deleted = 0",array($whatsapp_contactid));
		            if($adb->num_rows($checkDeleted)){
		            	$setype = VtigerCRMObject::getSEType($whatsapp_contactid);
			            $moduleRecordModel = Vtiger_Record_Model::getInstanceById($whatsapp_contactid);
			            $entityQuery = $adb->pquery("SELECT * FROM vtiger_entityname WHERE modulename = ?",array($setype));
						$entityField = $adb->query_result($entityQuery,0,'fieldname');
						$entityField_array = explode(',',$entityField);
						$entityField = $entityField_array[0];
						if(count($entityField_array) == 2){
							$label = $moduleRecordModel->get($entityField_array[0])." ".$moduleRecordModel->get($entityField_array[1]);
						}else{
			            	$label = $moduleRecordModel->get($entityField);
						}
			            $wsid = CTMobile_WS_Utils::getEntityModuleWSId($moduleRecordModel->getModuleName()).'x'.$whatsapp_contactid;
			            $editAction = Users_Privileges_Model::isPermitted($moduleRecordModel->getModuleName(), 'EditView', $whatsapp_contactid);
			            $modCommentsModel = Vtiger_Module_Model::getInstance('ModComments');
			            $commentModuleAccess = $modCommentsModel->isPermitted('EditView');
			            $crmRecord = array('id'=>$whatsapp_contactid,'wsid'=>$wsid,'label'=>$label,'module'=>$moduleRecordModel->getModuleName(),'modulelabel'=>vtranslate($moduleRecordModel->getModuleName(),$moduleRecordModel->getModuleName()),'editAction'=>$editAction,'CommentAccess'=>$commentModuleAccess);
			            $createModules = array();
			            $createRelatedModules = array();
			            $relatedModules = CTWhatsApp_Record_Model::getRelatedModules($moduleRecordModel->getModuleName());
			            foreach ($relatedModules as $rkey => $relatedModule) {
			            	$relatedModule['relatedModulelabel'] = vtranslate($relatedModule['relatedModule'],$relatedModule['relatedModule']);
			            	$createRelatedModules[] = $relatedModule;
			            }
		            }else{
		            	$imagePath = '';
			        	$label = $whatsapp_withccode;
			        	$crmRecord = array();
			        	$relatedModules = CTWhatsApp_Record_Model::getWhatsappAllowModules();
			        	$createModules = array();
			        	$createRelatedModules = array();
			        	foreach ($relatedModules as $rkey => $relatedModule) {
			        		$relatedModule['modulelabel'] = vtranslate($relatedModule['module'],$relatedModule['module']);
			            	$createModules[] = $relatedModule;
			            }
		            }
		        }else{
		        	$imagePath = '';
		        	if($recordid == ""){
		        		$label = $whatsapp_withccode;
		        	}
		        	$crmRecord = array();
		        	$relatedModules = CTWhatsApp_Record_Model::getWhatsappAllowModules();
		        	$createModules = array();
		        	$createRelatedModules = array();
		        	foreach ($relatedModules as $rkey => $relatedModule) {
		        		$relatedModule['modulelabel'] = vtranslate($relatedModule['module'],$relatedModule['module']);
		            	$createModules[] = $relatedModule;
		            }
		        }

		        $isGroup = 0;
				$ChatId = $ChatId;
				$whatsapp_datetime = $adb->query_result($queryResult, $i, 'whatsapp_datetime');
			}

			if (strpos($ChatId, '@g.us') !== false) {
			    $getMesssageQuery = " AND vtiger_ctwhatsapp.msgid = '".$ChatId."' AND vtiger_ctwhatsapp.your_number IN (".$allnumber.") AND DATE(vtiger_ctwhatsapp.whatsapp_datetime) = '".$messageDateTime[0]."'";
			}else{
				$getMesssageQuery = " AND vtiger_ctwhatsapp.whatsapp_withccode = '".$ChatId."' AND vtiger_ctwhatsapp.your_number IN (".$allnumber.") AND DATE(vtiger_ctwhatsapp.whatsapp_datetime) = '".$messageDateTime[0]."'";
			}

			$getAllMessageQuery = $adb->pquery("SELECT * FROM ".$explodeQuery[1]." ".$getMesssageQuery." ORDER BY vtiger_ctwhatsapp.whatsapp_datetime DESC");

			$messageRows = $adb->num_rows($getAllMessageQuery);

			$allMessages = array();
			for ($j=0; $j < $messageRows; $j++) { 
				$ctwhatsappid = $adb->query_result($getAllMessageQuery, $j, 'ctwhatsappid');
				$message_type = $adb->query_result($getAllMessageQuery, $j, 'message_type');
				$message_body = $adb->query_result($getAllMessageQuery, $j, 'message_body');
				$whatsapp_sendername = $adb->query_result($getAllMessageQuery, $j, 'whatsapp_sendername');
				$whatsapp_unreadread = $adb->query_result($getAllMessageQuery, $j, 'whatsapp_unreadread');
				$messageDateandTime = $adb->query_result($getAllMessageQuery, $j, 'whatsapp_datetime');
				$your_number = $adb->query_result($getAllMessageQuery, $j, 'your_number');
				$whatsapp_quotemessage = $adb->query_result($getAllMessageQuery, $j, 'whatsapp_quotemessage');
				$msgid = $adb->query_result($getAllMessageQuery, $j, 'msgid');
				$getNumberDetails = CTWhatsApp_Record_Model::getWhatsAppDetailWithMobileNo($your_number);
            	$getNumberUsername = $getNumberDetails['username'];
            	if($getNumberUsername){
            		$sendnumberwithusername = $your_number.' ('.$getNumberUsername.')';
            	}else{
            		$sendnumberwithusername = $your_number;
            	}
				if($message_type == 'Mass Message'){
					$message_type = 'Send';
				}
				$fileName = "";
				$type = "";
				$mimetype = "";
				$filesize = "";
				$pathinfo = array();
				$pathinfo = pathinfo($message_body);
				//print_r($pathinfo);
				if($pathinfo['extension']){
					/*if (function_exists('finfo_open')) {
				        $finfo = finfo_open(FILEINFO_MIME_TYPE);
				        $mimetype = finfo_file($finfo, $pathinfo['basename']);
				        finfo_close($finfo);
				    }else {
				        $mimetype = get_mime_type($pathinfo['extension']);
				    }*/
				    $mimetype = get_mime_type($pathinfo['extension']);
					$type = $pathinfo['extension'];
					$fileName = $pathinfo['basename'];
					//$message_body = urlencode($message_body);
					$message_body = str_replace(' ', '%20', $message_body);
					$result = get_remote_file_info($message_body);
					$filesize = sizeFilter($result['fileSize']);
				}
				$message_body = decode_html(decode_html(urldecode($message_body)));
				$datetime = explode(' ', Vtiger_Util_Helper::convertDateTimeIntoUsersDisplayFormat($messageDateandTime));
				if (strpos($ChatId, '@g.us') !== false) {
					$allMessages[] = array('ctwhatsappid'=>$ctwhatsappid,'msg' => $message_body,"fileName"=>$fileName,'type'=>$mimetype,"filesize"=>$filesize, 'date' => $datetime[0], 'time' => $datetime[1].' '.$datetime[2], 'isSent' => $message_type, 'isRead' => $whatsapp_unreadread,'sendername'=>$whatsapp_sendername,'sender_username'=>$sendnumberwithusername,'whatsapp_quotemessage'=>$whatsapp_quotemessage,'MessageId'=>$msgid);
				}else{
					$allMessages[] = array('ctwhatsappid'=>$ctwhatsappid,'msg' => $message_body,"fileName"=>$fileName,'type'=>$mimetype,"filesize"=>$filesize, 'date' => $datetime[0], 'time' => $datetime[1].' '.$datetime[2], 'isSent' => $message_type, 'isRead' => $whatsapp_unreadread,'sendername'=>$whatsapp_sendername,'sender_username'=>$sendnumberwithusername,'whatsapp_quotemessage'=>$whatsapp_quotemessage,'MessageId'=>$msgid);
				}

			}
			if(!empty($allMessages)){
				$whatsAppMessageList['data']['chat'][] = array('Date' => $datetime[0], 'messages' => $allMessages);
			}
		}

		if($whatsapplog_important == ""){
			$getRecord = $adb->pquery("SELECT * FROM vtiger_whatsapplog 
						INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_whatsapplog.whatsapplogid 
						WHERE vtiger_whatsapplog.whatsapplog_withccode = '".$ChatId."' AND vtiger_crmentity.deleted = 0  ORDER BY whatsapplogid DESC", array());
			$RecordRow = $adb->num_rows($getRecord);
			if($RecordRow){
				$whatsapplog_important = $adb->query_result($getRecord, 0, 'whatsapplog_important');
			}
		}
		
		if($label == "" && $recordid != ""){
			
			$getlabelsql = "SELECT setype from vtiger_crmentity WHERE crmid = ? AND deleted = 0";
			$getlabel = $adb->pquery($getlabelsql,array($recordid));
			if($adb->num_rows($getlabel) > 0){
				$setype = $adb->query_result($getlabel,0,'setype');
	            $moduleRecordModel = Vtiger_Record_Model::getInstanceById($recordid);
	            $entityQuery = $adb->pquery("SELECT * FROM vtiger_entityname WHERE modulename = ?",array($setype));
				$entityField = $adb->query_result($entityQuery,0,'fieldname');
				$entityField_array = explode(',',$entityField);
				$entityField = $entityField_array[0];
				if(count($entityField_array) == 2){
					$label = $moduleRecordModel->get($entityField_array[0])." ".$moduleRecordModel->get($entityField_array[1]);
				}else{
	            	$label = $moduleRecordModel->get($entityField);
				}

				$wsid = CTMobile_WS_Utils::getEntityModuleWSId($moduleRecordModel->getModuleName()).'x'.$recordid;
	            $editAction = Users_Privileges_Model::isPermitted($moduleRecordModel->getModuleName(), 'EditView', $recordid);
	            $modCommentsModel = Vtiger_Module_Model::getInstance('ModComments');
	            $commentModuleAccess = $modCommentsModel->isPermitted('EditView');
	            $crmRecord = array('id'=>$recordid,'wsid'=>$wsid,'label'=>$label,'module'=>$moduleRecordModel->getModuleName(),'modulelabel'=>vtranslate($moduleRecordModel->getModuleName(),$moduleRecordModel->getModuleName()),'editAction'=>$editAction,'CommentAccess'=>$commentModuleAccess);
	            $createModules = array();
	            $createRelatedModules = array();
	            $relatedModules = CTWhatsApp_Record_Model::getRelatedModules($moduleRecordModel->getModuleName());
	            foreach ($relatedModules as $rkey => $relatedModule) {
	            	$relatedModule['relatedModulelabel'] = vtranslate($relatedModule['relatedModule'],$relatedModule['relatedModule']);
	            	$createRelatedModules[] = $relatedModule;
	            }
			}
		}

		$lastStatus = "";
		$lastMessageConvertDateTime = "";
		$whatsapplog_datetime = "";
		$whatsapp_displayname = "";
		if($adb->num_rows($queryResult)){
			$whatsapplog_datetime = $adb->query_result($queryResult, 0, 'whatsapp_datetime');
			$whatsapp_displayname = $adb->query_result($queryResult, 0, 'whatsapp_displayname');
			$lastStatus = $adb->query_result($queryResult, 0, 'whatsapp_unreadread');
			$lastMessageConvertDateTime = Vtiger_Util_Helper::formatDateDiffInStrings($whatsapplog_datetime);
			if(date('Y-m-d',strtotime($whatsapplog_datetime)) == date('Y-m-d')){
				$dateArray = explode(' ',Vtiger_Util_Helper::convertDateTimeIntoUsersDisplayFormat($whatsapplog_datetime));
				if(count($dateArray) > 2){
					$whatsapplog_datetime = $dateArray[1].' '.$dateArray[2];
				}else{
					$whatsapplog_datetime = $dateArray[1];
				}
			}else{
				$dateArray = explode(' ',Vtiger_Util_Helper::convertDateTimeIntoUsersDisplayFormat($whatsapplog_datetime));
				$whatsapplog_datetime = $dateArray[0];
			}
		}


		
		if($label == null){
			$label = $ChatId;
		}
		$response = new CTMobile_API_Response();
		$results = $response->getResult();
		$results = $whatsAppMessageList;
		$results['imagePath'] = urldecode($imagePath);
		$results['label'] = $label;
		$results['isGroup'] = $isGroup;
		$ChatId = trim($request->get('ChatId'));
		$results['ChatId'] = $ChatId;
		$results['module'] = $module;
		$results['crmRecord'] = $crmRecord;
		$results['moduleLabel'] = 'WhatsApp';
		$results['lastMessageDateTime'] = $whatsapplog_datetime;
		$results['lastMessageConvertDateTime'] = $lastMessageConvertDateTime;
		$results['lastStatus'] = $lastStatus;
		$results['whatsapp_displayname'] = $whatsapp_displayname;
		$results['isLast'] = $isLast;
		$results['totalLabel'] = $totalLabel;
		$results['activeNumbers'] = $activeNumbers;
		$results['connectedDetails'] = $connectedNumberDetails;
		$results['createRecords'] = $createModules;
		$results['createRelatedRecords'] = $createRelatedModules;
		$results['whatsapplog_important'] = ($whatsapplog_important == "")?0:$whatsapplog_important;
		$results['disconnectedMessage'] = $this->CTTranslate("Ooops.. You're disconnected from WhatsApp..");
		$results['licenseExpiredMessage'] = $this->CTTranslate("Your WhatsApp license key has expired. Please activate it through the CRM.");
		$userPrivModel = Users_Privileges_Model::getInstanceById($current_user->id);
		$CTWhatsAppTemplatesModel = Vtiger_Module_Model::getInstance('CTWhatsAppTemplates');
		$CTWhatsAppTemplates = false;
		$presence = array('0', '2');
		if(($userPrivModel->isAdminUser() ||
							$userPrivModel->hasGlobalReadPermission() ||
							$userPrivModel->hasModulePermission($CTWhatsAppTemplatesModel->get('id'))) && in_array($CTWhatsAppTemplatesModel->get('presence'), $presence) ){
			$CTWhatsAppTemplates = true;
		}
		$results['CTWhatsAppTemplates'] = $CTWhatsAppTemplates;
		$response->setResult($results);
		return $response;
	}

	function getActiveNumber($current_user){
		$currenUserID = $current_user->id;
        $configurationData = Settings_CTWhatsApp_Record_Model::getUserConfigurationAllDataWithId($currenUserID);
        $allUserNumber = CTWhatsApp_Record_Model::getAllUserWhatsappNumber($currenUserID);
        $connectedNumbers = array();
        foreach ($allUserNumber as $key => $value) {
        	$configurationData = Settings_CTWhatsApp_Record_Model::getUserConfigurationAllDataWithId($value['userid']);
	        $value['authtoken'] = $configurationData['authtoken'];
	        $value['api_url'] = $configurationData['api_url'];
        	$connectedNumbers[] = $value;
        }
        return $connectedNumbers;
	}

}

function get_mime_type($idx) {
    /*$idx = explode( '.', $filename );
    $count_explode = count($idx);
    $idx = strtolower($idx[$count_explode-1]);*/

    $mimet = array( 
        'txt' => 'text/plain',
        'htm' => 'text/html',
        'html' => 'text/html',
        'php' => 'text/html',
        'css' => 'text/css',
        'csv' => 'text/csv',
        'js' => 'application/javascript',
        'json' => 'application/json',
        'xml' => 'application/xml',
        'swf' => 'application/x-shockwave-flash',
        'flv' => 'video/x-flv',

        // images
        'png' => 'image/png',
        'jpe' => 'image/jpeg',
        'jpeg' => 'image/jpeg',
        'jpg' => 'image/jpeg',
        'gif' => 'image/gif',
        'bmp' => 'image/bmp',
        'ico' => 'image/vnd.microsoft.icon',
        'tiff' => 'image/tiff',
        'tif' => 'image/tiff',
        'svg' => 'image/svg+xml',
        'svgz' => 'image/svg+xml',

        // archives
        'zip' => 'application/zip',
        'rar' => 'application/x-rar-compressed',
        'exe' => 'application/x-msdownload',
        'msi' => 'application/x-msdownload',
        'cab' => 'application/vnd.ms-cab-compressed',

        // audio/video
        'mp3' => 'audio/mpeg',
        'qt' => 'video/quicktime',
        'mov' => 'video/quicktime',
        'avi' => 'video/x-msvideo',
        'mp4' => 'video/mp4',
        'mpeg' => 'video/mpeg',
        'ogv' => 'video/ogg',
        'oga' => 'audio/ogg',
        'webm' => 'video/webm',
        'm4a'=> 'audio/m4a',
        

        // adobe
        'pdf' => 'application/pdf',
        'psd' => 'image/vnd.adobe.photoshop',
        'ai' => 'application/postscript',
        'eps' => 'application/postscript',
        'ps' => 'application/postscript',

        // ms office
        'doc' => 'application/msword',
        'rtf' => 'application/rtf',
        'xls' => 'application/vnd.ms-excel',
        'ppt' => 'application/vnd.ms-powerpoint',
        'docx' => 'application/msword',
        'xlsx' => 'application/vnd.ms-excel',
        'pptx' => 'application/vnd.ms-powerpoint',


        // open office
        'odt' => 'application/vnd.oasis.opendocument.text',
        'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
    );

    if (isset( $mimet[$idx] )) {
     return $mimet[$idx];
    } else {
     return '';
    }
 }

 function get_remote_file_info($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, TRUE);
    curl_setopt($ch, CURLOPT_NOBODY, TRUE);
    $data = curl_exec($ch);
    $fileSize = curl_getinfo($ch, CURLINFO_CONTENT_LENGTH_DOWNLOAD);
    $httpResponseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return [
        'fileExists' => (int) $httpResponseCode == 200,
        'fileSize' => (int) $fileSize
    ];
}

function sizeFilter( $bytes )
{
    $label = array( 'B', 'KB', 'MB', 'GB', 'TB', 'PB' );
    for( $i = 0; $bytes >= 1024 && $i < ( count( $label ) -1 ); $bytes /= 1024, $i++ );
    return( round( $bytes, 2 ) . " " . $label[$i] );
}