<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once 'vtlib/Vtiger/Module.php';

class CTMobileSettings extends CRMEntity {
    /**
     * Invoked when special actions are performed on the module.
     * @param String Module name
     * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
     */
    function vtlib_handler($modulename, $event_type) {
        if($event_type == 'module.postinstall') {
            self::addWidgetTo();
            self::iniData(); 
            self::CTmobileUserAccess();   
            self::languageInit();
            self::sectionInit();     
        } else if($event_type == 'module.disabled') {
            // TODO Handle actions when this module is disabled.
            self::removeWidgetTo();
        } else if($event_type == 'module.enabled') {
            // TODO Handle actions when this module is enabled.
            self::addWidgetTo();
        } else if($event_type == 'module.preuninstall') {
            self::removeWidgetTo();
            // TODO Handle actions when this module is about to be deleted.
        } else if($event_type == 'module.preupdate') {
            // TODO Handle actions before this module is updated.
        } else if($event_type == 'module.postupdate') {
            self::addWidgetTo(); 
            self::iniData(); 
            self::CTmobileUserAccess();
            self::languageInit();
            self::sectionInit();
        }
    }
    
    static function sectionInit() {
        global $adb;
        $sectionCheck = $adb->pquery('DELETE FROM ctmobile_language_section',array());
        $adb->pquery("INSERT INTO `ctmobile_language_section` (`section_id`, `section_name`) VALUES
                (1, 'Common Message'),
                (2, 'Login Screen'),
                (3, 'Forgot Password Screen'),
                (4, 'Email Screen'),
                (5, 'Add/Edit Record'),
                (6, 'CoverLead Screen'),
                (7, 'Calender screen'),
                (8, 'Setting Screen'),
                (9, 'Module Setting screen'),
                (10, 'Line item Screen'),
                (11, 'Detail Screen'),
                (12, 'Summary Details screen'),
                (13, 'NearBy screen'),
                (14, 'Email Detail Screen'),
                (15, 'Home Screen'),
                (16, 'FeedBack Screen'),
                (17, 'EmailTemplate Screen'),
                (18, 'UserFilterView Screen'),
                (19, 'Activity Setting'),
                (20, 'SMS Send Screen'),
                (21, 'Global Search screen'),
                (22, 'App Introduction screen'),
                (23, 'Drive Record screen'),
                (24, 'ReportBug screen'),
                (25, 'Shortcut screen'),
                (26, 'Check URL screen'),
                (27, 'List Screen'),
                (28, 'Card Scanner Screen'),
                (29, 'Other Message'),
                (30, 'Route Planning Screen'),
                (31, 'Time Tracking Screen'),
                (32, 'CTMobile Messages'),
                (33, 'Notification Settings'),
                (34, 'WhatsApp');",array());
    }
    
    static function iniData() {
        global $adb;
        $checkAddressModule = $adb->pquery("SELECT 1 FROM ctmobile_address_modules",array());
        if($adb->num_rows($checkAddressModule) == 0){
            $allModules = Vtiger_Module_Model::getSearchableModules();
            $searchModules=array_keys($allModules);
            foreach($searchModules as $module) {
                $adb->pquery("INSERT INTO `ctmobile_address_modules` (`module`, `active`) VALUES (?, ?)",array($module,'1'));
            }
        }
        //Insert Contact Address Fields
        $checkAddressField = $adb->pquery("SELECT 1 FROM ctmobile_address_fields",array());
        if($adb->num_rows($checkAddressField) == 0){
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingstreet:mailingstreet:Contacts_Mailing_Street:V"));
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingcity:mailingcity:Contacts_Mailing_City:V"));
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingstate:mailingstate:Contacts_Mailing_State:V"));
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingcountry:mailingcountry:Contacts_Mailing_Country:V"));
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Contacts","vtiger_contactaddress:mailingzip:mailingzip:Contacts_Mailing_Zip:V"));
            //Insert Accounts Address Fields
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_street:ship_street:Accounts_Shipping_Address:V"));
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_city:ship_city:Accounts_Shipping_City:V"));
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_state:ship_state:Accounts_Shipping_State:V"));
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_country:ship_country:Accounts_Shipping_Country:V"));
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Accounts","vtiger_accountshipads:ship_code:ship_code:Accounts_Shipping_Code:V"));
            //Insert Leads Address Fields
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:lane:lane:Leads_Street:V"));
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:city:city:Leads_City:V"));
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:state:state:Leads_State:V"));
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:country:country:Leads_Country:V"));
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Leads","vtiger_leadaddress:code:code:Leads_Postal_Code:V"));
            //Insert Calendar Address Fields
            $adb->pquery("INSERT INTO ctmobile_address_fields (module,fieldname) VALUES (?,?)",array("Calendar","vtiger_activity:location:location:Events_Location:V"));
        }

        //Insert Barcode Field 
        $checkBarcode = $adb->pquery("SELECT 1 FROM ctmobile_barcode_fields",array());
        if($adb->num_rows($checkBarcode) == 0){
            $adb->pquery("INSERT INTO `ctmobile_barcode_fields` (`module`, `fieldname`) VALUES ('Products', 'vtiger_products:product_no:product_no:Products_Product_No:V')",array());
        }
        //Insert Asset Tracking Field
        $checkAsset = $adb->pquery("SELECT 1 FROM ctmobile_asset_field",array());
        if($adb->num_rows($checkAsset) == 0){
            $adb->pquery("INSERT INTO `ctmobile_asset_field` (`module`, `fieldname`) VALUES ('Assets', 'vtiger_assets:asset_no:asset_no:Assets_Asset_No:V')",array());
        }
        //Insert Vcard Field
        $checkVcard = $adb->pquery("SELECT 1 FROM ctmobile_vcard_fields",array());
        if($adb->num_rows($checkVcard) == 0){
            $adb->pquery("INSERT INTO `ctmobile_vcard_fields` (`module`, `fieldname`)VALUES ('Vendors','vtiger_vendor:vendorname:vendorname:Vendors_Vendor_Name:V'),
            ('Leads','vtiger_leaddetails:firstname:firstname:Leads_First_Name:V'),
            ('Leads','vtiger_leaddetails:lastname:lastname:Leads_Last_Name:V'),
            ('Contacts', 'vtiger_contactdetails:firstname:firstname:Contacts_First_Name:V'),
            ('Contacts', 'vtiger_contactdetails:lastname:lastname:Contacts_Last_Name:V')
            ",array());  
        }
        //Insert Route Status
        $checkRoutestatus = $adb->pquery("SELECT 1 FROM ctmobile_routestatus",array());
        if($adb->num_rows($checkRoutestatus) == 0){
            $adb->pquery("INSERT INTO `ctmobile_routestatus` (`routestatusname`, `routestatuslabel`) VALUES
                    ('In Progress',  'In Progress'),
                    ('On Hold',  'On Hold'),
                    ('Completed',    'Completed'),
                    ('Not Available',    'Not Available');",array());
        }
        //Insert All Module as Module Management
        $checkModuletatus = $adb->pquery("SELECT 1 FROM ctmobile_modules_management",array());
        if($adb->num_rows($checkModuletatus) == 0){
            $adb->pquery("INSERT INTO `ctmobile_modules_management` (`module`) VALUES
                    ('selectAll');",array());
        }
        //Insert User Settings
        $checkUserSettings = $adb->pquery("SELECT 1 FROM ctmobile_user_settings",array());
        if($adb->num_rows($checkUserSettings) == 0){
            $adb->pquery("INSERT INTO `ctmobile_user_settings` (`user_setting_type`, `user_setting_value`) VALUES
                ('access_user',  '1'),
                ('location_tracking',    '1'),
                ('route_planner',    '1'),
                ('time_tracker', '1'),
                ('call_logging', '0'),
                ('api_logs', '0');",array());
        }
        //Insert Notification Settings
        $checkNotificationSettings = $adb->pquery("SELECT 1 FROM ctmobile_notification_settings",array());
        if($adb->num_rows($checkNotificationSettings) == 0){
            $adb->pquery("INSERT INTO `ctmobile_notification_settings` (`notification_type`, `notification_enabled`, `workflow_id`, `reminder_time`,`notification_title`,`notification_message`) VALUES
                ('event_invitation', '0',0,0,'You\’ve event Invitation','Event invitation from $events-smownerid:first_name$ $events-smownerid:last_name$ On $events-date_start$ $events-time_start$'),
                ('event_reminder',   '0',0,0,'Event starts shortly...','Event $events-subject$ due on $events-date_start$'),
                ('record_assigned',  '0',0,0,'Record assigned to you','You\’ve been assigned to record, click to see more information'),
                ('comment_mentioned','0',0,0,'You\’re mentioned in comments','$modcomments-commentcontent$'),
                ('comment_assigned', '0',0,0,'Comment added to your assigned Record','Comment has been added to your assigned record, click to see more information'),
                ('task_reminder',    '0',0,0,'Task starts shortly...','Task $calendar-subject$  due on $calendar-date_start$');",array());
        }
        //Insert Premium feature
        $checkPremiumFeature = $adb->pquery("SELECT 1 FROM ctmobile_premium_feature",array());
        if($adb->num_rows($checkPremiumFeature) == 0){
            $adb->pquery("INSERT INTO `ctmobile_premium_feature` (`feature_name`, `feature_enabled`) VALUES
                        ('meeting_checkin','1'),
                        ('attendance_checkin','1'),
                        ('qr_code_scanner','1'),
                        ('business_card_scanner','1'),
                        ('asset_tracking','1'),
                        ('nearby_customer','1'),
                        ('record_map_view','1'),
                        ('address_autofinder','1'),
                        ('call_from_app','1'),
                        ('email_from_app','1'),
                        ('sms_from_app','1'),
                        ('whatsapp_from_app','1');",array());
        }

        //check google API exists or not
        $checkAPi = $adb->pquery("SELECT api_key FROM ctmobile_api_settings",array());
        if($adb->num_rows($checkAPi) == 1){
            $api_key = $adb->query_result($checkAPi,0,'api_key');
            if($api_key){
                 $adb->pquery("INSERT INTO `ctmobile_api_settings` (`api_key`, `order_no`) VALUES
                        ('$api_key','GOOGLE::1'),
                        ('','LOCATIONIQ::0'),
                        ('','OPENSTREET::0');",array());
            }else{
                $deleteAPI = $adb->pquery('DELETE FROM ctmobile_api_settings',array());
                $adb->pquery("INSERT INTO `ctmobile_api_settings` (`api_key`, `order_no`) VALUES
                        ('','GOOGLE::0'),
                        ('','LOCATIONIQ::0'),
                        ('','OPENSTREET::1');",array());
            }  
        }else if($adb->num_rows($checkAPi) == 0){
            $adb->pquery("INSERT INTO `ctmobile_api_settings` (`api_key`, `order_no`) VALUES
                        ('','GOOGLE::0'),
                        ('','LOCATIONIQ::0'),
                        ('','OPENSTREET::1');",array());
        }
        
    }

    static function languageInit(){
        global $adb;
        $AllLanguage = Vtiger_Language::getAll();
        foreach ($AllLanguage as $language => $langname) {
              if($language == 'es_es'){
                self::es_es();
              }else if($language == 'es_mx'){
                self::es_mx();
              }else if($language == 'he_il'){
                self::he_il();
              }else if($language == 'ar_ae'){
                self::ar_ae();
              }else if($language == 'it_it'){
                self::it_it();
              }else if($language == 'pt_br'){
                self::pt_br();
              }else if($language == 'hu_hu'){
                self::hu_hu();
              }else{
                self::en_us($language);
              }

              $newkeywords= array(array('no_address_reference_found','No Address Reference found',32),
                                array('no_overdue_activities','No OverDue Activities',32),
                                array('latitude_longitude_validation_message','Please enter proper address from this address we are not getting proper latitude and longitude',32),
                                array('Default_Search_Field','Default search field',32),
                                array('Calender_Reminder_Message','Free user can\'t send local reminder',32),
                                array('you_must_have_permission','You must give permissions to use this features.',32),
                                array('internal_comment','Internal Comment',1),
                                array('unlink_record','Unlink Record',11),
                                array('unlink_record_msg','Are you sure want to unlink record?',11),
                                array('file_format_not_support','File format not supported',11),
                                array('file_upload','File Upload',5),
                                array('to_vtiger','To Vtiger',5),
                                array('link_external_document','Link External Document',5),
                                array('from_file_url','From File Url',5),
                                array('create_new_document','Create New Document',5),
                                array('select_document_type','Select Document type',5),
                                array('add_signature','Please add signature',11),
                                array('date_greater_then_equal','should be greater than or equal to',1),
                                array('date_less_then_equal','should be less than or equal to',1),
                                array('Click_on_plus_for_add','Please tap on  +  to create a new record.',15),
                                array('display_map','Display map',15),
                                array('other_settings','Other settings',15),
                                array('total_hours','Total hours',15),
                                array('widget_not_found','No widgets found',15),
                                array('quickaction','Quick action',15),
                                array('dashboard','Dashboard',15),
                                array('new','New',15),
                                array('global_search_hint','Please try to search using search box at top',15),
                                array('near_by_map','Near By Map',15),
                                array('view','View',15),
                                array('miles','Miles',15),
                                array('lbl_filters','Filters',27),
                                array('warning','Warning',27),
                                array('no_filter_created','No filter is created.',27),
                                array('please_create_new_ilter','Please create a new filter',27),
                                array('select_search_fields','Select fields for the search record.',27),
                                array('apply_fliters','Apply filters',27),
                                array('sort_by','Sort by',27),
                                array('sort_order','Sort order',27),
                                array('Start_time_tracking','Start time tracking',31),
                                array('Stop_time_tracking','Stop time tracking',31),
                                array('create_shortcut','Create shortcut',25),
                                array('signature','Signature',11),
                                array('image_preview','Image preview',11),
                                array('phone_number','Phone number',11),
                                array('email_address','Email address',11),
                                array('edit_your_preferences','Edit your preferences',8),
                                array('about_app','About app',8),
                                array('updated_ctmobile_ext_version','You already have latest CTMobile Ext. Version',8),
                                array('updated_app_version','You already have latest CRMTiger App Version',8),
                                array('plan','Plan',8),
                                array('time','Time',31),
                                array('error_log_msg','Oops, something went wrong! Please click on Share Button to share error log with our technical team',1),
                                array('add_to_quick_action','Add to quick action',1),
                                array('add_filter_to_quick_action','Add filter to quick action',1),
                                array('create_record','Create Record',1),
                                array('quick_action_hint','You can Add Quick Action here',1),
                                array('str_send','Send',3),
                                array('tax_region_msg','Do you want to update tax & charge values corresponding to selected region?',1),
                                array('delete_quick_action_widgest','Delete Widget?',15),
                                array('add_record_to_dashboard','Add record to dashboard',15),
                                array('module_quick_action_msg','Module added to dashboard',15),
                                array('filter_quick_action_msg','Filter added to dashboard',15),
                                array('record_quick_action_msg','Record added to dashboard',15),
                                array('filter_shortcut_quick_action_msg','Filter shortcut added to dashboard',15),
                                array('record_shortcut_quick_action_msg','Record shortcut added to dashboard',15),
                                array('documents_disabled','Documents Module is disabled',1),
                                array('document_dont_attachment','Document does not have a attachment',1),
                                array('go_to_neat_by','Go to NearBy',15),
                                array('go_to_time_tracking','Go to Time Tracker',13),
                                array('nearby_quick_action_msg','NearBy added to dashboard',15),
                                array('time_tracking_quick_action_msg','Time Tracking added to dashboard',15),
                                array('attendance_quick_action_msg','Attendance added to dashboard',15),
                                array('attachment','Attachment',15),
                                array('search_by_fields','Search by fields',27),
                                array('apply_selected','Apply selected',27),
                                array('auto_address_disabled','auto address finder is disabled, please enable it from CRMTiger Settings',1),
                                array('Attendance','Attendance',15),
                                array('Check-in successfully','Check-in successfully',32),
                                array('Check-out successfully','Check-out successfully',32),
                                array('Nothing around here','Nothing around here',13),
                                array('select_days','Select Days',5),
                                array('select_minutes','Select Minutes',5),
                                array('select_hours','Select Hours',5),
                                array('no_lat_long_found','Location information (Latitude,Longitude) not found',32),
                                array('Call Log save successfully','Call Log save successfully',32),
                                array('Files/photos deleted successfully','Files/photos deleted successfully',32),
                                array('important','Important',34),
                                array('template','Template',34),
                                array('copy','Copy',34),
                                array('camera','Camera',34),
                                array('gallery','Gallery',34),
                                array('audio','Audio',34),
                                array('last_seen_at','Last seen at',34),
                                array('type_a_message','Type a message',34),
                                array('all_messages','All messages',34),
                                array('time_tracking_reports','Time tracking reports',34),
                                array('attendance_reports','Attendance reports',34),
                                array('chats','Chats',34),
                                array('Marked chat as Important','Marked chat as Important',34),
                                array('Unmarked chat as Important','Unmarked chat as Important',34),
                                array('mark_as_important','Mark as important',34),
                                array('unmark_As_important','Unmark as important',34),
                                array('select_template','Select template',34),
                                array('chat','Chat',34),
                                array('search_by_name_or_contact','Search by name or contact',34),
                                array('choose_contact_for_whatsApp','Choose contact for whatsApp',34),
                                array('whatsapp_template','Whatsapp template',34),
                                array('send_voice_recording','Send voice recording',34),
                                array('slide_to_cancel','Slide To Cancel',34),
                                array('whatsapp_disconnect_messsage','Ooops.. You\'re disconnected from WhatsApp. Please Scan QR Code from the CRM.',34),
                                array('select_priority','Select priority',30),
                                array('repeat_route','Repeat route',30),
                                array('change_assign_to','Change assigned to',30),
                                array('Multiple Route created successfully','Multiple Route created successfully',30),
                                array('Route duplicated successfully','Route duplicated successfully',30));
              
              foreach ($newkeywords as $key => $keywords) {
                  self::AddNewKeywords($keywords[0],$keywords[1],$language,$keywords[2]);
              }
        }
    }

    static function AddNewKeywords($keyword,$keyword_lang,$language,$sectionid){
        global $adb;
        $checkLang = $adb->pquery("SELECT 1 FROM ctmobile_language_keyword WHERE keyword = ? AND keyword_lang = ?",array($keyword,$language));
        if($adb->num_rows($checkLang) == 0){
            $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            (?, ?, ?, ?, ?);",array($keyword,$keyword_lang,$language,$keyword_lang,$sectionid));
        }
    }

    static function en_us($language = 'en_us'){
        global $adb;
        $checkLang = $adb->pquery("SELECT 1 FROM ctmobile_language_keyword WHERE keyword_lang = ?",array($language));
        if($adb->num_rows($checkLang) == 0){

        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error',   'Network connection error!',    '".$language."',    'Network connection error!',    1),
            ('connection_check',    'Could not connect to CRM, Please check your Internet connection.', '".$language."',    'Could not connect to CRM, Please check your Internet connection.', 1),
            ('update',  'Update',   '".$language."',    'Update',   1),
            ('cancel',  'Cancel',   '".$language."',    'Cancel',   1),
            ('ok',  'Ok',   '".$language."',    'Ok',   1),
            ('more_information',    'Click here for more information.', '".$language."',    'Click here for more information.', 1),
            ('yes', 'Yes',  '".$language."',    'Yes',  1),
            ('no',  'No',   '".$language."',    'No',   1),
            ('click_again_exit',    'Click again to exit',  '".$language."',    'Click again to exit',  1),
            ('forpermission',   'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.',   '".$language."',    'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.',   1),
            ('clickhere',   'Click here',   '".$language."',    'Click here',   1),
            ('clickhere_subscribe', 'Click here to subscribe premium version',  '".$language."',    'Click here to subscribe premium version',  1),
            ('clickhere_configure', 'Click here and view how to Configure.',    '".$language."',    'Click here and view how to Configure.',    1),
            ('please_wait', 'Please Wait…', '".$language."',    'Please Wait…', 1),
            ('share__msg',  'Share file with',  '".$language."',    'Share file with',  1),
            ('dialog_camera',   'Camera',   '".$language."',    'Camera',   1),
            ('dialog_add_file_by',  'Take Photo from',  '".$language."',    'Take Photo from',  1),
            ('add', 'Add',  '".$language."',    'Add',  1),
            ('mail_manager_configured', 'Mail Manager is not configured',   '".$language."',    'Mail Manager is not configured',   1),
            ('dialog_add_files_by', 'Add Files by', '".$language."',    'Add Files by', 1),
            ('dialog_drive',    'Drive',    '".$language."',    'Drive',    1),
            ('dialog_drop_box', 'Drop Box', '".$language."',    'Drop Box', 1),
            ('dialog_need_signin',  'You need to Sign-in to your Drive account first.', '".$language."',    'You need to Sign-in to your Drive account first.', 1),
            ('dialog_gallery',  'Gallery',  '".$language."',    'Gallery',  1),
            ('delete',  'Delete',   '".$language."',    'Delete',   1),
            ('timeoutmessage',  'Oops! Request is taking more time than expected.', '".$language."',    'Oops! Request is taking more time than expected.', 1),
            ('gps_location_message',    'GPS is not enabled. Please turn it on to get your near by locations.', '".$language."',    'GPS is not enabled. Please turn it on to get your near by locations.', 1),
            ('sure_want_delete',    'Are you sure want to delete ?',    '".$language."',    'Are you sure want to delete ?',    1),
            ('select',  'Select',   '".$language."',    'Select',   1),
            ('msgforrecordaudio',   'Minimum record duration one second.',  '".$language."',    'Minimum record duration one second.',  1),
            ('permission_storage',  'Permission denied to read your External storage',  '".$language."',    'Permission denied to read your External storage',  1),
            ('send_permission_msg', 'Send message permission denied',   '".$language."',    'Send message permission denied',   1),
            ('choosefile',  'Choose File',  '".$language."',    'Choose File',  1),
            ('enter',   'Enter',    '".$language."',    'Enter',    1),
            ('select_an_option',    'Select an Option', '".$language."',    'Select an Option', 1),
            ('email_validation',    'Email is not valid',   '".$language."',    'Email is not valid',   1),
            ('please_enter',    'Please Enter', '".$language."',    'Please Enter', 1),
            ('website_validation_text', 'Website URL is not valid', '".$language."',    'Website URL is not valid', 1),
            ('selectvalue', 'Select value first',   '".$language."',    'Select value first',   1),
            ('email',   'Email',    '".$language."',    'Email',    1),
            ('enter_email_address', 'Enter email address',  '".$language."',    'Enter email address',  1),
            ('email_address_not_correct',   'Email address incorrect',  '".$language."',    'Email address incorrect',  1),
            ('pls_enter_subject',   'Please Enter Subject', '".$language."',    'Please Enter Subject', 1),
            ('attachFiles', 'Attached File',    '".$language."',    'Attached File',    1),
            ('from',    'From', '".$language."',    'From', 1),
            ('to',  'To',   '".$language."',    'To',   1),
            ('call_permission_msg', 'Call permission denied',   '".$language."',    'Call permission denied',   1),
            ('no_records',  'No records found', '".$language."',    'No records found', 1),
            ('fullform',    'Create New',   '".$language."',    'Create New',   1),
            ('save',    'Save', '".$language."',    'Save', 1),
            ('total',   'Total',    '".$language."',    'Total',    1),
            ('discount',    'Discount', '".$language."',    'Discount', 1),
            ('price',   'Price',    '".$language."',    'Price',    1),
            ('quantity',    'Quantity', '".$language."',    'Quantity', 1),
            ('select_module',   'Select Module',    '".$language."',    'Select Module',    1),
            ('item_list',   'Item List',    '".$language."',    'Item List',    1),
            ('quickcreate', 'Quick Create', '".$language."',    'Quick Create', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', '".$language."',    'Overwrite the existing address with the selected', 1),
            ('once_in_every',   'Once in every',    '".$language."',    'Once in every',    1),
            ('overwrite_msg_part2', 'address details?', '".$language."',    'address details?', 1),
            ('add_item',    'Add Item', '".$language."',    'Add Item', 1),
            ('recordsave',  'Record saved successfully',    '".$language."',    'Record saved successfully',    1),
            ('recordnotsave',   'Could not save record. Try again later',   '".$language."',    'Could not save record. Try again later',   1),
            ('minutes', 'Minutes',  '".$language."',    'Minutes',  1),
            ('hours',   'Hours',    '".$language."',    'Hours',    1),
            ('days',    'Days', '".$language."',    'Days', 1),
            ('on',  'On',   '".$language."',    'On',   1),
            ('day_of_the_month',    'day of the month', '".$language."',    'day of the month', 1),
            ('list_price',  'List Price',   '".$language."',    'List Price',   1),
            ('add_record',  'Add Record',   '".$language."',    'Add Record',   1),
            ('add_product', 'Add Product',  '".$language."',    'Add Product',  1),
            ('add_service', 'Add Service',  '".$language."',    'Add Service',  1),
            ('discountin',  'Discount in %',    '".$language."',    'Discount in %',    1),
            ('unitprice',   'Unit price',   '".$language."',    'Unit price',   1),
            ('netprice',    'Net price',    '".$language."',    'Net price',    1),
            ('comments',    'Comments', '".$language."',    'Comments', 1),
            ('add_close',   'Add & Close',  '".$language."',    'Add & Close',  1),
            ('fetching_rout_message',   'Fetching route, Please wait…', '".$language."',    'Fetching route, Please wait…', 1),
            ('setting', 'Settings', '".$language."',    'Settings', 1),
            ('utc', 'UTC',  '".$language."',    'UTC',  1),
            ('in',  'In',   '".$language."',    'In',   1),
            ('days_ago',    'days ago', '".$language."',    'days ago', 1),
            ('mins_ago',    'Minutes ago',  '".$language."',    'Minutes ago',  1),
            ('justnow', 'Just now', '".$language."',    'Just now', 1),
            ('hours_ago',   'hours ago',    '".$language."',    'hours ago',    1),
            ('in_1_day',    'In 1 day', '".$language."',    'In 1 day', 1),
            ('scanqrcode',  'Asset / Card scanner', '".$language."',    'Asset / Card scanner', 1),
            ('call_log',    'Call Log', '".$language."',    'Call Log', 1),
            ('voice_message',   'Hi',   '".$language."',    'Hi',   1),
            ('voice_message1',  'What can I search for you in', '".$language."',    'What can I search for you in', 1),
            ('live_tracking',   'Live Tracking',    '".$language."',    'Live Tracking',    1),
            ('mailmanager', 'Mail Manager', '".$language."',    'Mail Manager', 1),
            ('my_location', 'My location',  '".$language."',    'My location',  1),
            ('created_on',  'Created On',   '".$language."',    'Created On',   1),
            ('modified_on', 'Modified On',  '".$language."',    'Modified On',  1),
            ('enter_comments',  'Enter Comments',   '".$language."',    'Enter Comments',   1),
            ('viewmore',    'View More',    '".$language."',    'View More',    1),
            ('viewless',    'View Less',    '".$language."',    'View Less',    1),
            ('gotofullform',    'Go to Full Form',  '".$language."',    'Go to Full Form',  1),
            ('post',    'Post', '".$language."',    'Post', 1),
            ('url', 'URL',  '".$language."',    'URL',  1),
            ('dialog_title_text_back_color',    'Select a Text Background Color',   '".$language."',    'Select a Text Background Color',   1),
            ('event_or_task',   'Add event/task',   '".$language."',    'Add event/task',   1),
            ('shortcut',    'Shortcuts',    '".$language."',    'Shortcuts',    1),
            ('select_field',    'Select Field', '".$language."',    'Select Field', 1),
            ('share',   'Share',    '".$language."',    'Share',    1),
            ('title_insert_link',   'Insert Link',  '".$language."',    'Insert Link',  1),
            ('addyourcommentshere', 'Add your comments here',   '".$language."',    'Add your comments here',   1),
            ('nocomment',   'No Comments',  '".$language."',    'No Comments',  1),
            ('leads',   'Leads',    '".$language."',    'Leads',    1),
            ('true_val',    'true', '".$language."',    'true', 1),
            ('noresult',    'No Result',    '".$language."',    'No Result',    1),
            ('version', 'Version',  '".$language."',    'Version',  1),
            ('convert_lead',    'Convert Lead', '".$language."',    'Convert Lead', 1),
            ('app_name',    'CRMTiger', '".$language."',    'CRMTiger', 1),
            ('enter_url',   'Please Enter url', '".$language."',    'Please Enter url', 1),
            ('help',    'Help', '".$language."',    'Help', 1),
            ('contact_us',  'Contact Us',   '".$language."',    'Contact Us',   1),
            ('updates', 'Updates',  '".$language."',    'Updates',  1),
            ('logout',  'LogOut',   '".$language."',    'LogOut',   1),
            ('busnies_cardscanner', 'Business Card Scanner',    '".$language."',    'Business Card Scanner',    1),
            ('sure_want_logout',    'Are you sure want to logout ?',    '".$language."',    'Are you sure want to logout ?',    1),
            ('logout_message',  'Logout successfully',  '".$language."',    'Logout successfully',  1),
            ('all', 'All',  '".$language."',    'All',  1),
            ('add_event',   'Add event',    '".$language."',    'Add event',    1),
            ('add_task',    'Add Task', '".$language."',    'Add Task', 1),
            ('next',    'Next', '".$language."',    'Next', 1),
            ('terms_conditions',    'Terms and Conditions', '".$language."',    'Terms and Conditions', 1),
            ('login',   'Login',    '".$language."',    'Login',    2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy',    '".$language."',    'By logging in, you agree to our Terms and Conditions & Privacy Policy',    2),
            ('copyright',   'Copyright © 2020 CRMTiger Version',    '".$language."',    'Copyright © 2020 CRMTiger Version',    2),
            ('enter_username',  'Please enter username',    '".$language."',    'Please enter username',    2),
            ('enter_password',  'Please enter password',    '".$language."',    'Please enter password',    2),
            ('remanberme',  'Remember Me',  '".$language."',    'Remember Me',  2),
            ('forgot_password', 'Forgot password?', '".$language."',    'Forgot password?', 2),
            ('privacy_policay1',    'Privacy Policy',   '".$language."',    'Privacy Policy',   2),
            ('contactsupportmsg',   'Something went wrong. \n please Click here to contact support.',   '".$language."',    'Something went wrong. \n please Click here to contact support.',   2),
            ('enter_username_password', 'Entered Username or Password is wrong',    '".$language."',    'Entered Username or Password is wrong',    2),
            ('server_issue_occured',    'Server issues occurred',   '".$language."',    'Server issues occurred',   2),
            ('password',    'Password', '".$language."',    'Password', 3),
            ('user_name',   'Username', '".$language."',    'Username', 3),
            ('reset_pwd',   'Reset Password',   '".$language."',    'Reset Password',   3),
            ('forgot_password_title',   'Forgot password',  '".$language."',    'Forgot password',  3),
            ('enter_user_name', 'Enter user name',  '".$language."',    'Enter user name',  3),
            ('cc',  'Cc',   '".$language."',    'Cc',   4),
            ('body',    'Body', '".$language."',    'Body', 4),
            ('bcc', 'BCC',  '".$language."',    'BCC',  4),
            ('dialog_title_text_color', 'Select a Text Color',  '".$language."',    'Select a Text Color',  4),
            ('date',    'Date', '".$language."',    'Date', 4),
            ('subject', 'Subject',  '".$language."',    'Subject',  4),
            ('composeMail', 'Compose Mail', '".$language."',    'Compose Mail', 4),
            ('send',    'Send', '".$language."',    'Send', 4),
            ('select_message',  'Select message',   '".$language."',    'Select message',   4),
            ('title_insert_table',  'Insert Table', '".$language."',    'Insert Table', 4),
            ('log_file_sms',    'I agree to Share API Log to Technical team for further troubleshooting',   '".$language."',    'I agree to Share API Log to Technical team for further troubleshooting',   5),
            ('edit_record', 'Edit Records', '".$language."',    'Edit Records', 5),
            ('select_time', 'Select Time',  '".$language."',    'Select Time',  5),
            ('edit_item',   'Edit Item',    '".$language."',    'Edit Item',    5),
            ('items_total', 'Items Total',  '".$language."',    'Items Total',  5),
            ('number_less_then_31', 'Number should be less than 31',    '".$language."',    'Number should be less than 31',    5),
            ('users',   'Users',    '".$language."',    'Users',    5),
            ('groups',  'Groups',   '".$language."',    'Groups',   5),
            ('txt_note_for_file',   'Note : Existing attachments(images/files) will be replaced',   '".$language."',    'Note : Existing attachments(images/files) will be replaced',   5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime',   '".$language."',    'End DateTime should be greater than Start DateTime',   5),
            ('until',   'Until',    '".$language."',    'Until',    5),
            ('organizations',   'Organizations',    '".$language."',    'Organizations',    6),
            ('contacts',    'Contacts', '".$language."',    'Contacts', 6),
            ('opportunity', 'Opportunity',  '".$language."',    'Opportunity',  6),
            ('lbl_sun', 'SUN',  '".$language."',    'SUN',  7),
            ('lbl_mon', 'MON',  '".$language."',    'MON',  7),
            ('lbl_tue', 'TUE',  '".$language."',    'TUE',  7),
            ('lbl_wed', 'WED',  '".$language."',    'WED',  7),
            ('lbl_thu', 'THU',  '".$language."',    'THU',  7),
            ('lbl_fri', 'FRI',  '".$language."',    'FRI',  7),
            ('lbl_sat', 'SAT',  '".$language."',    'SAT',  7),
            ('lbl_1',   '1',    '".$language."',    '1',    7),
            ('lbl_2',   '2',    '".$language."',    '2',    7),
            ('lbl_3',   '3',    '".$language."',    '3',    7),
            ('lbl_4',   '4',    '".$language."',    '4',    7),
            ('lbl_5',   '5',    '".$language."',    '5',    7),
            ('lbl_6',   '6',    '".$language."',    '6',    7),
            ('lbl_7',   '7',    '".$language."',    '7',    7),
            ('lbl_8',   '8',    '".$language."',    '8',    7),
            ('lbl_9',   '9',    '".$language."',    '9',    7),
            ('lbl_10',  '10',   '".$language."',    '10',   7),
            ('lbl_11',  '11',   '".$language."',    '11',   7),
            ('lbl_12',  '12',   '".$language."',    '12',   7),
            ('lbl_13',  '13',   '".$language."',    '13',   7),
            ('lbl_14',  '14',   '".$language."',    '14',   7),
            ('lbl_15',  '15',   '".$language."',    '15',   7),
            ('lbl_16',  '16',   '".$language."',    '16',   7),
            ('lbl_17',  '17',   '".$language."',    '17',   7),
            ('lbl_18',  '18',   '".$language."',    '18',   7),
            ('lbl_19',  '19',   '".$language."',    '19',   7),
            ('lbl_20',  '20',   '".$language."',    '20',   7),
            ('lbl_21',  '21',   '".$language."',    '21',   7),
            ('lbl_22',  '22',   '".$language."',    '22',   7),
            ('lbl_23',  '23',   '".$language."',    '23',   7),
            ('lbl_24',  '24',   '".$language."',    '24',   7),
            ('lbl_25',  '25',   '".$language."',    '25',   7),
            ('lbl_26',  '26',   '".$language."',    '26',   7),
            ('lbl_27',  '27',   '".$language."',    '27',   7),
            ('lbl_28',  '28',   '".$language."',    '28',   7),
            ('lbl_29',  '29',   '".$language."',    '29',   7),
            ('lbl_30',  '30',   '".$language."',    '30',   7),
            ('lbl_31',  '31',   '".$language."',    '31',   7),
            ('lbl_32',  '32',   '".$language."',    '32',   7),
            ('lbl_33',  '33',   '".$language."',    '33',   7),
            ('lbl_34',  '34',   '".$language."',    '34',   7),
            ('lbl_35',  '35',   '".$language."',    '35',   7),
            ('lbl_36',  '36',   '".$language."',    '36',   7),
            ('lbl_37',  '37',   '".$language."',    '37',   7),
            ('lbl_38',  '38',   '".$language."',    '38',   7),
            ('lbl_39',  '39',   '".$language."',    '39',   7),
            ('lbl_40',  '40',   '".$language."',    '40',   7),
            ('lbl_41',  '41',   '".$language."',    '41',   7),
            ('lbl_42',  '42',   '".$language."',    '42',   7),
            ('current_date',    'current date', '".$language."',    'current date', 7),
            ('event',   'Events',   '".$language."',    'Events',   7),
            ('calendar',    'Calendar', '".$language."',    'Calendar', 7),
            ('latest_version',  'Latest Version :', '".$language."',    'Latest Version :', 8),
            ('expire_on',   'Next renewal date : ', '".$language."',    'Next renewal date : ', 8),
            ('ctmobile_ext_version',    'CTMobile Ext. Version : ', '".$language."',    'CTMobile Ext. Version : ', 8),
            ('you_have_latest_version', 'You already have latest version',  '".$language."',    'You already have latest version',  8),
            ('latest_version1', 'You Already have latest version',  '".$language."',    'You Already have latest version',  8),
            ('upgreaded',   'Upgrade',  '".$language."',    'Upgrade',  8),
            ('downgrade',   'Downgrade',    '".$language."',    'Downgrade',    8),
            ('dialog_recent_event_info',    'You can set from here how many number of records you want to show on Home screen for Recent Event.',   '".$language."',    'You can set from here how many number of records you want to show on Home screen for Recent Event.',   8),
            ('dialog_feedback_info',    'You can submit your feedback with description , our team will check your feedback and get back to you.',   '".$language."',    'You can submit your feedback with description , our team will check your feedback and get back to you.',   8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.',    '".$language."',    'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.',    8),
            ('info',    'Info', '".$language."',    'Info', 8),
            ('recent_history',  'Recent History',   '".$language."',    'Recent History',   8),
            ('recent_feedback', 'Feedback', '".$language."',    'Feedback', 8),
            ('recent_log',  'Log',  '".$language."',    'Log',  8),
            ('crmtiger_app_version',    'CRMTiger App Version : ',  '".$language."',    'CRMTiger App Version : ',  8),
            ('historylimit',    'Recent History Limit', '".$language."',    'Recent History Limit', 8),
            ('radious_in_miles',    'Radius in miles',  '".$language."',    'Radius in miles',  8),
            ('recentlimit', 'Recent Event Limit',   '".$language."',    'Recent Event Limit',   8),
            ('upcoming_events', 'Upcoming Events',  '".$language."',    'Upcoming Events',  8),
            ('rate_our_app',    'Rate Our App!',    '".$language."',    'Rate Our App!',    8),
            ('feedback',    'Submit Feedback',  '".$language."',    'Submit Feedback',  8),
            ('sendfeedback',    'Feedback Send',    '".$language."',    'Feedback Send',    8),
            ('emaillimit',  'Email limit',  '".$language."',    'Email limit',  8),
            ('log', 'Log',  '".$language."',    'Log',  8),
            ('logclear',    'Log cleared successfully.',    '".$language."',    'Log cleared successfully.',    8),
            ('dialog_recent_history_info',  'You can set from here how many number of records you want to show on Home screen for Recent History.', '".$language."',    'You can set from here how many number of records you want to show on Home screen for Recent History.', 8),
            ('proceed_to_upgrade1', 'Proceed to',   '".$language."',    'Proceed to',   8),
            ('upgradation_message', 'will required logout and login again later.',  '".$language."',    'will required logout and login again later.',  8),
            ('proceed_to_upgrade',  'Proceed to Upgrade',   '".$language."',    'Proceed to Upgrade',   8),
            ('module_setting',  'Module Setting',   '".$language."',    'Module Setting',   9),
            ('sortbyfield', 'Sort by field',    '".$language."',    'Sort by field',    9),
            ('ascending',   'Ascending  A to Z',    '".$language."',    'Ascending  A to Z',    9),
            ('descending',  'Descending  Z to A',   '".$language."',    'Descending  Z to A',   9),
            ('first_field', 'First Field',  '".$language."',    'First Field',  9),
            ('second_field',    'Second Field', '".$language."',    'Second Field', 9),
            ('third_field', 'Third Field',  '".$language."',    'Third Field',  9),
            ('sure_want_restore',   'Are you sure you want to reset to default settings?',  '".$language."',    'Are you sure you want to reset to default settings?',  9),
            ('orderlist',   'List Order',   '".$language."',    'List Order',   9),
            ('module_reset',    'Restore to Default',   '".$language."',    'Restore to Default',   9),
            ('display_fields',  'Display Fields',   '".$language."',    'Display Fields',   9),
            ('discount_lessthen_100',   'Discount % should be less than 100',   '".$language."',    'Discount % should be less than 100',   10),
            ('select_item', 'Select Item',  '".$language."',    'Select Item',  10),
            ('item_comment',    'Item Comment', '".$language."',    'Item Comment', 10),
            ('record_name', 'Record Name is :', '".$language."',    'Record Name is :', 11),
            ('go_back', 'Go Back',  '".$language."',    'Go Back',  11),
            ('please_enter_shortcut_name',  'Please Enter Shortcut Name',   '".$language."',    'Please Enter Shortcut Name',   11),
            ('number_not_found',    'Contact Number not found', '".$language."',    'Contact Number not found', 11),
            ('mail_not_found',  'Mail Address not found',   '".$language."',    'Mail Address not found',   11),
            ('create_shortcut', 'Create Shortcut',  '".$language."',    'Create Shortcut',  11),
            ('contact_summary', 'Summary',  '".$language."',    'Summary',  11),
            ('activites',   'Activities',   '".$language."',    'Activities',   11),
            ('details', 'Details',  '".$language."',    'Details',  11),
            ('related', 'Related',  '".$language."',    'Related',  11),
            ('share_link',  'Share record with',    '".$language."',    'Share record with',    11),
            ('edit',    'Edit', '".$language."',    'Edit', 11),
            ('duplicate',   'Duplicate',    '".$language."',    'Duplicate',    11),
            ('whatsapp',    'Whatsapp', '".$language."',    'Whatsapp', 11),
            ('call',    'Call', '".$language."',    'Call', 11),
            ('choose_contact_for_call', 'Choose Contact for Call',  '".$language."',    'Choose Contact for Call',  11),
            ('choose_contact_for_sms',  'Choose Contact for SMS',   '".$language."',    'Choose Contact for SMS',   11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp',  '".$language."',    'Choose Contact for WhatsApp',  11),
            ('chosse_contact_for_email',    'Choose Email', '".$language."',    'Choose Email', 11),
            ('attach_file', 'Attach Files', '".$language."',    'Attach Files', 11),
            ('close',   'Close',    '".$language."',    'Close',    11),
            ('status',  'Status',   '".$language."',    'Status',   11),
            ('stop',    'Stop', '".$language."',    'Stop', 11),
            ('zero',    '0',    '".$language."',    '0',    11),
            ('record',  'Record',   '".$language."',    'Record',   11),
            ('voice_note',  'Voice Note',   '".$language."',    'Voice Note',   11),
            ('tickets', 'Tickets',  '".$language."',    'Tickets',  12),
            ('check_out',   'Check Out',    '".$language."',    'Check Out',    12),
            ('check_in',    'Check In', '".$language."',    'Check In', 12),
            ('select_any',  'Select any',   '".$language."',    'Select any',   12),
            ('fulldetails', 'Show Full Details',    '".$language."',    'Show Full Details',    12),
            ('checkin', 'Check-in', '".$language."',    'Check-in', 12),
            ('navigate',    'Navigate', '".$language."',    'Navigate', 12),
            ('product', 'Products', '".$language."',    'Products', 12),
            ('projectMilestone',    'Project Milestone',    '".$language."',    'Project Milestone',    12),
            ('projecttask', 'Project Tasks',    '".$language."',    'Project Tasks',    12),
            ('nearby',  'NearBy',   '".$language."',    'NearBy',   13),
            ('document',    'Document', '".$language."',    'Document', 14),
            ('reply',   'Reply',    '".$language."',    'Reply',    14),
            ('reply_all',   'Reply All',    '".$language."',    'Reply All',    14),
            ('forward', 'Forward',  '".$language."',    'Forward',  14),
            ('action',  'Action',   '".$language."',    'Action',   14),
            ('select_first',    'Select First', '".$language."',    'Select First', 14),
            ('commentaddsuccessful',    'Comment added successfull',    '".$language."',    'Comment added successfull',    14),
            ('move_to', 'Move to',  '".$language."',    'Move to',  14),
            ('attach',  'Attach',   '".$language."',    'Attach',   14),
            ('addcoment',   'Add Comment',  '".$language."',    'Add Comment',  14),
            ('adddocument', 'Add Document', '".$language."',    'Add Document', 14),
            ('home',    'Home', '".$language."',    'Home', 15),
            ('checkout',    'Check-out',    '".$language."',    'Check-out',    15),
            ('message_search',  'Search by name',   '".$language."',    'Search by name',   15),
            ('start_shift', 'Start shift',  '".$language."',    'Start shift',  15),
            ('end_shift',   'End shift',    '".$language."',    'End shift',    15),
            ('today_meeting',   'Meetings', '".$language."',    'Meetings', 15),
            ('shift_time_track',    'Shift Time Track', '".$language."',    'Shift Time Track', 15),
            ('logout_msg',  'You have to login again , click',  '".$language."',    'You have to login again , click',  15),
            ('logout_msg1', 'to continue.', '".$language."',    'to continue.', 15),
            ('permission_denied',   'You don\'t have permission to create', '".$language."',    'You don\'t have permission to create', 15),
            ('history', 'Activity stream',  '".$language."',    'Activity stream',  15),
            ('search_value',    'Search value :',   '".$language."',    'Search value :',   15),
            ('feed_back_msg',   'Please enter feedback message',    '".$language."',    'Please enter feedback message',    16),
            ('feed_back_hint_msg',  'Enter feedback message',   '".$language."',    'Enter feedback message',   16),
            ('submit',  'Submit',   '".$language."',    'Submit',   16),
            ('check_app_not_installed', 'Application is not currently installed.',  '".$language."',    'Application is not currently installed.',  17),
            ('send_sms_fail_message',   'SMS failed, please try again later!',  '".$language."',    'SMS failed, please try again later!',  17),
            ('documentaddsuccessfully', 'Document Attach successfully', '".$language."',    'Document Attach successfully', 17),
            ('send_message',    'Send message', '".$language."',    'Send message', 17),
            ('sms_to',  'smsto:',   '".$language."',    'smsto:',   17),
            ('add_list_message',    'Add List', '".$language."',    'Add List', 18),
            ('mylist',  'My List',  '".$language."',    'My List',  18),
            ('filtername',  'Filter Name',  '".$language."',    'Filter Name',  18),
            ('selectlist',  'Select a List',    '".$language."',    'Select a List',    18),
            ('assingedto',  'Assigned To',  '".$language."',    'Assigned To',  18),
            ('selectmodule',    'Select a module',  '".$language."',    'Select a module',  18),
            ('add_list',    'Add Filter',   '".$language."',    'Add Filter',   18),
            ('recent_event',    'Recent Event', '".$language."',    'Recent Event', 19),
            ('recent_hostory',  'Recent History',   '".$language."',    'Recent History',   19),
            ('module_specific_settings',    'Module-Specific Settings', '".$language."',    'Module-Specific Settings', 19),
            ('talk_to_us',  'Talk to us',   '".$language."',    'Talk to us',   19),
            ('report_a_bug',    'Report A Bug', '".$language."',    'Report A Bug', 19),
            ('faq', 'FAQ',  '".$language."',    'FAQ',  19),
            ('selectmodules',   'Select Module',    '".$language."',    'Select Module',    19),
            ('myplan',  'My Plan',  '".$language."',    'My Plan',  19),
            ('message', 'Message',  '".$language."',    'Message',  20),
            ('message_validation',  'Please enter Message', '".$language."',    'Please enter Message', 20),
            ('contact_select',  'Please Select contact',    '".$language."',    'Please Select contact',    20),
            ('global_search',   'Global Search',    '".$language."',    'Global Search',    21),
            ('records', 'Records',  '".$language."',    'Records',  21),
            ('dont_show_again', 'Don\'t Show Again',    '".$language."',    'Don\'t Show Again',    22),
            ('skip',    'Skip', '".$language."',    'Skip', 22),
            ('file_downloading',    'File Downloading', '".$language."',    'File Downloading', 23),
            ('add_screenshots_optional',    'Add screenshots (optional)',   '".$language."',    'Add screenshots (optional)',   24),
            ('describe_your_problem',   'Describe your problem',    '".$language."',    'Describe your problem',    24),
            ('default_filter_shortcut', 'Default Filter Shortcut',  '".$language."',    'Default Filter Shortcut',  25),
            ('record_shortcut', 'Record Shortcut',  '".$language."',    'Record Shortcut',  25),
            ('enter_url',   'Please Enter url', '".$language."',    'Please Enter url', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', '".$language."',    'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 26),
            ('search_by',   'Search by',    '".$language."',    'Search by',    27),
            ('selected_filter', 'Selected filter :',    '".$language."',    'Selected filter :',    27),
            ('selected_field',  'Selected field :', '".$language."',    'Selected field :', 27),
            ('choose',  'Choose',   '".$language."',    'Choose',   28),
            ('qr_cardscanner',  'QR Code Scanner',  '".$language."',    'QR Code Scanner',  28),
            ('error_message_for_scan',  'Could not read the card Try again later.', '".$language."',    'Could not read the card Try again later.', 28),
            ('press_start_scan',    'Press to Start Scan',  '".$language."',    'Press to Start Scan',  28),
            ('line_item_quntity_validation_msg',    'Value should be greater than zero',    '".$language."',    'Value should be greater than zero',    29),
            ('percentage_msg',  'Percentage should be less than 100',   '".$language."',    'Percentage should be less than 100',   29),
            ('MSG_NO_DATA', 'No data found!',   '".$language."',    'No data found!',   29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!',    '".$language."',    'Something went wrong!',    29),
            ('MSG_COMING_SOON', 'Coming Soon!', '".$language."',    'Coming Soon!', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE',    'Please upload profile image.', '".$language."',    'Please upload profile image.', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access',  '".$language."',    'Location Access',  29),
            ('ALERT_MSG_LOCATION_ACCESS',   'Requires your location to show nearby events.',    '".$language."',    'Requires your location to show nearby events.',    29),
            ('ALERT_BTN_ALLOW', 'ALLOW',    '".$language."',    'ALLOW',    29),
            ('ALERT_BTN_DENY',  'DENY', '".$language."',    'DENY', 29),
            ('ALERT_MSG_LOCATION_SETTING',  'Not able to fetch your current location. Please allow us to use your location to provide you certain features like, live tracking, route planning and display near by leads, contact, organization, etc. This will help you to plan your on field task as well',   '".$language."',    'Not able to fetch your current location. Please allow us to use your location to provide you certain features like, live tracking, route planning and display near by leads, contact, organization, etc. This will help you to plan your on field task as well',   29),
            ('DELETE_RECORD',   'Delete Record',    '".$language."',    'Delete Record',    29),
            ('ALERT_MSG_DELETE_SHORTCUT',   'Are you sure want to delete this shortcut?',   '".$language."',    'Are you sure want to delete this shortcut?',   29),
            ('DELETE_SHORTCUT', 'Delete Shortcut',  '".$language."',    'Delete Shortcut',  29),
            ('LBL_TERMS',   'By logging in, you agree to our Terms and',    '".$language."',    'By logging in, you agree to our Terms and',    29),
            ('LBL_CONDITIONS',  'Conditions &', '".$language."',    'Conditions &', 29),
            ('ALERT_TITLE', 'Alert',    '".$language."',    'Alert',    29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe',    '".$language."',    'Subscribe',    29),
            ('MSG_SELECT_MODULE',   'Please select any Module', '".$language."',    'Please select any Module', 29),
            ('MSG_SELECT_LIST', 'Please select any List',   '".$language."',    'Please select any List',   29),
            ('ALERT_MSG_DONT_HAVE_CAMERA',  'You don\'t have camera',   '".$language."',    'You don\'t have camera',   29),
            ('ALERT_MSG_GALLARY_PERMISSION',    'You don\'t have permission to access gallery.',    '".$language."',    'You don\'t have permission to access gallery.',    29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', '".$language."',    'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', '".$language."',    'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 29),
            ('BTN_DONE',    'Done', '".$language."',    'Done', 29),
            ('COMMENT', 'Comment',  '".$language."',    'Comment',  29),
            ('FULL_FORM',   'Full Form',    '".$language."',    'Full Form',    29),
            ('QUICK_CREATE',    'Create',   '".$language."',    'Create',   29),
            ('LBL_SELECT_FIELDS',   'Select Fields',    '".$language."',    'Select Fields',    29),
            ('LBL_SELECT_FIELDS',   'Select Fields',    '".$language."',    'Select Fields',    29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field',   '".$language."',    'Select First Field',   29),
            ('LBL_SELECT_SECOND_FIELDS',    'Select Second Field',  '".$language."',    'Select Second Field',  29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field',   '".$language."',    'Select Third Field',   29),
            ('LBL_SORT_BY_FIELD',   'Select Sort By Field', '".$language."',    'Select Sort By Field', 29),
            ('BTN_RESET_TO_DEFAULT',    'Reset to Default', '".$language."',    'Reset to Default', 29),
            ('MSG_SELECT_SORT_BY_FIELD',    'Select Sort by field', '".$language."',    'Select Sort by field', 29),
            ('kStrClearBtnTitle',   'Clear',    '".$language."',    'Clear',    29),
            ('kStrShowMoreBtnTitle',    'Show More',    '".$language."',    'Show More',    29),
            ('kStrAddActivitiesBtnTitle',   'Add Activities',   '".$language."',    'Add Activities',   29),
            ('kStrAddCommentPlaceHolder',   'Add your comments here',   '".$language."',    'Add your comments here',   29),
            ('MSG_ENTER_TO_EMAIL',  'Please enter to field.',   '".$language."',    'Please enter to field.',   29),
            ('WARNING_FILE',    'File can\'t open.',    '".$language."',    'File can\'t open.',    29),
            ('MSG_FILE_SAVED',  'File saved.',  '".$language."',    'File saved.',  29),
            ('WARNING_DOWNLOAD_FAIL',   'Download fail!, please try after sometime.',   '".$language."',    'Download fail!, please try after sometime.',   29),
            ('LBL_SHORTCUT',    'Shortcut', '".$language."',    'Shortcut', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', '".$language."',    'Type Message', 29),
            ('ALERT_INSTALL_WHATSAPP',  'Install Whatsapp', '".$language."',    'Install Whatsapp', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox',  '".$language."',    'No MailBox found. Please Create Mailbox',  29),
            ('LBL_WROTE',   'Wrote',    '".$language."',    'Wrote',    29),
            ('MSG_MAIL_SEND',   'Mail sent',    '".$language."',    'Mail sent',    29),
            ('log_file_not_found',  'API Log file not found.',  '".$language."',    'API Log file not found.',  29),
            ('unknown_error',   'An unknown error occurred, try again', '".$language."',    'An unknown error occurred, try again', 29),
            ('CTMTigerAppVersion',  'CRMTiger App Version', '".$language."',    'CRMTiger App Version', 29),
            ('CTMMobileUpdateMsg',  'CTMobile Ext. Version Update Successfully',    '".$language."',    'CTMobile Ext. Version Update Successfully',    29),
            ('dialog_Premium_downgrade',    'Downgrade will required logout and login again later', '".$language."',    'Downgrade will required logout and login again later', 29),
            ('dialog_Premium',  'Upgrade will required logout and login again later',   '".$language."',    'Upgrade will required logout and login again later',   29),
            ('Overwrite',   'Overwrite',    '".$language."',    'Overwrite',    29),
            ('MSGAddressOverwrite1',    'Overwrite the existing address with the selected', '".$language."',    'Overwrite the existing address with the selected', 29),
            ('MSGAddressOverwrite2',    'address details?', '".$language."',    'address details?', 29),
            ('UPGRADE_PLAN',    'Upgrade Plan', '".$language."',    'Upgrade Plan', 29),
            ('DOWNGRADE_PLAN',  'Downgrade Plan',   '".$language."',    'Downgrade Plan',   29),
            ('UPGRADE_EXTENSION',   'Upgrade Extension',    '".$language."',    'Upgrade Extension',    29),
            ('UPGRADE_APP', 'Upgrade App',  '".$language."',    'Upgrade App',  29),
            ('SELECT_OPTION',   'Select Option',    '".$language."',    'Select Option',    29),
            ('PLEASE_SELECT',   'Please select',    '".$language."',    'Please select',    29),
            ('MSG_ACCESS_DENIED',   'You don\'t have permission for this module.',  '".$language."',    'You don\'t have permission for this module.',  29),
            ('MSG_SELECT_RECCURING_MONTH_DAY',  'Please select reccuring day of month.',    '".$language."',    'Please select reccuring day of month.',    29),
            ('MSG_SELECT_RECCURING_WEEK_DAY',   'Please select reccuring day of week.', '".$language."',    'Please select reccuring day of week.', 29),
            ('MSG_SELECT_RECCURING_DAYS',   'Please select reccuring days.',    '".$language."',    'Please select reccuring days.',    29),
            ('Please select reccuring days.',   'Please select reccuring days.',    '".$language."',    'Please select reccuring days.',    29),
            ('MSG_SELECT_RECCURING_END_DATE',   'Please select reccuring end date.',    '".$language."',    'Please select reccuring end date.',    29),
            ('MSG_SELECT_RECCURING_TYPE',   'Please select reccuring type.',    '".$language."',    'Please select reccuring type.',    29),
            ('FREQ_TIME',   'Times',    '".$language."',    'Times',    29),
            ('REPEAT_YEARLY',   'Repeat Yearly',    '".$language."',    'Repeat Yearly',    29),
            ('REPEAT_MONTHLY',  'Repeat Monthly',   '".$language."',    'Repeat Monthly',   29),
            ('REPEAT_WEEKLY',   'Repeat Weekly',    '".$language."',    'Repeat Weekly',    29),
            ('REPEAT_DAILY',    'Repeat Daily', '".$language."',    'Repeat Daily', 29),
            ('ACTION_TITLE',    'Action Title', '".$language."',    'Action Title', 29),
            ('MSG_SELECT_VALID_DATE',   'Please select valid day of month.',    '".$language."',    'Please select valid day of month.',    29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', '".$language."',    'Start date should be less than end date.', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', '".$language."',    'Start time should be less than end time.', 29),
            ('LBL_LINEITEM_DETAILS',    'Lineitem Details', '".$language."',    'Lineitem Details', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT',    'Discount amount should be less than the total.',   '".$language."',    'Discount amount should be less than the total.',   29),
            ('VIEW',    'View', '".$language."',    'View', 29),
            ('MSG_ENTER_VALID', 'Please enter valid',   '".$language."',    'Please enter valid',   29),
            ('MSG_ENTER_PERCENTAGE',    'Percentage should be less than 100.',  '".$language."',    'Percentage should be less than 100.',  29),
            ('ITEM_TOTAL',  'Item Total',   '".$language."',    'Item Total',   29),
            ('ADJUSTMENT',  'Adjustment',   '".$language."',    'Adjustment',   29),
            ('TITLE_CHOOSE_IMAGE',  'Choose Image', '".$language."',    'Choose Image', 29),
            ('COMPRESS',    'Compress', '".$language."',    'Compress', 29),
            ('CHOOSE_ANOTHER_IMAGE',    'Your image size is too large, please select another image',    '".$language."',    'Your image size is too large, please select another image',    29),
            ('OnDayOfMonth',    'On day of month',  '".$language."',    'On day of month',  29),
            ('OnDayOfWeek', 'On day of week',   '".$language."',    'On day of week',   29),
            ('AddAndClose', 'Add & Close',  '".$language."',    'Add & Close',  29),
            ('Repeat',  'Repeat',   '".$language."',    'Repeat',   29),
            ('OnDay',   'On day',   '".$language."',    'On day',   29),
            ('View_Line_Item',  'View Line Item',   '".$language."',    'View Line Item',   29),
            ('TITLE_IMAGE', 'Image',    '".$language."',    'Image',    29),
            ('TITLE_ICLOUD',    'iCloud',   '".$language."',    'iCloud',   29),
            ('GOOGLE',  'Google',   '".$language."',    'Google',   29),
            ('ALERT_BTN_OKAY',  'Okay', '".$language."',    'Okay', 29),
            ('ALERT_TITLE_ACCESS_DENIED',   'Access Denied',    '".$language."',    'Access Denied',    29),
            ('Dont_Show_Again', 'Don\'t show again',    '".$language."',    'Don\'t show again',    29),
            ('Skip',    'Skip', '".$language."',    'Skip', 29),
            ('Fillter_Name',    'Fillter Name', '".$language."',    'Fillter Name', 29),
            ('Fillter_Record_Count',    'Fillter Record Count', '".$language."',    'Fillter Record Count', 29),
            ('url_note',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   '".$language."',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   26),
            ('vtiger_url',  'Your vTiger CRM URL',  '".$language."',    'Your vTiger CRM URL',  26),
            ('msg_doc_read_permission', 'You don\'t have permission to Add either This is read-only or Private Field.', '".$language."',    'You don\'t have permission to Add either This is read-only or Private Field.', 31),
            ('CLEAR',   'Clear',    '".$language."',    'Clear',    31),
            ('Files/photos uploaded successfully',  'Files/photos uploaded successfully',   '".$language."',    'Files/photos uploaded successfully',   32),
            ('Digital signature saved', 'Digital signature saved',  '".$language."',    'Digital signature saved',  32),
            ('Please upload Signature or Files/photos', 'Please upload Signature or Files/photos',  '".$language."',    'Please upload Signature or Files/photos',  32),
            ('Files / Photos',  'Files / Photos',   '".$language."',    'Files / Photos',   32),
            ('Signature',   'Signature',    '".$language."',    'Signature',    32),
            ('add_photo_using', 'Add Photo Using',  '".$language."',    'Add Photo Using',  31),
            ('btn_upload_sign', '(+) Add Signature',    '".$language."',    '(+) Add Signature',    31),
            ('btn_upload_photo_doc',    '(+) Upload Files/Photos',  '".$language."',    '(+) Upload Files/Photos',  31),
            ('select_photo_doc_to_upload',  'Please select files/photos to upload', '".$language."',    'Please select files/photos to upload', 31),
            ('related_module_title',    'Search from related module and Add to \"Route\"',  '".$language."',    'Search from related module and Add to \"Route\"',  30),
            ('Route status updated successfully',   'Route status updated successfully',    '".$language."',    'Route status updated successfully',    32),
            ('Session init failed', 'Session init failed',  '".$language."',    'Session init failed',  32),
            ('You don\'t have permission to access this resource',  'You don\'t have permission to access this resource',   '".$language."',    'You don\'t have permission to access this resource',   32),
            ('ctroute_realtedto cannot be empty',   'Could not get the Related To - Try again later',   '".$language."',    'Could not get the Related To - Try again later',   32),
            ('ctroute_planning cannot be empty',    'Could not get the Route Planning Record - Try again later',    '".$language."',    'Could not get the Route Planning Record - Try again later',    32),
            ('Something went wrong - Try again later',  'Something went wrong - Try again later',   '".$language."',    'Something went wrong - Try again later',   32),
            ('sequence updated successfully',   'sequence updated successfully',    '".$language."',    'sequence updated successfully',    32),
            ('sequence cannot be empty',    'sequence cannot be empty', '".$language."',    'sequence cannot be empty', 32),
            ('Shortcut details not saved',  'Shortcut details not saved',   '".$language."',    'Shortcut details not saved',   32),
            ('Shortcut details saved successfully', 'Shortcut details saved successfully',  '".$language."',    'Shortcut details saved successfully',  32),
            ('Route save successfully', 'Route save successfully',  '".$language."',    'Route save successfully',  32),
            ('Record save successfully',    'Record save successfully', '".$language."',    'Record save successfully', 32),
            ('No dependency found for picklist',    'No dependency found for picklist', '".$language."',    'No dependency found for picklist', 32),
            ('No records found',    'No records found', '".$language."',    'No records found', 32),
            ('Outgoing server is not enabled, please configure from CRM',   'Outgoing server is not enabled, please configure from CRM',    '".$language."',    'Outgoing server is not enabled, please configure from CRM',    32),
            ('Removed Successfully',    'Removed Successfully', '".$language."',    'Removed Successfully', 32),
            ('Shortcut has been deleted',   'Shortcut has been deleted',    '".$language."',    'Shortcut has been deleted',    32),
            ('relation of records removed successfully',    'relation of records removed successfully', '".$language."',    'relation of records removed successfully', 32),
            ('relation of records not removed', 'relation of records not removed',  '".$language."',    'relation of records not removed',  32),
            ('Record has been deleted successfully',    'Record has been deleted successfully', '".$language."',    'Record has been deleted successfully', 32),
            ('Time Tracking saved successfully',    'Time Tracking saved successfully', '".$language."',    'Time Tracking saved successfully', 32),
            ('Time Tracking updated successfully',  'Time Tracking updated successfully',   '".$language."',    'Time Tracking updated successfully',   32),
            ('Time Tracking ended successfully',    'Time Tracking ended successfully', '".$language."',    'Time Tracking ended successfully', 32),
            ('Time Tracking started successfully',  'Time Tracking started successfully',   '".$language."',    'Time Tracking started successfully',   32),
            ('record cannot be empty',  'record cannot be empty',   '".$language."',    'record cannot be empty',   32),
            ('Module is disabled',  'Module is disabled',   '".$language."',    'Module is disabled',   32),
            ('Shift ended successfully',    'Shift ended successfully', '".$language."',    'Shift ended successfully', 32),
            ('Shift started successfully',  'Shift started successfully',   '".$language."',    'Shift started successfully',   32),
            ('relation of records added successfully',  'relation of records added successfully',   '".$language."',    'relation of records added successfully',   32),
            ('Comment saved successfully',  'Comment saved successfully',   '".$language."',    'Comment saved successfully',   32),
            ('Comment not saved',   'Comment not saved',    '".$language."',    'Comment not saved',    32),
            ('Comment module is not active',    'Comment module is not active', '".$language."',    'Comment module is not active', 32),
            ('No Upcoming Event',   'No Upcoming Event',    '".$language."',    'No Upcoming Event',    32),
            ('No Templates found - create it from Message Templates module',    'No Templates found - create it from Message Templates module', '".$language."',    'No Templates found - create it from Message Templates module', 32),
            ('No event or task for this date',  'No event or task for this date',   '".$language."',    'No event or task for this date',   32),
            ('No filters created',  'No filters created',   '".$language."',    'No filters created',   32),
            ('Select at least one record to attach',    'Select at least one record to attach', '".$language."',    'Select at least one record to attach', 32),
            ('Please select one or more attachments',   'Please select one or more attachments',    '".$language."',    'Please select one or more attachments',    32),
            ('No event for this month', 'No event for this month',  '".$language."',    'No event for this month',  32),
            ('No Activity found',   'No Activity found',    '".$language."',    'No Activity found',    32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    '".$language."',    'Your feedback is valuable for us - it cannot be empty',    32),
            ('Could not send mail, Please try later',   'Could not send mail, Please try later',    '".$language."',    'Could not send mail, Please try later',    32),
            ('Latest Version updated successfully', 'Latest Version updated successfully',  '".$language."',    'Latest Version updated successfully',  32),
            ('User Location Updated Successfully',  'User Location Updated Successfully',   '".$language."',    'User Location Updated Successfully',   32),
            ('User Location not Updated Successfully',  'User Location not Updated Successfully',   '".$language."',    'User Location not Updated Successfully',   32),
            ('SMSNotifier is not enable in CRM. Please enable it first',    'SMSNotifier is not enable in CRM. Please enable it first', '".$language."',    'SMSNotifier is not enable in CRM. Please enable it first', 32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  '".$language."',    'Could not submit your feedback - Please try again later',  32),
            ('Thank you for submitting your feedback',  'Thank you for submitting your feedback',   '".$language."',    'Thank you for submitting your feedback',   32),
            ('Please upload User Image',    'Please upload User Image', '".$language."',    'Please upload User Image', 32),
            ('Image Not Uploading, please try again',   'Image Not Uploading, please try again',    '".$language."',    'Image Not Uploading, please try again',    32),
            ('User Image Uploaded Successfully',    'User Image Uploaded Successfully', '".$language."',    'User Image Uploaded Successfully', 32),
            ('Invalid Module name', 'Invalid Module name',  '".$language."',    'Invalid Module name',  32),
            ('Records Sync Successfully',   'Records Sync Successfully',    '".$language."',    'Records Sync Successfully',    32),
            ('Values cannot be empty',  'Values cannot be empty',   '".$language."',    'Values cannot be empty',   32),
            ('Record id is empty',  'Record id is empty',   '".$language."',    'Record id is empty',   32),
            ('Logout Successfully', 'Logout Successfully',  '".$language."',    'Logout Successfully',  32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    '".$language."',    'Please Enable CTMobile Module',    32),
            ('Authentication Failed',   'Username and Password do not match',   '".$language."',    'Username and Password do not match',   32),
            ('Mismatched module information',   'Something gone wrong, please try again later', '".$language."',    'Something gone wrong, please try again later', 32),
            ('Field does not exists',   'Please set display fields again',  '".$language."',    'Please set display fields again',  32),
            ('Module does not exists',  'Module does not exists or disabled by admin',  '".$language."',    'Module does not exists or disabled by admin',  32),
            ('Month cannot be empty',   'Could not get the Month - Try again later',    '".$language."',    'Could not get the Month - Try again later',    32),
            ('Year cannot be empty',    'Could not get the Year - Try again later', '".$language."',    'Could not get the Year - Try again later', 32),
            ('Date cannot be empty',    'Could not get the Date - Try again later', '".$language."',    'Could not get the Date - Try again later', 32),
            ('Userid cannot be empty',  'Could not get the Userid - Try again later',   '".$language."',    'Could not get the Userid - Try again later',   32),
            ('End Date cannot be empty',    'Could not get the status - Try again later',   '".$language."',    'Could not get the status - Try again later',   32),
            ('Start Date cannot be empty',  'Could not get the Start Date - Try again later',   '".$language."',    'Could not get the Start Date - Try again later',   32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  '".$language."',    'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  32),
            ('Longitude cannot be empty',   'Could not get location-Please try again',  '".$language."',    'Could not get location-Please try again',  32),
            ('Latitude cannot be empty',    'Could not get location-Please try again',  '".$language."',    'Could not get location-Please try again',  32),
            ('User cannot be empty',    'Could not get the User - Try again later', '".$language."',    'Could not get the User - Try again later', 32),
            ('Status cannot be empty',  'Could not get the status - Try again later',   '".$language."',    'Could not get the status - Try again later',   32),
            ('Required fields not found',   'Required fields not found',    '".$language."',    'Required fields not found',    32),
            ('Tracking module not active',  'Tracking module not active-Please contact CRM Admin',  '".$language."',    'Tracking module not active-Please contact CRM Admin',  32),
            ('Missing mandatory input values',  'Missing mandatory input values',   '".$language."',    'Missing mandatory input values',   32),
            ('No MailBox found. Please Create Mailbox', 'No MailBox found. Please Create Mailbox',  '".$language."',    'No MailBox found. Please Create Mailbox',  32),
            ('Mail not sent',   'Mail not sent',    '".$language."',    'Mail not sent',    32),
            ('Mail send successfully',  'Mail send successfully',   '".$language."',    'Mail send successfully',   32),
            ('Email Id or username not match with your record', 'Email Id or username not match with your record',  '".$language."',    'Email Id or username not match with your record',  32),
            ('Module not specified',    'Module not specified', '".$language."',    'Module not specified', 32),
            ('No messages found',   'No messages found',    '".$language."',    'No messages found',    32),
            ('No Dependency Found For This Module', 'No Dependency Found For This Module',  '".$language."',    'No Dependency Found For This Module',  32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   '".$language."',    'Outgoing server is not Enabled',   32),
            ('Outgoing server is Enabled',  'Outgoing server is Enabled',   '".$language."',    'Outgoing server is Enabled',   32),
            ('Email Attached Successfully', 'Email Attached Successfully',  '".$language."',    'Email Attached Successfully',  32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  '".$language."',    'Documents Attached Successfully',  32),
            ('Login required - Please login again', 'Login required - Please login again',  '".$language."',    'Login required - Please login again',  32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  '".$language."',    'Time tracking module is disable',  31),
            ('route_planning_module_disable',   'Route planning module is disable', '".$language."',    'Route planning module is disable', 31),
            ('mark_as_held',    'Are you sure you want to mark Event as Held?', '".$language."',    'Are you sure you want to mark Event as Held?', 31),
            ('stop_timer_msg',  'You have already started Time tracking for another record, Do you want to stop it first ?',    '".$language."',    'You have already started Time tracking for another record, Do you want to stop it first ?',    31),
            ('access_denied_routeplanning', 'Access denied for route planning', '".$language."',    'Access denied for route planning', 31),
            ('time_spent',  'Time Spent',   '".$language."',    'Time Spent',   31),
            ('select_user', 'Select User',  '".$language."',    'Select User',  30),
            ('status_cannot_be_held',   'Status cannot be held for future date start',  '".$language."',    'Status cannot be held for future date start',  30),
            ('please_select_end_date',  'Please select end date',   '".$language."',    'Please select end date',   30),
            ('please_select_start_date',    'Please select start date', '".$language."',    'Please select start date', 30),
            ('tap_on_plus_icon_for_select_route',   'Tap on + icon to select record for your route.',   '".$language."',    'Tap on + icon to select record for your route.',   30),
            ('please_enter_notes',  'Please enter notes',   '".$language."',    'Please enter notes',   30),
            ('please_enter_title',  'Please enter title',   '".$language."',    'Please enter title',   30),
            ('please_select_date',  'Please Select Date',   '".$language."',    'Please Select Date',   30),
            ('search_by_date',  'Search by Date',   '".$language."',    'Search by Date',   30),
            ('shortcut_not_setup_yet',  'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  '".$language."',    'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  30),
            ('max_upload_size', 'max file Upload exceeds',  '".$language."',    'max file Upload exceeds',  30),
            ('unselect_all',    'UnSelect All', '".$language."',    'UnSelect All', 30),
            ('select_all',  'Select All',   '".$language."',    'Select All',   30),
            ('please_select_records',   'Please select records',    '".$language."',    'Please select records',    30),
            ('select_date', 'Select Date',  '".$language."',    'Select Date',  30),
            ('quantity_in_stock_is',    'Quantity in stock is', '".$language."',    'Quantity in stock is', 30),
            ('replies', 'Replies',  '".$language."',    'Replies',  30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', '".$language."',    'Conversion requires selection of Contact or Organization', 30),
            ('please_select_product',   'Please Select Product',    '".$language."',    'Please Select Product',    30),
            ('timer_msg',   'You can start timer for single task only at same time',    '".$language."',    'You can start timer for single task only at same time',    31),
            ('save_start_tracking', 'Save & Start Tracking',    '".$language."',    'Save & Start Tracking',    31),
            ('lbl_notes',   'Notes',    '".$language."',    'Notes',    31),
            ('enter_title', 'Enter Title',  '".$language."',    'Enter Title',  31),
            ('select_module_record',    'Select Module / Record',   '".$language."',    'Select Module / Record',   31),
            ('lbl_tomorrow',    'Tomorrow', '".$language."',    'Tomorrow', 30),
            ('lbl_yesterday',   'Yesterday',    '".$language."',    'Yesterday',    30),
            ('lbl_today',   'Today',    '".$language."',    'Today',    30),
            ('time_tracker',    'Time Tracker', '".$language."',    'Time Tracker', 31),
            ('time_end',    'End Time', '".$language."',    'End Time', 5),
            ('due_date',    'End Date', '".$language."',    'End Date', 5),
            ('time_start',  'Time Start',   '".$language."',    'Time Start',   5),
            ('date_start',  'Start Date',   '".$language."',    'Start Date',   5),
            ('delete_widget_msg',   'Display widget again by using (+) option', '".$language."',    'Display widget again by using (+) option', 15),
            ('no_upcoming_activities',  'No scheduled activities    ',  '".$language."',    'No scheduled activities    ',  15),
            ('check_in_first',  'Please check-in first',    '".$language."',    'Please check-in first',    30),
            ('duration',    'Duration', '".$language."',    'Duration', 30),
            ('distance',    'Distance', '".$language."',    'Distance', 30),
            ('proper_address_message',  'Please enter proper address in record\n',  '".$language."',    'Please enter proper address in record',    30),
            ('select_status',   'Select Status',    '".$language."',    'Select Status',    30),
            ('route_planner',   'Route Planner',    '".$language."',    'Route Planner',    30),
            ('route_planning',  'Route Planning',   '".$language."',    'Route Planning',   30),
            ('add_route',   'Add Route',    '".$language."',    'Add Route',    30),
            ('calender_disabled',   'Calendar Module is disabled',  '".$language."',    'Calendar Module is disabled',  30),
            ('close_dialog',    'Close form',   '".$language."',    'Close form',   30),
            ('cancel_form_message', 'Are You sure want to close ?', '".$language."',    'Are You sure want to close ?', 30),
            ('create_route',    'Create Route', '".$language."',    'Create Route', 30),
            ('select_module_create_route',  'Select Module to create Route',    '".$language."',    'Select Module to create Route',    30),
            ('cancel',  'Cancel',   '".$language."',    'Cancel',   30),
            ('assign_route',    'Assign Route', '".$language."',    'Assign Route', 30),
            ('route_for',   'Route for',    '".$language."',    'Route for',    30),
            ('assigned_to', 'Assigned To',  '".$language."',    'Assigned To',  30),
            ('enter_route_name',    'Enter Route Name', '".$language."',    'Enter Route Name', 30),
            ('list',    'List', '".$language."',    'List', 30),
            ('map', 'Map',  '".$language."',    'Map',  30),
            ('other_modules',   'Other Modules',    '".$language."',    'Other Modules',    15),
            ('shortcut_no_record_msg',  'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', '".$language."',    'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 25),
            ('clear',   'Clear',    '".$language."',    'Clear',    25),
            ('open',    'Open', '".$language."',    'Open', 11),
            ('max_file_msg',    'Too many files selected (max:6)',  '".$language."',    'Too many files selected (max:6)',  11),
            ('error_voicenote_record',  'Unable to recording voice while another application is recording sound.',  '".$language."',    'Unable to recording voice while another application is recording sound.',  11),
            ('msg_warning', 'Warning!', '".$language."',    'Warning!', 11),
            ('Permision_denied_contact',    'Permission denied to access your contacts',    '".$language."',    'Permission denied to access your contacts',    15),
            ('no_widget_added', 'Please click + icon to add new widget to your dashboard.', '".$language."',    'Please click + icon to add new widget to your dashboard.', 15),
            ('no_data_available',   'Data not available, please check the selected fields', '".$language."',    'Data not available, please check the selected fields', 15),
            ('check_out_successfully',  'Check out successfully',   '".$language."',    'Checked out successfully', 11),
            ('check_in_successfully',   'Check in successfully',    '".$language."',    'Checked in successfully',  11),
            ('check_out',   'Check out',    '".$language."',    'Check out',    11),
            ('check_in',    'Check in', '".$language."',    'Check in', 11),
            ('navigate',    'Navigate', '".$language."',    'Navigate', 11),
            ('save_to_phone_vcard_success', 'VCard Saved to phone successfully',    '".$language."',    'VCard Saved to phone successfully',    15),
            ('download_vcard_success',  'VCard downloaded successfully',    '".$language."',    'VCard downloaded successfully',    15),
            ('card_details',    'Card Details', '".$language."',    'Card Details', 15),
            ('add_widget',  'Add Widget',   '".$language."',    'Add Widget',   15),
            ('delete_widget',   'Are you sure to hide widget?', '".$language."',    'Are you sure to hide widget?', 15),
            ('already_widgets_added',   'All types of Widget & reports are already added',  '".$language."',    'All types of Widget & reports are already added',  15),
            ('retry',   'Retry',    '".$language."',    'Retry',    28),
            ('retake',  'Retake',   '".$language."',    'Retake',   28),
            ('Reports', 'Reports',  '".$language."',    'Reports',  15),
            ('Widgets', 'Widgets',  '".$language."',    'Widgets',  15),
            ('vcard_config',    'Vcard Configuration',  '".$language."',    'Vcard Configuration',  8),
            ('save_to_phone',   'Save to phone',    '".$language."',    'Save to phone',    11),
            ('download_vcard',  'Download Vcard',   '".$language."',    'Download Vcard',   11),
            ('share_vcard', 'Share Vcard',  '".$language."',    'Share Vcard',  11),
            ('share_record',    'Share Record', '".$language."',    'Share Record', 11),
            ('permission_denied_edit',  'You don\'t have permission to edit this record.',  '".$language."',    'You don\'t have permission to edit this record.',  27),
            ('permission_denied_delete',    'You don\'t have permission to delete this record.',    '".$language."',    'You don\'t have permission to delete this record.',    27),
            ('Voice_Recording_Started', 'Recording Started',    '".$language."',    'Recording Started',    12),
            ('Voice_Recording_Stopped', 'Recording Stopped',    '".$language."',    'Recording Stopped',    12),
            ('SEARCH',  'Search',   '".$language."',    'Search',   7),
            ('LAST',    'Last', '".$language."',    'Last', 7),
            ('FIRST',   'First',    '".$language."',    'First',    7),
            ('MONDAY',  'Monday',   '".$language."',    'Monday',   7),
            ('TUESDAY', 'Tuesday',  '".$language."',    'Tuesday',  7),
            ('WEDNESDAY',   'Wednesday',    '".$language."',    'Wednesday',    7),
            ('THURSDAY',    'Thursday', '".$language."',    'Thursday', 7),
            ('FRIDAY',  'Friday',   '".$language."',    'Friday',   7),
            ('SATURDAY',    'Saturday', '".$language."',    'Saturday', 7),
            ('SUNDAY',  'Sunday',   '".$language."',    'Sunday',   7),
            ('DAILY',   'Daily',    '".$language."',    'Daily',    7),
            ('WEEKLY',  'Weekly',   '".$language."',    'Weekly',   7),
            ('MONTHLY', 'Monthly',  '".$language."',    'Monthly',  7),
            ('YEARLY',  'Yearly',   '".$language."',    'Yearly',   7),
            ('asset_tracking',  'Asset tracking',   '".$language."',    'Asset tracking',   15),
            ('open_file',   'Open File',    '".$language."',    'Open File',    1),
            ('download_pdf_successfully',   'Download PDF Successfully',    '".$language."',    'Download PDF Successfully',    1),
            ('select_pdf',  'Select PDF',   '".$language."',    'Select PDF',   1),
            ('email_pdf',   'Email PDF',    '".$language."',    'Email PDF',    1),
            ('download_pdf',    'Download PDF', '".$language."',    'Download PDF', 1),
            ('edit_route',  'Edit Route',   '".$language."',    'Edit Route',   1),
            ('save_route',  'Save Route',   '".$language."',    'Save Route',   1),
            ('clear_all',   'Clear All',    '".$language."',    'Clear All',    1),
            ('notification',    'Notifications',    '".$language."',    'Notifications',    1),
            ('menu_management', 'Menu Management',  '".$language."',    'Menu Management',  1),
            ('select_menu', 'Select Menu',  '".$language."',    'Select Menu',  1),
            ('module_record_not_found', 'Module and Record not found',  '".$language."',    'Module and Record not found',  1),
            ('reason_for_changing_comments',    'Reason for changing comments', '".$language."',    'Reason for changing comments', 1),
            ('edit_reason', 'Edit Reason',  '".$language."',    'Edit Reason',  1),
            ('create_filters',  'Create Filter',    '".$language."',    'Create Filter',    1),
            ('you_checked', 'You Checked',  '".$language."',    'You Checked',  1),
            ('you_un_checked',  'You UnChecked',    '".$language."',    'You UnChecked',    1),
            ('log_the_call',    'Log the call ?',   '".$language."',    'Log the call ?',   1),
            ('add_a_description_(optional)',    'Add a description (optional)', '".$language."',    'Add a description (optional)', 1),
            ('called',  'Called',   '".$language."',    'Called',   1),
            ('call_log',    'Call Log', '".$language."',    'Call Log', 1),
            ('subject', 'Subject',  '".$language."',    'Subject',  1),
            ('add_condition',   'Add Condition',    '".$language."',    'Add Condition',    1),
            ('select_condition',    'Select Condition', '".$language."',    'Select Condition', 1),
            ('please_select_first_field',   'Please First Select field',    '".$language."',    'Please First Select field',    1),
            ('filter_name', 'Filter Name',  '".$language."',    'Filter Name',  1),
            ('enter_filter_name',   'Enter filter name',    '".$language."',    'Enter filter name',    1),
            ('choose_conditions',   'Choose Conditions',    '".$language."',    'Choose Conditions',    1),
            ('all_condition',   'All Conditions(All conditions must be met)',   '".$language."',    'All Conditions(All conditions must be met)',   1),
            ('any_condition',   'Any Conditions(At least one the conditions must be met)',  '".$language."',    'Any Conditions(At least one the conditions must be met)',  1),
            ('lattitude',   'latitude', '".$language."',    'latitude', 1),
            ('notification_settings',   'Notification Settings',    '".$language."',    'Notification Settings',    1),
            ('notification_management', 'Notification Management',  '".$language."',    'Notification Management',  1),
            ('addyourcommentshere', 'Type @ to mention user',   '".$language."',    'Type @ to mention user',   1),
            ('google_api_key_missing',  'Google Api key is missing.',   '".$language."',    'Google Api key is missing.',   1),
            ('event_filter_by', 'Event Filter by',  '".$language."',    'Event Filter by',  1),
            ('apply',   'Apply',    '".$language."',    'Apply',    1),
            ('choose_from_gallery', 'Choose From Gallery',  '".$language."',    'Choose From Gallery',  1),
            ('choose_from_camera',  'Choose From Camera',   '".$language."',    'Choose From Camera',   1),
            ('mutli_select_CB', 'Mutli Select CB',  '".$language."',    'Mutli Select CB',  1),
            ('please_select_condition', 'Please Select Condition',  '".$language."',    'Please Select Condition',  1),
            ('please_enter_value_or_field', 'Please Enter Value or Field',  '".$language."',    'Please Enter Value or Field',  1),
            ('set_as_default',  'Set as Default',   '".$language."',    'Set as Default',   1),
            ('list_in_metrics', 'List in Metrics',  '".$language."',    'List in Metrics',  1),
            ('order_number',    'Order Number', '".$language."',    'Order Number', 1),
            ('recording_saved_message', 'Recording saved successfully.',    '".$language."',    'Recording saved successfully.',    1),
            ('recording_file',  'Recording File',   '".$language."',    'Recording File',   1),
            ('file_not_found',  'File not found',   '".$language."',    'File not found',   1),
            ('please_enter_valid_path', 'Please enter valid path',  '".$language."',    'Please enter valid path',  1),
            ('enter_path_here', 'Enter path here...',   '".$language."',    'Enter path here...',   1),
            ('set_call_recording_path', 'Set Call Recording Path',  '".$language."',    'Set Call Recording Path',  1),
            ('set_call_recording_path_here',    'Set call recording path here', '".$language."',    'Set call recording path here', 1),
            ('call_recording_path', 'Call Recording Path',  '".$language."',    'Call Recording Path',  1),
            ('please_place_api',    'Please enable place api',  '".$language."',    'Please enable place api',  1),
            ('event_filters_by',    'Event Filters by', '".$language."',    'Event Filters by', 1),
            ('select_at_least_one_option',  'Please select at least one option',    '".$language."',    'Please select at least one option',    1),
            ('enable_call_feature', 'Please enable call feature',   '".$language."',    'Please enable call feature',   1),
            ('enable_email_feature',    'Please enable email feature',  '".$language."',    'Please enable email feature',  1),
            ('demo_login',  'Demo Login',   '".$language."',    'Demo Login',   1),
            ('select_email_template',   'Select Email Template',    '".$language."',    'Select Email Template',    1),
            ('template_name',   'Template Name',    '".$language."',    'Template Name',    1),
            ('example_storage_path',    'example : storage/Music/Recordings/Call Recordings',   '".$language."',    'example : storage/Music/Recordings/Call Recordings',   1),
            ('User Notification Settings saved successfully',   'User Notification Settings saved successfully',    '".$language."',    'User Notification Settings saved successfully',    33),
            ('This Notification has been disabled by admin',    'This Notification has been disabled by admin', '".$language."',    'This Notification has been disabled by admin', 33),
            ('Notify when any updates to the record you\'re following', 'Notify when any updates to the record you\'re following',  '".$language."',    'Notify when any updates to the record you\'re following',  33),
            ('Task assigned to you',    'Task assigned to you', '".$language."',    'Task assigned to you', 33),
            ('Task Reminder',   'Task Reminder',    '".$language."',    'Task Reminder',    33),
            ('You were mentioned in comments',  'You were mentioned in comments',   '".$language."',    'You were mentioned in comments',   33),
            ('Comments has been added to record assigned to you',   'Comments has been added to record assigned to you',    '".$language."',    'Comments has been added to record assigned to you',    33),
            ('When Record Assigned',    'When Record Assigned', '".$language."',    'When Record Assigned', 33),
            ('Event Reminder',  'Event Reminder',   '".$language."',    'Event Reminder',   33),
            ('Event Invitation',    'Event Invitation', '".$language."',    'Event Invitation', 33),
            ('Follow record',   'Follow record',    '".$language."',    'Follow record',    33),
            ('Task',    'Task', '".$language."',    'Task', 33),
            ('Conversions', 'Conversions',  '".$language."',    'Conversions',  33),
            ('Events',  'Events',   '".$language."',    'Events',   33),
            ('no_records_changed_filter_message',   'No record(s) found Please click on filter icon to change filter',  '".$language."',    'No record(s) found Please click on filter icon to change filter',  1),
            ('title',   'Title',    '".$language."',    'Title',    1),
            ('dialog_recent_call_info', 'Click + to select your mobile call recording folder where your recorded call files are stored.',   '".$language."',    'Click + to select your mobile call recording folder where your recorded call files are stored.',   1),
            ('call_recording',  'Call recording',   '".$language."',    'Call recording',   1),
            ('voice_recorder',  'Voice Recorder',   '".$language."',    'Voice Recorder',   1),
            ('no_address_reference_found',  'No Address Reference found',   '".$language."',    'No Address Reference found',   32),
            ('no_overdue_activities',   'No OverDue Activities',    '".$language."',    'No OverDue Activities',    32),
            ('latitude_longitude_validation_message',   'Please enter proper address from this address we are not getting proper latitude and longitude',   '".$language."',    'Please enter proper address from this address we are not getting proper latitude and longitude',   32),
            ('Default_Search_Field',    'Default search field', '".$language."',    'Default search field', 32),
            ('Calender_Reminder_Message',   'Free user can\'t send local reminder', '".$language."',    'Free user can\'t send local reminder', 32),
            ('you_must_have_permission',    'You must give permissions to use this features.',  '".$language."',    'You must give permissions to use this features.',  32),
            ('internal_comment',    'Internal Comment', '".$language."',    'Internal Comment', 1),
            ('unlink_record',   'Unlink Record',    '".$language."',    'Unlink Record',    11),
            ('unlink_record_msg',   'Are you sure want to unlink record?',  '".$language."',    'Are you sure want to unlink record?',  11),
            ('file_format_not_support', 'File format not supported',    '".$language."',    'File format not supported',    11),
            ('file_upload', 'File Upload',  '".$language."',    'File Upload',  5),
            ('to_vtiger',   'To Vtiger',    '".$language."',    'To Vtiger',    5),
            ('link_external_document',  'Link External Document',   '".$language."',    'Link External Document',   5),
            ('from_file_url',   'From File Url',    '".$language."',    'From File Url',    5),
            ('create_new_document', 'Create New Document',  '".$language."',    'Create New Document',  5),
            ('select_document_type',    'Select Document type', '".$language."',    'Select Document type', 5),
            ('add_signature',   'Please add signature', '".$language."',    'Please add signature', 11),
            ('date_greater_then_equal', 'should be greater than or equal to',   '".$language."',    'should be greater than or equal to',   1),
            ('date_less_then_equal',    'should be less than or equal to',  '".$language."',    'should be less than or equal to',  1),
            ('Click_on_plus_for_add',   'Please tap on  +  to create a new record.',    '".$language."',    'Please tap on  +  to create a new record.',    15),
            ('display_map', 'Display map',  '".$language."',    'Display map',  15),
            ('other_settings',  'Other settings',   '".$language."',    'Other settings',   15),
            ('total_hours', 'Total hours',  '".$language."',    'Total hours',  15),
            ('widget_not_found',    'No widgets found', '".$language."',    'No widgets found', 15),
            ('quickaction', 'Quick action', '".$language."',    'Quick action', 15),
            ('dashboard',   'Dashboard',    '".$language."',    'Dashboard',    15),
            ('new', 'New',  '".$language."',    'New',  15),
            ('global_search_hint',  'Please try to search using search box at top', '".$language."',    'Please try to search using search box at top', 15),
            ('near_by_map', 'Near By Map',  '".$language."',    'Near By Map',  15),
            ('miles',   'Miles',    '".$language."',    'Miles',    15),
            ('lbl_filters', 'Filters',  '".$language."',    'Filters',  27),
            ('warning', 'Warning',  '".$language."',    'Warning',  27),
            ('no_filter_created',   'No filter is created.',    '".$language."',    'No filter is created.',    27),
            ('please_create_new_ilter', 'Please create a new filter',   '".$language."',    'Please create a new filter',   27),
            ('select_search_fields',    'Select fields for the search record.', '".$language."',    'Select fields for the search record.', 27),
            ('apply_fliters',   'Apply filters',    '".$language."',    'Apply filters',    27),
            ('sort_by', 'Sort by',  '".$language."',    'Sort by',  27),
            ('sort_order',  'Sort order',   '".$language."',    'Sort order',   27),
            ('Start_time_tracking', 'Start time tracking',  '".$language."',    'Start time tracking',  31),
            ('Stop_time_tracking',  'Stop time tracking',   '".$language."',    'Stop time tracking',   31),
            ('image_preview',   'Image preview',    '".$language."',    'Image preview',    11),
            ('phone_number',    'Phone number', '".$language."',    'Phone number', 11),
            ('email_address',   'Email address',    '".$language."',    'Email address',    11),
            ('edit_your_preferences',   'Edit your preferences',    '".$language."',    'Edit your preferences',    8),
            ('about_app',   'About app',    '".$language."',    'About app',    8),
            ('updated_ctmobile_ext_version',    'You already have latest CTMobile Ext. Version',    '".$language."',    'You already have latest CTMobile Ext. Version',    8),
            ('updated_app_version', 'You already have latest CRMTiger App Version', '".$language."',    'You already have latest CRMTiger App Version', 8),
            ('plan',    'Plan', '".$language."',    'Plan', 8),
            ('time',    'Time', '".$language."',    'Time', 31),
            ('error_log_msg',   'Oops, something went wrong! Please click on Share Button to share error log with our technical team',  '".$language."',    'Oops, something went wrong! Please click on Share Button to share error log with our technical team',  1),
            ('add_to_quick_action', 'Add to quick action',  '".$language."',    'Add to quick action',  1),
            ('add_filter_to_quick_action',  'Add filter to quick action',   '".$language."',    'Add filter to quick action',   1),
            ('create_record',   'Create Record',    '".$language."',    'Create Record',    1),
            ('quick_action_hint',   'You can Add Quick Action here',    '".$language."',    'You can Add Quick Action here',    1),
            ('str_send',    'Send', '".$language."',    'Send', 3),
            ('tax_region_msg',  'Do you want to update tax & charge values corresponding to selected region?',  '".$language."',    'Do you want to update tax & charge values corresponding to selected region?',  1),
            ('delete_quick_action_widgest', 'Delete Widget?',   '".$language."',    'Delete Widget?',   15),
            ('add_record_to_dashboard', 'Add record to dashboard',  '".$language."',    'Add record to dashboard',  15),
            ('module_quick_action_msg', 'Module added to dashboard',    '".$language."',    'Module added to dashboard',    15),
            ('filter_quick_action_msg', 'Filter added to dashboard',    '".$language."',    'Filter added to dashboard',    15),
            ('record_quick_action_msg', 'Record added to dashboard',    '".$language."',    'Record added to dashboard',    15),
            ('filter_shortcut_quick_action_msg',    'Filter shortcut added to dashboard',   '".$language."',    'Filter shortcut added to dashboard',   15),
            ('record_shortcut_quick_action_msg',    'Record shortcut added to dashboard',   '".$language."',    'Record shortcut added to dashboard',   15),
            ('documents_disabled',  'Documents Module is disabled', '".$language."',    'Documents Module is disabled', 1),
            ('document_dont_attachment',    'Document does not have a attachment',  '".$language."',    'Document does not have a attachment',  1),
            ('go_to_neat_by',   'Go to NearBy', '".$language."',    'Go to NearBy', 15),
            ('go_to_time_tracking', 'Go to Time Tracker',   '".$language."',    'Go to Time Tracker',   13),
            ('nearby_quick_action_msg', 'NearBy added to dashboard',    '".$language."',    'NearBy added to dashboard',    15),
            ('time_tracking_quick_action_msg',  'Time Tracking added to dashboard', '".$language."',    'Time Tracking added to dashboard', 15),
            ('attendance_quick_action_msg', 'Attendance added to dashboard',    '".$language."',    'Attendance added to dashboard',    15),
            ('attachment',  'Attachment',   '".$language."',    'Attachment',   15),
            ('search_by_fields',    'Search by fields', '".$language."',    'Search by fields', 27),
            ('apply_selected',  'Apply selected',   '".$language."',    'Apply selected',   27),
            ('auto_address_disabled',   'auto address finder is disabled, please enable it from CRMTiger Settings', '".$language."',    'auto address finder is disabled, please enable it from CRMTiger Settings', 1),
            ('Attendance',  'Attendance',   '".$language."',    'Attendance',   15),
            ('Check-in successfully',   'Check-in successfully',    '".$language."',    'Check-in successfully',    32),
            ('Check-out successfully',  'Check-out successfully',   '".$language."',    'Check-out successfully',   32),
            ('Nothing around here', 'Nothing around here',  '".$language."',    'Nothing around here',  13),
            ('select_days', 'Select Days',  '".$language."',    'Select Days',  5),
            ('select_minutes',  'Select Minutes',   '".$language."',    'Select Minutes',   5),
            ('select_hours',    'Select Hours', '".$language."',    'Select Hours', 5),
            ('no_lat_long_found',   'Location information (Latitude,Longitude) not found',  '".$language."',    'Location information (Latitude,Longitude) not found',  32),
            ('Call Log save successfully',  'Call Log save successfully',   '".$language."',    'Call Log save successfully',   32),
            ('Files/photos deleted successfully',   'Files/photos deleted successfully',    '".$language."',    'Files/photos deleted successfully',    32),
            ('important',   'Important',    '".$language."',    'Important',    34),
            ('template',    'Template', '".$language."',    'Template', 34),
            ('copy',    'Copy', '".$language."',    'Copy', 34),
            ('camera',  'Camera',   '".$language."',    'Camera',   34),
            ('gallery', 'Gallery',  '".$language."',    'Gallery',  34),
            ('audio',   'Audio',    '".$language."',    'Audio',    34),
            ('last_seen_at',    'Last seen at', '".$language."',    'Last seen at', 34),
            ('type_a_message',  'Type a message',   '".$language."',    'Type a message',   34),
            ('all_messages',    'All messages', '".$language."',    'All messages', 34),
            ('time_tracking_reports',   'Time tracking reports',    '".$language."',    'Time tracking reports',    31),
            ('attendance_reports',  'Attendance reports',   '".$language."',    'Attendance reports',   31),
            ('chats',   'Chats',    '".$language."',    'Chats',    34),
            ('Marked chat as Important',    'Marked chat as Important', '".$language."',    'Marked chat as Important', 34),
            ('Unmarked chat as Important',  'Unmarked chat as Important',   '".$language."',    'Unmarked chat as Important',   34),
            ('mark_as_important',   'Mark as important',    '".$language."',    'Mark as important',    34),
            ('unmark_As_important', 'Unmark as important',  '".$language."',    'Unmark as important',  34),
            ('select_template', 'Select template',  '".$language."',    'Select template',  34),
            ('chat',    'Chat', '".$language."',    'Chat', 34),
            ('search_by_name_or_contact',   'Search by name or contact',    '".$language."',    'Search by name or contact',    34),
            ('choose_contact_for_whatsApp', 'Choose contact for whatsApp',  '".$language."',    'Choose contact for whatsApp',  34),
            ('whatsapp_template',   'Whatsapp template',    '".$language."',    'Whatsapp template',    34),
            ('send_voice_recording',    'Send voice recording', '".$language."',    'Send voice recording', 34),
            ('slide_to_cancel', 'Slide To Cancel',  '".$language."',    'Slide To Cancel',  34),
            ('whatsapp_disconnect_messsage',    'Ooops.. You\'re disconnected from WhatsApp. Please Scan QR Code from the CRM.',    '".$language."',    'Ooops.. You\'re disconnected from WhatsApp. Please Scan QR Code from the CRM.',    34),
            ('select_priority', 'Select priority',  '".$language."',    'Select priority',  30),
            ('repeat_route',    'Repeat route', '".$language."',    'Repeat route', 30),
            ('change_assign_to',    'Change assigned to',   '".$language."',    'Change assigned to',   30),
            ('Multiple Route created successfully', 'Multiple Route created successfully',  '".$language."',    'Multiple Route created successfully',  30),
            ('Route duplicated successfully',   'Route duplicated successfully',    '".$language."',    'Route duplicated successfully',    30);",array());
        }
    }

    static function ar_ae(){
        global $adb;
        $checkLang = $adb->pquery("SELECT 1 FROM ctmobile_language_keyword WHERE keyword_lang = ?",array('ar_ae'));
        if($adb->num_rows($checkLang) == 0){
            $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error',   'Network connection error!',    'ar_ae',    'خطأ في الشبكة!',   1),
            ('connection_check',    'Could not connect to CRM, Please check your Internet connection.', 'ar_ae',    'الرجاء التحقق من اتصال الانترنت الخاص بك.',    1),
            ('update',  'Update',   'ar_ae',    'تحديث',    1),
            ('cancel',  'Cancel',   'ar_ae',    'يلغي', 1),
            ('ok',  'Ok',   'ar_ae',    'حسنا', 1),
            ('more_information',    'Click here for more information.', 'ar_ae',    'انقر هنا للمزيد من المعلومات.',    1),
            ('yes', 'Yes',  'ar_ae',    'نعم فعلا', 1),
            ('no',  'No',   'ar_ae',    'لا',   1),
            ('click_again_exit',    'Click again to exit',  'ar_ae',    'انقر مرة أخرى للخروج', 1),
            ('forpermission',   'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.',   'ar_ae',    'ليس لديك إذن لعرض هذه الميزات. يرجى الاشتراك للحصول على نسخة متميزة انقر هنا للاشتراك.',   1),
            ('clickhere',   'Click here',   'ar_ae',    'انقر هنا', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version',  'ar_ae',    'انقر هنا للاشتراك في الإصدار المميز',  1),
            ('clickhere_configure', 'Click here and view how to Configure.',    'ar_ae',    'انقر هنا وعرض كيفية تكوين.',   1),
            ('please_wait', 'Please Wait…', 'ar_ae',    'ارجوك انتظر…', 1),
            ('share__msg',  'Share file with',  'ar_ae',    'مشاركة الملف مع',  1),
            ('dialog_camera',   'Camera',   'ar_ae',    'الة تصوير',    1),
            ('dialog_add_file_by',  'Take Photo from',  'ar_ae',    'إضافة ملفات',  1),
            ('add', 'Add',  'ar_ae',    'إضافة',    1),
            ('mail_manager_configured', 'Mail Manager is not configured',   'ar_ae',    'لم يتم تكوين مدير البريد', 1),
            ('dialog_add_files_by', 'Add Files by', 'ar_ae',    'إضافة ملفات',  1),
            ('dialog_drive',    'Drive',    'ar_ae',    'قيادة',    1),
            ('dialog_drop_box', 'Drop Box', 'ar_ae',    'بصندوق الإسقاط',   1),
            ('dialog_need_signin',  'You need to Sign-in to your Drive account first.', 'ar_ae',    'يجب تسجيل الدخول إلى حساب Drive أولاً.',   1),
            ('dialog_gallery',  'Gallery',  'ar_ae',    'صالة عرض', 1),
            ('delete',  'Delete',   'ar_ae',    'حذف',  1),
            ('timeoutmessage',  'Oops! Request is taking more time than expected.', 'ar_ae',    'انتبه! الطلب يستغرق وقتًا أكثر مما هو متوقع.', 1),
            ('gps_location_message',    'GPS is not enabled. Please turn it on to get your near by locations.', 'ar_ae',    'لم يتم تمكين GPS. يرجى تشغيلها للحصول على قرب من المواقع.',    1),
            ('sure_want_delete',    'Are you sure want to delete ?',    'ar_ae',    'هل أنت متأكد من حذف؟', 1),
            ('select',  'Select',   'ar_ae',    'تحديد',    1),
            ('msgforrecordaudio',   'Minimum record duration one second.',  'ar_ae',    'اقل وقت للتسجيل ثانيه واحده',  1),
            ('permission_storage',  'Permission denied to read your External storage',  'ar_ae',    'تم رفض الإذن لقراءة وحدة التخزين الخارجية',    1),
            ('send_permission_msg', 'Send message permission denied',   'ar_ae',    'إرسال تم رفض الإذن',   1),
            ('choosefile',  'Choose File',  'ar_ae',    'اختر ملف', 1),
            ('enter',   'Enter',    'ar_ae',    'أدخل', 1),
            ('select_an_option',    'Select an Option', 'ar_ae',    'اختار',    1),
            ('email_validation',    'Email is not valid',   'ar_ae',    'البريد الإلكتروني غير صالح',   1),
            ('please_enter',    'Please Enter', 'ar_ae',    'تفضل ',    1),
            ('website_validation_text', 'Website URL is not valid', 'ar_ae',    'عنوان url للموقع غير صالح',    1),
            ('selectvalue', 'Select value first',   'ar_ae',    'حدد القيمة أولا',  1),
            ('email',   'Email',    'ar_ae',    'البريد الإلكتروني',    1),
            ('enter_email_address', 'Enter email address',  'ar_ae',    'أدخل عنوان البريد الالكتروني', 1),
            ('email_address_not_correct',   'Email address incorrect',  'ar_ae',    'عنوان البريد الالكتروني غير صحيح', 1),
            ('pls_enter_subject',   'Please Enter Subject', 'ar_ae',    'من فضلك أدخل الموضوع', 1),
            ('attachFiles', 'Attached File',    'ar_ae',    'ملف مرفق', 1),
            ('from',    'From', 'ar_ae',    'من عند',   1),
            ('to',  'To',   'ar_ae',    'إلى',  1),
            ('call_permission_msg', 'Call permission denied',   'ar_ae',    'رفض تصريح المكالمة',   1),
            ('no_records',  'No records found', 'ar_ae',    'لا توجد سجلات',    1),
            ('fullform',    'Create New',   'ar_ae',    'خلق جديد إبداع جديد',  1),
            ('save',    'Save', 'ar_ae',    'حفظ',  1),
            ('total',   'Total',    'ar_ae',    'مجموع',    1),
            ('discount',    'Discount', 'ar_ae',    'خصم(٪)',   1),
            ('price',   'Price',    'ar_ae',    'السعر *',  1),
            ('quantity',    'Quantity', 'ar_ae',    'الكمية *', 1),
            ('select_module',   'Select Module',    'ar_ae',    'حدد الوحدة',   1),
            ('item_list',   'Item List',    'ar_ae',    'قائمة البند',  1),
            ('quickcreate', 'Quick Create', 'ar_ae',    'إنشاء سريع',   1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'ar_ae',    'الكتابه علي العنوان الحالي بالعنوان المختار',  1),
            ('once_in_every',   'Once in every',    'ar_ae',    'مرة واحدة في كل',  1),
            ('overwrite_msg_part2', 'address details?', 'ar_ae',    'تفاصيل العنوان',   1),
            ('add_item',    'Add Item', 'ar_ae',    'اضافة عنصر',   1),
            ('recordsave',  'Record saved successfully',    'ar_ae',    'حفظ السجل بنجاح',  1),
            ('recordnotsave',   'Could not save record. Try again later',   'ar_ae',    'السجل لا يحفظ',    1),
            ('minutes', 'Minutes',  'ar_ae',    'الدقائق',  1),
            ('hours',   'Hours',    'ar_ae',    'ساعات',    1),
            ('days',    'Days', 'ar_ae',    'أيام', 1),
            ('on',  'On',   'ar_ae',    'على',  1),
            ('day_of_the_month',    'day of the month', 'ar_ae',    'يوم من الشهر', 1),
            ('list_price',  'List Price',   'ar_ae',    'قائمة الأسعار *',  1),
            ('add_record',  'Add Record',   'ar_ae',    'أضف سجل',  1),
            ('add_product', 'Add Product',  'ar_ae',    'أضف منتج', 1),
            ('add_service', 'Add Service',  'ar_ae',    'أضف خدمة', 1),
            ('discountin',  'Discount in %',    'ar_ae',    'الخصم في٪',    1),
            ('unitprice',   'Unit price',   'ar_ae',    'سعر الوحدة',   1),
            ('netprice',    'Net price',    'ar_ae',    'السعر الصافي*',    1),
            ('comments',    'Comments', 'ar_ae',    'تعليقات',  1),
            ('add_close',   'Add & Close',  'ar_ae',    'إضافة وإغلاق', 1),
            ('fetching_rout_message',   'Fetching route, Please wait…', 'ar_ae',    'إحضار الطريق ، يرجى الانتظار …',   1),
            ('setting', 'Settings', 'ar_ae',    'الإعدادات',    1),
            ('utc', 'UTC',  'ar_ae',    'التوقيت العالمي',  1),
            ('in',  'In',   'ar_ae',    'في ',  1),
            ('days_ago',    'days ago', 'ar_ae',    'أيام مضت', 1),
            ('mins_ago',    'Minutes ago',  'ar_ae',    'قبل دقيقة',    1),
            ('justnow', 'Just now', 'ar_ae',    'الآن فقط', 1),
            ('hours_ago',   'hours ago',    'ar_ae',    'منذ ساعات',    1),
            ('in_1_day',    'In 1 day', 'ar_ae',    'في يوم واحد',  1),
            ('scanqrcode',  'Asset / Card scanner', 'ar_ae',    'ماسحة بطاقة',  1),
            ('call_log',    'Call Log', 'ar_ae',    'سجل المكالمات',    1),
            ('voice_message',   'Hi',   'ar_ae',    'اهلا', 1),
            ('voice_message1',  'What can I search for you in', 'ar_ae',    'عن ماذا تريد ان ابحث لك',  1),
            ('live_tracking',   'Live Tracking',    'ar_ae',    'تتبع مباشر (فريق)',    1),
            ('mailmanager', 'Mail Manager', 'ar_ae',    'مدير البريد',  1),
            ('my_location', 'My location',  'ar_ae',    'موقعي',    1),
            ('created_on',  'Created On',   'ar_ae',    'تم إنشاؤها على',   1),
            ('modified_on', 'Modified On',  'ar_ae',    'تعديل على',    1),
            ('enter_comments',  'Enter Comments',   'ar_ae',    'أدخل التعليقات',   1),
            ('viewmore',    'View More',    'ar_ae',    'عرض المزيد',   1),
            ('viewless',    'View Less',    'ar_ae',    'عرض أقل',  1),
            ('gotofullform',    'Go to Full Form',  'ar_ae',    'الذهاب إلى النموذج الكامل',    1),
            ('post',    'Post', 'ar_ae',    'بريد', 1),
            ('url', 'URL',  'ar_ae',    'عنوان URL',    1),
            ('dialog_title_text_back_color',    'Select a Text Background Color',   'ar_ae',    'حدد لون خلفية النص',   1),
            ('event_or_task',   'Add event/task',   'ar_ae',    'اضافه حدث/ مهمه',  1),
            ('shortcut',    'Shortcuts',    'ar_ae',    'اختصارات', 1),
            ('select_field',    'Select Field', 'ar_ae',    'اختر المجال',  1),
            ('share',   'Share',    'ar_ae',    'شارك', 1),
            ('title_insert_link',   'Insert Link',  'ar_ae',    'Insert Link',  1),
            ('addyourcommentshere', 'Add your comments here',   'ar_ae',    'أضف تعليقاتك هنا', 1),
            ('nocomment',   'No Comments',  'ar_ae',    'لا تعليقات',   1),
            ('leads',   'Leads',    'ar_ae',    'يؤدي', 1),
            ('true_val',    'true', 'ar_ae',    'حقيقي',    1),
            ('noresult',    'No Result',    'ar_ae',    'لا نتيجة', 1),
            ('version', 'Version',  'ar_ae',    'الإصدار',  1),
            ('convert_lead',    'Convert Lead', 'ar_ae',    'تحويل العميل المحتمل', 1),
            ('app_name',    'CRMTiger', 'ar_ae',    'SalesHiker',   1),
            ('enter_url',   'Please Enter url', 'ar_ae',    'يرجى إدخال url',   1),
            ('help',    'Help', 'ar_ae',    'مساعدة',   1),
            ('contact_us',  'Contact Us',   'ar_ae',    'اتصل بنا', 1),
            ('updates', 'Updates',  'ar_ae',    'تحديث',    1),
            ('logout',  'LogOut',   'ar_ae',    'الخروج',   1),
            ('busnies_cardscanner', 'Business Card Scanner',    'ar_ae',    'مسح ضوئي للكارت',  1),
            ('sure_want_logout',    'Are you sure want to logout ?',    'ar_ae',    'هل أنت متأكد من تسجيل الخروج؟',    1),
            ('logout_message',  'Logout successfully',  'ar_ae',    'تسجيل الخروج بنجاح',   1),
            ('all', 'All',  'ar_ae',    'الكل', 1),
            ('add_event',   'Add event',    'ar_ae',    'اضافه حدث',    1),
            ('add_task',    'Add Task', 'ar_ae',    'اضافه مهمه',   1),
            ('next',    'Next', 'ar_ae',    'التالي',   1),
            ('terms_conditions',    'Terms and Conditions', 'ar_ae',    'الأحكام والشروط',  1),
            ('login',   'Login',    'ar_ae',    'تسجيل الدخول', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy',    'ar_ae',    'من خلال تسجيل الدخول ، فإنك توافق على الشروط والأحكام  سياسة خاصة',    2),
            ('copyright',   'Copyright © 2019 CRMTiger Version',    'ar_ae',    'حقوق الطبع والنشر © 2019clickhere_subscribe CRMTiger الإصدار', 2),
            ('enter_username',  'Please enter username',    'ar_ae',    'الرجاء إدخال اسم المستخدم',    2),
            ('enter_password',  'Please enter password',    'ar_ae',    'يرجى إدخال كلمة المرور',   2),
            ('remanberme',  'Remember Me',  'ar_ae',    'تذكرنى',   2),
            ('forgot_password', 'Forgot password?', 'ar_ae',    'هل نسيت كلمة المرور؟', 2),
            ('privacy_policay1',    'Privacy Policy',   'ar_ae',    'سياسة خاصة',   2),
            ('contactsupportmsg',   'Something went wrong. \n please Click here to contact support.',   'ar_ae',    'هناك خطا ما يرجي الضغط هنا للتواصل مع الدعم الفني',    2),
            ('enter_username_password', 'Entered Username or Password is wrong',    'ar_ae',    'اسم المستخدم أو كلمة المرور المدخلتين غير صحيحين', 2),
            ('server_issue_occured',    'Server issues occurred',   'ar_ae',    'ظهر تعطل بالخادم ',    2),
            ('password',    'Password', 'ar_ae',    'كلمه السر',    3),
            ('user_name',   'Username', 'ar_ae',    'اسم المستخدم', 3),
            ('reset_pwd',   'Reset Password',   'ar_ae',    'إعادة ضبط كلمة المرور',    3),
            ('forgot_password_title',   'Forgot password',  'ar_ae',    'هل نسيت كلمة المرور',  3),
            ('enter_user_name', 'Enter user name',  'ar_ae',    'ادخل اسم المستخدم',    3),
            ('cc',  'Cc',   'ar_ae',    'سم مكعب',  4),
            ('body',    'Body', 'ar_ae',    'الجسم',    4),
            ('bcc', 'BCC',  'ar_ae',    'مخفية',    4),
            ('dialog_title_text_color', 'Select a Text Color',  'ar_ae',    'حدد لون النص', 4),
            ('date',    'Date', 'ar_ae',    'تاريخ',    4),
            ('subject', 'Subject',  'ar_ae',    'موضوع',    4),
            ('composeMail', 'Compose Mail', 'ar_ae',    'كتابة رسالة',  4),
            ('send',    'Send', 'ar_ae',    'إرسال',    4),
            ('select_message',  'Select message',   'ar_ae',    'اختر الرسالة', 4),
            ('title_insert_table',  'Insert Table', 'ar_ae',    'إدراج جدول',   4),
            ('log_file_sms',    'I agree to Share API Log to Technical team for further troubleshooting',   'ar_ae',    'أوافق على مشاركة سجل API إلى الفريق الفني لمزيد من استكشاف الأخطاء وإصلاحها',  5),
            ('edit_record', 'Edit Records', 'ar_ae',    'تحرير السجل',  5),
            ('select_time', 'Select Time',  'ar_ae',    'اختر الوقت',   5),
            ('edit_item',   'Edit Item',    'ar_ae',    'تعديل عنصر',   5),
            ('items_total', 'Items Total',  'ar_ae',    'إجمالي العناصر',   5),
            ('number_less_then_31', 'Number should be less than 31',    'ar_ae',    'الرقم لابد ان يكون اقل من 31', 5),
            ('users',   'Users',    'ar_ae',    'المستخدمين',   5),
            ('groups',  'Groups',   'ar_ae',    'المجموعات',    5),
            ('txt_note_for_file',   'Note : Existing attachments(images/files) will be replaced',   'ar_ae',    'ملاحظة: سيتم استبدال المرفقات الحالية (الصور / الملفات)',  5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime',   'ar_ae',    'يجب أن يكون تاريخ ووقت الانتهاء أكبر من تاريخ ووقت البدء', 5),
            ('until',   'Until',    'ar_ae',    'حتى',  5),
            ('organizations',   'Organizations',    'ar_ae',    'المنظمات', 6),
            ('contacts',    'Contacts', 'ar_ae',    'جهات الاتصال', 6),
            ('opportunity', 'Opportunity',  'ar_ae',    'فرصة', 6),
            ('lbl_sun', 'SUN',  'ar_ae',    'شمس',  7),
            ('lbl_mon', 'MON',  'ar_ae',    'مون',  7),
            ('lbl_tue', 'TUE',  'ar_ae',    'الثلاثاء', 7),
            ('lbl_wed', 'WED',  'ar_ae',    'تزوج', 7),
            ('lbl_thu', 'THU',  'ar_ae',    'الخميس',   7),
            ('lbl_fri', 'FRI',  'ar_ae',    'جمعة', 7),
            ('lbl_sat', 'SAT',  'ar_ae',    'جلسنا',    7),
            ('lbl_1',   '1',    'ar_ae',    'واحد', 7),
            ('lbl_2',   '2',    'ar_ae',    'إثنان',    7),
            ('lbl_3',   '3',    'ar_ae',    'ثلاثة',    7),
            ('lbl_4',   '4',    'ar_ae',    'أربعة',    7),
            ('lbl_5',   '5',    'ar_ae',    'خمسة', 7),
            ('lbl_6',   '6',    'ar_ae',    'ستة',  7),
            ('lbl_7',   '7',    'ar_ae',    'سبعة', 7),
            ('lbl_8',   '8',    'ar_ae',    'ثمانية',   7),
            ('lbl_9',   '9',    'ar_ae',    'تسعة', 7),
            ('lbl_10',  '10',   'ar_ae',    'عشرة', 7),
            ('lbl_11',  '11',   'ar_ae',    'إحدى عشر', 7),
            ('lbl_12',  '12',   'ar_ae',    'إثنا عشر', 7),
            ('lbl_13',  '13',   'ar_ae',    'ثلاثة عشر',    7),
            ('lbl_14',  '14',   'ar_ae',    'أربعة عشر',    7),
            ('lbl_15',  '15',   'ar_ae',    'خمسة عشر', 7),
            ('lbl_16',  '16',   'ar_ae',    'ستة عشر',  7),
            ('lbl_17',  '17',   'ar_ae',    'سبعة عشر', 7),
            ('lbl_18',  '18',   'ar_ae',    'ثمانية عشر',   7),
            ('lbl_19',  '19',   'ar_ae',    'تسعة عشر', 7),
            ('lbl_20',  '20',   'ar_ae',    'عشرون',    7),
            ('lbl_21',  '21',   'ar_ae',    'واحد وعشرون',  7),
            ('lbl_22',  '22',   'ar_ae',    'إثنان وعشرون', 7),
            ('lbl_23',  '23',   'ar_ae',    'ثلاثة وعشرون', 7),
            ('lbl_24',  '24',   'ar_ae',    'أربعة وعشرون', 7),
            ('lbl_25',  '25',   'ar_ae',    'خمسة وعشرون',  7),
            ('lbl_26',  '26',   'ar_ae',    'ستة وعشرون',   7),
            ('lbl_27',  '27',   'ar_ae',    'سبعة وعشرون',  7),
            ('lbl_28',  '28',   'ar_ae',    'ثمانية وعشرون',    7),
            ('lbl_29',  '29',   'ar_ae',    'تسعة وعشرون',  7),
            ('lbl_30',  '30',   'ar_ae',    'ثلاثون',   7),
            ('lbl_31',  '31',   'ar_ae',    'واحد وثلاثون', 7),
            ('lbl_32',  '32',   'ar_ae',    'إثنان وثلاثون',    7),
            ('lbl_33',  '33',   'ar_ae',    'ثلاثة وثلاثون',    7),
            ('lbl_34',  '34',   'ar_ae',    'أربعة وثلاثون',    7),
            ('lbl_35',  '35',   'ar_ae',    'خمسة وثلاثون', 7),
            ('lbl_36',  '36',   'ar_ae',    'ستة وثلاثون',  7),
            ('lbl_37',  '37',   'ar_ae',    'سبعة وثلاثون', 7),
            ('lbl_38',  '38',   'ar_ae',    'ثمانية وثلاثون',   7),
            ('lbl_39',  '39',   'ar_ae',    'تسعة وثلاثون', 7),
            ('lbl_40',  '40',   'ar_ae',    'أربعون',   7),
            ('lbl_41',  '41',   'ar_ae',    'واحد وأربعون', 7),
            ('lbl_42',  '42',   'ar_ae',    'إثنان وأربعون',    7),
            ('current_date',    'current date', 'ar_ae',    'التاريخ الحالي',   7),
            ('event',   'Events',   'ar_ae',    'أحداث',    7),
            ('calendar',    'Calendar', 'ar_ae',    'التقويم',  7),
            ('latest_version',  'Latest Version :', 'ar_ae',    'احدث اصدار : ',    8),
            ('expire_on',   'Expire On :',  'ar_ae',    'تنتهي في:',    8),
            ('ctmobile_ext_version',    'CTMobile Ext. Version :',  'ar_ae',    'CTMobile تحويلة. الإصدار :',   8),
            ('you_have_latest_version', 'You already have latest version',  'ar_ae',    'لديك بالفعل أحدث نسخة',    8),
            ('latest_version1', 'You Already have latest version',  'ar_ae',    'لديك بالفعل أحدث نسخة',    8),
            ('upgreaded',   'Upgrade',  'ar_ae',    'تطوير',    8),
            ('downgrade',   'Downgrade',    'ar_ae',    'تخفيض',    8),
            ('dialog_recent_event_info',    'You can set from here how many number of records you want to show on Home screen for Recent Event.',   'ar_ae',    'يمكنك تعيين عدد السجلات التي تريد إظهارها على الشاشة الرئيسية للحدث الأخير من هنا.',   8),
            ('dialog_feedback_info',    'You can submit your feedback with description , our team will check your feedback and get back to you.',   'ar_ae',    'يمكنك تعيين عدد السجلات التي تريد إظهارها على الشاشة الرئيسية للحدث الأخير من هنا.',   8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.',    'ar_ae',    'يتم استخدام وظيفة سجل لدعم / مساعدة العملاء ، إذا كنت تواجه أي مشاكل في التطبيق أو أي وحدة نمطية أو وظيفة لا يعمل بشكل صحيح ، يمكنك تمكين سجل المشاركة مع فريق التطوير لدينا.',    8),
            ('info',    'Info', 'ar_ae',    'معلومات',  8),
            ('recent_history',  'Recent History',   'ar_ae',    'التاريخ الحديث',   8),
            ('recent_feedback', 'Feedback', 'ar_ae',    'ردود الفعل',   8),
            ('recent_log',  'Log',  'ar_ae',    'سجل',  8),
            ('crmtiger_app_version',    'CRMTiger App Version :',   'ar_ae',    'إصدار تطبيق CRMTiger:',    8),
            ('historylimit',    'Recent History Limit', 'ar_ae',    'حد التاريخ الحديث',    8),
            ('radious_in_miles',    'Radius in miles',  'ar_ae',    'نصف القطر بالأميال',   8),
            ('recentlimit', 'Recent Event Limit',   'ar_ae',    'حدود الأحداث الأخيرة', 8),
            ('upcoming_events', 'Upcoming Events',  'ar_ae',    'الأحداث القادمة',  8),
            ('rate_our_app',    'Rate Our App!',    'ar_ae',    'قيم التطبيق',  8),
            ('feedback',    'Submit Feedback',  'ar_ae',    'إرسال ملاحظات',    8),
            ('sendfeedback',    'Feedback Send',    'ar_ae',    'إرسال ردود الفعل', 8),
            ('emaillimit',  'Email limit',  'ar_ae',    'حد البريد الإلكتروني', 8),
            ('log', 'Log',  'ar_ae',    'سجل',  8),
            ('logclear',    'Log cleared successfully.',    'ar_ae',    'تم محو السجل بنجاح',   8),
            ('dialog_recent_history_info',  'You can set from here how many number of records you want to show on Home screen for Recent History.', 'ar_ae',    'يمكنك تعيين عدد السجلات التي تريد إظهارها على الشاشة الرئيسية للسجل الحديث من هنا.',   8),
            ('proceed_to_upgrade1', 'Proceed to',   'ar_ae',    'الشروع في',    8),
            ('upgradation_message', 'will required logout and login again later.',  'ar_ae',    'يتطلب الخروج من البرنامج و الخول مره اخري',    8),
            ('proceed_to_upgrade',  'Proceed to Upgrade',   'ar_ae',    'يجري التحديث الان',    8),
            ('module_setting',  'Module Setting',   'ar_ae',    'إعدادات الوحدة',   9),
            ('sortbyfield', 'Sort by field',    'ar_ae',    'الترتيب حسب المجال',   9),
            ('ascending',   'Ascending  A to Z',    'ar_ae',    'تصاعدي A إلى Z',   9),
            ('descending',  'Descending  Z to A',   'ar_ae',    'تنازلي Z إلى A',   9),
            ('first_field', 'First Field',  'ar_ae',    'الحقل الأول',  9),
            ('second_field',    'Second Field', 'ar_ae',    'الحقل الثاني', 9),
            ('third_field', 'Third Field',  'ar_ae',    'المجال الثالث',    9),
            ('sure_want_restore',   'Are you sure you want to reset to default settings?',  'ar_ae',    'هل تريد بالتأكيد إعادة تعيين الإعدادات الافتراضية؟',   9),
            ('orderlist',   'List Order',   'ar_ae',    'ترتيب القائمة',    9),
            ('module_reset',    'Restore to Default',   'ar_ae',    'إعادة تعيين إلى الافتراضي',    9),
            ('display_fields',  'Display Fields',   'ar_ae',    'حقول العرض',   9),
            ('discount_lessthen_100',   'Discount % should be less than 100',   'ar_ae',    'يجب أن يكون الخصم٪ أقل من 100',    10),
            ('select_item', 'Select Item',  'ar_ae',    'اختر البند',   10),
            ('item_comment',    'Item Comment', 'ar_ae',    'تعليق البند',  10),
            ('record_name', 'Record Name is :', 'ar_ae',    'مسجل باسم',    11),
            ('go_back', 'Go Back',  'ar_ae',    'عُد',  11),
            ('please_enter_shortcut_name',  'Please Enter Shortcut Name',   'ar_ae',    'الرجاء إدخال اسم الاختصار',    11),
            ('number_not_found',    'Contact Number not found', 'ar_ae',    'رقم الاتصال غير موجود',    11),
            ('mail_not_found',  'Mail Address not found',   'ar_ae',    'عنوان البريد غير موجود ',  11),
            ('create_shortcut', 'Create Shortcut',  'ar_ae',    'انشاء اختصار', 11),
            ('contact_summary', 'Summary',  'ar_ae',    'ملخص', 11),
            ('activites',   'Activities',   'ar_ae',    'أنشطة',    11),
            ('details', 'Details',  'ar_ae',    'تفاصيل',   11),
            ('related', 'Related',  'ar_ae',    'متعلق ب',  11),
            ('share_link',  'Share record with',    'ar_ae',    'مشاركه المجل مع',  11),
            ('edit',    'Edit', 'ar_ae',    'اضافه',    11),
            ('duplicate',   'Duplicate',    'ar_ae',    'مكرر', 11),
            ('whatsapp',    'Whatsapp', 'ar_ae',    'واتس اب',  11),
            ('call',    'Call', 'ar_ae',    'مكالمه',   11),
            ('choose_contact_for_call', 'Choose Contact for Call',  'ar_ae',    'اختار اسم للاتصال',    11),
            ('choose_contact_for_sms',  'Choose Contact for SMS',   'ar_ae',    'اختار اسم لارسال رساله قصيره', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp',  'ar_ae',    'اختار اسم لارسال واتس اب', 11),
            ('chosse_contact_for_email',    'Choose Email', 'ar_ae',    'اختار بريد الكتروني',  11),
            ('attach_file', 'Attach Files', 'ar_ae',    'اضافه ملحقات', 11),
            ('close',   'Close',    'ar_ae',    'اغلق', 11),
            ('status',  'Status',   'ar_ae',    'الحالة',   11),
            ('stop',    'Stop', 'ar_ae',    'توقف', 11),
            ('zero',    '0',    'ar_ae',    'صفر',  11),
            ('record',  'Record',   'ar_ae',    'تسجيل',    11),
            ('voice_note',  'Voice Note',   'ar_ae',    'مفكره صوتيه',  11),
            ('tickets', 'Tickets',  'ar_ae',    'تذاكر',    12),
            ('check_out',   'Check Out',    'ar_ae',    'الدفع',    12),
            ('check_in',    'Check In', 'ar_ae',    'تحقق في',  12),
            ('select_any',  'Select any',   'ar_ae',    'حدد أي',   12),
            ('fulldetails', 'Show Full Details',    'ar_ae',    'إظهار التفاصيل الكاملة',   12),
            ('checkin', 'Check-in', 'ar_ae',    'تحقق في',  12),
            ('navigate',    'Navigate', 'ar_ae',    'التنقل',   12),
            ('product', 'Products', 'ar_ae',    'منتجات',   12),
            ('projectMilestone',    'Project Milestone',    'ar_ae',    'معلما المشروع',    12),
            ('projecttask', 'Project Tasks',    'ar_ae',    'المشاريع المهمة',  12),
            ('nearby',  'NearBy',   'ar_ae',    'مجاوز',    13),
            ('document',    'Document', 'ar_ae',    'وثيقة',    14),
            ('reply',   'Reply',    'ar_ae',    'الرد', 14),
            ('reply_all',   'Reply All',    'ar_ae',    'الرد على الجميع',  14),
            ('forward', 'Forward',  'ar_ae',    'إلى الأمام',   14),
            ('action',  'Action',   'ar_ae',    'عمل',  14),
            ('select_first',    'Select First', 'ar_ae',    'اختار اولا',   14),
            ('commentaddsuccessful',    'Comment added successfull',    'ar_ae',    'تم إضافة التعليق بنجاح',   14),
            ('move_to', 'Move to',  'ar_ae',    'الانتقال إلى', 14),
            ('attach',  'Attach',   'ar_ae',    'يربط', 14),
            ('addcoment',   'Add Comment',  'ar_ae',    'أضف تعليق',    14),
            ('adddocument', 'Add Document', 'ar_ae',    'إضافة وثيقة',  14),
            ('home',    'Home', 'ar_ae',    'الصفحة الرئيسية',  15),
            ('checkout',    'Check-out',    'ar_ae',    'الدفع',    15),
            ('message_search',  'Search by name',   'ar_ae',    'البحث عن طريق الإسم',  15),
            ('start_shift', 'Start shift',  'ar_ae',    'بدء التحول',   15),
            ('end_shift',   'End shift',    'ar_ae',    'نهاية التحول', 15),
            ('today_meeting',   'Meetings', 'ar_ae',    'اجتماعات', 15),
            ('shift_time_track',    'Shift Time Track', 'ar_ae',    'التحول الزمني المسار', 15),
            ('logout_msg',  'You have to login again , click',  'ar_ae',    'لابد من الدخول مره اخري    اضغط',  15),
            ('logout_msg1', 'to continue.', 'ar_ae',    'يستمر',    15),
            ('permission_denied',   'You don\'t have permission to create', 'ar_ae',    'ليس لديك إذن لإنشاء',  15),
            ('history', 'Activity stream',  'ar_ae',    'تيار النشاط',  15),
            ('search_value',    'Search value :',   'ar_ae',    'قيمه البحث',   15),
            ('feed_back_msg',   'Please enter feedback message',    'ar_ae',    'يرجى إدخال رسالة ملاحظات', 16),
            ('feed_back_hint_msg',  'Enter feedback message',   'ar_ae',    'أدخل رسالة التعليقات', 16),
            ('submit',  'Submit',   'ar_ae',    'خضع',  16),
            ('check_app_not_installed', 'Application is not currently installed.',  'ar_ae',    'التطبيق غير مثبت حاليا.',  17),
            ('send_sms_fail_message',   'SMS failed, please try again later!',  'ar_ae',    'فشلت رسالة SMS ، يرجى المحاولة مرة أخرى في وقت لاحق!', 17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'ar_ae',    'إرفاق المستند بنجاح',  17),
            ('send_message',    'Send message', 'ar_ae',    'ارسل رساله',   17),
            ('sms_to',  'smsto:',   'ar_ae',    'رساله الي ',   17),
            ('add_list_message',    'Add List', 'ar_ae',    'اضف قائمة',    18),
            ('mylist',  'My List',  'ar_ae',    'قوائمي',   18),
            ('filtername',  'Filter Name',  'ar_ae',    'اسم الفلتر',   18),
            ('selectlist',  'Select a List',    'ar_ae',    'حدد وحدة نمطية *', 18),
            ('assingedto',  'Assigned To',  'ar_ae',    'مخصص ل*',  18),
            ('selectmodule',    'Select a module',  'ar_ae',    'حدد وحدة نمطية',   18),
            ('add_list',    'Add Filter',   'ar_ae',    'إضافة مرشح',   18),
            ('recent_event',    'Recent Event', 'ar_ae',    'حدث حديث', 19),
            ('recent_hostory',  'Recent History',   'ar_ae',    'التاريخ الحديث',   19),
            ('module_specific_settings',    'Module-Specific Settings', 'ar_ae',    'إعدادات الوحدة النمطية',   19),
            ('talk_to_us',  'Talk to us',   'ar_ae',    'تكلم معنا',    19),
            ('report_a_bug',    'Report A Bug', 'ar_ae',    'الإبلاغ عن خطأ',   19),
            ('faq', 'FAQ',  'ar_ae',    'التعليمات',    19),
            ('selectmodules',   'Select Module',    'ar_ae',    'اختر الوحدة',  19),
            ('myplan',  'My Plan',  'ar_ae',    'خطتي', 19),
            ('message', 'Message',  'ar_ae',    'رسالة',    20),
            ('message_validation',  'Please enter Message', 'ar_ae',    'يرجى إدخال الرسالة',   20),
            ('contact_select',  'Please Select contact',    'ar_ae',    'يرجى تحديد الاتصال',   20),
            ('global_search',   'Global Search',    'ar_ae',    'بحث عام',  21),
            ('records', 'Records',  'ar_ae',    'تسجيل',    21),
            ('dont_show_again', 'Don\'t Show Again',    'ar_ae',    'لا تراه مره اخري', 22),
            ('skip',    'Skip', 'ar_ae',    'تخطي', 22),
            ('file_downloading',    'File Downloading', 'ar_ae',    'تحميل الملف',  23),
            ('add_screenshots_optional',    'Add screenshots (optional)',   'ar_ae',    'إضافة لقطات شاشة (اختياري)',   24),
            ('describe_your_problem',   'Describe your problem',    'ar_ae',    'صف مشكلتك',    24),
            ('default_filter_shortcut', 'Default Filter Shortcut',  'ar_ae',    'اختصار افتراضي عام ',  25),
            ('record_shortcut', 'Record Shortcut',  'ar_ae',    'تسجيل الاختصار',   25),
            ('enter_url',   'Please Enter url', 'ar_ae',    'يرجي ادخال الموقع الالكتروني ',    26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'ar_ae',    'لابد من تحديث التطبيق للاستمرا يرجي تحديث التطبيق و معاوده المحاوله',  26),
            ('search_by',   'Search by',    'ar_ae',    'البحث ب',  27),
            ('selected_filter', 'Selected filter :',    'ar_ae',    'مرشح محدد: -', 27),
            ('selected_field',  'Selected field :', 'ar_ae',    'الحقل المحدد: -',  27),
            ('choose',  'Choose',   'ar_ae',    'اختار',    28),
            ('qr_cardscanner',  'QR Code Scanner',  'ar_ae',    'اجراء مسح QR', 28),
            ('error_message_for_scan',  'Could not read the card Try again later.', 'ar_ae',    'لا يمكن قراءة البطاقة حاول مرة أخرى لاحقًا.',  28),
            ('press_start_scan',    'Press to Start Scan',  'ar_ae',    'اضغط بدء المسح',   28),
            ('line_item_quntity_validation_msg',    'Value should be greater than zero',    'ar_ae',    'القيمه لابد انت تكون اكبر من صفر', 29),
            ('percentage_msg',  'Percentage should be less than 100',   'ar_ae',    'النسبه المئويه لابد ان تكون اقل من 100',   29),
            ('MSG_NO_DATA', 'No data found!',   'ar_ae',    'لا توجد بيانات',   29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!',    'ar_ae',    'هناك خطا ما',  29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'ar_ae',    'قريبا',    29),
            ('MSG_UPLOAD_PROFILE_IMAGE',    'Please upload profile image.', 'ar_ae',    'يرجي رفع صوره البروفايل',  29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access',  'ar_ae',    'الوصول الي الموقع',    29),
            ('ALERT_MSG_LOCATION_ACCESS',   'Requires your location to show nearby events.',    'ar_ae',    'لابد من الحصول علي موقعك لامكانيه ايضاح المواقع القريبه',  29),
            ('ALERT_BTN_ALLOW', 'ALLOW',    'ar_ae',    'سماح', 29),
            ('ALERT_BTN_DENY',  'DENY', 'ar_ae',    'رفض',  29),
            ('ALERT_MSG_LOCATION_SETTING',  'Not able to fetch your current location. Please allow us to use your location to provide you certain features like, live tracking, route planning and display near by leads, contact, organization, etc. This will help you to plan your on field task as well',   'ar_ae',    'غير قادر على جلب موقعك الحالي. يرجى السماح لنا باستخدام موقعك لتزويدك بميزات معينة مثل التتبع المباشر وتخطيط المسار والعرض بالقرب من العملاء المحتملين وجهات الاتصال والمؤسسة وما إلى ذلك. سيساعدك هذا على التخطيط لمهمتك الميدانية أيضًا',    29),
            ('DELETE_RECORD',   'Delete Record',    'ar_ae',    'الغاء ',   29),
            ('ALERT_MSG_DELETE_SHORTCUT',   'Are you sure want to delete this shortcut?',   'ar_ae',    'هل انت متاكد من الالغاء؟', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut',  'ar_ae',    'اختصار الالغاء',   29),
            ('LBL_TERMS',   'By logging in, you agree to our Terms and',    'ar_ae',    'بدخولك علي الموقع فقد وافقت علي الشروط و الاحكام', 29),
            ('LBL_CONDITIONS',  'Conditions &', 'ar_ae',    'شرط',  29),
            ('ALERT_TITLE', 'Alert',    'ar_ae',    'تنبيه',    29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe',    'ar_ae',    'اشترك',    29),
            ('MSG_SELECT_MODULE',   'Please select any Module', 'ar_ae',    'برجاء اختار الموديول', 29),
            ('MSG_SELECT_LIST', 'Please select any List',   'ar_ae',    'برجاء اختيار القائمه', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA',  'You don\'t have camera',   'ar_ae',    'لا توجد كاميرا',   29),
            ('ALERT_MSG_GALLARY_PERMISSION',    'You don\'t have permission to access gallery.',    'ar_ae',    'انت لا تملك الصلاحيه للدخول الي معرض الصور',   29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'ar_ae',    'انت لا تملك الصلاحيه للدخول الي معرض الصور برجاء الدخول الي اعدادات و انزل الي نهايه الصفحه و اختار تطبيق ',   29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'ar_ae',    'ليس لديك إذن للوصول إلى ميزة \"التعرف على الكلام\". انتقل إلى الإعداد -&gt; قم بالتمرير إلى الأسفل وحدد تطبيق CRMTiger -&gt; قم بتشغيل التعرف على الكلام', 29),
            ('BTN_DONE',    'Done', 'ar_ae',    'انتهي',    29),
            ('COMMENT', 'Comment',  'ar_ae',    'تعليق',    29),
            ('FULL_FORM',   'Full Form',    'ar_ae',    'الاستماره الكامله',    29),
            ('QUICK_CREATE',    'Create',   'ar_ae',    'انشاء',    29),
            ('LBL_SELECT_FIELDS',   'Select Fields',    'ar_ae',    'اختار حقل',    29),
            ('LBL_SELECT_FIELDS',   'Select Fields',    'ar_ae',    'اختار حقل',    29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field',   'ar_ae',    'اختار اول حقل',    29),
            ('LBL_SELECT_SECOND_FIELDS',    'Select Second Field',  'ar_ae',    'اختار ثاني حقل',   29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field',   'ar_ae',    'اختار ثالث حقل',   29),
            ('LBL_SORT_BY_FIELD',   'Select Sort By Field', 'ar_ae',    'اختيار ب', 29),
            ('BTN_RESET_TO_DEFAULT',    'Reset to Default', 'ar_ae',    'الرجوع الي الافتراضي', 29),
            ('MSG_SELECT_SORT_BY_FIELD',    'Select Sort by field', 'ar_ae',    'اختيار ب', 29),
            ('kStrClearBtnTitle',   'Clear',    'ar_ae',    'امسح', 29),
            ('kStrShowMoreBtnTitle',    'Show More',    'ar_ae',    'ارني اكثر',    29),
            ('kStrAddActivitiesBtnTitle',   'Add Activities',   'ar_ae',    'اضافه نشاطات', 29),
            ('kStrAddCommentPlaceHolder',   'Add your comments here',   'ar_ae',    'ضع تعليقك هنا',    29),
            ('MSG_ENTER_TO_EMAIL',  'Please enter to field.',   'ar_ae',    'يرجي ادخال الحقل', 29),
            ('WARNING_FILE',    'File can\'t open.',    'ar_ae',    'الملف لا يفتح',    29),
            ('MSG_FILE_SAVED',  'File saved.',  'ar_ae',    'تم حفظ الملف', 29),
            ('WARNING_DOWNLOAD_FAIL',   'Download fail!, please try after sometime.',   'ar_ae',    'فشل في التنزيل برجاء المحاوله بعد فتره',   29),
            ('LBL_SHORTCUT',    'Shortcut', 'ar_ae',    'اختصار',   29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'ar_ae',    'اكتب الرساله', 29),
            ('ALERT_INSTALL_WHATSAPP',  'Install Whatsapp', 'ar_ae',    'تنزيل واتس اب',    29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox',  'ar_ae',    'لا يوجد صندوق بريد برجاء انشاء صندوق بريد',    29),
            ('LBL_WROTE',   'Wrote',    'ar_ae',    'كتب',  29),
            ('MSG_MAIL_SEND',   'Mail sent',    'ar_ae',    'تم ارسال الرساله', 29),
            ('log_file_not_found',  'API Log file not found.',  'ar_ae',    'لم يتم العثور علي API',    29),
            ('unknown_error',   'An unknown error occurred, try again', 'ar_ae',    'خطا غير معروف برجاء المحاوله مره اخري',    29),
            ('CTMTigerAppVersion',  'CRMTiger App Version', 'ar_ae',    'نسخه تطبيق CRM Tiger', 29),
            ('CTMMobileUpdateMsg',  'CTMobile Ext. Version Update Successfully',    'ar_ae',    'امتداد CT Mobile  تم تحديثه',  29),
            ('dialog_Premium_downgrade',    'Downgrade will required logout and login again later', 'ar_ae',    'النزول الي الفئه الادني يتطلب الخروج و الدخول مره اخري',   29),
            ('dialog_Premium',  'Upgrade will required logout and login again later',   'ar_ae',    'التحديث الي الفئه الاعلي يتطلب الخروج و الدخول مره اخري',  29),
            ('Overwrite',   'Overwrite',    'ar_ae',    'الكتابه فوق',  29),
            ('MSGAddressOverwrite1',    'Overwrite the existing address with the selected', 'ar_ae',    'الكتابه فوق العنوان المكتوب سيتم اختياره', 29),
            ('MSGAddressOverwrite2',    'address details?', 'ar_ae',    'تفاصيل العنوان',   29),
            ('UPGRADE_PLAN',    'Upgrade Plan', 'ar_ae',    'خطه التحديث',  29),
            ('DOWNGRADE_PLAN',  'Downgrade Plan',   'ar_ae',    'خطه النزول الي افئه الادني',   29),
            ('UPGRADE_EXTENSION',   'Upgrade Extension',    'ar_ae',    'امتدادات التحديث', 29),
            ('UPGRADE_APP', 'Upgrade App',  'ar_ae',    'تحديث التطبيق',    29),
            ('SELECT_OPTION',   'Select Option',    'ar_ae',    'اختار ',   29),
            ('PLEASE_SELECT',   'Please select',    'ar_ae',    'برجاء الاختيار',   29),
            ('MSG_ACCESS_DENIED',   'You don\'t have permission for this module.',  'ar_ae',    'انت لا تملك الصلاحيه للدخول لهذا القسم',   29),
            ('MSG_SELECT_RECCURING_MONTH_DAY',  'Please select reccuring day of month.',    'ar_ae',    'برجاء اختيار اليوم المكرر في الشهر',   29),
            ('MSG_SELECT_RECCURING_WEEK_DAY',   'Please select reccuring day of week.', 'ar_ae',    'برجاء اختيار اليوم المكرر في الاسبوع', 29),
            ('MSG_SELECT_RECCURING_DAYS',   'Please select reccuring days.',    'ar_ae',    'برجاء اختيار اليوم المكرر',    29),
            ('Please select reccuring days.',   'Please select reccuring days.',    'ar_ae',    'برجاء اختيار اليوم المكرر',    29),
            ('MSG_SELECT_RECCURING_END_DATE',   'Please select reccuring end date.',    'ar_ae',    'برجاء اختيار اليوم النهائي',   29),
            ('MSG_SELECT_RECCURING_TYPE',   'Please select reccuring type.',    'ar_ae',    'برجاء اختيار النوع',   29),
            ('FREQ_TIME',   'Times',    'ar_ae',    'عدد المرات',   29),
            ('REPEAT_YEARLY',   'Repeat Yearly',    'ar_ae',    'الاعاده سنويا',    29),
            ('REPEAT_MONTHLY',  'Repeat Monthly',   'ar_ae',    'الاعاده شهريا',    29),
            ('REPEAT_WEEKLY',   'Repeat Weekly',    'ar_ae',    'الاعاده اسبوعيا',  29),
            ('REPEAT_DAILY',    'Repeat Daily', 'ar_ae',    'الاعاده يوميا',    29),
            ('ACTION_TITLE',    'Action Title', 'ar_ae',    'عنوان الحدث',  29),
            ('MSG_SELECT_VALID_DATE',   'Please select valid day of month.',    'ar_ae',    'برجاء اختيار يوم مناسب في الشهر',  29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'ar_ae',    'تاريخ البدايه لابد ان يكون اقل من تاريخ الانتهاء', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'ar_ae',    'اختيار بدء الوقت لابد ان يكون قبل وقت الانتهاء',   29),
            ('LBL_LINEITEM_DETAILS',    'Lineitem Details', 'ar_ae',    'تفاصيل الخط',  29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT',    'Discount amount should be less than the total.',   'ar_ae',    'الخصم لابد ان يكون اقل من الاجمالي',   29),
            ('VIEW',    'View', 'ar_ae',    'منظر', 29),
            ('MSG_ENTER_VALID', 'Please enter valid',   'ar_ae',    'برجاء ادخال صحيح', 29),
            ('MSG_ENTER_PERCENTAGE',    'Percentage should be less than 100.',  'ar_ae',    'النسبه المئويه لابد ان تكون اقل من 100',   29),
            ('ITEM_TOTAL',  'Item Total',   'ar_ae',    'الاجمالي', 29),
            ('ADJUSTMENT',  'Adjustment',   'ar_ae',    'تعديل',    29),
            ('TITLE_CHOOSE_IMAGE',  'Choose Image', 'ar_ae',    'اختار صوره',   29),
            ('COMPRESS',    'Compress', 'ar_ae',    'ضغط',  29),
            ('CHOOSE_ANOTHER_IMAGE',    'Your image size is too large, please select another image',    'ar_ae',    'الصوره كبيره جدا برجاء اختيار صوره اخري',  29),
            ('OnDayOfMonth',    'On day of month',  'ar_ae',    'يوم في الشهر', 29),
            ('OnDayOfWeek', 'On day of week',   'ar_ae',    'يوم في الاسبوع',   29),
            ('AddAndClose', 'Add & Close',  'ar_ae',    'اضافه&اغلاق',  29),
            ('Repeat',  'Repeat',   'ar_ae',    'اعاده',    29),
            ('OnDay',   'On day',   'ar_ae',    'في يوم',   29),
            ('View_Line_Item',  'View Line Item',   'ar_ae',    'عرض البند',    29),
            ('TITLE_IMAGE', 'Image',    'ar_ae',    'صوره', 29),
            ('TITLE_ICLOUD',    'iCloud',   'ar_ae',    'اي كلود',  29),
            ('GOOGLE',  'Google',   'ar_ae',    'جوجل', 29),
            ('ALERT_BTN_OKAY',  'Okay', 'ar_ae',    'حسنا', 29),
            ('ALERT_TITLE_ACCESS_DENIED',   'Access Denied',    'ar_ae',    'الدخول مرفوض', 29),
            ('Dont_Show_Again', 'Don\'t show again',    'ar_ae',    'لا تظهرها مره اخري',   29),
            ('Skip',    'Skip', 'ar_ae',    'تخطي', 29),
            ('Fillter_Name',    'Fillter Name', 'ar_ae',    'اسم الفلتر',   29),
            ('Fillter_Record_Count',    'Fillter Record Count', 'ar_ae',    'عدد سجلات التصفية',    29),
            ('url_note',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'ar_ae',    'ملاحظة: إذا كان عنوان URL الخاص بـ CRM هو https://example.com/crm، فأدخله في المربع أعلاه',    26),
            ('vtiger_url',  'Your vTiger CRM URL',  'ar_ae',    'عنوان URL الخاص بـ vTiger CRM',    26),
            ('msg_doc_read_permission', 'You don\'t have permission to Add either This is read-only or Private Field.', 'ar_ae',    'ليس لديك إذن لإضافة هذا الحقل للقراءة فقط أو حقل خاص.',    31),
            ('CLEAR',   'Clear',    'ar_ae',    'واضح', 31),
            ('Files/photos uploaded successfully',  'Files/photos uploaded successfully',   'ar_ae',    'تم تحميل الملفات/الصور بنجاح', 32),
            ('Digital signature saved', 'Digital signature saved',  'ar_ae',    'تم حفظ التوقيع الرقمي',    32),
            ('Please upload Signature or Files/photos', 'Please upload Signature or Files/photos',  'ar_ae',    'يرجى تحميل التوقيع أو الملفات/الصور',  32),
            ('Files / Photos',  'Files / Photos',   'ar_ae',    'ملفات / صور',  32),
            ('Signature',   'Signature',    'ar_ae',    'إمضاء',    32),
            ('add_photo_using', 'Add Photo Using',  'ar_ae',    'إضافة صورة باستخدام',  31),
            ('btn_upload_sign', '(+) Add Signature',    'ar_ae',    '(+) إضافة التوقيع',    31),
            ('btn_upload_photo_doc',    '(+) Upload Files/Photos',  'ar_ae',    '(+) تحميل الملفات/الصور',  31),
            ('select_photo_doc_to_upload',  'Please select files/photos to upload', 'ar_ae',    'الرجاء تحديد الملفات/الصور للتحميل',   31),
            ('related_module_title',    'Search from related module and Add to \"Route\"',  'ar_ae',    'ابحث من الوحدة ذات الصلة وأضف إلى \"الطريق\"', 30),
            ('Route status updated successfully',   'Route status updated successfully',    'ar_ae',    'تم تحديث حالة المسار بنجاح',   32),
            ('Session init failed', 'Session init failed',  'ar_ae',    'فشل بدء الجلسة',   32),
            ('You don\'t have permission to access this resource',  'You don\'t have permission to access this resource',   'ar_ae',    'ليس لديك إذن للوصول إلى هذا المورد',   32),
            ('ctroute_realtedto cannot be empty',   'Could not get the Related To - Try again later',   'ar_ae',    'تعذر الحصول على الارتباط بـ - حاول مرة أخرى لاحقًا',   32),
            ('ctroute_planning cannot be empty',    'Could not get the Route Planning Record - Try again later',    'ar_ae',    'تعذر الحصول على سجل تخطيط المسار - حاول مرة أخرى لاحقًا',  32),
            ('Something went wrong - Try again later',  'Something went wrong - Try again later',   'ar_ae',    'حدث خطأ ما - حاول مرة أخرى لاحقًا',    32),
            ('sequence updated successfully',   'sequence updated successfully',    'ar_ae',    'تم تحديث التسلسل بنجاح',   32),
            ('sequence cannot be empty',    'sequence cannot be empty', 'ar_ae',    'لا يمكن أن يكون التسلسل فارغًا',   32),
            ('Shortcut details not saved',  'Shortcut details not saved',   'ar_ae',    'لم يتم حفظ تفاصيل الاختصار',   32),
            ('Shortcut details saved successfully', 'Shortcut details saved successfully',  'ar_ae',    'تم حفظ تفاصيل الاختصار بنجاح', 32),
            ('Route save successfully', 'Route save successfully',  'ar_ae',    'تم حفظ المسار بنجاح',  32),
            ('Record save successfully',    'Record save successfully', 'ar_ae',    'سجل الحفظ بنجاح',  32),
            ('No dependency found for picklist',    'No dependency found for picklist', 'ar_ae',    'لم يتم العثور على تبعية لقائمة الاختيار',  32),
            ('No records found',    'No records found', 'ar_ae',    'عربي\nلم يتم العثور على تبعية لقائمة الاختيار',    32),
            ('Outgoing server is not enabled, please configure from CRM',   'Outgoing server is not enabled, please configure from CRM',    'ar_ae',    'لم يتم تمكين الخادم الصادر، يرجى تكوينه من CRM',   32),
            ('Removed Successfully',    'Removed Successfully', 'ar_ae',    'تمت الإزالة بنجاح',    32),
            ('Shortcut has been deleted',   'Shortcut has been deleted',    'ar_ae',    'تم حذف الاختصار',  32),
            ('relation of records removed successfully',    'relation of records removed successfully', 'ar_ae',    'تمت إزالة العلاقة بين السجلات بنجاح',  32),
            ('relation of records not removed', 'relation of records not removed',  'ar_ae',    'علاقة السجلات لم تتم إزالتها', 32),
            ('Record has been deleted successfully',    'Record has been deleted successfully', 'ar_ae',    'تم حذف السجل بنجاح',   32),
            ('Time Tracking saved successfully',    'Time Tracking saved successfully', 'ar_ae',    'تم حفظ تتبع الوقت بنجاح',  32),
            ('Time Tracking updated successfully',  'Time Tracking updated successfully',   'ar_ae',    'تم تحديث تتبع الوقت بنجاح',    32),
            ('Time Tracking ended successfully',    'Time Tracking ended successfully', 'ar_ae',    'انتهى تتبع الوقت بنجاح',   32),
            ('Time Tracking started successfully',  'Time Tracking started successfully',   'ar_ae',    'بدأ تتبع الوقت بنجاح', 32),
            ('record cannot be empty',  'record cannot be empty',   'ar_ae',    'لا يمكن أن يكون السجل فارغًا', 32),
            ('Module is disabled',  'Module is disabled',   'ar_ae',    'تم تعطيل الوحدة النمطية',  32),
            ('Shift ended successfully',    'Shift ended successfully', 'ar_ae',    'انتهى التحول بنجاح',   32),
            ('Shift started successfully',  'Shift started successfully',   'ar_ae',    'بدأ التحول بنجاح', 32),
            ('relation of records added successfully',  'relation of records added successfully',   'ar_ae',    'تمت إضافة علاقة السجلات بنجاح',    32),
            ('Comment saved successfully',  'Comment saved successfully',   'ar_ae',    'تم حفظ التعليق بنجاح', 32),
            ('Comment not saved',   'Comment not saved',    'ar_ae',    'لم يتم حفظ التعليق',   32),
            ('Comment module is not active',    'Comment module is not active', 'ar_ae',    'وحدة التعليق غير نشطة',    32),
            ('No Upcoming Event',   'No Upcoming Event',    'ar_ae',    'لا يوجد حدث قادم', 32),
            ('No Templates found - create it from Message Templates module',    'No Templates found - create it from Message Templates module', 'ar_ae',    'لم يتم العثور على قوالب - قم بإنشائها من وحدة قوالب الرسائل',  32),
            ('No event or task for this date',  'No event or task for this date',   'ar_ae',    'لا يوجد حدث أو مهمة لهذا التاريخ', 32),
            ('No filters created',  'No filters created',   'ar_ae',    'لم يتم إنشاء أي مرشحات',   32),
            ('Select at least one record to attach',    'Select at least one record to attach', 'ar_ae',    'حدد سجلاً واحدًا على الأقل لإرفاقه',   32),
            ('Please select one or more attachments',   'Please select one or more attachments',    'ar_ae',    'الرجاء تحديد مرفق واحد أو أكثر',   32),
            ('No event for this month', 'No event for this month',  'ar_ae',    'لا يوجد حدث لهذا الشهر',   32),
            ('No Activity found',   'No Activity found',    'ar_ae',    'لم يتم العثور على أي نشاط',    32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'ar_ae',    'تعليقاتك ذات قيمة بالنسبة لنا - لا يمكن أن تكون فارغة',    32),
            ('Could not send mail, Please try later',   'Could not send mail, Please try later',    'ar_ae',    'لا يمكن إرسال البريد، يرجى المحاولة لاحقا',    32),
            ('Latest Version updated successfully', 'Latest Version updated successfully',  'ar_ae',    'تم تحديث أحدث إصدار بنجاح',    32),
            ('User Location Updated Successfully',  'User Location Updated Successfully',   'ar_ae',    'تم تحديث موقع المستخدم بنجاح', 32),
            ('User Location not Updated Successfully',  'User Location not Updated Successfully',   'ar_ae',    'لم يتم تحديث موقع المستخدم بنجاح', 32),
            ('SMSNotifier is not enable in CRM. Please enable it first',    'SMSNotifier is not enable in CRM. Please enable it first', 'ar_ae',    'لم يتم تمكين SMSNotifier في CRM. يرجى تمكينه أولا',    32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'ar_ae',    'تعذر إرسال تعليقاتك - يرجى المحاولة مرة أخرى لاحقًا',  32),
            ('Thank you for submitting your feedback',  'Thank you for submitting your feedback',   'ar_ae',    'شكرا لك على تقديم تعليقاتك',   32),
            ('Please upload User Image',    'Please upload User Image', 'ar_ae',    'الرجاء تحميل صورة المستخدم',   32),
            ('Image Not Uploading, please try again',   'Image Not Uploading, please try again',    'ar_ae',    'لا يتم تحميل الصورة، يرجى المحاولة مرة أخرى',  32),
            ('User Image Uploaded Successfully',    'User Image Uploaded Successfully', 'ar_ae',    'تم تحميل صورة المستخدم بنجاح', 32),
            ('Invalid Module name', 'Invalid Module name',  'ar_ae',    'اسم الوحدة غير صالح',  32),
            ('Records Sync Successfully',   'Records Sync Successfully',    'ar_ae',    'تمت مزامنة السجلات بنجاح', 32),
            ('Values cannot be empty',  'Values cannot be empty',   'ar_ae',    'لا يمكن أن تكون القيم فارغة',  32),
            ('Record id is empty',  'Record id is empty',   'ar_ae',    'معرف السجل فارغ',  32),
            ('Logout Successfully', 'Logout Successfully',  'ar_ae',    'تم تسجيل الخروج بنجاح',    32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'ar_ae',    'الرجاء تمكين وحدة CTMobile',   32),
            ('Authentication Failed',   'Username and Password do not match',   'ar_ae',    'اسم المستخدم وكلمة المرور لا يتطابقان',    32),
            ('Mismatched module information',   'Something gone wrong, please try again later', 'ar_ae',    'حدث خطأ ما، يرجى المحاولة مرة أخرى لاحقًا',    32),
            ('Field does not exists',   'Please set display fields again',  'ar_ae',    'الرجاء ضبط حقول العرض مرة أخرى',   32),
            ('Module does not exists',  'Module does not exists or disabled by admin',  'ar_ae',    'الوحدة غير موجودة أو تم تعطيلها بواسطة المشرف',    32),
            ('Month cannot be empty',   'Could not get the Month - Try again later',    'ar_ae',    'تعذر الحصول على الشهر - حاول مرة أخرى لاحقًا', 32),
            ('Year cannot be empty',    'Could not get the Year - Try again later', 'ar_ae',    'تعذر الحصول على السنة - حاول مرة أخرى لاحقًا', 32),
            ('Date cannot be empty',    'Could not get the Date - Try again later', 'ar_ae',    'تعذر الحصول على التاريخ - حاول مرة أخرى لاحقًا',   32),
            ('Userid cannot be empty',  'Could not get the Userid - Try again later',   'ar_ae',    'تعذر الحصول على معرف المستخدم - حاول مرة أخرى لاحقًا', 32),
            ('End Date cannot be empty',    'Could not get the status - Try again later',   'ar_ae',    'تعذر الحصول على الحالة - حاول مرة أخرى لاحقًا',    32),
            ('Start Date cannot be empty',  'Could not get the Start Date - Try again later',   'ar_ae',    'تعذر الحصول على تاريخ البدء - حاول مرة أخرى لاحقًا',   32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'ar_ae',    'لم تقم بتكوين SMS Notifier في CRM. يرجى تكوين SMS Notifier في نظام إدارة علاقات العملاء (CRM) الخاص بك لاستخدام هذه الميزة',   32),
            ('Longitude cannot be empty',   'Could not get location-Please try again',  'ar_ae',    'تعذر الحصول على الموقع-يرجى المحاولة مرة أخرى',    32),
            ('Latitude cannot be empty',    'Could not get location-Please try again',  'ar_ae',    'تعذر الحصول على الموقع-يرجى المحاولة مرة أخرى',    32),
            ('User cannot be empty',    'Could not get the User - Try again later', 'ar_ae',    'تعذر الحصول على المستخدم - حاول مرة أخرى لاحقًا',  32),
            ('Status cannot be empty',  'Could not get the status - Try again later',   'ar_ae',    'تعذر الحصول على الحالة - حاول مرة أخرى لاحقًا',    32),
            ('Required fields not found',   'Required fields not found',    'ar_ae',    'لم يتم العثور على الحقول المطلوبة',    32),
            ('Tracking module not active',  'Tracking module not active-Please contact CRM Admin',  'ar_ae',    'وحدة التتبع غير نشطة - يرجى الاتصال بمسؤول CRM',   32),
            ('Missing mandatory input values',  'Missing mandatory input values',   'ar_ae',    'قيم الإدخال الإلزامية مفقودة', 32),
            ('No MailBox found. Please Create Mailbox', 'No MailBox found. Please Create Mailbox',  'ar_ae',    'لم يتم العثور على صندوق بريد. الرجاء إنشاء صندوق بريد',    32),
            ('Mail not sent',   'Mail not sent',    'ar_ae',    'لم يتم إرسال البريد',  32),
            ('Mail send successfully',  'Mail send successfully',   'ar_ae',    'تم إرسال البريد بنجاح',    32),
            ('Email Id or username not match with your record', 'Email Id or username not match with your record',  'ar_ae',    'معرف البريد الإلكتروني أو اسم المستخدم لا يتطابق مع السجل الخاص بك',   32),
            ('Module not specified',    'Module not specified', 'ar_ae',    'الوحدة غير محددة', 32),
            ('No messages found',   'No messages found',    'ar_ae',    'لا توجد رسائل',    32),
            ('No Dependency Found For This Module', 'No Dependency Found For This Module',  'ar_ae',    'لم يتم العثور على تبعية لهذه الوحدة',  32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'ar_ae',    'لم يتم تمكين الخادم الصادر',   32),
            ('Outgoing server is Enabled',  'Outgoing server is Enabled',   'ar_ae',    'تم تمكين الخادم الصادر',   32),
            ('Email Attached Successfully', 'Email Attached Successfully',  'ar_ae',    'تم إرفاق البريد الإلكتروني بنجاح', 32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  'ar_ae',    'تم إرفاق المستندات بنجاح', 32),
            ('Login required - Please login again', 'Login required - Please login again',  'ar_ae',    'تسجيل الدخول مطلوب - يرجى تسجيل الدخول مرة أخرى',  32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  'ar_ae',    'تم تعطيل وحدة تتبع الوقت', 31),
            ('route_planning_module_disable',   'Route planning module is disable', 'ar_ae',    'تم تعطيل وحدة تخطيط الطريق',   31),
            ('mark_as_held',    'Are you sure you want to mark Event as Held?', 'ar_ae',    'هل أنت متأكد أنك تريد وضع علامة \"معقد\" على الحدث؟',  31),
            ('stop_timer_msg',  'You have already started Time tracking for another record, Do you want to stop it first ?',    'ar_ae',    'لقد بدأت بالفعل في تتبع الوقت لسجل آخر، هل تريد إيقافه أولاً؟',    31),
            ('access_denied_routeplanning', 'Access denied for route planning', 'ar_ae',    'تم رفض الوصول لتخطيط الطريق',  31),
            ('time_spent',  'Time Spent',   'ar_ae',    'قضاء الوقت',   31),
            ('select_user', 'Select User',  'ar_ae',    'اختر المستخدم',    30),
            ('status_cannot_be_held',   'Status cannot be held for future date start',  'ar_ae',    'لا يمكن الاحتفاظ بالحالة حتى تاريخ البدء المستقبلي',   30),
            ('please_select_end_date',  'Please select end date',   'ar_ae',    'الرجاء تحديد تاريخ الانتهاء',  30),
            ('please_select_start_date',    'Please select start date', 'ar_ae',    'الرجاء تحديد تاريخ البدء', 30),
            ('tap_on_plus_icon_for_select_route',   'Tap on + icon to select record for your route.',   'ar_ae',    'اضغط على أيقونة + لتحديد سجل لمسارك.', 30),
            ('please_enter_notes',  'Please enter notes',   'ar_ae',    'الرجاء إدخال الملاحظات',   30),
            ('please_enter_title',  'Please enter title',   'ar_ae',    'الرجاء إدخال العنوان', 30),
            ('please_select_date',  'Please Select Date',   'ar_ae',    'الرجاء تحديد التاريخ', 30),
            ('search_by_date',  'Search by Date',   'ar_ae',    'البحث حسب التاريخ',    30),
            ('shortcut_not_setup_yet',  'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  'ar_ae',    'عذرًا، لم يتم إعداد الاختصار بعد!!! يرجى إضافة اختصار بالضغط على [الأيقونات أو عرض شاشة التسجيل.', 30),
            ('max_upload_size', 'max file Upload exceeds',  'ar_ae',    'يتجاوز الحد الأقصى لتحميل الملف',  30),
            ('unselect_all',    'UnSelect All', 'ar_ae',    'إلغاء تحديد الكل', 30),
            ('select_all',  'Select All',   'ar_ae',    'اختر الكل',    30),
            ('please_select_records',   'Please select records',    'ar_ae',    'الرجاء تحديد السجلات', 30),
            ('select_date', 'Select Date',  'ar_ae',    'حدد تاريخ',    30),
            ('quantity_in_stock_is',    'Quantity in stock is', 'ar_ae',    'الكمية في المخزون هي', 30),
            ('replies', 'Replies',  'ar_ae',    'الردود',   30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'ar_ae',    'يتطلب التحويل تحديد جهة الاتصال أو المنظمة',   30),
            ('please_select_product',   'Please Select Product',    'ar_ae',    'الرجاء تحديد المنتج',  30),
            ('timer_msg',   'You can start timer for single task only at same time',    'ar_ae',    'يمكنك بدء تشغيل المؤقت لمهمة واحدة فقط في نفس الوقت',  31),
            ('save_start_tracking', 'Save & Start Tracking',    'ar_ae',    'حفظ وبدء التتبع',  31),
            ('lbl_notes',   'Notes',    'ar_ae',    'ملحوظات',  31),
            ('enter_title', 'Enter Title',  'ar_ae',    'أدخل العنوان', 31),
            ('select_module_record',    'Select Module / Record',   'ar_ae',    'حدد الوحدة / السجل',   31),
            ('lbl_tomorrow',    'Tomorrow', 'ar_ae',    'غداً', 30),
            ('lbl_yesterday',   'Yesterday',    'ar_ae',    'أمس',  30),
            ('lbl_today',   'Today',    'ar_ae',    'اليوم',    30),
            ('time_tracker',    'Time Tracker', 'ar_ae',    'تعقب الوقت',   31),
            ('time_end',    'End Time', 'ar_ae',    'وقت النهاية',  5),
            ('due_date',    'End Date', 'ar_ae',    'تاريخ الانتهاء',   5),
            ('time_start',  'Time Start',   'ar_ae',    'وقت البدء',    5),
            ('date_start',  'Start Date',   'ar_ae',    'تاريخ البدء',  5),
            ('delete_widget_msg',   'Display widget again by using (+) option', 'ar_ae',    'عرض القطعة مرة أخرى باستخدام خيار (+).',   15),
            ('no_upcoming_activities',  'No scheduled activities      ',    'ar_ae',    'لا توجد أنشطة مجدولة', 15),
            ('check_in_first',  'Please check-in first',    'ar_ae',    'يرجى تسجيل الدخول أولا',   30),
            ('duration',    'Duration', 'ar_ae',    'مدة',  30),
            ('distance',    'Distance', 'ar_ae',    'مسافة',    30),
            ('proper_address_message',  'Please enter proper address in record\n',  'ar_ae',    'الرجاء إدخال العنوان الصحيح في السجل', 30),
            ('select_status',   'Select Status',    'ar_ae',    'حدد الحالة',   30),
            ('route_planner',   'Route Planner',    'ar_ae',    'مخطط الطريق',  30),
            ('route_planning',  'Route Planning',   'ar_ae',    'تخطيط الطريق', 30),
            ('add_route',   'Add Route',    'ar_ae',    'إضافة الطريق', 30),
            ('calender_disabled',   'Calendar Module is disabled',  'ar_ae',    'تم تعطيل وحدة التقويم',    30),
            ('close_dialog',    'Close form',   'ar_ae',    'إغلاق النموذج',    30),
            ('cancel_form_message', 'Are You sure want to close ?', 'ar_ae',    'هل أنت متأكد أنك تريد الإغلاق؟',   30),
            ('create_route',    'Create Route', 'ar_ae',    'إنشاء الطريق', 30),
            ('select_module_create_route',  'Select Module to create Route',    'ar_ae',    'حدد الوحدة النمطية لإنشاء المسار', 30),
            ('cancel',  'Cancel',   'ar_ae',    'الغاء',    30),
            ('assign_route',    'Assign Route', 'ar_ae',    'تعيين الطريق', 30),
            ('route_for',   'Route for',    'ar_ae',    'الطريق ل', 30),
            ('assigned_to', 'Assigned To',  'ar_ae',    'مخصص ل',   30),
            ('enter_route_name',    'Enter Route Name', 'ar_ae',    'أدخل اسم الطريق',  30),
            ('list',    'List', 'ar_ae',    'قائمة',    30),
            ('map', 'Map',  'ar_ae',    'خريطة',    30),
            ('other_modules',   'Other Modules',    'ar_ae',    'وحدات أخرى',   15),
            ('shortcut_no_record_msg',  'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 'ar_ae',    'لم يتم إعداد اختصار Ops\n حتى الآن!!! الرجاء إضافة اختصار بالضغط على أيقونة + من السجل\n نتائج البحث أو عرض شاشة التسجيل.',    25),
            ('clear',   'Clear',    'ar_ae',    'واضح', 25),
            ('open',    'Open', 'ar_ae',    'يفتح', 11),
            ('max_file_msg',    'Too many files selected (max:6)',  'ar_ae',    'تم تحديد عدد كبير جدًا من الملفات (الحد الأقصى: 6)',   11),
            ('error_voicenote_record',  'Unable to recording voice while another application is recording sound.',  'ar_ae',    'غير قادر على تسجيل الصوت أثناء قيام تطبيق آخر بتسجيل الصوت.',  11),
            ('msg_warning', 'Warning!', 'ar_ae',    'تحذير!',   11),
            ('Permision_denied_contact',    'Permission denied to access your contacts',    'ar_ae',    'تم رفض الإذن للوصول إلى جهات الاتصال الخاصة بك',   15),
            ('no_widget_added', 'Please click + icon to add new widget to your dashboard.', 'ar_ae',    'الرجاء النقر على أيقونة + لإضافة عنصر واجهة مستخدم جديد إلى لوحة التحكم الخاصة بك.',   15),
            ('no_data_available',   'Data not available, please check the selected fields', 'ar_ae',    'البيانات غير متوفرة، يرجى التحقق من الحقول المحددة',   15),
            ('check_out_successfully',  'Check out successfully',   'ar_ae',    'تم السحب بنجاح',   11),
            ('check_in_successfully',   'Check in successfully',    'ar_ae',    'تم تسجيل الدخول بنجاح',    11),
            ('check_out',   'Check out',    'ar_ae',    'الدفع',    11),
            ('check_in',    'Check in', 'ar_ae',    'تحقق في',  11),
            ('navigate',    'Navigate', 'ar_ae',    'التنقل',   11),
            ('save_to_phone_vcard_success', 'VCard Saved to phone successfully',    'ar_ae',    'تم حفظ VCard على الهاتف بنجاح',    15),
            ('download_vcard_success',  'VCard downloaded successfully',    'ar_ae',    'تم تنزيل VCard بنجاح', 15),
            ('card_details',    'Card Details', 'ar_ae',    'معلومات البطاقة',  15),
            ('add_widget',  'Add Widget',   'ar_ae',    'إضافة القطعة', 15),
            ('delete_widget',   'Are you sure to hide widget?', 'ar_ae',    'إضافة القطعة هل أنت متأكد من إخفاء القطعة؟',   15),
            ('already_widgets_added',   'All types of Widget & reports are already added',  'ar_ae',    'تمت إضافة جميع أنواع الأدوات والتقارير بالفعل',    15),
            ('retry',   'Retry',    'ar_ae',    'أعد المحاولة', 28),
            ('retake',  'Retake',   'ar_ae',    'إعادة الالتقاط',   28),
            ('Reports', 'Reports',  'ar_ae',    'التقارير', 15),
            ('Widgets', 'Widgets',  'ar_ae',    'الحاجيات', 15),
            ('vcard_config',    'Vcard Configuration',  'ar_ae',    'تكوين Vcard',  8),
            ('save_to_phone',   'Save to phone',    'ar_ae',    'حفظ على الهاتف',   11),
            ('download_vcard',  'Download Vcard',   'ar_ae',    'تحميل في كارد',    11),
            ('share_vcard', 'Share Vcard',  'ar_ae',    'مشاركة فكارد', 11),
            ('share_record',    'Share Record', 'ar_ae',    'شارك ',    11),
            ('permission_denied_edit',  'You don\'t have permission to edit this record.',  'ar_ae',    'انت لا تملك صلاحيه الاضافه',   27),
            ('permission_denied_delete',    'You don\'t have permission to delete this record.',    'ar_ae',    'انهت لا تملك صلاحيه الغاء هذا ',   27),
            ('Voice_Recording_Started', 'Recording Started',    'ar_ae',    'بدء التسجيل',  12),
            ('Voice_Recording_Stopped', 'Recording Stopped',    'ar_ae',    'وقف التسجيل',  12),
            ('SEARCH',  'Search',   'ar_ae',    'بحث',  7),
            ('LAST',    'Last', 'ar_ae',    'الاخير',   7),
            ('FIRST',   'First',    'ar_ae',    'الاول',    7),
            ('MONDAY',  'Monday',   'ar_ae',    'الاثنين',  7),
            ('TUESDAY', 'Tuesday',  'ar_ae',    'الثلاثاء', 7),
            ('WEDNESDAY',   'Wednesday',    'ar_ae',    'الاربعاء', 7),
            ('THURSDAY',    'Thursday', 'ar_ae',    'الخميس',   7),
            ('FRIDAY',  'Friday',   'ar_ae',    'الجمعه',   7),
            ('SATURDAY',    'Saturday', 'ar_ae',    'السبت',    7),
            ('SUNDAY',  'Sunday',   'ar_ae',    'الاحد',    7),
            ('DAILY',   'Daily',    'ar_ae',    'يوميا',    7),
            ('WEEKLY',  'Weekly',   'ar_ae',    'اسبوعيا',  7),
            ('MONTHLY', 'Monthly',  'ar_ae',    'شهريا',    7),
            ('YEARLY',  'Yearly',   'ar_ae',    'سنويا',    7),
            ('asset_tracking',  'Asset tracking',   'ar_ae',    'مساعده في البحث',  15),
            ('open_file',   'Open File',    'ar_ae',    'افتح الملف',   1),
            ('download_pdf_successfully',   'Download PDF Successfully',    'ar_ae',    'تم تنزيل ملف PDF بنجاح',   1),
            ('select_pdf',  'Select PDF',   'ar_ae',    'حدد قوات الدفاع الشعبي',   1),
            ('email_pdf',   'Email PDF',    'ar_ae',    'أرسل ملف PDF بالبريد الإلكتروني',  1),
            ('download_pdf',    'Download PDF', 'ar_ae',    'تحميل PDF',    1),
            ('edit_route',  'Edit Route',   'ar_ae',    'تحرير المسار', 1),
            ('save_route',  'Save Route',   'ar_ae',    'حفظ المسار',   1),
            ('clear_all',   'Clear All',    'ar_ae',    'امسح الكل',    1),
            ('notification',    'Notifications',    'ar_ae',    'إشعارات',  1),
            ('menu_management', 'Menu Management',  'ar_ae',    'إدارة القائمة',    1),
            ('select_menu', 'Select Menu',  'ar_ae',    'اختر قائمة',   1),
            ('module_record_not_found', 'Module and Record not found',  'ar_ae',    'لم يتم العثور على الوحدة النمطية والسجل',  1),
            ('reason_for_changing_comments',    'Reason for changing comments', 'ar_ae',    'سبب تغيير التعليقات',  1),
            ('edit_reason', 'Edit Reason',  'ar_ae',    'تعديل السبب',  1),
            ('create_filters',  'Create Filter',    'ar_ae',    'إنشاء عامل تصفية', 1),
            ('you_checked', 'You Checked',  'ar_ae',    'لقد فحصت', 1),
            ('you_un_checked',  'You UnChecked',    'ar_ae',    'لقد قمت بإلغاء التحديد',   1),
            ('log_the_call',    'Log the call ?',   'ar_ae',    'تسجيل المكالمة؟',  1),
            ('add_a_description_(optional)',    'Add a description (optional)', 'ar_ae',    'إضافة وصف (اختياري)',  1),
            ('called',  'Called',   'ar_ae',    'مُسَمًّى', 1),
            ('call_log',    'Call Log', 'ar_ae',    'سجل المكالمات',    1),
            ('subject', 'Subject',  'ar_ae',    'موضوع',    1),
            ('add_condition',   'Add Condition',    'ar_ae',    'إضافة شرط',    1),
            ('select_condition',    'Select Condition', 'ar_ae',    'حدد الحالة',   1),
            ('select_field',    'Select Field', 'ar_ae',    'حدد الحقل',    1),
            ('please_select_first_field',   'Please First Select field',    'ar_ae',    'الرجاء أولا تحديد الحقل',  1),
            ('filter_name', 'Filter Name',  'ar_ae',    'اسم الفلتر',   1),
            ('enter_filter_name',   'Enter filter name',    'ar_ae',    'أدخل اسم الفلتر',  1),
            ('choose_conditions',   'Choose Conditions',    'ar_ae',    'اختر الشروط',  1),
            ('all_condition',   'All Conditions(All conditions must be met)',   'ar_ae',    'جميع الشروط (يجب استيفاء جميع الشروط)',    1),
            ('any_condition',   'Any Conditions(At least one the conditions must be met)',  'ar_ae',    'أي شروط (يجب استيفاء شرط واحد على الأقل)', 1),
            ('lattitude',   'latitude', 'ar_ae',    'خط العرض', 1),
            ('notification_settings',   'Notification Settings',    'ar_ae',    'إعدادات الإشعار',  1),
            ('notification_management', 'Notification Management',  'ar_ae',    'إدارة الإخطارات',  1),
            ('addyourcommentshere', 'Type @ to mention user',   'ar_ae',    'اكتب @ لذكر المستخدم', 1),
            ('google_api_key_missing',  'Google Api key is missing.',   'ar_ae',    'مفتاح Google API مفقود.',  1),
            ('event_filter_by', 'Event Filter by',  'ar_ae',    'تصفية الأحداث حسب',    1),
            ('apply',   'Apply',    'ar_ae',    'يتقدم',    1),
            ('choose_from_gallery', 'Choose From Gallery',  'ar_ae',    'اختر من المعرض',   1),
            ('choose_from_camera',  'Choose From Camera',   'ar_ae',    'اختر من الكاميرا', 1),
            ('mutli_select_CB', 'Mutli Select CB',  'ar_ae',    'متعدد تحديد CB',   1),
            ('please_select_condition', 'Please Select Condition',  'ar_ae',    'الرجاء تحديد الحالة',  1),
            ('please_enter_value_or_field', 'Please Enter Value or Field',  'ar_ae',    'الرجاء إدخال القيمة أو الحقل', 1),
            ('set_as_default',  'Set as Default',   'ar_ae',    'تعيين كافتراضي',   1),
            ('list_in_metrics', 'List in Metrics',  'ar_ae',    'قائمة في المقاييسقائمة في المقاييس',   1),
            ('order_number',    'Order Number', 'ar_ae',    'رقم الأمر',    1),
            ('recording_saved_message', 'Recording saved successfully.',    'ar_ae',    'تم حفظ التسجيل بنجاح.',    1),
            ('recording_file',  'Recording File',   'ar_ae',    'ملف التسجيل',  1),
            ('file_not_found',  'File not found',   'ar_ae',    'لم يتم العثور على الملف',  1),
            ('please_enter_valid_path', 'Please enter valid path',  'ar_ae',    'الرجاء إدخال مسار صالح',   1),
            ('enter_path_here', 'Enter path here...',   'ar_ae',    'أدخل المسار هنا...',   1),
            ('set_call_recording_path', 'Set Call Recording Path',  'ar_ae',    'ضبط مسار تسجيل المكالمات', 1),
            ('set_call_recording_path_here',    'Set call recording path here', 'ar_ae',    'اضبط مسار تسجيل المكالمات هنا',    1),
            ('call_recording_path', 'Call Recording Path',  'ar_ae',    'مسار تسجيل المكالمات', 1),
            ('please_place_api',    'Please enable place api',  'ar_ae',    'يرجى تمكين مكان API',  1),
            ('event_filters_by',    'Event Filters by', 'ar_ae',    'مرشحات الأحداث حسب',   1),
            ('select_at_least_one_option',  'Please select at least one option',    'ar_ae',    'الرجاء تحديد خيار واحد على الأقل', 1),
            ('enable_call_feature', 'Please enable call feature',   'ar_ae',    'يرجى تفعيل ميزة الاتصال',  1),
            ('enable_email_feature',    'Please enable email feature',  'ar_ae',    'الرجاء تفعيل ميزة البريد الإلكتروني',  1),
            ('demo_login',  'Demo Login',   'ar_ae',    'تسجيل الدخول التجريبي',    1),
            ('select_email_template',   'Select Email Template',    'ar_ae',    'حدد قالب البريد الإلكتروني',   1),
            ('template_name',   'Template Name',    'ar_ae',    'اسم القالب',   1),
            ('example_storage_path',    'example : storage/Music/Recordings/Call Recordings',   'ar_ae',    'مثال: التخزين/الموسيقى/التسجيلات/تسجيلات المكالمات',   1),
            ('User Notification Settings saved successfully',   'User Notification Settings saved successfully',    'ar_ae',    'تم حفظ إعدادات إشعارات المستخدم بنجاح',    33),
            ('This Notification has been disabled by admin',    'This Notification has been disabled by admin', 'ar_ae',    'لقد تم تعطيل هذا الإشعار من قبل المشرف',   33),
            ('Notify when any updates to the record you\'re following', 'Notify when any updates to the record you\'re following',  'ar_ae',    'إعلام عند حدوث أي تحديثات للسجل الذي تتابعه',  33),
            ('Task assigned to you',    'Task assigned to you', 'ar_ae',    'المهمة الموكلة إليك',  33),
            ('Task Reminder',   'Task Reminder',    'ar_ae',    'تذكير بالمهمة',    33),
            ('You were mentioned in comments',  'You were mentioned in comments',   'ar_ae',    'لقد تم ذكرك في التعليقات', 33),
            ('Comments has been added to record assigned to you',   'Comments has been added to record assigned to you',    'ar_ae',    'تمت إضافة التعليقات إلى السجل المخصص لك',  33),
            ('When Record Assigned',    'When Record Assigned', 'ar_ae',    'عندما سجل المعينة',    33),
            ('Event Reminder',  'Event Reminder',   'ar_ae',    'تذكير بالحدث', 33),
            ('Event Invitation',    'Event Invitation', 'ar_ae',    'دعوة للحدث',   33),
            ('Follow record',   'Follow record',    'ar_ae',    'اتبع السجل',   33),
            ('Task',    'Task', 'ar_ae',    'مهمة', 33),
            ('Conversions', 'Conversions',  'ar_ae',    'التحويلات',    33),
            ('Events',  'Events',   'ar_ae',    'الأحداث',  33),
            ('no_records_changed_filter_message',   'No record(s) found Please click on filter icon to change filter',  'ar_ae',    'لم يتم العثور على أي سجل (سجلات) يرجى النقر على أيقونة التصفية لتغيير عامل التصفية',   1),
            ('title',   'Title',    'ar_ae',    'عنوان',    1),
            ('dialog_recent_call_info', 'Click + to select your mobile call recording folder where your recorded call files are stored.',   'ar_ae',    'انقر فوق + لتحديد مجلد تسجيل مكالمات الهاتف المحمول الخاص بك حيث يتم تخزين ملفات المكالمات المسجلة.',  1),
            ('call_recording',  'Call recording',   'ar_ae',    'تسجيل المكالمات',  1),
            ('voice_recorder',  'Voice Recorder',   'ar_ae',    'مسجل الصوت',   1),
            ('no_address_reference_found',  'No Address Reference found',   'ar_ae',    'لم يتم العثور على مرجع العنوان',   32),
            ('no_overdue_activities',   'No OverDue Activities',    'ar_ae',    'لا توجد أنشطة متأخرة', 32),
            ('latitude_longitude_validation_message',   'Please enter proper address from this address we are not getting proper latitude and longitude',   'ar_ae',    'الرجاء إدخال العنوان الصحيح من هذا العنوان، فنحن لا نحصل على خطوط الطول والعرض المناسبة',  32),
            ('Default_Search_Field',    'Default search field', 'ar_ae',    'حقل البحث الافتراضي',  32),
            ('Calender_Reminder_Message',   'Free user can\'t send local reminder', 'ar_ae',    'لا يمكن للمستخدم المجاني إرسال تذكير محلي',    32),
            ('you_must_have_permission',    'You must give permissions to use this features.',  'ar_ae',    'يجب عليك منح الأذونات لاستخدام هذه الميزات.',  32),
            ('internal_comment',    'Internal Comment', 'ar_ae',    'تعليق داخلي',  1),
            ('unlink_record',   'Unlink Record',    'ar_ae',    'إلغاء ربط السجل',  11),
            ('unlink_record_msg',   'Are you sure want to unlink record?',  'ar_ae',    'هل أنت متأكد أنك تريد إلغاء ربط السجل؟',   11),
            ('file_format_not_support', 'File format not supported',    'ar_ae',    'تنسيق ملف غير معتمد',  11),
            ('file_upload', 'File Upload',  'ar_ae',    'تحميل الملف',  5),
            ('to_vtiger',   'To Vtiger',    'ar_ae',    'إلى فتيجر',    5),
            ('link_external_document',  'Link External Document',   'ar_ae',    'ربط الوثيقة الخارجية', 5),
            ('from_file_url',   'From File Url',    'ar_ae',    'من عنوان URL للملف',   5),
            ('create_new_document', 'Create New Document',  'ar_ae',    'إنشاء مستند جديد', 5),
            ('select_document_type',    'Select Document type', 'ar_ae',    'حدد نوع المستند',  5),
            ('add_signature',   'Please add signature', 'ar_ae',    'الرجاء إضافة التوقيع', 11),
            ('date_greater_then_equal', 'should be greater than or equal to',   'ar_ae',    'يجب أن يكون أكبر من أو يساوي', 1),
            ('date_less_then_equal',    'should be less than or equal to',  'ar_ae',    'يجب أن يكون أقل من أو يساوي',  1),
            ('Click_on_plus_for_add',   'Please tap on  +  to create a new record.',    'ar_ae',    'الرجاء الضغط على + لإنشاء سجل جديد.',  15),
            ('display_map', 'Display map',  'ar_ae',    'عرض الخريطة',  15),
            ('other_settings',  'Other settings',   'ar_ae',    'اعدادات اخرى', 15),
            ('total_hours', 'Total hours',  'ar_ae',    'مجموع الساعات',    15),
            ('widget_not_found',    'No widgets found', 'ar_ae',    'لم يتم العثور على أي أدوات',   15),
            ('quickaction', 'Quick action', 'ar_ae',    'عمل سريع', 15),
            ('dashboard',   'Dashboard',    'ar_ae',    'لوحة القيادة', 15),
            ('new', 'New',  'ar_ae',    'جديد', 15),
            ('global_search_hint',  'Please try to search using search box at top', 'ar_ae',    'يرجى محاولة البحث باستخدام مربع البحث في الأعلى',  15),
            ('near_by_map', 'Near By Map',  'ar_ae',    'بالقرب من الخريطة',    15),
            ('miles',   'Miles',    'ar_ae',    'اميال',    15),
            ('lbl_filters', 'Filters',  'ar_ae',    'المرشحات', 27),
            ('warning', 'Warning',  'ar_ae',    'تحذير',    27),
            ('no_filter_created',   'No filter is created.',    'ar_ae',    'لم يتم إنشاء أي مرشح.',    27),
            ('please_create_new_ilter', 'Please create a new filter',   'ar_ae',    'الرجاء إنشاء مرشح جديد',   27),
            ('select_search_fields',    'Select fields for the search record.', 'ar_ae',    'حدد الحقول لسجل البحث.',   27),
            ('apply_fliters',   'Apply filters',    'ar_ae',    'تطبيق المرشحات',   27),
            ('sort_by', 'Sort by',  'ar_ae',    'ترتيب حسب',    27),
            ('sort_order',  'Sort order',   'ar_ae',    'امر ترتيب',    27),
            ('Start_time_tracking', 'Start time tracking',  'ar_ae',    'بدء تتبع الوقت',   31),
            ('Stop_time_tracking',  'Stop time tracking',   'ar_ae',    'إيقاف تتبع الوقت', 31),
            ('image_preview',   'Image preview',    'ar_ae',    'معاينة الصورة',    11),
            ('phone_number',    'Phone number', 'ar_ae',    'رقم التليفون', 11),
            ('email_address',   'Email address',    'ar_ae',    'عنوان البريد الإلكتروني',  11),
            ('edit_your_preferences',   'Edit your preferences',    'ar_ae',    'قم بتحرير تفضيلاتك',   8),
            ('about_app',   'About app',    'ar_ae',    'حول التطبيق',  8),
            ('updated_ctmobile_ext_version',    'You already have latest CTMobile Ext. Version',    'ar_ae',    'لديك بالفعل أحدث إصدار من CTMobile Ext. إصدار',    8),
            ('updated_app_version', 'You already have latest CRMTiger App Version', 'ar_ae',    'لديك بالفعل أحدث إصدار من تطبيق CRMTiger', 8),
            ('plan',    'Plan', 'ar_ae',    'يخطط', 8),
            ('time',    'Time', 'ar_ae',    'وقت',  31),
            ('error_log_msg',   'Oops, something went wrong! Please click on Share Button to share error log with our technical team',  'ar_ae',    'تبا شيء ما حدث بشكل خاطئ! الرجاء الضغط على زر المشاركة لمشاركة سجل الأخطاء مع فريقنا الفني',   1),
            ('add_to_quick_action', 'Add to quick action',  'ar_ae',    'أضف إلى العمل السريع', 1),
            ('add_filter_to_quick_action',  'Add filter to quick action',   'ar_ae',    'أضف مرشحًا إلى الإجراء السريع',    1),
            ('create_record',   'Create Record',    'ar_ae',    'إنشاء سجل',    1),
            ('quick_action_hint',   'You can Add Quick Action here',    'ar_ae',    'يمكنك إضافة إجراء سريع هنا',   1),
            ('str_send',    'Send', 'ar_ae',    'يرسل', 3),
            ('tax_region_msg',  'Do you want to update tax & charge values corresponding to selected region?',  'ar_ae',    'هل تريد تحديث قيم الضرائب والرسوم المطابقة للمنطقة المحددة؟',  1),
            ('delete_quick_action_widgest', 'Delete Widget?',   'ar_ae',    'هل تريد حذف الأداة؟',  15),
            ('add_record_to_dashboard', 'Add record to dashboard',  'ar_ae',    'إضافة سجل إلى لوحة القيادة',   15),
            ('module_quick_action_msg', 'Module added to dashboard',    'ar_ae',    'تمت إضافة الوحدة إلى لوحة القيادة',    15),
            ('filter_quick_action_msg', 'Filter added to dashboard',    'ar_ae',    'تمت إضافة الفلتر إلى لوحة القيادة',    15),
            ('record_quick_action_msg', 'Record added to dashboard',    'ar_ae',    'تمت إضافة السجل إلى لوحة القيادة', 15),
            ('filter_shortcut_quick_action_msg',    'Filter shortcut added to dashboard',   'ar_ae',    'تمت إضافة اختصار الفلتر إلى لوحة التحكم',  15),
            ('record_shortcut_quick_action_msg',    'Record shortcut added to dashboard',   'ar_ae',    'تمت إضافة اختصار السجل إلى لوحة القيادة',  15),
            ('documents_disabled',  'Documents Module is disabled', 'ar_ae',    'تم تعطيل وحدة المستندات',  1),
            ('document_dont_attachment',    'Document does not have a attachment',  'ar_ae',    'الوثيقة لا تحتوي على مرفق',    1),
            ('go_to_neat_by',   'Go to NearBy', 'ar_ae',    'انتقل إلى مكان قريب',  15),
            ('go_to_time_tracking', 'Go to Time Tracker',   'ar_ae',    'انتقل إلى تعقب الوقت', 13),
            ('nearby_quick_action_msg', 'NearBy added to dashboard',    'ar_ae',    'تمت إضافة NearBy إلى لوحة القيادة',    15),
            ('time_tracking_quick_action_msg',  'Time Tracking added to dashboard', 'ar_ae',    'تمت إضافة تتبع الوقت إلى لوحة القيادة',    15),
            ('attendance_quick_action_msg', 'Attendance added to dashboard',    'ar_ae',    'تمت إضافة الحضور إلى لوحة القيادة',    15),
            ('attachment',  'Attachment',   'ar_ae',    'مرفق', 15),
            ('search_by_fields',    'Search by fields', 'ar_ae',    'البحث حسب الحقول', 27),
            ('apply_selected',  'Apply selected',   'ar_ae',    'تطبيق المحدد', 27),
            ('auto_address_disabled',   'auto address finder is disabled, please enable it from CRMTiger Settings', 'ar_ae',    'تم تعطيل أداة البحث التلقائي عن العناوين، يرجى تمكينها من إعدادات CRMTiger',   1),
            ('Attendance',  'Attendance',   'ar_ae',    'حضور', 15),
            ('Check-in successfully',   'Check-in successfully',    'ar_ae',    'تم تسجيل الدخول بنجاح',    32),
            ('Check-out successfully',  'Check-out successfully',   'ar_ae',    'تم تسجيل الخروج بنجاح',    32),
            ('Nothing around here', 'Nothing around here',  'ar_ae',    'لا شيء هنا',   13),
            ('select_days', 'Select Days',  'ar_ae',    'حدد الأيام',   5),
            ('select_minutes',  'Select Minutes',   'ar_ae',    'حدد الدقائق',  5),
            ('select_hours',    'Select Hours', 'ar_ae',    'حدد الساعات',  5),
            ('no_lat_long_found',   'Location information (Latitude,Longitude) not found',  'ar_ae',    'لم يتم العثور على معلومات الموقع (خط العرض، خط الطول).',   32),
            ('Call Log save successfully',  'Call Log save successfully',   'ar_ae',    'تم حفظ سجل المكالمات بنجاح',   32),
            ('Files/photos deleted successfully',   'Files/photos deleted successfully',    'ar_ae',    'تم حذف الملفات/الصور بنجاح',   32),
            ('important',   'Important',    'ar_ae',    'مهم',  34),
            ('template',    'Template', 'ar_ae',    'نموذج',    34),
            ('copy',    'Copy', 'ar_ae',    'ينسخ', 34),
            ('camera',  'Camera',   'ar_ae',    'آلة تصوير',    34),
            ('gallery', 'Gallery',  'ar_ae',    'صالة عرض', 34),
            ('audio',   'Audio',    'ar_ae',    'صوتي', 34),
            ('last_seen_at',    'Last seen at', 'ar_ae',    'شوهد آخر مرة في',  34),
            ('type_a_message',  'Type a message',   'ar_ae',    'اكتب رسالة',   34),
            ('all_messages',    'All messages', 'ar_ae',    'جميع الرسائل', 34),
            ('time_tracking_reports',   'Time tracking reports',    'ar_ae',    'تقارير تتبع الوقت',    31),
            ('attendance_reports',  'Attendance reports',   'ar_ae',    'تقارير الحضور',    31),
            ('chats',   'Chats',    'ar_ae',    'الدردشات', 34),
            ('Marked chat as Important',    'Marked chat as Important', 'ar_ae',    'تم وضع علامة على الدردشة على أنها مهمة',   34),
            ('Unmarked chat as Important',  'Unmarked chat as Important',   'ar_ae',    'تم إلغاء وضع علامة على الدردشة باعتبارها مهمة',    34),
            ('mark_as_important',   'Mark as important',    'ar_ae',    'وضع علامة على أنها مهمة',  34),
            ('unmark_As_important', 'Unmark as important',  'ar_ae',    'قم بإلغاء تحديد الأهمية',  34),
            ('select_template', 'Select template',  'ar_ae',    'حدد قالب', 34),
            ('chat',    'Chat', 'ar_ae',    'محادثة',   34),
            ('search_by_name_or_contact',   'Search by name or contact',    'ar_ae',    'البحث بالاسم أو جهة الاتصال',  34),
            ('choose_contact_for_whatsApp', 'Choose contact for whatsApp',  'ar_ae',    'اختر جهة اتصال لتطبيق WhatsApp',   34),
            ('whatsapp_template',   'Whatsapp template',    'ar_ae',    'قالب واتس اب', 34),
            ('send_voice_recording',    'Send voice recording', 'ar_ae',    'إرسال التسجيل الصوتي', 34),
            ('slide_to_cancel', 'Slide To Cancel',  'ar_ae',    'قم بالتمرير للإلغاء',  34),
            ('whatsapp_disconnect_messsage',    'Ooops.. You\'re disconnected from WhatsApp. Please Scan QR Code from the CRM.',    'ar_ae',    'عفوًا.. لقد تم قطع اتصالك بالواتساب. يرجى مسح رمز الاستجابة السريعة ضوئيًا من CRM.',   34),
            ('select_priority', 'Select priority',  'ar_ae',    'حدد الأولوية', 30),
            ('repeat_route',    'Repeat route', 'ar_ae',    'كرر المسار',   30),
            ('change_assign_to',    'Change assigned to',   'ar_ae',    'التغيير المخصص ل', 30),
            ('Multiple Route created successfully', 'Multiple Route created successfully',  'ar_ae',    'تم إنشاء مسارات متعددة بنجاح', 30),
            ('Route duplicated successfully',   'Route duplicated successfully',    'ar_ae',    'تم تكرار المسار بنجاح',    30);",array());   
        }
    }

    static function es_es(){
        global $adb;
        $checkLang = $adb->pquery("SELECT 1 FROM ctmobile_language_keyword WHERE keyword_lang = ?",array('es_es'));
        if($adb->num_rows($checkLang) == 0){
            $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error',   'Network connection error!',    'es_es',    '¡Error de conexión de red!',   1),
            ('connection_check',    'Could not connect to CRM, Please check your Internet connection.', 'es_es',    'No se pudo conectar a CRM. Verifique su conexión a Internet.', 1),
            ('update',  'Update',   'es_es',    'Actualizar',   1),
            ('cancel',  'Cancel',   'es_es',    'Cancelar', 1),
            ('ok',  'Ok',   'es_es',    'DE ACUERDO',   1),
            ('more_information',    'Click here for more information.', 'es_es',    'Haga clic aquí para mas información.', 1),
            ('yes', 'Yes',  'es_es',    'Sí',   1),
            ('no',  'No',   'es_es',    'No',   1),
            ('click_again_exit',    'Click again to exit',  'es_es',    'Haga clic de nuevo para salir',    1),
            ('forpermission',   'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.',   'es_es',    'No tiene permiso para ver estas características, para acceder suscribase a la versión premium Clic aqui para suscribirse.',    1),
            ('clickhere',   'Click here',   'es_es',    'Clic Aquí',    1),
            ('clickhere_subscribe', 'Click here to subscribe premium version',  'es_es',    'Clic aqui para suscribirse',   1),
            ('clickhere_configure', 'Click here and view how to Configure.',    'es_es',    'Haga clic aquí y vea cómo configurar.',    1),
            ('please_wait', 'Please Wait…', 'es_es',    'Por favor espera…',    1),
            ('share__msg',  'Share file with',  'es_es',    'compartir archivo con',    1),
            ('dialog_camera',   'Camera',   'es_es',    'Cámara',   1),
            ('dialog_add_file_by',  'Take Photo from',  'es_es',    'Agregar archivos por', 1),
            ('add', 'Add',  'es_es',    'Agregar',  1),
            ('mail_manager_configured', 'Mail Manager is not configured',   'es_es',    'Mail Manager no está configurado', 1),
            ('dialog_add_files_by', 'Add Files by', 'es_es',    'Agregar archivos por', 1),
            ('dialog_drive',    'Drive',    'es_es',    'Controlar',    1),
            ('dialog_drop_box', 'Drop Box', 'es_es',    'buzón',    1),
            ('dialog_need_signin',  'You need to Sign-in to your Drive account first.', 'es_es',    'debe iniciar sesión primero',  1),
            ('dialog_gallery',  'Gallery',  'es_es',    'Galería',  1),
            ('delete',  'Delete',   'es_es',    'Borrar',   1),
            ('timeoutmessage',  'Oops! Request is taking more time than expected.', 'es_es',    'Oops solicitud lleva tiempo de lo esperado.',  1),
            ('gps_location_message',    'GPS is not enabled. Please turn it on to get your near by locations.', 'es_es',    'GPS no está habilitado. Por favor, enciéndelo para obtener su ubicación cercana.', 1),
            ('sure_want_delete',    'Are you sure want to delete ?',    'es_es',    '¿Seguro que quiere borrar?',   1),
            ('select',  'Select',   'es_es',    'Seleccionar',  1),
            ('msgforrecordaudio',   'Minimum record duration one second.',  'es_es',    'Duración mínima del registro un segundo',  1),
            ('permission_storage',  'Permission denied to read your External storage',  'es_es',    'Permiso denegado para leer el almacenamiento externo', 1),
            ('send_permission_msg', 'Send message permission denied',   'es_es',    'Permiso de llamada denegado',  1),
            ('choosefile',  'Choose File',  'es_es',    'Elija el archivo', 1),
            ('enter',   'Enter',    'es_es',    'Entrar',   1),
            ('select_an_option',    'Select an Option', 'es_es',    'Sleccione una opcion', 1),
            ('email_validation',    'Email is not valid',   'es_es',    'El correo no es válido',   1),
            ('please_enter',    'Please Enter', 'es_es',    'Por favor escribe',    1),
            ('website_validation_text', 'Website URL is not valid', 'es_es',    'La URL del sitio web no es válida',    1),
            ('selectvalue', 'Select value first',   'es_es',    'Seleccionar valor',    1),
            ('email',   'Email',    'es_es',    'Correo electrónico',   1),
            ('enter_email_address', 'Enter email address',  'es_es',    'Introduzca la dirección de correo electrónico',    1),
            ('email_address_not_correct',   'Email address incorrect',  'es_es',    'Dirección de correo electrónico incorrecta',   1),
            ('pls_enter_subject',   'Please Enter Subject', 'es_es',    'Por favor ingrese el asunto',  1),
            ('attachFiles', 'Attached File',    'es_es',    'Adjuntar archivo', 1),
            ('from',    'From', 'es_es',    'Desde',    1),
            ('to',  'To',   'es_es',    'A',    1),
            ('call_permission_msg', 'Call permission denied',   'es_es',    'Permiso de llamada denegado',  1),
            ('no_records',  'No records found', 'es_es',    'No se encontrarón registros',  1),
            ('fullform',    'Create New',   'es_es',    'Forma completa',   1),
            ('save',    'Save', 'es_es',    'Guardarng',    1),
            ('total',   'Total',    'es_es',    'Total',    1),
            ('discount',    'Discount', 'es_es',    'Descuento',    1),
            ('price',   'Price',    'es_es',    'Precio *', 1),
            ('quantity',    'Quantity', 'es_es',    'Cantidad *',   1),
            ('select_module',   'Select Module',    'es_es',    'Seleccionar módulo',   1),
            ('item_list',   'Item List',    'es_es',    'Lista de articulos',   1),
            ('quickcreate', 'Quick Create', 'es_es',    'Creación rápida',  1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'es_es',    'Sobrescriba la dirección existente con la seleccionada',   1),
            ('once_in_every',   'Once in every',    'es_es',    'Una vez en cada',  1),
            ('overwrite_msg_part2', 'address details?', 'es_es',    '¿detalles de dirección?',  1),
            ('add_item',    'Add Item', 'es_es',    'Agregar artículo', 1),
            ('recordsave',  'Record saved successfully',    'es_es',    'Registro guardado',    1),
            ('recordnotsave',   'Could not save record. Try again later',   'es_es',    'No se guardó el regitro',  1),
            ('minutes', 'Minutes',  'es_es',    'Minutos',  1),
            ('hours',   'Hours',    'es_es',    'horas',    1),
            ('days',    'Days', 'es_es',    'Dias', 1),
            ('on',  'On',   'es_es',    'En',   1),
            ('day_of_the_month',    'day of the month', 'es_es',    'día del mes',  1),
            ('list_price',  'List Price',   'es_es',    'Precio de lista *',    1),
            ('add_record',  'Add Record',   'es_es',    'Agregar registro', 1),
            ('add_product', 'Add Product',  'es_es',    'Agregar Producto', 1),
            ('add_service', 'Add Service',  'es_es',    'Agregar servicio', 1),
            ('discountin',  'Discount in %',    'es_es',    'Descuento en%',    1),
            ('unitprice',   'Unit price',   'es_es',    'Precio unitario *',    1),
            ('netprice',    'Net price',    'es_es',    'Precio neto *',    1),
            ('comments',    'Comments', 'es_es',    'Comentarios',  1),
            ('add_close',   'Add & Close',  'es_es',    'Agregar & amp; Cerrar',    1),
            ('fetching_rout_message',   'Fetching route, Please wait…', 'es_es',    'Recogiendo ruta, por favor espere …',  1),
            ('setting', 'Settings', 'es_es',    'Ajustes',  1),
            ('utc', 'UTC',  'es_es',    'UTC',  1),
            ('in',  'In',   'es_es',    'En ',  1),
            ('days_ago',    'days ago', 'es_es',    'hace días',    1),
            ('mins_ago',    'Minutes ago',  'es_es',    'hace minutos', 1),
            ('justnow', 'Just now', 'es_es',    'Justo ahora',  1),
            ('hours_ago',   'hours ago',    'es_es',    'horas atras',  1),
            ('in_1_day',    'In 1 day', 'es_es',    'En 1 día', 1),
            ('scanqrcode',  'Asset / Card scanner', 'es_es',    'Escáner de tarjetas',  1),
            ('call_log',    'Call Log', 'es_es',    'Registro de llamadas', 1),
            ('voice_message',   'Hi',   'es_es',    'Hola', 1),
            ('voice_message1',  'What can I search for you in', 'es_es',    '¿Qué puedo buscarte en?',  1),
            ('live_tracking',   'Live Tracking',    'es_es',    'Seguimiento en vivo',  1),
            ('mailmanager', 'Mail Manager', 'es_es',    'Administrador de correo',  1),
            ('my_location', 'My location',  'es_es',    'Mi ubicación', 1),
            ('created_on',  'Created On',   'es_es',    'Creado en',    1),
            ('modified_on', 'Modified On',  'es_es',    'Modificado en',    1),
            ('enter_comments',  'Enter Comments',   'es_es',    'Agregar comentarios',  1),
            ('viewmore',    'View More',    'es_es',    'Ver más',  1),
            ('viewless',    'View Less',    'es_es',    'Ver menos',    1),
            ('gotofullform',    'Go to Full Form',  'es_es',    'Ir a formulario completo', 1),
            ('post',    'Post', 'es_es',    'Enviar',   1),
            ('url', 'URL',  'es_es',    'URL',  1),
            ('dialog_title_text_back_color',    'Select a Text Background Color',   'es_es',    'Seleccione un color de fondo de texto',    1),
            ('event_or_task',   'Add event/task',   'es_es',    'Agregar evento / tarea',   1),
            ('shortcut',    'Shortcuts',    'es_es',    'Atajos',   1),
            ('select_field',    'Select Field', 'es_es',    'Seleccionar campo',    1),
            ('share',   'Share',    'es_es',    'Compartir',    1),
            ('title_insert_link',   'Insert Link',  'es_es',    'nsertar el link',  1),
            ('addyourcommentshere', 'Add your comments here',   'es_es',    'Agregue sus comentarios aquí', 1),
            ('nocomment',   'No Comments',  'es_es',    'Sin comentarios',  1),
            ('leads',   'Leads',    'es_es',    'Prospectos',   1),
            ('true_val',    'true', 'es_es',    'Verdadero',    1),
            ('noresult',    'No Result',    'es_es',    'Sin resultados',   1),
            ('version', 'Version',  'es_es',    'Versión',  1),
            ('convert_lead',    'Convert Lead', 'es_es',    'Convertir cliente potencial',  1),
            ('app_name',    'CRMTiger', 'es_es',    'SalesHiker',   1),
            ('enter_url',   'Please Enter url', 'es_es',    'Por favor ingrese url',    1),
            ('help',    'Help', 'es_es',    'Ayuda ',   1),
            ('contact_us',  'Contact Us',   'es_es',    'Contáctenos',  1),
            ('updates', 'Updates',  'es_es',    'Actualizar',   1),
            ('logout',  'LogOut',   'es_es',    'Cerrar sesión',    1),
            ('busnies_cardscanner', 'Business Card Scanner',    'es_es',    'Escáner de tarjetas de visita',    1),
            ('sure_want_logout',    'Are you sure want to logout ?',    'es_es',    '¿Seguro que quiere cerrar sesión?',    1),
            ('logout_message',  'Logout successfully',  'es_es',    '¿Seguro que quiere cerrar sesión?',    1),
            ('all', 'All',  'es_es',    'Todos',    1),
            ('add_event',   'Add event',    'es_es',    'Añadir evento',    1),
            ('add_task',    'Add Task', 'es_es',    'Agregar tarea',    1),
            ('next',    'Next', 'es_es',    'Proximo',  1),
            ('terms_conditions',    'Terms and Conditions', 'es_es',    'Términos y condiciones',   1),
            ('login',   'Login',    'es_es',    'Iniciar sesión',   2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy',    'es_es',    'Al iniciar sesión, usted acepta nuestros Términos y condiciones Política de privacidad',   2),
            ('copyright',   'Copyright © 2019 CRMTiger Version',    'es_es',    'Copyright © 2019 CRMTiger Versión ',   2),
            ('enter_username',  'Please enter username',    'es_es',    'Ingrese el usuario',   2),
            ('enter_password',  'Please enter password',    'es_es',    'Ingrese contraseña',   2),
            ('remanberme',  'Remember Me',  'es_es',    'Recordarme',   2),
            ('forgot_password', 'Forgot password?', 'es_es',    '¿Olvidó la contraseña?',   2),
            ('privacy_policay1',    'Privacy Policy',   'es_es',    'Política de privacidad',   2),
            ('contactsupportmsg',   'Something went wrong. \n please Click here to contact support.',   'es_es',    'Algo salió mal.',  2),
            ('enter_username_password', 'Entered Username or Password is wrong',    'es_es',    'El usuario o la contraseña son incorrectos',   2),
            ('server_issue_occured',    'Server issues occurred',   'es_es',    'Ocurrieron problemas con el servidor', 2),
            ('password',    'Password', 'es_es',    'Contraseña',   3),
            ('user_name',   'Username', 'es_es',    'Nombre de usuario',    3),
            ('reset_pwd',   'Reset Password',   'es_es',    'Restablecer la contraseña',    3),
            ('forgot_password_title',   'Forgot password',  'es_es',    'Olvidó la contraseña', 3),
            ('enter_user_name', 'Enter user name',  'es_es',    'Introduzca un nombre de usuario',  3),
            ('cc',  'Cc',   'es_es',    'Cc',   4),
            ('body',    'Body', 'es_es',    'Cuerpo',   4),
            ('bcc', 'BCC',  'es_es',    'BCC',  4),
            ('dialog_title_text_color', 'Select a Text Color',  'es_es',    'Seleccione un color de texto', 4),
            ('date',    'Date', 'es_es',    'Fecha',    4),
            ('subject', 'Subject',  'es_es',    'Tema', 4),
            ('composeMail', 'Compose Mail', 'es_es',    'Redactar correo',  4),
            ('send',    'Send', 'es_es',    'Enviar',   4),
            ('select_message',  'Select message',   'es_es',    'Seleccionar mensaje',  4),
            ('title_insert_table',  'Insert Table', 'es_es',    'Insertar tabla',   4),
            ('log_file_sms',    'I agree to Share API Log to Technical team for further troubleshooting',   'es_es',    'Estoy de acuerdo en compartir el registro de la API con el equipo técnico para solución de problemas ',    5),
            ('edit_record', 'Edit Records', 'es_es',    'Editar registros', 5),
            ('select_time', 'Select Time',  'es_es',    'Seleccione tiempo',    5),
            ('edit_item',   'Edit Item',    'es_es',    'Editar elemento',  5),
            ('items_total', 'Items Total',  'es_es',    'Total de artículos',   5),
            ('number_less_then_31', 'Number should be less than 31',    'es_es',    'El número debe ser menor que 31',  5),
            ('users',   'Users',    'es_es',    'Usuarios', 5),
            ('groups',  'Groups',   'es_es',    'Los grupos',   5),
            ('txt_note_for_file',   'Note : Existing attachments(images/files) will be replaced',   'es_es',    'Nota: los archivos adjuntos existentes (imágenes / archivos) serán reemplazados',  5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime',   'es_es',    'La fecha y hora de finalización deben ser mayores que la fecha y hora de inicio',  5),
            ('until',   'Until',    'es_es',    'Hasta',    5),
            ('organizations',   'Organizations',    'es_es',    'Cuentas',  6),
            ('contacts',    'Contacts', 'es_es',    'Contactos',    6),
            ('opportunity', 'Opportunity',  'es_es',    'Oportunidad',  6),
            ('lbl_sun', 'SUN',  'es_es',    'DOM',  7),
            ('lbl_mon', 'MON',  'es_es',    'LUN',  7),
            ('lbl_tue', 'TUE',  'es_es',    'MAR',  7),
            ('lbl_wed', 'WED',  'es_es',    'MIE',  7),
            ('lbl_thu', 'THU',  'es_es',    'JUE',  7),
            ('lbl_fri', 'FRI',  'es_es',    'VIE',  7),
            ('lbl_sat', 'SAT',  'es_es',    'SAB',  7),
            ('lbl_1',   '1',    'es_es',    '1',    7),
            ('lbl_2',   '2',    'es_es',    '2',    7),
            ('lbl_3',   '3',    'es_es',    '3',    7),
            ('lbl_4',   '4',    'es_es',    '4',    7),
            ('lbl_5',   '5',    'es_es',    '5',    7),
            ('lbl_6',   '6',    'es_es',    '6',    7),
            ('lbl_7',   '7',    'es_es',    '7',    7),
            ('lbl_8',   '8',    'es_es',    '8',    7),
            ('lbl_9',   '9',    'es_es',    '9',    7),
            ('lbl_10',  '10',   'es_es',    '10',   7),
            ('lbl_11',  '11',   'es_es',    '11',   7),
            ('lbl_12',  '12',   'es_es',    '12',   7),
            ('lbl_13',  '13',   'es_es',    '13',   7),
            ('lbl_14',  '14',   'es_es',    '14',   7),
            ('lbl_15',  '15',   'es_es',    '15',   7),
            ('lbl_16',  '16',   'es_es',    '16',   7),
            ('lbl_17',  '17',   'es_es',    '17',   7),
            ('lbl_18',  '18',   'es_es',    '18',   7),
            ('lbl_19',  '19',   'es_es',    '19',   7),
            ('lbl_20',  '20',   'es_es',    '20',   7),
            ('lbl_21',  '21',   'es_es',    '21',   7),
            ('lbl_22',  '22',   'es_es',    '22',   7),
            ('lbl_23',  '23',   'es_es',    '23',   7),
            ('lbl_24',  '24',   'es_es',    '24',   7),
            ('lbl_25',  '25',   'es_es',    '25',   7),
            ('lbl_26',  '26',   'es_es',    '26',   7),
            ('lbl_27',  '27',   'es_es',    '27',   7),
            ('lbl_28',  '28',   'es_es',    '28',   7),
            ('lbl_29',  '29',   'es_es',    '29',   7),
            ('lbl_30',  '30',   'es_es',    '30',   7),
            ('lbl_31',  '31',   'es_es',    '31',   7),
            ('lbl_32',  '32',   'es_es',    '32',   7),
            ('lbl_33',  '33',   'es_es',    '33',   7),
            ('lbl_34',  '34',   'es_es',    '34',   7),
            ('lbl_35',  '35',   'es_es',    '35',   7),
            ('lbl_36',  '36',   'es_es',    '36',   7),
            ('lbl_37',  '37',   'es_es',    '37',   7),
            ('lbl_38',  '38',   'es_es',    '38',   7),
            ('lbl_39',  '39',   'es_es',    '39',   7),
            ('lbl_40',  '40',   'es_es',    '40',   7),
            ('lbl_41',  '41',   'es_es',    '41',   7),
            ('lbl_42',  '42',   'es_es',    '42',   7),
            ('current_date',    'current date', 'es_es',    'fecha actual', 7),
            ('event',   'Events',   'es_es',    'أEventos', 7),
            ('calendar',    'Calendar', 'es_es',    'Calendario',   7),
            ('latest_version',  'Latest Version :', 'es_es',    'Ultima versión : ',    8),
            ('expire_on',   'Expire On :',  'es_es',    'Vence en :',   8),
            ('ctmobile_ext_version',    'CTMobile Ext. Version :',  'es_es',    'CTMobile Ext. Versión :',  8),
            ('you_have_latest_version', 'You already have latest version',  'es_es',    'Has actualizado la versión ',  8),
            ('latest_version1', 'You Already have latest version',  'es_es',    'لYa tienes la última versióz', 8),
            ('upgreaded',   'Upgrade',  'es_es',    'Mejorar',  8),
            ('downgrade',   'Downgrade',    'es_es',    'Degradar', 8),
            ('dialog_recent_event_info',    'You can set from here how many number of records you want to show on Home screen for Recent Event.',   'es_es',    'Puede configurar desde aquí cuántos registros desea mostrar en la pantalla de inicio para el evento reciente.',    8),
            ('dialog_feedback_info',    'You can submit your feedback with description , our team will check your feedback and get back to you.',   'es_es',    'Puede enviar sus comentarios con una descripción, nuestro equipo revisará sus comentarios y se comunicará con usted.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.',    'es_es',    'La funcionalidad de registro se utiliza para soporte/ayuda al cliente. Si tiene algún problema en la aplicación o algún módulo o funcionalidad no funciona correctamente, puede habilitar compartir registro con nuestro equipo de desarrollo.',   8),
            ('info',    'Info', 'es_es',    'Información',  8),
            ('recent_history',  'Recent History',   'es_es',    'Historia reciente',    8),
            ('recent_feedback', 'Feedback', 'es_es',    'FeedSign In Failed.Trate de nuevo después',    8),
            ('recent_log',  'Log',  'es_es',    'Iniciar sesión',   8),
            ('crmtiger_app_version',    'CRMTiger App Version :',   'es_es',    'Versión de la aplicación CRMTiger:',   8),
            ('historylimit',    'Recent History Limit', 'es_es',    'Límite de historial',  8),
            ('radious_in_miles',    'Radius in miles',  'es_es',    'Radio en millas',  8),
            ('recentlimit', 'Recent Event Limit',   'es_es',    'Límite de eventos recientes',  8),
            ('upcoming_events', 'Upcoming Events',  'es_es',    'Próximos eventos', 8),
            ('rate_our_app',    'Rate Our App!',    'es_es',    'Califica nuestra aplicación!', 8),
            ('feedback',    'Submit Feedback',  'es_es',    'Enviar comentarios',   8),
            ('sendfeedback',    'Feedback Send',    'es_es',    'Enviar comentarios',   8),
            ('emaillimit',  'Email limit',  'es_es',    'Límite de correo electrónico', 8),
            ('log', 'Log',  'es_es',    'Iniciar sesión',   8),
            ('logclear',    'Log cleared successfully.',    'es_es',    'Limpieza exitosa', 8),
            ('dialog_recent_history_info',  'You can set from here how many number of records you want to show on Home screen for Recent History.', 'es_es',    'Puede establecer desde aquí la cantidad de registros que desea mostrar en la pantalla de Inicio para Historial reciente.', 8),
            ('proceed_to_upgrade1', 'Proceed to',   'es_es',    'Proceder a',   8),
            ('upgradation_message', 'will required logout and login again later.',  'es_es',    'será necesario cerrar la sesión y volver a iniciar sesión más tarde.', 8),
            ('proceed_to_upgrade',  'Proceed to Upgrade',   'es_es',    'Continuar con la actualización',   8),
            ('module_setting',  'Module Setting',   'es_es',    'Configuración del módulo', 9),
            ('sortbyfield', 'Sort by field',    'es_es',    'Ordenar por campo',    9),
            ('ascending',   'Ascending  A to Z',    'es_es',    'Ascendiendo de la A a la Z',   9),
            ('descending',  'Descending  Z to A',   'es_es',    'Z descendente a A',    9),
            ('first_field', 'First Field',  'es_es',    'Primer campo', 9),
            ('second_field',    'Second Field', 'es_es',    'Segundo campo',    9),
            ('third_field', 'Third Field',  'es_es',    'Tercer campo', 9),
            ('sure_want_restore',   'Are you sure you want to reset to default settings?',  'es_es',    '¿Estás seguro de que quieres restaurar el predeterminado', 9),
            ('orderlist',   'List Order',   'es_es',    'Orden de la lista',    9),
            ('module_reset',    'Restore to Default',   'es_es',    'Restablecen a los predeterminados',    9),
            ('display_fields',  'Display Fields',   'es_es',    'Campos de visualización',  9),
            ('discount_lessthen_100',   'Discount % should be less than 100',   'es_es',    '% El descuento debeser menor a 100',   10),
            ('select_item', 'Select Item',  'es_es',    'Seleccione un artículo',   10),
            ('item_comment',    'Item Comment', 'es_es',    'Comentario del artículo',  10),
            ('record_name', 'Record Name is :', 'es_es',    'El nombre del registro es:',   11),
            ('go_back', 'Go Back',  'es_es',    'Regresa',  11),
            ('please_enter_shortcut_name',  'Please Enter Shortcut Name',   'es_es',    'Por favor ingrese el nombre del atajo',    11),
            ('number_not_found',    'Contact Number not found', 'es_es',    'Número de contacto no encontrado', 11),
            ('mail_not_found',  'Mail Address not found',   'es_es',    'Dirección de correo no encontrada',    11),
            ('create_shortcut', 'Create Shortcut',  'es_es',    'Crear acceso directo', 11),
            ('contact_summary', 'Summary',  'es_es',    'Resumen',  11),
            ('activites',   'Activities',   'es_es',    'Actividadess', 11),
            ('details', 'Details',  'es_es',    'Detalles', 11),
            ('related', 'Related',  'es_es',    'Relacionado',  11),
            ('share_link',  'Share record with',    'es_es',    'Compartir registro con',   11),
            ('edit',    'Edit', 'es_es',    'Editar',   11),
            ('duplicate',   'Duplicate',    'es_es',    'Duplicar', 11),
            ('whatsapp',    'Whatsapp', 'es_es',    'Whatsapp', 11),
            ('call',    'Call', 'es_es',    'LLamada',  11),
            ('choose_contact_for_call', 'Choose Contact for Call',  'es_es',    'Elija contacto para llamar',   11),
            ('choose_contact_for_sms',  'Choose Contact for SMS',   'es_es',    'Elija Contacto para SMS',  11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp',  'es_es',    'Elija Contacto para WhatsApp', 11),
            ('chosse_contact_for_email',    'Choose Email', 'es_es',    'Elija Email',  11),
            ('attach_file', 'Attach Files', 'es_es',    'Adjuntar archivos',    11),
            ('close',   'Close',    'es_es',    'Cerrar',   11),
            ('status',  'Status',   'es_es',    'Estado',   11),
            ('stop',    'Stop', 'es_es',    'Detener',  11),
            ('zero',    '0',    'es_es',    'Cero', 11),
            ('record',  'Record',   'es_es',    'Grabar',   11),
            ('voice_note',  'Voice Note',   'es_es',    'Nota de Voz',  11),
            ('tickets', 'Tickets',  'es_es',    'Entradas', 12),
            ('check_out',   'Check Out',    'es_es',    'Revisa',   12),
            ('check_in',    'Check In', 'es_es',    'Registrarse',  12),
            ('select_any',  'Select any',   'es_es',    'Seleccione cualquiera',    12),
            ('fulldetails', 'Show Full Details',    'es_es',    'Mostrar detalles completos',   12),
            ('checkin', 'Check-in', 'es_es',    'Registrarse',  12),
            ('navigate',    'Navigate', 'es_es',    'Navegar',  12),
            ('product', 'Products', 'es_es',    'Productos',    12),
            ('projectMilestone',    'Project Milestone',    'es_es',    'Hito del proyecto',    12),
            ('projecttask', 'Project Tasks',    'es_es',    'Tarea de proyecto',    12),
            ('nearby',  'NearBy',   'es_es',    'Cerca',    13),
            ('document',    'Document', 'es_es',    'Documento',    14),
            ('reply',   'Reply',    'es_es',    'Respuesta',    14),
            ('reply_all',   'Reply All',    'es_es',    'Responder a todos',    14),
            ('forward', 'Forward',  'es_es',    'Adelante', 14),
            ('action',  'Action',   'es_es',    'Action',   14),
            ('select_first',    'Select First', 'es_es',    'Seleccionar primero',  14),
            ('commentaddsuccessful',    'Comment added successfull',    'es_es',    'Comentar agregar con éxito',   14),
            ('move_to', 'Move to',  'es_es',    'Mover a',  14),
            ('attach',  'Attach',   'es_es',    'Adjuntar', 14),
            ('addcoment',   'Add Comment',  'es_es',    'Agregar comentario',   14),
            ('adddocument', 'Add Document', 'es_es',    'Agregar documento',    14),
            ('home',    'Home', 'es_es',    'Inicio',   15),
            ('checkout',    'Check-out',    'es_es',    'Revisar',  15),
            ('message_search',  'Search by name',   'es_es',    'Buscar por nombre',    15),
            ('start_shift', 'Start shift',  'es_es',    'Inicio de turno',  15),
            ('end_shift',   'End shift',    'es_es',    'Fin de turno', 15),
            ('today_meeting',   'Meetings', 'es_es',    'Reuniones',    15),
            ('shift_time_track',    'Shift Time Track', 'es_es',    'Cambiar tiempo',   15),
            ('logout_msg',  'You have to login again , click',  'es_es',    'Tienes que iniciar sesión de nuevo, haz clic', 15),
            ('logout_msg1', 'to continue.', 'es_es',    'Continuar.',   15),
            ('permission_denied',   'You don\'t have permission to create', 'es_es',    'No tienes permiso para crear', 15),
            ('history', 'Activity stream',  'es_es',    'Últimas acciones', 15),
            ('search_value',    'Search value :',   'es_es',    'Enviar mensaje',   15),
            ('feed_back_msg',   'Please enter feedback message',    'es_es',    'Ingrese un mensaje de retroalimentación',  16),
            ('feed_back_hint_msg',  'Enter feedback message',   'es_es',    'Ingresar mensaje de retroalimentación',    16),
            ('submit',  'Submit',   'es_es',    'Enviar',   16),
            ('check_app_not_installed', 'Application is not currently installed.',  'es_es',    'La aplicación no está instalada actualmente.', 17),
            ('send_sms_fail_message',   'SMS failed, please try again later!',  'es_es',    'Error de SMS, por favor intente de nuevo más tarde!',  17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'es_es',    'Documento adjunto exitosamente',   17),
            ('send_message',    'Send message', 'es_es',    'Enviar mensaje',   17),
            ('sms_to',  'smsto:',   'es_es',    'smsto:',   17),
            ('add_list_message',    'Add List', 'es_es',    'Agregar lista',    18),
            ('mylist',  'My List',  'es_es',    'Mi lista', 18),
            ('filtername',  'Filter Name',  'es_es',    'Nombre del filtro',    18),
            ('selectlist',  'Select a List',    'es_es',    'Seleccione una lista *',   18),
            ('assingedto',  'Assigned To',  'es_es',    'Asignado a *', 18),
            ('selectmodule',    'Select a module',  'es_es',    'Seleccione un modulo', 18),
            ('add_list',    'Add Filter',   'es_es',    'Agregar filtro',   18),
            ('recent_event',    'Recent Event', 'es_es',    'Evento reciente',  19),
            ('recent_hostory',  'Recent History',   'es_es',    'Historial reciente',   19),
            ('module_specific_settings',    'Module-Specific Settings', 'es_es',    'Configuración específica del módulo',  19),
            ('talk_to_us',  'Talk to us',   'es_es',    'Háblanos', 19),
            ('report_a_bug',    'Report A Bug', 'es_es',    'Reportar un error',    19),
            ('faq', 'FAQ',  'es_es',    'Preguntas más frecuentes', 19),
            ('selectmodules',   'Select Module',    'es_es',    'Seleccionar módulo',   19),
            ('myplan',  'My Plan',  'es_es',    'Mi Plan',  19),
            ('message', 'Message',  'es_es',    'Mensaje',  20),
            ('message_validation',  'Please enter Message', 'es_es',    'Por favor ingrese un mensaje', 20),
            ('contact_select',  'Please Select contact',    'es_es',    'Seleccione contacto',  20),
            ('global_search',   'Global Search',    'es_es',    'Búsqueda global',  21),
            ('records', 'Records',  'es_es',    'Grabar',   21),
            ('dont_show_again', 'Don\'t Show Again',    'es_es',    'No volver a mostrar',  22),
            ('skip',    'Skip', 'es_es',    'Omitir',   22),
            ('file_downloading',    'File Downloading', 'es_es',    'Descarga de archivos', 23),
            ('add_screenshots_optional',    'Add screenshots (optional)',   'es_es',    'Añadir capturas de pantalla (opcional)ss', 24),
            ('describe_your_problem',   'Describe your problem',    'es_es',    'Describe tu problema', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut',  'es_es',    'Atajo de filtro predeterminado',   25),
            ('record_shortcut', 'Record Shortcut',  'es_es',    'enter_url',    25),
            ('enter_url',   'Please Enter url', 'es_es',    'Por favor ingrese url',    26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'es_es',    'Necesita actualizar la aplicación para continuar usando. Actualice a', 26),
            ('search_by',   'Search by',    'es_es',    'Búsqueda por', 27),
            ('selected_filter', 'Selected filter :',    'es_es',    'Filtro seleccionado: -',   27),
            ('selected_field',  'Selected field :', 'es_es',    'Campo seleccionado: -',    27),
            ('choose',  'Choose',   'es_es',    'Escoger',  28),
            ('qr_cardscanner',  'QR Code Scanner',  'es_es',    'Escáner de código QR', 28),
            ('error_message_for_scan',  'Could not read the card Try again later.', 'es_es',    'No se pudo leer la tarjeta vuelva a intentarlo más tarde.',    28),
            ('press_start_scan',    'Press to Start Scan',  'es_es',    'Presione para comenzar a escanear',    28),
            ('line_item_quntity_validation_msg',    'Value should be greater than zero',    'es_es',    'El valor debe ser mayor que cero', 29),
            ('percentage_msg',  'Percentage should be less than 100',   'es_es',    'El porcentaje debe ser inferior a 100',    29),
            ('MSG_NO_DATA', 'No data found!',   'es_es',    '¡Datos no encontrados!',   29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!',    'es_es',    '¡Algo salió mal!', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'es_es',    '¡Próximamente!',   29),
            ('MSG_UPLOAD_PROFILE_IMAGE',    'Please upload profile image.', 'es_es',    'Sube la imagen de perfil.',    29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access',  'es_es',    'Acceso a la ubicación',    29),
            ('ALERT_MSG_LOCATION_ACCESS',   'Requires your location to show nearby events.',    'es_es',    'Requiere su ubicación para mostrar eventos cercanos.', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW',    'es_es',    'PERMITIR', 29),
            ('ALERT_BTN_DENY',  'DENY', 'es_es',    'NEGAR',    29),
            ('ALERT_MSG_LOCATION_SETTING',  'Not able to fetch your current location. Please allow us to use your location to provide you certain features like, live tracking, route planning and display near by leads, contact, organization, etc. This will help you to plan your on field task as well',   'es_es',    'Not able to fetch your current location. Please allow us to use your location to provide you certain features like, live tracking, route planning and display near by leads, contact, organization, etc. This will help you to plan your on field task as well',   29),
            ('DELETE_RECORD',   'Delete Record',    'es_es',    'Eliminar el registro', 29),
            ('ALERT_MSG_DELETE_SHORTCUT',   'Are you sure want to delete this shortcut?',   'es_es',    '¿Estás seguro de que quieres eliminar este acceso directo?',   29),
            ('DELETE_SHORTCUT', 'Delete Shortcut',  'es_es',    'Eliminar acceso directo',  29),
            ('LBL_TERMS',   'By logging in, you agree to our Terms and',    'es_es',    'Al iniciar sesión, acepta nuestros Términos y',    29),
            ('LBL_CONDITIONS',  'Conditions &', 'es_es',    'Condiciones y',    29),
            ('ALERT_TITLE', 'Alert',    'es_es',    'Alerta',   29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe',    'es_es',    'Suscribir',    29),
            ('MSG_SELECT_MODULE',   'Please select any Module', 'es_es',    'Seleccione cualquier módulo',  29),
            ('MSG_SELECT_LIST', 'Please select any List',   'es_es',    'Seleccione cualquier listas',  29),
            ('ALERT_MSG_DONT_HAVE_CAMERA',  'You don\'t have camera',   'es_es',    'No tienes camara', 29),
            ('ALERT_MSG_GALLARY_PERMISSION',    'You don\'t have permission to access gallery.',    'es_es',    'No tienes permiso para acceder a la galería.', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'es_es',    'No tienes permiso para acceder a la cámara. Ir a configuración -&gt;\n            Desplácese hacia abajo y seleccione la aplicación CRMTiger -&gt; Activar cámar', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'es_es',    'No tiene permiso para acceder al reconocimiento de voz.\n            Vaya a configuración -&gt; Desplácese hacia abajo y seleccione Aplicación CRMTiger -&gt;\n            Activar el reconocimiento de voz',  29),
            ('BTN_DONE',    'Done', 'es_es',    'Listo',    29),
            ('COMMENT', 'Comment',  'es_es',    'Comentario',   29),
            ('FULL_FORM',   'Full Form',    'es_es',    'Forma completa',   29),
            ('QUICK_CREATE',    'Create',   'es_es',    'Crear',    29),
            ('LBL_SELECT_FIELDS',   'Select Fields',    'es_es',    'Seleccionar campos',   29),
            ('LBL_SELECT_FIELDS',   'Select Fields',    'es_es',    'Seleccionar campos',   29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field',   'es_es',    'Seleccionar primer campo', 29),
            ('LBL_SELECT_SECOND_FIELDS',    'Select Second Field',  'es_es',    'Seleccionar segundo campo',    29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field',   'es_es',    'Seleccionar tercer campo', 29),
            ('LBL_SORT_BY_FIELD',   'Select Sort By Field', 'es_es',    'Seleccione Ordenar por campo', 29),
            ('BTN_RESET_TO_DEFAULT',    'Reset to Default', 'es_es',    'restablecen a los predeterminados',    29),
            ('MSG_SELECT_SORT_BY_FIELD',    'Select Sort by field', 'es_es',    'Seleccione Ordenar por campo', 29),
            ('kStrClearBtnTitle',   'Clear',    'es_es',    'Claro',    29),
            ('kStrShowMoreBtnTitle',    'Show More',    'es_es',    'Mostrar más',  29),
            ('kStrAddActivitiesBtnTitle',   'Add Activities',   'es_es',    'Agregar actividades',  29),
            ('kStrAddCommentPlaceHolder',   'Add your comments here',   'es_es',    'Agrega tus comentarios aquí',  29),
            ('MSG_ENTER_TO_EMAIL',  'Please enter to field.',   'es_es',    'Ingrese al campo.',    29),
            ('WARNING_FILE',    'File can\'t open.',    'es_es',    'El archivo no se puede abrir.',    29),
            ('MSG_FILE_SAVED',  'File saved.',  'es_es',    'Archivo guardado.',    29),
            ('WARNING_DOWNLOAD_FAIL',   'Download fail!, please try after sometime.',   'es_es',    '¡Error de descarga !, inténtelo más tarde.',   29),
            ('LBL_SHORTCUT',    'Shortcut', 'es_es',    'Atajo',    29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'es_es',    'Escribir mensaje', 29),
            ('ALERT_INSTALL_WHATSAPP',  'Install Whatsapp', 'es_es',    'Instalar whatsapp',    29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox',  'es_es',    'No se encontró ningún buzón. Crear buzón', 29),
            ('LBL_WROTE',   'Wrote',    'es_es',    'Escribió', 29),
            ('MSG_MAIL_SEND',   'Mail sent',    'es_es',    'Correo enviado',   29),
            ('log_file_not_found',  'API Log file not found.',  'es_es',    'No se encontró el archivo de registro de API.',    29),
            ('unknown_error',   'An unknown error occurred, try again', 'es_es',    'Ocurrió un error desconocido, inténtalo de nuevo', 29),
            ('CTMTigerAppVersion',  'CRMTiger App Version', 'es_es',    'Versión de la aplicación CRMTiger',    29),
            ('CTMMobileUpdateMsg',  'CTMobile Ext. Version Update Successfully',    'es_es',    'CTMobile Ext. Actualización de la versión con éxito',  29),
            ('dialog_Premium_downgrade',    'Downgrade will required logout and login again later', 'es_es',    'La degradación requerirá cerrar sesión y volver a iniciar sesión más tarde',   29),
            ('dialog_Premium',  'Upgrade will required logout and login again later',   'es_es',    'La actualización requerirá cerrar sesión y volver a iniciar sesión más tarde', 29),
            ('Overwrite',   'Overwrite',    'es_es',    'Sobrescribir', 29),
            ('MSGAddressOverwrite1',    'Overwrite the existing address with the selected', 'es_es',    'Sobrescriba la dirección existente con la seleccionada',   29),
            ('MSGAddressOverwrite2',    'address details?', 'es_es',    '¿detalles de dirección?',  29),
            ('UPGRADE_PLAN',    'Upgrade Plan', 'es_es',    'Plan de actualización',    29),
            ('DOWNGRADE_PLAN',  'Downgrade Plan',   'es_es',    'Plan de degradación',  29),
            ('UPGRADE_EXTENSION',   'Upgrade Extension',    'es_es',    'Actualizar extensión', 29),
            ('UPGRADE_APP', 'Upgrade App',  'es_es',    'Actualizar aplicación',    29),
            ('SELECT_OPTION',   'Select Option',    'es_es',    'Seleccionar opción',   29),
            ('PLEASE_SELECT',   'Please select',    'es_es',    'Por favor seleccione', 29),
            ('MSG_ACCESS_DENIED',   'You don\'t have permission for this module.',  'es_es',    'No tienes permiso para este módulo',   29),
            ('MSG_SELECT_RECCURING_MONTH_DAY',  'Please select reccuring day of month.',    'es_es',    'Seleccione el día recurrente del mes.',    29),
            ('MSG_SELECT_RECCURING_WEEK_DAY',   'Please select reccuring day of week.', 'es_es',    'Seleccione el día de la semana recurrente.',   29),
            ('MSG_SELECT_RECCURING_DAYS',   'Please select reccuring days.',    'es_es',    'Seleccione días recurrentes.', 29),
            ('Please select reccuring days.',   'Please select reccuring days.',    'es_es',    'Seleccione días recurrentes.', 29),
            ('MSG_SELECT_RECCURING_END_DATE',   'Please select reccuring end date.',    'es_es',    'Seleccione la fecha de finalización recurrente.',  29),
            ('MSG_SELECT_RECCURING_TYPE',   'Please select reccuring type.',    'es_es',    'Seleccione el tipo recurrente.',   29),
            ('FREQ_TIME',   'Times',    'es_es',    'Veces ',   29),
            ('REPEAT_YEARLY',   'Repeat Yearly',    'es_es',    'Repetir anualmente',   29),
            ('REPEAT_MONTHLY',  'Repeat Monthly',   'es_es',    'Repetir mensualmente', 29),
            ('REPEAT_WEEKLY',   'Repeat Weekly',    'es_es',    'Repetir semanalmente', 29),
            ('REPEAT_DAILY',    'Repeat Daily', 'es_es',    'Repetir diariamente',  29),
            ('ACTION_TITLE',    'Action Title', 'es_es',    'Título de la acción',  29),
            ('MSG_SELECT_VALID_DATE',   'Please select valid day of month.',    'es_es',    'Seleccione un día válido del mes.',    29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'es_es',    'La fecha de inicio debe ser menor que la fecha de finalización.',  29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'es_es',    'La hora de inicio debe ser menor que la hora de finalización.',    29),
            ('LBL_LINEITEM_DETAILS',    'Lineitem Details', 'es_es',    'Detalles del elemento de línea',   29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT',    'Discount amount should be less than the total.',   'es_es',    'El monto del descuento debe ser menor que el total.',  29),
            ('VIEW',    'View', 'es_es',    'Ver',  29),
            ('MSG_ENTER_VALID', 'Please enter valid',   'es_es',    'Por favor enter válido',   29),
            ('MSG_ENTER_PERCENTAGE',    'Percentage should be less than 100.',  'es_es',    'El porcentaje debe ser inferior a 100.',   29),
            ('ITEM_TOTAL',  'Item Total',   'es_es',    'Total',    29),
            ('ADJUSTMENT',  'Adjustment',   'es_es',    'Ajustamiento', 29),
            ('TITLE_CHOOSE_IMAGE',  'Choose Image', 'es_es',    'Elegir imagen',    29),
            ('COMPRESS',    'Compress', 'es_es',    'Comprimir',    29),
            ('CHOOSE_ANOTHER_IMAGE',    'Your image size is too large, please select another image',    'es_es',    'El tamaño de su imagen es demasiado grande, seleccione otra imagen',   29),
            ('OnDayOfMonth',    'On day of month',  'es_es',    'El día del mes',   29),
            ('OnDayOfWeek', 'On day of week',   'es_es',    'El día de la semana',  29),
            ('AddAndClose', 'Add & Close',  'es_es',    'Agregar y cerrar', 29),
            ('Repeat',  'Repeat',   'es_es',    'Repetir',  29),
            ('OnDay',   'On day',   'es_es',    'En el día',    29),
            ('View_Line_Item',  'View Line Item',   'es_es',    'Ver línea de pedido',  29),
            ('TITLE_IMAGE', 'Image',    'es_es',    'Imagen',   29),
            ('TITLE_ICLOUD',    'iCloud',   'es_es',    'ICloud',   29),
            ('GOOGLE',  'Google',   'es_es',    'Google',   29),
            ('ALERT_BTN_OKAY',  'Okay', 'es_es',    'Bueno',    29),
            ('ALERT_TITLE_ACCESS_DENIED',   'Access Denied',    'es_es',    'Acceso denegado',  29),
            ('Dont_Show_Again', 'Don\'t show again',    'es_es',    'No volver a mostrar',  29),
            ('Skip',    'Skip', 'es_es',    'Omitir',   29),
            ('Fillter_Name',    'Fillter Name', 'es_es',    'Nombre del filtro',    29),
            ('Fillter_Record_Count',    'Fillter Record Count', 'es_es',    'Recuento de registros de filtro',  29),
            ('url_note',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'es_es',    'Nota: si su URL de CRM es https://example.com/crm, ingrésela en el cuadro de arriba',  31),
            ('vtiger_url',  'Your vTiger CRM URL',  'es_es',    'Su URL de vTiger CRM', 26),
            ('msg_doc_read_permission', 'You don\'t have permission to Add either This is read-only or Private Field.', 'es_es',    'No tienes permiso para agregar Esto es de solo lectura o Campo privado.',  31),
            ('CLEAR',   'Clear',    'es_es',    'Claro',    31),
            ('Files/photos uploaded successfully',  'Files/photos uploaded successfully',   'es_es',    'Archivos / fotos subidos con éxito',   32),
            ('Digital signature saved', 'Digital signature saved',  'es_es',    'Firma digital guardada',   32),
            ('Please upload Signature or Files/photos', 'Please upload Signature or Files/photos',  'es_es',    'Cargue la firma o archivos / fotos',   32),
            ('Files / Photos',  'Files / Photos',   'es_es',    'Archivos / Fotos', 32),
            ('Signature',   'Signature',    'es_es',    'Firma',    32),
            ('add_photo_using', 'Add Photo Using',  'es_es',    'Agregar foto usando',  31),
            ('btn_upload_sign', '(+) Add Signature',    'es_es',    '(+) Agregar firma',    31),
            ('btn_upload_photo_doc',    '(+) Upload Files/Photos',  'es_es',    '(+) Cargar archivos / fotos',  31),
            ('select_photo_doc_to_upload',  'Please select files/photos to upload', 'es_es',    'Seleccione archivos / fotos para cargar',  31),
            ('related_module_title',    'Search from related module and Add to \"Route\"',  'es_es',    'Buscar desde el módulo relacionado y agregar a \"Ruta\"',  30),
            ('Route status updated successfully',   'Route status updated successfully',    'es_es',    'REl estado de la ruta se actualizó correctamente', 32),
            ('Session init failed', 'Session init failed',  'es_es',    'Error al iniciar la sesión',   32),
            ('You don\'t have permission to access this resource',  'You don\'t have permission to access this resource',   'es_es',    'No tienes permiso para acceder a este recurso',    32),
            ('ctroute_realtedto cannot be empty',   'Could not get the Related To - Try again later',   'es_es',    'No se pudo obtener el relacionado con - Inténtelo de nuevo más tarde', 32),
            ('ctroute_planning cannot be empty',    'Could not get the Route Planning Record - Try again later',    'es_es',    'No se pudo obtener el registro de planificación de ruta. Vuelva a intentarlo más tarde.',  32),
            ('Something went wrong - Try again later',  'Something went wrong - Try again later',   'es_es',    'Se produjo un error. Vuelve a intentarlo más tarde.',  32),
            ('sequence updated successfully',   'sequence updated successfully',    'es_es',    'secuencia actualizada con éxito',  32),
            ('sequence cannot be empty',    'sequence cannot be empty', 'es_es',    'la secuencia no puede estar vacía',    32),
            ('Shortcut details not saved',  'Shortcut details not saved',   'es_es',    'No se guardaron los detalles del acceso directo',  32),
            ('Shortcut details saved successfully', 'Shortcut details saved successfully',  'es_es',    'Los detalles del acceso directo se guardaron correctamente',   32),
            ('Route save successfully', 'Route save successfully',  'es_es',    'Ruta guardada correctamente',  32),
            ('Record save successfully',    'Record save successfully', 'es_es',    'Grabar guardar con éxito', 32),
            ('No dependency found for picklist',    'No dependency found for picklist', 'es_es',    'No se encontró ninguna dependencia para la lista de selección',    32),
            ('No records found',    'No records found', 'es_es',    'No se encontraron registros',  32),
            ('Outgoing server is not enabled, please configure from CRM',   'Outgoing server is not enabled, please configure from CRM',    'es_es',    'El servidor saliente no está habilitado, configure desde CRM', 32),
            ('Removed Successfully',    'Removed Successfully', 'es_es',    'Eliminado con éxito',  32),
            ('Shortcut has been deleted',   'Shortcut has been deleted',    'es_es',    'Se ha eliminado el acceso directo',    32),
            ('relation of records removed successfully',    'relation of records removed successfully', 'es_es',    'relación de registros eliminados con éxito',   32),
            ('relation of records not removed', 'relation of records not removed',  'es_es',    'relación de registros no eliminados',  32),
            ('Record has been deleted successfully',    'Record has been deleted successfully', 'es_es',    'El registro se ha eliminado correctamente',    32),
            ('Time Tracking saved successfully',    'Time Tracking saved successfully', 'es_es',    'El seguimiento del tiempo se guardó correctamente',    32),
            ('Time Tracking updated successfully',  'Time Tracking updated successfully',   'es_es',    'Seguimiento de tiempo actualizado correctamente',  32),
            ('Time Tracking ended successfully',    'Time Tracking ended successfully', 'es_es',    'El seguimiento del tiempo finalizó correctamente', 32),
            ('Time Tracking started successfully',  'Time Tracking started successfully',   'es_es',    'El seguimiento del tiempo finalizó correctamente', 32),
            ('record cannot be empty',  'record cannot be empty',   'es_es',    'el registro no puede estar vacío', 32),
            ('Module is disabled',  'Module is disabled',   'es_es',    'El módulo está deshabilitado', 32),
            ('Shift ended successfully',    'Shift ended successfully', 'es_es',    'El turno terminó con éxito',   32),
            ('Shift started successfully',  'Shift started successfully',   'es_es',    'El turno comenzó con éxito',   32),
            ('relation of records added successfully',  'relation of records added successfully',   'es_es',    'relación de registros agregados con éxito',    32),
            ('Comment saved successfully',  'Comment saved successfully',   'es_es',    'Comentario no guardado',   32),
            ('Comment not saved',   'Comment not saved',    'es_es',    'Comentario no guardado',   32),
            ('Comment module is not active',    'Comment module is not active', 'es_es',    'El módulo de comentarios no está activo',  32),
            ('No Upcoming Event',   'No Upcoming Event',    'es_es',    'Ningún evento próximo',    32),
            ('No Templates found - create it from Message Templates module',    'No Templates found - create it from Message Templates module', 'es_es',    'No se encontraron plantillas: créelo desde el módulo Plantillas de mensajes',  32),
            ('No event or task for this date',  'No event or task for this date',   'es_es',    'Ningún evento o tarea para esta fecha',    32),
            ('No filters created',  'No filters created',   'es_es',    'No se crearon filtros',    32),
            ('Select at least one record to attach',    'Select at least one record to attach', 'es_es',    'Seleccione al menos un registro para adjuntar',    32),
            ('Please select one or more attachments',   'Please select one or more attachments',    'es_es',    'Seleccione uno o más archivos adjuntos',   32),
            ('No event for this month', 'No event for this month',  'es_es',    'Ningún evento para este mes',  32),
            ('No Activity found',   'No Activity found',    'es_es',    'No se encontró actividad', 32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'es_es',    'Sus comentarios son valiosos para nosotros, no pueden estar vacíos',   32),
            ('Could not send mail, Please try later',   'Could not send mail, Please try later',    'es_es',    'No se pudo enviar el correo. Inténtelo más tarde.',    32),
            ('Latest Version updated successfully', 'Latest Version updated successfully',  'es_es',    'Última versión actualizada correctamente', 32),
            ('User Location Updated Successfully',  'User Location Updated Successfully',   'es_es',    'Ubicación del usuario actualizada correctamente',  32),
            ('User Location not Updated Successfully',  'User Location not Updated Successfully',   'es_es',    'La ubicación del usuario no se actualizó correctamente',   32),
            ('SMSNotifier is not enable in CRM. Please enable it first',    'SMSNotifier is not enable in CRM. Please enable it first', 'es_es',    'SMSNotifier no está habilitado en CRM. Habilítelo primero',    32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'es_es',    'No se pudieron enviar sus comentarios. Vuelva a intentarlo más tarde.',    32),
            ('Thank you for submitting your feedback',  'Thank you for submitting your feedback',   'es_es',    'Gracias por enviar sus comentarios.',  32),
            ('Please upload User Image',    'Please upload User Image', 'es_es',    'Cargue la imagen de usuario',  32),
            ('Image Not Uploading, please try again',   'Image Not Uploading, please try again',    'es_es',    'La imagen no se está cargando, inténtelo de nuevo',    32),
            ('User Image Uploaded Successfully',    'User Image Uploaded Successfully', 'es_es',    'Imagen de usuario cargada correctamente',  32),
            ('Invalid Module name', 'Invalid Module name',  'es_es',    'Nombre de módulo no válido',   32),
            ('Records Sync Successfully',   'Records Sync Successfully',    'es_es',    'Los registros se sincronizan correctamente',   32),
            ('Values cannot be empty',  'Values cannot be empty',   'es_es',    'Los valores no pueden estar vacíos',   32),
            ('Record id is empty',  'Record id is empty',   'es_es',    'El ID de registro está vacío', 32),
            ('Logout Successfully', 'Logout Successfully',  'es_es',    'Cerrar sesión correctamente',  32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'es_es',    'Habilite el módulo CTMobile',  32),
            ('Authentication Failed',   'Username and Password do not match',   'es_es',    'Nombre de usuario y contraseña no coinciden',  32),
            ('Mismatched module information',   'Something gone wrong, please try again later', 'es_es',    'Algo salió mal. Vuelve a intentarlo más tarde.',   32),
            ('Field does not exists',   'Please set display fields again',  'es_es',    'Vuelva a configurar los campos de visualización',  32),
            ('Module does not exists',  'Module does not exists or disabled by admin',  'es_es',    'El módulo no existe o el administrador lo deshabilitó',    32),
            ('Month cannot be empty',   'Could not get the Month - Try again later',    'es_es',    'No se pudo obtener el mes. Vuelve a intentarlo más tarde.',    32),
            ('Year cannot be empty',    'Could not get the Year - Try again later', 'es_es',    'No se pudo obtener el año. Vuelve a intentarlo más tarde.',    32),
            ('Date cannot be empty',    'Could not get the Date - Try again later', 'es_es',    'No se pudo obtener la fecha. Vuelve a intentarlo más tarde.',  32),
            ('Userid cannot be empty',  'Could not get the Userid - Try again later',   'es_es',    'No se pudo obtener el ID de usuario. Vuelve a intentarlo más tarde.',  32),
            ('End Date cannot be empty',    'Could not get the status - Try again later',   'es_es',    'No se pudo obtener el estado. Vuelve a intentarlo más tarde.', 32),
            ('Start Date cannot be empty',  'Could not get the Start Date - Try again later',   'es_es',    'No se pudo obtener la fecha de inicio. Vuelve a intentarlo más tarde.',    32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'es_es',    'No configura SMS Notifier en CRM. Por favor configure,\n            Notificador de SMS en su CRM para utilizar esta función',  32),
            ('Longitude cannot be empty',   'Could not get location-Please try again',  'es_es',    'No se pudo obtener la ubicación. Vuelve a intentarlo.',    32),
            ('Latitude cannot be empty',    'Could not get location-Please try again',  'es_es',    'No se pudo obtener la ubicación. Vuelve a intentarlo.',    32),
            ('User cannot be empty',    'Could not get the User - Try again later', 'es_es',    'No se pudo obtener el usuario. Vuelva a intentarlo más tarde.',    32),
            ('Status cannot be empty',  'Could not get the status - Try again later',   'es_es',    'No se pudo obtener el estado. Vuelve a intentarlo más tarde.', 32),
            ('Required fields not found',   'Required fields not found',    'es_es',    'Campos obligatorios no encontrados',   32),
            ('Tracking module not active',  'Tracking module not active-Please contact CRM Admin',  'es_es',    'El módulo de seguimiento no está activo: póngase en contacto con el administrador de CRM', 32),
            ('Missing mandatory input values',  'Missing mandatory input values',   'es_es',    'Faltan valores de entrada obligatorios',   32),
            ('No MailBox found. Please Create Mailbox', 'No MailBox found. Please Create Mailbox',  'es_es',    'No se encontró ningún buzón. Crear buzón', 32),
            ('Mail not sent',   'Mail not sent',    'es_es',    'Correo no enviado',    32),
            ('Mail send successfully',  'Mail send successfully',   'es_es',    'Correo enviado con éxito', 32),
            ('Email Id or username not match with your record', 'Email Id or username not match with your record',  'es_es',    'La identificación de correo electrónico o el nombre de usuario no coinciden con su registro',  32),
            ('Module not specified',    'Module not specified', 'es_es',    'Módulo no especificado',   32),
            ('No messages found',   'No messages found',    'es_es',    'No se han encontrado mensajes',    32),
            ('No Dependency Found For This Module', 'No Dependency Found For This Module',  'es_es',    'No se encontraron dependencias para este módulo',  32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'es_es',    'El servidor saliente no está habilitado',  32),
            ('Outgoing server is Enabled',  'Outgoing server is Enabled',   'es_es',    'El servidor saliente está habilitado', 32),
            ('Email Attached Successfully', 'Email Attached Successfully',  'es_es',    'Correo electrónico adjunto con éxito', 32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  'es_es',    'Documentos adjuntos correctamente',    32),
            ('Login required - Please login again', 'Login required - Please login again',  'es_es',    'Se requiere inicio de sesión: inicie sesión nuevamente',   32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  'es_es',    'El módulo de seguimiento de tiempo está desactivado',  31),
            ('route_planning_module_disable',   'Route planning module is disable', 'es_es',    'El módulo de planificación de ruta está desactivado',  31),
            ('mark_as_held',    'Are you sure you want to mark Event as Held?', 'es_es',    '¿Está seguro de que desea marcar el evento como celebrado?',   31),
            ('stop_timer_msg',  'You have already started Time tracking for another record, Do you want to stop it first ?',    'es_es',    '¿Está seguro de que desea marcar el evento como celebrado?',   31),
            ('access_denied_routeplanning', 'Access denied for route planning', 'es_es',    'Acceso denegado para planificación de rutas',  31),
            ('time_spent',  'Time Spent',   'es_es',    'Tiempo usado', 31),
            ('select_user', 'Select User',  'es_es',    'Seleccionar usuario',  30),
            ('status_cannot_be_held',   'Status cannot be held for future date start',  'es_es',    'El estado no se puede retener para una fecha de inicio futura',    30),
            ('please_select_end_date',  'Please select end date',   'es_es',    'Seleccione la fecha de finalización',  30),
            ('please_select_start_date',    'Please select start date', 'es_es',    'Seleccione la fecha de inicio',    30),
            ('tap_on_plus_icon_for_select_route',   'Tap on + icon to select record for your route.',   'es_es',    'Toque el icono + para seleccionar el registro de su ruta.',    30),
            ('please_enter_notes',  'Please enter notes',   'es_es',    'Por favor ingrese notas',  30),
            ('please_enter_title',  'Please enter title',   'es_es',    'Ingrese el título',    30),
            ('please_select_date',  'Please Select Date',   'es_es',    'Seleccione la fecha',  30),
            ('search_by_date',  'Search by Date',   'es_es',    'Buscar por fecha', 30),
            ('shortcut_not_setup_yet',  'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  'es_es',    '¡El acceso directo de Opps aún no está configurado! Agregue un acceso directo haciendo clic en [icono] en los resultados de búsqueda de registros o ver la pantalla de registros.',    30),
            ('max_upload_size', 'max file Upload exceeds',  'es_es',    'La carga máxima de archivos supera',   30),
            ('unselect_all',    'UnSelect All', 'es_es',    'Deselecciona todo',    30),
            ('select_all',  'Select All',   'es_es',    'Seleccionar todo', 30),
            ('please_select_records',   'Please select records',    'es_es',    'Seleccione registros', 30),
            ('select_date', 'Select Date',  'es_es',    'Seleccione fecha', 30),
            ('quantity_in_stock_is',    'Quantity in stock is', 'es_es',    'La cantidad en stock es',  30),
            ('replies', 'Replies',  'es_es',    'Respuestas',   30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'es_es',    'La conversión requiere la selección de Contacto u Organización',   30),
            ('please_select_product',   'Please Select Product',    'es_es',    'Seleccione el producto',   30),
            ('timer_msg',   'You can start timer for single task only at same time',    'es_es',    'Puede iniciar el temporizador para una sola tarea solo al mismo tiempo',   31),
            ('save_start_tracking', 'Save & Start Tracking',    'es_es',    'Guardar e iniciar seguimiento',    31),
            ('lbl_notes',   'Notes',    'es_es',    'Notas',    31),
            ('enter_title', 'Enter Title',  'es_es',    'Ingrese el título',    31),
            ('select_module_record',    'Select Module / Record',   'es_es',    'Seleccionar módulo / registro',    31),
            ('lbl_tomorrow',    'Tomorrow', 'es_es',    'Mañana',   30),
            ('lbl_yesterday',   'Yesterday',    'es_es',    'Ayer', 30),
            ('lbl_today',   'Today',    'es_es',    'Hoy',  30),
            ('time_tracker',    'Time Tracker', 'es_es',    'Rastreador de tiempo', 31),
            ('time_end',    'End Time', 'es_es',    'Fecha final',  5),
            ('due_date',    'End Date', 'es_es',    'Hora final',   5),
            ('time_start',  'Time Start',   'es_es',    'Hora de inicio',   5),
            ('date_start',  'Start Date',   'es_es',    'Fecha de inicio',  5),
            ('delete_widget_msg',   'Display widget again by using (+) option', 'es_es',    'Mostrar el widget nuevamente usando la opción (+)',    15),
            ('no_upcoming_activities',  'No scheduled activities      ',    'es_es',    'No hay actividades programadas',   15),
            ('check_in_first',  'Please check-in first',    'es_es',    'Regístrese primero',   30),
            ('duration',    'Duration', 'es_es',    'Duracion', 30),
            ('distance',    'Distance', 'es_es',    'Distancia',    30),
            ('proper_address_message',  'Please enter proper address in record\n',  'es_es',    'Ingrese la dirección correcta en el registro', 30),
            ('select_status',   'Select Status',    'es_es',    'Seleccionar estado',   30),
            ('route_planner',   'Route Planner',    'es_es',    'Planeador de ruta',    30),
            ('route_planning',  'Route Planning',   'es_es',    'Planificacion de la ruta', 30),
            ('add_route',   'Add Route',    'es_es',    'Agregar ruta', 30),
            ('calender_disabled',   'Calendar Module is disabled',  'es_es',    'El módulo de calendario está desactivado', 30),
            ('close_dialog',    'Close form',   'es_es',    'Cerrar formulario',    30),
            ('cancel_form_message', 'Are You sure want to close ?', 'es_es',    '¿Estás seguro de que quieres cerrar?', 30),
            ('create_route',    'Create Route', 'es_es',    'Crear ruta',   30),
            ('select_module_create_route',  'Select Module to create Route',    'es_es',    'Seleccione el módulo para crear la ruta',  30),
            ('cancel',  'Cancel',   'es_es',    'Cancelar', 30),
            ('assign_route',    'Assign Route', 'es_es',    'Asignar ruta', 30),
            ('route_for',   'Route for',    'es_es',    'Crear ruta',   30),
            ('assigned_to', 'Assigned To',  'es_es',    'Asignado a',   30),
            ('enter_route_name',    'Enter Route Name', 'es_es',    'Ingrese el nombre de la ruta', 30),
            ('list',    'List', 'es_es',    'Lista',    30),
            ('map', 'Map',  'es_es',    'Mapa', 30),
            ('other_modules',   'Other Modules',    'es_es',    'Otros módulos',    15),
            ('shortcut_no_record_msg',  'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 'es_es',    'Acceso directo de Opps no configurado¡¡¡todavía!!! Agregue un acceso directo haciendo clic en el icono + del registro resultados de búsqueda o ver la pantalla de registro.',  25),
            ('clear',   'Clear',    'es_es',    'Limpiar',  25),
            ('open',    'Open', 'es_es',    'Abrir',    11),
            ('max_file_msg',    'Too many files selected (max:6)',  'es_es',    'Demasiados archivos seleccionados (máximo: 6)',    11),
            ('error_voicenote_record',  'Unable to recording voice while another application is recording sound.',  'es_es',    'No se puede grabar voz mientras otra aplicación está grabando sonido.',    11),
            ('msg_warning', 'Warning!', 'es_es',    '¡Advertencia!',    11),
            ('Permision_denied_contact',    'Permission denied to access your contacts',    'es_es',    'Permiso denegado para acceder a sus contactos',    15),
            ('no_widget_added', 'Please click + icon to add new widget to your dashboard.', 'es_es',    'Haga clic en el icono + para agregar un nuevo widget a su panel.', 15),
            ('no_data_available',   'Data not available, please check the selected fields', 'es_es',    'Datos no disponibles, consulte los campos seleccionados',  15),
            ('check_out_successfully',  'Check out successfully',   'es_es',    'Echa un vistazo con éxito',    11),
            ('check_in_successfully',   'Check in successfully',    'es_es',    'Registrarse con éxito',    11),
            ('check_out',   'Check out',    'es_es',    'Revisa',   11),
            ('check_in',    'Check in', 'es_es',    'Registrarse',  11),
            ('navigate',    'Navigate', 'es_es',    'Navegar',  11),
            ('save_to_phone_vcard_success', 'VCard Saved to phone successfully',    'es_es',    'VCard guardada en el teléfono correctamente',  15),
            ('download_vcard_success',  'VCard downloaded successfully',    'es_es',    'VCard descargado con éxito',   15),
            ('card_details',    'Card Details', 'es_es',    'Detalles de tarjeta',  15),
            ('add_widget',  'Add Widget',   'es_es',    'Agregar widget',   15),
            ('delete_widget',   'Are you sure to hide widget?', 'es_es',    '¿Estás seguro de ocultar el widget?',  15),
            ('already_widgets_added',   'All types of Widget & reports are already added',  'es_es',    'Todos los tipos de widgets e informes ya están agregados', 15),
            ('retry',   'Retry',    'es_es',    'reintentar',   28),
            ('retake',  'Retake',   'es_es',    'Volver a tomar',   28),
            ('Reports', 'Reports',  'es_es',    'Reportes', 15),
            ('Widgets', 'Widgets',  'es_es',    'widgets',  15),
            ('vcard_config',    'Vcard Configuration',  'es_es',    'Configuración de Vcard',   8),
            ('save_to_phone',   'Save to phone',    'es_es',    'Guardar en el teléfono',   11),
            ('download_vcard',  'Download Vcard',   'es_es',    'Descarga Vcard',   11),
            ('share_vcard', 'Share Vcard',  'es_es',    'Compartir Vcard',  11),
            ('share_record',    'Share Record', 'es_es',    'Compartir registro',   11),
            ('permission_denied_edit',  'You don\'t have permission to edit this record.',  'es_es',    'No tienes permiso para editar este registro.', 27),
            ('permission_denied_delete',    'You don\'t have permission to delete this record.',    'es_es',    'No tienes permiso para borrar este registro.', 27),
            ('Voice_Recording_Started', 'Recording Started',    'es_es',    'Grabación iniciada',   12),
            ('Voice_Recording_Stopped', 'Recording Stopped',    'es_es',    'Grabación detenida',   12),
            ('SEARCH',  'Search',   'es_es',    'Buscar',   7),
            ('LAST',    'Last', 'es_es',    'Ultimo',   7),
            ('FIRST',   'First',    'es_es',    'Primero',  7),
            ('MONDAY',  'Monday',   'es_es',    'Lunes',    7),
            ('TUESDAY', 'Tuesday',  'es_es',    'Marte',    7),
            ('WEDNESDAY',   'Wednesday',    'es_es',    'Miercoles',    7),
            ('THURSDAY',    'Thursday', 'es_es',    'Jueves',   7),
            ('FRIDAY',  'Friday',   'es_es',    'Vierne',   7),
            ('SATURDAY',    'Saturday', 'es_es',    'Sabado',   7),
            ('SUNDAY',  'Sunday',   'es_es',    'domingo',  7),
            ('DAILY',   'Daily',    'es_es',    'Diario',   7),
            ('WEEKLY',  'Weekly',   'es_es',    'Semanal',  7),
            ('MONTHLY', 'Monthly',  'es_es',    'Mensual',  7),
            ('YEARLY',  'Yearly',   'es_es',    'Anual',    7),
            ('asset_tracking',  'Asset tracking',   'es_es',    'Seguimiento de activos',   15),
            ('open_file',   'Open File',    'es_es',    'Abrir documento',  1),
            ('download_pdf_successfully',   'Download PDF Successfully',    'es_es',    'Descargar PDF exitosamente',   1),
            ('select_pdf',  'Select PDF',   'es_es',    'Seleccione PDF',   1),
            ('email_pdf',   'Email PDF',    'es_es',    'Enviar PDF por correo electrónico',    1),
            ('download_pdf',    'Download PDF', 'es_es',    'Descargar PDF',    1),
            ('edit_route',  'Edit Route',   'es_es',    'Editar ruta',  1),
            ('save_route',  'Save Route',   'es_es',    'Guardar ruta', 1),
            ('clear_all',   'Clear All',    'es_es',    'Limpiar todo', 1),
            ('notification',    'Notifications',    'es_es',    'Notificaciones',   1),
            ('menu_management', 'Menu Management',  'es_es',    'Gestión de menú',  1),
            ('select_menu', 'Select Menu',  'es_es',    'Seleccione el menú',   1),
            ('module_record_not_found', 'Module and Record not found',  'es_es',    'Módulo y registro no encontrados', 1),
            ('reason_for_changing_comments',    'Reason for changing comments', 'es_es',    'Razón para cambiar los comentarios.',  1),
            ('edit_reason', 'Edit Reason',  'es_es',    'Editar motivo',    1),
            ('create_filters',  'Create Filter',    'es_es',    'Crear filtro', 1),
            ('you_checked', 'You Checked',  'es_es',    'Lo comprobaste',   1),
            ('you_un_checked',  'You UnChecked',    'es_es',    'Usted desmarcado', 1),
            ('log_the_call',    'Log the call ?',   'es_es',    '¿Registrar la llamada?',   1),
            ('add_a_description_(optional)',    'Add a description (optional)', 'es_es',    'Añade una descripción (opcional)', 1),
            ('called',  'Called',   'es_es',    'Llamada',  1),
            ('call_log',    'Call Log', 'es_es',    'Registro de llamadas', 1),
            ('subject', 'Subject',  'es_es',    'Sujeta',   1),
            ('add_condition',   'Add Condition',    'es_es',    'Agregar condición',    1),
            ('select_condition',    'Select Condition', 'es_es',    'Seleccionar condición',    1),
            ('select_field',    'Select Field', 'es_es',    'Seleccionar campo',    1),
            ('please_select_first_field',   'Please First Select field',    'es_es',    'Por favor seleccione primero el campo',    1),
            ('filter_name', 'Filter Name',  'es_es',    'Nombre del filtro',    1),
            ('enter_filter_name',   'Enter filter name',    'es_es',    'Introduzca el nombre del filtro',  1),
            ('choose_conditions',   'Choose Conditions',    'es_es',    'Elige Condiciones',    1),
            ('all_condition',   'All Conditions(All conditions must be met)',   'es_es',    'Todas las condiciones (Se deben cumplir todas las condiciones)',   1),
            ('any_condition',   'Any Conditions(At least one the conditions must be met)',  'es_es',    'Cualquier condición (se debe cumplir al menos una de las condiciones)',    1),
            ('lattitude',   'latitude', 'es_es',    'latitud',  1),
            ('notification_settings',   'Notification Settings',    'es_es',    'Configuración de las notificaciones',  1),
            ('notification_management', 'Notification Management',  'es_es',    'Gestión de notificaciones',    1),
            ('addyourcommentshere', 'Type @ to mention user',   'es_es',    'Escribe @ para mencionar a la usuaria',    1),
            ('google_api_key_missing',  'Google Api key is missing.',   'es_es',    'Falta la clave API de Google.',    1),
            ('event_filter_by', 'Event Filter by',  'es_es',    'Filtrar evento por',   1),
            ('apply',   'Apply',    'es_es',    'Aplicar',  1),
            ('choose_from_gallery', 'Choose From Gallery',  'es_es',    'Elegir de la galería', 1),
            ('choose_from_camera',  'Choose From Camera',   'es_es',    'Elija entre cámara',   1),
            ('mutli_select_CB', 'Mutli Select CB',  'es_es',    'CB de selección múltiple', 1),
            ('please_select_condition', 'Please Select Condition',  'es_es',    'Por favor seleccione condición',   1),
            ('please_enter_value_or_field', 'Please Enter Value or Field',  'es_es',    'Por favor ingrese valor o campo',  1),
            ('set_as_default',  'Set as Default',   'es_es',    'Establecer por defecto',   1),
            ('list_in_metrics', 'List in Metrics',  'es_es',    'Listar en Métricas',   1),
            ('order_number',    'Order Number', 'es_es',    'Número de orden',  1),
            ('recording_saved_message', 'Recording saved successfully.',    'es_es',    'Grabación guardada exitosamente.', 1),
            ('recording_file',  'Recording File',   'es_es',    'Archivo de grabación', 1),
            ('file_not_found',  'File not found',   'es_es',    'Archivo no encontrado',    1),
            ('please_enter_valid_path', 'Please enter valid path',  'es_es',    'Por favor ingresa una ruta válida',    1),
            ('enter_path_here', 'Enter path here...',   'es_es',    'Introduzca la ruta aquí...',   1),
            ('set_call_recording_path', 'Set Call Recording Path',  'es_es',    'Establecer ruta de grabación de llamadas', 1),
            ('set_call_recording_path_here',    'Set call recording path here', 'es_es',    'Configure la ruta de grabación de llamadas aquí',  1),
            ('call_recording_path', 'Call Recording Path',  'es_es',    'Ruta de grabación de llamadas',    1),
            ('please_place_api',    'Please enable place api',  'es_es',    'Por favor, habilite la API del lugar.',    1),
            ('event_filters_by',    'Event Filters by', 'es_es',    'Filtros de eventos por',   1),
            ('select_at_least_one_option',  'Please select at least one option',    'es_es',    'Por favor seleccione al menos una opción', 1),
            ('enable_call_feature', 'Please enable call feature',   'es_es',    'Por favor habilite la función de llamada', 1),
            ('enable_email_feature',    'Please enable email feature',  'es_es',    'Por favor habilite la función de correo electrónico',  1),
            ('demo_login',  'Demo Login',   'es_es',    'Iniciar sesión de demostración',   1),
            ('select_email_template',   'Select Email Template',    'es_es',    'Seleccionar plantilla de correo electrónico',  1),
            ('template_name',   'Template Name',    'es_es',    'Nombre de la plantilla',   1),
            ('example_storage_path',    'example : storage/Music/Recordings/Call Recordings',   'es_es',    'ejemplo: almacenamiento/Música/Grabaciones/Grabaciones de llamadas',   1),
            ('User Notification Settings saved successfully',   'User Notification Settings saved successfully',    'es_es',    'La configuración de notificaciones de usuario se guardó correctamente',    33),
            ('This Notification has been disabled by admin',    'This Notification has been disabled by admin', 'es_es',    'Esta notificación ha sido deshabilitada por el administrador.',    33),
            ('Notify when any updates to the record you\'re following', 'Notify when any updates to the record you\'re following',  'es_es',    'Notificar cuando haya actualizaciones en el registro que estás siguiendo.',    33),
            ('Task assigned to you',    'Task assigned to you', 'es_es',    'Tarea asignada a ti',  33),
            ('Task Reminder',   'Task Reminder',    'es_es',    'Recordatorio de tarea',    33),
            ('You were mentioned in comments',  'You were mentioned in comments',   'es_es',    'Fuiste mencionado en los comentarios.',    33),
            ('Comments has been added to record assigned to you',   'Comments has been added to record assigned to you',    'es_es',    'Se agregaron comentarios al registro que se le asignó',    33),
            ('When Record Assigned',    'When Record Assigned', 'es_es',    'Cuando se asigna el registro', 33),
            ('Event Reminder',  'Event Reminder',   'es_es',    'Recordatorio de evento',   33),
            ('Event Invitation',    'Event Invitation', 'es_es',    'Invitación al evento', 33),
            ('Follow record',   'Follow record',    'es_es',    'Seguir registro',  33),
            ('Task',    'Task', 'es_es',    'Tarea',    33),
            ('Conversions', 'Conversions',  'es_es',    'Conversiones', 33),
            ('Events',  'Events',   'es_es',    'Eventos',  33),
            ('no_records_changed_filter_message',   'No record(s) found Please click on filter icon to change filter',  'es_es',    'No se encontraron registros. Haga clic en el icono de filtro para cambiar el filtro.', 1),
            ('title',   'Title',    'es_es',    'Título',   1),
            ('dialog_recent_call_info', 'Click + to select your mobile call recording folder where your recorded call files are stored.',   'es_es',    'Haga clic en + para seleccionar la carpeta de grabación de llamadas de su móvil donde se almacenan los archivos de llamadas grabadas.',    1),
            ('call_recording',  'Call recording',   'es_es',    'Grabacion de llamada', 1),
            ('voice_recorder',  'Voice Recorder',   'es_es',    'Grabadora de voz', 1),
            ('no_address_reference_found',  'No Address Reference found',   'es_es',    'No se encontró ninguna referencia de dirección',   32),
            ('no_overdue_activities',   'No OverDue Activities',    'es_es',    'Sin actividades atrasadas',    32),
            ('latitude_longitude_validation_message',   'Please enter proper address from this address we are not getting proper latitude and longitude',   'es_es',    'Ingrese la dirección correcta de esta dirección. No obtenemos la latitud y longitud adecuadas.',   32),
            ('Default_Search_Field',    'Default search field', 'es_es',    'Campo de búsqueda predeterminado', 32),
            ('Calender_Reminder_Message',   'Free user can\'t send local reminder', 'es_es',    'La usuaria gratuita no puede enviar recordatorio local.',  32),
            ('you_must_have_permission',    'You must give permissions to use this features.',  'es_es',    'Debe otorgar permisos para utilizar estas funciones.', 32),
            ('internal_comment',    'Internal Comment', 'es_es',    'Comentario interno',   1),
            ('unlink_record',   'Unlink Record',    'es_es',    'Desvincular registro', 11),
            ('unlink_record_msg',   'Are you sure want to unlink record?',  'es_es',    '¿Estás segura de que quieres desvincular el registro?',    11),
            ('file_format_not_support', 'File format not supported',    'es_es',    'Formato de archivo no soportado',  11),
            ('file_upload', 'File Upload',  'es_es',    'Subir archivo',    5),
            ('to_vtiger',   'To Vtiger',    'es_es',    'A Vtiger', 5),
            ('link_external_document',  'Link External Document',   'es_es',    'Vincular documento externo',   5),
            ('from_file_url',   'From File Url',    'es_es',    'Desde la URL del archivo', 5),
            ('create_new_document', 'Create New Document',  'es_es',    'Crear nuevo documento',    5),
            ('select_document_type',    'Select Document type', 'es_es',    'Seleccionar tipo de documento',    5),
            ('add_signature',   'Please add signature', 'es_es',    'Por favor agregue firma',  11),
            ('date_greater_then_equal', 'should be greater than or equal to',   'es_es',    'debe ser mayor o igual a', 1),
            ('date_less_then_equal',    'should be less than or equal to',  'es_es',    'debe ser menor o igual a', 1),
            ('Click_on_plus_for_add',   'Please tap on  +  to create a new record.',    'es_es',    'Toque + para crear un nuevo registro.',    15),
            ('display_map', 'Display map',  'es_es',    'Mostrar mapa', 15),
            ('other_settings',  'Other settings',   'es_es',    'Otros ajustes',    15),
            ('total_hours', 'Total hours',  'es_es',    'Horas totales',    15),
            ('widget_not_found',    'No widgets found', 'es_es',    'No se encontraron widgets',    15),
            ('quickaction', 'Quick action', 'es_es',    'Acción rapida',    15),
            ('dashboard',   'Dashboard',    'es_es',    'Panel',    15),
            ('new', 'New',  'es_es',    'Nueva',    15),
            ('global_search_hint',  'Please try to search using search box at top', 'es_es',    'Intente buscar usando el cuadro de búsqueda en la parte superior.',    15),
            ('near_by_map', 'Near By Map',  'es_es',    'Cerca del mapa',   15),
            ('miles',   'Miles',    'es_es',    'Millas',   15),
            ('lbl_filters', 'Filters',  'es_es',    'Filtros',  27),
            ('warning', 'Warning',  'es_es',    'Advertencia',  27),
            ('no_filter_created',   'No filter is created.',    'es_es',    'No se crea ningún filtro.',    27),
            ('please_create_new_ilter', 'Please create a new filter',   'es_es',    'Por favor crea un nuevo filtro',   27),
            ('select_search_fields',    'Select fields for the search record.', 'es_es',    'Seleccione campos para el registro de búsqueda.',  27),
            ('apply_fliters',   'Apply filters',    'es_es',    'Aplicar filtros',  27),
            ('sort_by', 'Sort by',  'es_es',    'Ordenar por',  27),
            ('sort_order',  'Sort order',   'es_es',    'Orden de clasificación',   27),
            ('Start_time_tracking', 'Start time tracking',  'es_es',    'Seguimiento de la hora de inicio', 31),
            ('Stop_time_tracking',  'Stop time tracking',   'es_es',    'Detener el seguimiento del tiempo',    31),
            ('image_preview',   'Image preview',    'es_es',    'Vista previa de la imagen',    11),
            ('phone_number',    'Phone number', 'es_es',    'Número de teléfono',   11),
            ('email_address',   'Email address',    'es_es',    'Dirección de correo electrónico',  11),
            ('edit_your_preferences',   'Edit your preferences',    'es_es',    'Edita tus preferencias',   8),
            ('about_app',   'About app',    'es_es',    'Acerca de la aplicación',  8),
            ('updated_ctmobile_ext_version',    'You already have latest CTMobile Ext. Version',    'es_es',    'Ya tienes la última extensión CTMobile. Versión',  8),
            ('updated_app_version', 'You already have latest CRMTiger App Version', 'es_es',    'Ya tienes la última versión de la aplicación CRMTiger',    8),
            ('plan',    'Plan', 'es_es',    'Plan', 8),
            ('time',    'Time', 'es_es',    'Tiempo',   31),
            ('error_log_msg',   'Oops, something went wrong! Please click on Share Button to share error log with our technical team',  'es_es',    '¡Huy! Algo salió mal! Haga clic en el botón Compartir para compartir el registro de errores con nuestro equipo técnico.',  1),
            ('add_to_quick_action', 'Add to quick action',  'es_es',    'Añadir a acción rápida',   1),
            ('add_filter_to_quick_action',  'Add filter to quick action',   'es_es',    'Agregar filtro a la acción rápida',    1),
            ('create_record',   'Create Record',    'es_es',    'Crear registro',   1),
            ('quick_action_hint',   'You can Add Quick Action here',    'es_es',    'Puedes agregar una acción rápida aquí',    1),
            ('str_send',    'Send', 'es_es',    'Enviar',   3),
            ('tax_region_msg',  'Do you want to update tax & charge values corresponding to selected region?',  'es_es',    '¿Quiere actualizar los valores de impuestos y cargos correspondientes a la región seleccionada?',  1),
            ('delete_quick_action_widgest', 'Delete Widget?',   'es_es',    '¿Eliminar widget?',    15),
            ('add_record_to_dashboard', 'Add record to dashboard',  'es_es',    'Agregar registro al panel',    15),
            ('module_quick_action_msg', 'Module added to dashboard',    'es_es',    'Módulo agregado al tablero',   15),
            ('filter_quick_action_msg', 'Filter added to dashboard',    'es_es',    'Filtro agregado al panel', 15),
            ('record_quick_action_msg', 'Record added to dashboard',    'es_es',    'Registro agregado al tablero', 15),
            ('filter_shortcut_quick_action_msg',    'Filter shortcut added to dashboard',   'es_es',    'Acceso directo al filtro agregado al panel',   15),
            ('record_shortcut_quick_action_msg',    'Record shortcut added to dashboard',   'es_es',    'Acceso directo a registros agregado al panel', 15),
            ('documents_disabled',  'Documents Module is disabled', 'es_es',    'El módulo de documentos está deshabilitado',   1),
            ('document_dont_attachment',    'Document does not have a attachment',  'es_es',    'El documento no tiene adjunto',    1),
            ('go_to_neat_by',   'Go to NearBy', 'es_es',    'Ir a NearBy',  15),
            ('go_to_time_tracking', 'Go to Time Tracker',   'es_es',    'Ir al rastreador de tiempo',   13),
            ('nearby_quick_action_msg', 'NearBy added to dashboard',    'es_es',    'NearBy agregado al tablero',   15),
            ('time_tracking_quick_action_msg',  'Time Tracking added to dashboard', 'es_es',    'Seguimiento del tiempo agregado al panel', 15),
            ('attendance_quick_action_msg', 'Attendance added to dashboard',    'es_es',    'Asistencia agregada al panel', 15),
            ('attachment',  'Attachment',   'es_es',    'Adjunto',  15),
            ('search_by_fields',    'Search by fields', 'es_es',    'Buscar por campos',    27),
            ('apply_selected',  'Apply selected',   'es_es',    'Aplicar seleccionado', 27),
            ('auto_address_disabled',   'auto address finder is disabled, please enable it from CRMTiger Settings', 'es_es',    'El buscador automático de direcciones está deshabilitado, habilítelo desde la configuración de CRMTiger',  1),
            ('Attendance',  'Attendance',   'es_es',    'Asistencia',   15),
            ('Check-in successfully',   'Check-in successfully',    'es_es',    'Registro exitoso', 32),
            ('Check-out successfully',  'Check-out successfully',   'es_es',    'Realizar el pago con éxito',   32),
            ('Nothing around here', 'Nothing around here',  'es_es',    'Nada por aquí',    13),
            ('select_days', 'Select Days',  'es_es',    'Seleccionar días', 5),
            ('select_minutes',  'Select Minutes',   'es_es',    'Seleccionar Minutos',  5),
            ('select_hours',    'Select Hours', 'es_es',    'Seleccionar horas',    5),
            ('no_lat_long_found',   'Location information (Latitude,Longitude) not found',  'es_es',    'Información de ubicación (latitud, longitud) no encontrada',   32),
            ('Call Log save successfully',  'Call Log save successfully',   'es_es',    'Registro de llamadas guardado correctamente',  32),
            ('Files/photos deleted successfully',   'Files/photos deleted successfully',    'es_es',    'Archivos/fotos eliminados correctamente',  32),
            ('important',   'Important',    'es_es',    'Importante',   34),
            ('template',    'Template', 'es_es',    'Plantilla',    34),
            ('copy',    'Copy', 'es_es',    'Copiar',   34),
            ('camera',  'Camera',   'es_es',    'Cámara',   34),
            ('gallery', 'Gallery',  'es_es',    'Galería',  34),
            ('audio',   'Audio',    'es_es',    'Audio',    34),
            ('last_seen_at',    'Last seen at', 'es_es',    'Visto por última vez en',  34),
            ('type_a_message',  'Type a message',   'es_es',    'Escribe un mensaje',   34),
            ('all_messages',    'All messages', 'es_es',    'Todos los mensajes',   34),
            ('time_tracking_reports',   'Time tracking reports',    'es_es',    'Informes de seguimiento del tiempo',   31),
            ('attendance_reports',  'Attendance reports',   'es_es',    'Informes de asistencia',   31),
            ('chats',   'Chats',    'es_es',    'Charlas',  34),
            ('Marked chat as Important',    'Marked chat as Important', 'es_es',    'El chat se marcó como importante', 34),
            ('Unmarked chat as Important',  'Unmarked chat as Important',   'es_es',    'Chat sin marcar como importante',  34),
            ('mark_as_important',   'Mark as important',    'es_es',    'Marcar como importante',   34),
            ('unmark_As_important', 'Unmark as important',  'es_es',    'Desmarcar como importante',    34),
            ('select_template', 'Select template',  'es_es',    'Seleccionar plantilla',    34),
            ('chat',    'Chat', 'es_es',    'Charlar',  34),
            ('search_by_name_or_contact',   'Search by name or contact',    'es_es',    'Buscar por nombre o contacto', 34),
            ('choose_contact_for_whatsApp', 'Choose contact for whatsApp',  'es_es',    'Elige contacto para WhatsApp', 34),
            ('whatsapp_template',   'Whatsapp template',    'es_es',    'Plantilla WhatsApp',   34),
            ('send_voice_recording',    'Send voice recording', 'es_es',    'Enviar grabación de voz',  34),
            ('slide_to_cancel', 'Slide To Cancel',  'es_es',    'Deslizar para cancelar',   34),
            ('whatsapp_disconnect_messsage',    'Ooops.. You\'re disconnected from WhatsApp. Please Scan QR Code from the CRM.',    'es_es',    'Vaya... Te han desconectado de WhatsApp... ¡Escanea el código QR nuevamente y mantén tu teléfono conectado a Internet!',   34),
            ('select_priority', 'Select priority',  'es_es',    'Seleccionar prioridad',    30),
            ('repeat_route',    'Repeat route', 'es_es',    'Repetir ruta', 30),
            ('change_assign_to',    'Change assigned to',   'es_es',    'Cambio asignado a',    30),
            ('Multiple Route created successfully', 'Multiple Route created successfully',  'es_es',    'Ruta múltiple creada con éxito',   30),
            ('Route duplicated successfully',   'Route duplicated successfully',    'es_es',    'Ruta duplicada exitosamente',  30);",array());
        }
        
    }

    static function it_it(){
        global $adb;
        $checkLang = $adb->pquery("SELECT 1 FROM ctmobile_language_keyword WHERE keyword_lang = ?",array('it_it'));
        if($adb->num_rows($checkLang) == 0){

        $adb->pquery("INSERT INTO `ctmobile_language_keyword` ( `keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
        ('network_error',   'Network connection error!',    'it_it',    'Errore di rete!',  1),
        ('connection_check',    'Could not connect to CRM, Please check your Internet connection.', 'it_it',    'Per favore controlla la tua connessione Internet.',    1),
        ('update',  'Update',   'it_it',    'Aggiornare',   1),
        ('cancel',  'Cancel',   'it_it',    'Cancella', 1),
        ('ok',  'Ok',   'it_it',    'ok',   1),
        ('more_information',    'Click here for more information.', 'it_it',    'Clicca qui per maggiori informazioni.',    1),
        ('yes', 'Yes',  'it_it',    'sì',   1),
        ('no',  'No',   'it_it',    'No',   1),
        ('click_again_exit',    'Click again to exit',  'it_it',    'Clicca di nuovo per uscire',   1),
        ('forpermission',   'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.',   'it_it',    'Non hai il permesso di vedere questa funzione. Si prega di iscriversi per la versione Premium Clicca qui per iscriverti.', 1),
        ('clickhere',   'Click here',   'it_it',    'Clicca qui',   1),
        ('clickhere_subscribe', 'Click here to subscribe premium version',  'it_it',    'Clicca qui per iscriverti',    1),
        ('clickhere_configure', 'Click here and view how to Configure.',    'it_it',    'Clicca qui e vedi come configurare.',  1),
        ('please_wait', 'Please Wait…', 'it_it',    'Attendere prego…', 1),
        ('share__msg',  'Share file with',  'it_it',    'condividi file con',   1),
        ('dialog_camera',   'Camera',   'it_it',    'telecamera',   1),
        ('dialog_add_file_by',  'Take Photo from',  'it_it',    'Aggiungi file per',    1),
        ('add', 'Add',  'it_it',    'Inserisci',    1),
        ('mail_manager_configured', 'Mail Manager is not configured',   'it_it',    'Mail Manager non è configurato',   1),
        ('dialog_add_files_by', 'Add Files by', 'it_it',    'Aggiungi file per',    1),
        ('dialog_drive',    'Drive',    'it_it',    'Guidare',  1),
        ('dialog_drop_box', 'Drop Box', 'it_it',    'Drop Box', 1),
        ('dialog_need_signin',  'You need to Sign-in to your Drive account first.', 'it_it',    'Devi prima effettuare l\'accesso', 1),
        ('dialog_gallery',  'Gallery',  'it_it',    'Galleria', 1),
        ('delete',  'Delete',   'it_it',    'Elimina',  1),
        ('timeoutmessage',  'Oops! Request is taking more time than expected.', 'it_it',    'La richiesta richiede più tempo del previsto.',    1),
        ('gps_location_message',    'GPS is not enabled. Please turn it on to get your near by locations.', 'it_it',    'Il GPS non è abilitato. Si prega di accenderlo per ottenere il tuo vicino da posizioni.',  1),
        ('sure_want_delete',    'Are you sure want to delete ?',    'it_it',    'Sei sicuro di voler cancellare?',  1),
        ('select',  'Select',   'it_it',    'Selezionare',  1),
        ('msgforrecordaudio',   'Minimum record duration one second.',  'it_it',    'Durata minima del record un secondo.', 1),
        ('permission_storage',  'Permission denied to read your External storage',  'it_it',    'Autorizzazione negata per leggere la memoria esterna', 1),
        ('send_permission_msg', 'Send message permission denied',   'it_it',    'Permesso negato per invio messaggio',  1),
        ('choosefile',  'Choose File',  'it_it',    'Scegli il file',   1),
        ('enter',   'Enter',    'it_it',    'accedere', 1),
        ('select_an_option',    'Select an Option', 'it_it',    'Seleziona una opzione',    1),
        ('email_validation',    'Email is not valid',   'it_it',    'L\'email non è valida',    1),
        ('please_enter',    'Please Enter', 'it_it',    'Prego entra',  1),
        ('website_validation_text', 'Website URL is not valid', 'it_it',    'L\'URL del sito web non è valido', 1),
        ('selectvalue', 'Select value first',   'it_it',    'Seleziona prima il valore',    1),
        ('email',   'Email',    'it_it',    'E-mail',   1),
        ('enter_email_address', 'Enter email address',  'it_it',    'Inserisci l\'indirizzo email', 1),
        ('email_address_not_correct',   'Email address incorrect',  'it_it',    'Indirizzo email errato',   1),
        ('pls_enter_subject',   'Please Enter Subject', 'it_it',    'Per favore, inserisci l\'oggetto', 1),
        ('attachFiles', 'Attached File',    'it_it',    'File allegato',    1),
        ('from',    'From', 'it_it',    'A partire dal',    1),
        ('to',  'To',   'it_it',    'A',    1),
        ('call_permission_msg', 'Call permission denied',   'it_it',    'Permesso negato per la chiamata',  1),
        ('no_records',  'No records found', 'it_it',    'Nessun record trovato',    1),
        ('fullform',    'Create New',   'it_it',    'Modulo completo',  1),
        ('save',    'Save', 'it_it',    'Salvare',  1),
        ('total',   'Total',    'it_it',    'Totale',   1),
        ('discount',    'Discount', 'it_it',    'Sconto',   1),
        ('price',   'Price',    'it_it',    'Prezzo *', 1),
        ('quantity',    'Quantity', 'it_it',    'Quantità *',   1),
        ('select_module',   'Select Module',    'it_it',    'Seleziona il modulo',  1),
        ('item_list',   'Item List',    'it_it',    'Elenco degli elementi',    1),
        ('quickcreate', 'Quick Create', 'it_it',    'Creazione rapida', 1),
        ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'it_it',    'Sovrascrivi l\'indirizzo attuale con ',    1),
        ('once_in_every',   'Once in every',    'it_it',    'Una volta in ogni',    1),
        ('overwrite_msg_part2', 'address details?', 'it_it',    'l\'indirizzo selezionato?',    1),
        ('add_item',    'Add Item', 'it_it',    'Aggiungi elemento',    1),
        ('recordsave',  'Record saved successfully',    'it_it',    'Il Record è stato salvato con successo',   1),
        ('recordnotsave',   'Could not save record. Try again later',   'it_it',    'Record non salvato',   1),
        ('minutes', 'Minutes',  'it_it',    'Minuti',   1),
        ('hours',   'Hours',    'it_it',    'Hours',    1),
        ('days',    'Days', 'it_it',    'giorni',   1),
        ('on',  'On',   'it_it',    'Sopra',    1),
        ('day_of_the_month',    'day of the month', 'it_it',    'giorno del mese',  1),
        ('list_price',  'List Price',   'it_it',    'Listino prezzi *', 1),
        ('add_record',  'Add Record',   'it_it',    'Aggiungi record',  1),
        ('add_product', 'Add Product',  'it_it',    'Aggiungi prodotto',    1),
        ('add_service', 'Add Service',  'it_it',    'Aggiungi servizio',    1),
        ('discountin',  'Discount in %',    'it_it',    'Sconto in%',   1),
        ('unitprice',   'Unit price',   'it_it',    'Prezzo unitario',  1),
        ('netprice',    'Net price',    'it_it',    'Prezzo netto *',   1),
        ('comments',    'Comments', 'it_it',    'Commenti', 1),
        ('add_close',   'Add & Close',  'it_it',    'Aggiungi e Chiudi',    1),
        ('fetching_rout_message',   'Fetching route, Please wait…', 'it_it',    'Recupero del percorso, attendere prego …', 1),
        ('setting', 'Settings', 'it_it',    'impostazioni', 1),
        ('utc', 'UTC',  'it_it',    'UTC',  1),
        ('in',  'In',   'it_it',    'Nel',  1),
        ('days_ago',    'days ago', 'it_it',    'giorni fa',    1),
        ('mins_ago',    'Minutes ago',  'it_it',    'minuti fa',    1),
        ('justnow', 'Just now', 'it_it',    'Proprio adesso',   1),
        ('hours_ago',   'hours ago',    'it_it',    'ore fa',   1),
        ('in_1_day',    'In 1 day', 'it_it',    'In 1 giorno',  1),
        ('scanqrcode',  'Asset / Card scanner', 'it_it',    'Scanner Asset / Card', 1),
        ('call_log',    'Call Log', 'it_it',    'Registro chiamate',    1),
        ('voice_message',   'Hi',   'it_it',    'Ciao', 1),
        ('voice_message1',  'What can I search for you in', 'it_it',    'Cosa posso cercare per te',    1),
        ('live_tracking',   'Live Tracking',    'it_it',    'Monitoraggio dal vivo',    1),
        ('mailmanager', 'Mail Manager', 'it_it',    'Gestore della posta',  1),
        ('my_location', 'My location',  'it_it',    'La mia posizione', 1),
        ('created_on',  'Created On',   'it_it',    'Creato',   1),
        ('modified_on', 'Modified On',  'it_it',    'Modificato',   1),
        ('enter_comments',  'Enter Comments',   'it_it',    'Inserisci commenti',   1),
        ('viewmore',    'View More',    'it_it',    'Visualizza altro', 1),
        ('viewless',    'View Less',    'it_it',    'Visualizza meno',  1),
        ('gotofullform',    'Go to Full Form',  'it_it',    'Vai a modulo completo',    1),
        ('post',    'Post', 'it_it',    'Inviare',  1),
        ('url', 'URL',  'it_it',    'URL',  1),
        ('dialog_title_text_back_color',    'Select a Text Background Color',   'it_it',    'Seleziona un colore di sfondo del testo',  1),
        ('event_or_task',   'Add event/task',   'it_it',    'Aggiungi evento / attività',   1),
        ('shortcut',    'Shortcuts',    'it_it',    'Tasti di scelta rapida',   1),
        ('select_field',    'Select Field', 'it_it',    'Seleziona campo',  1),
        ('share',   'Share',    'it_it',    'Condividere',  1),
        ('title_insert_link',   'Insert Link',  'it_it',    'Inserisci collegamento',   1),
        ('addyourcommentshere', 'Add your comments here',   'it_it',    'Aggiungi i tuoi commenti qui', 1),
        ('nocomment',   'No Comments',  'it_it',    'Non ci sono commenti', 1),
        ('leads',   'Leads',    'it_it',    'Conduce',  1),
        ('true_val',    'true', 'it_it',    'vero', 1),
        ('noresult',    'No Result',    'it_it',    'Nessun risultato', 1),
        ('version', 'Version',  'it_it',    'Versione', 1),
        ('convert_lead',    'Convert Lead', 'it_it',    'Converti Lead',    1),
        ('app_name',    'CRMTiger', 'it_it',    'CRMTiger', 1),
        ('enter_url',   'Please Enter url', 'it_it',    'Si prega di inserire l\'url',  1),
        ('help',    'Help', 'it_it',    'Aiuto',    1),
        ('contact_us',  'Contact Us',   'it_it',    'Contattaci',   1),
        ('updates', 'Updates',  'it_it',    'Aggiornamenti',    1),
        ('logout',  'LogOut',   'it_it',    'Disconnettersi',   1),
        ('busnies_cardscanner', 'Business Card Scanner',    'it_it',    'Scanner di BdV',   1),
        ('sure_want_logout',    'Are you sure want to logout ?',    'it_it',    'Sei sicuro di voler uscire?',  1),
        ('logout_message',  'Logout successfully',  'it_it',    'Logout successfully',  1),
        ('all', 'All',  'it_it',    'Tutti',    1),
        ('add_event',   'Add event',    'it_it',    'Aggiungi evento',  1),
        ('add_task',    'Add Task', 'it_it',    'Aggiungi attività',    1),
        ('next',    'Next', 'it_it',    'Prossimo', 1),
        ('terms_conditions',    'Terms and Conditions', 'it_it',    'Termini e Condizioni', 1),
        ('login',   'Login',    'it_it',    'Accesso',  2),
        ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy',    'it_it',    'Effettuando il login, accetti i nostri Termini e condizioni nonché la politica sulla riservatezza',    2),
        ('copyright',   'Copyright © 2019 CRMTiger Version',    'it_it',    'Copyright © 2019 CRMTiger Version',    2),
        ('enter_username',  'Please enter username',    'it_it',    'Si prega di inserire il nome utente',  2),
        ('enter_password',  'Please enter password',    'it_it',    'Per favore, inserisci la password',    2),
        ('remanberme',  'Remember Me',  'it_it',    'Ricordati di me',  2),
        ('forgot_password', 'Forgot password?', 'it_it',    'Hai dimenticato la password?', 2),
        ('privacy_policay1',    'Privacy Policy',   'it_it',    'politica sulla riservatezza',  2),
        ('contactsupportmsg',   'Something went wrong. \n please Click here to contact support.',   'it_it',    'Qualcosa è andato storto.per favore Clicca qui per contattare il supporto',    2),
        ('enter_username_password', 'Entered Username or Password is wrong',    'it_it',    'Il nome utente o la password inseriti sono errati',    2),
        ('server_issue_occured',    'Server issues occurred',   'it_it',    'Problema con il server',   2),
        ('password',    'Password', 'it_it',    'Parola d\'ordine', 3),
        ('user_name',   'Username', 'it_it',    'Nome utente',  3),
        ('reset_pwd',   'Reset Password',   'it_it',    'Resetta la password',  3),
        ('forgot_password_title',   'Forgot password',  'it_it',    'Hai dimenticato la password',  3),
        ('enter_user_name', 'Enter user name',  'it_it',    'Inserire username',    3),
        ('cc',  'Cc',   'it_it',    'cc',   4),
        ('body',    'Body', 'it_it',    'Corpo',    4),
        ('bcc', 'BCC',  'it_it',    'CCN',  4),
        ('dialog_title_text_color', 'Select a Text Color',  'it_it',    'Seleziona il colore del testo',    4),
        ('date',    'Date', 'it_it',    'Data', 4),
        ('subject', 'Subject',  'it_it',    'Oggetto',  4),
        ('composeMail', 'Compose Mail', 'it_it',    'Scrivi una mail',  4),
        ('send',    'Send', 'it_it',    'Inviare',  4),
        ('select_message',  'Select message',   'it_it',    'Seleziona messaggio',  4),
        ('title_insert_table',  'Insert Table', 'it_it',    'Inserisci tabella',    4),
        ('log_file_sms',    'I agree to Share API Log to Technical team for further troubleshooting',   'it_it',    'Accetto di condividere il log dell\'API al team tecnico per una ulteriore analisi e risoluzione dei problemi', 5),
        ('edit_record', 'Edit Records', 'it_it',    'Modifica record',  5),
        ('select_time', 'Select Time',  'it_it',    'Seleziona ora',    5),
        ('edit_item',   'Edit Item',    'it_it',    'Modifica elemento',    5),
        ('items_total', 'Items Total',  'it_it',    'Totale articoli',  5),
        ('number_less_then_31', 'Number should be less than 31',    'it_it',    'Il numero deve essere inferiore a 31', 5),
        ('users',   'Users',    'it_it',    'utenti',   5),
        ('groups',  'Groups',   'it_it',    'gruppi',   5),
        ('txt_note_for_file',   'Note : Existing attachments(images/files) will be replaced',   'it_it',    'Nota: gli allegati esistenti (immagini / file) saranno sostituiti',    5),
        ('greaterdatetime', 'End DateTime should be greater than Start DateTime',   'it_it',    'End DateTime deve essere maggiore di Start DateTime',  5),
        ('until',   'Until',    'it_it',    'Fino a',   5),
        ('organizations',   'Organizations',    'it_it',    'organizzazioni',   6),
        ('contacts',    'Contacts', 'it_it',    'Contatti', 6),
        ('opportunity', 'Opportunity',  'it_it',    'Opportunità',  6),
        ('lbl_sun', 'SUN',  'it_it',    'DOM',  7),
        ('lbl_mon', 'MON',  'it_it',    'LUN',  7),
        ('lbl_tue', 'TUE',  'it_it',    'MAR',  7),
        ('lbl_wed', 'WED',  'it_it',    'MER',  7),
        ('lbl_thu', 'THU',  'it_it',    'GIO',  7),
        ('lbl_fri', 'FRI',  'it_it',    'VEN',  7),
        ('lbl_sat', 'SAT',  'it_it',    'SAB',  7),
        ('lbl_1',   '1',    'it_it',    '1',    7),
        ('lbl_2',   '2',    'it_it',    '2',    7),
        ('lbl_3',   '3',    'it_it',    '3',    7),
        ('lbl_4',   '4',    'it_it',    '4',    7),
        ('lbl_5',   '5',    'it_it',    '5',    7),
        ('lbl_6',   '6',    'it_it',    '6',    7),
        ('lbl_7',   '7',    'it_it',    '7',    7),
        ('lbl_8',   '8',    'it_it',    '8',    7),
        ('lbl_9',   '9',    'it_it',    '9',    7),
        ('lbl_10',  '10',   'it_it',    '10',   7),
        ('lbl_11',  '11',   'it_it',    '11',   7),
        ('lbl_12',  '12',   'it_it',    '12',   7),
        ('lbl_13',  '13',   'it_it',    '13',   7),
        ('lbl_14',  '14',   'it_it',    '14',   7),
        ('lbl_15',  '15',   'it_it',    '15',   7),
        ('lbl_16',  '16',   'it_it',    '16',   7),
        ('lbl_17',  '17',   'it_it',    '17',   7),
        ('lbl_18',  '18',   'it_it',    '18',   7),
        ('lbl_19',  '19',   'it_it',    '19',   7),
        ('lbl_20',  '20',   'it_it',    '20',   7),
        ('lbl_21',  '21',   'it_it',    '21',   7),
        ('lbl_22',  '22',   'it_it',    '22',   7),
        ('lbl_23',  '23',   'it_it',    '23',   7),
        ('lbl_24',  '24',   'it_it',    '24',   7),
        ('lbl_25',  '25',   'it_it',    '25',   7),
        ('lbl_26',  '26',   'it_it',    '26',   7),
        ('lbl_27',  '27',   'it_it',    '27',   7),
        ('lbl_28',  '28',   'it_it',    '28',   7),
        ('lbl_29',  '29',   'it_it',    '29',   7),
        ('lbl_30',  '30',   'it_it',    '30',   7),
        ('lbl_31',  '31',   'it_it',    '31',   7),
        ('lbl_32',  '32',   'it_it',    '32',   7),
        ('lbl_33',  '33',   'it_it',    '33',   7),
        ('lbl_34',  '34',   'it_it',    '34',   7),
        ('lbl_35',  '35',   'it_it',    '35',   7),
        ('lbl_36',  '36',   'it_it',    '36',   7),
        ('lbl_37',  '37',   'it_it',    '37',   7),
        ('lbl_38',  '38',   'it_it',    '38',   7),
        ('lbl_39',  '39',   'it_it',    '39',   7),
        ('lbl_40',  '40',   'it_it',    '40',   7),
        ('lbl_41',  '41',   'it_it',    '41',   7),
        ('lbl_42',  '42',   'it_it',    '42',   7),
        ('current_date',    'current date', 'it_it',    'data odierna', 7),
        ('event',   'Events',   'it_it',    'eventi',   7),
        ('calendar',    'Calendar', 'it_it',    'Calendario',   7),
        ('latest_version',  'Latest Version :', 'it_it',    'Ultima versione :',    8),
        ('expire_on',   'Expire On :',  'it_it',    'Scadenza:',    8),
        ('ctmobile_ext_version',    'CTMobile Ext. Version :',  'it_it',    'CTMobile est. Versione:',  8),
        ('you_have_latest_version', 'You already have latest version',  'it_it',    'Hai aggiornato la versione',   8),
        ('upgreaded',   'Upgrade',  'it_it',    'aggiornamento',    8),
        ('downgrade',   'Downgrade',    'it_it',    'retrocedere',  8),
        ('dialog_recent_event_info',    'You can set from here how many number of records you want to show on Home screen for Recent Event.',   'it_it',    'Puoi impostare da qui quanti numeri di record vuoi mostrare sulla schermata Home per Eventi recenti.', 8),
        ('dialog_feedback_info',    'You can submit your feedback with description , our team will check your feedback and get back to you.',   'it_it',    'Puoi inviare il tuo feedback con la descrizione, il nostro team controllerà il tuo feedback e ti risponderà.', 8),
        ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.',    'it_it',    'La funzionalità di registro viene utilizzata per l\'assistenza / aiuto clienti, se si riscontrano problemi nell\'app o in qualsiasi modulo o se la funzionalità non funziona correttamente, è possibile abilitare il registro di condivisione con il nostro team di sviluppo.',    8),
        ('info',    'Info', 'it_it',    'Informazioni', 8),
        ('recent_history',  'Recent History',   'it_it',    'Storia recente',   8),
        ('recent_feedback', 'Feedback', 'it_it',    'Risposta', 8),
        ('recent_log',  'Log',  'it_it',    'Tronco d\'albero', 8),
        ('crmtiger_app_version',    'CRMTiger App Version :',   'it_it',    'Versione dell\'app CRMTiger:', 8),
        ('historylimit',    'Recent History Limit', 'it_it',    'Limite della cronologia recente',  8),
        ('radious_in_miles',    'Radius in miles',  'it_it',    'Raggio in miglia', 8),
        ('recentlimit', 'Recent Event Limit',   'it_it',    'Limite eventi recenti',    8),
        ('upcoming_events', 'Upcoming Events',  'it_it',    'Prossimi eventi',  8),
        ('rate_our_app',    'Rate Our App!',    'it_it',    'Vota la nostra app!',  8),
        ('feedback',    'Submit Feedback',  'it_it',    'Invia feedback',   8),
        ('sendfeedback',    'Feedback Send',    'it_it',    'Invia feedback',   8),
        ('emaillimit',  'Email limit',  'it_it',    'Limite email', 8),
        ('log', 'Log',  'it_it',    'Tronco d\'albero', 8),
        ('logclear',    'Log cleared successfully.',    'it_it',    'Cancellazione eseguita',   8),
        ('dialog_recent_history_info',  'You can set from here how many number of records you want to show on Home screen for Recent History.', 'it_it',    'È possibile impostare da qui quanti numeri di record si desidera mostrare nella schermata Home per la cronologia recente.',    8),
        ('proceed_to_upgrade1', 'Proceed to',   'it_it',    'Procedi a',    8),
        ('upgradation_message', 'will required logout and login again later.',  'it_it',    'Sarà richiesto un logout e un login in seguito.',  8),
        ('proceed_to_upgrade',  'Proceed to Upgrade',   'it_it',    'Procedi con l\'upgrade',   8),
        ('module_setting',  'Module Setting',   'it_it',    'Impostazione del modulo',  9),
        ('sortbyfield', 'Sort by field',    'it_it',    'Ordina per campo', 9),
        ('ascending',   'Ascending  A to Z',    'it_it',    'Ascendente dalla A alla Z.',   9),
        ('descending',  'Descending  Z to A',   'it_it',    'Decrescente dalla Z alla A',   9),
        ('first_field', 'First Field',  'it_it',    'Primo campo',  9),
        ('second_field',    'Second Field', 'it_it',    'Secondo campo',    9),
        ('third_field', 'Third Field',  'it_it',    'Terzo campo',  9),
        ('sure_want_restore',   'Are you sure you want to reset to default settings?',  'it_it',    'Sei sicuro di voler ripristinare il valore predefinito',   9),
        ('orderlist',   'List Order',   'it_it',    'Ordine di lista',  9),
        ('module_reset',    'Restore to Default',   'it_it',    'Ripristina al valore predefinito', 9),
        ('display_fields',  'Display Fields',   'it_it',    'Visualizza campi', 9),
        ('discount_lessthen_100',   'Discount % should be less than 100',   'it_it',    'La percentuale di sconto deve essere inferiore a 100', 10),
        ('select_item', 'Select Item',  'it_it',    'Scegliere elemento',   10),
        ('item_comment',    'Item Comment', 'it_it',    'Commento elemento',    10),
        ('record_name', 'Record Name is :', 'it_it',    'Il nome del record è: -',  11),
        ('go_back', 'Go Back',  'it_it',    'Torna indietro',   11),
        ('please_enter_shortcut_name',  'Please Enter Shortcut Name',   'it_it',    'Si prega di inserire il nome del collegamento',    11),
        ('number_not_found',    'Contact Number not found', 'it_it',    'Numero di contatto non trovato',   11),
        ('mail_not_found',  'Mail Address not found',   'it_it',    'Indirizzo di posta non trovato',   11),
        ('create_shortcut', 'Create Shortcut',  'it_it',    'Creare una scorciatoia',   11),
        ('contact_summary', 'Summary',  'it_it',    'Riepilogo',    11),
        ('activites',   'Activities',   'it_it',    'attività', 11),
        ('details', 'Details',  'it_it',    'Dettagli', 11),
        ('related', 'Related',  'it_it',    'Imparentato',  11),
        ('share_link',  'Share record with',    'it_it',    'Condividi record con', 11),
        ('edit',    'Edit', 'it_it',    'Modifica', 11),
        ('duplicate',   'Duplicate',    'it_it',    'Duplica',  11),
        ('whatsapp',    'Whatsapp', 'it_it',    'Whatsapp', 11),
        ('call',    'Call', 'it_it',    'Chiama',   11),
        ('choose_contact_for_call', 'Choose Contact for Call',  'it_it',    'Scegli contatto per Chiamata', 11),
        ('choose_contact_for_sms',  'Choose Contact for SMS',   'it_it',    'Scegli contatto per SMS',  11),
        ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp',  'it_it',    'Scegli contatto per WhatsApp', 11),
        ('chosse_contact_for_email',    'Choose Email', 'it_it',    'Scegli Email', 11),
        ('attach_file', 'Attach Files', 'it_it',    'Allega File',  11),
        ('close',   'Close',    'it_it',    'Chiudi',   11),
        ('status',  'Status',   'it_it',    'Stato',    11),
        ('stop',    'Stop', 'it_it',    'Blocca',   11),
        ('zero',    '0',    'it_it',    '0',    11),
        ('record',  'Record',   'it_it',    'Registra', 11),
        ('voice_note',  'Voice Note',   'it_it',    'Nota vocale',  11),
        ('tickets', 'Tickets',  'it_it',    'Biglietti',    12),
        ('check_out',   'Check Out',    'it_it',    'Registra Uscita',  12),
        ('check_in',    'Check In', 'it_it',    'Registra Entrata', 12),
        ('select_any',  'Select any',   'it_it',    'Seleziona uno qualsiasi',  12),
        ('fulldetails', 'Show Full Details',    'it_it',    'Mostra tutti i dettagli',  12),
        ('checkin', 'Check-in', 'it_it',    'Registrare',   12),
        ('navigate',    'Navigate', 'it_it',    'Navigare', 12),
        ('product', 'Products', 'it_it',    'Prodotti', 12),
        ('projectMilestone',    'Project Milestone',    'it_it',    'Pietra miliare del progetto',  12),
        ('projecttask', 'Project Tasks',    'it_it',    'Compiti del progetto', 12),
        ('nearby',  'NearBy',   'it_it',    'Nelle vicinanze',  13),
        ('document',    'Document', 'it_it',    'Documento',    14),
        ('reply',   'Reply',    'it_it',    'rispondere',   14),
        ('reply_all',   'Reply All',    'it_it',    'Rispondi a tutti', 14),
        ('forward', 'Forward',  'it_it',    'Inoltrare',    14),
        ('action',  'Action',   'it_it',    'Azione',   14),
        ('select_first',    'Select First', 'it_it',    'Seleziona Prima',  14),
        ('commentaddsuccessful',    'Comment added successfull',    'it_it',    'Commento aggiungere con successo', 14),
        ('move_to', 'Move to',  'it_it',    'Sposta a', 14),
        ('attach',  'Attach',   'it_it',    'allegare', 14),
        ('addcoment',   'Add Comment',  'it_it',    'Aggiungi un commento', 14),
        ('adddocument', 'Add Document', 'it_it',    'Aggiungi documento',   14),
        ('home',    'Home', 'it_it',    'Casa', 15),
        ('checkout',    'Check-out',    'it_it',    'Registra Uscita',  15),
        ('message_search',  'Search by name',   'it_it',    'Ricerca per nome', 15),
        ('start_shift', 'Start shift',  'it_it',    'Inizia il turno',  15),
        ('end_shift',   'End shift',    'it_it',    'Fine turno',   15),
        ('today_meeting',   'Meetings', 'it_it',    'incontri', 15),
        ('shift_time_track',    'Shift Time Track', 'it_it',    'Traccia dei turni',    15),
        ('logout_msg',  'You have to login again , click',  'it_it',    'Devi fare nuovamente login, clicca',   15),
        ('logout_msg1', 'to continue.', 'it_it',    'per continuare',   15),
        ('permission_denied',   'You don\'t have permission to create', 'it_it',    'Non hai il permesso di creare',    15),
        ('history', 'Activity stream',  'it_it',    'Flusso di attività',   15),
        ('search_value',    'Search value :',   'it_it',    'Cerca il valore :',    15),
        ('feed_back_msg',   'Please enter feedback message',    'it_it',    'Si prega di inserire un messaggio di feedback',    16),
        ('feed_back_hint_msg',  'Enter feedback message',   'it_it',    'Inserisci un messaggio di feedback',   16),
        ('submit',  'Submit',   'it_it',    'Sottoscrivi',  16),
        ('check_app_not_installed', 'Application is not currently installed.',  'it_it',    'L\'applicazione non è attualmente installata.',    17),
        ('send_sms_fail_message',   'SMS failed, please try again later!',  'it_it',    'SMS fallito, per favore riprova più tardi!',   17),
        ('documentaddsuccessfully', 'Document Attach successfully', 'it_it',    'Documento Allega con successo',    17),
        ('send_message',    'Send message', 'it_it',    'Invia messaggio',  17),
        ('sms_to',  'smsto:',   'it_it',    'smsto:',   17),
        ('add_list_message',    'Add List', 'it_it',    'Aggiungi lista',   18),
        ('mylist',  'My List',  'it_it',    'La mia lista', 18),
        ('filtername',  'Filter Name',  'it_it',    'Nome filtro',  18),
        ('selectlist',  'Select a List',    'it_it',    'Seleziona un elenco *',    18),
        ('assingedto',  'Assigned To',  'it_it',    'Assegnato a *',    18),
        ('selectmodule',    'Select a module',  'it_it',    'Seleziona un modulo',  18),
        ('add_list',    'Add Filter',   'it_it',    'Aggiungi filtro',  18),
        ('recent_event',    'Recent Event', 'it_it',    'Evento recente',   19),
        ('recent_hostory',  'Recent History',   'it_it',    'Storia recente',   19),
        ('module_specific_settings',    'Module-Specific Settings', 'it_it',    'Impostazioni specifiche del modulo',   19),
        ('talk_to_us',  'Talk to us',   'it_it',    'Parla con noi',    19),
        ('report_a_bug',    'Report A Bug', 'it_it',    'Segnalare un bug', 19),
        ('faq', 'FAQ',  'it_it',    'FAQ',  19),
        ('selectmodules',   'Select Module',    'it_it',    'Seleziona il modulo',  19),
        ('myplan',  'My Plan',  'it_it',    'Il mio piano', 19),
        ('message', 'Message',  'it_it',    'Messaggio',    20),
        ('message_validation',  'Please enter Message', 'it_it',    'Si prega di inserire il messaggio',    20),
        ('contact_select',  'Please Select contact',    'it_it',    'Si prega di selezionare un contatto',  20),
        ('global_search',   'Global Search',    'it_it',    'Ricerca globale',  21),
        ('records', 'Records',  'it_it',    'Registrazioni',    21),
        ('dont_show_again', 'Don\'t Show Again',    'it_it',    'Non mostrare di nuovo',    22),
        ('skip',    'Skip', 'it_it',    'Salta',    22),
        ('file_downloading',    'File Downloading', 'it_it',    'Download di file', 23),
        ('add_screenshots_optional',    'Add screenshots (optional)',   'it_it',    'Aggiungi screenshot (opzionale)',  24),
        ('describe_your_problem',   'Describe your problem',    'it_it',    'Descrivi il tuo problema', 24),
        ('default_filter_shortcut', 'Default Filter Shortcut',  'it_it',    'Scorciatoia per filtro di default',    25),
        ('record_shortcut', 'Record Shortcut',  'it_it',    'Scorciatoia per registrazione',    25),
        ('enter_url',   'Please Enter url', 'it_it',    'Per favore inserisci url', 26),
        ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'it_it',    'Devi aggiornare l\'app per continuare Per favore aggiorna per continuare Le vecchie versioni non funzioneranno più da oggi',   26),
        ('search_by',   'Search by',    'it_it',    'Cercato da',   27),
        ('selected_filter', 'Selected filter :',    'it_it',    'Filtro selezionato: -',    27),
        ('selected_field',  'Selected field :', 'it_it',    'Campo selezionato: -', 27),
        ('choose',  'Choose',   'it_it',    'Scegli',   28),
        ('qr_cardscanner',  'QR Code Scanner',  'it_it',    'Scanner di QR Code',   28),
        ('error_message_for_scan',  'Could not read the card Try again later.', 'it_it',    'Impossibile leggere il biglietto Prova più tardi.',    28),
        ('press_start_scan',    'Press to Start Scan',  'it_it',    'Premi per avviare la scansione',   28),
        ('line_item_quntity_validation_msg',    'Value should be greater than zero',    'it_it',    'Il valore deve essere maggiore di zero',   29),
        ('percentage_msg',  'Percentage should be less than 100',   'it_it',    'La percentuale deve essere inferiore a 100',   29),
        ('MSG_NO_DATA', 'No data found!',   'it_it',    'Nessun dato trovato!', 29),
        ('MSG_SOMETHING_WRONG', 'Something went wrong!',    'it_it',    'Qualcosa è andato storto!',    29),
        ('MSG_COMING_SOON', 'Coming Soon!', 'it_it',    'Prossimamente!',   29),
        ('MSG_UPLOAD_PROFILE_IMAGE',    'Please upload profile image.', 'it_it',    'Per favore carica la foto profilo.',   29),
        ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access',  'it_it',    'Accesso alla posizione',   29),
        ('ALERT_MSG_LOCATION_ACCESS',   'Requires your location to show nearby events.',    'it_it',    'La tua posizione è richiesta per mostrare eventi nelle vicinanze.',    29),
        ('ALERT_BTN_ALLOW', 'ALLOW',    'it_it',    'PERMETTI', 29),
        ('ALERT_BTN_DENY',  'DENY', 'it_it',    'NEGA', 29),
        ('ALERT_MSG_LOCATION_SETTING',  'Not able to fetch your current location. Please allow us to use your location to provide you certain features like, live tracking, route planning and display near by leads, contact, organization, etc. This will help you to plan your on field task as well',   'it_it',    'Impossibile recuperare la tua posizione attuale. Consentici di utilizzare la tua posizione per fornirti determinate funzionalità come il monitoraggio in tempo reale, la pianificazione del percorso e la visualizzazione nelle vicinanze di contatti, contatti, organizzazione, ecc. Ciò ti aiuterà anche a pianificare la tua attività sul campo',   29),
        ('DELETE_RECORD',   'Delete Record',    'it_it',    'Cancella Record',  29),
        ('ALERT_MSG_DELETE_SHORTCUT',   'Are you sure want to delete this shortcut?',   'it_it',    'Sei sicuro di voler cancellare questa scorciatoia?',   29),
        ('DELETE_SHORTCUT', 'Delete Shortcut',  'it_it',    'Cancella Scorciatoia', 29),
        ('LBL_TERMS',   'By logging in, you agree to our Terms and',    'it_it',    'per continuare devi accettare i nostri Termini',   29),
        ('LBL_CONDITIONS',  'Conditions &', 'it_it',    'Condizioni &', 29),
        ('ALERT_TITLE', 'Alert',    'it_it',    'Attenzione',   29),
        ('ALERT_BTN_SUBSCRIBE', 'Subscribe',    'it_it',    'Sottoscrivi',  29),
        ('MSG_SELECT_MODULE',   'Please select any Module', 'it_it',    'Prego seleziona un modulo',    29),
        ('MSG_SELECT_LIST', 'Please select any List',   'it_it',    'Prego seleziona una lista',    29),
        ('ALERT_MSG_DONT_HAVE_CAMERA',  'You don\'t have camera',   'it_it',    'Non hai una Webcam',   29),
        ('ALERT_MSG_GALLARY_PERMISSION',    'You don\'t have permission to access gallery.',    'it_it',    'Non hai il permesso di accedere alla galleria.',   29),
        ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'it_it',    'Non hai il permesso di accedere alla fotocamera. Vai a Impostazioni -&gt; Scorri in fondo e seleziona CRMTiger App -&gt; Attiva fotocamera',   29),
        ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'it_it',    'Non hai il permesso di accedere al riconoscimento vocale. Vai a Impostazioni -&gt; Scorri in fondo e seleziona CRMTiger App -&gt; Attiva riconoscimento vocale',   29),
        ('BTN_DONE',    'Done', 'it_it',    'Commento', 29),
        ('COMMENT', 'Comment',  'it_it',    'Commento', 29),
        ('FULL_FORM',   'Full Form',    'it_it',    'Form completo',    29),
        ('QUICK_CREATE',    'Create',   'it_it',    'Crea', 29),
        ('LBL_SELECT_FIELDS',   'Select Fields',    'it_it',    'Seleziona Campi',  29),
        ('LBL_SELECT_FIELDS',   'Select Fields',    'it_it',    'Seleziona Campi',  29),
        ('LBL_SELECT_FIRST_FIELDS', 'Select First Field',   'it_it',    'Selezione Primo Campo',    29),
        ('LBL_SELECT_SECOND_FIELDS',    'Select Second Field',  'it_it',    'Selezione Secondo Campo',  29),
        ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field',   'it_it',    'Selezione Terzo Campo',    29),
        ('LBL_SORT_BY_FIELD',   'Select Sort By Field', 'it_it',    'Selezione Campo Visualizza per',   29),
        ('BTN_RESET_TO_DEFAULT',    'Reset to Default', 'it_it',    'Reimposta a valori di default',    29),
        ('MSG_SELECT_SORT_BY_FIELD',    'Select Sort by field', 'it_it',    'Selezione Campo Visualizza per',   29),
        ('kStrClearBtnTitle',   'Clear',    'it_it',    'Svuota',   29),
        ('kStrShowMoreBtnTitle',    'Show More',    'it_it',    'Mostra di più',    29),
        ('kStrAddActivitiesBtnTitle',   'Add Activities',   'it_it',    'Aggiungi Attività',    29),
        ('kStrAddCommentPlaceHolder',   'Add your comments here',   'it_it',    'Aggiungi qui i tuoi commenti', 29),
        ('MSG_ENTER_TO_EMAIL',  'Please enter to field.',   'it_it',    'Per favore inserisci nel campo.',  29),
        ('WARNING_FILE',    'File can\'t open.',    'it_it',    'Il file non si apre',  29),
        ('MSG_FILE_SAVED',  'File saved.',  'it_it',    'File salvato', 29),
        ('WARNING_DOWNLOAD_FAIL',   'Download fail!, please try after sometime.',   'it_it',    'Download fallito! Per favore riprova più tardi.',  29),
        ('LBL_SHORTCUT',    'Shortcut', 'it_it',    'Scorciatoia',  29),
        ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'it_it',    'Scrivi Messaggio', 29),
        ('ALERT_INSTALL_WHATSAPP',  'Install Whatsapp', 'it_it',    'Installa Whatsapp',    29),
        ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox',  'it_it',    'Nessuna casella email trovata. Per favore Crea Casella',   29),
        ('LBL_WROTE',   'Wrote',    'it_it',    'Scritto',  29),
        ('MSG_MAIL_SEND',   'Mail sent',    'it_it',    'Mail inviata', 29),
        ('log_file_not_found',  'API Log file not found.',  'it_it',    'File log API non trovato.',    29),
        ('unknown_error',   'An unknown error occurred, try again', 'it_it',    'Errore sconosciuto, riprova',  29),
        ('CTMTigerAppVersion',  'CRMTiger App Version', 'it_it',    'Versione App CRMTiger',    29),
        ('CTMMobileUpdateMsg',  'CTMobile Ext. Version Update Successfully',    'it_it',    'Estensione CTMobile aggiornata con successo',  29),
        ('dialog_Premium_downgrade',    'Downgrade will required logout and login again later', 'it_it',    'Il downgrade richiederà un logout e successivo login', 29),
        ('dialog_Premium',  'Upgrade will required logout and login again later',   'it_it',    'L\'upgrade richiederà un logout e successivo login',   29),
        ('Overwrite',   'Overwrite',    'it_it',    'Sovrascrivi',  29),
        ('MSGAddressOverwrite1',    'Overwrite the existing address with the selected', 'it_it',    'Sovrascrivi l\'indirizzo attuale con', 29),
        ('MSGAddressOverwrite2',    'address details?', 'it_it',    'i dati selezionati?',  29),
        ('UPGRADE_PLAN',    'Upgrade Plan', 'it_it',    'Upgrade del Piano',    29),
        ('DOWNGRADE_PLAN',  'Downgrade Plan',   'it_it',    'Downgrade del Piano',  29),
        ('UPGRADE_EXTENSION',   'Upgrade Extension',    'it_it',    'Upgrade dell\'estensione', 29),
        ('UPGRADE_APP', 'Upgrade App',  'it_it',    'Upgrade dell\'app',    29),
        ('SELECT_OPTION',   'Select Option',    'it_it',    'Seleziona Opzione',    29),
        ('PLEASE_SELECT',   'Please select',    'it_it',    'Per favore seleziona', 29),
        ('MSG_ACCESS_DENIED',   'You don\'t have permission for this module.',  'it_it',    'Non hai i permessi per questo modulo.',    29),
        ('MSG_SELECT_RECCURING_MONTH_DAY',  'Please select reccuring day of month.',    'it_it',    'Prego seleziona il giorno del mese periodico', 29),
        ('MSG_SELECT_RECCURING_WEEK_DAY',   'Please select reccuring day of week.', 'it_it',    'Prego seleziona il giorno della settimana periodico',  29),
        ('MSG_SELECT_RECCURING_DAYS',   'Please select reccuring days.',    'it_it',    'Prego seleziona i giorni periodici',   29),
        ('Please select reccuring days.',   'Please select reccuring days.',    'it_it',    'Prego seleziona i giorni periodici',   29),
        ('MSG_SELECT_RECCURING_END_DATE',   'Please select reccuring end date.',    'it_it',    'Prego seleziona la data di fine periodica',    29),
        ('MSG_SELECT_RECCURING_TYPE',   'Please select reccuring type.',    'it_it',    'Prego seleziona il tipo di periodicità',   29),
        ('FREQ_TIME',   'Times',    'it_it',    'Volte',    29),
        ('REPEAT_YEARLY',   'Repeat Yearly',    'it_it',    'Ripeti annualmente',   29),
        ('REPEAT_MONTHLY',  'Repeat Monthly',   'it_it',    'Ripeti mensilmente',   29),
        ('REPEAT_WEEKLY',   'Repeat Weekly',    'it_it',    'Ripeti settimanalmente',   29),
        ('REPEAT_DAILY',    'Repeat Daily', 'it_it',    'Ripeti giornalmente',  29),
        ('ACTION_TITLE',    'Action Title', 'it_it',    'Titolo dell\'azione',  29),
        ('MSG_SELECT_VALID_DATE',   'Please select valid day of month.',    'it_it',    'Prego seleziona un giorno del mese valido.',   29),
        ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'it_it',    'La data di inizio deve essere precedente alla data di fine.',  29),
        ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'it_it',    'L\'ora di inizio deve essere precedente all\'ora di fine.',    29),
        ('LBL_LINEITEM_DETAILS',    'Lineitem Details', 'it_it',    'Dettagli elemento',    29),
        ('MSG_INVALIDE_DISCOUNT_AMOUNT',    'Discount amount should be less than the total.',   'it_it',    'L\'importo dello sconto deve essere inferiore al totale.', 29),
        ('VIEW',    'View', 'it_it',    'Vista',    29),
        ('MSG_ENTER_VALID', 'Please enter valid',   'it_it',    'Prego inserisci un valore valido', 29),
        ('MSG_ENTER_PERCENTAGE',    'Percentage should be less than 100.',  'it_it',    'La percentuale deve essere inferiore a 100.',  29),
        ('ITEM_TOTAL',  'Item Total',   'it_it',    'Totale elemento',  29),
        ('ADJUSTMENT',  'Adjustment',   'it_it',    'Regolazione',  29),
        ('TITLE_CHOOSE_IMAGE',  'Choose Image', 'it_it',    'Scegli immagine',  29),
        ('COMPRESS',    'Compress', 'it_it',    'Comprimi', 29),
        ('CHOOSE_ANOTHER_IMAGE',    'Your image size is too large, please select another image',    'it_it',    'La tua immagine è troppo grande, selezionane un\'altra',   29),
        ('OnDayOfMonth',    'On day of month',  'it_it',    'Il giorno del mese',   29),
        ('OnDayOfWeek', 'On day of week',   'it_it',    'Il giorno della settimana',    29),
        ('AddAndClose', 'Add & Close',  'it_it',    'Aggiungi & Chiudi',    29),
        ('Repeat',  'Repeat',   'it_it',    'Ripeti',   29),
        ('OnDay',   'On day',   'it_it',    'Il giorno',    29),
        ('View_Line_Item',  'View Line Item',   'it_it',    'Vedi elemento',    29),
        ('TITLE_IMAGE', 'Image',    'it_it',    'Immagine', 29),
        ('TITLE_ICLOUD',    'iCloud',   'it_it',    'iCloud',   29),
        ('GOOGLE',  'Google',   'it_it',    'Google',   29),
        ('ALERT_BTN_OKAY',  'Okay', 'it_it',    'Va bene',  29),
        ('ALERT_TITLE_ACCESS_DENIED',   'Access Denied',    'it_it',    'Accesso negato',   29),
        ('Dont_Show_Again', 'Don\'t show again',    'it_it',    'Non mostrare di nuovo',    29),
        ('Skip',    'Skip', 'it_it',    'Salta',    29),
        ('Fillter_Name',    'Fillter Name', 'it_it',    'Nome filtro',  29),
        ('Fillter_Record_Count',    'Fillter Record Count', 'it_it',    'Conteggio record filtro',  29),
        ('url_note',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'it_it',    'Nota: se l\'URL del CRM è https://example.com/crm, inseriscilo nella casella sopra',   26),
        ('vtiger_url',  'Your vTiger CRM URL',  'it_it',    'Il tuo URL CRM vTiger',    26),
        ('msg_doc_read_permission', 'You don\'t have permission to Add either This is read-only or Private Field.', 'it_it',    'Non hai l\'autorizzazione per aggiungere Questo è di sola lettura o Campo privato.',   31),
        ('CLEAR',   'Clear',    'it_it',    'Svuota',   31),
        ('Files/photos uploaded successfully',  'Files/photos uploaded successfully',   'it_it',    'File/foto caricati correttamente', 32),
        ('Digital signature saved', 'Digital signature saved',  'it_it',    'Firma digitale salvata',   32),
        ('Please upload Signature or Files/photos', 'Please upload Signature or Files/photos',  'it_it',    'Prego carica Firma e File/foto',   32),
        ('Files / Photos',  'Files / Photos',   'it_it',    'File / Foto',  32),
        ('Signature',   'Signature',    'it_it',    'Firma',    32),
        ('add_photo_using', 'Add Photo Using',  'it_it',    'Aggiungi foto usando', 31),
        ('btn_upload_sign', '(+) Add Signature',    'it_it',    '(+) Aggiungi Firma',   31),
        ('btn_upload_photo_doc',    '(+) Upload Files/Photos',  'it_it',    '(+) Carica File / Foto',   31),
        ('select_photo_doc_to_upload',  'Please select files/photos to upload', 'it_it',    'Prego seleziona i file/foto da caricare',  31),
        ('related_module_title',    'Search from related module and Add to \"Route\"',  'it_it',    'Cerca da modulo collegato e Aggiungi a \"Itinerario\"',    30),
        ('Route status updated successfully',   'Route status updated successfully',    'it_it',    'Stato dell\'itinerario aggiornato correttamente',  32),
        ('Session init failed', 'Session init failed',  'it_it',    'Inizializzazione della sessione fallita',  32),
        ('You don\'t have permission to access this resource',  'You don\'t have permission to access this resource',   'it_it',    'Non hai il permesso di accedere a questa risorsa', 32),
        ('ctroute_realtedto cannot be empty',   'Could not get the Related To - Try again later',   'it_it',    'Non è stato possibile ottenere il Collegato a - Riprova più tardi',    32),
        ('ctroute_planning cannot be empty',    'Could not get the Route Planning Record - Try again later',    'it_it',    'Non è stato possibile ottenere il record della Pianificazione Itinerario - Riprova più tardi', 32),
        ('Something went wrong - Try again later',  'Something went wrong - Try again later',   'it_it',    'Qualcosa è andato storto - Riprova più tardi', 32),
        ('sequence updated successfully',   'sequence updated successfully',    'it_it',    'sequenza aggiornata correttamente',    32),
        ('sequence cannot be empty',    'sequence cannot be empty', 'it_it',    'la sequenza non può essere vuota', 32),
        ('Shortcut details not saved',  'Shortcut details not saved',   'it_it',    'Dettagli della scorciatoia non salvati',   32),
        ('Shortcut details saved successfully', 'Shortcut details saved successfully',  'it_it',    'Dettagli della scorciatoia salvati correttamente', 32),
        ('Route save successfully', 'Route save successfully',  'it_it',    'Itinerario salvato correttamente', 32),
        ('Record save successfully',    'Record save successfully', 'it_it',    'Record salvato correttamente', 32),
        ('No dependency found for picklist',    'No dependency found for picklist', 'it_it',    'Dipendenza non trovata per la picklist',   32),
        ('No records found',    'No records found', 'it_it',    'Nessun record trovato',    32),
        ('Outgoing server is not enabled, please configure from CRM',   'Outgoing server is not enabled, please configure from CRM',    'it_it',    'Server di uscita non abilitato, per favore configuralo nel CRM',   32),
        ('Removed Successfully',    'Removed Successfully', 'it_it',    'Eliminato correttamente',  32),
        ('Shortcut has been deleted',   'Shortcut has been deleted',    'it_it',    'La scorciatoia è stata eliminata', 32),
        ('relation of records removed successfully',    'relation of records removed successfully', 'it_it',    'relazioni dei record eliminate correttamente', 32),
        ('relation of records not removed', 'relation of records not removed',  'it_it',    'relazioni dei record non eliminate',   32),
        ('Record has been deleted successfully',    'Record has been deleted successfully', 'it_it',    'Il record è stato eliminato correttamente',    32),
        ('Time Tracking saved successfully',    'Time Tracking saved successfully', 'it_it',    'Tracciamento Orario salvato correttamente',    32),
        ('Time Tracking updated successfully',  'Time Tracking updated successfully',   'it_it',    'Tracciamento Orario aggiornato correttamente', 32),
        ('Time Tracking ended successfully',    'Time Tracking ended successfully', 'it_it',    'Tracciamento Orario concluso correttamente',   32),
        ('Time Tracking started successfully',  'Time Tracking started successfully',   'it_it',    'Tracciamento Orario avviato correttamente',    32),
        ('record cannot be empty',  'record cannot be empty',   'it_it',    'il record non può essere vuoto',   32),
        ('Module is disabled',  'Module is disabled',   'it_it',    'Modulo disabilitato',  32),
        ('Shift ended successfully',    'Shift ended successfully', 'it_it',    'Turno concluso correttamente', 32),
        ('Shift started successfully',  'Shift started successfully',   'it_it',    'Turno avviato correttamente',  32),
        ('relation of records added successfully',  'relation of records added successfully',   'it_it',    'relazione tra record aggiunta correttamente',  32),
        ('Comment saved successfully',  'Comment saved successfully',   'it_it',    'Commento salvato correttamente',   32),
        ('Comment not saved',   'Comment not saved',    'it_it',    'Commento non salvato', 32),
        ('Comment module is not active',    'Comment module is not active', 'it_it',    'Modulo commento non attivo',   32),
        ('No Upcoming Event',   'No Upcoming Event',    'it_it',    'Nessun evento in programma',   32),
        ('No Templates found - create it from Message Templates module',    'No Templates found - create it from Message Templates module', 'it_it',    'Nessun modello trovato - crealo nel modulo Modelli Messaggio', 32),
        ('No event or task for this date',  'No event or task for this date',   'it_it',    'Nessun evento o compito in questa data',   32),
        ('No filters created',  'No filters created',   'it_it',    'Nessun filtro creato', 32),
        ('Select at least one record to attach',    'Select at least one record to attach', 'it_it',    'Selezione almeno un record da allegare',   32),
        ('Please select one or more attachments',   'Please select one or more attachments',    'it_it',    'Per favore seleziona uno o più allegati',  32),
        ('No event for this month', 'No event for this month',  'it_it',    'Nessun evento in questo mese', 32),
        ('No Activity found',   'No Activity found',    'it_it',    'Nessuna Attività trovata', 32),
        ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'it_it',    'Il tuo feedback è importante - non può essere vuoto',  32),
        ('Could not send mail, Please try later',   'Could not send mail, Please try later',    'it_it',    'Mail non inviata, per favore prova più tardi', 32),
        ('Latest Version updated successfully', 'Latest Version updated successfully',  'it_it',    'Versione più recente aggiornata correttamente',    32),
        ('User Location Updated Successfully',  'User Location Updated Successfully',   'it_it',    'Posizione utente aggiornata correttamente',    32),
        ('User Location not Updated Successfully',  'User Location not Updated Successfully',   'it_it',    'Posizione utente non aggiornata correttamente',    32),
        ('SMSNotifier is not enable in CRM. Please enable it first',    'SMSNotifier is not enable in CRM. Please enable it first', 'it_it',    'SMSNotifier non è abilitato nel CRM. Per favore abilitalo prima',  32),
        ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'it_it',    'Non è stato possibile inviare il tuo feedback - Per favore riprova più tardi', 32),
        ('Thank you for submitting your feedback',  'Thank you for submitting your feedback',   'it_it',    'Grazie per aver inviato il tuo feedback',  32),
        ('Please upload User Image',    'Please upload User Image', 'it_it',    'Per favore carica la foto Utente', 32),
        ('Image Not Uploading, please try again',   'Image Not Uploading, please try again',    'it_it',    'Foto non caricata, per favore riprova',    32),
        ('User Image Uploaded Successfully',    'User Image Uploaded Successfully', 'it_it',    'Immagine utente caricata con successo',    32),
        ('Invalid Module name', 'Invalid Module name',  'it_it',    'Nome modulo non valido',   32),
        ('Records Sync Successfully',   'Records Sync Successfully',    'it_it',    'Record sincronizzati con successo',    32),
        ('Values cannot be empty',  'Values cannot be empty',   'it_it',    'I valori non possono essere vuoti',    32),
        ('Record id is empty',  'Record id is empty',   'it_it',    'L\'ID del record è vuoto', 32),
        ('Logout Successfully', 'Logout Successfully',  'it_it',    'Logout eseguito con successo', 32),
        ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'it_it',    'Abilita il modulo CTMobile',   32),
        ('Authentication Failed',   'Username and Password do not match',   'it_it',    'Nome utente e password non corrispondono', 32),
        ('Mismatched module information',   'Something gone wrong, please try again later', 'it_it',    'Qualcosa è andato storto, riprova più tardi',  32),
        ('Field does not exists',   'Please set display fields again',  'it_it',    'Si prega di impostare nuovamente i campi visualizzati',    32),
        ('Module does not exists',  'Module does not exists or disabled by admin',  'it_it',    'Il modulo non esiste o è disabilitato dall\'amministratore',   32),
        ('Month cannot be empty',   'Could not get the Month - Try again later',    'it_it',    'Impossibile ottenere il mese. Riprova più tardi',  32),
        ('Year cannot be empty',    'Could not get the Year - Try again later', 'it_it',    'Impossibile ottenere l\'anno. Riprova più tardi',  32),
        ('Date cannot be empty',    'Could not get the Date - Try again later', 'it_it',    'Impossibile ottenere la data. Riprova più tardi',  32),
        ('Userid cannot be empty',  'Could not get the Userid - Try again later',   'it_it',    'Impossibile ottenere l\'ID utente - Riprova più tardi',    32),
        ('End Date cannot be empty',    'Could not get the status - Try again later',   'it_it',    'Impossibile ottenere lo stato - Riprova più tardi',    32),
        ('Start Date cannot be empty',  'Could not get the Start Date - Try again later',   'it_it',    'Impossibile ottenere la data di inizio. Riprova più tardi',    32),
        ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'it_it',    'Non hai configurato l\'SMS Notifier nel CRM. Configura l\'SMS Notifier nel tuo CRM per utilizzare questa funzione',    32),
        ('Longitude cannot be empty',   'Could not get location-Please try again',  'it_it',    'Impossibile ottenere la posizione. Riprova',   32),
        ('Latitude cannot be empty',    'Could not get location-Please try again',  'it_it',    'Impossibile ottenere la posizione. Riprova',   32),
        ('User cannot be empty',    'Could not get the User - Try again later', 'it_it',    'Impossibile ottenere l\'utente - Riprova più tardi',   32),
        ('Status cannot be empty',  'Could not get the status - Try again later',   'it_it',    'Impossibile ottenere lo stato - Riprova più tardi',    32),
        ('Required fields not found',   'Required fields not found',    'it_it',    'Campi obbligatori non trovati',    32),
        ('Tracking module not active',  'Tracking module not active-Please contact CRM Admin',  'it_it',    'Modulo di monitoraggio non attivo - Contatta l\'admin del CRM',    32),
        ('Missing mandatory input values',  'Missing mandatory input values',   'it_it',    'Valori di input obbligatori mancanti', 32),
        ('No MailBox found. Please Create Mailbox', 'No MailBox found. Please Create Mailbox',  'it_it',    'Nessuna Mailbox trovata. Crea una Mailbox',    32),
        ('Mail not sent',   'Mail not sent',    'it_it',    'Mail non inviata', 32),
        ('Mail send successfully',  'Mail send successfully',   'it_it',    'Mail inviata con successo',    32),
        ('Email Id or username not match with your record', 'Email Id or username not match with your record',  'it_it',    'L\'ID e-mail o il nome utente non corrispondono al tuo record',    32),
        ('Module not specified',    'Module not specified', 'it_it',    'Modulo non specificato',   32),
        ('No messages found',   'No messages found',    'it_it',    'Nessun messaggio trovato', 32),
        ('No Dependency Found For This Module', 'No Dependency Found For This Module',  'it_it',    'Nessuna dipendenza trovata per questo modulo', 32),
        ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'it_it',    'Il server in uscita non è abilitato',  32),
        ('Outgoing server is Enabled',  'Outgoing server is Enabled',   'it_it',    'Il server in uscita è abilitato',  32),
        ('Email Attached Successfully', 'Email Attached Successfully',  'it_it',    'Email allegata con successo',  32),
        ('Documents Attached Successfully', 'Documents Attached Successfully',  'it_it',    'Documenti allegati correttamente', 32),
        ('Login required - Please login again', 'Login required - Please login again',  'it_it',    'Login richiesto - Effettua nuovamente il login',   32),
        ('time_tracking_module_disable',    'Time tracking module is disable',  'it_it',    'Il modulo di monitoraggio del tempo è disabilitato',   31),
        ('route_planning_module_disable',   'Route planning module is disable', 'it_it',    'Il modulo di pianificazione del percorso è disabilitato',  31),
        ('mark_as_held',    'Are you sure you want to mark Event as Held?', 'it_it',    'Sei sicuro di voler contrassegnare l\'evento come Tenuto?',    31),
        ('stop_timer_msg',  'You have already started Time tracking for another record, Do you want to stop it first ?',    'it_it',    'Hai già avviato il monitoraggio del tempo per un altro record. Vuoi interromperlo prima?', 31),
        ('access_denied_routeplanning', 'Access denied for route planning', 'it_it',    'Accesso negato per la pianificazione del percorso',    31),
        ('time_spent',  'Time Spent',   'it_it',    'Tempo impiegato',  31),
        ('select_user', 'Select User',  'it_it',    'Seleziona Utente', 30),
        ('status_cannot_be_held',   'Status cannot be held for future date start',  'it_it',    'Lo stato non può essere mantenuto per l\'inizio della data futura',    30),
        ('please_select_end_date',  'Please select end date',   'it_it',    'Seleziona la data di fine',    30),
        ('please_select_start_date',    'Please select start date', 'it_it',    'Seleziona la data di inizio',  30),
        ('tap_on_plus_icon_for_select_route',   'Tap on + icon to select record for your route.',   'it_it',    'Toccare l\'icona + per selezionare il record per il percorso.',    30),
        ('please_enter_notes',  'Please enter notes',   'it_it',    'Si prega di inserire note',    30),
        ('please_enter_title',  'Please enter title',   'it_it',    'Si prega di inserire il titolo',   30),
        ('please_select_date',  'Please Select Date',   'it_it',    'Seleziona la data',    30),
        ('search_by_date',  'Search by Date',   'it_it',    'Cerca per data',   30),
        ('shortcut_not_setup_yet',  'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  'it_it',    'Scorciatoia Opps non ancora configurata !!! Aggiungere un collegamento facendo clic su [icona] dai risultati di ricerca dei record o visualizzare la schermata di registrazione.', 30),
        ('max_upload_size', 'max file Upload exceeds',  'it_it',    'il caricamento massimo del file supera',   30),
        ('unselect_all',    'UnSelect All', 'it_it',    'Deseleziona tutto',    30),
        ('select_all',  'Select All',   'it_it',    'Seleziona tutto',  30),
        ('please_select_records',   'Please select records',    'it_it',    'Seleziona i record',   30),
        ('select_date', 'Select Date',  'it_it',    'Seleziona la data',    30),
        ('quantity_in_stock_is',    'Quantity in stock is', 'it_it',    'La quantità in magazzino è',   30),
        ('replies', 'Replies',  'it_it',    'Risposte', 30),
        ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'it_it',    'La conversione richiede la selezione del Contatto o dell\'Organizzazione', 30),
        ('please_select_product',   'Please Select Product',    'it_it',    'Seleziona un prodotto',    30),
        ('timer_msg',   'You can start timer for single task only at same time',    'it_it',    'È possibile avviare il timer per una singola attività solo allo stesso tempo', 31),
        ('save_start_tracking', 'Save & Start Tracking',    'it_it',    'Salva e avvia il monitoraggio',    31),
        ('lbl_notes',   'Notes',    'it_it',    'Appunti',  31),
        ('enter_title', 'Enter Title',  'it_it',    'Inserire il titolo',   31),
        ('select_module_record',    'Select Module / Record',   'it_it',    'Seleziona Modulo / Registra',  31),
        ('lbl_tomorrow',    'Tomorrow', 'it_it',    'Domani',   30),
        ('lbl_yesterday',   'Yesterday',    'it_it',    'Ieri', 30),
        ('lbl_today',   'Today',    'it_it',    'Oggi', 30),
        ('time_tracker',    'Time Tracker', 'it_it',    'Tracciatore del tempo',    31),
        ('time_end',    'End Time', 'it_it',    'Ora di fine',  5),
        ('due_date',    'End Date', 'it_it',    'Data di fine', 5),
        ('time_start',  'Time Start',   'it_it',    'Ora inizio',   5),
        ('date_start',  'Start Date',   'it_it',    'Data di inizio',   5),
        ('delete_widget_msg',   'Display widget again by using (+) option', 'it_it',    'Visualizza nuovamente il widget utilizzando l\'opzione (+)',   15),
        ('no_upcoming_activities',  'No scheduled activities ', 'it_it',    'Nessuna attività programmata', 15),
        ('check_in_first',  'Please check-in first',    'it_it',    'Effettua prima il check-in',   30),
        ('duration',    'Duration', 'it_it',    'Durata',   30),
        ('distance',    'Distance', 'it_it',    'Distanza', 30),
        ('proper_address_message',  'Please enter proper address in record\n',  'it_it',    'Immettere l\'indirizzo corretto nel record',   30),
        ('select_status',   'Select Status',    'it_it',    'Seleziona Stato',  30),
        ('route_planner',   'Route Planner',    'it_it',    'Pianificatore dell\'itinerario',   30),
        ('route_planning',  'Route Planning',   'it_it',    'Pianificazione dell\'itinerario',  30),
        ('add_route',   'Add Route',    'it_it',    'Aggiungi itinerario',  30),
        ('calender_disabled',   'Calendar Module is disabled',  'it_it',    'Il modulo calendario è disabilitato',  30),
        ('close_dialog',    'Close form',   'it_it',    'Chiudi modulo',    30),
        ('cancel_form_message', 'Are You sure want to close ?', 'it_it',    'Sei sicuro di voler chiudere?',    30),
        ('create_route',    'Create Route', 'it_it',    'Crea itinerario',  30),
        ('select_module_create_route',  'Select Module to create Route',    'it_it',    'Seleziona Modulo per creare l\'itinerario',    30),
        ('cancel',  'Cancel',   'it_it',    'Annulla',  30),
        ('assign_route',    'Assign Route', 'it_it',    'Assegna itinerario',   30),
        ('route_for',   'Route for',    'it_it',    'Itinerario per',   30),
        ('assigned_to', 'Assigned To',  'it_it',    'Assegnato a',  30),
        ('enter_route_name',    'Enter Route Name', 'it_it',    'Immettere il nome dell\'itinerario',   30),
        ('list',    'List', 'it_it',    'Elenco',   30),
        ('map', 'Map',  'it_it',    'Mappa',    30),
        ('other_modules',   'Other Modules',    'it_it',    'Altri moduli', 15),
        ('shortcut_no_record_msg',  'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 'it_it',    'Collegamento Opps non configurato ancora!!! Aggiungi un collegamento facendo clic sull\'icona + dal record\n                  risultati della ricerca o visualizza la schermata di registrazione. ',   25),
        ('clear',   'Clear',    'it_it',    'Svuota',   25),
        ('open',    'Open', 'it_it',    'Apri', 11),
        ('max_file_msg',    'Too many files selected (max:6)',  'it_it',    'Troppi file selezionati (max: 6)', 11),
        ('error_voicenote_record',  'Unable to recording voice while another application is recording sound.',  'it_it',    'Impossibile registrare la voce mentre un\'altra applicazione sta registrando il suono.',   11),
        ('msg_warning', 'Warning!', 'it_it',    'Attenzione!',  11),
        ('Permision_denied_contact',    'Permission denied to access your contacts',    'it_it',    'Autorizzazione negata per accedere ai tuoi contatti',  15),
        ('no_widget_added', 'Please click + icon to add new widget to your dashboard.', 'it_it',    'Fare clic sull\'icona + per aggiungere un nuovo widget alla dashboard.',   15),
        ('no_data_available',   'Data not available, please check the selected fields', 'it_it',    'Dati non disponibili, verificare i campi selezionati', 15),
        ('check_out_successfully',  'Check out successfully',   'it_it',    'Check out con successo',   11),
        ('check_in_successfully',   'Check in successfully',    'it_it',    'Check in con successo',    11),
        ('check_out',   'Check out',    'it_it',    'Guardare', 11),
        ('check_in',    'Check in', 'it_it',    'Registrare',   11),
        ('navigate',    'Navigate', 'it_it',    'Naviga',   11),
        ('save_to_phone_vcard_success', 'VCard Saved to phone successfully',    'it_it',    'VCard salvata correttamente nel telefono', 15),
        ('download_vcard_success',  'VCard downloaded successfully',    'it_it',    'VCard scaricata con successo', 15),
        ('card_details',    'Card Details', 'it_it',    'Estremi della carta',  15),
        ('add_widget',  'Add Widget',   'it_it',    'Aggiungi widget',  15),
        ('delete_widget',   'Are you sure to hide widget?', 'it_it',    'Sei sicuro di nascondere il widget?',  15),
        ('already_widgets_added',   'All types of Widget & reports are already added',  'it_it',    'Tutti i tipi di widget e report sono già aggiunti',    15),
        ('retry',   'Retry',    'it_it',    'Riprova',  28),
        ('retake',  'Retake',   'it_it',    'Ripeti',   28),
        ('Reports', 'Reports',  'it_it',    'Rapporti', 15),
        ('Widgets', 'Widgets',  'it_it',    'Widget',   15),
        ('vcard_config',    'Vcard Configuration',  'it_it',    'Configurazione Vcard', 8),
        ('save_to_phone',   'Save to phone',    'it_it',    'Salva sul telefono',   11),
        ('download_vcard',  'Download Vcard',   'it_it',    'Scarica Vcard',    11),
        ('share_vcard', 'Share Vcard',  'it_it',    'Condividi Vcard',  11),
        ('share_record',    'Share Record', 'it_it',    'Condividi record', 11),
        ('permission_denied_edit',  'You don\'t have permission to edit this record.',  'it_it',    'Non hai l\'autorizzazione per modificare questo record.',  27),
        ('permission_denied_delete',    'You don\'t have permission to delete this record.',    'it_it',    'YNon hai l\'autorizzazione per eliminare questo record.',  27),
        ('Voice_Recording_Started', 'Recording Started',    'it_it',    'Registrazione avviata',    12),
        ('Voice_Recording_Stopped', 'Recording Stopped',    'it_it',    'Registrazione interrotta', 12),
        ('SEARCH',  'Search',   'it_it',    'Cerca',    7),
        ('LAST',    'Last', 'it_it',    'Ultimo',   7),
        ('FIRST',   'First',    'it_it',    'Primo',    7),
        ('MONDAY',  'Monday',   'it_it',    'Lunedi',   7),
        ('TUESDAY', 'Tuesday',  'it_it',    'martedì',  7),
        ('WEDNESDAY',   'Wednesday',    'it_it',    'mercoledì',    7),
        ('THURSDAY',    'Thursday', 'it_it',    'giovedi',  7),
        ('FRIDAY',  'Friday',   'it_it',    'Venerdì',  7),
        ('SATURDAY',    'Saturday', 'it_it',    'Sabato',   7),
        ('SUNDAY',  'Sunday',   'it_it',    'Domenica', 7),
        ('DAILY',   'Daily',    'it_it',    'Giornaliero',  7),
        ('WEEKLY',  'Weekly',   'it_it',    'Settimanale',  7),
        ('MONTHLY', 'Monthly',  'it_it',    'Mensile',  7),
        ('YEARLY',  'Yearly',   'it_it',    'Annuale',  7),
        ('asset_tracking',  'Asset tracking',   'it_it',    'Monitoraggio risorse', 15),
        ('open_file',   'Open File',    'it_it',    'Apri il file', 1),
        ('download_pdf_successfully',   'Download PDF Successfully',    'it_it',    'Scarica PDF con successo', 1),
        ('select_pdf',  'Select PDF',   'it_it',    'Seleziona PDF',    1),
        ('email_pdf',   'Email PDF',    'it_it',    'Invia PDF via e-mail', 1),
        ('download_pdf',    'Download PDF', 'it_it',    'Scarica il pdf',   1),
        ('edit_route',  'Edit Route',   'it_it',    'Modifica percorso',    1),
        ('save_route',  'Save Route',   'it_it',    'Salva percorso',   1),
        ('clear_all',   'Clear All',    'it_it',    'Cancella tutto',   1),
        ('notification',    'Notifications',    'it_it',    'Notifiche',    1),
        ('menu_management', 'Menu Management',  'it_it',    'Gestione dei menù',    1),
        ('select_menu', 'Select Menu',  'it_it',    'Seleziona Menù',   1),
        ('module_record_not_found', 'Module and Record not found',  'it_it',    'Modulo e record non trovati',  1),
        ('reason_for_changing_comments',    'Reason for changing comments', 'it_it',    'Motivo per modificare i commenti', 1),
        ('edit_reason', 'Edit Reason',  'it_it',    'Modifica motivo',  1),
        ('create_filters',  'Create Filter',    'it_it',    'Crea filtro',  1),
        ('you_checked', 'You Checked',  'it_it',    'Hai controllato',  1),
        ('you_un_checked',  'You UnChecked',    'it_it',    'Hai deselezionato',    1),
        ('log_the_call',    'Log the call ?',   'it_it',    'Registrare la chiamata?',  1),
        ('add_a_description_(optional)',    'Add a description (optional)', 'it_it',    'Aggiungi una descrizione (facoltativo)',   1),
        ('called',  'Called',   'it_it',    'Chiamato', 1),
        ('call_log',    'Call Log', 'it_it',    'Registro chiamate',    1),
        ('subject', 'Subject',  'it_it',    'Soggetta', 1),
        ('add_condition',   'Add Condition',    'it_it',    'Aggiungi condizione',  1),
        ('select_condition',    'Select Condition', 'it_it',    'Seleziona Condizione', 1),
        ('select_field',    'Select Field', 'it_it',    'Seleziona Campo',  1),
        ('please_select_first_field',   'Please First Select field',    'it_it',    'Per favore seleziona prima il campo',  1),
        ('filter_name', 'Filter Name',  'it_it',    'Nome del filtro',  1),
        ('enter_filter_name',   'Enter filter name',    'it_it',    'Inserisci il nome del filtro', 1),
        ('choose_conditions',   'Choose Conditions',    'it_it',    'Scegli Condizioni',    1),
        ('all_condition',   'All Conditions(All conditions must be met)',   'it_it',    'Tutte le condizioni (tutte le condizioni devono essere soddisfatte)',  1),
        ('any_condition',   'Any Conditions(At least one the conditions must be met)',  'it_it',    'Qualsiasi condizione (almeno una condizione deve essere soddisfatta)', 1),
        ('lattitude',   'latitude', 'it_it',    'latitudine',   1),
        ('notification_settings',   'Notification Settings',    'it_it',    'Impostazioni di notifica', 1),
        ('notification_management', 'Notification Management',  'it_it',    'Gestione delle notifiche', 1),
        ('addyourcommentshere', 'Type @ to mention user',   'it_it',    'Digita @ per menzionare l\'utente',    1),
        ('google_api_key_missing',  'Google Api key is missing.',   'it_it',    'Manca la chiave API di Google.',   1),
        ('event_filter_by', 'Event Filter by',  'it_it',    'Evento Filtra per',    1),
        ('apply',   'Apply',    'it_it',    'Fare domanda a',   1),
        ('choose_from_gallery', 'Choose From Gallery',  'it_it',    'Scegli dalla Galleria',    1),
        ('choose_from_camera',  'Choose From Camera',   'it_it',    'Scegli dalla fotocamera',  1),
        ('mutli_select_CB', 'Mutli Select CB',  'it_it',    'CB a selezione multipla',  1),
        ('please_select_condition', 'Please Select Condition',  'it_it',    'Seleziona la condizione',  1),
        ('please_enter_value_or_field', 'Please Enter Value or Field',  'it_it',    'Inserisci un valore o un campo',   1),
        ('set_as_default',  'Set as Default',   'it_it',    'Imposta come predefinito', 1),
        ('list_in_metrics', 'List in Metrics',  'it_it',    'Elenco in Metriche',   1),
        ('order_number',    'Order Number', 'it_it',    'Numero d\'ordine', 1),
        ('recording_saved_message', 'Recording saved successfully.',    'it_it',    'Registrazione salvata correttamente.', 1),
        ('recording_file',  'Recording File',   'it_it',    'File di registrazione',    1),
        ('file_not_found',  'File not found',   'it_it',    'File non trovato', 1),
        ('please_enter_valid_path', 'Please enter valid path',  'it_it',    'Inserisci un percorso valido', 1),
        ('enter_path_here', 'Enter path here...',   'it_it',    'Inserisci il percorso qui...', 1),
        ('set_call_recording_path', 'Set Call Recording Path',  'it_it',    'Imposta il percorso di registrazione delle chiamate',  1),
        ('set_call_recording_path_here',    'Set call recording path here', 'it_it',    'Imposta qui il percorso di registrazione delle chiamate',  1),
        ('call_recording_path', 'Call Recording Path',  'it_it',    'Percorso di registrazione della chiamata', 1),
        ('please_place_api',    'Please enable place api',  'it_it',    'Abilita Place API',    1),
        ('event_filters_by',    'Event Filters by', 'it_it',    'Filtri eventi per',    1),
        ('select_at_least_one_option',  'Please select at least one option',    'it_it',    'Seleziona almeno un\'opzione', 1),
        ('enable_call_feature', 'Please enable call feature',   'it_it',    'Si prega di abilitare la funzione di chiamata',    1),
        ('enable_email_feature',    'Please enable email feature',  'it_it',    'Si prega di abilitare la funzione e-mail', 1),
        ('demo_login',  'Demo Login',   'it_it',    'Accesso dimostrativo', 1),
        ('select_email_template',   'Select Email Template',    'it_it',    'Seleziona modello di posta elettronica',   1),
        ('template_name',   'Template Name',    'it_it',    'Nome modello', 1),
        ('example_storage_path',    'example : storage/Music/Recordings/Call Recordings',   'it_it',    'esempio: archiviazione/Musica/Registrazioni/Registrazioni chiamate',   1),
        ('User Notification Settings saved successfully',   'User Notification Settings saved successfully',    'it_it',    'Impostazioni di notifica utente salvate correttamente',    33),
        ('This Notification has been disabled by admin',    'This Notification has been disabled by admin', 'it_it',    'Questa notifica è stata disabilitata dall\'amministratore',    33),
        ('Notify when any updates to the record you\'re following', 'Notify when any updates to the record you\'re following',  'it_it',    'Avvisa eventuali aggiornamenti al record che stai seguendo',   33),
        ('Task assigned to you',    'Task assigned to you', 'it_it',    'Compito assegnato a te',   33),
        ('Task Reminder',   'Task Reminder',    'it_it',    'Promemoria attività',  33),
        ('You were mentioned in comments',  'You were mentioned in comments',   'it_it',    'Sei stato menzionato nei commenti',    33),
        ('Comments has been added to record assigned to you',   'Comments has been added to record assigned to you',    'it_it',    'I commenti sono stati aggiunti al record assegnato a te',  33),
        ('When Record Assigned',    'When Record Assigned', 'it_it',    'Quando viene assegnato il record', 33),
        ('Event Reminder',  'Event Reminder',   'it_it',    'Promemoria evento',    33),
        ('Event Invitation',    'Event Invitation', 'it_it',    'Invito all\'evento',   33),
        ('Follow record',   'Follow record',    'it_it',    'Segui la registrazione',   33),
        ('Task',    'Task', 'it_it',    'Compito',  33),
        ('Conversions', 'Conversions',  'it_it',    'Conversioni',  33),
        ('Events',  'Events',   'it_it',    'Eventi',   33),
        ('no_records_changed_filter_message',   'No record(s) found Please click on filter icon to change filter',  'it_it',    'Nessun record trovato. Fare clic sull\'icona del filtro per modificare il filtro', 1),
        ('title',   'Title',    'it_it',    'Titolo',   1),
        ('dialog_recent_call_info', 'Click + to select your mobile call recording folder where your recorded call files are stored.',   'it_it',    'Fare clic su + per selezionare la cartella di registrazione delle chiamate su cellulare in cui sono archiviati i file delle chiamate registrate.', 1),
        ('call_recording',  'Call recording',   'it_it',    'Registrazione delle chiamate', 1),
        ('voice_recorder',  'Voice Recorder',   'it_it',    'Registratore vocale',  1),
        ('no_address_reference_found',  'No Address Reference found',   'it_it',    'Nessun riferimento all\'indirizzo trovato',    32),
        ('no_overdue_activities',   'No OverDue Activities',    'it_it',    'Nessuna attività scaduta', 32),
        ('latitude_longitude_validation_message',   'Please enter proper address from this address we are not getting proper latitude and longitude',   'it_it',    'Inserisci l\'indirizzo corretto da questo indirizzo, non riceviamo la latitudine e la longitudine corrette',   32),
        ('Default_Search_Field',    'Default search field', 'it_it',    'Campo di ricerca predefinito', 32),
        ('Calender_Reminder_Message',   'Free user can\'t send local reminder', 'it_it',    'L\'utente gratuito non può inviare promemoria locale', 32),
        ('you_must_have_permission',    'You must give permissions to use this features.',  'it_it',    'È necessario fornire le autorizzazioni per utilizzare queste funzionalità.',   32),
        ('internal_comment',    'Internal Comment', 'it_it',    'Commento interno', 1),
        ('unlink_record',   'Unlink Record',    'it_it',    'Scollega registrazione',   11),
        ('unlink_record_msg',   'Are you sure want to unlink record?',  'it_it',    'Sei sicuro di voler scollegare il record?',    11),
        ('file_format_not_support', 'File format not supported',    'it_it',    'Formato file non supportato',  11),
        ('file_upload', 'File Upload',  'it_it',    'Upload di file',   5),
        ('to_vtiger',   'To Vtiger',    'it_it',    'A Vtiger', 5),
        ('link_external_document',  'Link External Document',   'it_it',    'Collega documento esterno',    5),
        ('from_file_url',   'From File Url',    'it_it',    'Dall\'URL del file',   5),
        ('create_new_document', 'Create New Document',  'it_it',    'Crea nuovo documento', 5),
        ('select_document_type',    'Select Document type', 'it_it',    'Seleziona Tipo di documento',  5),
        ('add_signature',   'Please add signature', 'it_it',    'Per favore aggiungi la firma', 11),
        ('date_greater_then_equal', 'should be greater than or equal to',   'it_it',    'dovrebbe essere maggiore o uguale a',  1),
        ('date_less_then_equal',    'should be less than or equal to',  'it_it',    'dovrebbe essere inferiore o uguale a', 1),
        ('Click_on_plus_for_add',   'Please tap on  +  to create a new record.',    'it_it',    'Tocca + per creare un nuovo record.',  15),
        ('display_map', 'Display map',  'it_it',    'Visualizza la mappa',  15),
        ('other_settings',  'Other settings',   'it_it',    'Altre impostazioni',   15),
        ('total_hours', 'Total hours',  'it_it',    'Ore totali',   15),
        ('widget_not_found',    'No widgets found', 'it_it',    'Nessun widget trovato',    15),
        ('quickaction', 'Quick action', 'it_it',    'Azione rapida',    15),
        ('dashboard',   'Dashboard',    'it_it',    'Pannello di controllo',    15),
        ('new', 'New',  'it_it',    'Nuova',    15),
        ('global_search_hint',  'Please try to search using search box at top', 'it_it',    'Prova a cercare utilizzando la casella di ricerca in alto',    15),
        ('near_by_map', 'Near By Map',  'it_it',    'Vicino tramite mappa', 15),
        ('miles',   'Miles',    'it_it',    'Miglia',   15),
        ('lbl_filters', 'Filters',  'it_it',    'Filtri',   27),
        ('warning', 'Warning',  'it_it',    'Avvertimento', 27),
        ('no_filter_created',   'No filter is created.',    'it_it',    'Non viene creato alcun filtro.',   27),
        ('please_create_new_ilter', 'Please create a new filter',   'it_it',    'Per favore crea un nuovo filtro',  27),
        ('select_search_fields',    'Select fields for the search record.', 'it_it',    'Seleziona i campi per il record di ricerca.',  27),
        ('apply_fliters',   'Apply filters',    'it_it',    'Applica filtri',   27),
        ('sort_by', 'Sort by',  'it_it',    'Ordina per',   27),
        ('sort_order',  'Sort order',   'it_it',    'Ordinamento',  27),
        ('Start_time_tracking', 'Start time tracking',  'it_it',    'Avvia il monitoraggio del tempo',  31),
        ('Stop_time_tracking',  'Stop time tracking',   'it_it',    'Interrompi il monitoraggio del tempo', 31),
        ('image_preview',   'Image preview',    'it_it',    'Anteprima dell\'immagine', 11),
        ('phone_number',    'Phone number', 'it_it',    'Numero di telefono',   11),
        ('email_address',   'Email address',    'it_it',    'Indirizzo e-mail', 11),
        ('edit_your_preferences',   'Edit your preferences',    'it_it',    'Modifica le tue preferenze',   8),
        ('about_app',   'About app',    'it_it',    'Informazioni sull\'app',   8),
        ('updated_ctmobile_ext_version',    'You already have latest CTMobile Ext. Version',    'it_it',    'Hai già l\'ultima versione di CTMobile Ext. Versione', 8),
        ('updated_app_version', 'You already have latest CRMTiger App Version', 'it_it',    'Hai già l\'ultima versione dell\'app CRMTiger',    8),
        ('plan',    'Plan', 'it_it',    'Piano',    8),
        ('time',    'Time', 'it_it',    'Tempo',    31),
        ('error_log_msg',   'Oops, something went wrong! Please click on Share Button to share error log with our technical team',  'it_it',    'Oops! Qualcosa è andato storto! Fare clic sul pulsante Condividi per condividere il registro degli errori con il nostro team tecnico', 1),
        ('add_to_quick_action', 'Add to quick action',  'it_it',    'Aggiungi all\'azione rapida',  1),
        ('add_filter_to_quick_action',  'Add filter to quick action',   'it_it',    'Aggiungi filtro all\'azione rapida',   1),
        ('create_record',   'Create Record',    'it_it',    'Crea registrazione',   1),
        ('quick_action_hint',   'You can Add Quick Action here',    'it_it',    'Puoi aggiungere un\'azione rapida qui',    1),
        ('str_send',    'Send', 'it_it',    'Inviare',  3),
        ('tax_region_msg',  'Do you want to update tax & charge values corresponding to selected region?',  'it_it',    'Vuoi aggiornare i valori di tasse e addebiti corrispondenti alla regione selezionata?',    1),
        ('delete_quick_action_widgest', 'Delete Widget?',   'it_it',    'Eliminare il widget?', 15),
        ('add_record_to_dashboard', 'Add record to dashboard',  'it_it',    'Aggiungi record alla dashboard',   15),
        ('module_quick_action_msg', 'Module added to dashboard',    'it_it',    'Modulo aggiunto alla dashboard',   15),
        ('filter_quick_action_msg', 'Filter added to dashboard',    'it_it',    'Filtro aggiunto alla dashboard',   15),
        ('record_quick_action_msg', 'Record added to dashboard',    'it_it',    'Record aggiunto alla dashboard',   15),
        ('filter_shortcut_quick_action_msg',    'Filter shortcut added to dashboard',   'it_it',    'Collegamento al filtro aggiunto alla dashboard',   15),
        ('record_shortcut_quick_action_msg',    'Record shortcut added to dashboard',   'it_it',    'Scorciatoia per la registrazione aggiunta alla dashboard', 15),
        ('documents_disabled',  'Documents Module is disabled', 'it_it',    'Il Modulo Documenti è disabilitato',   1),
        ('document_dont_attachment',    'Document does not have a attachment',  'it_it',    'Il documento non ha allegati', 1),
        ('go_to_neat_by',   'Go to NearBy', 'it_it',    'Vai a Nelle vicinanze',    15),
        ('go_to_time_tracking', 'Go to Time Tracker',   'it_it',    'Vai a Time Tracker',   13),
        ('nearby_quick_action_msg', 'NearBy added to dashboard',    'it_it',    'NearBy aggiunto alla dashboard',   15),
        ('time_tracking_quick_action_msg',  'Time Tracking added to dashboard', 'it_it',    'Monitoraggio del tempo aggiunto alla dashboard',   15),
        ('attendance_quick_action_msg', 'Attendance added to dashboard',    'it_it',    'Presenze aggiunte alla dashboard', 15),
        ('attachment',  'Attachment',   'it_it',    'Allegato', 15),
        ('search_by_fields',    'Search by fields', 'it_it',    'Cerca per campi',  27),
        ('apply_selected',  'Apply selected',   'it_it',    'Applica selezionato',  27),
        ('auto_address_disabled',   'auto address finder is disabled, please enable it from CRMTiger Settings', 'it_it',    'la ricerca automatica degli indirizzi è disabilitata, abilitala dalle Impostazioni CRMTiger',  1),
        ('Attendance',  'Attendance',   'it_it',    'Partecipazione',   15),
        ('Check-in successfully',   'Check-in successfully',    'it_it',    'Check-in avvenuto con successo',   32),
        ('Check-out successfully',  'Check-out successfully',   'it_it',    'Check-out riuscito',   32),
        ('Nothing around here', 'Nothing around here',  'it_it',    'Niente da queste parti',   13),
        ('select_days', 'Select Days',  'it_it',    'Seleziona Giorni', 5),
        ('select_minutes',  'Select Minutes',   'it_it',    'Seleziona Minuti', 5),
        ('select_hours',    'Select Hours', 'it_it',    'Seleziona Orari',  5),
        ('no_lat_long_found',   'Location information (Latitude,Longitude) not found',  'it_it',    'Informazioni sulla posizione (latitudine, longitudine) non trovate',   32),
        ('Call Log save successfully',  'Call Log save successfully',   'it_it',    'Registro chiamate salvato correttamente',  32),
        ('Files/photos deleted successfully',   'Files/photos deleted successfully',    'it_it',    'File/foto eliminati correttamente',    32),
        ('important',   'Important',    'it_it',    'Importante',   34),
        ('template',    'Template', 'it_it',    'Modello',  34),
        ('copy',    'Copy', 'it_it',    'copia',    34),
        ('camera',  'Camera',   'it_it',    'Telecamera',   34),
        ('gallery', 'Gallery',  'it_it',    'Galleria', 34),
        ('audio',   'Audio',    'it_it',    'Audio',    34),
        ('last_seen_at',    'Last seen at', 'it_it',    'Ultimo accesso alle',  34),
        ('type_a_message',  'Type a message',   'it_it',    'Scrivi un messaggio',  34),
        ('all_messages',    'All messages', 'it_it',    'Tutti i messaggi', 34),
        ('time_tracking_reports',   'Time tracking reports',    'it_it',    'Rapporti sul monitoraggio del tempo',  31),
        ('attendance_reports',  'Attendance reports',   'it_it',    'Rapporti sulle presenze',  31),
        ('chats',   'Chats',    'it_it',    'Chat', 34),
        ('Marked chat as Important',    'Marked chat as Important', 'it_it',    'Chat contrassegnata come importante',  34),
        ('Unmarked chat as Important',  'Unmarked chat as Important',   'it_it',    'Chat non contrassegnata come importante',  34),
        ('mark_as_important',   'Mark as important',    'it_it',    'Segna come importante',    34),
        ('unmark_As_important', 'Unmark as important',  'it_it',    'Deseleziona come importante',  34),
        ('select_template', 'Select template',  'it_it',    'Seleziona modello',    34),
        ('chat',    'Chat', 'it_it',    'Chiacchierata',    34),
        ('search_by_name_or_contact',   'Search by name or contact',    'it_it',    'Cerca per nome o contatto',    34),
        ('choose_contact_for_whatsApp', 'Choose contact for whatsApp',  'it_it',    'Scegli il contatto per WhatsApp',  34),
        ('whatsapp_template',   'Whatsapp template',    'it_it',    'Modello di WhatsApp',  34),
        ('send_voice_recording',    'Send voice recording', 'it_it',    'Invia la registrazione vocale',    34),
        ('slide_to_cancel', 'Slide To Cancel',  'it_it',    'Scorri per annullare', 34),
        ('select_priority', 'Select priority',  'it_it',    'Seleziona la priorità',    30),
        ('repeat_route',    'Repeat route', 'it_it',    'Ripeti il ​​percorso', 30),
        ('change_assign_to',    'Change assigned to',   'it_it',    'Modifica assegnata a', 30),
        ('Multiple Route created successfully', 'Multiple Route created successfully',  'it_it',    'Percorso multiplo creato con successo',    30),
        ('Route duplicated successfully',   'Route duplicated successfully',    'it_it',    'Percorso duplicato con successo',  30);",array());
        }
    }


    static function he_il(){
        global $adb;
        $checkLang = $adb->pquery("SELECT 1 FROM ctmobile_language_keyword WHERE keyword_lang = ?",array('he_il'));
        if($adb->num_rows($checkLang) == 0){
        
        $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
        ('network_error',   'Network connection error!',    'he_il',    'בעיה ברשת!',   1),
        ('connection_check',    'Could not connect to CRM, Please check your Internet connection.', 'he_il',    'בדוק את חיבור האינטרנט שלך.',  1),
        ('update',  'Update',   'he_il',    'עדכון',    1),
        ('cancel',  'Cancel',   'he_il',    'בטל',  1),
        ('ok',  'Ok',   'he_il',    'בסדר', 1),
        ('more_information',    'Click here for more information.', 'he_il',    'לחץ כאן למידע נוסף.',  1),
        ('yes', 'Yes',  'he_il',    'כן',   1),
        ('no',  'No',   'he_il',    'לאפס', 1),
        ('click_again_exit',    'Click again to exit',  'he_il',    'לחץ שוב כדי לצאת', 1),
        ('forpermission',   'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.',   'he_il',    'אין לך הרשאה להציג תכונות אלה. נא להירשם לקבלת גירסת Premium לחץ כאן כדי להירשם.', 1),
        ('clickhere',   'Click here',   'he_il',    'לחץ כאן',  1),
        ('clickhere_subscribe', 'Click here to subscribe premium version',  'he_il',    'לחץ כאן כדי להירשם',   1),
        ('clickhere_configure', 'Click here and view how to Configure.',    'he_il',    'לחץ כאן כדי להציג כיצד להגדיר. ל', 1),
        ('please_wait', 'Please Wait…', 'he_il',    'המתן בבקשה…',  1),
        ('share__msg',  'Share file with',  'he_il',    'שיתוף קבצים עם',   1),
        ('dialog_camera',   'Camera',   'he_il',    'מצלמה',    1),
        ('dialog_add_file_by',  'Take Photo from',  'he_il',    'הוסף קבצים לפי',   1),
        ('add', 'Add',  'he_il',    'לְהוֹסִיף',    1),
        ('mail_manager_configured', 'Mail Manager is not configured',   'he_il',    'מנהל הדואר אינו מוגדר',    1),
        ('dialog_add_files_by', 'Add Files by', 'he_il',    'הוסף קבצים לפי',   1),
        ('dialog_drive',    'Drive',    'he_il',    'נהיגה',    1),
        ('dialog_drop_box', 'Drop Box', 'he_il',    'קופסת תיבות',  1),
        ('dialog_need_signin',  'You need to Sign-in to your Drive account first.', 'he_il',    'אתה צריך להיכנס ראשון',    1),
        ('dialog_gallery',  'Gallery',  'he_il',    'גלריה',    1),
        ('delete',  'Delete',   'he_il',    'לִמְחוֹק', 1),
        ('timeoutmessage',  'Oops! Request is taking more time than expected.', 'he_il',    'בקשת אופס אורכת זמן רב מהצפוי.',   1),
        ('gps_location_message',    'GPS is not enabled. Please turn it on to get your near by locations.', 'he_il',    'ה- GPS אינו מופעל. הפעל אותו כדי לקבל את המיקום הקרוב אליך.',  1),
        ('sure_want_delete',    'Are you sure want to delete ?',    'he_il',    'האם אתה בטוח שברצונך למחוק?',  1),
        ('select',  'Select',   'he_il',    'בחר',  1),
        ('msgforrecordaudio',   'Minimum record duration one second.',  'he_il',    'משך רשומה מינימלי שנייה אחת',  1),
        ('permission_storage',  'Permission denied to read your External storage',  'he_il',    'הרשאה נדחתה לקרוא את האחסון החיצוני שלך',  1),
        ('send_permission_msg', 'Send message permission denied',   'he_il',    'שלח אישור הודעה שנדחה',    1),
        ('choosefile',  'Choose File',  'he_il',    'בחר קובץ', 1),
        ('enter',   'Enter',    'he_il',    'להיכנס',   1),
        ('select_an_option',    'Select an Option', 'he_il',    'בחר אפשרות',   1),
        ('email_validation',    'Email is not valid',   'he_il',    'האימייל אינו חוקי',    1),
        ('please_enter',    'Please Enter', 'he_il',    'בבקשה היכנס',  1),
        ('website_validation_text', 'Website URL is not valid', 'he_il',    'כתובת האתר של האתר אינה חוקית',    1),
        ('selectvalue', 'Select value first',   'he_il',    'בחר ערך תחילה',    1),
        ('email',   'Email',    'he_il',    'אֶלֶקטרוֹנִי', 1),
        ('enter_email_address', 'Enter email address',  'he_il',    'הזן כתובת דוא\"ל', 1),
        ('email_address_not_correct',   'Email address incorrect',  'he_il',    'כתובת האימייל שגויה',  1),
        ('pls_enter_subject',   'Please Enter Subject', 'he_il',    'הזן נושא', 1),
        ('attachFiles', 'Attached File',    'he_il',    'קובץ מצורף',   1),
        ('from',    'From', 'he_il',    'מ',    1),
        ('to',  'To',   'he_il',    'ל',    1),
        ('call_permission_msg', 'Call permission denied',   'he_il',    'הרשאת קריאה נדחתה',    1),
        ('no_records',  'No records found', 'he_il',    'לא נמצאו שיאים',   1),
        ('fullform',    'Create New',   'he_il',    'טופס מלא', 1),
        ('save',    'Save', 'he_il',    'להציל',    1),
        ('total',   'Total',    'he_il',    'סך הכל',   1),
        ('discount',    'Discount', 'he_il',    'הנחה', 1),
        ('price',   'Price',    'he_il',    'מחיר *',   1),
        ('quantity',    'Quantity', 'he_il',    'כמות *',   1),
        ('select_module',   'Select Module',    'he_il',    'בחר מודול',    1),
        ('item_list',   'Item List',    'he_il',    'רשימת פריטים', 1),
        ('quickcreate', 'Quick Create', 'he_il',    'יצירה מהירה',  1),
        ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'he_il',    'החלף את הכתובת הקיימת באמצעות הכתובת הנבחרת ', 1),
        ('once_in_every',   'Once in every',    'he_il',    'פעם אחת בכל',  1),
        ('overwrite_msg_part2', 'address details?', 'he_il',    'פרטי כתובת?',  1),
        ('add_item',    'Add Item', 'he_il',    'הוסף פריט',    1),
        ('recordsave',  'Record saved successfully',    'he_il',    'הקלט שמור בהצלחה', 1),
        ('recordnotsave',   'Could not save record. Try again later',   'he_il',    'הרשומה לא תשמור',  1),
        ('minutes', 'Minutes',  'he_il',    'דקות', 1),
        ('hours',   'Hours',    'he_il',    'שעות', 1),
        ('days',    'Days', 'he_il',    'ימים', 1),
        ('on',  'On',   'he_il',    'מופעל',    1),
        ('day_of_the_month',    'day of the month', 'he_il',    'יום החודש',    1),
        ('list_price',  'List Price',   'he_il',    'רשימת מחירים *',   1),
        ('add_record',  'Add Record',   'he_il',    'הוסף רשומה',   1),
        ('add_product', 'Add Product',  'he_il',    'הוסף מוצר',    1),
        ('add_service', 'Add Service',  'he_il',    'הוסף שירות',   1),
        ('discountin',  'Discount in %',    'he_il',    'הנחה ב-%', 1),
        ('unitprice',   'Unit price',   'he_il',    'מחיר ליחידה *',    1),
        ('netprice',    'Net price',    'he_il',    'מחיר נטו *',   1),
        ('comments',    'Comments', 'he_il',    'הערות',    1),
        ('add_close',   'Add & Close',  'he_il',    'הוסף & סגור',  1),
        ('fetching_rout_message',   'Fetching route, Please wait…', 'he_il',    'מאחזר נתיב, המתן …',   1),
        ('setting', 'Settings', 'he_il',    'הגדרות',   1),
        ('utc', 'UTC',  'he_il',    'UTC',  1),
        ('in',  'In',   'he_il',    'ב',    1),
        ('days_ago',    'days ago', 'he_il',    'לפני מספר ימים',   1),
        ('mins_ago',    'Minutes ago',  'he_il',    'לפני דקות',    1),
        ('justnow', 'Just now', 'he_il',    'זֶה עַתָה',    1),
        ('hours_ago',   'hours ago',    'he_il',    'לפני שעות',    1),
        ('in_1_day',    'In 1 day', 'he_il',    'ביום אחד', 1),
        ('scanqrcode',  'Asset / Card Scanner', 'he_il',    'כרטיס סורק',   1),
        ('call_log',    'Call Log', 'he_il',    'יומן שיחות',   1),
        ('voice_message',   'Hi',   'he_il',    'שלום', 1),
        ('voice_message1',  'What can I search for you in', 'he_il',    'מה אוכל לחפש עבורך',   1),
        ('live_tracking',   'Live Tracking',    'he_il',    'מעקב חי',  1),
        ('mailmanager', 'Mail Manager', 'he_il',    'מנהל הדואר',   1),
        ('my_location', 'My location',  'he_il',    'המיקום שלי',   1),
        ('created_on',  'Created On',   'he_il',    'נוצר ב',   1),
        ('modified_on', 'Modified On',  'he_il',    'השתנה',    1),
        ('enter_comments',  'Enter Comments',   'he_il',    'הזן הערות',    1),
        ('viewmore',    'View More',    'he_il',    'ראה עוד',  1),
        ('viewless',    'View Less',    'he_il',    'הצג פחות', 1),
        ('gotofullform',    'Go to Full Form',  'he_il',    'עבור אל טופס מלא', 1),
        ('post',    'Post', 'he_il',    'הודעה',    1),
        ('url', 'URL',  'he_il',    'כתובת אתר',    1),
        ('dialog_title_text_back_color',    'Select a Text Background Color',   'he_il',    'בחר צבע רקע טקסט', 1),
        ('event_or_task',   'Add event/task',   'he_il',    'הוסף אירוע / משימה',   1),
        ('shortcut',    'Shortcuts',    'he_il',    'קיצורי דרך',   1),
        ('select_field',    'Select Field', 'he_il',    'בחר שדה',  1),
        ('share',   'Share',    'he_il',    'שתף',  1),
        ('title_insert_link',   'Insert Link',  'he_il',    'הוסף קישור',   1),
        ('addyourcommentshere', 'Add your comments here',   'he_il',    'הוסף את ההערות שלך כאן',   1),
        ('nocomment',   'No Comments',  'he_il',    'אין תגובה',    1),
        ('leads',   'Leads',    'he_il',    'הובלות',   1),
        ('true_val',    'true', 'he_il',    'נָכוֹן',   1),
        ('noresult',    'No Result',    'he_il',    'אין תוצאה',    1),
        ('version', 'Version',  'he_il',    'גרסה', 1),
        ('convert_lead',    'Convert Lead', 'he_il',    'המרת ליד', 1),
        ('app_name',    'CRMTiger', 'he_il',    'CRMTiger', 1),
        ('enter_url',   'Please Enter url', 'he_il',    'אנא הזן כתובת אתר',    1),
        ('help',    'Help', 'he_il',    'עזרה', 1),
        ('contact_us',  'Contact Us',   'he_il',    'תיצור איתנו קשר',  1),
        ('updates', 'Updates',  'he_il',    'עדכונים',  1),
        ('logout',  'LogOut',   'he_il',    'להתנתק',   1),
        ('busnies_cardscanner', 'Business Card Scanner',    'he_il',    'סורק כרטיסי ביקור',    1),
        ('sure_want_logout',    'Are you sure want to logout ?',    'he_il',    'האם אתה בטוח שברצונך להתנתק?', 1),
        ('logout_message',  'Logout successfully',  'he_il',    'האם אתה בטוח שברצונך להתנתק?', 1),
        ('all', 'All',  'he_il',    'את כל',    1),
        ('add_event',   'Add event',    'he_il',    'הוסף אירוע',   1),
        ('add_task',    'Add Task', 'he_il',    'הוסף משימה',   1),
        ('next',    'Next', 'he_il',    'הבא',  1),
        ('terms_conditions',    'Terms and Conditions', 'he_il',    'תנאים',    1),
        ('login',   'Login',    'he_il',    'התחברות',  2),
        ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy',    'he_il',    'על ידי כניסה, אתה מסכים לתנאים וההגבלות שלנו  מדיניות פרטיות', 2),
        ('copyright',   'Copyright © 2019 CRMTiger Version',    'he_il',    'זכויות יוצרים © 2019 CRMTiger גירסה',  2),
        ('enter_username',  'Please enter username',    'he_il',    'הזן שם משתמש', 2),
        ('enter_password',  'Please enter password',    'he_il',    'הזן סיסמה',    2),
        ('remanberme',  'Remember Me',  'he_il',    'זכור אותי',    2),
        ('forgot_password', 'Forgot password?', 'he_il',    'שכחת את הסיסמא?',  2),
        ('privacy_policay1',    'Privacy Policy',   'he_il',    'מדיניות פרטיות',   2),
        ('contactsupportmsg',   'Something went wrong. \n please Click here to contact support.',   'he_il',    'משהו השתבש אנא לחץ כאן ליצירת קשר עם התמיכה.', 2),
        ('enter_username_password', 'Entered Username or Password is wrong',    'he_il',    'הזן שם משתמש או סיסמה שגוי',   2),
        ('server_issue_occured',    'Server issues occurred',   'he_il',    'אירעו בעיות בשרת', 2),
        ('password',    'Password', 'he_il',    'סיסמה',    3),
        ('user_name',   'Username', 'he_il',    'שם משתמש', 3),
        ('reset_pwd',   'Reset Password',   'he_il',    'לאפס את הסיסמה',   3),
        ('forgot_password_title',   'Forgot password',  'he_il',    'שכחת את הסיסמא',   3),
        ('enter_user_name', 'Enter user name',  'he_il',    'הכנס שם משתמש',    3),
        ('cc',  'Cc',   'he_il',    'עותק', 4),
        ('body',    'Body', 'he_il',    'גוף',  4),
        ('bcc', 'BCC',  'he_il',    'עותק מוסתר',   4),
        ('dialog_title_text_color', 'Select a Text Color',  'he_il',    'בחר צבע טקסט', 4),
        ('date',    'Date', 'he_il',    'תאריך',    4),
        ('subject', 'Subject',  'he_il',    'נושא', 4),
        ('composeMail', 'Compose Mail', 'he_il',    'כתוב דואר',    4),
        ('send',    'Send', 'he_il',    'שלח',  4),
        ('select_message',  'Select message',   'he_il',    'בחר הודעה',    4),
        ('title_insert_table',  'Insert Table', 'he_il',    'הכנס טבלה',    4),
        ('log_file_sms',    'I agree to Share API Log to Technical team for further troubleshooting',   'he_il',    'אני מסכים לשתף יומן API לצוות הטכני לפתרון בעיות נוספות',  5),
        ('edit_record', 'Edit Records', 'he_il',    'ערוך רשומות',  5),
        ('select_time', 'Select Time',  'he_il',    'בחר שעה',  5),
        ('edit_item',   'Edit Item',    'he_il',    'ערוך פריט',    5),
        ('items_total', 'Items Total',  'he_il',    'פריטים סך הכל',    5),
        ('number_less_then_31', 'Number should be less than 31',    'he_il',    'המספר צריך להיות פחות מ -31',  5),
        ('users',   'Users',    'he_il',    'משתמשים',  5),
        ('groups',  'Groups',   'he_il',    'קבוצות',   5),
        ('txt_note_for_file',   'Note : Existing attachments(images/files) will be replaced',   'he_il',    'הערה: הקבצים המצורפים הקיימים (תמונות / קבצים) יוחלפו',    5),
        ('greaterdatetime', 'End DateTime should be greater than Start DateTime',   'he_il',    'תאריך הסיום והשעה צריכים להיות גדולים מתאריך ההתחלה והשעה',    5),
        ('until',   'Until',    'he_il',    'עד',   5),
        ('organizations',   'Organizations',    'he_il',    'ארגונים',  6),
        ('contacts',    'Contacts', 'he_il',    'אנשי קשר', 6),
        ('opportunity', 'Opportunity',  'he_il',    'הזדמנות',  6),
        ('lbl_sun', 'SUN',  'he_il',    'שמש',  7),
        ('lbl_mon', 'MON',  'he_il',    'יום שני',  7),
        ('lbl_tue', 'TUE',  'he_il',    'יום שלישי',    7),
        ('lbl_wed', 'WED',  'he_il',    'להתחתן',   7),
        ('lbl_thu', 'THU',  'he_il',    'הו',   7),
        ('lbl_fri', 'FRI',  'he_il',    'יום שישי', 7),
        ('lbl_sat', 'SAT',  'he_il',    'ישבה', 7),
        ('lbl_1',   '1',    'he_il',    '1',    7),
        ('lbl_2',   '2',    'he_il',    '2',    7),
        ('lbl_3',   '3',    'he_il',    '3',    7),
        ('lbl_4',   '4',    'he_il',    '4',    7),
        ('lbl_5',   '5',    'he_il',    '5',    7),
        ('lbl_6',   '6',    'he_il',    '6',    7),
        ('lbl_7',   '7',    'he_il',    '7',    7),
        ('lbl_8',   '8',    'he_il',    '8',    7),
        ('lbl_9',   '9',    'he_il',    '9',    7),
        ('lbl_10',  '10',   'he_il',    '10',   7),
        ('lbl_11',  '11',   'he_il',    '11',   7),
        ('lbl_12',  '12',   'he_il',    '12',   7),
        ('lbl_13',  '13',   'he_il',    '13',   7),
        ('lbl_14',  '14',   'he_il',    '14',   7),
        ('lbl_15',  '15',   'he_il',    '15',   7),
        ('lbl_16',  '16',   'he_il',    '16',   7),
        ('lbl_17',  '17',   'he_il',    '17',   7),
        ('lbl_18',  '18',   'he_il',    '18',   7),
        ('lbl_19',  '19',   'he_il',    '19',   7),
        ('lbl_20',  '20',   'he_il',    '20',   7),
        ('lbl_21',  '21',   'he_il',    '21',   7),
        ('lbl_22',  '22',   'he_il',    '22',   7),
        ('lbl_23',  '23',   'he_il',    '23',   7),
        ('lbl_24',  '24',   'he_il',    '24',   7),
        ('lbl_25',  '25',   'he_il',    '25',   7),
        ('lbl_26',  '26',   'he_il',    '26',   7),
        ('lbl_27',  '27',   'he_il',    '27',   7),
        ('lbl_28',  '28',   'he_il',    '28',   7),
        ('lbl_29',  '29',   'he_il',    '29',   7),
        ('lbl_30',  '30',   'he_il',    '30',   7),
        ('lbl_31',  '31',   'he_il',    '31',   7),
        ('lbl_32',  '32',   'he_il',    '32',   7),
        ('lbl_33',  '33',   'he_il',    '33',   7),
        ('lbl_34',  '34',   'he_il',    '34',   7),
        ('lbl_35',  '35',   'he_il',    '35',   7),
        ('lbl_36',  '36',   'he_il',    '36',   7),
        ('lbl_37',  '37',   'he_il',    '37',   7),
        ('lbl_38',  '38',   'he_il',    '38',   7),
        ('lbl_39',  '39',   'he_il',    '39',   7),
        ('lbl_40',  '40',   'he_il',    '40',   7),
        ('lbl_41',  '41',   'he_il',    '41',   7),
        ('lbl_42',  '42',   'he_il',    '42',   7),
        ('current_date',    'current date', 'he_il',    'דייט נוכחי',   7),
        ('event',   'Events',   'he_il',    'אירועים',  7),
        ('calendar',    'Calendar', 'he_il',    'לוּחַ שָׁנָה', 7),
        ('latest_version',  'Latest Version :', 'he_il',    'הגרסה העדכנית ביותר :',    8),
        ('expire_on',   'Expire On :',  'he_il',    'תוקף בתאריך:', 8),
        ('ctmobile_ext_version',    'CTMobile Ext. Version :',  'he_il',    'CTMobile Ext. גרסה:',  8),
        ('you_have_latest_version', 'You already have latest version',  'he_il',    'יש לך גירסה מעודכנת',  8),
        ('latest_version1', 'You Already have latest version',  'he_il',    'כבר יש לך גרסה חדשה',  8),
        ('upgreaded',   'Upgrade',  'he_il',    'שדרג', 8),
        ('downgrade',   'Downgrade',    'he_il',    'שדרג לאחור',   8),
        ('dialog_recent_event_info',    'You can set from here how many number of records you want to show on Home screen for Recent Event.',   'he_il',    'תוכל להגדיר מכאן כמה מספר רשומות ברצונך להציג במסך דף הבית של אירוע עדכני .',  8),
        ('dialog_feedback_info',    'You can submit your feedback with description , our team will check your feedback and get back to you.',   'he_il',    'תוכל לשלוח את המשוב שלך בתיאור, הצוות שלנו יבדוק את המשוב שלך ויחזור אליך.',   8),
        ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.',    'he_il',    'לוג פעילויות יעזור לאבחון תקלות ותמיכה טכנית, במידה ואתה ניתקל בתקלות אנא אפשר שמירת לוגים ושיתוף עם התמיכה .',    8),
        ('info',    'Info', 'he_il',    'מידע', 8),
        ('recent_history',  'Recent History',   'he_il',    'היסטוריה אחרונה',  8),
        ('recent_feedback', 'Feedback', 'he_il',    'משוב אחרון',   8),
        ('recent_log',  'Log',  'he_il',    'התחבר',    8),
        ('crmtiger_app_version',    'CRMTiger App Version :',   'he_il',    'CRMTiger App גרסה:',   8),
        ('historylimit',    'Recent History Limit', 'he_il',    'מגבלת ההיסטוריה האחרונה',  8),
        ('radious_in_miles',    'Radius in miles',  'he_il',    'רדיוס בקילומטרים', 8),
        ('recentlimit', 'Recent Event Limit',   'he_il',    'מגבלת אירועים אחרונים',    8),
        ('upcoming_events', 'Upcoming Events',  'he_il',    'אירועים קרובים',   8),
        ('rate_our_app',    'Rate Our App!',    'he_il',    'דרג את האפליקציה שלנו',    8),
        ('feedback',    'Submit Feedback',  'he_il',    'שלח משוב', 8),
        ('sendfeedback',    'Feedback Send',    'he_il',    'שלח משוב', 8),
        ('emaillimit',  'Email limit',  'he_il',    'גבלת דוא\"ל',  8),
        ('log', 'Log',  'he_il',    'התחבר',    8),
        ('logclear',    'Log cleared successfully.',    'he_il',    'נקה בהצלחה',   8),
        ('dialog_recent_history_info',  'You can set from here how many number of records you want to show on Home screen for Recent History.', 'he_il',    'תוכל להגדיר מכאן כמה מספר רשומות ברצונך להציג במסך דף הבית של היסטוריה עדכנית.',   8),
        ('proceed_to_upgrade1', 'Proceed to',   'he_il',    'המשך_לשדרוג 1',    8),
        ('upgradation_message', 'will required logout and login again later.',  'he_il',    'ידרש להתנתק ולהיכנס שוב מאוחר יותר.',  8),
        ('proceed_to_upgrade',  'Proceed to Upgrade',   'he_il',    'המשך_אל_שדרוג',    8),
        ('module_setting',  'Module Setting',   'he_il',    'הגדרות מודול', 9),
        ('sortbyfield', 'Sort by field',    'he_il',    'מיין לפי שדה', 9),
        ('ascending',   'Ascending  A to Z',    'he_il',    'עולה א עד ת',  9),
        ('descending',  'Descending  Z to A',   'he_il',    'יורד ל - A',   9),
        ('first_field', 'First Field',  'he_il',    'שדה ראשון',    9),
        ('second_field',    'Second Field', 'he_il',    'שדה שני',  9),
        ('third_field', 'Third Field',  'he_il',    'שדה שלישי',    9),
        ('sure_want_restore',   'Are you sure you want to reset to default settings?',  'he_il',    'האם אתה בטוח שברצונך לשחזר את ברירת המחדל',    9),
        ('orderlist',   'List Order',   'he_il',    'סדר רשימה',    9),
        ('module_reset',    'Restore to Default',   'he_il',    'אפס את ברירת המחדל',   9),
        ('display_fields',  'Display Fields',   'he_il',    'שדות תצוגה',   9),
        ('discount_lessthen_100',   'Discount % should be less than 100',   'he_il',    'אחוז ההנחה צריך להיות פחות מ-100', 10),
        ('select_item', 'Select Item',  'he_il',    'בחר פריט', 10),
        ('item_comment',    'Item Comment', 'he_il',    'הערה פריט',    10),
        ('record_name', 'Record Name is :', 'he_il',    'שם רשומה', 11),
        ('go_back', 'Go Back',  'he_il',    'תחזור',    11),
        ('please_enter_shortcut_name',  'Please Enter Shortcut Name',   'he_il',    'הזן שם קיצור', 11),
        ('number_not_found',    'Contact Number not found', 'he_il',    'מספר איש הקשר לא נמצא',    11),
        ('mail_not_found',  'Mail Address not found',   'he_il',    'כתובת הדואר לא נמצאה ',    11),
        ('create_shortcut', 'Create Shortcut',  'he_il',    'צור קיצור דרך',    11),
        ('contact_summary', 'Summary',  'he_il',    'סיכום',    11),
        ('activites',   'Activities',   'he_il',    'פעילויות', 11),
        ('details', 'Details',  'he_il',    'פרטים',    11),
        ('related', 'Related',  'he_il',    'קָשׁוּר',  11),
        ('share_link',  'Share record with',    'he_il',    'שתף קישור',    11),
        ('edit',    'Edit', 'he_il',    'ערוך', 11),
        ('duplicate',   'Duplicate',    'he_il',    'שכפל', 11),
        ('whatsapp',    'Whatsapp', 'he_il',    'וואצאפ',   11),
        ('call',    'Call', 'he_il',    'צלצל ',    11),
        ('choose_contact_for_call', 'Choose Contact for Call',  'he_il',    'בחר איש קשר לשיחה',    11),
        ('choose_contact_for_sms',  'Choose Contact for SMS',   'he_il',    'בחר איש קשר לסמס', 11),
        ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp',  'he_il',    'בחר איש קשר לוואצאפ',  11),
        ('chosse_contact_for_email',    'Choose Email', 'he_il',    'בחר איש קשר לדוא\"ל',  11),
        ('attach_file', 'Attach Files', 'he_il',    'צרף קובץ', 11),
        ('close',   'Close',    'he_il',    'סגור', 11),
        ('status',  'Status',   'he_il',    'סטטוס',    11),
        ('stop',    'Stop', 'he_il',    'עצור', 11),
        ('zero',    '0',    'he_il',    'אפס',  11),
        ('record',  'Record',   'he_il',    'רשומה',    11),
        ('voice_note',  'Voice Note',   'he_il',    'הערה קולית',   11),
        ('tickets', 'Tickets',  'he_il',    'כרטיסים',  12),
        ('check_out',   'Check Out',    'he_il',    'לבדוק',    12),
        ('check_in',    'Check In', 'he_il',    'קבלה', 12),
        ('select_any',  'Select any',   'he_il',    'בחר בכל',  12),
        ('fulldetails', 'Show Full Details',    'he_il',    'הצג פרטים מלאים',  12),
        ('checkin', 'Check-in', 'he_il',    'קבלה', 12),
        ('navigate',    'Navigate', 'he_il',    'נווט', 12),
        ('product', 'Products', 'he_il',    'מוצרים',   12),
        ('projectMilestone',    'Project Milestone',    'he_il',    'אבן דרך בפרויקט',  12),
        ('projecttask', 'Project Tasks',    'he_il',    'משימה פרויקט', 12),
        ('nearby',  'NearBy',   'he_il',    'קרוב', 13),
        ('document',    'Document', 'he_il',    'מסמך', 14),
        ('reply',   'Reply',    'he_il',    'תשובה',    14),
        ('reply_all',   'Reply All',    'he_il',    'השב לכולם',    14),
        ('forward', 'Forward',  'he_il',    'קדימה',    14),
        ('action',  'Action',   'he_il',    'פעולה',    14),
        ('select_first',    'Select First', 'he_il',    'בחר ראשון',    14),
        ('commentaddsuccessful',    'Comment added successfull',    'he_il',    'הערה הוסף בהצלחה', 14),
        ('move_to', 'Move to',  'he_il',    'לעבור ל',  14),
        ('attach',  'Attach',   'he_il',    'צרף',  14),
        ('addcoment',   'Add Comment',  'he_il',    'הוסף תגובה',   14),
        ('adddocument', 'Add Document', 'he_il',    'הוסף מסמך',    14),
        ('home',    'Home', 'he_il',    'בית',  15),
        ('checkout',    'Check-out',    'he_il',    'לבדוק',    15),
        ('message_search',  'Search by name',   'he_il',    'חפש לפי שם',   15),
        ('start_shift', 'Start shift',  'he_il',    'התחל התחל',    15),
        ('end_shift',   'End shift',    'he_il',    'סוף משמרת',    15),
        ('today_meeting',   'Meetings', 'he_il',    'מפגשים',   15),
        ('shift_time_track',    'Shift Time Track', 'he_il',    'זמן Shift מסלול',  15),
        ('logout_msg',  'You have to login again , click',  'he_il',    'עליך להתחבר שוב, לחץ', 15),
        ('logout_msg1', 'to continue.', 'he_il',    'להמשיך.',  15),
        ('permission_denied',   'You don\'t have permission to create', 'he_il',    'אין לך הרשאה ליצור',   15),
        ('history', 'Activity stream',  'he_il',    'זרם פעילות',   15),
        ('search_value',    'Search value :',   'he_il',    'ערך לחיפוש',   15),
        ('feed_back_msg',   'Please enter feedback message',    'he_il',    'הזן הודעת משוב',   16),
        ('feed_back_hint_msg',  'Enter feedback message',   'he_il',    'הזן הודעת משוב',   16),
        ('submit',  'Submit',   'he_il',    'שלח',  16),
        ('check_app_not_installed', 'Application is not currently installed.',  'he_il',    'היישום אינו מותקן כרגע.',  17),
        ('send_sms_fail_message',   'SMS failed, please try again later!',  'he_il',    'נכשל ב- SMS, נסה שוב מאוחר יותר!', 17),
        ('documentaddsuccessfully', 'Document Attach successfully', 'he_il',    'המסמך מצורף בהצלחה',   17),
        ('send_message',    'Send message', 'he_il',    'שלח הודעה',    17),
        ('sms_to',  'smsto:',   'he_il',    'סמס אל',   17),
        ('add_list_message',    'Add List', 'he_il',    'הוסף רשימה',   18),
        ('mylist',  'My List',  'he_il',    'הרשימה שלי',   18),
        ('filtername',  'Filter Name',  'he_il',    'שם סינון', 18),
        ('selectlist',  'Select a List',    'he_il',    'בחר רשימה *',  18),
        ('assingedto',  'Assigned To',  'he_il',    'שהוקצה ל *',   18),
        ('selectmodule',    'Select a module',  'he_il',    'בחר מודול',    18),
        ('add_list',    'Add Filter',   'he_il',    'הוסף רשימה',   18),
        ('recent_event',    'Recent Event', 'he_il',    'מגבלת אירועים אחרונים',    19),
        ('recent_hostory',  'Recent History',   'he_il',    'היסטוריה אחרונה',  19),
        ('module_specific_settings',    'Module-Specific Settings', 'he_il',    'הגדרות ספציפיות למודול',   19),
        ('talk_to_us',  'Talk to us',   'he_il',    'דבר איתנו',    19),
        ('report_a_bug',    'Report A Bug', 'he_il',    'דווח על באג',  19),
        ('faq', 'FAQ',  'he_il',    'שאלות נפוצות', 19),
        ('selectmodules',   'Select Module',    'he_il',    'בחר מודול',    19),
        ('myplan',  'My Plan',  'he_il',    'התוכנית שלי',  19),
        ('message', 'Message',  'he_il',    'הודעה',    20),
        ('message_validation',  'Please enter Message', 'he_il',    'הזן הודעה',    20),
        ('contact_select',  'Please Select contact',    'he_il',    'אנא בחר איש קשר',  20),
        ('global_search',   'Global Search',    'he_il',    'חיפוש גלובלי', 21),
        ('records', 'Records',  'he_il',    'רשומות',   21),
        ('dont_show_again', 'Don\'t Show Again',    'he_il',    'אל תציג שוב',  22),
        ('skip',    'Skip', 'he_il',    'דלג',  22),
        ('file_downloading',    'File Downloading', 'he_il',    'הורדת קובץ',   23),
        ('add_screenshots_optional',    'Add screenshots (optional)',   'he_il',    'הוספת צילומי מסך (אופציונלי)', 24),
        ('describe_your_problem',   'Describe your problem',    'he_il',    'תאר את הבעיה שלך', 24),
        ('default_filter_shortcut', 'Default Filter Shortcut',  'he_il',    'קיצור לברירת מחדל למסנן',  25),
        ('record_shortcut', 'Record Shortcut',  'he_il',    'קיצור לרשומה', 25),
        ('enter_url',   'Please Enter url', 'he_il',    'הזן כתובת אתר',    26),
        ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'he_il',    'עליך לעדכן את האפליקציה כדי להמשיך להשתמש אנא עדכן כדי להמשיך גרסאות ישנות יותר לא יעבדו עוד מהיום',   26),
        ('search_by',   'Search by',    'he_il',    'חפש לפי',  27),
        ('selected_filter', 'Selected filter :',    'he_il',    'מסנן נבחר: -', 27),
        ('selected_field',  'Selected field :', 'he_il',    'שדה נבחר: -',  27),
        ('choose',  'Choose',   'he_il',    'בחר',  28),
        ('qr_cardscanner',  'QR Code Scanner',  'he_il',    'סורק קוד QR',  28),
        ('error_message_for_scan',  'Could not read the card Try again later.', 'he_il',    'לא ניתן היה לקרוא את הכרטיס נסה שוב מאוחר יותר',   28),
        ('press_start_scan',    'Press to Start Scan',  'he_il',    'לחץ כדי להתחיל בסריקה',    28),
        ('line_item_quntity_validation_msg',    'Value should be greater than zero',    'he_il',    'הערך צריך להיות גדול מאפס',    29),
        ('percentage_msg',  'Percentage should be less than 100',   'he_il',    'האחוז צריך להיות פחות מ 100',  29),
        ('MSG_NO_DATA', 'No data found!',   'he_il',    'לא נמצאו נתונים!', 29),
        ('MSG_SOMETHING_WRONG', 'Something went wrong!',    'he_il',    'משהו השתבש',   29),
        ('MSG_COMING_SOON', 'Coming Soon!', 'he_il',    'בקרוב!',   29),
        ('MSG_UPLOAD_PROFILE_IMAGE',    'Please upload profile image.', 'he_il',    'אנא העלה תמונת פרופיל.',   29),
        ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access',  'he_il',    'גישה למיקום',  29),
        ('ALERT_MSG_LOCATION_ACCESS',   'Requires your location to show nearby events.',    'he_il',    'מחייב את המיקום שלך כדי להציג אירועים בקרבת מקום.',    29),
        ('ALERT_BTN_ALLOW', 'ALLOW',    'he_il',    'התר',  29),
        ('ALERT_BTN_DENY',  'DENY', 'he_il',    'דחה',  29),
        ('ALERT_MSG_LOCATION_SETTING',  'Not able to fetch your current location. Please allow us to use your location to provide you certain features like, live tracking, route planning and display near by leads, contact, organization, etc. This will help you to plan your on field task as well',   'he_il',    'לא ניתן לאחזר את המיקום הנוכחי שלך. אנא הרשה לנו להשתמש במיקום שלך כדי לספק לך תכונות מסוימות כמו, מעקב חי, תכנון מסלול והצגה ליד לידים, איש קשר, ארגון וכו\'. זה יעזור לך לתכנן גם את המשימה שלך בשטח',   29),
        ('DELETE_RECORD',   'Delete Record',    'he_il',    'מחק רשומה',    29),
        ('ALERT_MSG_DELETE_SHORTCUT',   'Are you sure want to delete this shortcut?',   'he_il',    'האם אתה בטוח שברצונך למחוק קיצור דרך זה?', 29),
        ('DELETE_SHORTCUT', 'Delete Shortcut',  'he_il',    'מחק קיצור דרך',    29),
        ('LBL_TERMS',   'By logging in, you agree to our Terms and',    'he_il',    'על ידי התחברות, אתה מסכים לתנאים שלנו',    29),
        ('LBL_CONDITIONS',  'Conditions &', 'he_il',    'והתנאים',  29),
        ('ALERT_TITLE', 'Alert',    'he_il',    'אַזעָקָה', 29),
        ('ALERT_BTN_SUBSCRIBE', 'Subscribe',    'he_il',    'הירשם כמנוי',  29),
        ('MSG_SELECT_MODULE',   'Please select any Module', 'he_il',    'אנא בחר כל מודול', 29),
        ('MSG_SELECT_LIST', 'Please select any List',   'he_il',    'אנא בחר רשימה כלשהי',  29),
        ('ALERT_MSG_DONT_HAVE_CAMERA',  'You don\'t have camera',   'he_il',    'אין לך מצלמה', 29),
        ('ALERT_MSG_GALLARY_PERMISSION',    'You don\'t have permission to access gallery.',    'he_il',    'אין לך הרשאה לגשת לגלריה.',    29),
        ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'he_il',    'אין לך הרשאה לגשת למצלמה. עבור להגדרה -&gt; גלול לתחתית ובחר יישום CRMTiger -&gt; הפעל מצלמה', 29),
        ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'he_il',    'אין לך הרשאה לגשת לזיהוי דיבור. עבור להגדרה -&gt; גלול לתחתית ובחר יישום CRMTiger -&gt; הפעל זיהוי דיבור', 29),
        ('BTN_DONE',    'Done', 'he_il',    'בוצע', 29),
        ('COMMENT', 'Comment',  'he_il',    'הערה', 29),
        ('FULL_FORM',   'Full Form',    'he_il',    'טופס מלא', 29),
        ('QUICK_CREATE',    'Create',   'he_il',    'צור',  29),
        ('LBL_SELECT_FIELDS',   'Select Fields',    'he_il',    'בחר שדות', 29),
        ('LBL_SELECT_FIELDS',   'Select Fields',    'he_il',    'בחר שדות', 29),
        ('LBL_SELECT_FIRST_FIELDS', 'Select First Field',   'he_il',    'בחר שדה ראשון',    29),
        ('LBL_SELECT_SECOND_FIELDS',    'Select Second Field',  'he_il',    'בחר שדה שני',  29),
        ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field',   'he_il',    'בחר שדה שלישי',    29),
        ('LBL_SORT_BY_FIELD',   'Select Sort By Field', 'he_il',    'בחר מיון לפי שדה', 29),
        ('BTN_RESET_TO_DEFAULT',    'Reset to Default', 'he_il',    'אפס לברירת מחדל',  29),
        ('MSG_SELECT_SORT_BY_FIELD',    'Select Sort by field', 'he_il',    'בחר מיון לפי שדה', 29),
        ('kStrClearBtnTitle',   'Clear',    'he_il',    'נקה',  29),
        ('kStrShowMoreBtnTitle',    'Show More',    'he_il',    'להראות יותר',  29),
        ('kStrAddActivitiesBtnTitle',   'Add Activities',   'he_il',    'הוסף פעילויות',    29),
        ('kStrAddCommentPlaceHolder',   'Add your comments here',   'he_il',    'הוסף את הערותיך כאן',  29),
        ('MSG_ENTER_TO_EMAIL',  'Please enter to field.',   'he_il',    'אנא הכנס לשדה.',   29),
        ('WARNING_FILE',    'File can\'t open.',    'he_il',    'הקובץ לא יכול להיפתח.',    29),
        ('MSG_FILE_SAVED',  'File saved.',  'he_il',    'הקובץ נשמר.',  29),
        ('WARNING_DOWNLOAD_FAIL',   'Download fail!, please try after sometime.',   'he_il',    'ההורדה נכשלה!, אנא נסה לאחר זמן מה.',  29),
        ('LBL_SHORTCUT',    'Shortcut', 'he_il',    'קיצור דרך',    29),
        ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'he_il',    'הקלד הודעה',   29),
        ('ALERT_INSTALL_WHATSAPP',  'Install Whatsapp', 'he_il',    'התקן את Whatsapp', 29),
        ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox',  'he_il',    'לא נמצאה תיבת דואר. נא ליצור תיבת דואר',   29),
        ('LBL_WROTE',   'Wrote',    'he_il',    'כתב',  29),
        ('MSG_MAIL_SEND',   'Mail sent',    'he_il',    'דואר נשלח',    29),
        ('log_file_not_found',  'API Log file not found.',  'he_il',    'קובץ יומן API לא נמצא.',   29),
        ('unknown_error',   'An unknown error occurred, try again', 'he_il',    'אירעה שגיאה לא ידועה, נסה שוב',    29),
        ('CTMTigerAppVersion',  'CRMTiger App Version', 'he_il',    'גרסת יישום CRMTiger',  29),
        ('CTMMobileUpdateMsg',  'CTMobile Ext. Version Update Successfully',    'he_il',    'CTMobile Ext. עדכון הגרסה בוצע  בהצלחה',   29),
        ('dialog_Premium_downgrade',    'Downgrade will required logout and login again later', 'he_il',    'שנמוך  ידרוש להתנתק ולהיכנס שוב מאוחר יותר',   29),
        ('dialog_Premium',  'Upgrade will required logout and login again later',   'he_il',    'שדרוג יידרש להתנתק ולהיכנס שוב מאוחר יותר',    29),
        ('Overwrite',   'Overwrite',    'he_il',    'שכתוב',    29),
        ('MSGAddressOverwrite1',    'Overwrite the existing address with the selected', 'he_il',    'החלף את הכתובת הקיימת באמצעות הנבחר',  29),
        ('MSGAddressOverwrite2',    'address details?', 'he_il',    'פרטי כתובת?',  29),
        ('UPGRADE_PLAN',    'Upgrade Plan', 'he_il',    'תוכנית שדרוג', 29),
        ('DOWNGRADE_PLAN',  'Downgrade Plan',   'he_il',    'תוכנית שנמוך', 29),
        ('UPGRADE_EXTENSION',   'Upgrade Extension',    'he_il',    'שדרוג סיומת',  29),
        ('UPGRADE_APP', 'Upgrade App',  'he_il',    'שדרג את האפליקציה',    29),
        ('SELECT_OPTION',   'Select Option',    'he_il',    'בחר אפשרות',   29),
        ('PLEASE_SELECT',   'Please select',    'he_il',    'בבקשה תבחר',   29),
        ('MSG_ACCESS_DENIED',   'You don\'t have permission for this module.',  'he_il',    'אין לך הרשאה למודול זה.',  29),
        ('MSG_SELECT_RECCURING_MONTH_DAY',  'Please select reccuring day of month.',    'he_il',    'בחר יום חוזר בחודש.',  29),
        ('MSG_SELECT_RECCURING_WEEK_DAY',   'Please select reccuring day of week.', 'he_il',    'אנא בחר ביום בשבוע החוזר.',    29),
        ('MSG_SELECT_RECCURING_DAYS',   'Please select reccuring days.',    'he_il',    'אנא בחר ימים חוזרים.', 29),
        ('Please select reccuring days.',   'Please select reccuring days.',    'he_il',    'אנא בחר ימים חוזרים.', 29),
        ('MSG_SELECT_RECCURING_END_DATE',   'Please select reccuring end date.',    'he_il',    'אנא בחר תאריך סיום חוזר.', 29),
        ('MSG_SELECT_RECCURING_TYPE',   'Please select reccuring type.',    'he_il',    'אנא בחר סוג חוזר.',    29),
        ('FREQ_TIME',   'Times',    'he_il',    'זמנים',    29),
        ('REPEAT_YEARLY',   'Repeat Yearly',    'he_il',    'חזור על פעולה שנתית',  29),
        ('REPEAT_MONTHLY',  'Repeat Monthly',   'he_il',    'חזור על חודשי',    29),
        ('REPEAT_WEEKLY',   'Repeat Weekly',    'he_il',    'חזור על שבועי',    29),
        ('REPEAT_DAILY',    'Repeat Daily', 'he_il',    'חזור על כך מדי יום',   29),
        ('ACTION_TITLE',    'Action Title', 'he_il',    'כותרת פעולה',  29),
        ('MSG_SELECT_VALID_DATE',   'Please select valid day of month.',    'he_il',    'בחר יום חוקי תקף.',    29),
        ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'he_il',    'תאריך ההתחלה צריך להיות פחות מתאריך הסיום.',   29),
        ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'he_il',    'זמן ההתחלה צריך להיות פחות משעת הסיום.',   29),
        ('LBL_LINEITEM_DETAILS',    'Lineitem Details', 'he_il',    'פרטי הפריט',   29),
        ('MSG_INVALIDE_DISCOUNT_AMOUNT',    'Discount amount should be less than the total.',   'he_il',    'סכום ההנחה צריך להיות פחות מהסך הכל.', 29),
        ('VIEW',    'View', 'he_il',    'צפה',  29),
        ('MSG_ENTER_VALID', 'Please enter valid',   'he_il',    'אנא הכנס חוקי',    29),
        ('MSG_ENTER_PERCENTAGE',    'Percentage should be less than 100.',  'he_il',    'האחוז צריך להיות פחות מ 100.', 29),
        ('ITEM_TOTAL',  'Item Total',   'he_il',    'פריט כולל',    29),
        ('ADJUSTMENT',  'Adjustment',   'he_il',    'התאמה',    29),
        ('TITLE_CHOOSE_IMAGE',  'Choose Image', 'he_il',    'בחר תמונה',    29),
        ('COMPRESS',    'Compress', 'he_il',    'דחוס', 29),
        ('CHOOSE_ANOTHER_IMAGE',    'Your image size is too large, please select another image',    'he_il',    'גודל התמונה שלך גדול מדי, בחר תמונה אחרת', 29),
        ('OnDayOfMonth',    'On day of month',  'he_il',    'ביום בחודש',   29),
        ('OnDayOfWeek', 'On day of week',   'he_il',    'ביום בשבוע',   29),
        ('AddAndClose', 'Add & Close',  'he_il',    'הוסף וסגור',   29),
        ('Repeat',  'Repeat',   'he_il',    'חזור', 29),
        ('OnDay',   'On day',   'he_il',    'ביום', 29),
        ('View_Line_Item',  'View Line Item',   'he_il',    'הצג פריט שורה',    29),
        ('TITLE_IMAGE', 'Image',    'he_il',    'תמונה',    29),
        ('TITLE_ICLOUD',    'iCloud',   'he_il',    'iCloud',   29),
        ('GOOGLE',  'Google',   'he_il',    'גוגל', 29),
        ('ALERT_BTN_OKAY',  'Okay', 'he_il',    'בסדר', 29),
        ('ALERT_TITLE_ACCESS_DENIED',   'Access Denied',    'he_il',    'גישה נדחתה',   29),
        ('Dont_Show_Again', 'Don\'t show again',    'he_il',    'אל תראה שוב',  29),
        ('Skip',    'Skip', 'he_il',    'דלג',  29),
        ('Fillter_Name',    'Fillter Name', 'he_il',    'שם המסנן', 29),
        ('Fillter_Record_Count',    'Fillter Record Count', 'he_il',    'סינון ספירת רשומות',   29),
        ('url_note',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'he_il',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   26),
        ('vtiger_url',  'Your vTiger CRM URL',  'he_il',    'כתובת האתר של vTiger CRM שלך', 26),
        ('msg_doc_read_permission', 'You don\'t have permission to Add either This is read-only or Private Field.', 'he_il',    'אין לך הרשאה להוסיף שדה זה לקריאה בלבד או שדה פרטי.',  31),
        ('CLEAR',   'Clear',    'he_il',    'נקה',  31),
        ('Files/photos uploaded successfully',  'Files/photos uploaded successfully',   'he_il',    'קבצים / תמונות הועלו בהצלחה',  32),
        ('Digital signature saved', 'Digital signature saved',  'he_il',    'חתימה דיגיטלית נשמרה', 32),
        ('Please upload Signature or Files/photos', 'Please upload Signature or Files/photos',  'he_il',    'אנא העלה חתימה או קבצים / תמונות', 32),
        ('Files / Photos',  'Files / Photos',   'he_il',    'קבצים  תמונות',    32),
        ('Signature',   'Signature',    'he_il',    'חתימה',    32),
        ('add_photo_using', 'Add Photo Using',  'he_il',    'הוסף תמונה באמצעות',   31),
        ('btn_upload_sign', '(+) Add Signature',    'he_il',    '(+) הוסף חתימה',   31),
        ('btn_upload_photo_doc',    '(+) Upload Files/Photos',  'he_il',    '(+) העלה קבצים / תמונות',  31),
        ('select_photo_doc_to_upload',  'Please select files/photos to upload', 'he_il',    'אנא בחר קבצים / תמונות להעלאה',    31),
        ('related_module_title',    'Search from related module and Add to \"Route\"',  'he_il',    'חפש ממודול קשור והוסף ל\"נתיב \"', 30),
        ('Route status updated successfully',   'Route status updated successfully',    'he_il',    'סטטוס המסלול עודכן בהצלחה',    32),
        ('Session init failed', 'Session init failed',  'he_il',    'ההפעלה של Session  נכשלה', 32),
        ('You don\'t have permission to access this resource',  'You don\'t have permission to access this resource',   'he_il',    'אין לך הרשאה לגשת למשאב זה',   32),
        ('ctroute_realtedto cannot be empty',   'Could not get the Related To - Try again later',   'he_il',    'לא הצלחנו להשיג את הקשור ל - נסה שוב מאוחר יותר',  32),
        ('ctroute_planning cannot be empty',    'Could not get the Route Planning Record - Try again later',    'he_il',    'לא ניתן היה להשיג את רשומת תכנון המסלול - נסה שוב מאוחר יותר', 32),
        ('Something went wrong - Try again later',  'Something went wrong - Try again later',   'he_il',    'משהו השתבש - נסה שוב מאוחר יותר',  32),
        ('sequence updated successfully',   'sequence updated successfully',    'he_il',    'הרצף עודכן בהצלחה',    32),
        ('sequence cannot be empty',    'sequence cannot be empty', 'he_il',    'רצף לא יכול להיות ריק',    32),
        ('Shortcut details not saved',  'Shortcut details not saved',   'he_il',    'פרטי קיצור הדרך לא נשמרו בהצלחה',  32),
        ('Shortcut details saved successfully', 'Shortcut details saved successfully',  'he_il',    'פרטי קיצור הדרך נשמרו בהצלחה', 32),
        ('Route save successfully', 'Route save successfully',  'he_il',    'שמירת מסלול בהצלחה',   32),
        ('Record save successfully',    'Record save successfully', 'he_il',    'הרשומה נשמרה בהצלחה',  32),
        ('No dependency found for picklist',    'No dependency found for picklist', 'he_il',    'לא נמצאה תלות ברשימת הבחירה',  32),
        ('No records found',    'No records found', 'he_il',    'לא נמצאה רשומה',   32),
        ('Outgoing server is not enabled, please configure from CRM',   'Outgoing server is not enabled, please configure from CRM',    'he_il',    'השרת היוצא אינו מופעל, אנא הגדר מתוך CRM', 32),
        ('Removed Successfully',    'Removed Successfully', 'he_il',    'הוסר בהצלחה',  32),
        ('Shortcut has been deleted',   'Shortcut has been deleted',    'he_il',    'קיצור דרך נמחק',   32),
        ('relation of records removed successfully',    'relation of records removed successfully', 'he_il',    'יחס הרשומות הוסר בהצלחה',  32),
        ('relation of records not removed', 'relation of records not removed',  'he_il',    'יחס הרשומות לא הוסר',  32),
        ('Record has been deleted successfully',    'Record has been deleted successfully', 'he_il',    'רשומה נמחקה בהצלחה',   32),
        ('Time Tracking saved successfully',    'Time Tracking saved successfully', 'he_il',    'מעקב הזמן נשמר בהצלחה',    32),
        ('Time Tracking updated successfully',  'Time Tracking updated successfully',   'he_il',    'מעקב אחר הזמן עודכן בהצלחה',   32),
        ('Time Tracking ended successfully',    'Time Tracking ended successfully', 'he_il',    'מעקב אחר זמן הסתיים בהצלחה',   32),
        ('Time Tracking started successfully',  'Time Tracking started successfully',   'he_il',    'מעקב אחר זמן התחיל בהצלחה',    32),
        ('record cannot be empty',  'record cannot be empty',   'he_il',    'רשומה לא יכולה להיות ריקה',    32),
        ('Module is disabled',  'Module is disabled',   'he_il',    'המודול מושבת', 32),
        ('Shift ended successfully',    'Shift ended successfully', 'he_il',    'משמרת הסתיימה בהצלחה', 32),
        ('Shift started successfully',  'Shift started successfully',   'he_il',    'משמרת התחילה בהצלחה',  32),
        ('relation of records added successfully',  'relation of records added successfully',   'he_il',    'יחס הרשומות נוסף בהצלחה',  32),
        ('Comment saved successfully',  'Comment saved successfully',   'he_il',    'הערה נשמרה בהצלחה',    32),
        ('Comment not saved',   'Comment not saved',    'he_il',    'הערה לא נשמרה',    32),
        ('Comment module is not active',    'Comment module is not active', 'he_il',    'מודול ההערות אינו פעיל',   32),
        ('No Upcoming Event',   'No Upcoming Event',    'he_il',    'אין אירוע קרוב',   32),
        ('No Templates found - create it from Message Templates module',    'No Templates found - create it from Message Templates module', 'he_il',    'לא נמצאו תבניות - צור אותן ממודול תבניות ההודעות', 32),
        ('No event or task for this date',  'No event or task for this date',   'he_il',    'אין אירוע או משימה לתאריך זה', 32),
        ('No filters created',  'No filters created',   'he_il',    'לא נוצרו פילטרים', 32),
        ('Select at least one record to attach',    'Select at least one record to attach', 'he_il',    'בחר רשומה אחת לפחות לצרף', 32),
        ('Please select one or more attachments',   'Please select one or more attachments',    'he_il',    'בחר קובץ מצורף אחד או יותר',   32),
        ('No event for this month', 'No event for this month',  'he_il',    'אין אירוע לחודש זה',   32),
        ('No Activity found',   'No Activity found',    'he_il',    'לא נמצאה פעילות',  32),
        ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'he_il',    'המשוב שלך הוא בעל ערך רב עבורנו - הוא לא יכול להיות ריק',  32),
        ('Could not send mail, Please try later',   'Could not send mail, Please try later',    'he_il',    'לא ניתן היה לשלוח דואר. אנא נסה מאוחר יותר',   32),
        ('Latest Version updated successfully', 'Latest Version updated successfully',  'he_il',    'הגרסה האחרונה עודכנה בהצלחה',  32),
        ('User Location Updated Successfully',  'User Location Updated Successfully',   'he_il',    'מיקום המשתמש עודכן בהצלחה',    32),
        ('User Location not Updated Successfully',  'User Location not Updated Successfully',   'he_il',    'מיקום המשתמש לא עודכן בהצלחה', 32),
        ('SMSNotifier is not enable in CRM. Please enable it first',    'SMSNotifier is not enable in CRM. Please enable it first', 'he_il',    'SMSNotifier אינו מופעל ב- CRM. אנא הפעל אותו תחילה',   32),
        ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'he_il',    'לא ניתן היה להגיש את המשוב שלך - נסה שוב מאוחר יותר',  32),
        ('Thank you for submitting your feedback',  'Thank you for submitting your feedback',   'he_il',    'תודה שהגשת את המשוב שלך',  32),
        ('Please upload User Image',    'Please upload User Image', 'he_il',    'אנא העלה תמונת משתמש', 32),
        ('Image Not Uploading, please try again',   'Image Not Uploading, please try again',    'he_il',    'התמונה לא הועלתה, נסה שוב',    32),
        ('User Image Uploaded Successfully',    'User Image Uploaded Successfully', 'he_il',    'תמונת משתמש הועלתה בהצלחה',    32),
        ('Invalid Module name', 'Invalid Module name',  'he_il',    'שם מודול לא חוקי', 32),
        ('Records Sync Successfully',   'Records Sync Successfully',    'he_il',    'סינכרון רשומות בוצע בהצלחה',   32),
        ('Values cannot be empty',  'Values cannot be empty',   'he_il',    'הערכים לא יכולים להיות ריקים', 32),
        ('Record id is empty',  'Record id is empty',   'he_il',    'הרשומה ריקה',  32),
        ('Logout Successfully', 'Logout Successfully',  'he_il',    'התנתק בהצלחה', 32),
        ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'he_il',    'אנא הפעל את מודול CTMobile',   32),
        ('Authentication Failed',   'Username and Password do not match',   'he_il',    'שם המשתמש והסיסמא לא תואמים',  32),
        ('Mismatched module information',   'Something gone wrong, please try again later', 'he_il',    'משהו השתבש, נסה שוב מאוחר יותר',   32),
        ('Field does not exists',   'Please set display fields again',  'he_il',    'אנא הגדר שוב שדות תצוגה',  32),
        ('Module does not exists',  'Module does not exists or disabled by admin',  'he_il',    'המודול אינו קיים או מושבת על ידי מנהל המערכת', 32),
        ('Month cannot be empty',   'Could not get the Month - Try again later',    'he_il',    'לא ניתן היה לקבל את החודש - נסה שוב מאוחר יותר',   32),
        ('Year cannot be empty',    'Could not get the Year - Try again later', 'he_il',    'לא הצלחנו להשיג את השנה - נסה שוב מאוחר יותר', 32),
        ('Date cannot be empty',    'Could not get the Date - Try again later', 'he_il',    'לא ניתן היה להשיג את התאריך - נסה שוב מאוחר יותר', 32),
        ('Userid cannot be empty',  'Could not get the Userid - Try again later',   'he_il',    'לא ניתן היה להשיג את User id - נסה שוב מאוחר יותר',    32),
        ('End Date cannot be empty',    'Could not get the status - Try again later',   'he_il',    'לא ניתן היה לקבל את הסטטוס - נסה שוב מאוחר יותר',  32),
        ('Start Date cannot be empty',  'Could not get the Start Date - Try again later',   'he_il',    'לא ניתן היה לקבל את תאריך ההתחלה - נסה שוב מאוחר יותר',    32),
        ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'he_il',    'אינך מגדיר את התראה SMS ב- CRM. אנא הגדר את התראה SMS ב- CRM שלך לשימוש בתכונה זו',    32),
        ('Longitude cannot be empty',   'Could not get location-Please try again',  'he_il',    'לא ניתן היה לקבל מיקום - אנא נסה שוב', 32),
        ('Latitude cannot be empty',    'Could not get location-Please try again',  'he_il',    'לא ניתן היה לקבל מיקום - אנא נסה שוב', 32),
        ('User cannot be empty',    'Could not get the User - Try again later', 'he_il',    'לא ניתן היה להשיג את המשתמש - נסה שוב מאוחר יותר', 32),
        ('Status cannot be empty',  'Could not get the status - Try again later',   'he_il',    'לא ניתן היה לקבל את הסטטוס - נסה שוב מאוחר יותר',  32),
        ('Required fields not found',   'Required fields not found',    'he_il',    'לא נמצאו שדות חובה',   32),
        ('Tracking module not active',  'Tracking module not active-Please contact CRM Admin',  'he_il',    'מודול המעקב אינו פעיל - אנא צרו קשר עם מנהל המערכת של CRM',    32),
        ('Missing mandatory input values',  'Missing mandatory input values',   'he_il',    'חסר ערך חובה', 32),
        ('No MailBox found. Please Create Mailbox', 'No MailBox found. Please Create Mailbox',  'he_il',    'לא נמצא תיבת דוא\"ל. אנא צור תיבה',    32),
        ('Mail not sent',   'Mail not sent',    'he_il',    'הדוא\"ל לא נשלח',  32),
        ('Mail send successfully',  'Mail send successfully',   'he_il',    'הדוא\"ל נשלח בהצלחה',  32),
        ('Email Id or username not match with your record', 'Email Id or username not match with your record',  'he_il',    'מזהה האימייל או שם המשתמש לא תואמים את הרשומה שלך',    32),
        ('Module not specified',    'Module not specified', 'he_il',    'המודול לא צוין',   32),
        ('No messages found',   'No messages found',    'he_il',    'לא נמצאו הודעות',  32),
        ('No Dependency Found For This Module', 'No Dependency Found For This Module',  'he_il',    'לא נמצאה תלות במודול זה',  32),
        ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'he_il',    'השרת היוצא  אינו מופעל',   32),
        ('Outgoing server is Enabled',  'Outgoing server is Enabled',   'he_il',    'השרת היוצא מופעל', 32),
        ('Email Attached Successfully', 'Email Attached Successfully',  'he_il',    'הדוא\"ל צורף בהצלחה',  32),
        ('Documents Attached Successfully', 'Documents Attached Successfully',  'he_il',    'המסמכים צורפו בהצלחה', 32),
        ('Login required - Please login again', 'Login required - Please login again',  'he_il',    'חובה להתחבר - אנא התחבר שוב',  32),
        ('time_tracking_module_disable',    'Time tracking module is disable',  'he_il',    'מודול מעקב אחר זמן מושבת', 31),
        ('route_planning_module_disable',   'Route planning module is disable', 'he_il',    'מודול תכנון מסלול מושבת',  31),
        ('mark_as_held',    'Are you sure you want to mark Event as Held?', 'he_il',    'האם אתה בטוח שברצונך לסמן את האירוע כמוחזק?',  31),
        ('stop_timer_msg',  'You have already started Time tracking for another record, Do you want to stop it first ?',    'he_il',    'כבר התחלת במעקב אחר זמן עבור רשומה אחרת, האם ברצונך לעצור אותה תחילה?',    31),
        ('access_denied_routeplanning', 'Access denied for route planning', 'he_il',    'הגישה נדחתה לצורך תכנון המסלול',   31),
        ('time_spent',  'Time Spent',   'he_il',    'זמן ששומש',    31),
        ('select_user', 'Select User',  'he_il',    'בחר משתמש',    30),
        ('status_cannot_be_held',   'Status cannot be held for future date start',  'he_il',    'לא ניתן להחזיק סטטוס לתחילת תאריך עתידי',  30),
        ('please_select_end_date',  'Please select end date',   'he_il',    'אנא בחר תאריך סיום',   30),
        ('please_select_start_date',    'Please select start date', 'he_il',    'אנא בחר תאריך התחלה',  30),
        ('tap_on_plus_icon_for_select_route',   'Tap on + icon to select record for your route.',   'he_il',    'הקש על סמל + כדי לבחור רשומה לנתיב  שלך.', 30),
        ('please_enter_notes',  'Please enter notes',   'he_il',    'אנא הכנס הערות',   30),
        ('please_enter_title',  'Please enter title',   'he_il',    'אנא הכנס כותרת',   30),
        ('please_select_date',  'Please Select Date',   'he_il',    'אנא בחר תאריך',    30),
        ('search_by_date',  'Search by Date',   'he_il',    'חפש לפי תאריך',    30),
        ('shortcut_not_setup_yet',  'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  'he_il',    'אופס,קיצור הדרך עדיין לא הוגדר !!! אנא הוסף קיצור דרך על ידי לחיצה על [סמל] מתוצאות החיפוש הרשומות או הצגת מסך ההקלטה.',   30),
        ('max_upload_size', 'max file Upload exceeds',  'he_il',    'חרגת מכמות העלאה מותרת',   30),
        ('unselect_all',    'UnSelect All', 'he_il',    'בטל את הבחירה בכולם',  30),
        ('select_all',  'Select All',   'he_il',    'בחר הכל',  30),
        ('please_select_records',   'Please select records',    'he_il',    'אנא בחר רשומות',   30),
        ('select_date', 'Select Date',  'he_il',    'בחר תאריך',    30),
        ('quantity_in_stock_is',    'Quantity in stock is', 'he_il',    'הכמות במלאי היא',  30),
        ('replies', 'Replies',  'he_il',    'תגובות',   30),
        ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'he_il',    'המרה מחייבת בחירת איש קשר או ארגון',   30),
        ('please_select_product',   'Please Select Product',    'he_il',    'אנא בחר מוצר', 30),
        ('timer_msg',   'You can start timer for single task only at same time',    'he_il',    'אתה יכול להתחיל טיימר למשימה יחידה רק באותו זמן',  31),
        ('save_start_tracking', 'Save & Start Tracking',    'he_il',    'שמור והתחל במעקב', 31),
        ('lbl_notes',   'Notes',    'he_il',    'הערות',    31),
        ('enter_title', 'Enter Title',  'he_il',    'הזן כותרת',    31),
        ('select_module_record',    'Select Module / Record',   'he_il',    'בחר מודול / רשומה',    31),
        ('lbl_tomorrow',    'Tomorrow', 'he_il',    'מחר',  30),
        ('lbl_yesterday',   'Yesterday',    'he_il',    'אתמול',    30),
        ('lbl_today',   'Today',    'he_il',    'היום', 30),
        ('time_tracker',    'Time Tracker', 'he_il',    'גשש זמן',  31),
        ('time_end',    'End Time', 'he_il',    'זמן סיום', 5),
        ('due_date',    'End Date', 'he_il',    'תאריך סיום',   5),
        ('time_start',  'Time Start',   'he_il',    'זמן התחלה',    5),
        ('date_start',  'Start Date',   'he_il',    'תאריך התחלה',  5),
        ('delete_widget_msg',   'Display widget again by using (+) option', 'he_il',    'הצג יישומון שוב באמצעות אפשרות (+)',   15),
        ('no_upcoming_activities',  'No scheduled activities      ',    'he_il',    'אין פעילויות מתוזמנות',    15),
        ('check_in_first',  'Please check-in first',    'he_il',    'אנא צ\'ק-אין תחילה',   30),
        ('duration',    'Duration', 'he_il',    'משך',  30),
        ('distance',    'Distance', 'he_il',    'מרחק', 30),
        ('proper_address_message',  'Please enter proper address in record\n',  'he_il',    'אנא הזן את הכתובת הנכונה ברשומה',  30),
        ('select_status',   'Select Status',    'he_il',    'בחר סטטוס',    30),
        ('route_planner',   'Route Planner',    'he_il',    'מתכנן נתיב',   30),
        ('route_planning',  'Route Planning',   'he_il',    'תכנון נתיב',   30),
        ('add_route',   'Add Route',    'he_il',    'הוסף נתיב',    30),
        ('calender_disabled',   'Calendar Module is disabled',  'he_il',    'מודול היומן מושבת',    30),
        ('close_dialog',    'Close form',   'he_il',    'סגור טופס',    30),
        ('cancel_form_message', 'Are You sure want to close ?', 'he_il',    'האם אתה בטוח שברצונך לסגור?',  30),
        ('create_route',    'Create Route', 'he_il',    'צור נתיב', 30),
        ('select_module_create_route',  'Select Module to create Route',    'he_il',    'בחר מודול ליצירת נתיב',    30),
        ('cancel',  'Cancel',   'he_il',    'בטל',  30),
        ('assign_route',    'Assign Route', 'he_il',    'הקצה נתיב',    30),
        ('route_for',   'Route for',    'he_il',    'נתיב ל',   30),
        ('assigned_to', 'Assigned To',  'he_il',    'מוקצה אל ',    30),
        ('enter_route_name',    'Enter Route Name', 'he_il',    'הזן את שם נתיב',   30),
        ('list',    'List', 'he_il',    'רשימה',    30),
        ('map', 'Map',  'he_il',    'מפה',  30),
        ('other_modules',   'Other Modules',    'he_il',    'מודולים אחרים',    15),
        ('shortcut_no_record_msg',  'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 'he_il',    'אופס קיצור הדרך  לא הוגדר   עדיין!!! אנא הוסף קיצור דרך על ידי לחיצה על סמל + מתוך הרשומה  תוצאות חיפוש או הצג מסך רשומה.',    25),
        ('clear',   'Clear',    'he_il',    'נקה',  25),
        ('open',    'Open', 'he_il',    'פתח',  11),
        ('max_file_msg',    'Too many files selected (max:6)',  'he_il',    'נבחרו יותר מדי קבצים (מקסימום: 6)',    11),
        ('error_voicenote_record',  'Unable to recording voice while another application is recording sound.',  'he_il',    'לא ניתן להקליט קול בזמן שיישום אחר מקליט צליל.',   11),
        ('msg_warning', 'Warning!', 'he_il',    'אַזהָרָה!',    11),
        ('Permision_denied_contact',    'Permission denied to access your contacts',    'he_il',    'הרשאה נדחתה לגשת לאנשי הקשר שלך',  15),
        ('no_widget_added', 'Please click + icon to add new widget to your dashboard.', 'he_il',    'לחץ על סמל + כדי להוסיף יישומון חדש למרכז השליטה שלך.',    15),
        ('no_data_available',   'Data not available, please check the selected fields', 'he_il',    'נתונים אינם זמינים, אנא בדוק את השדות שנבחרו', 15),
        ('check_out_successfully',  'Check out successfully',   'he_il',    'בדוק בהצלחה',  11),
        ('check_in_successfully',   'Check in successfully',    'he_il',    'צ\'ק-אין בהצלחה',  11),
        ('check_out',   'Check out',    'he_il',    'לבדוק',    11),
        ('check_in',    'Check in', 'he_il',    'קבלה', 11),
        ('navigate',    'Navigate', 'he_il',    'נווט', 11),
        ('save_to_phone_vcard_success', 'VCard Saved to phone successfully',    'he_il',    'VCard נשמר בטלפון בהצלחה', 15),
        ('download_vcard_success',  'VCard downloaded successfully',    'he_il',    'הורדת ה- VCard הושלמה בהצלחה', 15),
        ('card_details',    'Card Details', 'he_il',    'פרטי כרטיס',   15),
        ('add_widget',  'Add Widget',   'he_il',    'הוסף יישומון', 15),
        ('delete_widget',   'Are you sure to hide widget?', 'he_il',    'האם אתה בטוח רוצה להסתיר יישומון?',    15),
        ('already_widgets_added',   'All types of Widget & reports are already added',  'he_il',    'כל סוגי היישומונים והדוחות כבר נוספו', 15),
        ('retry',   'Retry',    'he_il',    'נסה שוב',  28),
        ('retake',  'Retake',   'he_il',    'צלם שוב',  28),
        ('Reports', 'Reports',  'he_il',    'דוחות',    15),
        ('Widgets', 'Widgets',  'he_il',    'יישומונים',    15),
        ('vcard_config',    'Vcard Configuration',  'he_il',    'תצורת Vcard',  8),
        ('save_to_phone',   'Save to phone',    'he_il',    'שמור בטלפון',  11),
        ('download_vcard',  'Download Vcard',   'he_il',    'הורד את ה Vcard',  11),
        ('share_vcard', 'Share Vcard',  'he_il',    'שתף את ה Vcard',   11),
        ('share_record',    'Share Record', 'he_il',    'שתף רשומה',    11),
        ('permission_denied_edit',  'You don\'t have permission to edit this record.',  'he_il',    'אין לך הרשאה לערוך רשומה זו.', 27),
        ('permission_denied_delete',    'You don\'t have permission to delete this record.',    'he_il',    'אין לך הרשאה למחוק רשומה זו.', 27),
        ('Voice_Recording_Started', 'Recording Started',    'he_il',    'ההקלטה התחילה',    12),
        ('Voice_Recording_Stopped', 'Recording Stopped',    'he_il',    'ההקלטה הופסקה',    12),
        ('SEARCH',  'Search',   'he_il',    'חיפוש',    7),
        ('LAST',    'Last', 'he_il',    'אחרון',    7),
        ('FIRST',   'First',    'he_il',    'ראשון',    7),
        ('MONDAY',  'Monday',   'he_il',    'יום שני',  7),
        ('TUESDAY', 'Tuesday',  'he_il',    'יום שלישי',    7),
        ('WEDNESDAY',   'Wednesday',    'he_il',    'יום רביעי',    7),
        ('THURSDAY',    'Thursday', 'he_il',    'יום חמישי',    7),
        ('FRIDAY',  'Friday',   'he_il',    'יום שישי', 7),
        ('SATURDAY',    'Saturday', 'he_il',    'שבת',  7),
        ('SUNDAY',  'Sunday',   'he_il',    'יום ראשון',    7),
        ('DAILY',   'Daily',    'he_il',    'יום יומי', 7),
        ('WEEKLY',  'Weekly',   'he_il',    'יומי', 7),
        ('MONTHLY', 'Monthly',  'he_il',    'שבועי',    7),
        ('YEARLY',  'Yearly',   'he_il',    'שנתי', 7),
        ('asset_tracking',  'Asset tracking',   'he_il',    'איתור נכסים',  15),
        ('open_file',   'Open File',    'he_il',    'פתח קובץ', 1),
        ('download_pdf_successfully',   'Download PDF Successfully',    'he_il',    'קובץ PDF ירד בהצלחה',  1),
        ('select_pdf',  'Select PDF',   'he_il',    'בחר PDF',  1),
        ('email_pdf',   'Email PDF',    'he_il',    'שלח PDF בדואר אלקטרוני',   1),
        ('download_pdf',    'Download PDF', 'he_il',    'הורד PDF', 1),
        ('edit_route',  'Edit Route',   'he_il',    'ערוך נתיב',    1),
        ('save_route',  'Save Route',   'he_il',    'שמור נתיב',    1),
        ('clear_all',   'Clear All',    'he_il',    'נקה הכל',  1),
        ('notification',    'Notifications',    'he_il',    'התראה',    1),
        ('menu_management', 'Menu Management',  'he_il',    'ניהול תפריט',  1),
        ('select_menu', 'Select Menu',  'he_il',    'בחר תפריט',    1),
        ('module_record_not_found', 'Module and Record not found',  'he_il',    'מודול ורשומה לא נמצאו',    1),
        ('reason_for_changing_comments',    'Reason for changing comments', 'he_il',    'סיבה לשינוי הערות',    1),
        ('edit_reason', 'Edit Reason',  'he_il',    'ערוך סיבה',    1),
        ('create_filters',  'Create Filter',    'he_il',    'צור מסנן', 1),
        ('you_checked', 'You Checked',  'he_il',    'סימנת בחירה',  1),
        ('you_un_checked',  'You UnChecked',    'he_il',    'ביטלת בחירה',  1),
        ('log_the_call',    'Log the call ?',   'he_il',    'לרשום את השיחה?',  1),
        ('add_a_description_(optional)',    'Add a description (optional)', 'he_il',    'הוסף תיאור (אופציונלי)',   1),
        ('called',  'Called',   'he_il',    'התקשרת',   1),
        ('call_log',    'Call Log', 'he_il',    'תיעוד שיחות',  1),
        ('subject', 'Subject',  'he_il',    'נושא', 1),
        ('add_condition',   'Add Condition',    'he_il',    'הוספת תנאי',   1),
        ('select_condition',    'Select Condition', 'he_il',    'בחר תנאי', 1),
        ('select_field',    'Select Field', 'he_il',    'בחר שדה',  1),
        ('please_select_first_field',   'Please First Select field',    'he_il',    'בבקשה קודם בחר שדה',   1),
        ('filter_name', 'Filter Name',  'he_il',    'סנן שם',   1),
        ('enter_filter_name',   'Enter filter name',    'he_il',    'הכנס שם מסנן', 1),
        ('choose_conditions',   'Choose Conditions',    'he_il',    'בחר תנאים',    1),
        ('all_condition',   'All Conditions(All conditions must be met)',   'he_il',    'כל התנאים (כל התנאים חייבים להתאים)',  1),
        ('any_condition',   'Any Conditions(At least one the conditions must be met)',  'he_il',    'תנאים שונים (תנאי אחד לפחות חייב להתאים)', 1),
        ('lattitude',   'latitude', 'he_il',    'קו רוחב',  1),
        ('notification_settings',   'Notification Settings',    'he_il',    'הגדרת התראות', 1),
        ('notification_management', 'Notification Management',  'he_il',    'ניהול התראות', 1),
        ('addyourcommentshere', 'Type @ to mention user',   'he_il',    'כתוב @ לתיוג משתמש',   1),
        ('google_api_key_missing',  'Google Api key is missing.',   'he_il',    'מפתח Google API חסר',  1),
        ('event_filter_by', 'Event Filter by',  'he_il',    'סנן אירועים לפי',  1),
        ('apply',   'Apply',    'he_il',    'החל',  1),
        ('choose_from_gallery', 'Choose From Gallery',  'he_il',    'בחר מגלריה',   1),
        ('choose_from_camera',  'Choose From Camera',   'he_il',    'בחר ממצלמה',   1),
        ('mutli_select_CB', 'Mutli Select CB',  'he_il',    'תיבת בחירה מרובת אפשרויות',    1),
        ('please_select_condition', 'Please Select Condition',  'he_il',    'בחר תנאי', 1),
        ('please_enter_value_or_field', 'Please Enter Value or Field',  'he_il',    'הכנס ערך או שדה',  1),
        ('set_as_default',  'Set as Default',   'he_il',    'סמן כברירת מחדל',  1),
        ('list_in_metrics', 'List in Metrics',  'he_il',    'הצג במדידת ביצועים',   1),
        ('order_number',    'Order Number', 'he_il',    'מספר הזמנה',   1),
        ('recording_saved_message', 'Recording saved successfully.',    'he_il',    'ההקלטה נשמרה בהצלחה.', 1),
        ('recording_file',  'Recording File',   'he_il',    'קובץ הקלטה',   1),
        ('file_not_found',  'File not found',   'he_il',    'הקובץ לא נמצא',    1),
        ('please_enter_valid_path', 'Please enter valid path',  'he_il',    'נא להזין נתיב חוקי',   1),
        ('enter_path_here', 'Enter path here...',   'he_il',    'הזן נתיב כאן...',  1),
        ('set_call_recording_path', 'Set Call Recording Path',  'he_il',    'הגדר נתיב הקלטת שיחות',    1),
        ('set_call_recording_path_here',    'Set call recording path here', 'he_il',    'הגדר את נתיב הקלטת השיחה כאן', 1),
        ('call_recording_path', 'Call Recording Path',  'he_il',    'נתיב הקלטת שיחות', 1),
        ('please_place_api',    'Please enable place api',  'he_il',    'אנא הפעל את מקום API', 1),
        ('event_filters_by',    'Event Filters by', 'he_il',    'מסננים אירועים לפי',   1),
        ('select_at_least_one_option',  'Please select at least one option',    'he_il',    'אנא בחר באפשרות אחת לפחות',    1),
        ('enable_call_feature', 'Please enable call feature',   'he_il',    'אנא הפעל את תכונת השיחה',  1),
        ('enable_email_feature',    'Please enable email feature',  'he_il',    'אנא הפעל את תכונת האימייל',    1),
        ('demo_login',  'Demo Login',   'he_il',    'כניסה להדגמה', 1),
        ('select_email_template',   'Select Email Template',    'he_il',    'בחר תבנית דוא\"ל', 1),
        ('template_name',   'Template Name',    'he_il',    'שם התבנית',    1),
        ('example_storage_path',    'example : storage/Music/Recordings/Call Recordings',   'he_il',    'דוגמה: אחסון/מוזיקה/הקלטות/הקלטות שיחות',  1),
        ('User Notification Settings saved successfully',   'User Notification Settings saved successfully',    'he_il',    'הגדרות התראות משתמש נשמרו בהצלחה', 33),
        ('This Notification has been disabled by admin',    'This Notification has been disabled by admin', 'he_il',    'הודעה זו הושבתה על ידי מנהל המערכת',   33),
        ('Notify when any updates to the record you\'re following', 'Notify when any updates to the record you\'re following',  'he_il',    'הודע כאשר יש עדכונים לרשומה שאתה עוקב אחריהם', 33),
        ('Task assigned to you',    'Task assigned to you', 'he_il',    'משימה שהוטלה עליך',    33),
        ('Task Reminder',   'Task Reminder',    'he_il',    'תזכורת למשימה',    33),
        ('You were mentioned in comments',  'You were mentioned in comments',   'he_il',    'הזכירו אותך בתגובות',  33),
        ('Comments has been added to record assigned to you',   'Comments has been added to record assigned to you',    'he_il',    'הערות נוספו לרשומה שהוקצתה לך',    33),
        ('When Record Assigned',    'When Record Assigned', 'he_il',    'כאשר הרשומה הוקצה',    33),
        ('Event Reminder',  'Event Reminder',   'he_il',    'תזכורת לאירוע',    33),
        ('Event Invitation',    'Event Invitation', 'he_il',    'הזמנה לאירוע', 33),
        ('Follow record',   'Follow record',    'he_il',    'עקוב אחר הרשומה',  33),
        ('Task',    'Task', 'he_il',    'מְשִׁימָה',    33),
        ('Conversions', 'Conversions',  'he_il',    'המרות',    33),
        ('Events',  'Events',   'he_il',    'אירועים',  33),
        ('no_records_changed_filter_message',   'No record(s) found Please click on filter icon to change filter',  'he_il',    'לא נמצאו רשומות אנא לחץ על סמל המסנן כדי לשנות מסנן',  1),
        ('title',   'Title',    'he_il',    'כותרת',    1),
        ('dialog_recent_call_info', 'Click + to select your mobile call recording folder where your recorded call files are stored.',   'he_il',    'לחץ על + כדי לבחור את תיקיית הקלטת השיחות שלך לנייד שבה מאוחסנים קבצי השיחות המוקלטות שלך.',   1),
        ('call_recording',  'Call recording',   'he_il',    'הקלטת שיחה',   1),
        ('voice_recorder',  'Voice Recorder',   'he_il',    'מקליט קול',    1),
        ('no_address_reference_found',  'No Address Reference found',   'he_il',    'No Address Reference found',   32),
        ('no_overdue_activities',   'No OverDue Activities',    'he_il',    'אין פעילויות באיחור',  32),
        ('latitude_longitude_validation_message',   'Please enter proper address from this address we are not getting proper latitude and longitude',   'he_il',    'אנא הזן כתובת נאותה מכתובת זו. אנחנו לא מקבלים קו רוחב וקו אורך מתאימים',  32),
        ('Default_Search_Field',    'Default search field', 'he_il',    'שדה חיפוש ברירת מחדל', 32),
        ('Calender_Reminder_Message',   'Free user can\'t send local reminder', 'he_il',    'משתמש חינם לא יכול לשלוח תזכורת מקומית',   32),
        ('you_must_have_permission',    'You must give permissions to use this features.',  'he_il',    'עליך לתת הרשאות כדי להשתמש בתכונות אלו.',  32),
        ('internal_comment',    'Internal Comment', 'he_il',    'הערה פנימית',  1),
        ('unlink_record',   'Unlink Record',    'he_il',    'בטל קישור רשומה',  11),
        ('unlink_record_msg',   'Are you sure want to unlink record?',  'he_il',    'האם אתה בטוח שברצונך לבטל את הקישור לרשומה?',  11),
        ('file_format_not_support', 'File format not supported',    'he_il',    'פורמט קובץ אינו נתמך', 11),
        ('file_upload', 'File Upload',  'he_il',    'העלאת קובץ',   5),
        ('to_vtiger',   'To Vtiger',    'he_il',    'ל-Vtiger', 5),
        ('link_external_document',  'Link External Document',   'he_il',    'קישור מסמך חיצוני',    5),
        ('from_file_url',   'From File Url',    'he_il',    'מתוך כתובת האתר של הקובץ', 5),
        ('create_new_document', 'Create New Document',  'he_il',    'צור מסמך חדש', 5),
        ('select_document_type',    'Select Document type', 'he_il',    'בחר סוג מסמך', 5),
        ('add_signature',   'Please add signature', 'he_il',    'נא להוסיף חתימה',  11),
        ('date_greater_then_equal', 'should be greater than or equal to',   'he_il',    'צריך להיות גדול או שווה ל',    1),
        ('date_less_then_equal',    'should be less than or equal to',  'he_il',    'צריך להיות קטן או שווה ל', 1),
        ('Click_on_plus_for_add',   'Please tap on  +  to create a new record.',    'he_il',    'אנא הקש על + כדי ליצור רשומה חדשה.',   15),
        ('display_map', 'Display map',  'he_il',    'הצג מפה',  15),
        ('other_settings',  'Other settings',   'he_il',    'הגדרות אחרות', 15),
        ('total_hours', 'Total hours',  'he_il',    'סה\"כ שעות',   15),
        ('widget_not_found',    'No widgets found', 'he_il',    'לא נמצאו ווידג\'טים',  15),
        ('quickaction', 'Quick action', 'he_il',    'פעולה מהירה',  15),
        ('dashboard',   'Dashboard',    'he_il',    'לוּחַ מַחווָנִים', 15),
        ('new', 'New',  'he_il',    'חָדָשׁ',   15),
        ('global_search_hint',  'Please try to search using search box at top', 'he_il',    'אנא נסה לחפש באמצעות תיבת החיפוש בחלק העליון', 15),
        ('near_by_map', 'Near By Map',  'he_il',    'ליד מפה',  15),
        ('miles',   'Miles',    'he_il',    'מיילס',    15),
        ('lbl_filters', 'Filters',  'he_il',    'מסננים',   27),
        ('warning', 'Warning',  'he_il',    'אַזהָרָה', 27),
        ('no_filter_created',   'No filter is created.',    'he_il',    'לא נוצר מסנן.',    27),
        ('please_create_new_ilter', 'Please create a new filter',   'he_il',    'נא ליצור מסנן חדש',    27),
        ('select_search_fields',    'Select fields for the search record.', 'he_il',    'בחר שדות עבור רשומת החיפוש.',  27),
        ('apply_fliters',   'Apply filters',    'he_il',    'החל מסננים',   27),
        ('sort_by', 'Sort by',  'he_il',    'מיין לפי', 27),
        ('sort_order',  'Sort order',   'he_il',    'סדר המיון',    27),
        ('Start_time_tracking', 'Start time tracking',  'he_il',    'התחל מעקב אחר זמן',    31),
        ('Stop_time_tracking',  'Stop time tracking',   'he_il',    'הפסק את מעקב הזמן',    31),
        ('image_preview',   'Image preview',    'he_il',    'תצוגה מקדימה של תמונה',    11),
        ('phone_number',    'Phone number', 'he_il',    'מספר טלפון',   11),
        ('email_address',   'Email address',    'he_il',    'כתובת דוא\"ל', 11),
        ('edit_your_preferences',   'Edit your preferences',    'he_il',    'ערוך את ההעדפות שלך',  8),
        ('about_app',   'About app',    'he_il',    'לגבי אפליקציה',    8),
        ('updated_ctmobile_ext_version',    'You already have latest CTMobile Ext. Version',    'he_il',    'כבר יש לך את ה-CTMobile Ext. גִרְסָה', 8),
        ('updated_app_version', 'You already have latest CRMTiger App Version', 'he_il',    'כבר יש לך את גרסת האפליקציה האחרונה של CRMTiger',  8),
        ('plan',    'Plan', 'he_il',    'לְתַכְנֵן',    8),
        ('time',    'Time', 'he_il',    'זְמַן',    31),
        ('error_log_msg',   'Oops, something went wrong! Please click on Share Button to share error log with our technical team',  'he_il',    'אופס! משהו השתבש! אנא לחץ על לחצן השיתוף כדי לשתף יומן שגיאות עם הצוות הטכני שלנו',    1),
        ('add_to_quick_action', 'Add to quick action',  'he_il',    'הוסף לפעולה מהירה',    1),
        ('add_filter_to_quick_action',  'Add filter to quick action',   'he_il',    'הוסף מסנן לפעולה מהירה',   1),
        ('create_record',   'Create Record',    'he_il',    'צור רשומה',    1),
        ('quick_action_hint',   'You can Add Quick Action here',    'he_il',    'אתה יכול להוסיף פעולה מהירה כאן',  1),
        ('str_send',    'Send', 'he_il',    'לִשְׁלוֹחַ',   3),
        ('tax_region_msg',  'Do you want to update tax & charge values corresponding to selected region?',  'he_il',    'האם ברצונך לעדכן ערכי מס וחיוב התואמים לאזור שנבחר?',  1),
        ('delete_quick_action_widgest', 'Delete Widget?',   'he_il',    'למחוק ווידג\'ט?',  15),
        ('add_record_to_dashboard', 'Add record to dashboard',  'he_il',    'הוסף רשומה ללוח המחוונים', 15),
        ('module_quick_action_msg', 'Module added to dashboard',    'he_il',    'מודול נוסף ללוח המחוונים', 15),
        ('filter_quick_action_msg', 'Filter added to dashboard',    'he_il',    'מסנן נוסף ללוח המחוונים',  15),
        ('record_quick_action_msg', 'Record added to dashboard',    'he_il',    'רשומה נוספה ללוח המחוונים',    15),
        ('filter_shortcut_quick_action_msg',    'Filter shortcut added to dashboard',   'he_il',    'קיצור דרך מסנן נוסף ללוח המחוונים',    15),
        ('record_shortcut_quick_action_msg',    'Record shortcut added to dashboard',   'he_il',    'קיצור הקלטה נוסף ללוח המחוונים',   15),
        ('documents_disabled',  'Documents Module is disabled', 'he_il',    'מודול המסמכים מושבת',  1),
        ('document_dont_attachment',    'Document does not have a attachment',  'he_il',    'למסמך אין קובץ מצורף', 1),
        ('go_to_neat_by',   'Go to NearBy', 'he_il',    'עבור אל NearBy',   15),
        ('go_to_time_tracking', 'Go to Time Tracker',   'he_il',    'עבור ל-Time Tracker',  13),
        ('nearby_quick_action_msg', 'NearBy added to dashboard',    'he_il',    'NearBy נוסף ללוח המחוונים',    15),
        ('time_tracking_quick_action_msg',  'Time Tracking added to dashboard', 'he_il',    'מעקב אחר זמן נוסף ללוח המחוונים',  15),
        ('attendance_quick_action_msg', 'Attendance added to dashboard',    'he_il',    'נוכחות נוספה ללוח המחוונים',   15),
        ('attachment',  'Attachment',   'he_il',    'הִתקַשְׁרוּת', 15),
        ('search_by_fields',    'Search by fields', 'he_il',    'חפש לפי שדות', 27),
        ('apply_selected',  'Apply selected',   'he_il',    'החל את הבחירה',    27),
        ('auto_address_disabled',   'auto address finder is disabled, please enable it from CRMTiger Settings', 'he_il',    'מאתר הכתובות האוטומטי מושבת, אנא הפעל אותו מהגדרות CRMTiger',  1),
        ('Attendance',  'Attendance',   'he_il',    'נוֹכְחוּת',    15),
        ('Check-in successfully',   'Check-in successfully',    'he_il',    'צ\'ק-אין בהצלחה',  32),
        ('Check-out successfully',  'Check-out successfully',   'he_il',    'צ\'ק-אאוט בהצלחה', 32),
        ('Nothing around here', 'Nothing around here',  'he_il',    'שום דבר בסביבה',   13),
        ('select_days', 'Select Days',  'he_il',    'בחר ימים', 5),
        ('select_minutes',  'Select Minutes',   'he_il',    'בחר דקות', 5),
        ('select_hours',    'Select Hours', 'he_il',    'בחר שעות', 5),
        ('no_lat_long_found',   'Location information (Latitude,Longitude) not found',  'he_il',    'מידע מיקום (קו רוחב, קו אורך) לא נמצא',    32),
        ('Call Log save successfully',  'Call Log save successfully',   'he_il',    'שמור יומן שיחות בהצלחה',   32),
        ('Files/photos deleted successfully',   'Files/photos deleted successfully',    'he_il',    'קבצים/תמונות נמחקו בהצלחה',    32),
        ('important',   'Important',    'he_il',    'חָשׁוּב',  34),
        ('template',    'Template', 'he_il',    'תבנית',    34),
        ('copy',    'Copy', 'he_il',    'עותק', 34),
        ('camera',  'Camera',   'he_il',    'מַצלֵמָה', 34),
        ('gallery', 'Gallery',  'he_il',    'גלריה',    34),
        ('audio',   'Audio',    'he_il',    'שֶׁמַע',   34),
        ('last_seen_at',    'Last seen at', 'he_il',    'נראה לאחרונה ב',   34),
        ('type_a_message',  'Type a message',   'he_il',    'הקלד הודעה',   34),
        ('all_messages',    'All messages', 'he_il',    'כל ההודעות',   34),
        ('time_tracking_reports',   'Time tracking reports',    'he_il',    'דוחות מעקב אחר זמן',   31),
        ('attendance_reports',  'Attendance reports',   'he_il',    'דוחות נוכחות', 31),
        ('chats',   'Chats',    'he_il',    'צ\'אטים',  34),
        ('Marked chat as Important',    'Marked chat as Important', 'he_il',    'סימן את הצ\'אט כחשוב', 34),
        ('Unmarked chat as Important',  'Unmarked chat as Important',   'he_il',    'בטל את סימון הצ\'אט כחשוב',    34),
        ('mark_as_important',   'Mark as important',    'he_il',    'סמן כחשוב',    34),
        ('unmark_As_important', 'Unmark as important',  'he_il',    'בטל את הסימון כחשוב',  34),
        ('select_template', 'Select template',  'he_il',    'בחר תבנית',    34),
        ('chat',    'Chat', 'he_il',    'לְשׂוֹחֵחַ',   34),
        ('search_by_name_or_contact',   'Search by name or contact',    'he_il',    'חפש לפי שם או איש קשר',    34),
        ('choose_contact_for_whatsApp', 'Choose contact for whatsApp',  'he_il',    'בחר איש קשר לוואטסאפ', 34),
        ('whatsapp_template',   'Whatsapp template',    'he_il',    'תבנית וואטסאפ',    34),
        ('send_voice_recording',    'Send voice recording', 'he_il',    'שלח הקלטת קול',    34),
        ('slide_to_cancel', 'Slide To Cancel',  'he_il',    'החלק לביטול',  34),
        ('whatsapp_disconnect_messsage',    'Ooops.. You\'re disconnected from WhatsApp. Please Scan QR Code from the CRM.',    'he_il',    'אופס...נותקת מוואטסאפ...אנא סרוק שוב את קוד ה-QR והשאר את הטלפון מחובר לאינטרנט!', 34),
        ('select_priority', 'Select priority',  'he_il',    'בחר עדיפות',   30),
        ('repeat_route',    'Repeat route', 'he_il',    'חזור על המסלול',   30),
        ('change_assign_to',    'Change assigned to',   'he_il',    'השינוי הוקצה ל',   30),
        ('Multiple Route created successfully', 'Multiple Route created successfully',  'he_il',    'מסלול מרובה נוצר בהצלחה',  30),
        ('Route duplicated successfully',   'Route duplicated successfully',    'he_il',    'המסלול שוכפל בהצלחה',  30);",array());
        }
    }

    static function es_mx(){
        global $adb;
        $checkLang = $adb->pquery("SELECT 1 FROM ctmobile_language_keyword WHERE keyword_lang = ?",array('es_mx'));
        if($adb->num_rows($checkLang) == 0){

            $adb->pquery("INSERT INTO `ctmobile_language_keyword` ( `keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error',   'Network connection error!',    'es_mx',    '¡Error de conexión de red!',   1),
            ('connection_check',    'Could not connect to CRM, Please check your Internet connection.', 'es_mx',    'No se puede conectar con CRM, por favor, compruebe su conexión a Internet.',   1),
            ('update',  'Update',   'es_mx',    'Actualización',    1),
            ('cancel',  'Cancel',   'es_mx',    'Cancelar', 1),
            ('ok',  'Ok',   'es_mx',    'OK',   1),
            ('more_information',    'Click here for more information.', 'es_mx',    'Haga clic aquí para más información.', 1),
            ('yes', 'Yes',  'es_mx',    'Sí',   1),
            ('no',  'No',   'es_mx',    'No',   1),
            ('click_again_exit',    'Click again to exit',  'es_mx',    'Haga clic de nuevo para salir',    1),
            ('forpermission',   'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.',   'es_mx',    'No tienes permiso para ver esta característica. Por favor suscriba para la versión Premium Haga clic aquí para Suscribir.',    1),
            ('clickhere',   'Click here',   'es_mx',    'Haz clic aquí',    1),
            ('clickhere_subscribe', 'Click here to subscribe premium version',  'es_mx',    'Haz clic aquí para suscribirte',   1),
            ('clickhere_configure', 'Click here and view how to Configure.',    'es_mx',    'Haz clic aquí para ver cómo configurar.',  1),
            ('please_wait', 'Please Wait…', 'es_mx',    'Por favor espere...',  1),
            ('share__msg',  'Share file with',  'es_mx',    'compartir archivo con',    1),
            ('dialog_camera',   'Camera',   'es_mx',    'Cámara',   1),
            ('dialog_add_file_by',  'Take Photo from',  'es_mx',    'Añadir archivos por',  1),
            ('add', 'Add',  'es_mx',    'Añadir',   1),
            ('mail_manager_configured', 'Mail Manager is not configured',   'es_mx',    'El administrador de correos no está configurado',  1),
            ('dialog_add_files_by', 'Add Files by', 'es_mx',    'Añadir archivos por',  1),
            ('dialog_drive',    'Drive',    'es_mx',    'Conduce',  1),
            ('dialog_drop_box', 'Drop Box', 'es_mx',    'Caja de caja', 1),
            ('dialog_need_signin',  'You need to Sign-in to your Drive account first.', 'es_mx',    'Primero necesitas registrarte en tu cuenta Drive.',    1),
            ('dialog_gallery',  'Gallery',  'es_mx',    'Galería',  1),
            ('delete',  'Delete',   'es_mx',    'Borrar',   1),
            ('timeoutmessage',  'Oops! Request is taking more time than expected.', 'es_mx',    'Ups! la solicitud está tardando más de lo esperado.',  1),
            ('gps_location_message',    'GPS is not enabled. Please turn it on to get your near by locations.', 'es_mx',    'El GPS no está habilitado. Por favor enciéndelo para obtener tus ubicaciones cercanas.',   1),
            ('sure_want_delete',    'Are you sure want to delete ?',    'es_mx',    '¿Estás seguro que quieres borrar?',    1),
            ('select',  'Select',   'es_mx',    'Seleccionar',  1),
            ('msgforrecordaudio',   'Minimum record duration one second.',  'es_mx',    'Duración mínima de grabación: un minuto',  1),
            ('permission_storage',  'Permission denied to read your External storage',  'es_mx',    'Permiso denegado para leer tu almacenamiento externo', 1),
            ('send_permission_msg', 'Send message permission denied',   'es_mx',    'Permiso para enviar mensaje denegado', 1),
            ('choosefile',  'Choose File',  'es_mx',    'Seleccione un archivo',    1),
            ('enter',   'Enter',    'es_mx',    'Entra',    1),
            ('select_an_option',    'Select an Option', 'es_mx',    'Elija una opción', 1),
            ('email_validation',    'Email is not valid',   'es_mx',    'El email no es válido',    1),
            ('please_enter',    'Please Enter', 'es_mx',    'Por favor ingresa',    1),
            ('website_validation_text', 'Website URL is not valid', 'es_mx',    'La url del sitio web no es válida',    1),
            ('selectvalue', 'Select value first',   'es_mx',    'Selecciona el valor primero',  1),
            ('email',   'Email',    'es_mx',    'Correo electrónico',   1),
            ('enter_email_address', 'Enter email address',  'es_mx',    'Introduzca la dirección de correo electrónico',    1),
            ('email_address_not_correct',   'Email address incorrect',  'es_mx',    'Introduzca la dirección de correo electrónico',    1),
            ('pls_enter_subject',   'Please Enter Subject', 'es_mx',    'Por favor ingresa el asunto',  1),
            ('attachFiles', 'Attached File',    'es_mx',    'Archivo adjunto',  1),
            ('from',    'From', 'es_mx',    'De',   1),
            ('to',  'To',   'es_mx',    'Para', 1),
            ('call_permission_msg', 'Call permission denied',   'es_mx',    'Permiso de llamada denegado',  1),
            ('no_records',  'No records found', 'es_mx',    'No se encontraron registros',  1),
            ('fullform',    'Create New',   'es_mx',    'Forma completa',   1),
            ('save',    'Save', 'es_mx',    'Guardar',  1),
            ('total',   'Total',    'es_mx',    'Total',    1),
            ('discount',    'Discount', 'es_mx',    'Descuento',    1),
            ('price',   'Price',    'es_mx',    'Precio *', 1),
            ('quantity',    'Quantity', 'es_mx',    'Cantidad *',   1),
            ('select_module',   'Select Module',    'es_mx',    'Seleccionar módulo',   1),
            ('item_list',   'Item List',    'es_mx',    'Lista de Items',   1),
            ('quickcreate', 'Quick Create', 'es_mx',    'Creación rápida',  1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'es_mx',    'Sobre escribir la direcccion actual con los detalles ',    1),
            ('once_in_every',   'Once in every',    'es_mx',    'Una vez cada', 1),
            ('overwrite_msg_part2', 'address details?', 'es_mx',    'de la dirección elegida?', 1),
            ('add_item',    'Add Item', 'es_mx',    'Añadir Item',  1),
            ('recordsave',  'Record saved successfully',    'es_mx',    'Registro guardado exitosamente',   1),
            ('recordnotsave',   'Could not save record. Try again later',   'es_mx',    'Registro no guardado', 1),
            ('minutes', 'Minutes',  'es_mx',    'Minutos',  1),
            ('hours',   'Hours',    'es_mx',    'horas',    1),
            ('days',    'Days', 'es_mx',    'Días', 1),
            ('on',  'On',   'es_mx',    'El',   1),
            ('day_of_the_month',    'day of the month', 'es_mx',    'día del mes',  1),
            ('list_price',  'List Price',   'es_mx',    'Precio de lista *',    1),
            ('add_record',  'Add Record',   'es_mx',    'Añadir registro',  1),
            ('add_product', 'Add Product',  'es_mx',    'Añadir Producto',  1),
            ('add_service', 'Add Service',  'es_mx',    'Añadir Servicio',  1),
            ('discountin',  'Discount in %',    'es_mx',    'Descuento en %',   1),
            ('unitprice',   'Unit price',   'es_mx',    'Precio unitario *',    1),
            ('netprice',    'Net price',    'es_mx',    'Precio neto *',    1),
            ('comments',    'Comments', 'es_mx',    'Comentarios',  1),
            ('add_close',   'Add & Close',  'es_mx',    'Añadir y cerrar',  1),
            ('fetching_rout_message',   'Fetching route, Please wait…', 'es_mx',    'Buscando la ruta, espere por favor…',  1),
            ('setting', 'Settings', 'es_mx',    'Configuración',    1),
            ('utc', 'UTC',  'es_mx',    'UTC',  1),
            ('in',  'In',   'es_mx',    'En',   1),
            ('days_ago',    'days ago', 'es_mx',    'días', 1),
            ('mins_ago',    'Minutes ago',  'es_mx',    'minutos',  1),
            ('justnow', 'Just now', 'es_mx',    'Ahora mismo',  1),
            ('hours_ago',   'hours ago',    'es_mx',    'horas',    1),
            ('in_1_day',    'In 1 day', 'es_mx',    'Dentro de 1 día',  1),
            ('scanqrcode',  'Asset / Card Scanner', 'es_mx',    'QR Card Scanner',  1),
            ('call_log',    'Call Log', 'es_mx',    'Bitácora de llamada',  1),
            ('voice_message',   'Hi',   'es_mx',    'Hola', 1),
            ('voice_message1',  'What can I search for you in', 'es_mx',    'Que quieres que busque',   1),
            ('live_tracking',   'Live Tracking',    'es_mx',    'Rastreo en vivo',  1),
            ('mailmanager', 'Mail Manager', 'es_mx',    'Administrador de correo',  1),
            ('my_location', 'My location',  'es_mx',    'Mi ubicación', 1),
            ('created_on',  'Created On',   'es_mx',    'Creado en',    1),
            ('modified_on', 'Modified On',  'es_mx',    'Modificado en',    1),
            ('enter_comments',  'Enter Comments',   'es_mx',    'Introducir comentarios',   1),
            ('viewmore',    'View More',    'es_mx',    'Ver más',  1),
            ('viewless',    'View Less',    'es_mx',    'Ver menos',    1),
            ('gotofullform',    'Go to Full Form',  'es_mx',    'Ir a la forma completa',   1),
            ('post',    'Post', 'es_mx',    'Postear',  1),
            ('url', 'URL',  'es_mx',    'URL',  1),
            ('dialog_title_text_back_color',    'Select a Text Background Color',   'es_mx',    'Selecciona un color para fondo de texto',  1),
            ('event_or_task',   'Add event/task',   'es_mx',    'Añadir evento/tarea',  1),
            ('shortcut',    'Shortcuts',    'es_mx',    'Accesos directos', 1),
            ('select_field',    'Select Field', 'es_mx',    'Selecciona el campo',  1),
            ('share',   'Share',    'es_mx',    'Compartir',    1),
            ('title_insert_link',   'Insert Link',  'es_mx',    'Insertar Link',    1),
            ('addyourcommentshere', 'Add your comments here',   'es_mx',    'Añade tus comentarios aquí',   1),
            ('nocomment',   'No Comments',  'es_mx',    'Sin comentarios',  1),
            ('leads',   'Leads',    'es_mx',    'Prospectos',   1),
            ('true_val',    'true', 'es_mx',    'verdadero',    1),
            ('noresult',    'No Result',    'es_mx',    'Sin resultados',   1),
            ('version', 'Version',  'es_mx',    'Versión',  1),
            ('convert_lead',    'Convert Lead', 'es_mx',    ' Convertir Prospecto', 1),
            ('app_name',    'CRMTiger', 'es_mx',    'CRMTiger', 1),
            ('enter_url',   'Please Enter url', 'es_mx',    'Por favor ingresa la url', 1),
            ('help',    'Help', 'es_mx',    'Ayuda',    1),
            ('contact_us',  'Contact Us',   'es_mx',    'Contáctanos',  1),
            ('updates', 'Updates',  'es_mx',    'Actualizaciones',  1),
            ('logout',  'LogOut',   'es_mx',    'LogOut',   1),
            ('busnies_cardscanner', 'Business Card Scanner',    'es_mx',    'Escáner de Tarjeta de Presentación',   1),
            ('sure_want_logout',    'Are you sure want to logout ?',    'es_mx',    '¿Estás seguro que quieres salir?', 1),
            ('logout_message',  'Logout successfully',  'es_mx',    '¿Estás seguro que quieres salir?', 1),
            ('all', 'All',  'es_mx',    'Todo', 1),
            ('add_event',   'Add event',    'es_mx',    'Añadir evento',    1),
            ('add_task',    'Add Task', 'es_mx',    'Añadir tarea', 1),
            ('next',    'Next', 'es_mx',    'Siguiente',    1),
            ('terms_conditions',    'Terms and Conditions', 'es_mx',    'Términos y condiciones',   1),
            ('login',   'Login',    'es_mx',    'Login',    2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy',    'es_mx',    'Al ingresar, aceptas nuestros términos y condiciones &amp; Política de privacidad',    2),
            ('copyright',   'Copyright © 2019 CRMTiger Version',    'es_mx',    'Copyright u00A9 2019 CRMTiger \n Versión', 2),
            ('enter_username',  'Please enter username',    'es_mx',    'Por favor ingresa tu usuario', 2),
            ('enter_password',  'Please enter password',    'es_mx',    'Por favor ingresa tu contraseña',  2),
            ('remanberme',  'Remember Me',  'es_mx',    'Recordarme',   2),
            ('forgot_password', 'Forgot password?', 'es_mx',    '¿Olvidaste tu contraseña?',    2),
            ('privacy_policay1',    'Privacy Policy',   'es_mx',    'Política de privacidad',   2),
            ('contactsupportmsg',   'Something went wrong. \n please Click here to contact support.',   'es_mx',    'Algo salió mal. Por favor haga clic aqui para contactat a soporte',    2),
            ('enter_username_password', 'Entered Username or Password is wrong',    'es_mx',    'El Usuario o la Contraseña ingresada es incorrecta',   2),
            ('server_issue_occured',    'Server issues occurred',   'es_mx',    'Ocurrieron problemas con el servidor', 2),
            ('password',    'Password', 'es_mx',    'Contraseña',   3),
            ('user_name',   'Username', 'es_mx',    'Usuario',  3),
            ('reset_pwd',   'Reset Password',   'es_mx',    'Reestablecer contraseña',  3),
            ('forgot_password_title',   'Forgot password',  'es_mx',    'Olvidé mi contraseña', 3),
            ('enter_user_name', 'Enter user name',  'es_mx',    'Ingresa nombre de usuario',    3),
            ('cc',  'Cc',   'es_mx',    'Cc',   4),
            ('body',    'Body', 'es_mx',    'Cuerpo',   4),
            ('bcc', 'BCC',  'es_mx',    'BCC',  4),
            ('dialog_title_text_color', 'Select a Text Color',  'es_mx',    'Selecciona un color de texto', 4),
            ('date',    'Date', 'es_mx',    'Fecha',    4),
            ('subject', 'Subject',  'es_mx',    'Asunto',   4),
            ('composeMail', 'Compose Mail', 'es_mx',    'Redactar correo',  4),
            ('send',    'Send', 'es_mx',    'Enviar',   4),
            ('select_message',  'Select message',   'es_mx',    'Seleccionar mensaje',  4),
            ('title_insert_table',  'Insert Table', 'es_mx',    'Insertar tabla',   4),
            ('log_file_sms',    'I agree to Share API Log to Technical team for further troubleshooting',   'es_mx',    'Estoy de acuerdo con compartir la Bitácora API con el equipo técnico para seguir solucionando el problema',    5),
            ('edit_record', 'Edit Records', 'es_mx',    'Editar registros', 5),
            ('select_time', 'Select Time',  'es_mx',    'Seleccionar hora', 5),
            ('edit_item',   'Edit Item',    'es_mx',    'Editar Item',  5),
            ('items_total', 'Items Total',  'es_mx',    'Total de items',   5),
            ('number_less_then_31', 'Number should be less than 31',    'es_mx',    'El número deber ser menor a 31',   5),
            ('users',   'Users',    'es_mx',    'Usuarios', 5),
            ('groups',  'Groups',   'es_mx',    'Grupos',   5),
            ('txt_note_for_file',   'Note : Existing attachments(images/files) will be replaced',   'es_mx',    'Nota : Los adjuntos existentes (imágenes/archivos) serán reemplazados',    5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime',   'es_mx',    'La fecha y hora final deben ser mayores que la fecha y hora de inicio',    5),
            ('until',   'Until',    'es_mx',    'Hasta',    5),
            ('organizations',   'Organizations',    'es_mx',    'Organizaciones',   6),
            ('contacts',    'Contacts', 'es_mx',    'Contactos',    6),
            ('opportunity', 'Opportunity',  'es_mx',    'Oportunidad',  6),
            ('lbl_sun', 'SUN',  'es_mx',    'DOM',  7),
            ('lbl_mon', 'MON',  'es_mx',    'LUN',  7),
            ('lbl_tue', 'TUE',  'es_mx',    'MAR',  7),
            ('lbl_wed', 'WED',  'es_mx',    'MIE',  7),
            ('lbl_thu', 'THU',  'es_mx',    'JUE',  7),
            ('lbl_fri', 'FRI',  'es_mx',    'VIE',  7),
            ('lbl_sat', 'SAT',  'es_mx',    'SAB',  7),
            ('lbl_1',   '1',    'es_mx',    '1',    7),
            ('lbl_2',   '2',    'es_mx',    '2',    7),
            ('lbl_3',   '3',    'es_mx',    '3',    7),
            ('lbl_4',   '4',    'es_mx',    '4',    7),
            ('lbl_5',   '5',    'es_mx',    '5',    7),
            ('lbl_6',   '6',    'es_mx',    '6',    7),
            ('lbl_7',   '7',    'es_mx',    '7',    7),
            ('lbl_8',   '8',    'es_mx',    '8',    7),
            ('lbl_9',   '9',    'es_mx',    '9',    7),
            ('lbl_10',  '10',   'es_mx',    '10',   7),
            ('lbl_11',  '11',   'es_mx',    '11',   7),
            ('lbl_12',  '12',   'es_mx',    '12',   7),
            ('lbl_13',  '13',   'es_mx',    '13',   7),
            ('lbl_14',  '14',   'es_mx',    '14',   7),
            ('lbl_15',  '15',   'es_mx',    '15',   7),
            ('lbl_16',  '16',   'es_mx',    '16',   7),
            ('lbl_17',  '17',   'es_mx',    '17',   7),
            ('lbl_18',  '18',   'es_mx',    '18',   7),
            ('lbl_19',  '19',   'es_mx',    '19',   7),
            ('lbl_20',  '20',   'es_mx',    '20',   7),
            ('lbl_21',  '21',   'es_mx',    '21',   7),
            ('lbl_22',  '22',   'es_mx',    '22',   7),
            ('lbl_23',  '23',   'es_mx',    '23',   7),
            ('lbl_24',  '24',   'es_mx',    '24',   7),
            ('lbl_25',  '25',   'es_mx',    '25',   7),
            ('lbl_26',  '26',   'es_mx',    '26',   7),
            ('lbl_27',  '27',   'es_mx',    '27',   7),
            ('lbl_28',  '28',   'es_mx',    '28',   7),
            ('lbl_29',  '29',   'es_mx',    '29',   7),
            ('lbl_30',  '30',   'es_mx',    '30',   7),
            ('lbl_31',  '31',   'es_mx',    '31',   7),
            ('lbl_32',  '32',   'es_mx',    '32',   7),
            ('lbl_33',  '33',   'es_mx',    '33',   7),
            ('lbl_34',  '34',   'es_mx',    '34',   7),
            ('lbl_35',  '35',   'es_mx',    '35',   7),
            ('lbl_36',  '36',   'es_mx',    '36',   7),
            ('lbl_37',  '37',   'es_mx',    '37',   7),
            ('lbl_38',  '38',   'es_mx',    '38',   7),
            ('lbl_39',  '39',   'es_mx',    '39',   7),
            ('lbl_40',  '40',   'es_mx',    '40',   7),
            ('lbl_41',  '41',   'es_mx',    '41',   7),
            ('lbl_42',  '42',   'es_mx',    '42',   7),
            ('current_date',    'current date', 'es_mx',    'fecha actual', 7),
            ('event',   'Events',   'es_mx',    'Eventos',  7),
            ('calendar',    'Calendar', 'es_mx',    'Calendario',   7),
            ('latest_version',  'Latest Version :', 'es_mx',    'Última versión :', 8),
            ('expire_on',   'Expire On :',  'es_mx',    'Expira el :',  8),
            ('ctmobile_ext_version',    'CTMobile Ext. Version :',  'es_mx',    'Versión de la Ext. CRMobile  :',   8),
            ('you_have_latest_version', 'You already have latest version',  'es_mx',    'Tienes la versión actualizada',    8),
            ('latest_version1', 'You Already have latest version',  'es_mx',    'Ya tienes la última versión',  8),
            ('upgreaded',   'Upgrade',  'es_mx',    'Upgrade',  8),
            ('downgrade',   'Downgrade',    'es_mx',    'Downgrade',    8),
            ('dialog_recent_event_info',    'You can set from here how many number of records you want to show on Home screen for Recent Event.',   'es_mx',    'Puedes definir aquí cuántos registros quieres mostrar en la pantalla de inicio para el evento reciente.',  8),
            ('dialog_feedback_info',    'You can submit your feedback with description , our team will check your feedback and get back to you.',   'es_mx',    'Puedes enviar tu retroalimentación con la descripción, nuestro equipo revisará tu retroalimentación y se pondrá en contacto contigo.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.',    'es_mx',    'La función de la bitácora es dar soporte / ayuda al cliente, si tienes algún problema con la app o algún módulo o funcionalidad no está funcionando adecuadamente, puedes habilitar la función de compartir la bitácora con nuestro equipo de desarrollo.',    8),
            ('info',    'Info', 'es_mx',    'Info', 8),
            ('recent_history',  'Recent History',   'es_mx',    'Historial reciente',   8),
            ('recent_feedback', 'Feedback', 'es_mx',    'Retroalimentación',    8),
            ('recent_log',  'Log',  'es_mx',    'Bitácora', 8),
            ('crmtiger_app_version',    'CRMTiger App Version :',   'es_mx',    'Versión de la App CRMTiger  :',    8),
            ('historylimit',    'Recent History Limit', 'es_mx',    'Límite historial reciente',    8),
            ('radious_in_miles',    'Radius in miles',  'es_mx',    'Radio en millas',  8),
            ('recentlimit', 'Recent Event Limit',   'es_mx',    'Límite de evento reciente',    8),
            ('upcoming_events', 'Upcoming Events',  'es_mx',    'Eventos próximos', 8),
            ('rate_our_app',    'Rate Our App!',    'es_mx',    '¡Califica nuestra App!',   8),
            ('feedback',    'Submit Feedback',  'es_mx',    'Enviar retroalimentación', 8),
            ('sendfeedback',    'Feedback Send',    'es_mx',    'Retroalimentación enviada',    8),
            ('emaillimit',  'Email limit',  'es_mx',    'Límite de email',  8),
            ('log', 'Log',  'es_mx',    'Bitácora', 8),
            ('logclear',    'Log cleared successfully.',    'es_mx',    'Clear successful', 8),
            ('dialog_recent_history_info',  'You can set from here how many number of records you want to show on Home screen for Recent History.', 'es_mx',    'Puedes definir aquí cuántos registros quieres mostrar en la pantalla de inicio para el historial reciente.',   8),
            ('proceed_to_upgrade1', 'Proceed to',   'es_mx',    'Proceder a',   8),
            ('upgradation_message', 'will required logout and login again later.',  'es_mx',    'se requerirá que salga del sistema y vuelva a entrar luego',   8),
            ('proceed_to_upgrade',  'Proceed to Upgrade',   'es_mx',    'Proceder a actualizar',    8),
            ('module_setting',  'Module Setting',   'es_mx',    'Configuración de módulo',  9),
            ('sortbyfield', 'Sort by field',    'es_mx',    'Ordenar por campo',    9),
            ('ascending',   'Ascending  A to Z',    'es_mx',    'Ascendiente  A a Z',   9),
            ('descending',  'Descending  Z to A',   'es_mx',    'Descendiente  Z a A',  9),
            ('first_field', 'First Field',  'es_mx',    'Primer campo', 9),
            ('second_field',    'Second Field', 'es_mx',    'Segundo campo',    9),
            ('third_field', 'Third Field',  'es_mx',    'Tercer campo', 9),
            ('sure_want_restore',   'Are you sure you want to reset to default settings?',  'es_mx',    '¿Estás seguro que quieres regresar a los valores predeterminados?',    9),
            ('orderlist',   'List Order',   'es_mx',    'Orden de lista',   9),
            ('module_reset',    'Restore to Default',   'es_mx',    'Regresar a los valores predeterminados',   9),
            ('display_fields',  'Display Fields',   'es_mx',    'Desplegar campos', 9),
            ('discount_lessthen_100',   'Discount % should be less than 100',   'es_mx',    'El % de descuento debe ser menor a 100',   10),
            ('select_item', 'Select Item',  'es_mx',    'Seleccionar Item', 10),
            ('item_comment',    'Item Comment', 'es_mx',    'Comentario sobre Item',    10),
            ('record_name', 'Record Name is :', 'es_mx',    'El nombre el registro es :-',  11),
            ('go_back', 'Go Back',  'es_mx',    'Regresar', 11),
            ('please_enter_shortcut_name',  'Please Enter Shortcut Name',   'es_mx',    'Por favor ingresa el nombre del acceso directo',   11),
            ('number_not_found',    'Contact Number not found', 'es_mx',    'Número de contacto no encontrado', 11),
            ('mail_not_found',  'Mail Address not found',   'es_mx',    'Dirección de correo no encontrada',    11),
            ('create_shortcut', 'Create Shortcut',  'es_mx',    'Crear acceso directo', 11),
            ('contact_summary', 'Summary',  'es_mx',    'Resumen',  11),
            ('activites',   'Activities',   'es_mx',    'Actividades',  11),
            ('details', 'Details',  'es_mx',    'Detalles', 11),
            ('related', 'Related',  'es_mx',    'Relacionado',  11),
            ('share_link',  'Share record with',    'es_mx',    'Compartir el registro con',    11),
            ('edit',    'Edit', 'es_mx',    'Editar',   11),
            ('duplicate',   'Duplicate',    'es_mx',    'Duplicar', 11),
            ('whatsapp',    'Whatsapp', 'es_mx',    'Whatsapp', 11),
            ('call',    'Call', 'es_mx',    'Llamar',   11),
            ('choose_contact_for_call', 'Choose Contact for Call',  'es_mx',    'Elegir un Contacto para Llamar',   11),
            ('choose_contact_for_sms',  'Choose Contact for SMS',   'es_mx',    'Elegir un Contacto para enviar SMS',   11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp',  'es_mx',    'Elegir un Contacto para enviar mensaje WhatsApp',  11),
            ('chosse_contact_for_email',    'Choose Email', 'es_mx',    'Elegir una direccion de correo',   11),
            ('attach_file', 'Attach Files', 'es_mx',    'Adjuntar Archivos',    11),
            ('close',   'Close',    'es_mx',    'Cerrar',   11),
            ('status',  'Status',   'es_mx',    'Estatus',  11),
            ('stop',    'Stop', 'es_mx',    'Detener',  11),
            ('zero',    '0',    'es_mx',    '0',    11),
            ('record',  'Record',   'es_mx',    'Grabar',   11),
            ('voice_note',  'Voice Note',   'es_mx',    'Nota de Voz',  11),
            ('tickets', 'Tickets',  'es_mx',    'Entradas', 12),
            ('check_out',   'Check Out',    'es_mx',    'Comprueba',    12),
            ('check_in',    'Check In', 'es_mx',    'Revisa',   12),
            ('select_any',  'Select any',   'es_mx',    'Seleccionar cualquier',    12),
            ('fulldetails', 'Show Full Details',    'es_mx',    'Mostrar todos los detalles',   12),
            ('checkin', 'Check-in', 'es_mx',    'Check-in', 12),
            ('navigate',    'Navigate', 'es_mx',    'Navegar',  12),
            ('product', 'Products', 'es_mx',    'Productos',    12),
            ('projectMilestone',    'Project Milestone',    'es_mx',    'Hitodelproyecto',  12),
            ('projecttask', 'Project Tasks',    'es_mx',    'Tareadelproyecto', 12),
            ('nearby',  'NearBy',   'es_mx',    'Cerca',    13),
            ('document',    'Document', 'es_mx',    'Documento',    14),
            ('reply',   'Reply',    'es_mx',    'Responder',    14),
            ('reply_all',   'Reply All',    'es_mx',    'Responder a todos',    14),
            ('forward', 'Forward',  'es_mx',    'Reenviar', 14),
            ('action',  'Action',   'es_mx',    'Acción',   14),
            ('select_first',    'Select First', 'es_mx',    'Elegir Primero',   14),
            ('commentaddsuccessful',    'Comment added successfull',    'es_mx',    'El comentario se añadió con éxito',    14),
            ('move_to', 'Move to',  'es_mx',    'Mover a',  14),
            ('attach',  'Attach',   'es_mx',    'Adjuntar', 14),
            ('addcoment',   'Add Comment',  'es_mx',    'Añadir comentario',    14),
            ('adddocument', 'Add Document', 'es_mx',    'Añadir documento', 14),
            ('home',    'Home', 'es_mx',    'Inicio',   15),
            ('checkout',    'Check-out',    'es_mx',    'Check-out',    15),
            ('message_search',  'Search by name',   'es_mx',    'Buscar por nombre',    15),
            ('start_shift', 'Start shift',  'es_mx',    'Empezar turno',    15),
            ('end_shift',   'End shift',    'es_mx',    'Terminar turno',   15),
            ('today_meeting',   'Meetings', 'es_mx',    'Reuniones',    15),
            ('shift_time_track',    'Shift Time Track', 'es_mx',    'Rastrear cambio de turno', 15),
            ('logout_msg',  'You have to login again , click',  'es_mx',    'Tiene que ingresar de nuevo , clic',   15),
            ('logout_msg1', 'to continue.', 'es_mx',    'para continuar',   15),
            ('permission_denied',   'You don\'t have permission to create', 'es_mx',    'No tienes permiso para crear', 15),
            ('history', 'Activity stream',  'es_mx',    'Flujo de actividad',   15),
            ('search_value',    'Search value :',   'es_mx',    'Buscar el valor',  15),
            ('feed_back_msg',   'Please enter feedback message',    'es_mx',    'Por favor ingresa mensaje de retroalimentación',   16),
            ('feed_back_hint_msg',  'Enter feedback message',   'es_mx',    'Ingresa mensaje de retroalimentación', 16),
            ('submit',  'Submit',   'es_mx',    'Enviar',   16),
            ('check_app_not_installed', 'Application is not currently installed.',  'es_mx',    'La aplicación no está instalada actualmente.', 17),
            ('send_sms_fail_message',   'SMS failed, please try again later!',  'es_mx',    'El SMS falló, por favor intenta más tarde',    17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'es_mx',    'El documento se adjuntó con éxito',    17),
            ('send_message',    'Send message', 'es_mx',    'Enviar mensaje',   17),
            ('sms_to',  'smsto:',   'es_mx',    'smspara:', 17),
            ('add_list_message',    'Add List', 'es_mx',    'Añadir lista', 18),
            ('mylist',  'My List',  'es_mx',    'Mi lista', 18),
            ('filtername',  'Filter Name',  'es_mx',    'Nombre del filtro',    18),
            ('selectlist',  'Select a List',    'es_mx',    'Seleccionar una lista *',  18),
            ('assingedto',  'Assigned To',  'es_mx',    'Asignado a *', 18),
            ('selectmodule',    'Select a module',  'es_mx',    'Seleccionar un módulo',    18),
            ('add_list',    'Add Filter',   'es_mx',    'Añadir filtro',    18),
            ('recent_event',    'Recent Event', 'es_mx',    'Evento reciente',  19),
            ('recent_hostory',  'Recent History',   'es_mx',    'Historial reciente',   19),
            ('module_specific_settings',    'Module-Specific Settings', 'es_mx',    'Configuración específica del módulo',  19),
            ('talk_to_us',  'Talk to us',   'es_mx',    'Habla con nosotros',   19),
            ('report_a_bug',    'Report A Bug', 'es_mx',    'Reporta un bug',   19),
            ('faq', 'FAQ',  'es_mx',    'Preguntas frecuentes', 19),
            ('selectmodules',   'Select Module',    'es_mx',    'Selecciona el módulo', 19),
            ('myplan',  'My Plan',  'es_mx',    'Mi plan',  19),
            ('message', 'Message',  'es_mx',    'Mensaje',  20),
            ('message_validation',  'Please enter Message', 'es_mx',    'Por favor, introduzca el mensaje', 20),
            ('contact_select',  'Please Select contact',    'es_mx',    'Por favor selecciona el contacto', 20),
            ('global_search',   'Global Search',    'es_mx',    'Búsqueda Global',  21),
            ('records', 'Records',  'es_mx',    'Registros',    21),
            ('dont_show_again', 'Don\'t Show Again',    'es_mx',    'No mostrar denuevo',   22),
            ('skip',    'Skip', 'es_mx',    'Saltear',  22),
            ('file_downloading',    'File Downloading', 'es_mx',    'Archivo descargándose',    23),
            ('add_screenshots_optional',    'Add screenshots (optional)',   'es_mx',    'Añadir capturas de pantalla (opcional)',   24),
            ('describe_your_problem',   'Describe your problem',    'es_mx',    'Describe tu problema', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut',  'es_mx',    'Atajo de Filtro Predeterminado',   25),
            ('record_shortcut', 'Record Shortcut',  'es_mx',    'Acceso de registro',   25),
            ('enter_url',   'Please Enter url', 'es_mx',    'Por favor ingrese URL',    26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'es_mx',    'Necesita actualizar la app para continuar usándola. Por favor actualice para continuar. Las versiones antiguas ya no están funcionando.',  26),
            ('search_by',   'Search by',    'es_mx',    'Buscar por',   27),
            ('selected_filter', 'Selected filter :',    'es_mx',    'Filtro seleccionado :-',   27),
            ('selected_field',  'Selected field :', 'es_mx',    'Campo seleccionado :-',    27),
            ('choose',  'Choose',   'es_mx',    'Elija',    28),
            ('qr_cardscanner',  'QR Code Scanner',  'es_mx',    'Escaner de Código QR', 28),
            ('error_message_for_scan',  'Could not read the card Try again later.', 'es_mx',    'La tarjeta no pudo ser leída. Trate nuevamente más tarde.',    28),
            ('press_start_scan',    'Press to Start Scan',  'es_mx',    'Presione para iniciar el escaner', 28),
            ('line_item_quntity_validation_msg',    'Value should be greater than zero',    'es_mx',    'El valor debe ser mayor a cero',   29),
            ('percentage_msg',  'Percentage should be less than 100',   'es_mx',    'El porcentaje debe ser menor a cero',  29),
            ('MSG_NO_DATA', 'No data found!',   'es_mx',    'No se encontró información',   29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!',    'es_mx',    'Algo salió mal',   29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'es_mx',    'Llegará pronto',   29),
            ('MSG_UPLOAD_PROFILE_IMAGE',    'Please upload profile image.', 'es_mx',    'Por favor cargue una imagen de perfil',    29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access',  'es_mx',    'Acceso a ubicación',   29),
            ('ALERT_MSG_LOCATION_ACCESS',   'Requires your location to show nearby events.',    'es_mx',    'Su ubicación es necesaria para mostrar eventos cercanos',  29),
            ('ALERT_BTN_ALLOW', 'ALLOW',    'es_mx',    'PERMITIR', 29),
            ('ALERT_BTN_DENY',  'DENY', 'es_mx',    'DENEGAR',  29),
            ('ALERT_MSG_LOCATION_SETTING',  'Not able to fetch your current location. Please allow us to use your location to provide you certain features like, live tracking, route planning and display near by leads, contact, organization, etc. This will help you to plan your on field task as well',   'es_mx',    'Not able to fetch your current location. Please allow us to use your location to provide you certain features like, live tracking, route planning and display near by leads, contact, organization, etc. This will help you to plan your on field task as well',   29),
            ('DELETE_RECORD',   'Delete Record',    'es_mx',    'Borrar registro',  29),
            ('ALERT_MSG_DELETE_SHORTCUT',   'Are you sure want to delete this shortcut?',   'es_mx',    '¿Está seguro de que quiere borrar este acceso directo?',   29),
            ('DELETE_SHORTCUT', 'Delete Shortcut',  'es_mx',    'Borrar acceso directo',    29),
            ('LBL_TERMS',   'By logging in, you agree to our Terms and',    'es_mx',    'Al iniciar sesión, acepta nuestros Términos',  29),
            ('LBL_CONDITIONS',  'Conditions &', 'es_mx',    '& Condiciones',    29),
            ('ALERT_TITLE', 'Alert',    'es_mx',    'Alerta',   29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe',    'es_mx',    'Suscribirse',  29),
            ('MSG_SELECT_MODULE',   'Please select any Module', 'es_mx',    'Por favor seleccione cualquier Módulo',    29),
            ('MSG_SELECT_LIST', 'Please select any List',   'es_mx',    'Por favor selecciona cualquier Lista', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA',  'You don\'t have camera',   'es_mx',    'No tiene cámara',  29),
            ('ALERT_MSG_GALLARY_PERMISSION',    'You don\'t have permission to access gallery.',    'es_mx',    'No tiene permiso para accesar la galería', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'es_mx',    'No tiene permiso para accesar a la cámara. Ir a configuración -&gt; Desplazar hacia abajo y seleccionar CRMTiger App -&gt; Encender la cámara',    29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'es_mx',    'No tiene permiso para accesar el Reconocimiento de voz. Ir a configuración -&gt; Desplazar y seleccionar CRMTiger App -&gt; Encender Reconocimiento de voz',   29),
            ('BTN_DONE',    'Done', 'es_mx',    'Terminado',    29),
            ('COMMENT', 'Comment',  'es_mx',    'Comentar', 29),
            ('FULL_FORM',   'Full Form',    'es_mx',    'Registro completo',    29),
            ('QUICK_CREATE',    'Create',   'es_mx',    'Crear',    29),
            ('LBL_SELECT_FIELDS',   'Select Fields',    'es_mx',    'Seleccionar campos',   29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field',   'es_mx',    'Seleccionar primer campo', 29),
            ('LBL_SELECT_SECOND_FIELDS',    'Select Second Field',  'es_mx',    'Seleccionar segundo campo',    29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field',   'es_mx',    'Seleccionar tercer campo', 29),
            ('LBL_SORT_BY_FIELD',   'Select Sort By Field', 'es_mx',    'Seleccionar Ordenar por campo',    29),
            ('BTN_RESET_TO_DEFAULT',    'Reset to Default', 'es_mx',    'Resetear a valor predeterminado',  29),
            ('MSG_SELECT_SORT_BY_FIELD',    'Select Sort by field', 'es_mx',    'Seleccionar Ordenar por campo',    29),
            ('kStrClearBtnTitle',   'Clear',    'es_mx',    'Limpiar',  29),
            ('kStrShowMoreBtnTitle',    'Show More',    'es_mx',    'Mostrar más',  29),
            ('kStrAddActivitiesBtnTitle',   'Add Activities',   'es_mx',    'Añadir actividades',   29),
            ('kStrAddCommentPlaceHolder',   'Add your comments here',   'es_mx',    'Añadir sus comentarios aquí',  29),
            ('MSG_ENTER_TO_EMAIL',  'Please enter to field.',   'es_mx',    'Por favor ingrese al campo',   29),
            ('WARNING_FILE',    'File can\'t open.',    'es_mx',    'El archivo no se puede abrir', 29),
            ('MSG_FILE_SAVED',  'File saved.',  'es_mx',    'Archivo guardado.',    29),
            ('WARNING_DOWNLOAD_FAIL',   'Download fail!, please try after sometime.',   'es_mx',    'La descarga no pudo completarse, favor de intentar más tarde', 29),
            ('LBL_SHORTCUT',    'Shortcut', 'es_mx',    'Acceso directo',   29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'es_mx',    'Escribir mensaje', 29),
            ('ALERT_INSTALL_WHATSAPP',  'Install Whatsapp', 'es_mx',    'Instalar Whatsapp',    29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox',  'es_mx',    'No se encontró el Buzón de correo. Por favor crear Buzón de correo',   29),
            ('LBL_WROTE',   'Wrote',    'es_mx',    'Escrito',  29),
            ('MSG_MAIL_SEND',   'Mail sent',    'es_mx',    'Correo enviado',   29),
            ('log_file_not_found',  'API Log file not found.',  'es_mx',    'No se encontró el archivo API Log',    29),
            ('unknown_error',   'An unknown error occurred, try again', 'es_mx',    'Ocurrió un error desconocido, trate nuevamente',   29),
            ('CTMTigerAppVersion',  'CRMTiger App Version', 'es_mx',    'Versión de App CRMTiger',  29),
            ('CTMMobileUpdateMsg',  'CTMobile Ext. Version Update Successfully',    'es_mx',    'Versión CTMMobile Ext. actualizada exitosamente',  29),
            ('dialog_Premium_downgrade',    'Downgrade will required logout and login again later', 'es_mx',    'Necesitará cerrar e iniciar sesión más tarde para hacer el downgrade', 29),
            ('dialog_Premium',  'Upgrade will required logout and login again later',   'es_mx',    'Necesitará cerrar e iniciar sesión más tarde para hacer el upgrade',   29),
            ('Overwrite',   'Overwrite',    'es_mx',    'Sobreescribir',    29),
            ('MSGAddressOverwrite1',    'Overwrite the existing address with the selected', 'es_mx',    'Sobreescribir la dirección existente con la que está seleccionada',    29),
            ('MSGAddressOverwrite2',    'address details?', 'es_mx',    '¿Detalles de la dirección?',   29),
            ('UPGRADE_PLAN',    'Upgrade Plan', 'es_mx',    'Plan de upgrade',  29),
            ('DOWNGRADE_PLAN',  'Downgrade Plan',   'es_mx',    'Plan de downgrade',    29),
            ('UPGRADE_EXTENSION',   'Upgrade Extension',    'es_mx',    'Extensión de upgrade', 29),
            ('UPGRADE_APP', 'Upgrade App',  'es_mx',    'App de upgrade',   29),
            ('SELECT_OPTION',   'Select Option',    'es_mx',    'Seleccionar opción',   29),
            ('PLEASE_SELECT',   'Please select',    'es_mx',    'Por favor seleccione ',    29),
            ('MSG_ACCESS_DENIED',   'You don\'t have permission for this module.',  'es_mx',    'No tiene permiso para este módulo.',   29),
            ('MSG_SELECT_RECCURING_MONTH_DAY',  'Please select reccuring day of month.',    'es_mx',    'Por favor seleccione día del mes recurrente.', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY',   'Please select reccuring day of week.', 'es_mx',    'Por favor seleccione un día de la semana recurrente.', 29),
            ('MSG_SELECT_RECCURING_DAYS',   'Please select reccuring days.',    'es_mx',    'Por favor seleccione días recurrentes.',   29),
            ('Please select reccuring days.',   'Please select reccuring days.',    'es_mx',    'Por favor seleccione días recurrentes.',   29),
            ('MSG_SELECT_RECCURING_END_DATE',   'Please select reccuring end date.',    'es_mx',    'Por favor seleccione fecha de término recurrente.',    29),
            ('MSG_SELECT_RECCURING_TYPE',   'Please select reccuring type.',    'es_mx',    'Por favor seleccione tipo recurrente', 29),
            ('FREQ_TIME',   'Times',    'es_mx',    'Horarios', 29),
            ('REPEAT_YEARLY',   'Repeat Yearly',    'es_mx',    'Repetir anualmente',   29),
            ('REPEAT_MONTHLY',  'Repeat Monthly',   'es_mx',    'Repetir mensualmente', 29),
            ('REPEAT_WEEKLY',   'Repeat Weekly',    'es_mx',    'Repetir semanalmente', 29),
            ('REPEAT_DAILY',    'Repeat Daily', 'es_mx',    'Repetir diariamente',  29),
            ('ACTION_TITLE',    'Action Title', 'es_mx',    'Título de la acción',  29),
            ('MSG_SELECT_VALID_DATE',   'Please select valid day of month.',    'es_mx',    'Por favor seleccione un día del mes válido',   29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'es_mx',    'La fecha de inicio debe ser menor que la fecha de término',    29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'es_mx',    'La hora de inicio debe ser menor que la fecha de término', 29),
            ('LBL_LINEITEM_DETAILS',    'Lineitem Details', 'es_mx',    'Detalles de objetos de línea', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT',    'Discount amount should be less than the total.',   'es_mx',    'El monto del descuento debe ser menor al total.',  29),
            ('VIEW',    'View', 'es_mx',    'Ver',  29),
            ('MSG_ENTER_VALID', 'Please enter valid',   'es_mx',    'Por favor ingrese un valor válido',    29),
            ('MSG_ENTER_PERCENTAGE',    'Percentage should be less than 100.',  'es_mx',    'El porcentaje debe ser menor a 100.',  29),
            ('ITEM_TOTAL',  'Item Total',   'es_mx',    'Total de objetos', 29),
            ('ADJUSTMENT',  'Adjustment',   'es_mx',    'Ajuste',   29),
            ('TITLE_CHOOSE_IMAGE',  'Choose Image', 'es_mx',    'Seleccionar imagen',   29),
            ('COMPRESS',    'Compress', 'es_mx',    'Comprimir',    29),
            ('CHOOSE_ANOTHER_IMAGE',    'Your image size is too large, please select another image',    'es_mx',    'El tamaño de la imagen es muy grande, por favor seleccione otra imagen',   29),
            ('OnDayOfMonth',    'On day of month',  'es_mx',    'El día del mes',   29),
            ('OnDayOfWeek', 'On day of week',   'es_mx',    'El día de la semana',  29),
            ('AddAndClose', 'Add & Close',  'es_mx',    'Añadir & Cerrar',  29),
            ('Repeat',  'Repeat',   'es_mx',    'Repetir',  29),
            ('OnDay',   'On day',   'es_mx',    'El día',   29),
            ('View_Line_Item',  'View Line Item',   'es_mx',    'Ver objeto de línea',  29),
            ('TITLE_IMAGE', 'Image',    'es_mx',    'Imagen',   29),
            ('TITLE_ICLOUD',    'iCloud',   'es_mx',    'iCloud',   29),
            ('GOOGLE',  'Google',   'es_mx',    'Google',   29),
            ('ALERT_BTN_OKAY',  'Okay', 'es_mx',    'Ok',   29),
            ('ALERT_TITLE_ACCESS_DENIED',   'Access Denied',    'es_mx',    'Acceso denegado',  29),
            ('Dont_Show_Again', 'Don\'t show again',    'es_mx',    'No mostrar de nuevo',  29),
            ('Skip',    'Skip', 'es_mx',    'Saltar',   29),
            ('Fillter_Name',    'Fillter Name', 'es_mx',    'Nombre del filtro',    29),
            ('Fillter_Record_Count',    'Fillter Record Count', 'es_mx',    'Count del registro del filtro',    29),
            ('url_note',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'es_mx',    'Nota : si su URL de CRM es https://example.com/crm introduzca esa en la casilla superior', 26),
            ('vtiger_url',  'Your vTiger CRM URL',  'es_mx',    'Tu dirección CRM vTiger',  26),
            ('msg_doc_read_permission', 'You don\'t have permission to Add either This is read-only or Private Field.', 'es_mx',    'No tienes permiso para añadir esto es solo de lectura o campo privado.',   31),
            ('CLEAR',   'Clear',    'es_mx',    'Despejado',    31),
            ('Files/photos uploaded successfully',  'Files/photos uploaded successfully',   'es_mx',    'Archivos/fotos subidos con éxito', 32),
            ('Digital signature saved', 'Digital signature saved',  'es_mx',    'Firma digital salvada',    32),
            ('Please upload Signature or Files/photos', 'Please upload Signature or Files/photos',  'es_mx',    'Por favor, suba la firma o ficheros/fotos',    32),
            ('Files / Photos',  'Files / Photos',   'es_mx',    'Archivos / Fotos', 32),
            ('Signature',   'Signature',    'es_mx',    'Firma',    32),
            ('add_photo_using', 'Add Photo Using',  'es_mx',    'Añadir el uso de fotos',   31),
            ('btn_upload_sign', '(+) Add Signature',    'es_mx',    '(+) Añadir la firma',  31),
            ('btn_upload_photo_doc',    '(+) Upload Files/Photos',  'es_mx',    '(+) Subir archivos/fotos', 31),
            ('select_photo_doc_to_upload',  'Please select files/photos to upload', 'es_mx',    'Por favor seleccione archivos/fotos para subir',   31),
            ('related_module_title',    'Search from related module and Add to \"Route\"',  'es_mx',    'Buscar desde módulo relacionado y añadir a \"Ruta\"',  30),
            ('Route status updated successfully',   'Route status updated successfully',    'es_mx',    'Estatuto de la ruta actualizado con éxito',    32),
            ('Session init failed', 'Session init failed',  'es_mx',    'La sesión init falló', 32),
            ('You don\'t have permission to access this resource',  'You don\'t have permission to access this resource',   'es_mx',    'No tienes permiso para acceder a este recurso',    32),
            ('ctroute_realtedto cannot be empty',   'Could not get the Related To - Try again later',   'es_mx',    'No pude conseguir que los Relacionados, intente de nuevo más tarde',   32),
            ('ctroute_planning cannot be empty',    'Could not get the Route Planning Record - Try again later',    'es_mx',    'No pude conseguir el registro de planificación de rutas - Inténtalo de nuevo más tarde',   32),
            ('Something went wrong - Try again later',  'Something went wrong - Try again later',   'es_mx',    'Algo salió mal, intenta de nuevo más tarde',   32),
            ('sequence updated successfully',   'sequence updated successfully',    'es_mx',    'secuencia actualizada con éxito',  32),
            ('sequence cannot be empty',    'sequence cannot be empty', 'es_mx',    'la secuencia no puede estar vacía',    32),
            ('Shortcut details not saved',  'Shortcut details not saved',   'es_mx',    'Detalles de atajo no guardados',   32),
            ('Shortcut details saved successfully', 'Shortcut details saved successfully',  'es_mx',    'Detalles de atajo guardados con éxito',    32),
            ('Route save successfully', 'Route save successfully',  'es_mx',    'La ruta salve con éxito',  32),
            ('Record save successfully',    'Record save successfully', 'es_mx',    'Registro ahorrar con éxito',   32),
            ('No dependency found for picklist',    'No dependency found for picklist', 'es_mx',    'No se encontró dependencia para la lista de picklist', 32),
            ('No records found',    'No records found', 'es_mx',    'No se han encontrado registros',   32),
            ('Outgoing server is not enabled, please configure from CRM',   'Outgoing server is not enabled, please configure from CRM',    'es_mx',    'El servidor saliente no está habilitado, por favor configure de CRM',  32),
            ('Removed Successfully',    'Removed Successfully', 'es_mx',    'Eliminado con éxito',  32),
            ('Shortcut has been deleted',   'Shortcut has been deleted',    'es_mx',    'Se ha eliminado el atajo', 32),
            ('relation of records removed successfully',    'relation of records removed successfully', 'es_mx',    'relación de los registros eliminados con éxito',   32),
            ('relation of records not removed', 'relation of records not removed',  'es_mx',    'relación de los registros no eliminados',  32),
            ('Record has been deleted successfully',    'Record has been deleted successfully', 'es_mx',    'El registro ha sido borrado con éxito',    32),
            ('Time Tracking saved successfully',    'Time Tracking saved successfully', 'es_mx',    'Rastreo de tiempo ahorrado con éxito', 32),
            ('Time Tracking updated successfully',  'Time Tracking updated successfully',   'es_mx',    'Rastreo del tiempo actualizado con éxito', 32),
            ('Time Tracking ended successfully',    'Time Tracking ended successfully', 'es_mx',    'El seguimiento del tiempo terminó con éxito',  32),
            ('Time Tracking started successfully',  'Time Tracking started successfully',   'es_mx',    'El seguimiento del tiempo empezó con éxito',   32),
            ('record cannot be empty',  'record cannot be empty',   'es_mx',    'el registro no puede estar vacío', 32),
            ('Module is disabled',  'Module is disabled',   'es_mx',    'Módulo está desactivado',  32),
            ('Shift ended successfully',    'Shift ended successfully', 'es_mx',    'El cambio terminó con éxito',  32),
            ('Shift started successfully',  'Shift started successfully',   'es_mx',    'El cambio comenzó con éxito',  32),
            ('relation of records added successfully',  'relation of records added successfully',   'es_mx',    'relación de los registros añadido con éxito',  32),
            ('Comment saved successfully',  'Comment saved successfully',   'es_mx',    'Comentario guardado con éxito',    32),
            ('Comment not saved',   'Comment not saved',    'es_mx',    'Comentario no guardado',   32),
            ('Comment module is not active',    'Comment module is not active', 'es_mx',    'El módulo de comentarios no está activo',  32),
            ('No Upcoming Event',   'No Upcoming Event',    'es_mx',    'No hay evento próximo',    32),
            ('No Templates found - create it from Message Templates module',    'No Templates found - create it from Message Templates module', 'es_mx',    'No se encontró ninguna plantilla - crearlo a partir del módulo de plantillas de mensajes', 32),
            ('No event or task for this date',  'No event or task for this date',   'es_mx',    'No hay evento ni tarea para esta fecha',   32),
            ('No filters created',  'No filters created',   'es_mx',    'No se crean filtros',  32),
            ('Select at least one record to attach',    'Select at least one record to attach', 'es_mx',    'Seleccione al menos un disco que adjuntar',    32),
            ('Please select one or more attachments',   'Please select one or more attachments',    'es_mx',    'Por favor, seleccione uno o más accesorios',   32),
            ('No event for this month', 'No event for this month',  'es_mx',    'No hay evento para este mes',  32),
            ('No Activity found',   'No Activity found',    'es_mx',    'No se encontró ninguna actividad', 32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'es_mx',    'Su retroalimentación es valiosa para nosotros, no puede estar vacía',  32),
            ('Could not send mail, Please try later',   'Could not send mail, Please try later',    'es_mx',    'No pude enviar correo, por favor, inténtalo más tarde',    32),
            ('Latest Version updated successfully', 'Latest Version updated successfully',  'es_mx',    'Última versión actualizada con éxito', 32),
            ('User Location Updated Successfully',  'User Location Updated Successfully',   'es_mx',    'Usuario Usuario actualizado con éxito',    32),
            ('User Location not Updated Successfully',  'User Location not Updated Successfully',   'es_mx',    'Usuario no actualizado con éxito', 32),
            ('SMSNotifier is not enable in CRM. Please enable it first',    'SMSNotifier is not enable in CRM. Please enable it first', 'es_mx',    'SMSNotifier no está habilitado en CRM. Por favor, déjalo primero', 32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'es_mx',    'No podría presentar sus comentarios - Por favor, inténtalo de nuevo más tarde',    32),
            ('Thank you for submitting your feedback',  'Thank you for submitting your feedback',   'es_mx',    'Gracias por presentar sus comentarios',    32),
            ('Please upload User Image',    'Please upload User Image', 'es_mx',    'Por favor, suba Imagen de Usuario',    32),
            ('Image Not Uploading, please try again',   'Image Not Uploading, please try again',    'es_mx',    'Imagen No subir, por favor inténtalo de nuevo',    32),
            ('User Image Uploaded Successfully',    'User Image Uploaded Successfully', 'es_mx',    'Imagen de usuario se ha subido con éxito', 32),
            ('Invalid Module name', 'Invalid Module name',  'es_mx',    'Nombre del módulo inválido',   32),
            ('Records Sync Successfully',   'Records Sync Successfully',    'es_mx',    'Registros Sync con éxito', 32),
            ('Values cannot be empty',  'Values cannot be empty',   'es_mx',    'Los valores no pueden estar vacíos',   32),
            ('Record id is empty',  'Record id is empty',   'es_mx',    'El registro está vacío',   32),
            ('Logout Successfully', 'Logout Successfully',  'es_mx',    'Logot con éxito',  32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'es_mx',    'Por favor, habilite el módulo CTMobile',   32),
            ('Authentication Failed',   'Username and Password do not match',   'es_mx',    'Nombre de usuario y contraseña no coinciden',  32),
            ('Mismatched module information',   'Something gone wrong, please try again later', 'es_mx',    'Algo salió mal, por favor vuelva a intentarlo más tarde',  32),
            ('Field does not exists',   'Please set display fields again',  'es_mx',    'Por favor, vuelva a configurar los campos de visualización',   32),
            ('Module does not exists',  'Module does not exists or disabled by admin',  'es_mx',    'El módulo no existe o discapacitado por administrador',    32),
            ('Month cannot be empty',   'Could not get the Month - Try again later',    'es_mx',    'No pude conseguir el Mes - Inténtalo de nuevo más tarde',  32),
            ('Year cannot be empty',    'Could not get the Year - Try again later', 'es_mx',    'No pude conseguir el Año - Inténtalo de nuevo más tarde',  32),
            ('Date cannot be empty',    'Could not get the Date - Try again later', 'es_mx',    'No pude conseguir la Fecha - Inténtalo de nuevo más tarde',    32),
            ('Userid cannot be empty',  'Could not get the Userid - Try again later',   'es_mx',    'No pude conseguir el Userid - Inténtalo de nuevo más tarde',   32),
            ('End Date cannot be empty',    'Could not get the status - Try again later',   'es_mx',    'No pude obtener el estatus - Inténtalo de nuevo más tarde',    32),
            ('Start Date cannot be empty',  'Could not get the Start Date - Try again later',   'es_mx',    'No pude conseguir la Fecha de inicio - Inténtalo de nuevo más tarde',  32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'es_mx',    'No configura SMS Notificar en CRM. Por favor configure SMS Notificader en su CRM para utilizar esta función',  32),
            ('Longitude cannot be empty',   'Could not get location-Please try again',  'es_mx',    'No pude localizar, por favor, inténtalo de nuevo', 32),
            ('Latitude cannot be empty',    'Could not get location-Please try again',  'es_mx',    'No pude localizar, por favor, inténtalo de nuevo', 32),
            ('User cannot be empty',    'Could not get the User - Try again later', 'es_mx',    'No pude conseguir el Usuario - Inténtalo de nuevo más tarde',  32),
            ('Status cannot be empty',  'Could not get the status - Try again later',   'es_mx',    'No pude obtener el estatus - Inténtalo de nuevo más tarde',    32),
            ('Required fields not found',   'Required fields not found',    'es_mx',    'Campos requeridos no encontrados', 32),
            ('Tracking module not active',  'Tracking module not active-Please contact CRM Admin',  'es_mx',    'Módulo de seguimiento no activo-Por favor contacte con CRM Administration',    32),
            ('Missing mandatory input values',  'Missing mandatory input values',   'es_mx',    'Faltan valores de entrada obligatorios',   32),
            ('No MailBox found. Please Create Mailbox', 'No MailBox found. Please Create Mailbox',  'es_mx',    'No se encontró ningún MailBox. Por favor, cree la casilla de correo',  32),
            ('Mail not sent',   'Mail not sent',    'es_mx',    'Correo no enviado',    32),
            ('Mail send successfully',  'Mail send successfully',   'es_mx',    'Envíen el correo con éxito',   32),
            ('Email Id or username not match with your record', 'Email Id or username not match with your record',  'es_mx',    'El Id o el nombre de usuario no coinciden con su registro',    32),
            ('Module not specified',    'Module not specified', 'es_mx',    'Módulo no especificado',   32),
            ('No messages found',   'No messages found',    'es_mx',    'No se encontraron mensajes',   32),
            ('No Dependency Found For This Module', 'No Dependency Found For This Module',  'es_mx',    'No se encontró dependencia para este módulo',  32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'es_mx',    'El servidor saliente no está habilitado',  32),
            ('Outgoing server is Enabled',  'Outgoing server is Enabled',   'es_mx',    'El servidor de salida está habilitado',    32),
            ('Email Attached Successfully', 'Email Attached Successfully',  'es_mx',    'Email adjuntado exitosamente', 32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  'es_mx',    'Documentos adjuntados exitosamente',   32),
            ('Login required - Please login again', 'Login required - Please login again',  'es_mx',    'Inicio de sesión requerido - Favor de iniciar sesión nuevamente',  32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  'es_mx',    'El módulo de rastreo de tiempo está deshabilitado',    31),
            ('route_planning_module_disable',   'Route planning module is disable', 'es_mx',    'El módulo de planeación de ruta está deshabilitado',   31),
            ('mark_as_held',    'Are you sure you want to mark Event as Held?', 'es_mx',    '¿Está seguro de que desea marcar el Evento como realizado?',   31),
            ('stop_timer_msg',  'You have already started Time tracking for another record, Do you want to stop it first ?',    'es_mx',    'Ya ha iniciado el rastreo de tiempo para otro registro. ¿Desea detenerlo primero?',    31),
            ('access_denied_routeplanning', 'Access denied for route planning', 'es_mx',    'Acceso denegado para plan de ruta',    31),
            ('time_spent',  'Time Spent',   'es_mx',    'Tiempo transcurrido',  31),
            ('select_user', 'Select User',  'es_mx',    'Seleccionar usuario',  30),
            ('status_cannot_be_held',   'Status cannot be held for future date start',  'es_mx',    'El estatus no puede realizarse para una fecha de inicio en el futuro', 30),
            ('please_select_end_date',  'Please select end date',   'es_mx',    'Favor de seleccionar fecha de término',    30),
            ('please_select_start_date',    'Please select start date', 'es_mx',    'Favor de seleccionar fecha de inicio', 30),
            ('tap_on_plus_icon_for_select_route',   'Tap on + icon to select record for your route.',   'es_mx',    'Toque el ícono de + para seleccionar el registro para su ruta.',   30),
            ('please_enter_notes',  'Please enter notes',   'es_mx',    'Favor de ingresar notas',  30),
            ('please_enter_title',  'Please enter title',   'es_mx',    'Favor de ingresar título', 30),
            ('please_select_date',  'Please Select Date',   'es_mx',    'Favor de seleccionar fecha',   30),
            ('search_by_date',  'Search by Date',   'es_mx',    'Busca por Fecha',  30),
            ('shortcut_not_setup_yet',  'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  'es_mx',    '¡Ups, el acceso directo no se ha creado todavía! Por favor añada un acceso directo al hacer clic + ícono desde los resultados de la búsqueda del registro o de la pantalla.',  30),
            ('max_upload_size', 'max file Upload exceeds',  'es_mx',    'El tamaño de carga máximo se ha exedido',  30),
            ('unselect_all',    'UnSelect All', 'es_mx',    'Des-seleccionar todo', 30),
            ('select_all',  'Select All',   'es_mx',    'Seleccionar todo', 30),
            ('please_select_records',   'Please select records',    'es_mx',    'Favor de seleccionar registros',   30),
            ('select_date', 'Select Date',  'es_mx',    'Seleccionar fecha',    30),
            ('quantity_in_stock_is',    'Quantity in stock is', 'es_mx',    'La cantidad en stock es',  30),
            ('replies', 'Replies',  'es_mx',    'Responde', 30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'es_mx',    'La conversión requiere seleccionar un Contacto o una Cuenta',  30),
            ('please_select_product',   'Please Select Product',    'es_mx',    'Favor de seleccionar el Producto', 30),
            ('timer_msg',   'You can start timer for single task only at same time',    'es_mx',    'Puede iniciar el timer solo para una tarea específica al mismo tiempo',    31),
            ('save_start_tracking', 'Save & Start Tracking',    'es_mx',    'Guardar & Iniciar el rastreo', 31),
            ('lbl_notes',   'Notes',    'es_mx',    'Notas',    31),
            ('enter_title', 'Enter Title',  'es_mx',    'Ingresar título',  31),
            ('select_module_record',    'Select Module / Record',   'es_mx',    'Seleccionar módulo / registro',    31),
            ('lbl_tomorrow',    'Tomorrow', 'es_mx',    'Mañana',   30),
            ('lbl_yesterday',   'Yesterday',    'es_mx',    'Ayer', 30),
            ('lbl_today',   'Today',    'es_mx',    'Hoy',  30),
            ('time_tracker',    'Time Tracker', 'es_mx',    'Rastreo de tiempo',    31),
            ('time_end',    'End Time', 'es_mx',    'Hora de término',  5),
            ('due_date',    'End Date', 'es_mx',    'Fecha de término', 5),
            ('time_start',  'Time Start',   'es_mx',    'Hora de inicio',   5),
            ('date_start',  'Start Date',   'es_mx',    'Fecha de inicio',  5),
            ('delete_widget_msg',   'Display widget again by using (+) option', 'es_mx',    'Desplegar widget nuevamente usando opción (+)',    15),
            ('no_upcoming_activities',  'No scheduled activities      ',    'es_mx',    'No hay actividades programadas',   15),
            ('check_in_first',  'Please check-in first',    'es_mx',    'Por favor, check-in primero',  30),
            ('duration',    'Duration', 'es_mx',    'Duración', 30),
            ('distance',    'Distance', 'es_mx',    'Distancia',    30),
            ('proper_address_message',  'Please enter proper address in record\n',  'es_mx',    'Por favor ingrese una dirección correcta en el registro',  30),
            ('select_status',   'Select Status',    'es_mx',    'Seleccionar estatus',  30),
            ('route_planner',   'Route Planner',    'es_mx',    'Planeador de ruta',    30),
            ('route_planning',  'Route Planning',   'es_mx',    'Plan de ruta', 30),
            ('add_route',   'Add Route',    'es_mx',    'Añadir ruta',  30),
            ('calender_disabled',   'Calendar Module is disabled',  'es_mx',    'Módulo de calendario deshabilitado',   30),
            ('close_dialog',    'Close form',   'es_mx',    'Cerrar desde', 30),
            ('cancel_form_message', 'Are You sure want to close ?', 'es_mx',    '¿Está seguro de que quiere cerrar?',   30),
            ('create_route',    'Create Route', 'es_mx',    'Crear ruta',   30),
            ('select_module_create_route',  'Select Module to create Route',    'es_mx',    'Seleccionar módulo para crear ruta',   30),
            ('cancel',  'Cancel',   'es_mx',    'Cancelar', 30),
            ('assign_route',    'Assign Route', 'es_mx',    'Asignar ruta', 30),
            ('route_for',   'Route for',    'es_mx',    'Ruta para',    30),
            ('assigned_to', 'Assigned To',  'es_mx',    'Asignado a',   30),
            ('enter_route_name',    'Enter Route Name', 'es_mx',    'Ingrese nombre de ruta',   30),
            ('list',    'List', 'es_mx',    'Lista',    30),
            ('map', 'Map',  'es_mx',    'Mapa', 30),
            ('other_modules',   'Other Modules',    'es_mx',    'Otros módulos',    15),
            ('shortcut_no_record_msg',  'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 'es_mx',    '¡Ups, el acceso directo no se ha creado todavía! Por favor añada un acceso directo al hacer clic + ícono desde los resultados de la búsqueda del registro o de la pantalla de vista de registros.',    25),
            ('clear',   'Clear',    'es_mx',    'Limpiar',  25),
            ('open',    'Open', 'es_mx',    'Abrir',    11),
            ('max_file_msg',    'Too many files selected (max:6)',  'es_mx',    'Se han seleccionado demasiados archivos (max: 6)', 11),
            ('error_voicenote_record',  'Unable to recording voice while another application is recording sound.',  'es_mx',    'No se puede grabar mietnras otrs aplicación está grabando sonido.',    11),
            ('msg_warning', 'Warning!', 'es_mx',    '¡Advertencia!',    11),
            ('Permision_denied_contact',    'Permission denied to access your contacts',    'es_mx',    'Permiso denegado para accesar sus contactos',  15),
            ('no_widget_added', 'Please click + icon to add new widget to your dashboard.', 'es_mx',    'Favor de hacer clic + ícono para añadir en nuevo widget a su tablero.',    15),
            ('no_data_available',   'Data not available, please check the selected fields', 'es_mx',    'Información no disponible, favor de verificar los campos seleccionados',   15),
            ('check_out_successfully',  'Check out successfully',   'es_mx',    'Mira con éxito',   11),
            ('check_in_successfully',   'Check in successfully',    'es_mx',    'Checked in successfully',  11),
            ('check_out',   'Check out',    'es_mx',    'Mira', 11),
            ('check_in',    'Check in', 'es_mx',    'Revisa',   11),
            ('navigate',    'Navigate', 'es_mx',    'Navegar',  11),
            ('save_to_phone_vcard_success', 'VCard Saved to phone successfully',    'es_mx',    'La VCard se guardó en el teléfono exitosamente',   15),
            ('download_vcard_success',  'VCard downloaded successfully',    'es_mx',    'La VCard se descargó exitosamente',    15),
            ('card_details',    'Card Details', 'es_mx',    'Detalles de la tarjeta',   15),
            ('add_widget',  'Add Widget',   'es_mx',    'Añadir widget',    15),
            ('delete_widget',   'Are you sure to hide widget?', 'es_mx',    'Está seguro de que quiere esconder el widget?',    15),
            ('already_widgets_added',   'All types of Widget & reports are already added',  'es_mx',    'Todos los tipos de widget & reportes ya están añadidos',   15),
            ('retry',   'Retry',    'es_mx',    'Volver a intentar',    28),
            ('retake',  'Retake',   'es_mx',    'Retomar',  28),
            ('Reports', 'Reports',  'es_mx',    'Reportes', 15),
            ('Widgets', 'Widgets',  'es_mx',    'Widgets',  15),
            ('vcard_config',    'Vcard Configuration',  'es_mx',    'Configuración Vcard',  8),
            ('save_to_phone',   'Save to phone',    'es_mx',    'Guardar en teléfono',  11),
            ('download_vcard',  'Download Vcard',   'es_mx',    'Descargar Vcard',  11),
            ('share_vcard', 'Share Vcard',  'es_mx',    'Compartir Vcard',  11),
            ('share_record',    'Share Record', 'es_mx',    'Compartir registro',   11),
            ('permission_denied_edit',  'You don\'t have permission to edit this record.',  'es_mx',    'No tiene permiso para editar este registro.',  27),
            ('permission_denied_delete',    'You don\'t have permission to delete this record.',    'es_mx',    'No tiene permiso para borrar este registro.',  27),
            ('Voice_Recording_Started', 'Recording Started',    'es_mx',    'El registro inició',   12),
            ('Voice_Recording_Stopped', 'Recording Stopped',    'es_mx',    'El registro se detuvo',    12),
            ('SEARCH',  'Search',   'es_mx',    'Búsqueda', 7),
            ('LAST',    'Last', 'es_mx',    'Último',   7),
            ('FIRST',   'First',    'es_mx',    'Primero',  7),
            ('MONDAY',  'Monday',   'es_mx',    'Lunes',    7),
            ('TUESDAY', 'Tuesday',  'es_mx',    'Martes',   7),
            ('WEDNESDAY',   'Wednesday',    'es_mx',    'Miércoles',    7),
            ('THURSDAY',    'Thursday', 'es_mx',    'Jueves',   7),
            ('FRIDAY',  'Friday',   'es_mx',    'Viernes',  7),
            ('SATURDAY',    'Saturday', 'es_mx',    'Sábado',   7),
            ('SUNDAY',  'Sunday',   'es_mx',    'Domingo',  7),
            ('DAILY',   'Daily',    'es_mx',    'Diariamente',  7),
            ('WEEKLY',  'Weekly',   'es_mx',    'Semanalmente', 7),
            ('MONTHLY', 'Monthly',  'es_mx',    'Mensualmente', 7),
            ('YEARLY',  'Yearly',   'es_mx',    'Anualmente',   7),
            ('asset_tracking',  'Asset tracking',   'es_mx',    'Rastreo de activos',   15),
            ('open_file',   'Open File',    'es_mx',    'Abre Archivo', 1),
            ('download_pdf_successfully',   'Download PDF Successfully',    'es_mx',    'Descargar PDF con éxito',  1),
            ('select_pdf',  'Select PDF',   'es_mx',    'Seleccione PDF',   1),
            ('email_pdf',   'Email PDF',    'es_mx',    'Correo PDF',   1),
            ('download_pdf',    'Download PDF', 'es_mx',    'Descargar PDF',    1),
            ('edit_route',  'Edit Route',   'es_mx',    'Editar la ruta',   1),
            ('save_route',  'Save Route',   'es_mx',    'Salva la ruta',    1),
            ('clear_all',   'Clear All',    'es_mx',    'Despejado todo',   1),
            ('notification',    'Notifications',    'es_mx',    'Notificaciones',   1),
            ('menu_management', 'Menu Management',  'es_mx',    'Gestión de menús', 1),
            ('select_menu', 'Select Menu',  'es_mx',    'Seleccione menú',  1),
            ('module_record_not_found', 'Module and Record not found',  'es_mx',    'Módulo y registro no encontrados', 1),
            ('reason_for_changing_comments',    'Reason for changing comments', 'es_mx',    'Razón para cambiar los comentarios',   1),
            ('edit_reason', 'Edit Reason',  'es_mx',    'Editar la razón',  1),
            ('create_filters',  'Create Filter',    'es_mx',    'Crear Filtro', 1),
            ('you_checked', 'You Checked',  'es_mx',    'Lo comprobaste',   1),
            ('you_un_checked',  'You UnChecked',    'es_mx',    'No revisaste', 1),
            ('log_the_call',    'Log the call ?',   'es_mx',    '¿Revisa la llamada?\n',    1),
            ('add_a_description_(optional)',    'Add a description (optional)', 'es_mx',    'Añadir una descripción (opcional)',    1),
            ('called',  'Called',   'es_mx',    'Llamado',  1),
            ('call_log',    'Call Log', 'es_mx',    'Llama a Log',  1),
            ('subject', 'Subject',  'es_mx',    'Asunto',   1),
            ('add_condition',   'Add Condition',    'es_mx',    'Añadir condiciones',   1),
            ('select_condition',    'Select Condition', 'es_mx',    'Seleccione la condición',  1),
            ('select_field',    'Select Field', 'es_mx',    'Seleccione Campo', 1),
            ('please_select_first_field',   'Please First Select field',    'es_mx',    'Por favor, primero Seleccione campo',  1),
            ('filter_name', 'Filter Name',  'es_mx',    'Nombre del filtro',    1),
            ('enter_filter_name',   'Enter filter name',    'es_mx',    'Introduzca el nombre del filtro',  1),
            ('choose_conditions',   'Choose Conditions',    'es_mx',    'Introduccia el nombre del filtro', 1),
            ('all_condition',   'All Conditions(All conditions must be met)',   'es_mx',    'Todas las condiciones(Se deben cumplir todas las condiciones)',    1),
            ('any_condition',   'Any Conditions(At least one the conditions must be met)',  'es_mx',    'Cualquier condición(al menos una de las condiciones deben cumplirse)', 1),
            ('lattitude',   'latitude', 'es_mx',    'latitud',  1),
            ('notification_settings',   'Notification Settings',    'es_mx',    'Configuraciones de notificación',  1),
            ('notification_management', 'Notification Management',  'es_mx',    'Gestión de la notificación',   1),
            ('addyourcommentshere', 'Type @ to mention user',   'es_mx',    'Tipo @ para mencionar al usuario', 1),
            ('google_api_key_missing',  'Google Api key is missing.',   'es_mx',    'Falta la llave de Google Api.',    1),
            ('event_filter_by', 'Event Filter by',  'es_mx',    'Filtro de eventos',    1),
            ('apply',   'Apply',    'es_mx',    'Aplicar',  1),
            ('choose_from_gallery', 'Choose From Gallery',  'es_mx',    'Elija de la Galería',  1),
            ('choose_from_camera',  'Choose From Camera',   'es_mx',    'Elija de la cámara',   1),
            ('mutli_select_CB', 'Mutli Select CB',  'es_mx',    'Mutli Seleccione CB',  1),
            ('please_select_condition', 'Please Select Condition',  'es_mx',    'Por favor, seleccione la condición',   1),
            ('please_enter_value_or_field', 'Please Enter Value or Field',  'es_mx',    'Por favor, introduzca el valor o el campo',    1),
            ('set_as_default',  'Set as Default',   'es_mx',    'Establecido como por defecto', 1),
            ('list_in_metrics', 'List in Metrics',  'es_mx',    'Lista en Metrics', 1),
            ('order_number',    'Order Number', 'es_mx',    'Número de orden',  1),
            ('recording_saved_message', 'Recording saved successfully.',    'es_mx',    'Grabación ahorrada con éxito.',    1),
            ('recording_file',  'Recording File',   'es_mx',    'Registro de archivos', 1),
            ('file_not_found',  'File not found',   'es_mx',    'Archivo no encontrado',    1),
            ('please_enter_valid_path', 'Please enter valid path',  'es_mx',    'Por favor, introduzca el camino válido',   1),
            ('enter_path_here', 'Enter path here...',   'es_mx',    'Entra el camino aquí...',  1),
            ('set_call_recording_path', 'Set Call Recording Path',  'es_mx',    'Sendero de grabación de llamadas', 1),
            ('set_call_recording_path_here',    'Set call recording path here', 'es_mx',    'Ajuste el camino de grabación aquí',   1),
            ('call_recording_path', 'Call Recording Path',  'es_mx',    'Llama a Sendero de Registro',  1),
            ('please_place_api',    'Please enable place api',  'es_mx',    'Por favor, habilite el lugar api', 1),
            ('event_filters_by',    'Event Filters by', 'es_mx',    'Filtros de eventos por',   1),
            ('select_at_least_one_option',  'Please select at least one option',    'es_mx',    'Por favor, seleccione al menos una opción',    1),
            ('enable_call_feature', 'Please enable call feature',   'es_mx',    'Por favor, habilite la función de llamada',    1),
            ('enable_email_feature',    'Please enable email feature',  'es_mx',    'Por favor, habilite la función de correo electrónico', 1),
            ('demo_login',  'Demo Login',   'es_mx',    'Demo Login',   1),
            ('select_email_template',   'Select Email Template',    'es_mx',    'Seleccione la plantilla de correo electrónico',    1),
            ('template_name',   'Template Name',    'es_mx',    'Nombre de plantilla',  1),
            ('example_storage_path',    'example : storage/Music/Recordings/Call Recordings',   'es_mx',    'ejemplo : almacenamiento/música/grabaciones/llamadas', 1),
            ('User Notification Settings saved successfully',   'User Notification Settings saved successfully',    'es_mx',    'Configuraciones de Notificación de Usuario guardadas con éxito',   33),
            ('This Notification has been disabled by admin',    'This Notification has been disabled by admin', 'es_mx',    'Esta notificación ha sido desactivada por administrador',  33),
            ('Notify when any updates to the record you\'re following', 'Notify when any updates to the record you\'re following',  'es_mx',    'Avise cuando cualquier actualización del registro que está siguiendo', 33),
            ('Task assigned to you',    'Task assigned to you', 'es_mx',    'Tarea asignada a usted',   33),
            ('Task Reminder',   'Task Reminder',    'es_mx',    'Reminder de tareas',   33),
            ('You were mentioned in comments',  'You were mentioned in comments',   'es_mx',    'Se le mencionó en comentarios',    33),
            ('Comments has been added to record assigned to you',   'Comments has been added to record assigned to you',    'es_mx',    'Se han añadido comentarios a los registros que se le han asignado',    33),
            ('When Record Assigned',    'When Record Assigned', 'es_mx',    'Cuando Registro Asignado', 33),
            ('Event Reminder',  'Event Reminder',   'es_mx',    'Reminder de eventos',  33),
            ('Event Invitation',    'Event Invitation', 'es_mx',    'Invitación de eventos',    33),
            ('Follow record',   'Follow record',    'es_mx',    'Siga el registro', 33),
            ('Task',    'Task', 'es_mx',    'Tarea',    33),
            ('Conversions', 'Conversions',  'es_mx',    'Conversiones', 33),
            ('Events',  'Events',   'es_mx',    'Eventos',  33),
            ('no_records_changed_filter_message',   'No record(s) found Please click on filter icon to change filter',  'es_mx',    'No se encuentran registros, haga clic en el icono de filtro para cambiar filtro',  1),
            ('title',   'Title',    'es_mx',    'Título',   1),
            ('dialog_recent_call_info', 'Click + to select your mobile call recording folder where your recorded call files are stored.',   'es_mx',    'Haga clic en + para seleccionar su carpeta de grabación de llamadas móviles donde se almacenan sus archivos de llamada grabados.', 1),
            ('call_recording',  'Call recording',   'es_mx',    'Llama a grabación',    1),
            ('voice_recorder',  'Voice Recorder',   'es_mx',    'Registro de voz',  1),
            ('no_address_reference_found',  'No Address Reference found',   'es_mx',    'No se encontró ninguna referencia a la dirección', 32),
            ('no_overdue_activities',   'No OverDue Activities',    'es_mx',    'No hay actividades superDue',  32),
            ('latitude_longitude_validation_message',   'Please enter proper address from this address we are not getting proper latitude and longitude',   'es_mx',    'Por favor, introduzca la dirección correcta de esta dirección que no estamos recibiendo la latitud y la longitud adecuadas',   32),
            ('Default_Search_Field',    'Default search field', 'es_mx',    'Campo de búsqueda por defecto',    32),
            ('Calender_Reminder_Message',   'Free user can\'t send local reminder', 'es_mx',    'El usuario gratuito no puede enviar recordatorio local',   32),
            ('you_must_have_permission',    'You must give permissions to use this features.',  'es_mx',    'Debe dar permisos para usar estas características.',   32),
            ('internal_comment',    'Internal Comment', 'es_mx',    'Comentario interno',   1),
            ('unlink_record',   'Unlink Record',    'es_mx',    'Desconectar el registro',  11),
            ('unlink_record_msg',   'Are you sure want to unlink record?',  'es_mx',    '¿Seguro que quieres desactivar el registro?',  11),
            ('file_format_not_support', 'File format not supported',    'es_mx',    'Formato de archivo no soportado',  11),
            ('file_upload', 'File Upload',  'es_mx',    'Archivo subido',   5),
            ('to_vtiger',   'To Vtiger',    'es_mx',    'Por Vtiger',   5),
            ('link_external_document',  'Link External Document',   'es_mx',    'Enlace Documento Externo', 5),
            ('from_file_url',   'From File Url',    'es_mx',    'De Archivo Url',   5),
            ('create_new_document', 'Create New Document',  'es_mx',    'Crear un nuevo documento', 5),
            ('select_document_type',    'Select Document type', 'es_mx',    'Seleccione el tipo de documento',  5),
            ('add_signature',   'Please add signature', 'es_mx',    'Por favor, añada la firma',    11),
            ('date_greater_then_equal', 'should be greater than or equal to',   'es_mx',    'debería ser mayor o igual a',  1),
            ('date_less_then_equal',    'should be less than or equal to',  'es_mx',    'debería ser inferior o igual a',   1),
            ('Click_on_plus_for_add',   'Please tap on  +  to create a new record.',    'es_mx',    'Por favor, ponga en + para crear un nuevo récord.',    15),
            ('display_map', 'Display map',  'es_mx',    'Muestra mapa', 15),
            ('other_settings',  'Other settings',   'es_mx',    'Otros ajustes',    15),
            ('total_hours', 'Total hours',  'es_mx',    'Horas totales',    15),
            ('widget_not_found',    'No widgets found', 'es_mx',    'No se encontró ningún widgets',    15),
            ('quickaction', 'Quick action', 'es_mx',    'Acción rápida',    15),
            ('dashboard',   'Dashboard',    'es_mx',    'Base de datos',    15),
            ('new', 'New',  'es_mx',    'Nuevo',    15),
            ('global_search_hint',  'Please try to search using search box at top', 'es_mx',    'Por favor, trate de buscar usando caja de búsqueda en la parte superior',  15),
            ('near_by_map', 'Near By Map',  'es_mx',    'Cerca del mapa',   15),
            ('miles',   'Miles',    'es_mx',    'Miles',    15),
            ('lbl_filters', 'Filters',  'es_mx',    'Filtros',  27),
            ('warning', 'Warning',  'es_mx',    'Advertencia',  27),
            ('no_filter_created',   'No filter is created.',    'es_mx',    'No se crea ningún filtro.',    27),
            ('please_create_new_ilter', 'Please create a new filter',   'es_mx',    'Por favor, cree un nuevo filtro',  27),
            ('select_search_fields',    'Select fields for the search record.', 'es_mx',    'Seleccione campos para el registro de búsqueda.',  27),
            ('apply_fliters',   'Apply filters',    'es_mx',    'Aplicar filtros',  27),
            ('sort_by', 'Sort by',  'es_mx',    'Algo así', 27),
            ('sort_order',  'Sort order',   'es_mx',    'Orden de orden',   27),
            ('Start_time_tracking', 'Start time tracking',  'es_mx',    'Empieza a rastrear el tiempo', 31),
            ('Stop_time_tracking',  'Stop time tracking',   'es_mx',    'Deja de rastrear el tiempo',   31),
            ('image_preview',   'Image preview',    'es_mx',    'Imagen previa',    11),
            ('phone_number',    'Phone number', 'es_mx',    'Número de teléfono',   11),
            ('email_address',   'Email address',    'es_mx',    'Dirección de correo electrónico',  11),
            ('edit_your_preferences',   'Edit your preferences',    'es_mx',    'Edit your preferences',    8),
            ('about_app',   'About app',    'es_mx',    'Sobre la aplicación',  8),
            ('updated_ctmobile_ext_version',    'You already have latest CTMobile Ext. Version',    'es_mx',    'Ya tienes la última CTMobile Ext. Versión',    8),
            ('updated_app_version', 'You already have latest CRMTiger App Version', 'es_mx',    'Ya tienes la última versión CRMTiger App', 8),
            ('plan',    'Plan', 'es_mx',    'Plan', 8),
            ('time',    'Time', 'es_mx',    'Tiempo',   31),
            ('error_log_msg',   'Oops, something went wrong! Please click on Share Button to share error log with our technical team',  'es_mx',    '¡Oops, algo salió mal! Por favor haga clic en Share Boton para compartir el registro de errores con nuestro equipo técnico',   1),
            ('add_to_quick_action', 'Add to quick action',  'es_mx',    'Añadir a la acción rápida',    1),
            ('add_filter_to_quick_action',  'Add filter to quick action',   'es_mx',    'Añadir filtro a acción rápida',    1),
            ('create_record',   'Create Record',    'es_mx',    'Crear Registro',   1),
            ('quick_action_hint',   'You can Add Quick Action here',    'es_mx',    'Puedes agregar Acción Rápida aquí',    1),
            ('str_send',    'Send', 'es_mx',    'Enviar',   3),
            ('tax_region_msg',  'Do you want to update tax & charge values corresponding to selected region?',  'es_mx',    '¿Desea actualizar los valores de impuestos y tasas correspondientes a una región seleccionada?',   1),
            ('delete_quick_action_widgest', 'Delete Widget?',   'es_mx',    '¿Suprimir a Widget?',  15),
            ('add_record_to_dashboard', 'Add record to dashboard',  'es_mx',    'Añadir el disco al tablero',   15),
            ('module_quick_action_msg', 'Module added to dashboard',    'es_mx',    'Módulo añadido al tablero',    15),
            ('filter_quick_action_msg', 'Filter added to dashboard',    'es_mx',    'Filtro añadido al tablero',    15),
            ('record_quick_action_msg', 'Record added to dashboard',    'es_mx',    'Registro añadido al tablero',  15),
            ('filter_shortcut_quick_action_msg',    'Filter shortcut added to dashboard',   'es_mx',    'El atajo de filtro añadido al tablero',    15),
            ('record_shortcut_quick_action_msg',    'Record shortcut added to dashboard',   'es_mx',    'El atajo de grabación añadido al tablero', 15),
            ('documents_disabled',  'Documents Module is disabled', 'es_mx',    'Módulo de documentos está desactivado',    1),
            ('document_dont_attachment',    'Document does not have a attachment',  'es_mx',    'El documento no tiene un apego',   1),
            ('go_to_neat_by',   'Go to NearBy', 'es_mx',    'Ve a Cerca de By', 15),
            ('go_to_time_tracking', 'Go to Time Tracker',   'es_mx',    'Ve a Time Tracker',    13),
            ('nearby_quick_action_msg', 'NearBy added to dashboard',    'es_mx',    'Cerca de By agregado al tablero',  15),
            ('time_tracking_quick_action_msg',  'Time Tracking added to dashboard', 'es_mx',    'Rastreo de tiempo añadido al tablero', 15),
            ('attendance_quick_action_msg', 'Attendance added to dashboard',    'es_mx',    'La asistencia se añadió al tablero de tablero',    15),
            ('attachment',  'Attachment',   'es_mx',    'Apéndice', 15),
            ('search_by_fields',    'Search by fields', 'es_mx',    'Buscar por campos',    27),
            ('apply_selected',  'Apply selected',   'es_mx',    'Aplicar seleccionada', 27),
            ('auto_address_disabled',   'auto address finder is disabled, please enable it from CRMTiger Settings', 'es_mx',    'el buscador de dirección automática está desactivado, por favor habilitado desde CRMTiger Configuraciones',    1),
            ('Attendance',  'Attendance',   'es_mx',    'Participación',    15),
            ('Check-in successfully',   'Check-in successfully',    'es_mx',    'Revisar con éxito',    32),
            ('Check-out successfully',  'Check-out successfully',   'es_mx',    'Check-out exitosamente',   32),
            ('Nothing around here', 'Nothing around here',  'es_mx',    'Nada por aquí',    13),
            ('select_days', 'Select Days',  'es_mx',    'Selecciona los días',  5),
            ('select_minutes',  'Select Minutes',   'es_mx',    'Seleccione Actas', 5),
            ('select_hours',    'Select Hours', 'es_mx',    'Seleccione Horas', 5),
            ('no_lat_long_found',   'Location information (Latitude,Longitude) not found',  'es_mx',    'Información de localización (Latitude, Longitud) no encontrada',   32),
            ('Call Log save successfully',  'Call Log save successfully',   'es_mx',    'Llama a Log ahorra con éxito', 32),
            ('Files/photos deleted successfully',   'Files/photos deleted successfully',    'es_mx',    'Archivos/fotos borrados con éxito',    32),
            ('important',   'Important',    'es_mx',    'Importante',   34),
            ('template',    'Template', 'es_mx',    'Plantilla',    34),
            ('copy',    'Copy', 'es_mx',    'Copiar',   34),
            ('camera',  'Camera',   'es_mx',    'Cámara',   34),
            ('gallery', 'Gallery',  'es_mx',    'Galería',  34),
            ('audio',   'Audio',    'es_mx',    'Audio',    34),
            ('last_seen_at',    'Last seen at', 'es_mx',    'Visto por última vez en    ',  34),
            ('type_a_message',  'Type a message',   'es_mx',    'Escribe un mensaje',   34),
            ('all_messages',    'All messages', 'es_mx',    'Todos los mensajes',   34),
            ('time_tracking_reports',   'Time tracking reports',    'es_mx',    'Informes de seguimiento del tiempo',   31),
            ('attendance_reports',  'Attendance reports',   'es_mx',    'Informes de asistencia',   31),
            ('chats',   'Chats',    'es_mx',    'Charlas',  34),
            ('Marked chat as Important',    'Marked chat as Important', 'es_mx',    'El chat se marcó como importante', 34),
            ('Unmarked chat as Important',  'Unmarked chat as Important',   'es_mx',    'Chat sin marcar como importante',  34),
            ('mark_as_important',   'Mark as important',    'es_mx',    'Marcar como importante',   34),
            ('unmark_As_important', 'Unmark as important',  'es_mx',    'Desmarcar como importante',    34),
            ('select_template', 'Select template',  'es_mx',    'Seleccionar plantilla',    34),
            ('chat',    'Chat', 'es_mx',    'Charlar',  34),
            ('search_by_name_or_contact',   'Search by name or contact',    'es_mx',    'Buscar por nombre o contacto', 34),
            ('choose_contact_for_whatsApp', 'Choose contact for whatsApp',  'es_mx',    'Elige contacto para whatsApp', 34),
            ('whatsapp_template',   'Whatsapp template',    'es_mx',    'Plantilla WhatsApp',   34),
            ('send_voice_recording',    'Send voice recording', 'es_mx',    'Enviar grabación de voz',  34),
            ('slide_to_cancel', 'Slide To Cancel',  'es_mx',    'Deslizar para cancelar',   34),
            ('select_priority', 'Select priority',  'es_mx',    'Seleccione prioridad', 30),
            ('repeat_route',    'Repeat route', 'es_mx',    'Repite la ruta',   30),
            ('change_assign_to',    'Change assigned to',   'es_mx',    'Cambio asignado',  30),
            ('Multiple Route created successfully', 'Multiple Route created successfully',  'es_mx',    'Múltiple Ruta creada con éxito',   30),
            ('Route duplicated successfully',   'Route duplicated successfully',    'es_mx',    'La ruta duplicó con éxito',    30);",array());
        }
    }

    static function hu_hu(){
        global $adb;
        $checkLang = $adb->pquery("SELECT 1 FROM ctmobile_language_keyword WHERE keyword_lang = ?",array('es_mx'));
        if($adb->num_rows($checkLang) == 0){
            $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error', 'Network connection error!', 'hu_hu', 'Hálózati csatlakozási hiba!', 1),
            ('connection_check', 'Could not connect to CRM, Please check your Internet connection.', 'hu_hu', 'Nem sikerült csatlakozni a CRM-hez. Ellenőrizze az internetkapcsolatot.', 1),
            ('update', 'Update', 'hu_hu', 'Frissítés', 1),
            ('cancel', 'Cancel', 'hu_hu', 'Mégse', 1),
            ('ok', 'Ok', 'hu_hu', 'Rendben', 1),
            ('more_information', 'Click here for more information.', 'hu_hu', 'Kattintson ide további információért.', 1),
            ('yes', 'Yes', 'hu_hu', 'Igen', 1),
            ('no', 'No', 'hu_hu', 'Nem', 1),
            ('click_again_exit', 'Click again to exit', 'hu_hu', 'Kattintson újra a kilépéshez', 1),
            ('forpermission', 'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.', 'hu_hu', 'Nincs engedélye ennek a funkciónak a megtekintéséhez. Kérjük, iratkozzon fel a prémium verzióért. Kattintson ide az előfizetéshez.', 1),
            ('clickhere', 'Click here', 'hu_hu', 'Kattintson ide', 1),
            ('clickhere_subscribe', 'Click here to subscribe premium version', 'hu_hu', 'Kattintson ide a prémium verzió előfizetéséhez', 1),
            ('clickhere_configure', 'Click here and view how to Configure.', 'hu_hu', 'Kattintson ide, és tekintse meg, hogyan kell konfigurálni.', 1),
            ('please_wait', 'Please Wait…', 'hu_hu', 'Kérjük várjon ...', 1),
            ('share__msg', 'Share file with', 'hu_hu', 'Fájl megosztása', 1),
            ('dialog_camera', 'Camera', 'hu_hu', 'Kamera', 1),
            ('dialog_add_file_by', 'Take Photo from', 'hu_hu', 'Fotó készítése innen', 1),
            ('add', 'Add', 'hu_hu', 'Új', 1),
            ('mail_manager_configured', 'Mail Manager is not configured', 'hu_hu', 'A Mail Manager nincs konfigurálva', 1),
            ('dialog_add_files_by', 'Add Files by', 'hu_hu', 'Fájlok hozzáadása', 1),
            ('dialog_drive', 'Drive', 'hu_hu', 'Drive', 1),
            ('dialog_drop_box', 'Drop Box', 'hu_hu', 'Drop Box', 1),
            ('dialog_need_signin', 'You need to Sign-in to your Drive account first.', 'hu_hu', 'Először be kell jelentkeznie Drive-fiókjába.', 1),
            ('dialog_gallery', 'Gallery', 'hu_hu', 'Galéria', 1),
            ('delete', 'Delete', 'hu_hu', 'Törlés', 1),
            ('timeoutmessage', 'Oops! Request is taking more time than expected.', 'hu_hu', 'Hoppá! A kérés a vártnál több időt vesz igénybe.', 1),
            ('gps_location_message', 'GPS is not enabled. Please turn it on to get your near by locations.', 'hu_hu', 'A GPS nincs engedélyezve. Kérjük, kapcsolja be, hogy megtalálja a közeli helyeket.', 1),
            ('sure_want_delete', 'Are you sure want to delete ?', 'hu_hu', 'Biztosan törölni szeretné?', 1),
            ('select', 'Select', 'hu_hu', 'Kiválaszt', 1),
            ('msgforrecordaudio', 'Minimum record duration one second.', 'hu_hu', 'A felvétel minimális időtartama egy másodperc.', 1),
            ('permission_storage', 'Permission denied to read your External storage', 'hu_hu', 'Engedély megtagadva a külső tárhely olvasásához', 1),
            ('send_permission_msg', 'Send message permission denied', 'hu_hu', 'Üzenetküldési engedély megtagadva', 1),
            ('choosefile', 'Choose File', 'hu_hu', 'Fájl választása', 1),
            ('enter', 'Enter', 'hu_hu', 'Belép', 1),
            ('select_an_option', 'Select an Option', 'hu_hu', 'Válasszon egy lehetőséget', 1),
            ('email_validation', 'Email is not valid', 'hu_hu', 'Az e-mail nem érvényes', 1),
            ('please_enter', 'Please Enter', 'hu_hu', 'Kérlek lépj be', 1),
            ('website_validation_text', 'Website URL is not valid', 'hu_hu', 'A webhely URL-címe érvénytelen', 1),
            ('selectvalue', 'Select value first', 'hu_hu', 'Először válassza ki az értéket', 1),
            ('email', 'Email', 'hu_hu', 'Email', 1),
            ('enter_email_address', 'Enter email address', 'hu_hu', 'Adja meg az email címét', 1),
            ('email_address_not_correct', 'Email address incorrect', 'hu_hu', 'Az e-mail cím helytelen', 1),
            ('pls_enter_subject', 'Please Enter Subject', 'hu_hu', 'Kérjük, adja meg a tárgyat', 1),
            ('attachFiles', 'Attached File', 'hu_hu', 'Csatolt fájl', 1),
            ('from', 'From', 'hu_hu', 'Küldő', 1),
            ('to', 'To', 'hu_hu', 'Címzett', 1),
            ('call_permission_msg', 'Call permission denied', 'hu_hu', 'Hívási engedély megtagadva', 1),
            ('no_records', 'No records found', 'hu_hu', 'Nincs találat', 1),
            ('fullform', 'Create New', 'hu_hu', 'Új létrehozása', 1),
            ('save', 'Save', 'hu_hu', 'Mentés', 1),
            ('total', 'Total', 'hu_hu', 'Összesen', 1),
            ('discount', 'Discount', 'hu_hu', 'Kedvezmény', 1),
            ('price', 'Price', 'hu_hu', 'Ár', 1),
            ('quantity', 'Quantity', 'hu_hu', 'Mennyiség', 1),
            ('select_module', 'Select Module', 'hu_hu', 'Válasszon modult', 1),
            ('item_list', 'Item List', 'hu_hu', 'Tétel lista', 1),
            ('quickcreate', 'Quick Create', 'hu_hu', 'Gyors létrehozás', 1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'hu_hu', 'Írja felül a meglévő címet a kiválasztottal', 1),
            ('once_in_every', 'Once in every', 'hu_hu', 'Egyszer minden ', 1),
            ('overwrite_msg_part2', 'address details?', 'hu_hu', 'Címadatok?', 1),
            ('add_item', 'Add Item', 'hu_hu', 'Tétel hozzáadása', 1),
            ('recordsave', 'Record saved successfully', 'hu_hu', 'A rekord sikeresen mentve', 1),
            ('recordnotsave', 'Could not save record. Try again later', 'hu_hu', 'Nem sikerült menteni a rekordot. Próbáld újra később', 1),
            ('minutes', 'Minutes', 'hu_hu', 'Perc', 1),
            ('hours', 'Hours', 'hu_hu', 'Óra', 1),
            ('days', 'Days', 'hu_hu', 'Nap', 1),
            ('on', 'On', 'hu_hu', '', 1),
            ('day_of_the_month', 'day of the month', 'hu_hu', 'a hónap napja', 1),
            ('list_price', 'List Price', 'hu_hu', 'Lista ár', 1),
            ('add_record', 'Add Record', 'hu_hu', 'Rekord hozzáadása', 1),
            ('add_product', 'Add Product', 'hu_hu', 'Termék hozzáadása', 1),
            ('add_service', 'Add Service', 'hu_hu', 'Szolgáltatás hozzáadása', 1),
            ('discountin', 'Discount in %', 'hu_hu', 'Kedvezmény %-ban', 1),
            ('unitprice', 'Unit price', 'hu_hu', 'Egységár', 1),
            ('netprice', 'Net price', 'hu_hu', 'Nettó ár', 1),
            ('comments', 'Comments', 'hu_hu', 'Megjegyzések', 1),
            ('add_close', 'Add & Close', 'hu_hu', 'Hozzáad & bezár', 1),
            ('fetching_rout_message', 'Fetching route, Please wait…', 'hu_hu', 'Útvonal lekérése, kérjük, várjon…', 1),
            ('setting', 'Settings', 'hu_hu', 'Beállítások', 1),
            ('utc', 'UTC', 'hu_hu', 'UTC', 1),
            ('in', 'In', 'hu_hu', '', 1),
            ('days_ago', 'days ago', 'hu_hu', 'nappal ezelőtt', 1),
            ('mins_ago', 'Minutes ago', 'hu_hu', 'perccel ezelőtt', 1),
            ('justnow', 'Just now', 'hu_hu', 'Éppen most', 1),
            ('hours_ago', 'hours ago', 'hu_hu', 'órával ezelőtt', 1),
            ('in_1_day', 'In 1 day', 'hu_hu', 'Egy napon belül', 1),
            ('scanqrcode', 'Asset / Card scanner', 'hu_hu', 'Eszköz/kártya szkenner', 1),
            ('call_log', 'Call Log', 'hu_hu', 'Hívás Log', 1),
            ('voice_message', 'Hi', 'hu_hu', 'Hello', 1),
            ('voice_message1', 'What can I search for you in', 'hu_hu', 'Mit tudok keresni számodra', 1),
            ('live_tracking', 'Live Tracking', 'hu_hu', 'Élő követés', 1),
            ('mailmanager', 'Mail Manager', 'hu_hu', 'Mail Manager', 1),
            ('my_location', 'My location', 'hu_hu', 'Helyzetem', 1),
            ('created_on', 'Created On', 'hu_hu', 'Létrehozva', 1),
            ('modified_on', 'Modified On', 'hu_hu', 'Módosítva', 1),
            ('enter_comments', 'Enter Comments', 'hu_hu', 'Írja ide megjegyzését', 1),
            ('viewmore', 'View More', 'hu_hu', 'Mutass többet', 1),
            ('viewless', 'View Less', 'hu_hu', 'Mutass kevesebbet', 1),
            ('gotofullform', 'Go to Full Form', 'hu_hu', 'Lépjen a Teljes űrlaphoz', 1),
            ('post', 'Post', 'hu_hu', 'Hozzászól', 1),
            ('url', 'URL', 'hu_hu', 'URL', 1),
            ('dialog_title_text_back_color', 'Select a Text Background Color', 'hu_hu', 'Válasszon ki egy szöveg háttérszínt', 1),
            ('event_or_task', 'Add event/task', 'hu_hu', 'Esemény/feladat hozzáadása', 1),
            ('shortcut', 'Shortcuts', 'hu_hu', 'Parancsikonok', 1),
            ('select_field', 'Select Field', 'hu_hu', 'Mező kiválasztása', 1),
            ('share', 'Share', 'hu_hu', 'Megosztás', 1),
            ('title_insert_link', 'Insert Link', 'hu_hu', 'Link beillesztése', 1),
            ('addyourcommentshere', 'Add your comments here', 'hu_hu', 'Írja ide megjegyzéseit', 1),
            ('nocomment', 'No Comments', 'hu_hu', 'No Comments', 1),
            ('leads', 'Leads', 'hu_hu', 'Vevőjelöltek', 1),
            ('true_val', 'true', 'hu_hu', 'igaz', 1),
            ('noresult', 'No Result', 'hu_hu', 'Nincs találat', 1),
            ('version', 'Version', 'hu_hu', 'Verzió', 1),
            ('convert_lead', 'Convert Lead', 'hu_hu', 'Vevőjelölt kovertálás', 1),
            ('app_name', 'CRMTiger', 'hu_hu', 'SOMACRM', 1),
            ('enter_url', 'Please Enter url', 'hu_hu', 'Kérjük, adja meg az url-t', 1),
            ('help', 'Help', 'hu_hu', 'Segítség', 1),
            ('contact_us', 'Contact Us', 'hu_hu', 'Lépjen kapcsolatba velünk', 1),
            ('updates', 'Updates', 'hu_hu', 'Frissítések', 1),
            ('logout', 'LogOut', 'hu_hu', 'Kijelentkezés', 1),
            ('busnies_cardscanner', 'Business Card Scanner', 'hu_hu', 'Névjegykártya szkenner', 1),
            ('sure_want_logout', 'Are you sure want to logout ?', 'hu_hu', 'Biztosan ki akar jelentkezni?', 1),
            ('logout_message', 'Logout successfully', 'hu_hu', 'Sikeres kijelentkezés', 1),
            ('all', 'All', 'hu_hu', 'Minden', 1),
            ('add_event', 'Add event', 'hu_hu', 'Esemény hozzáadása', 1),
            ('add_task', 'Add Task', 'hu_hu', 'Feladat hozzáadása', 1),
            ('next', 'Next', 'hu_hu', 'Következő', 1),
            ('terms_conditions', 'Terms and Conditions', 'hu_hu', 'Felhasználási feltételek', 1),
            ('login', 'Login', 'hu_hu', 'Bejelentkezés', 2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy', 'hu_hu', 'A bejelentkezéssel elfogadja Általános Szerződési Feltételeinket és Adatvédelmi szabályzatunkat', 2),
            ('copyright', 'Copyright © 2020 CRMTiger Version', 'hu_hu', 'SOMACRM', 2),
            ('enter_username', 'Please enter username', 'hu_hu', 'Kérjük, adja meg a felhasználónevét', 2),
            ('enter_password', 'Please enter password', 'hu_hu', 'Kérjük, adja meg jelszavát', 2),
            ('remanberme', 'Remember Me', 'hu_hu', 'Emlékezz rám', 2),
            ('forgot_password', 'Forgot password?', 'hu_hu', 'Elfelejtett jelszó?', 2),
            ('privacy_policay1', 'Privacy Policy', 'hu_hu', 'Adatvédelmi irányelvek', 2),
            ('contactsupportmsg', 'Something went wrong. \n please Click here to contact support.', 'hu_hu', 'Valami elromlott.\n  Kérjük, kattintson ide, hogy kapcsolatba lépjen az ügyfélszolgálattal.', 2),
            ('enter_username_password', 'Entered Username or Password is wrong', 'hu_hu', 'Hibás a megadott felhasználónév vagy jelszó', 2),
            ('server_issue_occured', 'Server issues occurred', 'hu_hu', 'Szerver problémák történtek', 2),
            ('password', 'Password', 'hu_hu', 'Jelszó', 3),
            ('user_name', 'Username', 'hu_hu', 'Felhasználónév', 3),
            ('reset_pwd', 'Reset Password', 'hu_hu', 'Jelszó visszaállítása', 3),
            ('forgot_password_title', 'Forgot password', 'hu_hu', 'Elfelejtett jelszó', 3),
            ('enter_user_name', 'Enter user name', 'hu_hu', 'Adja meg a felhasználónevet', 3),
            ('cc', 'Cc', 'hu_hu', 'Másolat', 4),
            ('body', 'Body', 'hu_hu', 'Törzs', 4),
            ('bcc', 'BCC', 'hu_hu', 'Titkos másolat', 4),
            ('dialog_title_text_color', 'Select a Text Color', 'hu_hu', 'Válasszon ki egy szövegszínt', 4),
            ('date', 'Date', 'hu_hu', 'Dátum', 4),
            ('subject', 'Subject', 'hu_hu', 'Tárgy', 4),
            ('composeMail', 'Compose Mail', 'hu_hu', 'Levél írása', 4),
            ('send', 'Send', 'hu_hu', 'Küldés', 4),
            ('select_message', 'Select message', 'hu_hu', 'Válassza ki az üzenetet', 4),
            ('title_insert_table', 'Insert Table', 'hu_hu', 'Táblázat beszúrása', 4),
            ('log_file_sms', 'I agree to Share API Log to Technical team for further troubleshooting', 'hu_hu', 'Elfogadom, hogy megosszam az API-naplót a műszaki csapattal további hibaelhárítás céljából', 5),
            ('edit_record', 'Edit Records', 'hu_hu', 'Rekordok szerkesztése', 5),
            ('select_time', 'Select Time', 'hu_hu', 'Válasszon Időt', 5),
            ('edit_item', 'Edit Item', 'hu_hu', 'Elem szerkesztése', 5),
            ('items_total', 'Items Total', 'hu_hu', 'Tételek összesen', 5),
            ('number_less_then_31', 'Number should be less than 31', 'hu_hu', 'A számnak 31-nél kisebbnek kell lennie', 5),
            ('users', 'Users', 'hu_hu', 'Felhasználók', 5),
            ('groups', 'Groups', 'hu_hu', 'Csoportok', 5),
            ('txt_note_for_file', 'Note : Existing attachments(images/files) will be replaced', 'hu_hu', 'Megjegyzés: A meglévő mellékletek (képek/fájlok) lecserélődnek', 5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime', 'hu_hu', 'A Befejezés dátumának nagyobbnak kell lennie, mint a Kezdési dátumnak', 5),
            ('until', 'Until', 'hu_hu', '-ig', 5),
            ('organizations', 'Organizations', 'hu_hu', 'Cégek', 6),
            ('contacts', 'Contacts', 'hu_hu', 'Kapcsolatok', 6),
            ('opportunity', 'Opportunity', 'hu_hu', 'Lehetőségek', 6),
            ('lbl_sun', 'SUN', 'hu_hu', 'VAS', 7),
            ('lbl_mon', 'MON', 'hu_hu', 'HÉT', 7),
            ('lbl_tue', 'TUE', 'hu_hu', 'KEDD', 7),
            ('lbl_wed', 'WED', 'hu_hu', 'SZER', 7),
            ('lbl_thu', 'THU', 'hu_hu', 'CSÜT', 7),
            ('lbl_fri', 'FRI', 'hu_hu', 'PÉN', 7),
            ('lbl_sat', 'SAT', 'hu_hu', 'SZOM', 7),
            ('lbl_1', '1', 'hu_hu', '1', 7),
            ('lbl_2', '2', 'hu_hu', '2', 7),
            ('lbl_3', '3', 'hu_hu', '3', 7),
            ('lbl_4', '4', 'hu_hu', '4', 7),
            ('lbl_5', '5', 'hu_hu', '5', 7),
            ('lbl_6', '6', 'hu_hu', '6', 7),
            ('lbl_7', '7', 'hu_hu', '7', 7),
            ('lbl_8', '8', 'hu_hu', '8', 7),
            ('lbl_9', '9', 'hu_hu', '9', 7),
            ('lbl_10', '10', 'hu_hu', '10', 7),
            ('lbl_11', '11', 'hu_hu', '11', 7),
            ('lbl_12', '12', 'hu_hu', '12', 7),
            ('lbl_13', '13', 'hu_hu', '13', 7),
            ('lbl_14', '14', 'hu_hu', '14', 7),
            ('lbl_15', '15', 'hu_hu', '15', 7),
            ('lbl_16', '16', 'hu_hu', '16', 7),
            ('lbl_17', '17', 'hu_hu', '17', 7),
            ('lbl_18', '18', 'hu_hu', '18', 7),
            ('lbl_19', '19', 'hu_hu', '19', 7),
            ('lbl_20', '20', 'hu_hu', '20', 7),
            ('lbl_21', '21', 'hu_hu', '21', 7),
            ('lbl_22', '22', 'hu_hu', '22', 7),
            ('lbl_23', '23', 'hu_hu', '23', 7),
            ('lbl_24', '24', 'hu_hu', '24', 7),
            ('lbl_25', '25', 'hu_hu', '25', 7),
            ('lbl_26', '26', 'hu_hu', '26', 7),
            ('lbl_27', '27', 'hu_hu', '27', 7),
            ('lbl_28', '28', 'hu_hu', '28', 7),
            ('lbl_29', '29', 'hu_hu', '29', 7),
            ('lbl_30', '30', 'hu_hu', '30', 7),
            ('lbl_31', '31', 'hu_hu', '31', 7),
            ('lbl_32', '32', 'hu_hu', '32', 7),
            ('lbl_33', '33', 'hu_hu', '33', 7),
            ('lbl_34', '34', 'hu_hu', '34', 7),
            ('lbl_35', '35', 'hu_hu', '35', 7),
            ('lbl_36', '36', 'hu_hu', '36', 7),
            ('lbl_37', '37', 'hu_hu', '37', 7),
            ('lbl_38', '38', 'hu_hu', '38', 7),
            ('lbl_39', '39', 'hu_hu', '39', 7),
            ('lbl_40', '40', 'hu_hu', '40', 7),
            ('lbl_41', '41', 'hu_hu', '41', 7),
            ('lbl_42', '42', 'hu_hu', '42', 7),
            ('current_date', 'current date', 'hu_hu', 'aktuális dátum', 7),
            ('event', 'Events', 'hu_hu', 'Események', 7),
            ('calendar', 'Calendar', 'hu_hu', 'Naptár', 7),
            ('latest_version', 'Latest Version :', 'hu_hu', 'Legújabb verzió :', 8),
            ('expire_on', 'Next renewal date : ', 'hu_hu', 'Következő megújítási dátum:', 8),
            ('ctmobile_ext_version', 'CTMobile Ext. Version : ', 'hu_hu', 'Mobil verzió:', 8),
            ('you_have_latest_version', 'You already have latest version', 'hu_hu', 'Már megvan a legújabb verzió', 8),
            ('latest_version1', 'You Already have latest version', 'hu_hu', 'Már rendelkezik a legújabb verzióval', 8),
            ('upgreaded', 'Upgrade', 'hu_hu', 'Upgrade', 8),
            ('downgrade', 'Downgrade', 'hu_hu', 'Downgrade', 8),
            ('dialog_recent_event_info', 'You can set from here how many number of records you want to show on Home screen for Recent Event.', 'hu_hu', 'Itt állíthatja be, hogy hány rekordot szeretne megjeleníteni a Kezdőképernyőn a Legutóbbi eseményhez.', 8),
            ('dialog_feedback_info', 'You can submit your feedback with description , our team will check your feedback and get back to you.', 'hu_hu', 'Visszajelzését leírással együtt küldheti el, csapatunk ellenőrzi visszajelzését, és felveszi Önnel a kapcsolatot.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.', 'hu_hu', 'A naplózási funkciót ügyfélszolgálatra/súgóra használják. Ha bármilyen problémával szembesül az alkalmazásban, vagy bármely modul vagy funkció nem működik megfelelően, akkor engedélyezheti a naplómegosztást fejlesztőcsapatunkkal.', 8),
            ('info', 'Info', 'hu_hu', 'Info', 8),
            ('recent_history', 'Recent History', 'hu_hu', 'Legutóbbi előzmény', 8),
            ('recent_feedback', 'Feedback', 'hu_hu', 'Visszajelzés', 8),
            ('recent_log', 'Log', 'hu_hu', 'Log', 8),
            ('crmtiger_app_version', 'CRMTiger App Version : ', 'hu_hu', 'CRM Verzió : ', 8),
            ('historylimit', 'Recent History Limit', 'hu_hu', 'Legutóbbi előzmény limit', 8),
            ('radious_in_miles', 'Radius in miles', 'hu_hu', 'Sugár mérföldben', 8),
            ('recentlimit', 'Recent Event Limit', 'hu_hu', 'Legutóbbi Esemény limit', 8),
            ('upcoming_events', 'Upcoming Events', 'hu_hu', 'Közelgő események', 8),
            ('rate_our_app', 'Rate Our App!', 'hu_hu', 'Értékelje alkalmazásunkat!', 8),
            ('feedback', 'Submit Feedback', 'hu_hu', 'Visszajelzés küldése', 8),
            ('sendfeedback', 'Feedback Send', 'hu_hu', 'Visszajelzés küldése', 8),
            ('emaillimit', 'Email limit', 'hu_hu', 'Email limit', 8),
            ('log', 'Log', 'hu_hu', 'Log', 8),
            ('logclear', 'Log cleared successfully.', 'hu_hu', 'A napló sikeresen törölve.', 8),
            ('dialog_recent_history_info', 'You can set from here how many number of records you want to show on Home screen for Recent History.', 'hu_hu', 'Itt állíthatja be, hogy hány rekordot szeretne megjeleníteni a Kezdőképernyőn a Legutóbbi előzményekhez.', 8),
            ('proceed_to_upgrade1', 'Proceed to', 'hu_hu', 'Folytassa ', 8),
            ('upgradation_message', 'will required logout and login again later.', 'hu_hu', 'kijelentkezést és későbbi bejelentkezést igényel.', 8),
            ('proceed_to_upgrade', 'Proceed to Upgrade', 'hu_hu', 'Folytassa az Upgrade-del', 8),
            ('module_setting', 'Module Setting', 'hu_hu', 'Modul Beállítások', 9),
            ('sortbyfield', 'Sort by field', 'hu_hu', 'Rendezés mező szerint', 9),
            ('ascending', 'Ascending  A to Z', 'hu_hu', 'Növekvő sorrendben (A-Z)', 9),
            ('descending', 'Descending  Z to A', 'hu_hu', 'Csökkenő sorrendben (A-Z)', 9),
            ('first_field', 'First Field', 'hu_hu', 'Első mező', 9),
            ('second_field', 'Second Field', 'hu_hu', 'Második mező', 9),
            ('third_field', 'Third Field', 'hu_hu', 'Harmadik mező', 9),
            ('sure_want_restore', 'Are you sure you want to reset to default settings?', 'hu_hu', 'Biztosan vissza szeretné állítani az alapértelmezett beállításokat?', 9),
            ('orderlist', 'List Order', 'hu_hu', 'Lista sorrend', 9),
            ('module_reset', 'Restore to Default', 'hu_hu', 'Visszaállítás alapértelmezettre', 9),
            ('display_fields', 'Display Fields', 'hu_hu', 'Megjelenítési mezők', 9),
            ('discount_lessthen_100', 'Discount % should be less than 100', 'hu_hu', 'A kedvezmény százalékának 100-nál kisebbnek kell lennie', 10),
            ('select_item', 'Select Item', 'hu_hu', 'Tétel kiválasztása', 10),
            ('item_comment', 'Item Comment', 'hu_hu', 'Tétel megjegyzés', 10),
            ('record_name', 'Record Name is :', 'hu_hu', 'A rekord neve:', 11),
            ('go_back', 'Go Back', 'hu_hu', 'Vissza', 11),
            ('please_enter_shortcut_name', 'Please Enter Shortcut Name', 'hu_hu', 'Kérjük, adja meg a parancsikon nevét', 11),
            ('number_not_found', 'Contact Number not found', 'hu_hu', 'A kapcsolattartó szám nem található', 11),
            ('mail_not_found', 'Mail Address not found', 'hu_hu', 'Az e-mail cím nem található', 11),
            ('create_shortcut', 'Create Shortcut', 'hu_hu', 'Parancsikon létrehozása', 11),
            ('contact_summary', 'Summary', 'hu_hu', 'Összegzés', 11),
            ('activites', 'Activities', 'hu_hu', 'Tevékenységek', 11),
            ('details', 'Details', 'hu_hu', 'Részletek', 11),
            ('related', 'Related', 'hu_hu', 'Kapcsolódóan', 11),
            ('share_link', 'Share record with', 'hu_hu', 'Rekord megosztása ', 11),
            ('edit', 'Edit', 'hu_hu', 'Szerkesztés', 11),
            ('duplicate', 'Duplicate', 'hu_hu', 'Megkettőz', 11),
            ('whatsapp', 'Whatsapp', 'hu_hu', 'Whatsapp', 11),
            ('call', 'Call', 'hu_hu', 'Hívás', 11),
            ('choose_contact_for_call', 'Choose Contact for Call', 'hu_hu', 'Válassza a Kapcsolatfelvétel lehetőséget a híváshoz', 11),
            ('choose_contact_for_sms', 'Choose Contact for SMS', 'hu_hu', 'Válassza a Kapcsolatfelvétel lehetőséget az SMS-hez', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp', 'hu_hu', 'Válassza a Kapcsolatfelvétel lehetőséget a WhatsApp-hoz', 11),
            ('chosse_contact_for_email', 'Choose Email', 'hu_hu', 'Válasszon Emailt', 11),
            ('attach_file', 'Attach Files', 'hu_hu', 'Fájlok csatolása', 11),
            ('close', 'Close', 'hu_hu', 'Bezárás', 11),
            ('status', 'Status', 'hu_hu', 'Állapot', 11),
            ('stop', 'Stop', 'hu_hu', 'Stop', 11),
            ('zero', '0', 'hu_hu', '0', 11),
            ('record', 'Record', 'hu_hu', 'Felvétel', 11),
            ('voice_note', 'Voice Note', 'hu_hu', 'Hangjegyzet', 11),
            ('tickets', 'Tickets', 'hu_hu', 'Kérések', 12),
            ('check_out', 'Check Out', 'hu_hu', 'Kijelentkezés', 12),
            ('check_in', 'Check In', 'hu_hu', 'Bejelentkezés', 12),
            ('select_any', 'Select any', 'hu_hu', 'Válassza ki bármelyiket', 12),
            ('fulldetails', 'Show Full Details', 'hu_hu', 'Teljes részletek megjelenítése', 12),
            ('checkin', 'Check-in', 'hu_hu', 'Bejelentkezés', 12),
            ('navigate', 'Navigate', 'hu_hu', 'Navigál', 12),
            ('product', 'Products', 'hu_hu', 'Termékek', 12),
            ('projectMilestone', 'Project Milestone', 'hu_hu', 'Project Milestone', 12),
            ('projecttask', 'Project Tasks', 'hu_hu', 'Projektfeladatok', 12),
            ('nearby', 'NearBy', 'hu_hu', 'Közeli', 13),
            ('document', 'Document', 'hu_hu', 'Dokumentum', 14),
            ('reply', 'Reply', 'hu_hu', 'Válasz', 14),
            ('reply_all', 'Reply All', 'hu_hu', 'Válasz mindenkinek', 14),
            ('forward', 'Forward', 'hu_hu', 'Előre', 14),
            ('action', 'Action', 'hu_hu', 'Művelet', 14),
            ('select_first', 'Select First', 'hu_hu', 'Válasszon először', 14),
            ('commentaddsuccessful', 'Comment added successfull', 'hu_hu', 'A megjegyzés sikeresen hozzáadva', 14),
            ('move_to', 'Move to', 'hu_hu', 'Mozgatás', 14),
            ('attach', 'Attach', 'hu_hu', 'Csatol', 14),
            ('addcoment', 'Add Comment', 'hu_hu', 'Megjegyzés hozzáadása', 14),
            ('adddocument', 'Add Document', 'hu_hu', 'Dokumentum hozzáadása', 14),
            ('home', 'Home', 'hu_hu', 'Főoldal', 15),
            ('checkout', 'Check-out', 'hu_hu', 'Kijelentkezés', 15),
            ('message_search', 'Search by name', 'hu_hu', 'Keresés név szerint', 15),
            ('start_shift', 'Start shift', 'hu_hu', 'Műszak kezdése', 15),
            ('end_shift', 'End shift', 'hu_hu', 'Műszak vége', 15),
            ('today_meeting', 'Meetings', 'hu_hu', 'Találkozók', 15),
            ('shift_time_track', 'Shift Time Track', 'hu_hu', 'Műszak Időnyilvántartás', 15),
            ('logout_msg', 'You have to login again , click', 'hu_hu', 'Újra be kell jelentkeznie, kattintson', 15),
            ('logout_msg1', 'to continue.', 'hu_hu', 'folytatni', 15),
            ('permission_denied', 'You don\'t have permission to create', 'hu_hu', 'Nincs engedélye a létrehozásra', 15),
            ('history', 'Activity stream', 'hu_hu', 'Tevékenység adatfolyam', 15),
            ('search_value', 'Search value :', 'hu_hu', 'Keresési érték:', 15),
            ('feed_back_msg', 'Please enter feedback message', 'hu_hu', 'Kérjük, írja be a visszajelzését.', 16),
            ('feed_back_hint_msg', 'Enter feedback message', 'hu_hu', 'Kérjük, írja be a visszajelzését.', 16),
            ('submit', 'Submit', 'hu_hu', 'Megerősít', 16),
            ('check_app_not_installed', 'Application is not currently installed.', 'hu_hu', 'Az alkalmazás jelenleg nincs telepítve.', 17),
            ('send_sms_fail_message', 'SMS failed, please try again later!', 'hu_hu', 'Az SMS elküldése nem sikerült, próbálja újra később!', 17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'hu_hu', 'A dokumentum csatolása sikeres volt', 17),
            ('send_message', 'Send message', 'hu_hu', 'Üzenet küldése', 17),
            ('sms_to', 'smsto:', 'hu_hu', 'SMS címzett', 17),
            ('add_list_message', 'Add List', 'hu_hu', 'Lista hozzáadása', 18),
            ('mylist', 'My List', 'hu_hu', 'Listám', 18),
            ('filtername', 'Filter Name', 'hu_hu', 'Szűrő neve', 18),
            ('selectlist', 'Select a List', 'hu_hu', 'Lista kiválasztása', 18),
            ('assingedto', 'Assigned To', 'hu_hu', 'Hozzárendelve', 18),
            ('selectmodule', 'Select a module', 'hu_hu', 'Modul kiválasztása', 18),
            ('add_list', 'Add Filter', 'hu_hu', 'Szűrő hozzáadása', 18),
            ('recent_event', 'Recent Event', 'hu_hu', 'Legutóbbi esemény', 19),
            ('recent_hostory', 'Recent History', 'hu_hu', 'Legutóbbi előzmény', 19),
            ('module_specific_settings', 'Module-Specific Settings', 'hu_hu', 'Modul-specifikus beállítások', 19),
            ('talk_to_us', 'Talk to us', 'hu_hu', 'Beszéljen velünk', 19),
            ('report_a_bug', 'Report A Bug', 'hu_hu', 'Hiba bejelentése', 19),
            ('faq', 'FAQ', 'hu_hu', 'GyIK', 19),
            ('selectmodules', 'Select Module', 'hu_hu', 'Modul kiválasztása', 19),
            ('myplan', 'My Plan', 'hu_hu', 'Tervem', 19),
            ('message', 'Message', 'hu_hu', 'Üzenet', 20),
            ('message_validation', 'Please enter Message', 'hu_hu', 'Kérjük, írja be az üzenetet', 20),
            ('contact_select', 'Please Select contact', 'hu_hu', 'Kérjük, válasszon kapcsolatot', 20),
            ('global_search', 'Global Search', 'hu_hu', 'Globális keresés', 21),
            ('records', 'Records', 'hu_hu', 'Rekordok', 21),
            ('dont_show_again', 'Don\'t Show Again', 'hu_hu', 'Ne mutasd újra', 22),
            ('skip', 'Skip', 'hu_hu', 'Átugrás', 22),
            ('file_downloading', 'File Downloading', 'hu_hu', 'Fájl letöltése', 23),
            ('add_screenshots_optional', 'Add screenshots (optional)', 'hu_hu', 'Képernyőképek hozzáadása (opcionális)', 24),
            ('describe_your_problem', 'Describe your problem', 'hu_hu', 'Írja le a problémáját', 24),
            ('default_filter_shortcut', 'Default Filter Shortcut', 'hu_hu', 'Alapértelmezett szűrő parancsikon', 25),
            ('record_shortcut', 'Record Shortcut', 'hu_hu', 'Parancsikon rögzítése', 25),
            ('enter_url', 'Please Enter url', 'hu_hu', 'Kérjük, adja meg az url-t', 26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'hu_hu', 'A használat folytatásához frissítenie kell az alkalmazást. Frissítse a folytatáshoz. A régebbi verziók mától nem működnek', 26),
            ('search_by', 'Search by', 'hu_hu', 'Keresés a következő szerint', 27),
            ('selected_filter', 'Selected filter :', 'hu_hu', 'Kiválasztott szűrő:', 27),
            ('selected_field', 'Selected field :', 'hu_hu', 'Kiválasztott mező:', 27),
            ('choose', 'Choose', 'hu_hu', 'Kiválaszt', 28),
            ('qr_cardscanner', 'QR Code Scanner', 'hu_hu', 'QR Code Scanner', 28),
            ('error_message_for_scan', 'Could not read the card Try again later.', 'hu_hu', 'Nem sikerült beolvasni a kártyát. Próbálja újra később.', 28),
            ('press_start_scan', 'Press to Start Scan', 'hu_hu', 'Nyomja meg a szkennelés elindításához', 28),
            ('line_item_quntity_validation_msg', 'Value should be greater than zero', 'hu_hu', 'Az értéknek nagyobbnak kell lennie nullánál', 29),
            ('percentage_msg', 'Percentage should be less than 100', 'hu_hu', 'A százaléknak 100-nál kisebbnek kell lennie', 29),
            ('MSG_NO_DATA', 'No data found!', 'hu_hu', 'Nem található adat!', 29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!', 'hu_hu', 'Valami elromlott!', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'hu_hu', 'Hamarosan!', 29),
            ('MSG_UPLOAD_PROFILE_IMAGE', 'Please upload profile image.', 'hu_hu', 'Kérjük, töltsön fel profilképet.', 29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access', 'hu_hu', 'Helyhozzáférés', 29),
            ('ALERT_MSG_LOCATION_ACCESS', 'Requires your location to show nearby events.', 'hu_hu', 'A közeli események megjelenítéséhez a tartózkodási hely szükséges.', 29),
            ('ALERT_BTN_ALLOW', 'ALLOW', 'hu_hu', 'ENGEDÉLYEZ', 29),
            ('ALERT_BTN_DENY', 'DENY', 'hu_hu', 'ELUTASÍT', 29),
            ('ALERT_MSG_LOCATION_SETTING', 'Not able to fetch your current location. Please allow us to use your location to provide you certain features like, live tracking, route planning and display near by leads, contact, organization, etc. This will help you to plan your on field task as well', 'hu_hu', 'Nem sikerült lekérni a jelenlegi tartózkodási helyét. Kérjük, engedje meg nekünk, hogy felhasználjuk a tartózkodási helyét bizonyos funkciók nyújtásához, például élő követéshez, útvonaltervezéshez, valamint közeli vevőjelöltek, kapcsolatok, szervezetek stb. megjelenítéséhez. Ez segíteni fog az Ön számára a tervezésben az üzleti feladatok területén is.', 29),
            ('DELETE_RECORD', 'Delete Record', 'hu_hu', 'Rekord törlése', 29),
            ('ALERT_MSG_DELETE_SHORTCUT', 'Are you sure want to delete this shortcut?', 'hu_hu', 'Biztosan törli ezt a parancsikont?', 29),
            ('DELETE_SHORTCUT', 'Delete Shortcut', 'hu_hu', 'Parancsikon törlése', 29),
            ('LBL_TERMS', 'By logging in, you agree to our Terms and', 'hu_hu', 'A bejelentkezéssel Ön elfogadja Feltételeinket és', 29),
            ('LBL_CONDITIONS', 'Conditions &', 'hu_hu', 'Feltételek és', 29),
            ('ALERT_TITLE', 'Alert', 'hu_hu', 'Riasztás', 29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe', 'hu_hu', 'Feliratkozás', 29),
            ('MSG_SELECT_MODULE', 'Please select any Module', 'hu_hu', 'Kérjük, válasszon bármilyen modult', 29),
            ('MSG_SELECT_LIST', 'Please select any List', 'hu_hu', 'Kérjük, válasszon egy listát', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA', 'You don\'t have camera', 'hu_hu', 'Nincsen kamerája', 29),
            ('ALERT_MSG_GALLARY_PERMISSION', 'You don\'t have permission to access gallery.', 'hu_hu', 'Nincs engedélye a galéria elérésére.', 29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'hu_hu', 'Nincs engedélye a kamera elérésére. Lépjen a beállításokhoz -&gt; Görgessen le, és válassza a CRMTiger App -&gt; Turn Camera on lehetőséget', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'hu_hu', 'Nincs engedélye a Beszédfelismerés elérésére. Menjen a beállításokhoz -&gt; Görgessen le, és válassza a CRMTiger alkalmazást -&gt; Beszédfelismerés bekapcsolása', 29),
            ('BTN_DONE', 'Done', 'hu_hu', 'Kész', 29),
            ('COMMENT', 'Comment', 'hu_hu', 'Megjegyzés', 29),
            ('FULL_FORM', 'Full Form', 'hu_hu', 'Teljes űrlap', 29),
            ('QUICK_CREATE', 'Create', 'hu_hu', 'Létrehoz', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'hu_hu', 'Válasszon mezőket', 29),
            ('LBL_SELECT_FIELDS', 'Select Fields', 'hu_hu', 'Válasszon mezőket', 29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field', 'hu_hu', 'Válassza ki az első mezőt', 29),
            ('LBL_SELECT_SECOND_FIELDS', 'Select Second Field', 'hu_hu', 'Válassza ki a második mezőt', 29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field', 'hu_hu', 'Válassza ki a harmadik mezőt', 29),
            ('LBL_SORT_BY_FIELD', 'Select Sort By Field', 'hu_hu', 'Válasszon rendezési mezőt', 29),
            ('BTN_RESET_TO_DEFAULT', 'Reset to Default', 'hu_hu', 'Visszaállítás alapértelmezettre', 29),
            ('MSG_SELECT_SORT_BY_FIELD', 'Select Sort by field', 'hu_hu', 'Válassza a Rendezés mező szerint lehetőséget', 29),
            ('kStrClearBtnTitle', 'Clear', 'hu_hu', 'Törlés', 29),
            ('kStrShowMoreBtnTitle', 'Show More', 'hu_hu', 'Mutass többet', 29),
            ('kStrAddActivitiesBtnTitle', 'Add Activities', 'hu_hu', 'Tevékenység hozzáadása', 29),
            ('kStrAddCommentPlaceHolder', 'Add your comments here', 'hu_hu', 'Írja ide megjegyzéseit', 29),
            ('MSG_ENTER_TO_EMAIL', 'Please enter to field.', 'hu_hu', 'Kérjük, írja be a mezőbe.', 29),
            ('WARNING_FILE', 'File can\'t open.', 'hu_hu', 'A fájl nem nyitható meg.', 29),
            ('MSG_FILE_SAVED', 'File saved.', 'hu_hu', 'A fájl mentve.', 29),
            ('WARNING_DOWNLOAD_FAIL', 'Download fail!, please try after sometime.', 'hu_hu', 'A letöltés sikertelen, próbálja meg később', 29),
            ('LBL_SHORTCUT', 'Shortcut', 'hu_hu', 'Parancsikon', 29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'hu_hu', 'Írja be az Üzenetet', 29),
            ('ALERT_INSTALL_WHATSAPP', 'Install Whatsapp', 'hu_hu', 'Telepítse a Whatsappot', 29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox', 'hu_hu', 'Nem található postafiók. Kérjük, hozzon létre postafiókot', 29),
            ('LBL_WROTE', 'Wrote', 'hu_hu', 'Írt', 29),
            ('MSG_MAIL_SEND', 'Mail sent', 'hu_hu', 'Levél elküldve', 29),
            ('log_file_not_found', 'API Log file not found.', 'hu_hu', 'API naplófájl nem található.', 29),
            ('unknown_error', 'An unknown error occurred, try again', 'hu_hu', 'Ismeretlen hiba történt, próbálja újra', 29),
            ('CTMTigerAppVersion', 'CRMTiger App Version', 'hu_hu', 'SOMACRM App Verzió', 29),
            ('CTMMobileUpdateMsg', 'CTMobile Ext. Version Update Successfully', 'hu_hu', 'Sikeres CRM verziófrissítés', 29),
            ('dialog_Premium_downgrade', 'Downgrade will required logout and login again later', 'hu_hu', 'A Downgrade-hez ki kell jelentkezni, majd később újra be kell jelentkezni', 29),
            ('dialog_Premium', 'Upgrade will required logout and login again later', 'hu_hu', 'Az Upgrade-hez ki kell jelentkezni, majd később újra be kell jelentkezni', 29),
            ('Overwrite', 'Overwrite', 'hu_hu', 'Felülír', 29),
            ('MSGAddressOverwrite1', 'Overwrite the existing address with the selected', 'hu_hu', 'Írja felül a meglévő címet a kiválasztottal', 29),
            ('MSGAddressOverwrite2', 'address details?', 'hu_hu', 'Címadatok?', 29),
            ('UPGRADE_PLAN', 'Upgrade Plan', 'hu_hu', 'Upgrade Plan', 29),
            ('DOWNGRADE_PLAN', 'Downgrade Plan', 'hu_hu', 'Downgrade Plan', 29),
            ('UPGRADE_EXTENSION', 'Upgrade Extension', 'hu_hu', 'Upgrade Bővítmény', 29),
            ('UPGRADE_APP', 'Upgrade App', 'hu_hu', 'Upgrade App', 29),
            ('SELECT_OPTION', 'Select Option', 'hu_hu', 'Válasszon lehetőséget', 29),
            ('PLEASE_SELECT', 'Please select', 'hu_hu', 'Kérjük válasszon', 29),
            ('MSG_ACCESS_DENIED', 'You don\'t have permission for this module.', 'hu_hu', 'Nincs engedélye ehhez a modulhoz.', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY', 'Please select reccuring day of month.', 'hu_hu', 'Kérjük, válassza ki a hónap ismétlődő napját.', 29),
            ('MSG_SELECT_RECCURING_WEEK_DAY', 'Please select reccuring day of week.', 'hu_hu', 'Kérjük, válassza ki a hét ismétlődő napját.', 29),
            ('MSG_SELECT_RECCURING_DAYS', 'Please select reccuring days.', 'hu_hu', 'Kérjük, válasszon ismétlődő napokat.', 29),
            ('Please select reccuring days.', 'Please select reccuring days.', 'hu_hu', 'Kérjük, válasszon ismétlődő napokat.', 29),
            ('MSG_SELECT_RECCURING_END_DATE', 'Please select reccuring end date.', 'hu_hu', 'Kérjük, válasszon ismétlődő befejezési dátumot.', 29),
            ('MSG_SELECT_RECCURING_TYPE', 'Please select reccuring type.', 'hu_hu', 'Kérjük, válassza ki az ismétlődő típust.', 29),
            ('FREQ_TIME', 'Times', 'hu_hu', 'Időpontok', 29),
            ('REPEAT_YEARLY', 'Repeat Yearly', 'hu_hu', 'Ismételje meg évente', 29),
            ('REPEAT_MONTHLY', 'Repeat Monthly', 'hu_hu', 'Ismételje meg havonta', 29),
            ('REPEAT_WEEKLY', 'Repeat Weekly', 'hu_hu', 'Ismételje meg hetente', 29),
            ('REPEAT_DAILY', 'Repeat Daily', 'hu_hu', 'Ismételje meg naponta', 29),
            ('ACTION_TITLE', 'Action Title', 'hu_hu', 'Művelet címe', 29),
            ('MSG_SELECT_VALID_DATE', 'Please select valid day of month.', 'hu_hu', 'Kérjük, válassza ki a hónap érvényes napját.', 29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'hu_hu', 'A kezdés dátuma legyen kisebb, mint a befejezés dátuma.', 29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'hu_hu', 'A kezdési időpontnak kisebbnek kell lennie, mint a befejezési időpontnak.', 29),
            ('LBL_LINEITEM_DETAILS', 'Lineitem Details', 'hu_hu', 'Elem részletei', 29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT', 'Discount amount should be less than the total.', 'hu_hu', 'A kedvezmény összege kevesebb kell legyen, mint a teljes összeg.', 29),
            ('VIEW', 'View', 'hu_hu', 'Nézet', 29),
            ('MSG_ENTER_VALID', 'Please enter valid', 'hu_hu', 'Kérlek, adj meg érvényes ', 29),
            ('MSG_ENTER_PERCENTAGE', 'Percentage should be less than 100.', 'hu_hu', 'A százalék értéke nem lehet 100-nál nagyobb.', 29),
            ('ITEM_TOTAL', 'Item Total', 'hu_hu', 'Tétel összesen', 29),
            ('ADJUSTMENT', 'Adjustment', 'hu_hu', 'Beállítás', 29),
            ('TITLE_CHOOSE_IMAGE', 'Choose Image', 'hu_hu', 'Válasszon képet', 29),
            ('COMPRESS', 'Compress', 'hu_hu', 'Csökkent', 29),
            ('CHOOSE_ANOTHER_IMAGE', 'Your image size is too large, please select another image', 'hu_hu', 'A kép mérete túl nagy, válasszon másik képet', 29),
            ('OnDayOfMonth', 'On day of month', 'hu_hu', 'Adott hónap napon', 29),
            ('OnDayOfWeek', 'On day of week', 'hu_hu', 'A hét egy adott napján', 29),
            ('AddAndClose', 'Add & Close', 'hu_hu', 'Hozzáad és Bezár', 29),
            ('Repeat', 'Repeat', 'hu_hu', 'Ismétlés', 29),
            ('OnDay', 'On day', 'hu_hu', 'Azon a napon', 29),
            ('View_Line_Item', 'View Line Item', 'hu_hu', 'Sor megtekintése', 29),
            ('TITLE_IMAGE', 'Image', 'hu_hu', 'Kép', 29),
            ('TITLE_ICLOUD', 'iCloud', 'hu_hu', 'iCloud', 29),
            ('GOOGLE', 'Google', 'hu_hu', 'Google', 29),
            ('ALERT_BTN_OKAY', 'Okay', 'hu_hu', 'Rendben', 29),
            ('ALERT_TITLE_ACCESS_DENIED', 'Access Denied', 'hu_hu', 'Hozzáférés megtagadva', 29),
            ('Dont_Show_Again', 'Don\'t show again', 'hu_hu', 'Ne mutasd újra', 29),
            ('Skip', 'Skip', 'hu_hu', 'Átugrás', 29),
            ('Fillter_Name', 'Fillter Name', 'hu_hu', 'Szűrő neve', 29),
            ('Fillter_Record_Count', 'Fillter Record Count', 'hu_hu', 'Szűrő rekordok száma', 29),
            ('url_note', 'Note : if your URL of CRM is https://example.com/crm enter that into above box', 'hu_hu', 'Megjegyzés: ha a CRM URL-je https://example.com/crm, írja be a fenti mezőbe', 31),
            ('vtiger_url', 'Your vTiger CRM URL', 'hu_hu', 'Az Ön SOMACRM URL-je', 31),
            ('msg_doc_read_permission', 'You don\'t have permission to Add either This is read-only or Private Field.', 'hu_hu', 'Nincs engedélyed az \"Hozzáadásra\", mert ez a mező csak olvasható vagy privát.', 31),
            ('CLEAR', 'Clear', 'hu_hu', 'Törlés', 31),
            ('Files/photos uploaded successfully', 'Files/photos uploaded successfully', 'hu_hu', 'A fájlok/fotók sikeresen feltöltve', 32),
            ('Digital signature saved', 'Digital signature saved', 'hu_hu', 'A digitális aláírás mentve', 32),
            ('Please upload Signature or Files/photos', 'Please upload Signature or Files/photos', 'hu_hu', 'Kérjük, töltsön fel aláírást vagy fájlokat/fotókat', 32),
            ('Files / Photos', 'Files / Photos', 'hu_hu', 'Fájlok / Fényképek', 32),
            ('Signature', 'Signature', 'hu_hu', 'Aláírás', 32),
            ('add_photo_using', 'Add Photo Using', 'hu_hu', 'Fénykép hozzáadása használatával', 31),
            ('btn_upload_sign', '(+) Add Signature', 'hu_hu', '(+) Aláírás hozzáadása', 31),
            ('btn_upload_photo_doc', '(+) Upload Files/Photos', 'hu_hu', '(+) Fájlok/fotók hozzáadása', 31),
            ('select_photo_doc_to_upload', 'Please select files/photos to upload', 'hu_hu', 'Kérjük, válassza ki a feltöltendő fájlokat/fotókat', 31),
            ('related_module_title', 'Search from related module and Add to \"Route\"', 'hu_hu', 'Keresés a kapcsolódó modulból és Hozzáadás az \"Útvonalhoz\"', 30),
            ('Route status updated successfully', 'Route status updated successfully', 'hu_hu', 'Az útvonal állapota sikeresen frissítve', 32),
            ('Session init failed', 'Session init failed', 'hu_hu', 'A munkamenet indítása nem sikerült', 32),
            ('You don\'t have permission to access this resource', 'You don\'t have permission to access this resource', 'hu_hu', 'Nincs engedélye az erőforrás elérésére', 32),
            ('ctroute_realtedto cannot be empty', 'Could not get the Related To - Try again later', 'hu_hu', 'Nem sikerült letölteni a Kapcsolódó címet – Próbálja újra később', 32),
            ('ctroute_planning cannot be empty', 'Could not get the Route Planning Record - Try again later', 'hu_hu', 'Nem sikerült lekérni az útvonaltervezési rekordot – Próbálja újra később', 32),
            ('Something went wrong - Try again later', 'Something went wrong - Try again later', 'hu_hu', 'Hiba történt – Próbálja újra később', 32),
            ('sequence updated successfully', 'sequence updated successfully', 'hu_hu', 'Sorrend sikeresen frissítve.', 32),
            ('sequence cannot be empty', 'sequence cannot be empty', 'hu_hu', 'A sorrend nem lehet üres', 32),
            ('Shortcut details not saved', 'Shortcut details not saved', 'hu_hu', 'A parancsikon részletei nem lettek mentve', 32),
            ('Shortcut details saved successfully', 'Shortcut details saved successfully', 'hu_hu', 'A parancsikon részletei sikeresen mentve', 32),
            ('Route save successfully', 'Route save successfully', 'hu_hu', 'Az útvonal mentése sikeres volt', 32),
            ('Record save successfully', 'Record save successfully', 'hu_hu', 'A rögzítés sikeresen mentve', 32),
            ('No dependency found for picklist', 'No dependency found for picklist', 'hu_hu', 'Nem található függőség a kiválasztási listához', 32),
            ('No records found', 'No records found', 'hu_hu', 'Nincs találat', 32),
            ('Outgoing server is not enabled, please configure from CRM', 'Outgoing server is not enabled, please configure from CRM', 'hu_hu', 'A kimenő szerver nincs engedélyezve, kérjük, konfigurálja a CRM-ből', 32),
            ('Removed Successfully', 'Removed Successfully', 'hu_hu', 'Sikeresen eltávolítva', 32),
            ('Shortcut has been deleted', 'Shortcut has been deleted', 'hu_hu', 'A parancsikon törölve lett', 32),
            ('relation of records removed successfully', 'relation of records removed successfully', 'hu_hu', 'a rekordok kapcsolata sikeresen eltávolítva', 32),
            ('relation of records not removed', 'relation of records not removed', 'hu_hu', 'az el nem távolított rekordok kapcsolata', 32),
            ('Record has been deleted successfully', 'Record has been deleted successfully', 'hu_hu', 'A rekord sikeresen törölve', 32),
            ('Time Tracking saved successfully', 'Time Tracking saved successfully', 'hu_hu', 'Az időkövetés sikeresen elmentve', 32),
            ('Time Tracking updated successfully', 'Time Tracking updated successfully', 'hu_hu', 'Az időkövetés sikeresen frissítve', 32),
            ('Time Tracking ended successfully', 'Time Tracking ended successfully', 'hu_hu', 'Az időkövetés sikeresen befejeződött', 32),
            ('Time Tracking started successfully', 'Time Tracking started successfully', 'hu_hu', 'Az időkövetés sikeresen elindult', 32),
            ('record cannot be empty', 'record cannot be empty', 'hu_hu', 'a rekord nem lehet üres', 32),
            ('Module is disabled', 'Module is disabled', 'hu_hu', 'A modul le van tiltva', 32),
            ('Shift ended successfully', 'Shift ended successfully', 'hu_hu', 'A műszak sikeresen befejeződött', 32),
            ('Shift started successfully', 'Shift started successfully', 'hu_hu', 'A műszak sikeresen elindult', 32),
            ('relation of records added successfully', 'relation of records added successfully', 'hu_hu', 'sikeresen hozzáadott rekordok kapcsolata', 32),
            ('Comment saved successfully', 'Comment saved successfully', 'hu_hu', 'A megjegyzés sikeresen mentve', 32),
            ('Comment not saved', 'Comment not saved', 'hu_hu', 'A megjegyzés nincs mentve', 32),
            ('Comment module is not active', 'Comment module is not active', 'hu_hu', 'A megjegyzés modul nem aktív', 32),
            ('No Upcoming Event', 'No Upcoming Event', 'hu_hu', 'Nincs közelgő esemény', 32),
            ('No Templates found - create it from Message Templates module', 'No Templates found - create it from Message Templates module', 'hu_hu', 'Nem található sablon – hozza létre az Üzenetsablonok modulból', 32),
            ('No event or task for this date', 'No event or task for this date', 'hu_hu', 'Nincs esemény vagy feladat erre a dátumra', 32),
            ('No filters created', 'No filters created', 'hu_hu', 'Nincsenek szűrők létrehozva', 32),
            ('Select at least one record to attach', 'Select at least one record to attach', 'hu_hu', 'Válasszon ki legalább egy rekordot a csatoláshoz', 32),
            ('Please select one or more attachments', 'Please select one or more attachments', 'hu_hu', 'Kérjük, válasszon egy vagy több mellékletet', 32),
            ('No event for this month', 'No event for this month', 'hu_hu', 'Ebben a hónapban nincs esemény', 32),
            ('No Activity found', 'No Activity found', 'hu_hu', 'Nem található tevékenység', 32),
            ('Your feedback is valuable for us - it cannot be empty', 'Your feedback is valuable for us - it cannot be empty', 'hu_hu', 'Visszajelzése értékes számunkra – nem lehet üres', 32),
            ('Could not send mail, Please try later', 'Could not send mail, Please try later', 'hu_hu', 'Nem sikerült e-mailt küldeni. Próbálkozzon később', 32),
            ('Latest Version updated successfully', 'Latest Version updated successfully', 'hu_hu', 'A legújabb verzió sikeresen frissítve', 32),
            ('User Location Updated Successfully', 'User Location Updated Successfully', 'hu_hu', 'Felhasználói hely sikeresen frissítve', 32),
            ('User Location not Updated Successfully', 'User Location not Updated Successfully', 'hu_hu', 'A felhasználó helyének frissítése nem sikerült', 32),
            ('SMSNotifier is not enable in CRM. Please enable it first', 'SMSNotifier is not enable in CRM. Please enable it first', 'hu_hu', 'Az SMSNotifier nincs engedélyezve a CRM-ben. Kérjük, először engedélyezze', 32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later', 'hu_hu', 'Nem sikerült elküldeni visszajelzését – Kérjük, próbálja újra később', 32),
            ('Thank you for submitting your feedback', 'Thank you for submitting your feedback', 'hu_hu', 'Köszönjük visszajelzését', 32),
            ('Please upload User Image', 'Please upload User Image', 'hu_hu', 'Kérjük, töltse fel a felhasználói képet', 32),
            ('Image Not Uploading, please try again', 'Image Not Uploading, please try again', 'hu_hu', 'A kép nem töltődik fel, próbáld újra', 32),
            ('User Image Uploaded Successfully', 'User Image Uploaded Successfully', 'hu_hu', 'Felhasználói kép sikeresen feltöltve', 32),
            ('Invalid Module name', 'Invalid Module name', 'hu_hu', 'Érvénytelen modulnév', 32),
            ('Records Sync Successfully', 'Records Sync Successfully', 'hu_hu', 'A rekordok szinkronizálása sikeresen megtörtént', 32),
            ('Values cannot be empty', 'Values cannot be empty', 'hu_hu', 'Az értékek nem lehetnek üresek', 32),
            ('Record id is empty', 'Record id is empty', 'hu_hu', 'A rekordazonosító üres', 32),
            ('Logout Successfully', 'Logout Successfully', 'hu_hu', 'Sikeres kijelentkezés', 32),
            ('Please Enable CTMobile Module', 'Please Enable CTMobile Module', 'hu_hu', 'Kérjük, engedélyezze a CTMobile modult', 32),
            ('Authentication Failed', 'Username and Password do not match', 'hu_hu', 'A felhasználónév és a jelszó nem egyezik', 32),
            ('Mismatched module information', 'Something gone wrong, please try again later', 'hu_hu', 'Hiba történt. Kérjük, próbálja újra később', 32),
            ('Field does not exists', 'Please set display fields again', 'hu_hu', 'Állítsa be újra a megjelenítési mezőket', 32),
            ('Module does not exists', 'Module does not exists or disabled by admin', 'hu_hu', 'A modul nem létezik, vagy az adminisztrátor letiltotta', 32),
            ('Month cannot be empty', 'Could not get the Month - Try again later', 'hu_hu', 'Nem sikerült lekérni a hónapot – Próbálja újra később', 32),
            ('Year cannot be empty', 'Could not get the Year - Try again later', 'hu_hu', 'Nem sikerült lekérni az évet– Próbálja újra később', 32),
            ('Date cannot be empty', 'Could not get the Date - Try again later', 'hu_hu', 'Nem sikerült lekérni a dátumot– Próbálja újra később', 32),
            ('Userid cannot be empty', 'Could not get the Userid - Try again later', 'hu_hu', 'Felhasználó azonosítójának lekérése sikertelen - Próbálja újra később', 32),
            ('End Date cannot be empty', 'Could not get the status - Try again later', 'hu_hu', 'Nem sikerült lekérni az állapotot – Próbálja újra később', 32),
            ('Start Date cannot be empty', 'Could not get the Start Date - Try again later', 'hu_hu', 'Nem sikerült lekérni a kezdő dátumot– Próbálja újra később', 32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'hu_hu', 'A CRM-ben nem konfiguráltad az SMS értesítést. Kérlek, konfiguráld az SMS értesítést a CRM-ben annak érdekében, hogy használni tudd ezt a funkciót.', 32),
            ('Longitude cannot be empty', 'Could not get location-Please try again', 'hu_hu', 'Nem sikerült lekérni a tartózkodási helyet. Kérlek, próbáld újra', 32),
            ('Latitude cannot be empty', 'Could not get location-Please try again', 'hu_hu', 'Nem sikerült lekérni a tartózkodási helyet. Kérlek, próbáld újra', 32),
            ('User cannot be empty', 'Could not get the User - Try again later', 'hu_hu', 'Nem sikerült lekérni a Felhasználót – Próbálja újra később', 32),
            ('Status cannot be empty', 'Could not get the status - Try again later', 'hu_hu', 'Nem sikerült lekérni az állapotot – Próbálja újra később', 32),
            ('Required fields not found', 'Required fields not found', 'hu_hu', 'A kötelező mezők nem találhatók', 32),
            ('Tracking module not active', 'Tracking module not active-Please contact CRM Admin', 'hu_hu', 'A nyomkövető modul nem aktív – Lépjen kapcsolatba a CRM-adminisztrátorral', 32),
            ('Missing mandatory input values', 'Missing mandatory input values', 'hu_hu', 'Hiányoznak a kötelező bemeneti értékek', 32),
            ('No MailBox found. Please Create Mailbox', 'No MailBox found. Please Create Mailbox', 'hu_hu', 'Nem található postafiók. Kérjük, hozzon létre postafiókot', 32),
            ('Mail not sent', 'Mail not sent', 'hu_hu', 'A levél nincs elküldve', 32),
            ('Mail send successfully', 'Mail send successfully', 'hu_hu', 'A levélküldés sikeres', 32),
            ('Email Id or username not match with your record', 'Email Id or username not match with your record', 'hu_hu', 'Az e-mail azonosító vagy a felhasználónév nem egyezik a rekorddal', 32),
            ('Module not specified', 'Module not specified', 'hu_hu', 'Modul nincs megadva', 32),
            ('No messages found', 'No messages found', 'hu_hu', 'Nem található üzenet', 32),
            ('No Dependency Found For This Module', 'No Dependency Found For This Module', 'hu_hu', 'Nem található függőség ehhez a modulhoz', 32),
            ('Outgoing server is not Enabled', 'Outgoing server is not Enabled', 'hu_hu', 'A kimenő szerver nincs engedélyezve', 32),
            ('Outgoing server is Enabled', 'Outgoing server is Enabled', 'hu_hu', 'A kimenő szerver engedélyezve van', 32),
            ('Email Attached Successfully', 'Email Attached Successfully', 'hu_hu', 'Az e-mail sikeresen csatolva', 32),
            ('Documents Attached Successfully', 'Documents Attached Successfully', 'hu_hu', 'A dokumentumok sikeresen csatolva', 32),
            ('Login required - Please login again', 'Login required - Please login again', 'hu_hu', 'Bejelentkezés szükséges - Kérjük, jelentkezzen be újra', 32),
            ('time_tracking_module_disable', 'Time tracking module is disable', 'hu_hu', 'Az időkövető modul le van tiltva', 31),
            ('route_planning_module_disable', 'Route planning module is disable', 'hu_hu', 'Az útvonaltervező modul le van tiltva', 31),
            ('mark_as_held', 'Are you sure you want to mark Event as Held?', 'hu_hu', 'Biztosan meg akarja jelölni az eseményt megtartottként?', 31),
            ('stop_timer_msg', 'You have already started Time tracking for another record, Do you want to stop it first ?', 'hu_hu', 'Már elindította az időkövetést egy másik rekordnál. Szeretné előbb leállítani?', 31),
            ('access_denied_routeplanning', 'Access denied for route planning', 'hu_hu', 'Hozzáférés megtagadva az útvonaltervezéshez', 31),
            ('time_spent', 'Time Spent', 'hu_hu', 'Eltöltött idő', 31),
            ('select_user', 'Select User', 'hu_hu', 'Válasszon Felhasználót', 30),
            ('status_cannot_be_held', 'Status cannot be held for future date start', 'hu_hu', 'A státuszt nem lehet a jövőbeli dátum indítására beállítani.', 30),
            ('please_select_end_date', 'Please select end date', 'hu_hu', 'Kérjük, válassza ki a befejezési dátumot', 30),
            ('please_select_start_date', 'Please select start date', 'hu_hu', 'Kérjük, válassza ki a kezdési dátumot', 30),
            ('tap_on_plus_icon_for_select_route', 'Tap on + icon to select record for your route.', 'hu_hu', 'Érintse meg a + ikont az útvonal rekordjának kiválasztásához.', 30),
            ('please_enter_notes', 'Please enter notes', 'hu_hu', 'Kérjük, írja be a megjegyzéseket', 30),
            ('please_enter_title', 'Please enter title', 'hu_hu', 'Kérjük, adja meg a címet', 30),
            ('please_select_date', 'Please Select Date', 'hu_hu', 'Kérjük válasszon dátumot', 30),
            ('search_by_date', 'Search by Date', 'hu_hu', 'Keresés dátum szerint', 30),
            ('shortcut_not_setup_yet', 'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.', 'hu_hu', 'Hopp a parancsikon még nincs beállítva!!! Kérjük, adjon hozzá parancsikont az [icon] elemre kattintva a rekord keresési eredményei közül, vagy tekintse meg a rekord képernyőt.', 30),
            ('max_upload_size', 'max file Upload exceeds', 'hu_hu', 'A maximális fájlfeltöltést meghaladja', 30),
            ('unselect_all', 'UnSelect All', 'hu_hu', 'Minden kijelölés megszüntetése', 30),
            ('select_all', 'Select All', 'hu_hu', 'Mindet kiválaszt', 30),
            ('please_select_records', 'Please select records', 'hu_hu', 'Kérjük, válasszon rekordokat', 30),
            ('select_date', 'Select Date', 'hu_hu', 'Válasszon Dátumot', 30),
            ('quantity_in_stock_is', 'Quantity in stock is', 'hu_hu', 'A raktáron lévő mennyiség', 30),
            ('replies', 'Replies', 'hu_hu', 'Válaszok', 30),
            ('conversation_require_selection', 'Conversion requires selection of Contact or Organization', 'hu_hu', 'Az átalakításhoz a Kapcsolat vagy a Szervezet kiválasztása szükséges', 30),
            ('please_select_product', 'Please Select Product', 'hu_hu', 'Kérjük, válassza ki a terméket', 30),
            ('timer_msg', 'You can start timer for single task only at same time', 'hu_hu', 'Egyszerre csak egyetlen feladat időzítőjét indíthatja el', 31),
            ('save_start_tracking', 'Save & Start Tracking', 'hu_hu', 'Mentés és nyomon követés indítása', 31),
            ('lbl_notes', 'Notes', 'hu_hu', 'Feljegyzések', 31),
            ('enter_title', 'Enter Title', 'hu_hu', 'Írja be a címet', 31),
            ('select_module_record', 'Select Module / Record', 'hu_hu', 'Modul / Rekord kiválasztása', 31),
            ('lbl_tomorrow', 'Tomorrow', 'hu_hu', 'Holnap', 30),
            ('lbl_yesterday', 'Yesterday', 'hu_hu', 'Tegnap', 30),
            ('lbl_today', 'Today', 'hu_hu', 'Ma', 30),
            ('time_tracker', 'Time Tracker', 'hu_hu', 'Időkövető', 31),
            ('time_end', 'End Time', 'hu_hu', 'Befejezés ideje', 5),
            ('due_date', 'End Date', 'hu_hu', 'Befejezés dátuma', 5),
            ('time_start', 'Time Start', 'hu_hu', 'Kezdés ideje', 5),
            ('date_start', 'Start Date', 'hu_hu', 'Kezdés dátuma', 5),
            ('delete_widget_msg', 'Display widget again by using (+) option', 'hu_hu', 'Jelenítse meg újra a widgetet a (+) opcióval', 15),
            ('no_upcoming_activities', 'No scheduled activities    ', 'hu_hu', 'Nincs ütemezett tevékenység', 15),
            ('check_in_first', 'Please check-in first', 'hu_hu', 'Kérjük, először jelentkezzen be', 30),
            ('duration', 'Duration', 'hu_hu', 'Időtartam', 30),
            ('distance', 'Distance', 'hu_hu', 'Távolság', 30),
            ('proper_address_message', 'Please enter proper address in record\n', 'hu_hu', 'Kérjük, írja be a megfelelő címet a nyilvántartásba', 30),
            ('select_status', 'Select Status', 'hu_hu', 'Állapot kiválasztása', 30),
            ('route_planner', 'Route Planner', 'hu_hu', 'Útvonaltervező', 30),
            ('route_planning', 'Route Planning', 'hu_hu', 'Útvonaltervezés', 30),
            ('add_route', 'Add Route', 'hu_hu', 'Útvonal hozzáadása', 30),
            ('calender_disabled', 'Calendar Module is disabled', 'hu_hu', 'A naptár modul le van tiltva', 30),
            ('close_dialog', 'Close form', 'hu_hu', 'Űrlap bezárása', 30),
            ('cancel_form_message', 'Are You sure want to close ?', 'hu_hu', 'Biztosan be akarja zárni?', 30),
            ('create_route', 'Create Route', 'hu_hu', 'Útvonal létrehozása', 30),
            ('select_module_create_route', 'Select Module to create Route', 'hu_hu', 'Útvonal létrehozásához válasszon Modult', 30),
            ('cancel', 'Cancel', 'hu_hu', 'Mégse', 30),
            ('assign_route', 'Assign Route', 'hu_hu', 'Útvonal hozzárendelése', 30),
            ('route_for', 'Route for', 'hu_hu', 'Útvonal ehhez', 30),
            ('assigned_to', 'Assigned To', 'hu_hu', 'Felelős', 30),
            ('enter_route_name', 'Enter Route Name', 'hu_hu', 'Írja be az útvonal nevét', 30),
            ('list', 'List', 'hu_hu', 'Lista', 30),
            ('map', 'Map', 'hu_hu', 'Térkép', 30),
            ('other_modules', 'Other Modules', 'hu_hu', 'Egyéb modulok', 15),
            ('shortcut_no_record_msg', 'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 'hu_hu', 'Opps parancsikon nincs beállítva\n  még!!! Adjon hozzá parancsikont a + ikonra kattintva a rekordban\n  keresési eredményeket, vagy tekintse meg a felvételi képernyőt.', 25),
            ('clear', 'Clear', 'hu_hu', 'Törlés', 25),
            ('open', 'Open', 'hu_hu', 'Megnyit', 11),
            ('max_file_msg', 'Too many files selected (max:6)', 'hu_hu', 'Túl sok fájl van kiválasztva (max: 6)', 11),
            ('error_voicenote_record', 'Unable to recording voice while another application is recording sound.', 'hu_hu', 'Nem lehet hangot rögzíteni, miközben egy másik alkalmazás hangot rögzít.', 11),
            ('msg_warning', 'Warning!', 'hu_hu', 'Figyelmeztetés!', 11),
            ('Permision_denied_contact', 'Permission denied to access your contacts', 'hu_hu', 'A névjegyekhez való hozzáférés megtagadva', 15),
            ('no_widget_added', 'Please click + icon to add new widget to your dashboard.', 'hu_hu', 'Kérjük, kattintson a + ikonra, ha új widgetet szeretne hozzáadni az kezdőképernyőhöz.', 15),
            ('no_data_available', 'Data not available, please check the selected fields', 'hu_hu', 'Az adatok nem állnak rendelkezésre, kérjük ellenőrizze a kiválasztott mezőket', 15),
            ('check_out_successfully', 'Check out successfully', 'hu_hu', 'Sikeresen kijelentkezett', 11),
            ('check_in_successfully', 'Check in successfully', 'hu_hu', 'Sikeresen bejelentkezett', 11),
            ('check_out', 'Check out', 'hu_hu', 'Kijelentkezés', 11),
            ('check_in', 'Check in', 'hu_hu', 'Bejelentkezés', 11),
            ('navigate', 'Navigate', 'hu_hu', 'Navigál', 11),
            ('save_to_phone_vcard_success', 'VCard Saved to phone successfully', 'hu_hu', 'VCard sikeresen mentve a telefonra', 15),
            ('download_vcard_success', 'VCard downloaded successfully', 'hu_hu', 'VCard sikeresen letöltve', 15),
            ('card_details', 'Card Details', 'hu_hu', 'Kártya részletei', 15),
            ('add_widget', 'Add Widget', 'hu_hu', 'Widget hozzáadása', 15),
            ('delete_widget', 'Are you sure to hide widget?', 'hu_hu', 'Biztosan elrejti a widgetet?', 15),
            ('already_widgets_added', 'All types of Widget & reports are already added', 'hu_hu', 'Már minden típusú widget és jelentés hozzáadva', 15),
            ('retry', 'Retry', 'hu_hu', 'Próbálja újra', 28),
            ('retake', 'Retake', 'hu_hu', 'Megismételni', 28),
            ('Reports', 'Reports', 'hu_hu', 'Jelentések', 15),
            ('Widgets', 'Widgets', 'hu_hu', 'Widget-ek', 15),
            ('vcard_config', 'Vcard Configuration', 'hu_hu', 'Vcard konfiguráció', 8),
            ('save_to_phone', 'Save to phone', 'hu_hu', 'Mentés telefonra', 11),
            ('download_vcard', 'Download Vcard', 'hu_hu', 'Töltse le a Vcardot', 11),
            ('share_vcard', 'Share Vcard', 'hu_hu', 'Vcard megosztása', 11),
            ('share_record', 'Share Record', 'hu_hu', 'Rekord megosztása', 11),
            ('permission_denied_edit', 'You don\'t have permission to edit this record.', 'hu_hu', 'Nincs engedélye a rekord szerkesztésére.', 27),
            ('permission_denied_delete', 'You don\'t have permission to delete this record.', 'hu_hu', 'Nincs engedélye a rekord törlésére.', 27),
            ('Voice_Recording_Started', 'Recording Started', 'hu_hu', 'Felvétel elkezdődött', 12),
            ('Voice_Recording_Stopped', 'Recording Stopped', 'hu_hu', 'Felvétel leállítva', 12),
            ('SEARCH', 'Search', 'hu_hu', 'Keresés', 7),
            ('LAST', 'Last', 'hu_hu', 'Utolsó', 7),
            ('FIRST', 'First', 'hu_hu', 'Első', 7),
            ('MONDAY', 'Monday', 'hu_hu', 'Hétfő', 7),
            ('TUESDAY', 'Tuesday', 'hu_hu', 'Kedd', 7),
            ('WEDNESDAY', 'Wednesday', 'hu_hu', 'Szerda', 7),
            ('THURSDAY', 'Thursday', 'hu_hu', 'Csütörtök', 7),
            ('FRIDAY', 'Friday', 'hu_hu', 'Péntek', 7),
            ('SATURDAY', 'Saturday', 'hu_hu', 'Szombat', 7),
            ('SUNDAY', 'Sunday', 'hu_hu', 'Vasárnap', 7),
            ('DAILY', 'Daily', 'hu_hu', 'Napi', 7),
            ('WEEKLY', 'Weekly', 'hu_hu', 'Heti', 7),
            ('MONTHLY', 'Monthly', 'hu_hu', 'Havi', 7),
            ('YEARLY', 'Yearly', 'hu_hu', 'Évi', 7),
            ('asset_tracking', 'Asset tracking', 'hu_hu', 'Eszközkövetés', 15),
            ('open_file', 'Open File', 'hu_hu', 'Fájl megnyitása', 1),
            ('download_pdf_successfully', 'Download PDF Successfully', 'hu_hu', 'PDF letöltése sikeres', 1),
            ('select_pdf', 'Select PDF', 'hu_hu', 'PDF kiválasztása', 1),
            ('email_pdf', 'Email PDF', 'hu_hu', 'PDF küldése e-mailben', 1),
            ('download_pdf', 'Download PDF', 'hu_hu', 'PDF letöltése', 1),
            ('edit_route', 'Edit Route', 'hu_hu', 'Útvonal szerkesztése', 1),
            ('save_route', 'Save Route', 'hu_hu', 'Útvonal mentése', 1),
            ('clear_all', 'Clear All', 'hu_hu', 'Mindent töröl', 1),
            ('notification', 'Notifications', 'hu_hu', 'Értesítések', 1),
            ('menu_management', 'Menu Management', 'hu_hu', 'Menükezelés', 1),
            ('select_menu', 'Select Menu', 'hu_hu', 'Válasszon menüt', 1),
            ('module_record_not_found', 'Module and Record not found', 'hu_hu', 'A modul és a rekord nem található', 1),
            ('reason_for_changing_comments', 'Reason for changing comments', 'hu_hu', 'A megjegyzések megváltoztatásának oka', 1),
            ('edit_reason', 'Edit Reason', 'hu_hu', 'Ok szerkesztése', 1),
            ('create_filters', 'Create Filter', 'hu_hu', 'Szűrő létrehozása', 1),
            ('you_checked', 'You Checked', 'hu_hu', 'Ellenőrizted', 1),
            ('you_un_checked', 'You UnChecked', 'hu_hu', 'Nem ellenőrizted', 1),
            ('log_the_call', 'Log the call ?', 'hu_hu', 'Naplózná a hívást?', 1),
            ('add_a_description_(optional)', 'Add a description (optional)', 'hu_hu', 'Leírás hozzáadása (nem kötelező)', 1),
            ('called', 'Called', 'hu_hu', 'Hívott', 1),
            ('call_log', 'Call Log', 'hu_hu', 'Hívás Log', 1),
            ('subject', 'Subject', 'hu_hu', 'Tárgy', 1),
            ('add_condition', 'Add Condition', 'hu_hu', 'Feltétel hozzáadása', 1),
            ('select_condition', 'Select Condition', 'hu_hu', 'Feltétel választása', 1),
            ('select_field', 'Select Field', 'hu_hu', 'Mező kiválasztása', 1),
            ('please_select_first_field', 'Please First Select field', 'hu_hu', 'Kérjük, először válassza ki a mezőt', 1),
            ('filter_name', 'Filter Name', 'hu_hu', 'Szűrő neve', 1),
            ('enter_filter_name', 'Enter filter name', 'hu_hu', 'Adja meg a szűrő nevét', 1),
            ('choose_conditions', 'Choose Conditions', 'hu_hu', 'Válasszon feltételeket', 1),
            ('all_condition', 'All Conditions(All conditions must be met)', 'hu_hu', 'Minden feltétel (Minden feltételnek teljesülnie kell)', 1),
            ('any_condition', 'Any Conditions(At least one the conditions must be met)', 'hu_hu', 'Bármilyen feltétel (legalább egy feltételnek teljesülnie kell)', 1),
            ('lattitude', 'latitude', 'hu_hu', 'szélességi kör', 1),
            ('notification_settings', 'Notification Settings', 'hu_hu', 'Értesítési beállítások', 1),
            ('notification_management', 'Notification Management', 'hu_hu', 'Értesítéskezelés', 1),
            ('addyourcommentshere', 'Type @ to mention user', 'hu_hu', 'A felhasználó megemlítéséhez írja be a @-t', 1),
            ('google_api_key_missing', 'Google Api key is missing.', 'hu_hu', 'A Google Api kulcs hiányzik.', 1),
            ('event_filter_by', 'Event Filter by', 'hu_hu', 'Eseményszűrés', 1),
            ('apply', 'Apply', 'hu_hu', 'Alkalmaz', 1),
            ('choose_from_gallery', 'Choose From Gallery', 'hu_hu', 'Válasszon a Galériából', 1),
            ('choose_from_camera', 'Choose From Camera', 'hu_hu', 'Válasszon a Kamerából', 1),
            ('mutli_select_CB', 'Mutli Select CB', 'hu_hu', 'Mutli Select CB', 1),
            ('please_select_condition', 'Please Select Condition', 'hu_hu', 'Kérjük válasszon feltételt', 1),
            ('please_enter_value_or_field', 'Please Enter Value or Field', 'hu_hu', 'Kérjük, adja meg az értéket vagy a mezőt', 1),
            ('set_as_default', 'Set as Default', 'hu_hu', 'Beállítás alapértelmezettként', 1),
            ('list_in_metrics', 'List in Metrics', 'hu_hu', 'Mutatók listája', 1),
            ('order_number', 'Order Number', 'hu_hu', 'Rendelésszám', 1),
            ('recording_saved_message', 'Recording saved successfully.', 'hu_hu', 'A felvétel sikeresen elmentve.', 1),
            ('recording_file', 'Recording File', 'hu_hu', 'Felvételi fájl', 1),
            ('file_not_found', 'File not found', 'hu_hu', 'Fájl nem található', 1),
            ('please_enter_valid_path', 'Please enter valid path', 'hu_hu', 'Adjon meg érvényes elérési utat', 1),
            ('enter_path_here', 'Enter path here...', 'hu_hu', 'Ide írja be az elérési utat...', 1),
            ('set_call_recording_path', 'Set Call Recording Path', 'hu_hu', 'Hívásrögzítési útvonal beállítása', 1),
            ('set_call_recording_path_here', 'Set call recording path here', 'hu_hu', 'Itt állíthatja be a hívásrögzítési útvonalat', 1),
            ('call_recording_path', 'Call Recording Path', 'hu_hu', 'Hívásrögzítési útvonal', 1),
            ('please_place_api', 'Please enable place api', 'hu_hu', 'Kérjük, engedélyezze a hely API-t', 1),
            ('event_filters_by', 'Event Filters by', 'hu_hu', 'Eseményszűrők szerint', 1),
            ('select_at_least_one_option', 'Please select at least one option', 'hu_hu', 'Kérjük, válasszon legalább egy lehetőséget', 1),
            ('enable_call_feature', 'Please enable call feature', 'hu_hu', 'Kérjük, engedélyezze a hívás funkciót', 1),
            ('enable_email_feature', 'Please enable email feature', 'hu_hu', 'Kérjük, engedélyezze az e-mail funkciót', 1),
            ('demo_login', 'Demo Login', 'hu_hu', 'Demo Bejelentkezés', 1),
            ('select_email_template', 'Select Email Template', 'hu_hu', 'Válasszon Email sablont', 1),
            ('template_name', 'Template Name', 'hu_hu', 'Sablon neve', 1),
            ('example_storage_path', 'example : storage/Music/Recordings/Call Recordings', 'hu_hu', 'példa: storage/Music/Recordings/Call Recordings', 1),
            ('User Notification Settings saved successfully', 'User Notification Settings saved successfully', 'hu_hu', 'A felhasználói értesítési beállítások sikeresen elmentve', 33),
            ('This Notification has been disabled by admin', 'This Notification has been disabled by admin', 'hu_hu', 'Ezt az értesítést az adminisztrátor letiltotta', 33),
            ('Notify when any updates to the record you\'re following', 'Notify when any updates to the record you\'re following', 'hu_hu', 'Értesítsen, ha a követett rekord frissítése történik', 33),
            ('Task assigned to you', 'Task assigned to you', 'hu_hu', 'Önhöz rendelt feladat', 33),
            ('Task Reminder', 'Task Reminder', 'hu_hu', 'Feladat emlékeztető', 33),
            ('You were mentioned in comments', 'You were mentioned in comments', 'hu_hu', 'Önt megemlítették egy megjegyzésben', 33),
            ('Comments has been added to record assigned to you', 'Comments has been added to record assigned to you', 'hu_hu', 'Megjegyzések hozzáadva az Önhöz rendelt rekordhoz', 33),
            ('When Record Assigned', 'When Record Assigned', 'hu_hu', 'Amikor a rekord hozzá van rendelve', 33),
            ('Event Reminder', 'Event Reminder', 'hu_hu', 'Esemény emlékeztető', 33),
            ('Event Invitation', 'Event Invitation', 'hu_hu', 'Eseménymeghívó', 33),
            ('Follow record', 'Follow record', 'hu_hu', 'Rekord követése', 33),
            ('Task', 'Task', 'hu_hu', 'Feladat', 33),
            ('Conversions', 'Conversions', 'hu_hu', 'Konverziók', 33),
            ('Events', 'Events', 'hu_hu', 'Események', 33),
            ('no_records_changed_filter_message', 'No record(s) found Please click on filter icon to change filter', 'hu_hu', 'Nem található rekord(ok) Kérjük, kattintson a szűrő ikonra a szűrő módosításához', 1),
            ('title', 'Title', 'hu_hu', 'Cím', 1),
            ('dialog_recent_call_info', 'Click + to select your mobile call recording folder where your recorded call files are stored.', 'hu_hu', 'Kattintson a + gombra a mobilhívásrögzítési mappájának kiválasztásához, ahol a rögzített hívásfájlokat tárolja.', 1),
            ('call_recording', 'Call recording', 'hu_hu', 'Hívásfelvétel', 1),
            ('voice_recorder', 'Voice Recorder', 'hu_hu', 'Hangrögzítő', 1),
            ('no_address_reference_found',  'No Address Reference found',   'hu_hu',    'Címhivatkozás nem található',  32),
            ('no_overdue_activities',   'No OverDue Activities',    'hu_hu',    'Nincs lejárt tevékenység', 32),
            ('latitude_longitude_validation_message',   'Please enter proper address from this address we are not getting proper latitude and longitude',   'hu_hu',    'Kérlek add meg a pontos címet,  mivel ebb?l a címb?l nem tudjuk meghatározni a megfelel? szélességi és hosszúsági fokot',  32),
            ('Default_Search_Field',    'Default search field', 'hu_hu',    'Alapértelmezett keresési mez?',    32),
            ('Calender_Reminder_Message',   'Free user can\'t send local reminder', 'hu_hu',    'Ingyenes felhasználó nem tud helyi emlékeztet?t küldeni',  32),
            ('you_must_have_permission',    'You must give permissions to use this features.',  'hu_hu',    'Engedélyeket kell adnod a funkciók használatához.',    32),
            ('internal_comment',    'Internal Comment', 'hu_hu',    'Bels? megjegyzés', 1),
            ('unlink_record',   'Unlink Record',    'hu_hu',    'Rekord lecsatlakoztatása', 11),
            ('unlink_record_msg',   'Are you sure want to unlink record?',  'hu_hu',    'Biztosan szeretnéd megszüntetni a rekord kapcsolatát?',    11),
            ('file_format_not_support', 'File format not supported',    'hu_hu',    'Fájlformátum nem támogatott',  11),
            ('file_upload', 'File Upload',  'hu_hu',    'Fájl feltöltés',   5),
            ('to_vtiger',   'To Vtiger',    'hu_hu',    'Vtigerbe', 5),
            ('link_external_document',  'Link External Document',   'hu_hu',    'Küls? dokumentum hivatkozása', 5),
            ('from_file_url',   'From File Url',    'hu_hu',    'Fájl URL-b?l', 5),
            ('create_new_document', 'Create New Document',  'hu_hu',    'Új dokumentum létrehozása',    5),
            ('select_document_type',    'Select Document type', 'hu_hu',    'Dokumentum típus kiválasztása',    5),
            ('add_signature',   'Please add signature', 'hu_hu',    'Kérlek add hozzá az aláírást', 11),
            ('date_greater_then_equal', 'should be greater than or equal to',   'hu_hu',    'nagyobb vagy egyenl? kell legyen', 1),
            ('date_less_then_equal',    'should be less than or equal to',  'hu_hu',    'kisebb vagy egyenl? kell legyen',  1),
            ('Click_on_plus_for_add',   'Please tap on  +  to create a new record.',    'hu_hu',    'Kérlek kattints a + jelre az új rekord létrehozásához.',   15),
            ('display_map', 'Display map',  'hu_hu',    'Térkép megjelenítése', 15),
            ('other_settings',  'Other settings',   'hu_hu',    'Egyéb beállítások',    15),
            ('total_hours', 'Total hours',  'hu_hu',    'Összes óraszám',   15),
            ('widget_not_found',    'No widgets found', 'hu_hu',    'Nincsenek widgetek',   15),
            ('quickaction', 'Quick action', 'hu_hu',    'Gyors m?velet',    15),
            ('dashboard',   'Dashboard',    'hu_hu',    'Kezd?képerny?',    15),
            ('new', 'New',  'hu_hu',    'Új',   15),
            ('global_search_hint',  'Please try to search using search box at top', 'hu_hu',    'Kérlek próbálj keresni a fels? keres?mez? használatával',  15),
            ('near_by_map', 'Near By Map',  'hu_hu',    'Térkép közelében', 15),
            ('miles',   'Miles',    'hu_hu',    'Mérföld',  15),
            ('lbl_filters', 'Filters',  'hu_hu',    'Sz?r?k',   27),
            ('warning', 'Warning',  'hu_hu',    'Figyelmeztetés',   27),
            ('no_filter_created',   'No filter is created.',    'hu_hu',    'Nincs létrehozva sz?r?.',  27),
            ('please_create_new_ilter', 'Please create a new filter',   'hu_hu',    'Kérlek hozz létre egy új sz?r?t',  27),
            ('select_search_fields',    'Select fields for the search record.', 'hu_hu',    'Válaszd ki a keresési rekord mez?it.', 27),
            ('apply_fliters',   'Apply filters',    'hu_hu',    'Sz?r?k alkalmazása',   27),
            ('sort_by', 'Sort by',  'hu_hu',    'Rendezés', 27),
            ('sort_order',  'Sort order',   'hu_hu',    'Rendezési sorrend',    27),
            ('Start_time_tracking', 'Start time tracking',  'hu_hu',    'Id?követés indítása',  31),
            ('Stop_time_tracking',  'Stop time tracking',   'hu_hu',    'Id?követés leállítása',    31),
            ('image_preview',   'Image preview',    'hu_hu',    'Kép el?nézet', 11),
            ('phone_number',    'Phone number', 'hu_hu',    'Telefonszám',  11),
            ('email_address',   'Email address',    'hu_hu',    'Email cím',    11),
            ('edit_your_preferences',   'Edit your preferences',    'hu_hu',    'Saját beállítások szerkesztése',   8),
            ('about_app',   'About app',    'hu_hu',    'Az alkalmazásról', 8),
            ('updated_ctmobile_ext_version',    'You already have latest CTMobile Ext. Version',    'hu_hu',    'Már a legújabb CTMobile kiterjesztés verziód van', 8),
            ('updated_app_version', 'You already have latest CRMTiger App Version', 'hu_hu',    'Már a legújabb CRMTiger alkalmazás verziód van',   8),
            ('plan',    'Plan', 'hu_hu',    'El?fizetés',   8),
            ('time',    'Time', 'hu_hu',    'Id?',  31),
            ('error_log_msg',   'Oops, something went wrong! Please click on Share Button to share error log with our technical team',  'hu_hu',    'Hoppá! Valami rosszul sült el! Kérjük, kattintson a Megosztás gombra a hibanapló megosztásához műszaki csapatunkkal',  1),
            ('add_to_quick_action', 'Add to quick action',  'hu_hu',    'Hozzáadás a gyors m?veletekhez',   1),
            ('add_filter_to_quick_action',  'Add filter to quick action',   'hu_hu',    'Sz?r? hozzáadása a gyors m?veletekhez',    1),
            ('create_record',   'Create Record',    'hu_hu',    'Rekord létrehozása',   1),
            ('quick_action_hint',   'You can Add Quick Action here',    'hu_hu',    'Itt hozzáadhatsz gyors m?veletet', 1),
            ('str_send',    'Send', 'hu_hu',    'Küldés',   3),
            ('tax_region_msg',  'Do you want to update tax & charge values corresponding to selected region?',  'hu_hu',    'Szeretnéd frissíteni az adó- és költségértékeket a kiválasztott régióhoz?',    1),
            ('delete_quick_action_widgest', 'Delete Widget?',   'hu_hu',    'Widget törlése?',  15),
            ('add_record_to_dashboard', 'Add record to dashboard',  'hu_hu',    'Rekord hozzáadása a m?szerfalhoz', 15),
            ('module_quick_action_msg', 'Module added to dashboard',    'hu_hu',    'Modul hozzáadva a m?szerfalhoz',   15),
            ('filter_quick_action_msg', 'Filter added to dashboard',    'hu_hu',    'Sz?r? hozzáadva a m?szerfalhoz',   15),
            ('record_quick_action_msg', 'Record added to dashboard',    'hu_hu',    'Rekord hozzáadva a m?szerfalhoz',  15),
            ('filter_shortcut_quick_action_msg',    'Filter shortcut added to dashboard',   'hu_hu',    'Sz?r? parancsikon hozzáadva a m?szerfalhoz',   15),
            ('record_shortcut_quick_action_msg',    'Record shortcut added to dashboard',   'hu_hu',    'Rekord parancsikon hozzáadva a m?szerfalhoz',  15),
            ('documents_disabled',  'Documents Module is disabled', 'hu_hu',    'Dokumentum modul le van tiltva',   1),
            ('document_dont_attachment',    'Document does not have a attachment',  'hu_hu',    'A dokumentumnak nincs csatolmánya',    1),
            ('go_to_neat_by',   'Go to NearBy', 'hu_hu',    'Mutasd a Közelben lév?ket',    15),
            ('go_to_time_tracking', 'Go to Time Tracker',   'hu_hu',    'Mutasd az Id?követ?t', 13),
            ('nearby_quick_action_msg', 'NearBy added to dashboard',    'hu_hu',    'Közelben lév?k hozzáadva a m?szerfalhoz',  15),
            ('time_tracking_quick_action_msg',  'Time Tracking added to dashboard', 'hu_hu',    'Id?követés hozzáadva a m?szerfalhoz',  15),
            ('attendance_quick_action_msg', 'Attendance added to dashboard',    'hu_hu',    'Jelenlét hozzáadva a m?szerfalhoz',    15),
            ('attachment',  'Attachment',   'hu_hu',    'Csatolmány',   15),
            ('search_by_fields',    'Search by fields', 'hu_hu',    'Keresés mez?k szerint',    27),
            ('apply_selected',  'Apply selected',   'hu_hu',    'Kiválasztott alkalmazása', 27),
            ('auto_address_disabled',   'auto address finder is disabled, please enable it from CRMTiger Settings', 'hu_hu',    'Az automatikus címkereső le van tiltva, engedélyezze a CRMTiger beállításainál',   1),
            ('Attendance',  'Attendance',   'hu_hu',    'Jelenlét', 15),
            ('Check-in successfully',   'Check-in successfully',    'hu_hu',    'Bejelentkezés sikeres',    32),
            ('Check-out successfully',  'Check-out successfully',   'hu_hu',    'Kijelentkezés sikeres',    32),
            ('Nothing around here', 'Nothing around here',  'hu_hu',    'Nincs semmi a közelben',   13),
            ('select_days', 'Select Days',  'hu_hu',    'Válassz napokat',  5),
            ('select_minutes',  'Select Minutes',   'hu_hu',    'Válassz perceket', 5),
            ('select_hours',    'Select Hours', 'hu_hu',    'Válassz órákat',   5),
            ('no_lat_long_found',   'Location information (Latitude,Longitude) not found',  'hu_hu',    'Helyinformáció (szélesség, hosszúság) nem található',  32),
            ('Call Log save successfully',  'Call Log save successfully',   'hu_hu',    'Hívásnapló sikeresen mentve',  32),
            ('Files/photos deleted successfully',   'Files/photos deleted successfully',    'hu_hu',    'Fájlok/fotók sikeresen törölve',   32),
            ('important',   'Important',    'hu_hu',    'Fontos',   34),
            ('template',    'Template', 'hu_hu',    'Sablon',   34),
            ('copy',    'Copy', 'hu_hu',    'Másolás',  34),
            ('camera',  'Camera',   'hu_hu',    'Kamera',   34),
            ('gallery', 'Gallery',  'hu_hu',    'Galéria',  34),
            ('audio',   'Audio',    'hu_hu',    'Hang', 34),
            ('last_seen_at',    'Last seen at', 'hu_hu',    'Utolsó látogatás ideje',   34),
            ('type_a_message',  'Type a message',   'hu_hu',    'Írj üzenetet', 34),
            ('all_messages',    'All messages', 'hu_hu',    'Minden üzenet',    34),
            ('time_tracking_reports',   'Time tracking reports',    'hu_hu',    'Id?követési jelentések',   31),
            ('attendance_reports',  'Attendance reports',   'hu_hu',    'Jelenléti jelentések', 31),
            ('chats',   'Chats',    'hu_hu',    'Beszélgetések',    34),
            ('Marked chat as Important',    'Marked chat as Important', 'hu_hu',    'Beszélgetés fontosnak jelölve',    34),
            ('Unmarked chat as Important',  'Unmarked chat as Important',   'hu_hu',    'Beszélgetés fontosnak jelölése megszüntetve',  34),
            ('mark_as_important',   'Mark as important',    'hu_hu',    'Fontosnak jelölés',    34),
            ('unmark_As_important', 'Unmark as important',  'hu_hu',    'Fontosnak jelölés megszüntetése',  34),
            ('select_template', 'Select template',  'hu_hu',    'Sablon kiválasztása',  34),
            ('chat',    'Chat', 'hu_hu',    'Beszélgetés',  34),
            ('search_by_name_or_contact',   'Search by name or contact',    'hu_hu',    'Keresés név vagy kapcsolat alapján',   34),
            ('choose_contact_for_whatsApp', 'Choose contact for whatsApp',  'hu_hu',    'Kapcsolat választása WhatsApp-hoz',    34),
            ('whatsapp_template',   'Whatsapp template',    'hu_hu',    'WhatsApp sablon',  34),
            ('send_voice_recording',    'Send voice recording', 'hu_hu',    'Hangfelvétel küldése', 34),
            ('slide_to_cancel', 'Slide To Cancel',  'hu_hu',    'Csúsztasd oldalra az eltávolításhoz',  34),
            ('whatsapp_disconnect_messsage',    'Ooops.. You\'re disconnected from WhatsApp. Please Scan QR Code from the CRM.',    'hu_hu',    'Hoppá... Le vagy kapcsolva a WhatsApp-ról... Kérlek  olvasd be újra a QR kódot a CRM-b? és tartsd a telefonodat az internethez csatlakoztatva!!!!',    34),
            ('select_priority', 'Select priority',  'hu_hu',    'Prioritás kiválasztása',   30),
            ('repeat_route',    'Repeat route', 'hu_hu',    'Útvonal ismétlése',    30),
            ('change_assign_to',    'Change assigned to',   'hu_hu',    'Kijelölés módosítása', 30),
            ('Multiple Route created successfully', 'Multiple Route created successfully',  'hu_hu',    'Több útvonal sikeresen létrehozva',    30),
            ('Route duplicated successfully',   'Route duplicated successfully',    'hu_hu',    'Útvonal sikeresen duplikálva', 30);",array());
        }
    }

    static function pt_br(){
        global $adb;
        $checkLang = $adb->pquery("SELECT 1 FROM ctmobile_language_keyword WHERE keyword_lang = ?",array('es_mx'));
        if($adb->num_rows($checkLang) == 0){
            $adb->pquery("INSERT INTO `ctmobile_language_keyword` (`keyword`, `keyword_name`, `keyword_lang`, `language_keyword`, `sectionid`) VALUES
            ('network_error',   'Network connection error!',    'pt_br',    'Erro de conexão de rede!', 1),
            ('connection_check',    'Could not connect to CRM, Please check your Internet connection.', 'pt_br',    'Não foi possível conectar-se ao CRM. Verifique sua conexão com a Internet.',   1),
            ('update',  'Update',   'pt_br',    'Atualizar',    1),
            ('cancel',  'Cancel',   'pt_br',    'Cancelar', 1),
            ('ok',  'Ok',   'pt_br',    'OK',   1),
            ('more_information',    'Click here for more information.', 'pt_br',    'Clique aqui para obter mais informações.', 1),
            ('yes', 'Yes',  'pt_br',    'Sim',  1),
            ('no',  'No',   'pt_br',    'Não',  1),
            ('click_again_exit',    'Click again to exit',  'pt_br',    'Clique novamente para sair',   1),
            ('forpermission',   'You don\'t have permission to view this feature. Please subscribe for Premium version Click here to Subscribe.',   'pt_br',    'Você não tem permissão para visualizar este recurso. Por favor, assine a versão Premium Clique aqui para se inscrever.',   1),
            ('clickhere',   'Click here',   'pt_br',    'Clique aqui',  1),
            ('clickhere_subscribe', 'Click here to subscribe premium version',  'pt_br',    'Clique aqui para assinar a versão premium',    1),
            ('clickhere_configure', 'Click here and view how to Configure.',    'pt_br',    'Clique aqui e veja como configurar.',  1),
            ('please_wait', 'Please Wait…', 'pt_br',    'Por favor, aguarde…',  1),
            ('share__msg',  'Share file with',  'pt_br',    'Compartilhar arquivo com', 1),
            ('dialog_camera',   'Camera',   'pt_br',    'Câmera',   1),
            ('dialog_add_file_by',  'Take Photo from',  'pt_br',    'Tirar foto de',    1),
            ('add', 'Add',  'pt_br',    'Adicionar',    1),
            ('mail_manager_configured', 'Mail Manager is not configured',   'pt_br',    'O Mail Manager não está configurado',  1),
            ('dialog_add_files_by', 'Add Files by', 'pt_br',    'Adicionar arquivos por',   1),
            ('dialog_drive',    'Drive',    'pt_br',    'Dirigir',  1),
            ('dialog_drop_box', 'Drop Box', 'pt_br',    'Dropbox',  1),
            ('dialog_need_signin',  'You need to Sign-in to your Drive account first.', 'pt_br',    'Você precisa primeiro fazer login em sua conta do Drive.', 1),
            ('dialog_gallery',  'Gallery',  'pt_br',    'Galeria',  1),
            ('delete',  'Delete',   'pt_br',    'Excluir',  1),
            ('timeoutmessage',  'Oops! Request is taking more time than expected.', 'pt_br',    'Ops! A solicitação está demorando mais do que o esperado.',    1),
            ('gps_location_message',    'GPS is not enabled. Please turn it on to get your near by locations.', 'pt_br',    'O GPS não está ativado. Ative-o para obter locais próximos.',  1),
            ('sure_want_delete',    'Are you sure want to delete ?',    'pt_br',    'Tem certeza de que deseja excluir?',   1),
            ('select',  'Select',   'pt_br',    'Selecione',    1),
            ('msgforrecordaudio',   'Minimum record duration one second.',  'pt_br',    'Duração mínima do registro de um segundo.',    1),
            ('permission_storage',  'Permission denied to read your External storage',  'pt_br',    'Permissão negada para ler seu armazenamento externo',  1),
            ('send_permission_msg', 'Send message permission denied',   'pt_br',    'Permissão para enviar mensagem negada',    1),
            ('choosefile',  'Choose File',  'pt_br',    'Escolher arquivo', 1),
            ('enter',   'Enter',    'pt_br',    'Digitar',  1),
            ('select_an_option',    'Select an Option', 'pt_br',    'Selecione uma opção',  1),
            ('email_validation',    'Email is not valid',   'pt_br',    'E-mail não é válido',  1),
            ('please_enter',    'Please Enter', 'pt_br',    'Por favor, insira',    1),
            ('website_validation_text', 'Website URL is not valid', 'pt_br',    'O URL do site não é válido',   1),
            ('selectvalue', 'Select value first',   'pt_br',    'Selecione o valor primeiro',   1),
            ('email',   'Email',    'pt_br',    'E-mail',   1),
            ('enter_email_address', 'Enter email address',  'pt_br',    'Insira o endereço de e-mail',  1),
            ('email_address_not_correct',   'Email address incorrect',  'pt_br',    'Endereço de e-mail incorreto', 1),
            ('pls_enter_subject',   'Please Enter Subject', 'pt_br',    'Por favor insira o assunto',   1),
            ('attachFiles', 'Attached File',    'pt_br',    'Arquivo anexo',    1),
            ('from',    'From', 'pt_br',    'De',   1),
            ('to',  'To',   'pt_br',    'From', 1),
            ('call_permission_msg', 'Call permission denied',   'pt_br',    'Permissão de chamada negada',  1),
            ('no_records',  'No records found', 'pt_br',    'Nenhum registro foi encontrado',   1),
            ('fullform',    'Create New',   'pt_br',    'Crie um novo', 1),
            ('save',    'Save', 'pt_br',    'Salvar',   1),
            ('total',   'Total',    'pt_br',    'Total',    1),
            ('discount',    'Discount', 'pt_br',    'Desconto', 1),
            ('price',   'Price',    'pt_br',    'Preço',    1),
            ('quantity',    'Quantity', 'pt_br',    'Quantidade',   1),
            ('select_module',   'Select Module',    'pt_br',    'Selecione Módulo', 1),
            ('item_list',   'Item List',    'pt_br',    'Item da lista',    1),
            ('quickcreate', 'Quick Create', 'pt_br',    'Criação rápida',   1),
            ('overwrite_msg_part1', 'Overwrite the existing address with the selected', 'pt_br',    'Substitua o endereço existente pelo selecionado',  1),
            ('once_in_every',   'Once in every',    'pt_br',    'Uma vez em cada',  1),
            ('overwrite_msg_part2', 'address details?', 'pt_br',    'Detalhes do Endereço?',    1),
            ('add_item',    'Add Item', 'pt_br',    'Adicionar Item',   1),
            ('recordsave',  'Record saved successfully',    'pt_br',    'Registro salvo com sucesso',   1),
            ('recordnotsave',   'Could not save record. Try again later',   'pt_br',    'Não foi possível salvar o registro. Tente mais tarde', 1),
            ('minutes', 'Minutes',  'pt_br',    'Minutos',  1),
            ('hours',   'Hours',    'pt_br',    'Horas',    1),
            ('days',    'Days', 'pt_br',    'Dias', 1),
            ('on',  'On',   'pt_br',    'Sobre',    1),
            ('day_of_the_month',    'day of the month', 'pt_br',    'dia do mês',   1),
            ('list_price',  'List Price',   'pt_br',    'Preço de tabela',  1),
            ('add_record',  'Add Record',   'pt_br',    'Adicionar registro',   1),
            ('add_product', 'Add Product',  'pt_br',    'Adicionar produto',    1),
            ('add_service', 'Add Service',  'pt_br',    'Adicionar serviço',    1),
            ('discountin',  'Discount in %',    'pt_br',    'Desconto em %',    1),
            ('unitprice',   'Unit price',   'pt_br',    'Preço unitário',   1),
            ('netprice',    'Net price',    'pt_br',    'Preço líquido',    1),
            ('comments',    'Comments', 'pt_br',    'Comentários',  1),
            ('add_close',   'Add & Close',  'pt_br',    'Adicionar e fechar',   1),
            ('fetching_rout_message',   'Fetching route, Please wait…', 'pt_br',    'Buscando rota, aguarde…',  1),
            ('setting', 'Settings', 'pt_br',    'Configurações',    1),
            ('utc', 'UTC',  'pt_br',    'UTC',  1),
            ('in',  'In',   'pt_br',    'Em',   1),
            ('days_ago',    'days ago', 'pt_br',    'dias atrás',   1),
            ('mins_ago',    'Minutes ago',  'pt_br',    'Minutos atrás',    1),
            ('justnow', 'Just now', 'pt_br',    'Agora mesmo',  1),
            ('hours_ago',   'hours ago',    'pt_br',    'horas atrás',  1),
            ('in_1_day',    'In 1 day', 'pt_br',    'Em 1 dia', 1),
            ('scanqrcode',  'Asset / Card scanner', 'pt_br',    'Scanner de ativos/cartões',    1),
            ('call_log',    'Call Log', 'pt_br',    'Registro de chamadas', 1),
            ('voice_message',   'Hi',   'pt_br',    'Oi',   1),
            ('voice_message1',  'What can I search for you in', 'pt_br',    'O que posso procurar por você em', 1),
            ('live_tracking',   'Live Tracking',    'pt_br',    'Rastreamento ao vivo', 1),
            ('mailmanager', 'Mail Manager', 'pt_br',    'Gerenciador de correio',   1),
            ('my_location', 'My location',  'pt_br',    'Minha localização',    1),
            ('created_on',  'Created On',   'pt_br',    'Criado em',    1),
            ('modified_on', 'Modified On',  'pt_br',    'Modificado em',    1),
            ('enter_comments',  'Enter Comments',   'pt_br',    'Insira comentários',   1),
            ('viewmore',    'View More',    'pt_br',    'Veja mais',    1),
            ('viewless',    'View Less',    'pt_br',    'Ver menos',    1),
            ('gotofullform',    'Go to Full Form',  'pt_br',    'Acesse o formulário completo', 1),
            ('post',    'Post', 'pt_br',    'Publicar', 1),
            ('url', 'URL',  'pt_br',    'URL',  1),
            ('dialog_title_text_back_color',    'Select a Text Background Color',   'pt_br',    'Selecione uma cor de fundo do texto',  1),
            ('event_or_task',   'Add event/task',   'pt_br',    'Adicionar evento/tarefa',  1),
            ('shortcut',    'Shortcuts',    'pt_br',    'Atalhos',  1),
            ('select_field',    'Select Field', 'pt_br',    'Selecione o campo',    1),
            ('share',   'Share',    'pt_br',    'Compartilhar', 1),
            ('title_insert_link',   'Insert Link',  'pt_br',    'Inserir link', 1),
            ('addyourcommentshere', 'Add your comments here',   'pt_br',    'Adicione seus comentários aqui',   1),
            ('nocomment',   'No Comments',  'pt_br',    'Sem comentários',  1),
            ('leads',   'Leads',    'pt_br',    'Pistas',   1),
            ('true_val',    'true', 'pt_br',    'verdadeira',   1),
            ('noresult',    'No Result',    'pt_br',    'Nenhum resultado', 1),
            ('version', 'Version',  'pt_br',    'Versão',   1),
            ('convert_lead',    'Convert Lead', 'pt_br',    'Líder do conversor',   1),
            ('app_name',    'CRMTiger', 'pt_br',    'CRMTiger', 1),
            ('enter_url',   'Please Enter url', 'pt_br',    'Por favor insira o URL',   1),
            ('help',    'Help', 'pt_br',    'Ajuda',    1),
            ('contact_us',  'Contact Us',   'pt_br',    'Contate-nos',  1),
            ('updates', 'Updates',  'pt_br',    'Atualizações', 1),
            ('logout',  'LogOut',   'pt_br',    'Sair', 1),
            ('busnies_cardscanner', 'Business Card Scanner',    'pt_br',    'Scanner de cartão de visita',  1),
            ('sure_want_logout',    'Are you sure want to logout ?',    'pt_br',    'Tem certeza de que deseja sair?',  1),
            ('logout_message',  'Logout successfully',  'pt_br',    'Sair com sucesso', 1),
            ('all', 'All',  'pt_br',    'Todos',    1),
            ('add_event',   'Add event',    'pt_br',    'Adicionar Evento', 1),
            ('add_task',    'Add Task', 'pt_br',    'Adicionar tarefa', 1),
            ('next',    'Next', 'pt_br',    'Próxima',  1),
            ('terms_conditions',    'Terms and Conditions', 'pt_br',    'Termos e Condições',   1),
            ('login',   'Login',    'pt_br',    'Conecte-se',   2),
            ('privacy_policay', 'By logging in, you agree to our Terms and Conditions & Privacy Policy',    'pt_br',    'Ao fazer login, você concorda com nossos Termos e Condições e Política de Privacidade',    2),
            ('copyright',   'Copyright © 2020 CRMTiger Version',    'pt_br',    'Direitos autorais © 2020 CRMTiger Versão', 2),
            ('enter_username',  'Please enter username',    'pt_br',    'Por favor insira o nome de usuário',   2),
            ('enter_password',  'Please enter password',    'pt_br',    'Por favor insira a senha', 2),
            ('remanberme',  'Remember Me',  'pt_br',    'Lembre de mim',    2),
            ('forgot_password', 'Forgot password?', 'pt_br',    'Esqueceu sua senha?',  2),
            ('privacy_policay1',    'Privacy Policy',   'pt_br',    'política de Privacidade',  2),
            ('contactsupportmsg',   'Something went wrong. \n please Click here to contact support.',   'pt_br',    'Algo deu errado.\n por favor Clique aqui para entrar em contato com o suporte.',   2),
            ('enter_username_password', 'Entered Username or Password is wrong',    'pt_br',    'Nome de usuário ou senha digitados estão errados', 2),
            ('server_issue_occured',    'Server issues occurred',   'pt_br',    'Ocorreram problemas de servidor',  2),
            ('password',    'Password', 'pt_br',    'Senha',    3),
            ('user_name',   'Username', 'pt_br',    'Nome de usuário',  3),
            ('reset_pwd',   'Reset Password',   'pt_br',    'Redefinir senha',  3),
            ('forgot_password_title',   'Forgot password',  'pt_br',    'Esqueceu sua senha',   3),
            ('enter_user_name', 'Enter user name',  'pt_br',    'Enter user name',  3),
            ('cc',  'Cc',   'pt_br',    'CC',   4),
            ('body',    'Body', 'pt_br',    'Corpo',    4),
            ('bcc', 'BCC',  'pt_br',    'CCO',  4),
            ('dialog_title_text_color', 'Select a Text Color',  'pt_br',    'Select a Text Color',  4),
            ('date',    'Date', 'pt_br',    'Data', 4),
            ('subject', 'Subject',  'pt_br',    'Assunto',  4),
            ('composeMail', 'Compose Mail', 'pt_br',    'Escrever um email',    4),
            ('send',    'Send', 'pt_br',    'Enviar',   4),
            ('select_message',  'Select message',   'pt_br',    'Selecione a mensagem', 4),
            ('title_insert_table',  'Insert Table', 'pt_br',    'Insira a tabela',  4),
            ('log_file_sms',    'I agree to Share API Log to Technical team for further troubleshooting',   'pt_br',    'Concordo em compartilhar o log da API com a equipe técnica para solucionar problemas adicionais',  5),
            ('edit_record', 'Edit Records', 'pt_br',    'Editar registros', 5),
            ('select_time', 'Select Time',  'pt_br',    'Selecione a hora', 5),
            ('edit_item',   'Edit Item',    'pt_br',    'Editar item',  5),
            ('items_total', 'Items Total',  'pt_br',    'Total de itens',   5),
            ('number_less_then_31', 'Number should be less than 31',    'pt_br',    'O número deve ser menor que 31',   5),
            ('users',   'Users',    'pt_br',    'Usuárias', 5),
            ('groups',  'Groups',   'pt_br',    'Grupos',   5),
            ('txt_note_for_file',   'Note : Existing attachments(images/files) will be replaced',   'pt_br',    'Nota: Os anexos existentes (imagens/arquivos) serão substituídos', 5),
            ('greaterdatetime', 'End DateTime should be greater than Start DateTime',   'pt_br',    'End DateTime deve ser maior que Start DateTime',   5),
            ('until',   'Until',    'pt_br',    'Até',  5),
            ('organizations',   'Organizations',    'pt_br',    'Organizações', 6),
            ('contacts',    'Contacts', 'pt_br',    'Contatos', 6),
            ('opportunity', 'Opportunity',  'pt_br',    'Oportunidade', 6),
            ('lbl_sun', 'SUN',  'pt_br',    'SOL',  7),
            ('lbl_mon', 'MON',  'pt_br',    'SEG',  7),
            ('lbl_tue', 'TUE',  'pt_br',    'TER',  7),
            ('lbl_wed', 'WED',  'pt_br',    'QUA',  7),
            ('lbl_thu', 'THU',  'pt_br',    'QUI',  7),
            ('lbl_fri', 'FRI',  'pt_br',    'SEX',  7),
            ('lbl_sat', 'SAT',  'pt_br',    'SENTADA',  7),
            ('lbl_1',   '1',    'pt_br',    '1',    7),
            ('lbl_2',   '2',    'pt_br',    '2',    7),
            ('lbl_3',   '3',    'pt_br',    '3',    7),
            ('lbl_4',   '4',    'pt_br',    '4',    7),
            ('lbl_5',   '5',    'pt_br',    '5',    7),
            ('lbl_6',   '6',    'pt_br',    '6',    7),
            ('lbl_7',   '7',    'pt_br',    '7',    7),
            ('lbl_8',   '8',    'pt_br',    '8',    7),
            ('lbl_9',   '9',    'pt_br',    '9',    7),
            ('lbl_10',  '10',   'pt_br',    '10',   7),
            ('lbl_11',  '11',   'pt_br',    '11',   7),
            ('lbl_12',  '12',   'pt_br',    '12',   7),
            ('lbl_13',  '13',   'pt_br',    '13',   7),
            ('lbl_14',  '14',   'pt_br',    '14',   7),
            ('lbl_15',  '15',   'pt_br',    '15',   7),
            ('lbl_16',  '16',   'pt_br',    '16',   7),
            ('lbl_17',  '17',   'pt_br',    '17',   7),
            ('lbl_18',  '18',   'pt_br',    '18',   7),
            ('lbl_19',  '19',   'pt_br',    '19',   7),
            ('lbl_20',  '20',   'pt_br',    '20',   7),
            ('lbl_21',  '21',   'pt_br',    '21',   7),
            ('lbl_22',  '22',   'pt_br',    '22',   7),
            ('lbl_23',  '23',   'pt_br',    '23',   7),
            ('lbl_24',  '24',   'pt_br',    '24',   7),
            ('lbl_25',  '25',   'pt_br',    '25',   7),
            ('lbl_26',  '26',   'pt_br',    '26',   7),
            ('lbl_27',  '27',   'pt_br',    '27',   7),
            ('lbl_28',  '28',   'pt_br',    '28',   7),
            ('lbl_29',  '29',   'pt_br',    '29',   7),
            ('lbl_30',  '30',   'pt_br',    '30',   7),
            ('lbl_31',  '31',   'pt_br',    '31',   7),
            ('lbl_32',  '32',   'pt_br',    '32',   7),
            ('lbl_33',  '33',   'pt_br',    '33',   7),
            ('lbl_34',  '34',   'pt_br',    '34',   7),
            ('lbl_35',  '35',   'pt_br',    '35',   7),
            ('lbl_36',  '36',   'pt_br',    '36',   7),
            ('lbl_37',  '37',   'pt_br',    '37',   7),
            ('lbl_38',  '38',   'pt_br',    '38',   7),
            ('lbl_39',  '39',   'pt_br',    '39',   7),
            ('lbl_40',  '40',   'pt_br',    '40',   7),
            ('lbl_41',  '41',   'pt_br',    '41',   7),
            ('lbl_42',  '42',   'pt_br',    '42',   7),
            ('current_date',    'current date', 'pt_br',    'data atual',   7),
            ('event',   'Events',   'pt_br',    'Eventos',  7),
            ('calendar',    'Calendar', 'pt_br',    'Calendário',   7),
            ('latest_version',  'Latest Version :', 'pt_br',    'Última versão :',  8),
            ('expire_on',   'Next renewal date : ', 'pt_br',    'Próxima data de renovação:',   8),
            ('ctmobile_ext_version',    'CTMobile Ext. Version : ', 'pt_br',    'CTMobile Ext. Versão:',    8),
            ('you_have_latest_version', 'You already have latest version',  'pt_br',    'Você já tem a versão mais recente',    8),
            ('latest_version1', 'You Already have latest version',  'pt_br',    'Você já tem a versão mais recente',    8),
            ('upgreaded',   'Upgrade',  'pt_br',    'Atualizar',    8),
            ('downgrade',   'Downgrade',    'pt_br',    'Downgrade',    8),
            ('dialog_recent_event_info',    'You can set from here how many number of records you want to show on Home screen for Recent Event.',   'pt_br',    'Você pode definir aqui quantos registros deseja mostrar na tela inicial para evento recente.', 8),
            ('dialog_feedback_info',    'You can submit your feedback with description , our team will check your feedback and get back to you.',   'pt_br',    'Você pode enviar seu feedback com uma descrição, nossa equipe verificará seu feedback e entrará em contato com você.', 8),
            ('dialog_log_info', 'Log functionality is used for customer support / help , If you are facing any issues in app or any module or functionality is not working proper then you can enable share log with our development team.',    'pt_br',    'A funcionalidade de log é usada para suporte / ajuda ao cliente. Se você estiver enfrentando algum problema no aplicativo ou algum módulo ou funcionalidade não estiver funcionando corretamente, você pode ativar o compartilhamento de log com nossa equipe de desenvolvimento.',    8),
            ('info',    'Info', 'pt_br',    'Informações',  8),
            ('recent_history',  'Recent History',   'pt_br',    'História recente', 8),
            ('recent_feedback', 'Feedback', 'pt_br',    'Opinião',  8),
            ('recent_log',  'Log',  'pt_br',    'Registro', 8),
            ('crmtiger_app_version',    'CRMTiger App Version : ',  'pt_br',    'Versão do aplicativo CRMTiger:',   8),
            ('historylimit',    'Recent History Limit', 'pt_br',    'Limite de histórico recente',  8),
            ('radious_in_miles',    'Radius in miles',  'pt_br',    'Raio em milhas',   8),
            ('recentlimit', 'Recent Event Limit',   'pt_br',    'Limite de eventos recentes',   8),
            ('upcoming_events', 'Upcoming Events',  'pt_br',    'próximos eventos', 8),
            ('rate_our_app',    'Rate Our App!',    'pt_br',    'Avalie nosso aplicativo!', 8),
            ('feedback',    'Submit Feedback',  'pt_br',    'Enviar comentários',   8),
            ('sendfeedback',    'Feedback Send',    'pt_br',    'Enviar comentários',   8),
            ('emaillimit',  'Email limit',  'pt_br',    'Limite de e-mail', 8),
            ('log', 'Log',  'pt_br',    'Registro', 8),
            ('logclear',    'Log cleared successfully.',    'pt_br',    'Log limpo com sucesso.',   8),
            ('dialog_recent_history_info',  'You can set from here how many number of records you want to show on Home screen for Recent History.', 'pt_br',    'Você pode definir aqui quantos registros deseja mostrar na tela inicial do histórico recente.',    8),
            ('proceed_to_upgrade1', 'Proceed to',   'pt_br',    'Prossiga para',    8),
            ('upgradation_message', 'will required logout and login again later.',  'pt_br',    'será necessário sair e fazer login novamente mais tarde.', 8),
            ('proceed_to_upgrade',  'Proceed to Upgrade',   'pt_br',    'Prossiga para atualizar',  8),
            ('module_setting',  'Module Setting',   'pt_br',    'Configuração do módulo',   9),
            ('sortbyfield', 'Sort by field',    'pt_br',    'Classificar por campo',    9),
            ('ascending',   'Ascending  A to Z',    'pt_br',    'Subindo de A a Z', 9),
            ('descending',  'Descending  Z to A',   'pt_br',    'Descendo de Z para A', 9),
            ('first_field', 'First Field',  'pt_br',    'Primeiro Campo',   9),
            ('second_field',    'Second Field', 'pt_br',    'Segundo Campo',    9),
            ('third_field', 'Third Field',  'pt_br',    'Terceiro Campo',   9),
            ('sure_want_restore',   'Are you sure you want to reset to default settings?',  'pt_br',    'Tem certeza de que deseja redefinir as configurações padrão?', 9),
            ('orderlist',   'List Order',   'pt_br',    'Ordem da lista',   9),
            ('module_reset',    'Restore to Default',   'pt_br',    'Restaurar para o padrão',  9),
            ('display_fields',  'Display Fields',   'pt_br',    'Campos de exibição',   9),
            ('discount_lessthen_100',   'Discount % should be less than 100',   'pt_br',    'A % de desconto deve ser inferior a 100',  10),
            ('select_item', 'Select Item',  'pt_br',    'Selecionar item',  10),
            ('item_comment',    'Item Comment', 'pt_br',    'Comentário do item',   10),
            ('record_name', 'Record Name is :', 'pt_br',    'O nome do registro é:',    11),
            ('go_back', 'Go Back',  'pt_br',    'Volte',    11),
            ('please_enter_shortcut_name',  'Please Enter Shortcut Name',   'pt_br',    'Digite o nome do atalho',  11),
            ('number_not_found',    'Contact Number not found', 'pt_br',    'Número de contato não encontrado', 11),
            ('mail_not_found',  'Mail Address not found',   'pt_br',    'Endereço de correio não encontrado',   11),
            ('create_shortcut', 'Create Shortcut',  'pt_br',    'Criar atalho', 11),
            ('contact_summary', 'Summary',  'pt_br',    'Resumo',   11),
            ('activites',   'Activities',   'pt_br',    'Atividades',   11),
            ('details', 'Details',  'pt_br',    'Detalhes', 11),
            ('related', 'Related',  'pt_br',    'Relacionada',  11),
            ('share_link',  'Share record with',    'pt_br',    'Compartilhar registro com',    11),
            ('edit',    'Edit', 'pt_br',    'Editar',   11),
            ('duplicate',   'Duplicate',    'pt_br',    'Duplicada',    11),
            ('whatsapp',    'Whatsapp', 'pt_br',    'Whatsapp', 11),
            ('call',    'Call', 'pt_br',    'Chamar',   11),
            ('choose_contact_for_call', 'Choose Contact for Call',  'pt_br',    'Escolha o contato para chamada',   11),
            ('choose_contact_for_sms',  'Choose Contact for SMS',   'pt_br',    'Escolha Contato para SMS', 11),
            ('choose_contact_for_whatsapp', 'Choose Contact for WhatsApp',  'pt_br',    'Escolha Contato para WhatsApp',    11),
            ('chosse_contact_for_email',    'Choose Email', 'pt_br',    'Escolha E-mail',   11),
            ('attach_file', 'Attach Files', 'pt_br',    'Anexar arquivos',  11),
            ('close',   'Close',    'pt_br',    'Fechar',   11),
            ('status',  'Status',   'pt_br',    'Status',   11),
            ('stop',    'Stop', 'pt_br',    'Parar',    11),
            ('zero',    '0',    'pt_br',    '0',    11),
            ('record',  'Record',   'pt_br',    'Registro', 11),
            ('voice_note',  'Voice Note',   'pt_br',    'Nota de voz',  11),
            ('tickets', 'Tickets',  'pt_br',    'Ingressos',    12),
            ('check_out',   'Check Out',    'pt_br',    'Confira',  12),
            ('check_in',    'Check In', 'pt_br',    'Check-in', 12),
            ('select_any',  'Select any',   'pt_br',    'Selecione qualquer',   12),
            ('fulldetails', 'Show Full Details',    'pt_br',    'Mostrar detalhes completos',   12),
            ('checkin', 'Check-in', 'pt_br',    'Check-in', 12),
            ('navigate',    'Navigate', 'pt_br',    'Navegar',  12),
            ('product', 'Products', 'pt_br',    'Produtos', 12),
            ('projectMilestone',    'Project Milestone',    'pt_br',    'Marco do projeto', 12),
            ('projecttask', 'Project Tasks',    'pt_br',    'Tarefas do Projeto',   12),
            ('nearby',  'NearBy',   'pt_br',    'PróximaPróxima',   13),
            ('document',    'Document', 'pt_br',    'Documento',    14),
            ('reply',   'Reply',    'pt_br',    'Responder',    14),
            ('reply_all',   'Reply All',    'pt_br',    'ResponderResponder a todos',   14),
            ('forward', 'Forward',  'pt_br',    'Avançar',  14),
            ('action',  'Action',   'pt_br',    'Ação', 14),
            ('select_first',    'Select First', 'pt_br',    'Selecione primeiro',   14),
            ('commentaddsuccessful',    'Comment added successfull',    'pt_br',    'Comentário adicionado com sucesso',    14),
            ('move_to', 'Move to',  'pt_br',    'Mover para',   14),
            ('attach',  'Attach',   'pt_br',    'Anexar',   14),
            ('addcoment',   'Add Comment',  'pt_br',    'Adicionar comentário', 14),
            ('adddocument', 'Add Document', 'pt_br',    'Adicionar documento',  14),
            ('home',    'Home', 'pt_br',    'Lar',  15),
            ('checkout',    'Check-out',    'pt_br',    'Confira',  15),
            ('message_search',  'Search by name',   'pt_br',    'Procura por nome', 15),
            ('start_shift', 'Start shift',  'pt_br',    'Iniciar turno',    15),
            ('end_shift',   'End shift',    'pt_br',    'Fim do turno', 15),
            ('today_meeting',   'Meetings', 'pt_br',    'Encontros',    15),
            ('shift_time_track',    'Shift Time Track', 'pt_br',    'Faixa de tempo de mudança',    15),
            ('logout_msg',  'You have to login again , click',  'pt_br',    'Você precisa fazer login novamente, clique em',    15),
            ('logout_msg1', 'to continue.', 'pt_br',    'continuar.',   15),
            ('permission_denied',   'You don\'t have permission to create', 'pt_br',    'Você não tem permissão para criar',    15),
            ('history', 'Activity stream',  'pt_br',    'Fluxo de atividades',  15),
            ('search_value',    'Search value :',   'pt_br',    'Valor de pesquisa:',   15),
            ('feed_back_msg',   'Please enter feedback message',    'pt_br',    'Insira uma mensagem de feedback',  16),
            ('feed_back_hint_msg',  'Enter feedback message',   'pt_br',    'Insira a mensagem de feedback',    16),
            ('submit',  'Submit',   'pt_br',    'Enviar',   16),
            ('check_app_not_installed', 'Application is not currently installed.',  'pt_br',    'O aplicativo não está instalado no momento.',  17),
            ('send_sms_fail_message',   'SMS failed, please try again later!',  'pt_br',    'Falha no SMS, tente novamente mais tarde!',    17),
            ('documentaddsuccessfully', 'Document Attach successfully', 'pt_br',    'Documento anexado com sucesso',    17),
            ('send_message',    'Send message', 'pt_br',    'Enviar mensagem',  17),
            ('sms_to',  'smsto:',   'pt_br',    'smsto:',   17),
            ('add_list_message',    'Add List', 'pt_br',    'Adicionar lista',  18),
            ('mylist',  'My List',  'pt_br',    'Minha lista',  18),
            ('filtername',  'Filter Name',  'pt_br',    'Nome do filtro',   18),
            ('selectlist',  'Select a List',    'pt_br',    'Selecione uma lista',  18),
            ('assingedto',  'Assigned To',  'pt_br',    'Atribuído a',  18),
            ('selectmodule',    'Select a module',  'pt_br',    'Selecione um módulo',  18),
            ('add_list',    'Add Filter',   'pt_br',    'Adicionar filtro', 18),
            ('recent_event',    'Recent Event', 'pt_br',    'Evento recente',   19),
            ('recent_hostory',  'Recent History',   'pt_br',    'História recente', 19),
            ('module_specific_settings',    'Module-Specific Settings', 'pt_br',    'Configurações específicas do módulo',  19),
            ('talk_to_us',  'Talk to us',   'pt_br',    'Fale Conosco', 19),
            ('report_a_bug',    'Report A Bug', 'pt_br',    'Reportar um erro', 19),
            ('faq', 'FAQ',  'pt_br',    'Perguntas frequentes', 19),
            ('selectmodules',   'Select Module',    'pt_br',    'Selecione Módulo', 19),
            ('myplan',  'My Plan',  'pt_br',    'Meu plano',    19),
            ('message', 'Message',  'pt_br',    'Mensagem', 20),
            ('message_validation',  'Please enter Message', 'pt_br',    'Por favor insira a mensagem',  20),
            ('contact_select',  'Please Select contact',    'pt_br',    'Por favor selecione contato',  20),
            ('global_search',   'Global Search',    'pt_br',    'Pesquisa Global',  21),
            ('records', 'Records',  'pt_br',    'Registros',    21),
            ('dont_show_again', 'Don\'t Show Again',    'pt_br',    'Não mostre novamente', 22),
            ('skip',    'Skip', 'pt_br',    'Pular',    22),
            ('file_downloading',    'File Downloading', 'pt_br',    'Download de arquivo',  23),
            ('add_screenshots_optional',    'Add screenshots (optional)',   'pt_br',    'Adicione capturas de tela (opcional)', 24),
            ('describe_your_problem',   'Describe your problem',    'pt_br',    'Descreva seu problema',    24),
            ('default_filter_shortcut', 'Default Filter Shortcut',  'pt_br',    'Atalho de filtro padrão',  25),
            ('record_shortcut', 'Record Shortcut',  'pt_br',    'Atalho de gravação',   25),
            ('enter_url',   'Please Enter url', 'pt_br',    'Por favor insira o URL',   26),
            ('new_version_is_avaiable', 'You need to update the app to continue using Please update to continue Older versions will no longer work from today', 'pt_br',    'Você precisa atualizar o aplicativo para continuar usando Atualize para continuar Versões mais antigas não funcionarão mais a partir de hoje', 26),
            ('search_by',   'Search by',    'pt_br',    'Procurar por', 27),
            ('selected_filter', 'Selected filter :',    'pt_br',    'Filtro selecionado:',  27),
            ('selected_field',  'Selected field :', 'pt_br',    'Campo selecionado:',   27),
            ('choose',  'Choose',   'pt_br',    'Escolher', 28),
            ('qr_cardscanner',  'QR Code Scanner',  'pt_br',    'Leitor de código QR',  28),
            ('error_message_for_scan',  'Could not read the card Try again later.', 'pt_br',    'Não foi possível ler o cartão. Tente novamente mais tarde.',   28),
            ('press_start_scan',    'Press to Start Scan',  'pt_br',    'Pressione para iniciar a digitalização',   28),
            ('line_item_quntity_validation_msg',    'Value should be greater than zero',    'pt_br',    'O valor deve ser maior que zero',  29),
            ('percentage_msg',  'Percentage should be less than 100',   'pt_br',    'A porcentagem deve ser inferior a 100',    29),
            ('MSG_NO_DATA', 'No data found!',   'pt_br',    'Nenhum dado encontrado!',  29),
            ('MSG_SOMETHING_WRONG', 'Something went wrong!',    'pt_br',    'Algo deu errado!', 29),
            ('MSG_COMING_SOON', 'Coming Soon!', 'pt_br',    'Em breve!',    29),
            ('MSG_UPLOAD_PROFILE_IMAGE',    'Please upload profile image.', 'pt_br',    'Por favor, carregue a imagem do perfil.',  29),
            ('ALERT_TITLE_LOCATION_ACCESS', 'Location Access',  'pt_br',    'Acesso à localização', 29),
            ('ALERT_MSG_LOCATION_ACCESS',   'Requires your location to show nearby events.',    'pt_br',    'Requer sua localização para mostrar eventos próximos.',    29),
            ('ALERT_BTN_ALLOW', 'ALLOW',    'pt_br',    'PERMITIR', 29),
            ('ALERT_BTN_DENY',  'DENY', 'pt_br',    'NEGAR',    29),
            ('ALERT_MSG_LOCATION_SETTING',  'Not able to fetch your current location. Please allow us to use your location to provide you certain features like, live tracking, route planning and display near by leads, contact, organization, etc. This will help you to plan your on field task as well',   'pt_br',    'Não foi possível buscar sua localização atual. Permita-nos usar sua localização para fornecer certos recursos, como rastreamento ao vivo, planejamento de rota e exibição de leads próximos, contato, organização, etc.',  29),
            ('DELETE_RECORD',   'Delete Record',    'pt_br',    'Apagar registro',  29),
            ('ALERT_MSG_DELETE_SHORTCUT',   'Are you sure want to delete this shortcut?',   'pt_br',    'Tem certeza de que deseja excluir este atalho?',   29),
            ('DELETE_SHORTCUT', 'Delete Shortcut',  'pt_br',    'Excluir atalho',   29),
            ('LBL_TERMS',   'By logging in, you agree to our Terms and',    'pt_br',    'Ao fazer login, você concorda com nossos Termos e',    29),
            ('LBL_CONDITIONS',  'Conditions &', 'pt_br',    'Condições e',  29),
            ('ALERT_TITLE', 'Alert',    'pt_br',    'Alerta',   29),
            ('ALERT_BTN_SUBSCRIBE', 'Subscribe',    'pt_br',    'Se inscrever', 29),
            ('MSG_SELECT_MODULE',   'Please select any Module', 'pt_br',    'Selecione qualquer módulo',    29),
            ('MSG_SELECT_LIST', 'Please select any List',   'pt_br',    'Selecione qualquer lista', 29),
            ('ALERT_MSG_DONT_HAVE_CAMERA',  'You don\'t have camera',   'pt_br',    'Você não tem câmera',  29),
            ('ALERT_MSG_GALLARY_PERMISSION',    'You don\'t have permission to access gallery.',    'pt_br',    'Você não tem permissão para acessar a galeria.',   29),
            ('ALERT_MSG_CAMERA_PERMISSION', 'You don\'t have permission to access camera. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Camera on', 'pt_br',    'Você não tem permissão para acessar a câmera. Vá para configuração -&gt; Role para baixo e selecione Aplicativo CRMTiger -&gt; Ativar câmera', 29),
            ('ALERT_MSG_SPEECH_PERMISSION', 'You don\'t have permission to access Speech Recognition. Go to setting -> Scroll to bottom and select CRMTiger App -> Turn Speech Recognition on', 'pt_br',    'Você não tem permissão para acessar o reconhecimento de fala. Vá para configuração -&gt; Role para baixo e selecione Aplicativo CRMTiger -&gt; Ativar reconhecimento de fala', 29),
            ('BTN_DONE',    'Done', 'pt_br',    'Feita',    29),
            ('COMMENT', 'Comment',  'pt_br',    'Comente',  29),
            ('FULL_FORM',   'Full Form',    'pt_br',    'Formulário completo',  29),
            ('QUICK_CREATE',    'Create',   'pt_br',    'Criar',    29),
            ('LBL_SELECT_FIELDS',   'Select Fields',    'pt_br',    'Selecione os campos',  29),
            ('LBL_SELECT_FIELDS',   'Select Fields',    'pt_br',    'Selecione os campos',  29),
            ('LBL_SELECT_FIRST_FIELDS', 'Select First Field',   'pt_br',    'Selecione o primeiro campo',   29),
            ('LBL_SELECT_SECOND_FIELDS',    'Select Second Field',  'pt_br',    'Selecione o segundo campo',    29),
            ('LBL_SELECT_THIRD_FIELDS', 'Select Third Field',   'pt_br',    'Selecione o terceiro campo',   29),
            ('LBL_SORT_BY_FIELD',   'Select Sort By Field', 'pt_br',    'Selecione Classificar por campo',  29),
            ('BTN_RESET_TO_DEFAULT',    'Reset to Default', 'pt_br',    'Restaurar ao padrão',  29),
            ('MSG_SELECT_SORT_BY_FIELD',    'Select Sort by field', 'pt_br',    'Selecione Classificar por campo',  29),
            ('kStrClearBtnTitle',   'Clear',    'pt_br',    'Clara',    29),
            ('kStrShowMoreBtnTitle',    'Show More',    'pt_br',    'Mostre mais',  29),
            ('kStrAddActivitiesBtnTitle',   'Add Activities',   'pt_br',    'Adicionar atividades', 29),
            ('kStrAddCommentPlaceHolder',   'Add your comments here',   'pt_br',    'Adicione seus comentários aqui',   29),
            ('MSG_ENTER_TO_EMAIL',  'Please enter to field.',   'pt_br',    'Por favor, insira no campo.',  29),
            ('WARNING_FILE',    'File can\'t open.',    'pt_br',    'O arquivo não pode ser aberto.',   29),
            ('MSG_FILE_SAVED',  'File saved.',  'pt_br',    'Arquivo salvo.',   29),
            ('WARNING_DOWNLOAD_FAIL',   'Download fail!, please try after sometime.',   'pt_br',    'Falha no download! Tente depois de algum tempo.',  29),
            ('LBL_SHORTCUT',    'Shortcut', 'pt_br',    'Atalho',   29),
            ('TXT_MESSAGE_PLACEHOLDER', 'Type Message', 'pt_br',    'Digite mensagem',  29),
            ('ALERT_INSTALL_WHATSAPP',  'Install Whatsapp', 'pt_br',    'Instalar Whatsapp',    29),
            ('MSG_NO_MAIL_BOX', 'No MailBox found. Please Create Mailbox',  'pt_br',    'Nenhuma caixa de correio encontrada. Por favor, crie uma caixa de correio',    29),
            ('LBL_WROTE',   'Wrote',    'pt_br',    'Escreveu', 29),
            ('MSG_MAIL_SEND',   'Mail sent',    'pt_br',    'Mail enviado', 29),
            ('log_file_not_found',  'API Log file not found.',  'pt_br',    'Arquivo de log da API não encontrado.',    29),
            ('unknown_error',   'An unknown error occurred, try again', 'pt_br',    'Ocorreu um erro desconhecido, tente novamente',    29),
            ('CTMTigerAppVersion',  'CRMTiger App Version', 'pt_br',    'Versão do aplicativo CRMTiger',    29),
            ('CTMMobileUpdateMsg',  'CTMobile Ext. Version Update Successfully',    'pt_br',    'CTMobile Ext. Atualização de versão com sucesso',  29),
            ('dialog_Premium_downgrade',    'Downgrade will required logout and login again later', 'pt_br',    'O downgrade exigirá logout e login novamente mais tarde',  29),
            ('dialog_Premium',  'Upgrade will required logout and login again later',   'pt_br',    'A atualização exigirá logout e login novamente mais tarde',    29),
            ('Overwrite',   'Overwrite',    'pt_br',    'Substituir',   29),
            ('MSGAddressOverwrite1',    'Overwrite the existing address with the selected', 'pt_br',    'Substitua o endereço existente pelo selecionado',  29),
            ('MSGAddressOverwrite2',    'address details?', 'pt_br',    'Detalhes do Endereço?',    29),
            ('UPGRADE_PLAN',    'Upgrade Plan', 'pt_br',    'Plano de atualização', 29),
            ('DOWNGRADE_PLAN',  'Downgrade Plan',   'pt_br',    'Plano de downgrade',   29),
            ('UPGRADE_EXTENSION',   'Upgrade Extension',    'pt_br',    'Extensão de atualização',  29),
            ('UPGRADE_APP', 'Upgrade App',  'pt_br',    'Atualizar aplicativo', 29),
            ('SELECT_OPTION',   'Select Option',    'pt_br',    'Selecione a opção',    29),
            ('PLEASE_SELECT',   'Please select',    'pt_br',    'Por favor selecione',  29),
            ('MSG_ACCESS_DENIED',   'You don\'t have permission for this module.',  'pt_br',    'Você não tem permissão para este módulo.', 29),
            ('MSG_SELECT_RECCURING_MONTH_DAY',  'Please select reccuring day of month.',    'pt_br',    'Selecione o dia recorrente do mês.',   29),
            ('MSG_SELECT_RECCURING_WEEK_DAY',   'Please select reccuring day of week.', 'pt_br',    'Selecione o dia da semana recorrente.',    29),
            ('MSG_SELECT_RECCURING_DAYS',   'Please select reccuring days.',    'pt_br',    'Please select reccuring days.',    29),
            ('Please select reccuring days.',   'Please select reccuring days.',    'pt_br',    'Selecione dias recorrentes.',  29),
            ('MSG_SELECT_RECCURING_END_DATE',   'Please select reccuring end date.',    'pt_br',    'Selecione uma data de término recorrente.',    29),
            ('MSG_SELECT_RECCURING_TYPE',   'Please select reccuring type.',    'pt_br',    'Selecione o tipo recorrente.', 29),
            ('FREQ_TIME',   'Times',    'pt_br',    'Tempos',   29),
            ('REPEAT_YEARLY',   'Repeat Yearly',    'pt_br',    'Repita anualmente',    29),
            ('REPEAT_MONTHLY',  'Repeat Monthly',   'pt_br',    'Repetir Mensalmente',  29),
            ('REPEAT_WEEKLY',   'Repeat Weekly',    'pt_br',    'Repita semanalmente',  29),
            ('REPEAT_DAILY',    'Repeat Daily', 'pt_br',    'Repita diariamente',   29),
            ('ACTION_TITLE',    'Action Title', 'pt_br',    'Título da ação',   29),
            ('MSG_SELECT_VALID_DATE',   'Please select valid day of month.',    'pt_br',    'Selecione um dia válido do mês.',  29),
            ('MSG_SELECT_VALID_START_DATE', 'Start date should be less than end date.', 'pt_br',    'A data de início deve ser inferior à data de término.',    29),
            ('MSG_SELECT_VALID_START_TIME', 'Start time should be less than end time.', 'pt_br',    'A hora de início deve ser menor que a hora de término.',   29),
            ('LBL_LINEITEM_DETAILS',    'Lineitem Details', 'pt_br',    'Detalhes do item de linha',    29),
            ('MSG_INVALIDE_DISCOUNT_AMOUNT',    'Discount amount should be less than the total.',   'pt_br',    'O valor do desconto deve ser menor que o total.',  29),
            ('VIEW',    'View', 'pt_br',    'Visualizar',   29),
            ('MSG_ENTER_VALID', 'Please enter valid',   'pt_br',    'Por favor insira válido',  29),
            ('MSG_ENTER_PERCENTAGE',    'Percentage should be less than 100.',  'pt_br',    'A porcentagem deve ser inferior a 100.',   29),
            ('ITEM_TOTAL',  'Item Total',   'pt_br',    'Total de itens',   29),
            ('ADJUSTMENT',  'Adjustment',   'pt_br',    'Ajustamento',  29),
            ('TITLE_CHOOSE_IMAGE',  'Choose Image', 'pt_br',    'Escolha a imagem', 29),
            ('COMPRESS',    'Compress', 'pt_br',    'Comprimir',    29),
            ('CHOOSE_ANOTHER_IMAGE',    'Your image size is too large, please select another image',    'pt_br',    'O tamanho da sua imagem é muito grande. Selecione outra imagem',   29),
            ('OnDayOfMonth',    'On day of month',  'pt_br',    'No dia do mês',    29),
            ('OnDayOfWeek', 'On day of week',   'pt_br',    'No dia da semana', 29),
            ('AddAndClose', 'Add & Close',  'pt_br',    'Adicionar e fechar',   29),
            ('Repeat',  'Repeat',   'pt_br',    'Repita',   29),
            ('OnDay',   'On day',   'pt_br',    'Um dia',   29),
            ('View_Line_Item',  'View Line Item',   'pt_br',    'Ver item de linha',    29),
            ('TITLE_IMAGE', 'Image',    'pt_br',    'Imagem',   29),
            ('TITLE_ICLOUD',    'iCloud',   'pt_br',    'iCloud',   29),
            ('GOOGLE',  'Google',   'pt_br',    'Google',   29),
            ('ALERT_BTN_OKAY',  'Okay', 'pt_br',    'OK',   29),
            ('ALERT_TITLE_ACCESS_DENIED',   'Access Denied',    'pt_br',    'Acesso negado',    29),
            ('Dont_Show_Again', 'Don\'t show again',    'pt_br',    'Não mostre novamente', 29),
            ('Skip',    'Skip', 'pt_br',    'Pular',    29),
            ('Fillter_Name',    'Fillter Name', 'pt_br',    'Nome do filtro',   29),
            ('Fillter_Record_Count',    'Fillter Record Count', 'pt_br',    'Filtrar contagem de registros',    29),
            ('url_note',    'Note : if your URL of CRM is https://example.com/crm enter that into above box',   'pt_br',    'Nota: se o seu URL do CRM for https://example.com/crm, insira-o na caixa acima',   26),
            ('vtiger_url',  'Your vTiger CRM URL',  'pt_br',    'Seu URL do vTiger CRM',    26),
            ('msg_doc_read_permission', 'You don\'t have permission to Add either This is read-only or Private Field.', 'pt_br',    'Você não tem permissão para adicionar Este campo é somente leitura ou Privado.',   31),
            ('CLEAR',   'Clear',    'pt_br',    'Clara',    31),
            ('Files/photos uploaded successfully',  'Files/photos uploaded successfully',   'pt_br',    'Arquivos/fotos enviados com sucesso',  32),
            ('Digital signature saved', 'Digital signature saved',  'pt_br',    'Assinatura digital salva', 32),
            ('Please upload Signature or Files/photos', 'Please upload Signature or Files/photos',  'pt_br',    'Faça upload de assinatura ou arquivos/fotos',  32),
            ('Files / Photos',  'Files / Photos',   'pt_br',    'Arquivos / Fotos', 32),
            ('Signature',   'Signature',    'pt_br',    'Assinatura',   32),
            ('add_photo_using', 'Add Photo Using',  'pt_br',    'Adicionar foto usando',    31),
            ('btn_upload_sign', '(+) Add Signature',    'pt_br',    '(+) Adicionar assinatura', 31),
            ('btn_upload_photo_doc',    '(+) Upload Files/Photos',  'pt_br',    '(+) Carregar arquivos/fotos',  31),
            ('select_photo_doc_to_upload',  'Please select files/photos to upload', 'pt_br',    'Selecione os arquivos/fotos para enviar',  31),
            ('related_module_title',    'Search from related module and Add to \"Route\"',  'pt_br',    'Pesquise no módulo relacionado e adicione à \"Rota\"', 30),
            ('Route status updated successfully',   'Route status updated successfully',    'pt_br',    'Status da rota atualizado com sucesso',    32),
            ('Session init failed', 'Session init failed',  'pt_br',    'Falha na inicialização da sessão', 32),
            ('You don\'t have permission to access this resource',  'You don\'t have permission to access this resource',   'pt_br',    'Você não tem permissão para acessar este recurso', 32),
            ('ctroute_realtedto cannot be empty',   'Could not get the Related To - Try again later',   'pt_br',    'Não foi possível obter o relacionado a - tente novamente mais tarde',  32),
            ('ctroute_planning cannot be empty',    'Could not get the Route Planning Record - Try again later',    'pt_br',    'Não foi possível obter o registro de planejamento de rota. Tente novamente mais tarde',    32),
            ('Something went wrong - Try again later',  'Something went wrong - Try again later',   'pt_br',    'Algo deu errado - Tente novamente mais tarde', 32),
            ('sequence updated successfully',   'sequence updated successfully',    'pt_br',    'sequência atualizada com sucesso', 32),
            ('sequence cannot be empty',    'sequence cannot be empty', 'pt_br',    'sequência não pode estar vazia',   32),
            ('Shortcut details not saved',  'Shortcut details not saved',   'pt_br',    'Detalhes do atalho não salvos',    32),
            ('Shortcut details saved successfully', 'Shortcut details saved successfully',  'pt_br',    'Detalhes do atalho salvos com sucesso',    32),
            ('Route save successfully', 'Route save successfully',  'pt_br',    'Rota salva com sucesso',   32),
            ('Record save successfully',    'Record save successfully', 'pt_br',    'Registro salvo com sucesso',   32),
            ('No dependency found for picklist',    'No dependency found for picklist', 'pt_br',    'Nenhuma dependência encontrada para a lista de opções',    32),
            ('No records found',    'No records found', 'pt_br',    'Nenhum registro foi encontrado',   32),
            ('Outgoing server is not enabled, please configure from CRM',   'Outgoing server is not enabled, please configure from CRM',    'pt_br',    'O servidor de saída não está habilitado, configure no CRM',    32),
            ('Removed Successfully',    'Removed Successfully', 'pt_br',    'Removido com sucesso', 32),
            ('Shortcut has been deleted',   'Shortcut has been deleted',    'pt_br',    'O atalho foi excluído',    32),
            ('relation of records removed successfully',    'relation of records removed successfully', 'pt_br',    'relação de registros removidos com sucesso',   32),
            ('relation of records not removed', 'relation of records not removed',  'pt_br',    'relação de registros não removidos',   32),
            ('Record has been deleted successfully',    'Record has been deleted successfully', 'pt_br',    'O registro foi excluído com sucesso',  32),
            ('Time Tracking saved successfully',    'Time Tracking saved successfully', 'pt_br',    'Controle de tempo salvo com sucesso',  32),
            ('Time Tracking updated successfully',  'Time Tracking updated successfully',   'pt_br',    'Controle de tempo atualizado com sucesso', 32),
            ('Time Tracking ended successfully',    'Time Tracking ended successfully', 'pt_br',    'O controle de tempo terminou com sucesso', 32),
            ('Time Tracking started successfully',  'Time Tracking started successfully',   'pt_br',    'O controle de tempo foi iniciado com sucesso', 32),
            ('record cannot be empty',  'record cannot be empty',   'pt_br',    'registro não pode ficar vazio',    32),
            ('Module is disabled',  'Module is disabled',   'pt_br',    'Módulo está desabilitado', 32),
            ('Shift ended successfully',    'Shift ended successfully', 'pt_br',    'Turno finalizado com sucesso', 32),
            ('Shift started successfully',  'Shift started successfully',   'pt_br',    'Turno iniciado com sucesso',   32),
            ('relation of records added successfully',  'relation of records added successfully',   'pt_br',    'relação de registros adicionados com sucesso', 32),
            ('Comment saved successfully',  'Comment saved successfully',   'pt_br',    'Comentário salvo com sucesso', 32),
            ('Comment not saved',   'Comment not saved',    'pt_br',    'Comentário não salvo', 32),
            ('Comment module is not active',    'Comment module is not active', 'pt_br',    'O módulo de comentários não está ativo',   32),
            ('No Upcoming Event',   'No Upcoming Event',    'pt_br',    'Nenhum próximo evento',    32),
            ('No Templates found - create it from Message Templates module',    'No Templates found - create it from Message Templates module', 'pt_br',    'Nenhum modelo encontrado - crie-o no módulo Modelos de mensagens', 32),
            ('No event or task for this date',  'No event or task for this date',   'pt_br',    'Nenhum evento ou tarefa para esta data',   32),
            ('No filters created',  'No filters created',   'pt_br',    'Nenhum filtro criado', 32),
            ('Select at least one record to attach',    'Select at least one record to attach', 'pt_br',    'Selecione pelo menos um registro para anexar', 32),
            ('Please select one or more attachments',   'Please select one or more attachments',    'pt_br',    'Selecione um ou mais anexos',  32),
            ('No event for this month', 'No event for this month',  'pt_br',    'Nenhum evento para este mês',  32),
            ('No Activity found',   'No Activity found',    'pt_br',    'Nenhuma atividade encontrada', 32),
            ('Your feedback is valuable for us - it cannot be empty',   'Your feedback is valuable for us - it cannot be empty',    'pt_br',    'Seu feedback é valioso para nós - não pode ficar vazio',   32),
            ('Could not send mail, Please try later',   'Could not send mail, Please try later',    'pt_br',    'Não foi possível enviar e-mail, tente mais tarde', 32),
            ('Latest Version updated successfully', 'Latest Version updated successfully',  'pt_br',    'Versão mais recente atualizada com sucesso',   32),
            ('User Location Updated Successfully',  'User Location Updated Successfully',   'pt_br',    'Localização do usuário atualizada com sucesso',    32),
            ('User Location not Updated Successfully',  'User Location not Updated Successfully',   'pt_br',    'Localização do usuário não atualizada com sucesso',    32),
            ('SMSNotifier is not enable in CRM. Please enable it first',    'SMSNotifier is not enable in CRM. Please enable it first', 'pt_br',    'SMSNotifier não está habilitado no CRM. Por favor, ative-o primeiro',  32),
            ('Could not submit your feedback - Please try again later', 'Could not submit your feedback - Please try again later',  'pt_br',    'Não foi possível enviar seu feedback. Tente novamente mais tarde.',    32),
            ('Thank you for submitting your feedback',  'Thank you for submitting your feedback',   'pt_br',    'Obrigado por enviar seu feedback', 32),
            ('Please upload User Image',    'Please upload User Image', 'pt_br',    'Faça upload da imagem do usuário', 32),
            ('Image Not Uploading, please try again',   'Image Not Uploading, please try again',    'pt_br',    'A imagem não está sendo carregada, tente novamente',   32),
            ('User Image Uploaded Successfully',    'User Image Uploaded Successfully', 'pt_br',    'Imagem do usuário carregada com sucesso',  32),
            ('Invalid Module name', 'Invalid Module name',  'pt_br',    'Nome de módulo inválido',  32),
            ('Records Sync Successfully',   'Records Sync Successfully',    'pt_br',    'Sincronização de registros com sucesso',   32),
            ('Values cannot be empty',  'Values cannot be empty',   'pt_br',    'Os valores não podem ficar vazios',    32),
            ('Record id is empty',  'Record id is empty',   'pt_br',    'O ID do registro está vazio',  32),
            ('Logout Successfully', 'Logout Successfully',  'pt_br',    'Sair com sucesso', 32),
            ('Please Enable CTMobile Module',   'Please Enable CTMobile Module',    'pt_br',    'Ative o módulo CTMobile',  32),
            ('Authentication Failed',   'Username and Password do not match',   'pt_br',    'Usuário e senha não correspondem', 32),
            ('Mismatched module information',   'Something gone wrong, please try again later', 'pt_br',    'Algo deu errado, tente novamente mais tarde',  32),
            ('Field does not exists',   'Please set display fields again',  'pt_br',    'Defina os campos de exibição novamente',   32),
            ('Module does not exists',  'Module does not exists or disabled by admin',  'pt_br',    'O módulo não existe ou foi desativado pelo administrador', 32),
            ('Month cannot be empty',   'Could not get the Month - Try again later',    'pt_br',    'Não foi possível obter o mês. Tente novamente mais tarde', 32),
            ('Year cannot be empty',    'Could not get the Year - Try again later', 'pt_br',    'Não foi possível obter o ano. Tente novamente mais tarde', 32),
            ('Date cannot be empty',    'Could not get the Date - Try again later', 'pt_br',    'Não foi possível obter a data. Tente novamente mais tarde',    32),
            ('Userid cannot be empty',  'Could not get the Userid - Try again later',   'pt_br',    'Não foi possível obter o ID do usuário. Tente novamente mais tarde',   32),
            ('End Date cannot be empty',    'Could not get the status - Try again later',   'pt_br',    'Não foi possível obter o status. Tente novamente mais tarde',  32),
            ('Start Date cannot be empty',  'Could not get the Start Date - Try again later',   'pt_br',    'Não foi possível obter a data de início. Tente novamente mais tarde',  32),
            ('You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature', 'You do not configure SMS Notifier in CRM. Please configure SMS Notifier in your CRM to use this feature',  'pt_br',    'Você não configura o SMS Notifier no CRM. Configure o SMS Notifier em seu CRM para usar este recurso', 32),
            ('Longitude cannot be empty',   'Could not get location-Please try again',  'pt_br',    'Não foi possível obter a localização. Tente novamente',    32),
            ('Latitude cannot be empty',    'Could not get location-Please try again',  'pt_br',    'Não foi possível obter a localização. Tente novamente',    32),
            ('User cannot be empty',    'Could not get the User - Try again later', 'pt_br',    'Não foi possível obter o usuário. Tente novamente mais tarde', 32),
            ('Status cannot be empty',  'Could not get the status - Try again later',   'pt_br',    'Não foi possível obter o status. Tente novamente mais tarde',  32),
            ('Required fields not found',   'Required fields not found',    'pt_br',    'Campos obrigatórios não encontrados',  32),
            ('Tracking module not active',  'Tracking module not active-Please contact CRM Admin',  'pt_br',    'Módulo de rastreamento não ativo. Entre em contato com o administrador do CRM',    32),
            ('Missing mandatory input values',  'Missing mandatory input values',   'pt_br',    'Valores de entrada obrigatórios ausentes', 32),
            ('No MailBox found. Please Create Mailbox', 'No MailBox found. Please Create Mailbox',  'pt_br',    'Nenhuma caixa de correio encontrada. Por favor, crie uma caixa de correio',    32),
            ('Mail not sent',   'Mail not sent',    'pt_br',    'Correio não enviado',  32),
            ('Mail send successfully',  'Mail send successfully',   'pt_br',    'Email enviado com sucesso',    32),
            ('Email Id or username not match with your record', 'Email Id or username not match with your record',  'pt_br',    'O ID de e-mail ou nome de usuário não corresponde ao seu registro',    32),
            ('Module not specified',    'Module not specified', 'pt_br',    'Módulo não especificado',  32),
            ('No messages found',   'No messages found',    'pt_br',    'Nenhuma mensagem encontrada',  32),
            ('No Dependency Found For This Module', 'No Dependency Found For This Module',  'pt_br',    'Nenhuma dependência encontrada para este módulo',  32),
            ('Outgoing server is not Enabled',  'Outgoing server is not Enabled',   'pt_br',    'O servidor de saída não está habilitado',  32),
            ('Outgoing server is Enabled',  'Outgoing server is Enabled',   'pt_br',    'O servidor de saída está ativado', 32),
            ('Email Attached Successfully', 'Email Attached Successfully',  'pt_br',    'E-mail anexado com sucesso',   32),
            ('Documents Attached Successfully', 'Documents Attached Successfully',  'pt_br',    'Documentos anexados com sucesso',  32),
            ('Login required - Please login again', 'Login required - Please login again',  'pt_br',    'Login necessário - Faça login novamente',  32),
            ('time_tracking_module_disable',    'Time tracking module is disable',  'pt_br',    'O módulo de controle de tempo está desativado',    31),
            ('route_planning_module_disable',   'Route planning module is disable', 'pt_br',    'O módulo de planejamento de rota está desativado', 31),
            ('mark_as_held',    'Are you sure you want to mark Event as Held?', 'pt_br',    'Are you sure you want to mark Event as Held?', 31),
            ('stop_timer_msg',  'You have already started Time tracking for another record, Do you want to stop it first ?',    'pt_br',    'Você já iniciou o monitoramento de tempo para outro registro. Quer interrompê-lo primeiro?',   31),
            ('access_denied_routeplanning', 'Access denied for route planning', 'pt_br',    'Acesso negado para planejamento de rota',  31),
            ('time_spent',  'Time Spent',   'pt_br',    'Tempo gasto',  31),
            ('select_user', 'Select User',  'pt_br',    'Selecione o usuário',  30),
            ('status_cannot_be_held',   'Status cannot be held for future date start',  'pt_br',    'O status não pode ser mantido para início em data futura', 30),
            ('please_select_end_date',  'Please select end date',   'pt_br',    'Selecione a data de término',  30),
            ('please_select_start_date',    'Please select start date', 'pt_br',    'Selecione a data de início',   30),
            ('tap_on_plus_icon_for_select_route',   'Tap on + icon to select record for your route.',   'pt_br',    'Toque no ícone + para selecionar o registro da sua rota.', 30),
            ('please_enter_notes',  'Please enter notes',   'pt_br',    'Por favor insira notas',   30),
            ('please_enter_title',  'Please enter title',   'pt_br',    'Por favor insira o título',    30),
            ('please_select_date',  'Please Select Date',   'pt_br',    'Selecione a data', 30),
            ('search_by_date',  'Search by Date',   'pt_br',    'Pesquisar por data',   30),
            ('shortcut_not_setup_yet',  'Opps shortcut not setup yet!!! Please add shortcut by click on [icon] from record search results or view record screen.',  'pt_br',    'Atalho de operações ainda não configurado!!! Adicione um atalho clicando em [ícone] nos resultados da pesquisa de registros ou visualizando a tela de registro.',  30),
            ('max_upload_size', 'max file Upload exceeds',  'pt_br',    'máximo de upload de arquivo excede',   30),
            ('unselect_all',    'UnSelect All', 'pt_br',    'Desmarque todos',  30),
            ('select_all',  'Select All',   'pt_br',    'Selecionar tudo',  30),
            ('please_select_records',   'Please select records',    'pt_br',    'Selecione os registros',   30),
            ('select_date', 'Select Date',  'pt_br',    'Selecione a data', 30),
            ('quantity_in_stock_is',    'Quantity in stock is', 'pt_br',    'A quantidade em estoque é',    30),
            ('replies', 'Replies',  'pt_br',    'Respostas',    30),
            ('conversation_require_selection',  'Conversion requires selection of Contact or Organization', 'pt_br',    'A conversão requer a seleção de contato ou organização',   30),
            ('please_select_product',   'Please Select Product',    'pt_br',    'Por favor selecione o produto',    30),
            ('timer_msg',   'You can start timer for single task only at same time',    'pt_br',    'Você pode iniciar o cronômetro para uma única tarefa ao mesmo tempo',  31),
            ('save_start_tracking', 'Save & Start Tracking',    'pt_br',    'Salve e comece a rastrear',    31),
            ('lbl_notes',   'Notes',    'pt_br',    'Notas',    31),
            ('enter_title', 'Enter Title',  'pt_br',    'Insira o título',  31),
            ('select_module_record',    'Select Module / Record',   'pt_br',    'Selecione Módulo/Registro',    31),
            ('lbl_tomorrow',    'Tomorrow', 'pt_br',    'Amanhã',   30),
            ('lbl_yesterday',   'Yesterday',    'pt_br',    'Ontem',    30),
            ('lbl_today',   'Today',    'pt_br',    'Hoje', 30),
            ('time_tracker',    'Time Tracker', 'pt_br',    'Rastreador de tempo',  31),
            ('time_end',    'End Time', 'pt_br',    'Fim do tempo', 5),
            ('due_date',    'End Date', 'pt_br',    'Data final',   5),
            ('time_start',  'Time Start',   'pt_br',    'Início da hora',   5),
            ('date_start',  'Start Date',   'pt_br',    'Data de início',   5),
            ('delete_widget_msg',   'Display widget again by using (+) option', 'pt_br',    'Exibir o widget novamente usando a opção (+)', 15),
            ('no_upcoming_activities',  'No scheduled activities    ',  'pt_br',    'Não há atividades programadas',    15),
            ('check_in_first',  'Please check-in first',    'pt_br',    'Por favor, faça o check-in primeiro',  30),
            ('duration',    'Duration', 'pt_br',    'Duração',  30),
            ('distance',    'Distance', 'pt_br',    'Distância',    30),
            ('proper_address_message',  'Please enter proper address in record\n',  'pt_br',    'Por favor insira o endereço correto no registro',  30),
            ('select_status',   'Select Status',    'pt_br',    'Selecione o status',   30),
            ('route_planner',   'Route Planner',    'pt_br',    'Planejador de rota',   30),
            ('route_planning',  'Route Planning',   'pt_br',    'Planejamento de rota', 30),
            ('add_route',   'Add Route',    'pt_br',    'Adicionar rota',   30),
            ('calender_disabled',   'Calendar Module is disabled',  'pt_br',    'O módulo Calendário está desativado',  30),
            ('close_dialog',    'Close form',   'pt_br',    'Fechar formulário',    30),
            ('cancel_form_message', 'Are You sure want to close ?', 'pt_br',    'Tem certeza de que deseja fechar?',    30),
            ('create_route',    'Create Route', 'pt_br',    'Criar rota',   30),
            ('select_module_create_route',  'Select Module to create Route',    'pt_br',    'Selecione o módulo para criar a rota', 30),
            ('cancel',  'Cancel',   'pt_br',    'Cancelar', 30),
            ('assign_route',    'Assign Route', 'pt_br',    'Atribuir rota',    30),
            ('route_for',   'Route for',    'pt_br',    'Rota para',    30),
            ('assigned_to', 'Assigned To',  'pt_br',    'Atribuído a',  30),
            ('enter_route_name',    'Enter Route Name', 'pt_br',    'Insira o nome da rota',    30),
            ('list',    'List', 'pt_br',    'Lista',    30),
            ('map', 'Map',  'pt_br',    'Mapa', 30),
            ('other_modules',   'Other Modules',    'pt_br',    'Outros Módulos',   15),
            ('shortcut_no_record_msg',  'Opps shortcut not setup\n yet!!! Please add shortcut  by click on + icon from record\n search results or view record screen.', 'pt_br',    'Atalho de operações não configurado\n ainda!!! Adicione um atalho clicando no ícone + do registro\n resultados de pesquisa ou visualização da tela de registro.',  25),
            ('clear',   'Clear',    'pt_br',    'Clara',    25),
            ('open',    'Open', 'pt_br',    'Abrir',    11),
            ('max_file_msg',    'Too many files selected (max:6)',  'pt_br',    'Muitos arquivos selecionados (máx.: 6)',   11),
            ('error_voicenote_record',  'Unable to recording voice while another application is recording sound.',  'pt_br',    'Não é possível gravar voz enquanto outro aplicativo grava som.',   11),
            ('msg_warning', 'Warning!', 'pt_br',    'Aviso!',   11),
            ('Permision_denied_contact',    'Permission denied to access your contacts',    'pt_br',    'Permissão negada para acessar seus contatos',  15),
            ('no_widget_added', 'Please click + icon to add new widget to your dashboard.', 'pt_br',    'Clique no ícone + para adicionar um novo widget ao seu painel.',   15),
            ('no_data_available',   'Data not available, please check the selected fields', 'pt_br',    'Dados não disponíveis, verifique os campos selecionados',  15),
            ('check_out_successfully',  'Check out successfully',   'pt_br',    'Confira com sucesso',  11),
            ('check_in_successfully',   'Check in successfully',    'pt_br',    'Check-in efetuado com sucesso',    11),
            ('check_out',   'Check out',    'pt_br',    'Confira',  11),
            ('check_in',    'Check in', 'pt_br',    'Check-in', 11),
            ('navigate',    'Navigate', 'pt_br',    'Navegar',  11),
            ('save_to_phone_vcard_success', 'VCard Saved to phone successfully',    'pt_br',    'VCard salvo no telefone com sucesso',  15),
            ('download_vcard_success',  'VCard downloaded successfully',    'pt_br',    'VCard baixado com sucesso',    15),
            ('card_details',    'Card Details', 'pt_br',    'Detalhes do cartão',   15),
            ('add_widget',  'Add Widget',   'pt_br',    'Adicionar widget', 15),
            ('delete_widget',   'Are you sure to hide widget?', 'pt_br',    'Tem certeza de ocultar o widget?', 15),
            ('already_widgets_added',   'All types of Widget & reports are already added',  'pt_br',    'Todos os tipos de widgets e relatórios já foram adicionados',  15),
            ('retry',   'Retry',    'pt_br',    'Tentar novamente', 28),
            ('retake',  'Retake',   'pt_br',    'Retomar',  28),
            ('Reports', 'Reports',  'pt_br',    'Relatórios',   15),
            ('Widgets', 'Widgets',  'pt_br',    'Widgets',  15),
            ('vcard_config',    'Vcard Configuration',  'pt_br',    'Configuração do Vcard',    8),
            ('save_to_phone',   'Save to phone',    'pt_br',    'Salvar no telefone',   11),
            ('download_vcard',  'Download Vcard',   'pt_br',    'Baixar Vcard', 11),
            ('share_vcard', 'Share Vcard',  'pt_br',    'Compartilhe Vcard',    11),
            ('share_record',    'Share Record', 'pt_br',    'Compartilhar registro',    11),
            ('permission_denied_edit',  'You don\'t have permission to edit this record.',  'pt_br',    'Você não tem permissão para editar este registro.',    27),
            ('permission_denied_delete',    'You don\'t have permission to delete this record.',    'pt_br',    'Você não tem permissão para excluir este registro.',   27),
            ('Voice_Recording_Started', 'Recording Started',    'pt_br',    'Gravação iniciada',    12),
            ('Voice_Recording_Stopped', 'Recording Stopped',    'pt_br',    'Gravação interrompida',    12),
            ('SEARCH',  'Search',   'pt_br',    'Procurar', 7),
            ('LAST',    'Last', 'pt_br',    'Durar',    7),
            ('FIRST',   'First',    'pt_br',    'Primeira', 7),
            ('MONDAY',  'Monday',   'pt_br',    'Segunda-feira',    7),
            ('TUESDAY', 'Tuesday',  'pt_br',    'Terça-feira',  7),
            ('WEDNESDAY',   'Wednesday',    'pt_br',    'Quarta-feira', 7),
            ('THURSDAY',    'Thursday', 'pt_br',    'Quinta-feira', 7),
            ('FRIDAY',  'Friday',   'pt_br',    'Sexta-feira',  7),
            ('SATURDAY',    'Saturday', 'pt_br',    'Sábado',   7),
            ('SUNDAY',  'Sunday',   'pt_br',    'Domingo',  7),
            ('DAILY',   'Daily',    'pt_br',    'Diária',   7),
            ('WEEKLY',  'Weekly',   'pt_br',    'Semanalmente', 7),
            ('MONTHLY', 'Monthly',  'pt_br',    'Por mês',  7),
            ('YEARLY',  'Yearly',   'pt_br',    'Anual',    7),
            ('asset_tracking',  'Asset tracking',   'pt_br',    'Acompanhamento de bens',   15),
            ('open_file',   'Open File',    'pt_br',    'Abrir arquivo',    1),
            ('download_pdf_successfully',   'Download PDF Successfully',    'pt_br',    'Baixe o PDF com sucesso',  1),
            ('select_pdf',  'Select PDF',   'pt_br',    'Selecione PDF',    1),
            ('email_pdf',   'Email PDF',    'pt_br',    'Enviar PDF por e-mail',    1),
            ('download_pdf',    'Download PDF', 'pt_br',    'baixar PDF',   1),
            ('edit_route',  'Edit Route',   'pt_br',    'Editar rota',  1),
            ('save_route',  'Save Route',   'pt_br',    'Salvar rota',  1),
            ('clear_all',   'Clear All',    'pt_br',    'Limpar tudo',  1),
            ('notification',    'Notifications',    'pt_br',    'Notificações', 1),
            ('menu_management', 'Menu Management',  'pt_br',    'Gerenciamento de cardápio',    1),
            ('select_menu', 'Select Menu',  'pt_br',    'Selecione o menu', 1),
            ('module_record_not_found', 'Module and Record not found',  'pt_br',    'Módulo e registro não encontrados',    1),
            ('reason_for_changing_comments',    'Reason for changing comments', 'pt_br',    'Motivo para alterar comentários',  1),
            ('edit_reason', 'Edit Reason',  'pt_br',    'Editar motivo',    1),
            ('create_filters',  'Create Filter',    'pt_br',    'Criar filtro', 1),
            ('you_checked', 'You Checked',  'pt_br',    'Você verificou',   1),
            ('you_un_checked',  'You UnChecked',    'pt_br',    'Você desmarcou',   1),
            ('log_the_call',    'Log the call ?',   'pt_br',    'Registrar a chamada?', 1),
            ('add_a_description_(optional)',    'Add a description (optional)', 'pt_br',    'Adicione uma descrição (opcional)',    1),
            ('called',  'Called',   'pt_br',    'Chamado',  1),
            ('call_log',    'Call Log', 'pt_br',    'Registro de chamadas', 1),
            ('subject', 'Subject',  'pt_br',    'Assunto',  1),
            ('add_condition',   'Add Condition',    'pt_br',    'Adicionar condição',   1),
            ('select_condition',    'Select Condition', 'pt_br',    'Selecione a condição', 1),
            ('select_field',    'Select Field', 'pt_br',    'Selecione o campo',    1),
            ('please_select_first_field',   'Please First Select field',    'pt_br',    'Selecione primeiro o campo',   1),
            ('filter_name', 'Filter Name',  'pt_br',    'Nome do filtro',   1),
            ('enter_filter_name',   'Enter filter name',    'pt_br',    'Insira o nome do filtro',  1),
            ('choose_conditions',   'Choose Conditions',    'pt_br',    'Escolha as condições', 1),
            ('all_condition',   'All Conditions(All conditions must be met)',   'pt_br',    'Todas as condições(Todas as condições devem ser atendidas)',   1),
            ('any_condition',   'Any Conditions(At least one the conditions must be met)',  'pt_br',    'Quaisquer condições (pelo menos uma das condições deve ser atendida)', 1),
            ('lattitude',   'latitude', 'pt_br',    'latitude', 1),
            ('notification_settings',   'Notification Settings',    'pt_br',    'Configurações de notificação', 1),
            ('notification_management', 'Notification Management',  'pt_br',    'Gerenciamento de Notificações',    1),
            ('addyourcommentshere', 'Type @ to mention user',   'pt_br',    'Digite @ para mencionar o usuário',    1),
            ('google_api_key_missing',  'Google Api key is missing.',   'pt_br',    'A chave da API do Google está faltando.',  1),
            ('event_filter_by', 'Event Filter by',  'pt_br',    'Filtrar eventos por',  1),
            ('apply',   'Apply',    'pt_br',    'Aplicar',  1),
            ('choose_from_gallery', 'Choose From Gallery',  'pt_br',    'Escolha da galeria',   1),
            ('choose_from_camera',  'Choose From Camera',   'pt_br',    'Escolha da galeria',   1),
            ('mutli_select_CB', 'Mutli Select CB',  'pt_br',    'CB de seleção múltipla',   1),
            ('please_select_condition', 'Please Select Condition',  'pt_br',    'Selecione a condição', 1),
            ('please_enter_value_or_field', 'Please Enter Value or Field',  'pt_br',    'Insira o valor ou campo',  1),
            ('set_as_default',  'Set as Default',   'pt_br',    'Definir como padrão',  1),
            ('list_in_metrics', 'List in Metrics',  'pt_br',    'Listar em métricas',   1),
            ('order_number',    'Order Number', 'pt_br',    'Número do pedido', 1),
            ('recording_saved_message', 'Recording saved successfully.',    'pt_br',    'Gravação salva com sucesso.',  1),
            ('recording_file',  'Recording File',   'pt_br',    'Arquivo de Gravação',  1),
            ('file_not_found',  'File not found',   'pt_br',    'Arquivo não encontrado',   1),
            ('please_enter_valid_path', 'Please enter valid path',  'pt_br',    'Por favor insira um caminho válido',   1),
            ('enter_path_here', 'Enter path here...',   'pt_br',    'Insira o caminho aqui...', 1),
            ('set_call_recording_path', 'Set Call Recording Path',  'pt_br',    'Definir caminho de gravação de chamadas',  1),
            ('set_call_recording_path_here',    'Set call recording path here', 'pt_br',    'Defina o caminho de gravação de chamadas aqui',    1),
            ('call_recording_path', 'Call Recording Path',  'pt_br',    'Caminho de gravação de chamadas',  1),
            ('please_place_api',    'Please enable place api',  'pt_br',    'Ative a API do local', 1),
            ('event_filters_by',    'Event Filters by', 'pt_br',    'Filtros de eventos por',   1),
            ('select_at_least_one_option',  'Please select at least one option',    'pt_br',    'Selecione pelo menos uma opção',   1),
            ('enable_call_feature', 'Please enable call feature',   'pt_br',    'Ative o recurso de chamada',   1),
            ('enable_email_feature',    'Please enable email feature',  'pt_br',    'Ative o recurso de e-mail',    1),
            ('demo_login',  'Demo Login',   'pt_br',    'Login de demonstração',    1),
            ('select_email_template',   'Select Email Template',    'pt_br',    'Selecione o modelo de e-mail', 1),
            ('template_name',   'Template Name',    'pt_br',    'Nome do modelo',   1),
            ('example_storage_path',    'example : storage/Music/Recordings/Call Recordings',   'pt_br',    'exemplo: armazenamento/música/gravações/gravações de chamadas',    1),
            ('User Notification Settings saved successfully',   'User Notification Settings saved successfully',    'pt_br',    'Configurações de notificação do usuário salvas com sucesso',   33),
            ('This Notification has been disabled by admin',    'This Notification has been disabled by admin', 'pt_br',    'Esta notificação foi desativada pelo administrador',   33),
            ('Notify when any updates to the record you\'re following', 'Notify when any updates to the record you\'re following',  'pt_br',    'Notificar quando houver atualizações no registro que você está seguindo',  33),
            ('Task assigned to you',    'Task assigned to you', 'pt_br',    'Tarefa atribuída a você',  33),
            ('Task Reminder',   'Task Reminder',    'pt_br',    'Lembrete de tarefa',   33),
            ('You were mentioned in comments',  'You were mentioned in comments',   'pt_br',    'Você foi mencionado nos comentários',  33),
            ('Comments has been added to record assigned to you',   'Comments has been added to record assigned to you',    'pt_br',    'Comentários foram adicionados ao registro atribuído a você',   33),
            ('When Record Assigned',    'When Record Assigned', 'pt_br',    'Quando o registro é atribuído',    33),
            ('Event Reminder',  'Event Reminder',   'pt_br',    'Lembrete de evento',   33),
            ('Event Invitation',    'Event Invitation', 'pt_br',    'Convite para Evento',  33),
            ('Follow record',   'Follow record',    'pt_br',    'Seguir registro',  33),
            ('Task',    'Task', 'pt_br',    'Tarefa',   33),
            ('Conversions', 'Conversions',  'pt_br',    'Conversões',   33),
            ('Events',  'Events',   'pt_br',    'Eventos',  33),
            ('no_records_changed_filter_message',   'No record(s) found Please click on filter icon to change filter',  'pt_br',    'Nenhum registro(s) encontrado(s) Clique no ícone de filtro para alterar o filtro', 1),
            ('title',   'Title',    'pt_br',    'Título',   1),
            ('dialog_recent_call_info', 'Click + to select your mobile call recording folder where your recorded call files are stored.',   'pt_br',    'Clique em + para selecionar a pasta de gravação de chamadas do seu celular onde os arquivos de chamadas gravadas são armazenados.',    1),
            ('call_recording',  'Call recording',   'pt_br',    'Gravação de chamadas', 1),
            ('voice_recorder',  'Voice Recorder',   'pt_br',    'Gravador de voz',  1),
            ('no_address_reference_found',  'No Address Reference found',   'pt_br',    'Nenhuma referência de endereço encontrada',    32),
            ('no_overdue_activities',   'No OverDue Activities',    'pt_br',    'Nenhuma atividade atrasada',   32),
            ('latitude_longitude_validation_message',   'Please enter proper address from this address we are not getting proper latitude and longitude',   'pt_br',    'Por favor, insira o endereço correto deste endereço, não estamos obtendo latitude e longitude adequadas',  32),
            ('Default_Search_Field',    'Default search field', 'pt_br',    'Campo de pesquisa padrão', 32),
            ('Calender_Reminder_Message',   'Free user can\'t send local reminder', 'pt_br',    'O usuário gratuito não pode enviar lembrete local',    32),
            ('you_must_have_permission',    'You must give permissions to use this features.',  'pt_br',    'Você deve conceder permissões para usar esses recursos.',  32),
            ('internal_comment',    'Internal Comment', 'pt_br',    'Comentário interno',   1),
            ('unlink_record',   'Unlink Record',    'pt_br',    'Desvincular registro', 11),
            ('unlink_record_msg',   'Are you sure want to unlink record?',  'pt_br',    'Tem certeza de que deseja desvincular o registro?',    11),
            ('file_format_not_support', 'File format not supported',    'pt_br',    'Formato de arquivo não suportado', 11),
            ('file_upload', 'File Upload',  'pt_br',    'Upload de arquivo',    5),
            ('to_vtiger',   'To Vtiger',    'pt_br',    'Para Vtiger',  5),
            ('link_external_document',  'Link External Document',   'pt_br',    'Vincular documento externo',   5),
            ('from_file_url',   'From File Url',    'pt_br',    'Do URL do arquivo',    5),
            ('create_new_document', 'Create New Document',  'pt_br',    'Criar novo documento', 5),
            ('select_document_type',    'Select Document type', 'pt_br',    'Selecione o tipo de documento',    5),
            ('add_signature',   'Please add signature', 'pt_br',    'Adicione assinatura',  11),
            ('date_greater_then_equal', 'should be greater than or equal to',   'pt_br',    'should be greater than or equal to',   1),
            ('date_less_then_equal',    'should be less than or equal to',  'pt_br',    'deve ser menor ou igual a',    1),
            ('Click_on_plus_for_add',   'Please tap on  +  to create a new record.',    'pt_br',    'Toque em + para criar um novo registro.',  15),
            ('display_map', 'Display map',  'pt_br',    'Exibir mapa',  15),
            ('other_settings',  'Other settings',   'pt_br',    'Outros ajustes',   15),
            ('total_hours', 'Total hours',  'pt_br',    'Total de horas',   15),
            ('widget_not_found',    'No widgets found', 'pt_br',    'Nenhum widget encontrado', 15),
            ('quickaction', 'Quick action', 'pt_br',    'Ação rápida',  15),
            ('dashboard',   'Dashboard',    'pt_br',    'Painel',   15),
            ('new', 'New',  'pt_br',    'Nova', 15),
            ('global_search_hint',  'Please try to search using search box at top', 'pt_br',    'Por favor, tente pesquisar usando a caixa de pesquisa na parte superior',  15),
            ('near_by_map', 'Near By Map',  'pt_br',    'Perto do mapa',    15),
            ('miles',   'Miles',    'pt_br',    'Milhas',   15),
            ('lbl_filters', 'Filters',  'pt_br',    'Filtros',  27),
            ('warning', 'Warning',  'pt_br',    'Aviso',    27),
            ('no_filter_created',   'No filter is created.',    'pt_br',    'Nenhum filtro é criado.',  27),
            ('please_create_new_ilter', 'Please create a new filter',   'pt_br',    'Por favor, crie um novo filtro',   27),
            ('select_search_fields',    'Select fields for the search record.', 'pt_br',    'Selecione campos para o registro de pesquisa.',    27),
            ('apply_fliters',   'Apply filters',    'pt_br',    'Apply filters',    27),
            ('sort_by', 'Sort by',  'pt_br',    'Ordenar por',  27),
            ('sort_order',  'Sort order',   'pt_br',    'Ordem de classificação',   27),
            ('Start_time_tracking', 'Start time tracking',  'pt_br',    'Iniciar rastreamento de tempo',    31),
            ('Stop_time_tracking',  'Stop time tracking',   'pt_br',    'Parar o monitoramento do tempo',   31),
            ('image_preview',   'Image preview',    'pt_br',    'Pré-visualização de imagem',   11),
            ('phone_number',    'Phone number', 'pt_br',    'Número de telefone',   11),
            ('email_address',   'Email address',    'pt_br',    'Endereço de email',    11),
            ('edit_your_preferences',   'Edit your preferences',    'pt_br',    'Edite suas preferências',  8),
            ('about_app',   'About app',    'pt_br',    'Sobre o aplicativo',   8),
            ('updated_ctmobile_ext_version',    'You already have latest CTMobile Ext. Version',    'pt_br',    'Você já possui o CTMobile Ext mais recente. Versão',   8),
            ('updated_app_version', 'You already have latest CRMTiger App Version', 'pt_br',    'Você já tem a versão mais recente do aplicativo CRMTiger', 8),
            ('plan',    'Plan', 'pt_br',    'Plano',    8),
            ('time',    'Time', 'pt_br',    'Tempo',    31),
            ('error_log_msg',   'Oops, something went wrong! Please click on Share Button to share error log with our technical team',  'pt_br',    'Ops, algo deu errado! Clique no botão Compartilhar para compartilhar o log de erros com nossa equipe técnica', 1),
            ('add_to_quick_action', 'Add to quick action',  'pt_br',    'Adicionar à ação rápida',  1),
            ('add_filter_to_quick_action',  'Add filter to quick action',   'pt_br',    'Adicionar filtro à ação rápida',   1),
            ('create_record',   'Create Record',    'pt_br',    'Criar registro',   1),
            ('quick_action_hint',   'You can Add Quick Action here',    'pt_br',    'Você pode adicionar ação rápida aqui', 1),
            ('str_send',    'Send', 'pt_br',    'Enviar',   3),
            ('tax_region_msg',  'Do you want to update tax & charge values corresponding to selected region?',  'pt_br',    'Deseja atualizar os valores de impostos e cobranças correspondentes à região selecionada?',    1),
            ('delete_quick_action_widgest', 'Delete Widget?',   'pt_br',    'Excluir widget?',  15),
            ('add_record_to_dashboard', 'Add record to dashboard',  'pt_br',    'Adicionar registro ao painel', 15),
            ('module_quick_action_msg', 'Module added to dashboard',    'pt_br',    'Módulo adicionado ao painel',  15),
            ('filter_quick_action_msg', 'Filter added to dashboard',    'pt_br',    'Filtro adicionado ao painel',  15),
            ('record_quick_action_msg', 'Record added to dashboard',    'pt_br',    'Registro adicionado ao painel',    15),
            ('filter_shortcut_quick_action_msg',    'Filter shortcut added to dashboard',   'pt_br',    'Atalho de filtro adicionado ao painel',    15),
            ('record_shortcut_quick_action_msg',    'Record shortcut added to dashboard',   'pt_br',    'Atalho de registro adicionado ao painel',  15),
            ('documents_disabled',  'Documents Module is disabled', 'pt_br',    'Módulo Documentos está desativado',    1),
            ('document_dont_attachment',    'Document does not have a attachment',  'pt_br',    'O documento não possui anexo', 1),
            ('go_to_neat_by',   'Go to NearBy', 'pt_br',    'Vá para Perto',    15),
            ('go_to_time_tracking', 'Go to Time Tracker',   'pt_br',    'Vá para o Rastreador de TempoVá para o Rastreador de Tempo',   13),
            ('nearby_quick_action_msg', 'NearBy added to dashboard',    'pt_br',    'NearBy adicionado ao painel',  15),
            ('time_tracking_quick_action_msg',  'Time Tracking added to dashboard', 'pt_br',    'Controle de tempo adicionado ao painel',   15),
            ('attendance_quick_action_msg', 'Attendance added to dashboard',    'pt_br',    'Presença adicionada ao painel',    15),
            ('attachment',  'Attachment',   'pt_br',    'Anexo',    15),
            ('search_by_fields',    'Search by fields', 'pt_br',    'Pesquisar por campos', 27),
            ('apply_selected',  'Apply selected',   'pt_br',    'Aplicar selecionado',  27),
            ('auto_address_disabled',   'auto address finder is disabled, please enable it from CRMTiger Settings', 'pt_br',    'o localizador automático de endereço está desativado, ative-o nas configurações do CRMTiger',  1),
            ('Attendance',  'Attendance',   'pt_br',    'Comparecimento',   15),
            ('Check-in successfully',   'Check-in successfully',    'pt_br',    'Check-in com sucesso', 32),
            ('Check-out successfully',  'Check-out successfully',   'pt_br',    'Check-out com sucesso',    32),
            ('Nothing around here', 'Nothing around here',  'pt_br',    'Nada por aqui',    13),
            ('select_days', 'Select Days',  'pt_br',    'Selecione os dias',    5),
            ('select_minutes',  'Select Minutes',   'pt_br',    'Selecione Minutos',    5),
            ('select_hours',    'Select Hours', 'pt_br',    'Selecione o horário',  5),
            ('no_lat_long_found',   'Location information (Latitude,Longitude) not found',  'pt_br',    'Informações de localização (latitude, longitude) não encontradas', 32),
            ('Call Log save successfully',  'Call Log save successfully',   'pt_br',    'Registro de chamadas salvo com sucesso',   32),
            ('Files/photos deleted successfully',   'Files/photos deleted successfully',    'pt_br',    'Arquivos/fotos excluídos com sucesso', 32),
            ('important',   'Important',    'pt_br',    'Importante',   34),
            ('template',    'Template', 'pt_br',    'Modelo',   34),
            ('copy',    'Copy', 'pt_br',    'cópia de', 34),
            ('camera',  'Camera',   'pt_br',    'Câmera',   34),
            ('gallery', 'Gallery',  'pt_br',    'Galeria',  34),
            ('audio',   'Audio',    'pt_br',    'Áudio',    34),
            ('last_seen_at',    'Last seen at', 'pt_br',    'Visto por último em',  34),
            ('type_a_message',  'Type a message',   'pt_br',    'Digite uma mensagem',  34),
            ('all_messages',    'All messages', 'pt_br',    'Todas as mensagens',   34),
            ('time_tracking_reports',   'Time tracking reports',    'pt_br',    'Relatórios de controle de tempo',  31),
            ('attendance_reports',  'Attendance reports',   'pt_br',    'Relatórios de presença',   31),
            ('chats',   'Chats',    'pt_br',    'Bate-papos',   34),
            ('Marked chat as Important',    'Marked chat as Important', 'pt_br',    'Bate-papo marcado como importante',    34),
            ('Unmarked chat as Important',  'Unmarked chat as Important',   'pt_br',    'Bate-papo desmarcado como importante', 34),
            ('mark_as_important',   'Mark as important',    'pt_br',    'Marcar como importante',   34),
            ('unmark_As_important', 'Unmark as important',  'pt_br',    'Desmarcar como importante',    34),
            ('select_template', 'Select template',  'pt_br',    'Selecione o modelo',   34),
            ('chat',    'Chat', 'pt_br',    'Bater papo',   34),
            ('search_by_name_or_contact',   'Search by name or contact',    'pt_br',    'Pesquisar por nome ou contato',    34),
            ('choose_contact_for_whatsApp', 'Choose contact for whatsApp',  'pt_br',    'Escolha o contato para o WhatsApp',    34),
            ('whatsapp_template',   'Whatsapp template',    'pt_br',    'Modelo Whatsapp',  34),
            ('send_voice_recording',    'Send voice recording', 'pt_br',    'Enviar gravação de voz',   34),
            ('slide_to_cancel', 'Slide To Cancel',  'pt_br',    'Deslize para cancelar',    34),
            ('select_priority', 'Select priority',  'pt_br',    'Select priority',  30),
            ('repeat_route',    'Repeat route', 'pt_br',    'Repeat route', 30),
            ('change_assign_to',    'Change assigned to',   'pt_br',    'Change assigned to',   30),
            ('Multiple Route created successfully', 'Multiple Route created successfully',  'pt_br',    'Rota múltipla criada com sucesso', 30),
            ('Route duplicated successfully',   'Route duplicated successfully',    'pt_br',    'Rota duplicada com sucesso',   30);",array());
        }
    }


    static function CTMobileUserAccess() {
        global $adb;
        
        $ctmobile_access_Users =$adb->pquery("SELECT * FROM `ctmobile_access_users` ",array());
        if($adb->num_rows($ctmobile_access_Users) == 0 ){
            //Insert Defaullt Users in ctmobile_access_users Table
            $Users =$adb->pquery("SELECT * FROM `vtiger_users` WHERE deleted = 0 AND status = ?",array('Active'));
            $userArray = array();
            for($i=0;$i<($adb->num_rows($Users));$i++){
            $id = $adb->query_result($Users,$i,'id');
            $adb->pquery("INSERT INTO `ctmobile_access_users` (`userid`) VALUES (?)",array($id));
            }
            
        }
        
    }

 
    /**
     * Add CTMobileSettings Widgets at CRM Settings > Other Settings
     * parameters None.
     * @return None
     */
    static function addWidgetTo() {
        global $adb;
        $widgetType = 'HEADERSCRIPT';
        $widgetName = 'CTMobileSettingsJS';
        $link = 'layouts/vlayout/modules/CTMobileSettings/resources/CTMobileSettings.js';
        include_once 'vtlib/Vtiger/Module.php';

        $moduleNames = array('CTMobileSettings');
        foreach($moduleNames as $moduleName) {
            $module = Vtiger_Module::getInstance($moduleName);
            if($module) {
                $module->addLink($widgetType, $widgetName, $link);
            }
        }
        $adb->pquery("DELETE FROM vtiger_settings_field WHERE `name` = ?",array('CTMobileSettings'));
        $rsBlock=$adb->pquery("SELECT blockid FROM `vtiger_settings_blocks` WHERE label='LBL_OTHER_SETTINGS'",array());
        $blockid=$adb->query_result($rsBlock, 0, 'blockid');
        $max_id=$adb->getUniqueID('vtiger_settings_field');
        $adb->pquery("INSERT INTO `vtiger_settings_field` (`fieldid`, `blockid`, `name`, `description`, `linkto`, `sequence`) VALUES (?, ?, ?, ?, ?, ?)",array($max_id,$blockid,'CTMobileSettings', 'CTMobileSettings', 'index.php?module=CTMobileSettings&parent=Settings&view=Details',$max_id));
    }
    /**
     * remove CTMobileSettings Widgets from CRM Settings > Other Settings
     * parameters None.
     * @return None
     */
    static function removeWidgetTo() {
        global $adb;
        $widgetType = 'HEADERSCRIPT';
        $widgetName = 'CTMobileSettingsJs';
        $link = 'layouts/vlayout/modules/CTMobileSettings/resources/CTMobileSettings.js';
        include_once 'vtlib/Vtiger/Module.php';

        $moduleNames = array('CTMobileSettings');
        foreach($moduleNames as $moduleName) {
            $module = Vtiger_Module::getInstance($moduleName);
            if($module) {
                $module->deleteLink($widgetType, $widgetName, $link);
            }
        }
        $adb->pquery("DELETE FROM vtiger_settings_field WHERE `name` = ?",array('CTMobileSettings'));
    }
    
}
