<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
class CTMobileSettings_SaveAPILogsSettings_Action extends Vtiger_Save_Action {
	public function process(Vtiger_Request $request) {
		global $adb;
		$mode = $request->get('mode');
		if($mode == 'removeLogs'){
            $query= $adb->pquery("TRUNCATE TABLE ctmobile_apilogs");
            $result = array('success' => true);
            $response = new Vtiger_Response();
            $response->setResult($result);
            $response->emit();
        }else if($mode == 'downloadLogs'){
            $headers = array("Sr No","Username","Request","Response");
            $excelData="";
            // Display column names as first row 
            $excelData = implode("\t", array_values($headers)) . "\n";
            $query = $adb->pquery("SELECT * FROM ctmobile_apilogs");
            $numofrows = $adb->num_rows($query);

            if($numofrows > 0){
                $entries = array();
                for($i=0;$i<$numofrows;$i++){
                    $srno = $i+1;
                    $row = $adb->query_result_rowdata($query,$i);
                    $UserName  = '';
                    if($row['userid'] != ''){
                        $userModel = Users_Record_Model::getInstanceById($row['userid'],'Users');
                        $UserName = decode_html(decode_html($userModel->get('first_name').' '.$userModel->get('last_name')));
                    }
                    $rowData = array($srno,$UserName,decode_html(decode_html($row['apirequest'])),decode_html(decode_html($row['apiresponse'])));
                    
                    $excelData .= implode("\t", array_values($rowData)) . "\n";
                }

                $fileName = 'APILogData.xls';
                // Headers for download 
                header("Content-Disposition: attachment; filename=\"$fileName\""); 
                header("Content-Type: application/vnd.ms-excel"); 
                // Render excel data 
                echo $excelData; 
                exit;
            }

        }else if($mode == 'checkLogData'){
            $query = $adb->pquery("SELECT * FROM ctmobile_apilogs");
            $numofrows = $adb->num_rows($query);
            $result = array('success' => $numofrows);
            $response = new Vtiger_Response();
            $response->setResult($result);
            $response->emit();

        }else if($mode == 'updateLogs'){
            $logvalue = $request->get('logvalue');
            $query = $adb->pquery("UPDATE ctmobile_user_settings SET user_setting_value=? WHERE user_setting_type=?", array($logvalue,'api_logs'));
            
        }
	}
}