<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

class CTMobileSettings_LoginHistory_View extends Settings_Vtiger_Index_View {

	function process(Vtiger_Request $request) {
		$viewer = $this->getViewer($request);
		$loginHistoryRecordModel = new  Settings_LoginHistory_Record_Model();
		$usersList = $loginHistoryRecordModel->getAccessibleUsers();
		$viewer->assign('USERSLIST',$usersList);
		
		$viewer->assign('SOURCE_MODULE', 'CTMobileSettings');
		$viewer->assign('QUALIFIED_MODULE', 'CTMobileSettings');
		$viewer->assign('MODULE', 'Settings:CTMobileSettings');
		$viewer->view('ListViewContents.tpl', $request->get('module'));
	}


	/**
	* Function to get the list of Script models to be included
	* @param Vtiger_Request $request
	* @return <Array> - List of Vtiger_JsScript_Model instances
	*/
    function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $jsFileNames = array(
            "modules.CTMobileSettings.resources.LoginHistory",
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }
}