<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Leads_Validate_Action extends Vtiger_BasicAjax_Action {

	public function process(Vtiger_Request $request) {
		global $current_user, $adb;
		$record = $request->get('record');
		$sourceModule = 'Leads';
		$response = new Vtiger_Response();
		// cf_751 = tipo doc
		// siccode = nro doc
		$recordModel = Vtiger_Record_Model::getInstanceById($record, $sourceModule);
		$data = $recordModel->getData();
		
		$query = "SELECT a.* FROM vtiger_accountscf a 
				INNER JOIN vtiger_crmentity e on a.accountid = e.crmid and e.deleted = 0 
				inner join vtiger_account aa on a.accountid = aa.accountid 
				WHERE trim(a.cf_751)=? AND trim(aa.siccode)=?";
		// $adb->setDebug(true);
		$rs = $adb->pquery($query, array(trim($data['cf_985']), trim($data['cf_987'])));
		// $adb->setDebug(false);
		$accountid = $adb->query_result($rs,0,'accountid');

		// var_dump($data);die();
		if(!empty($accountid) && intval($accountid) > 0) {
			$recordModel = Vtiger_Record_Model::getInstanceById($accountid, 'Accounts');
			$data = $recordModel->getData();
			$response->setResult(array('success'=>false, 'data'=>array_map('decode_html',$data)));
			// var_dump($response);
			// die();
		} else {
			$response->setResult(array('success'=>true, 'message'=> ''));
		}
		$response->emit();
	}
}
